/***************************************************************************
 *                                                                         *
 *     QUEST FOR MAGIC Version 3.0                                         *
 *                                                                         *
 *     Copyright (C) 1986-1992 GALACTICOMM, Inc.    All Rights Reserved.   *
 *                                                                         *
 ***************************************************************************
 * GALACTICOMM Software License Agreement                                  *
 *                                                                         *
 * GALACTICOMM, Inc., grants you a fully paid, perpetual, worldwide,       *
 * non-exclusive license to use, transfer, share, modify, delete, and      *
 * incorporate this Software into products copyrighted, patented,          *
 * subject to trade secret or other intellectual protection rights         *
 * asserted by you.                                                        *
 *                                                                         *
 * This Software is provided "as is", without warranty of any kind,        *
 * either expressed or implied, including, but not limited to, the implied *
 * warranties of merchantability and fitness for a particular purpose.     *
 *                                                                         *
 * This license is effective as long as this declaration is preserved in   *
 * its entirety in this Software and any copies or derivatives.            *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *     SIMPCMDS.C                                                          *
 *     Quest for Magic Player Simple Commands                              *
 *                                                                         *
 *     By - Tim Stryker and Scott Brinker      11/21/86                    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "qm.h"
#include "galqm.h"

void
approu(void)
{
     prfmsg(QMSIM100,playpt->altid,playpt->hisher);
     outothr();
     prfmsg(QMSIM101);
     outprf(usrnum);
}

void
gigrou(void)
{
     prfmsg(QMSIM102,playpt->altid);
     outothr();
     prfmsg(QMSIM103);
     outprf(usrnum);
}

void
jmprou(void)
{
     prfmsg(QMSIM104,playpt->altid);
     outothr();
     prfmsg(QMSIM105);
     outprf(usrnum);
}

void
lghrou(void)
{
     prfmsg(QMSIM106,playpt->altid);
     outothr();
     prfmsg(QMSIM107);
     outprf(usrnum);
}

void
shgrou(void)
{
     prfmsg(QMSIM108,playpt->altid,playpt->hisher);
     outothr();
     prfmsg(QMSIM109);
     outprf(usrnum);
}

void
lierou(void)
{
     prfmsg(QMSIM110,playpt->altid);
     outothr();
     prfmsg(QMSIM111);
     outprf(usrnum);
}

void
wherou(void)
{
     prfmsg(QMSIM112,playpt->altid);
     outothr();
     prfmsg(QMSIM113);
     outprf(usrnum);
}

void
sitrou(void)
{
     prfmsg(QMSIM114,playpt->altid);
     outothr();
     prfmsg(QMSIM115);
     outprf(usrnum);
}

void
grvrou(void)
{
     prfmsg(QMSIM116,playpt->altid,playpt->hisher);
     outothr();
     prfmsg(QMSIM117);
     outprf(usrnum);
}

void
snrrou(void)
{
     prfmsg(QMSIM118,playpt->altid);
     outothr();
     prfmsg(QMSIM119);
     outprf(usrnum);
}

void
cacrou(void)
{
     prfmsg(QMSIM120,playpt->altid);
     outothr();
     prfmsg(QMSIM121);
     outprf(usrnum);
}

void
swerou(void)
{
     if (margc == 1) {
          prfmsg(QMSIM122,playpt->altid,playpt->hisher);
          outothr();
          prfmsg(QMSIM123);
          outprf(usrnum);
     }
     else {
          qmsayrou();
     }
}

void
chorou(void)
{
     if (margc == 1) {
          prfmsg(QMSIM124,playpt->altid);
          outothr();
          prfmsg(QMSIM125);
          outprf(usrnum);
     }
     else {
          qmsayrou();
     }
}

void
begrou(void)
{
     if (margc == 1) {
          prfmsg(QMSIM126,playpt->altid);
          outothr();
          prfmsg(QMSIM127);
          outprf(usrnum);
     }
     else {
          qmsayrou();
     }
}

void
chrrou(void)
{
     if (margc == 1) {
          prfmsg(QMSIM128,playpt->altid);
          outothr();
          prfmsg(QMSIM129);
          outprf(usrnum);
     }
     else {
          qmsayrou();
     }
}

void
blurou(void)
{
     prfmsg(QMSIM130,playpt->altid);
     outothr();
     prfmsg(QMSIM131);
     outprf(usrnum);
}

void
gasrou(void)
{
     prfmsg(QMSIM132,playpt->altid);
     outothr();
     prfmsg(QMSIM133);
     outprf(usrnum);
}

void
cowrou(void)
{
     prfmsg(QMSIM134,playpt->altid);
     outothr();
     prfmsg(QMSIM135);
     outprf(usrnum);
}

void
bowrou(void)
{
     prfmsg(QMSIM136,playpt->altid);
     outothr();
     prfmsg(QMSIM137);
     outprf(usrnum);
}

void
smkrou(void)
{
     prfmsg(QMSIM138,playpt->altid,playpt->hisher);
     outothr();
     prfmsg(QMSIM139);
     outprf(usrnum);
}

void
chvrou(void)
{
     prfmsg(QMSIM140,playpt->altid);
     outothr();
     prfmsg(QMSIM141);
     outprf(usrnum);
}

void
boorou(void)
{
     prfmsg(QMSIM142,playpt->altid);
     outothr();
     prfmsg(QMSIM143);
     outprf(usrnum);
}

void
hisrou(void)
{
     prfmsg(QMSIM144,playpt->altid);
     outothr();
     prfmsg(QMSIM145);
     outprf(usrnum);
}

void
frnrou(void)
{
     prfmsg(QMSIM146,playpt->altid);
     outothr();
     prfmsg(QMSIM147);
     outprf(usrnum);
}

void
snlrou(void)
{
     if (margc == 1) {
          prfmsg(QMSIM148,playpt->altid);
          outothr();
          prfmsg(QMSIM149);
          outprf(usrnum);
     }
     else {
          qmsayrou();
     }
}

void
potrou(void)
{
     if (margc == 1) {
          prfmsg(QMSIM150,playpt->altid);
          outothr();
          prfmsg(QMSIM151);
          outprf(usrnum);
     }
     else {
          qmsayrou();
     }
}

void
grwrou(void)
{
     prfmsg(QMSIM152,playpt->altid);
     outothr();
     prfmsg(QMSIM153);
     outprf(usrnum);
}

void
grurou(void)
{
     prfmsg(QMSIM154,playpt->altid);
     outothr();
     prfmsg(QMSIM155);
     outprf(usrnum);
}

void
smlrou(void)
{
     prfmsg(QMSIM156,playpt->altid);
     outothr();
     prfmsg(QMSIM157);
     outprf(usrnum);
}

void
grnrou(void)
{
     prfmsg(QMSIM158,playpt->altid,playpt->hisher);
     outothr();
     prfmsg(QMSIM159);
     outprf(usrnum);
}

void
danrou(void)
{
     prfmsg(QMSIM160,playpt->altid);
     outothr();
     prfmsg(QMSIM161);
     outprf(usrnum);
}

void
sihrou(void)
{
     prfmsg(QMSIM162,playpt->altid);
     outothr();
     prfmsg(QMSIM163);
     outprf(usrnum);
}

void
sinrou(void)
{
     prfmsg(QMSIM164,playpt->altid);
     outothr();
     prfmsg(QMSIM165);
     outprf(usrnum);
}

void
snzrou(void)
{
     prfmsg(QMSIM166,playpt->altid);
     outothr();
     prfmsg(QMSIM167);
     outprf(usrnum);
}

void
whmrou(void)
{
     prfmsg(QMSIM168,playpt->altid);
     outothr();
     prfmsg(QMSIM169);
     outprf(usrnum);
}

void
smorou(void)
{
     prfmsg(QMSIM170,playpt->altid,playpt->hisher);
     outothr();
     prfmsg(QMSIM171);
     outprf(usrnum);
}

void
spirou(void)
{
     prfmsg(QMSIM172,playpt->altid);
     outothr();
     prfmsg(QMSIM173);
     outprf(usrnum);
}

void
snkrou(void)
{
     prfmsg(QMSIM174,playpt->altid,playpt->hisher);
     outothr();
     prfmsg(QMSIM175);
     outprf(usrnum);
}

void
gonrou(void)
{
     prfmsg(QMSIM176,playpt->altid);
     outothr();
     prfmsg(QMSIM177);
     outprf(usrnum);
}

void
monrou(void)
{
     if (margc == 1) {
          prfmsg(QMSIM178,playpt->altid);
          outothr();
          prfmsg(QMSIM179);
          outprf(usrnum);
     }
     else {
          qmsayrou();
     }
}

void
burrou(void)
{
     prfmsg(QMSIM180,playpt->altid);
     outothr();
     prfmsg(QMSIM181);
     outprf(usrnum);
}

void
farrou(void)
{
     prfmsg(QMSIM182,playpt->altid);
     outothr();
     prfmsg(QMSI1832);
     outprf(usrnum);
}

void
yawrou(void)
{
     prfmsg(QMSIM184,playpt->altid);
     outothr();
     prfmsg(QMSIM185);
     outprf(usrnum);
}

void
redeye(void)
{
     prfmsg(QMSIM186,playpt->altid);
     outothr();
     prfmsg(QMSIM187);
     outprf(usrnum);
}

void
nodrou(void)
{
     prfmsg(QMSIM188,playpt->altid);
     outothr();
     prfmsg(QMSIM189);
     outprf(usrnum);
}

void
fixrou(void)
{
     prfmsg(QMSIM190,playpt->altid);
     outothr();
     prfmsg(QMSIM191);
     outprf(usrnum);
}

void
gamrou(void)
{
     prfmsg(QMSIM192,playpt->altid);
     outothr();
     prfmsg(QMSIM193);
     outprf(usrnum);
}

void
trdrou(void)
{
     prfmsg(QMSIM194,playpt->altid);
     outothr();
     prfmsg(QMSIM195);
     outprf(usrnum);
}

void
clnrou(void)
{
     prfmsg(QMSIM196,playpt->altid);
     outothr();
     prfmsg(QMSIM197);
     outprf(usrnum);
}

void
prarou(void)
{
     prfmsg(QMSIM198,playpt->altid);
     outothr();
     prfmsg(QMSIM199);
     outprf(usrnum);
}

void
anyrou(void)
{
     prfmsg(QMSIM200,playpt->altid);
     outothr();
     prfmsg(QMSIM201);
     outprf(usrnum);
}

void
sicrou(void)
{
     prfmsg(QMSIM202,playpt->altid);
     outothr();
     prfmsg(QMSIM203);
     outprf(usrnum);
}

void
stmrou(void)
{
     prfmsg(QMSIM204,playpt->altid);
     outothr();
     prfmsg(QMSIM205);
     outprf(usrnum);
}

void
cryrou(void)
{
     if (margc == 1) {
          prfmsg(QMSIM206,playpt->altid);
          outothr();
          prfmsg(QMSIM207);
          outprf(usrnum);
     }
     else {
          yelrou();
     }
}

void
courou(void)
{
     prfmsg(QMSIM208,playpt->altid);
     outothr();
     prfmsg(QMSIM209);
     outprf(usrnum);
}

void
churou(void)
{
     prfmsg(QMSIM210,playpt->altid,playpt->hisher);
     outothr();
     prfmsg(QMSIM211);
     outprf(usrnum);
}

void
wisrou(void)
{
     prfmsg(QMSIM212,playpt->altid);
     outothr();
     prfmsg(QMSIM213);
     outprf(usrnum);
}

void
humrou(void)
{
     prfmsg(QMSIM214,playpt->altid);
     outothr();
     prfmsg(QMSIM215);
     outprf(usrnum);
}

void
blkrou(void)
{
     prfmsg(QMSIM216,playpt->altid,playpt->hisher);
     outothr();
     prfmsg(QMSIM217);
     outprf(usrnum);
}

void
snfrou(void)
{
     if (margc == 1) {
          prfmsg(QMSIM218,playpt->altid);
          outothr();
          prfmsg(QMSIM219);
          outprf(usrnum);
     }
     else {
          qmsayrou();
     }
}

void
snorou(void)
{
     prfmsg(QMSIM220,playpt->altid);
     outothr();
     prfmsg(QMSIM221);
     outprf(usrnum);
}

void
helrou(void)
{
     if (margc < 2) {
          prfmsg(HELP);
          outprf(usrnum);
     }
     else if (sameas(margv[1],"attack")) {
          prfmsg(ATTHLP);
          outprf(usrnum);
     }
     else if (sameas(margv[1],"commands")) {
          prfmsg(CMDHLP);
          outprf(usrnum);
     }
     else if (sameas(margv[1],"info")) {
          prfmsg(INFHLP);
          outprf(usrnum);
     }
     else if (sameas(margv[1],"player")) {
          prfmsg(PLYHLP);
          outprf(usrnum);
     }
     else if (sameas(margv[1],"spells")) {
          prfmsg(SPLHLP);
          outprf(usrnum);
     }
     else {
          prfmsg(HELP);
          outprf(usrnum);
     }
}

void
brfrou(void)
{
     playpt->flags|=BRIEF;
     prfmsg(QMSIM222);
     outprf(usrnum);
}

void
lonrou(void)
{
     playpt->flags&=~BRIEF;
     prfmsg(QMSIM223);
     outprf(usrnum);
}

void
hpts(void)
{
     prfmsg(QMSIM224,playpt->hits);
     prfmsg(QMSIM225,playpt->maxhit);
     outprf(usrnum);
     prfmsg(QMSIM226,playpt->altid,playpt->hisher);
     outothr();
}


