/***************************************************************************
 *                                                                         *
 *   SUBMNU.C                                                              *
 *                              Oct 06, 1988                               *
 *                    (C) Copyright 1988 by D. M. Arnel                    *
 *                                                                         *
 *   Courtesy of Logicom                                                   *
 *   (305) 581-0092 Voice                                                  *
 *   (305) 581-7097                                                        *
 *                                                                         *
 ***************************************************************************/

#include "stdio.h"
#include "ctype.h"
#include "majorbbs.h"
#include "portable.h"

int inismu(),dfsthn(),submnu();

#define SMUSTT       8        /* Sub-menu state                       */
struct module module08={      /* module interface block               */
     'G',                     /*    menu select character             */
     "GAMES",                 /*    description for menu              */
     inismu,                  /*    system initialization routine     */
     NULL,                    /*    user logon supplemental routine   */
     submnu,                  /*    input routine if selected         */
     dfsthn,                  /*    status-input routine if selected  */
     NULL,                    /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     NULL,                    /*    delete-account routine            */
     NULL                     /*    finish-up (sys shutdown) routine  */
};

static
char select[NMODS];

extern
struct module *module[NMODS]; /* module access block pointer table         */



inismu()
{
     int setupm(),mnudiv();

     module[0]->sttrou=mnudiv;
     rtkick(1,setupm);
}

mnudiv()                      /* Divert user to proper menu                */
{
     if (submod()) {
          return(submnu());
     }
     return(mainu());
}

submod()
{
     int i;

     for (i=0 ; i < NMODS ; i++) {
          if (select[usrptr->state] != '\0') {
               return(1);
          }
     }
     return(0);
}

submnu()
{
     int i,c;

     switch (usrptr->substt) {
     case 0:
          fmenu();
          usrptr->substt=1;
          break;
     default:
          if (margc == 0) {
               smenu();
          }
          else if ((c=margv[0][0]) == '?') {
               fmenu();
          }
          else if (tolower(c) == 'x') {
               usrptr->substt=0;
               return(mainu());
          }
          else {
               for (i=1 ; i < NMODS ; i++) {
                    if (tolower(c) == tolower(select[i])) {
                         usrptr->state=i;
                         usrptr->substt=0;
                         setmem(vdarea+(usrnum*(long)vdasiz),vdasiz,0);
                         return((*(module[i]->sttrou))());
                    }
               }
               prf("\rThe option you have chosen, \"%c\", is not available!\r",c);
               smenu();
          }
          break;
     }
     outprf(usrnum);
     usrptr->state=SMUSTT;
     return(1);
}

smenu()                            /* generate and display short menu      */
{
     int i,c;

     prf("\rSelect an option (");

     for (i=1 ; i < NMODS ; i++) {
          if ((c=select[i]) != '\0') {
               prf("%c,",c);
          }
     }
     prf("X, or ? for menu): ");
}

fmenu()                            /* generate and display full menu       */
{
     int i,c;

     prf("\r%s\r\r",module[SMUSTT]->descrp);
     for (i=1 ; i < NMODS ; i++) {
          if ((c=select[i]) != '\0') {
               prf(" %c) %s\r",c,module[i]->descrp);
          }
     }
     prf("\rSelect one of the above options: ");
}

setupm()
{
     int i,none=1;

     setmem(select,sizeof(select),0);
     for (i=1 ; i < NMODS ; i++) {
          if (i != SMUSTT
           && module[i]->select != '\0' && module[i]->descrp[0] == '/') {
               select[i]=module[i]->select;
               module[i]->select='\0';
               movmem(&module[i]->descrp[1],module[i]->descrp,strlen(module[i]->descrp));
               none=0;
          }
     }
     if (none) {
          module[SMUSTT]->select='\0';
     }
}

                                                                                    