/***************************************************************************
 *                                                                         *
 *   GALDCTX.C                                                             *
 *                                                                         *
 *   Copyright (C) 1994 GALACTICOMM, Inc.    All Rights Reserved.          *
 *                                                                         *
 *   Contact Database, Full Screen Data Entry example                      *
 *                                                                         *
 *                                             - R. Stein  12/15/93        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "fsdbbs.h"
#include "galctx.h"

STATIC int ctxinp(void);
STATIC void ctxsts(void);
STATIC void ctxprp(int msgno,int amode);
STATIC void ctxdun(int save);
STATIC void ctxfin(void);

int ctxstt;                        /* Contact DB module state number       */
static FILE *ctxmb;                /* file pointer for GALCTX.MCV          */
BTVFILE *ctxbb;                    /* Btrieve pointer for GALCTX.DAT       */

struct module ctxmodule={          /* module interface block               */
     "",                           /*    name used to refer to this module */
     NULL,                         /*    user logon supplemental routine   */
     ctxinp,                       /*    input routine if selected         */
     ctxsts,                       /*    status-input routine if selected  */
     NULL,                         /*    "injoth" routine for this module  */
     NULL,                         /*    user logoff supplemental routine  */
     NULL,                         /*    hangup (lost carrier) routine     */
     NULL,                         /*    midnight cleanup routine          */
     NULL,                         /*    delete-account routine            */
     ctxfin                        /*    finish-up (sys shutdown) routine  */
};

struct contct {                         /* Contact Database structure      */
     char userid[UIDSIZ];               /* User-ID                         */
     char nam[UIDSIZ];                  /* name                            */
     char pho[UIDSIZ];                  /* voice phone                     */
     char fax[UIDSIZ];                  /* fax                             */
     char net[UIDSIZ];                  /* internet address                */
};

#define ctxbuf ((struct contct *)ctxbb->data)

#define UIDFLD 0                        /* Contact DB field indexes        */
#define NAMFLD 1
#define PHOFLD 2
#define FAXFLD 3
#define INTFLD 4
#define XITFLD 5

static char ctxfmt[]=                   /* Contact DB answer string format */
     "USERID=%s%c"
     "NAME=%s%c"
     "PHONE=%s%c"
     "FAX=%s%c"
     "INTERNET=%s%c";

static char ctxfsp[]=                   /* Contact DB field specifications */
     "USERID(MIN=3) "
     "NAME(MIN=5) "
     "PHONE "
     "FAX "
     "INTERNET "
     "DONE(ALT=SAVE ALT=QUIT ALT=EDIT MULTICHOICE)";

void EXPORT
init__contactdb(void)                   /* Contact DB initialization       */
{
     stzcpy(ctxmodule.descrp,gmdnam("GALCTX.MDF"),MNMSIZ);
     ctxstt=register_module(&ctxmodule);
     ctxmb=opnmsg("GALCTX.MCV");
     ctxbb=opnbtv("GALCTX.DAT",sizeof(struct contct));
     dclvda(fsdroom(CTXDISP,ctxfsp,0));
     dclvda(fsdroom(CTXFULL,ctxfsp,0));
     dclvda(fsdroom(CTXLINE,ctxfsp,-1));
}

STATIC int
ctxinp(void)                            /* Contact DB input handler        */
{
     char *uid,*cp,title[80];
     int rc;

     setmbk(ctxmb);
     setbtv(ctxbb);
     if (margc == 1 && sameas(margv[0],"X")) {
          clrxrf();
          return(0);
     }
     if (usrptr->flags&ABOIP) {
          btuclo(usrnum);
     }
     do {
          bgncnc();
          switch (usrptr->substt) {
          case 0:
               cncchr();
               prfmsg(usrptr->substt=WHOCON);
               break;
          case WHOCON:
          case ANOTHER:
               if (usrptr->flags&INJOIP) {
                    prfmsg(WHOCON);
                    break;
               }
               if (*(uid=cncall()) == '\0' || sameas(uid,".")) {
                    if (!acqbtv(NULL,usaptr->userid,0)) {
                         setmem(ctxbuf,sizeof(*ctxbuf),0);
                         strcpy(ctxbuf->userid,usaptr->userid);
                    }
                    if (usaptr->ansifl&ANSON
                     && usaptr->scnfse >= 23
                     && usaptr->scnwid >= 80) {
                         ctxprp(CTXFULL,1);
                         stpans(cp=getmsg(CTXTTL));
                         stzcpy(title,cp,80);
                         fsdrhd(title);
                         fsdbkg(fsdrft());
                         fsdscb->flddat[UIDFLD].flags|=FFFAVD;
                         fsdego(vfyadn,ctxdun);   /* Begin full-screen entry */
                    }
                    else {
                         ctxprp(CTXDISP,-1);
                         fsddsp(fsdrft());        /* Display all information */
                         prfmsg(usrptr->substt=CTXLASK);
                    }                             /* Ask before linear entry */
               }
               else if ((rc=hdluid(uid)) != UIDFND) {
                    if (rc == UIDPMT) {
                         prfmsg(WHOCON);
                    }
               }
               else if (!acqbtv(NULL,uidxrf.userid,0)) {
                    prfmsg(NOTGOT);
                    prfmsg(ANOTHER);
               }
               else {
                    ctxprp(CTXDISP,-1);
                    fsddsp(fsdrft());
                    condex();
                    prfmsg(usrptr->substt=ANOTHER);
               }
               break;
          case CTXLASK:
               switch(cncyesno()) {
               case 'Y':
                    prfmsg(usrptr->substt=CTXHELP);
                    btuoes(usrnum,1);             /* Buffer must be empty    */
                    break;                        /* before linear entry     */
               case '\0':
                    if (usrptr->flags&INJOIP) {
                         prfmsg(CTXLASK);
                         break;
                    }
               case 'N':
                    condex();
                    prfmsg(usrptr->substt=ANOTHER);
                    break;
               default:
                    prfmsg(CTXLASK);
                    break;
               }
               break;
          }
     } while (!endcnc());
     outprf(usrnum);
     return(1);
}

STATIC void
ctxsts(void)                            /* Contact DB status code handler  */
{
     if (status == OUTMT && usrptr->substt == CTXHELP) {
          btuoes(usrnum,0);
          setmbk(ctxmb);
          setbtv(ctxbb);
          ctxprp(CTXLINE,0);
          fsdrft();
          fsdscb->flddat[UIDFLD].flags|=FFFAVD;
          fsdego(vfyadn,ctxdun);                  /* Begin linear entry    */
          outprf(usrnum);
     }
     else {
          dfsthn();
     }
}

STATIC void
ctxprp(                                 /* prepare for Contact DB editing  */
int msgno,                              /* answer template                 */
int amode)                              /* 1=full-scn, 0=linear -1=display */
{
     fsdroom(msgno,ctxfsp,amode);
     sprintf(vdatmp,ctxfmt,ctxbuf->userid,'\0',
                           ctxbuf->nam,'\0',
                           ctxbuf->pho,'\0',
                           ctxbuf->fax,'\0',
                           ctxbuf->net,'\0');
     fsdapr(vdaptr,vdasiz,vdatmp);
}

STATIC void
ctxdun(                                 /* When-done routine               */
int save)                               /* 1=save, 0=quit                  */
{
     int already;

     setmbk(ctxmb);
     setbtv(ctxbb);
     if (fsdscb->chgcnt == 0) {
          prfmsg(CTXNOCH);                        /* Done, no changes      */
     }
     else if (!save) {
          prfmsg(CTXQIT);                         /* Done, discard changes */
     }
     else {
          already=acqbtv(NULL,fsdnan(UIDFLD),0);
          fsdfxt(UIDFLD,ctxbuf->userid,UIDSIZ);
          fsdfxt(NAMFLD,ctxbuf->nam,UIDSIZ);
          fsdfxt(PHOFLD,ctxbuf->pho,UIDSIZ);
          fsdfxt(FAXFLD,ctxbuf->fax,UIDSIZ);
          fsdfxt(INTFLD,ctxbuf->net,UIDSIZ);
          already ? updbtv(NULL) : insbtv(NULL);
          prfmsg(CTXSAV);                         /* Done, changes saved   */
     }
     usrptr->state=ctxstt;
     condex();
     prfmsg(usrptr->substt=ANOTHER);
}

STATIC void
ctxfin(void)                            /* Contact DB shutdown             */
{
     clsmsg(ctxmb);
}
