/***************************************************************************
 *                                                                         *
 *   FLASH.C                                                               *
 *                                                                         *
 *   Copyright (C) 1988-1991 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   This is The Major BBS remote-program interface, designed for use      *
 *   as an adjunct to the teleconference.                                  *
 *                                                                         *
 *                                            - T. Stryker 5/26/89         *
 *                                                                         *
 ***************************************************************************/

#include "stdio.h"
#include "ctype.h"
#include "dosface.h"
#include "majorbbs.h"
#include "usracc.h"
#include "flash.h"
#include "portable.h"
#include "enttlc.h"
#include "btvstf.h"

struct pool *pools,*piptr,*pbptr;

struct fapyr *fapyrs,*fiptr,*fbptr;

#define NAK      21
#define CAN      24
#define NAKACK  120
#define REMOVE  121
#define TICK    122
#define LINEUP  127

#define fptr ((struct fapyr *)vdaptr)

char *nxpack(),*napack();

BTVFILE *flbb;

struct flrec {
     char uidgam[20];
     char spare[20];
} *flrec;

extern
char bturno[];

static
int nlvflh,                   /* non-live flashing allowed?                */
    flhres,                   /* flashing restricted by time-of-day?       */
    flhstm,                   /* if flhres, starting time flash allowed    */
    flhdur;                   /* if flhres, duration flash allowed         */

static
int fnterms;                  /* flash-local copy of nterms (in case HUGE) */

inifla()
{
     int n,flarti();

     pools=(struct pool *)alcmem(n=NPOOLS*sizeof(struct pool));
     setmem(pools,n,0);
     fapyrs=(struct fapyr *)alcmem(n=nterms*sizeof(struct fapyr));
     setmem(fapyrs,n,0);
     flbb=opnbtv("flashmen.dat",sizeof(struct flrec));
     flrec=(struct flrec *)alcmem(n=sizeof(struct flrec));
     setmem(flrec,n,0);
     bturti(TPERSC,flarti);
     nlvflh=ynopt(NLVFLH);
     flhres=ynopt(FLHRES);
     flhstm=numopt(FLHSTM,0,23);
     flhdur=numopt(FLHDUR,1,23);
     fnterms=nterms;
}

ck4fla()
{
     int i,j,avlchn,hr;
     static char *cmsg[]={
          "/","Flash","Protocol","Copyright","1989","Galacticomm,","Inc."
     };

     if (margc != 3+sizeof(cmsg)/sizeof(char *)) {
          return(0);
     }
     if (strcmp(margv[0],"Flash") != 0) {
          return(0);
     }
     if (*(margv[3]) == '#' && *(margv[3]+1) == '9' && strlen(margv[3]) > 9) {
          if (!(sameas(margv[3]+2,bturno))) {
               prfmsg(WRGBBS,margv[2]);
               shocst(1,"FLASH: Bad Ser.%s",margv[3]);
               outprf(usrnum);
               return(0);
          }
          setmem(flrec->uidgam,sizeof(struct flrec),0);
          strcpy(flrec->uidgam,usaptr->userid);
          strncat(flrec->uidgam,margv[1],9);
          strlwr(flrec->uidgam);
          setbtv(flbb);
          if (!qeqbtv(flrec->uidgam,0)) {
               prfmsg(GETFSH,margv[1]);
               shocst(1,"FLASH: Bad User %s",usaptr->userid);
               outprf(usrnum);
               return(0);
          }
     }
     else {
          for (i=margc-1 ; i >= 3 ; i--) {
               if (strcmp(margv[i],cmsg[i-3]) != 0) {
                    if (i == 3 && *margv[3] == '#') {
                         for (j=0 ; j < nterms ; j++) {
                              if (user[j].state == usrptr->state
                               && user[j].substt == FLHING
                               && sameas(fapyrs[j].poolpt->gamnam,margv[1])
                               && sameas(fapyrs[j].poolpt->gamver,margv[2])
                               && fapyrs[j].serno == atol(margv[3]+1)) {
                                   prfmsg(DUPSER,margv[1]);
                                   outprf(usrnum);
                                   return(1);
                              }
                         }
                    }
                    else {
                         return(0);
                    }
               }
          }
     }
     if (!nlvflh && usrptr->class <= FRELOA) {
          prfmsg(MBL4F);
          howbuy();
          outprf(usrnum);
          return(1);
     }
     telext();
     if (flhres) {
          hr=dthour(now());
          if (flhstm+flhdur <= 24) {
               if (hr < flhstm || hr > flhstm+flhdur-1) {
                    prfmsg(NFNOW,flhstm);
                    outprf(usrnum);
                    return(1);
               }
          }
          else {
               if (hr < flhstm && hr >= flhstm+flhdur-24) {
                    prfmsg(NFNOW,flhstm);
                    outprf(usrnum);
                    return(1);
               }
          }
     }
     avlchn=-1;
     for (i=0,pbptr=pools ; i < NPOOLS ; i++,pbptr++) {
          if (pbptr->nchans == 0) {
               avlchn=i;
          }
          else if (pbptr->tlcchn == tlcptr->channel) {
               if (strcmp(margv[1],pbptr->gamnam) == 0) {
                    if (strcmp(margv[2],pbptr->gamver) == 0) {
                         if (pbptr->nchans < SHPERP
                           || (*margv[3] == '#' && pbptr->nchans < CHPERP)) {
                              gofchi();
                         }
                         else {
                              prfmsg(T2MANY);
                         }
                    }
                    else {
                         prfmsg(WRGVER,pbptr->gamver,pbptr->gamnam,margv[2]);
                    }
               }
               else {
                    prfmsg(WRGGAM,pbptr->gamnam,pbptr->gamver,margv[1]);
               }
               outprf(usrnum);
               return(1);
          }
     }
     if (avlchn < 0) {
          prfmsg(NEPOOL,NPOOLS);
          outprf(usrnum);
     }
     else {
          pbptr=&pools[avlchn];
          pbptr->tlcchn=tlcptr->channel;
          strncpy(pbptr->gamnam,margv[1],GNSIZE);
          strncpy(pbptr->gamver,margv[2],GVSIZE);
          pbptr->nxtbyt=0;
          gofchi();
     }
     return(1);
}

gofchi()
{
     int i,flachi();
     char *astuid(),*nxpstg;

     fbptr=&fapyrs[usrnum];
     fbptr->chno=usrnum;
     fbptr->cancnt=0;
     fbptr->poolpt=pbptr;
     fbptr->oneten=pbptr->nchans;
     btuclo(usrnum);
     btupmt(usrnum,0);
     btuxnf(usrnum,0,0);
     prf("%c",LINEUP);
     for (i=0 ; i < pbptr->nchans ; i++) {
          prf("%s ",astuid(pbptr->faps[i]->chno));
     }
     if ((fbptr->serno=atol(margv[3]+1)) == 0) {
          prf("%s %u%c",astuid(usrnum),now(),LINEUP);
     }
     else if (*(margv[3]+1) == '9') {
          prf("%s %u %c%s%c",astuid(usrnum),now(),'#',bturno,LINEUP);
     }
     else {
          prf("%s %u %s%c",astuid(usrnum),now(),margv[3],LINEUP);
     }
     pbptr->faps[pbptr->nchans]=fbptr;

     dsairp();
     fbptr->nxxbyt=fbptr->bytoff=pbptr->nxtbyt;
     pbptr->nchans++;
     chiout(usrnum,'\0');
     chiout(usrnum,'\0');
     chiout(usrnum,'\0');
     chiout(usrnum,'\0');
     chiout(usrnum,'\0');
     chiout(usrnum,'\0');
     for (prfptr=prfbuf ; *prfptr != '\0' ; prfptr++) {
          pbptr->pdata[pbptr->nxtbyt]=*prfptr;
          pbptr->nxtbyt=((pbptr->nxtbyt+1)&PDMASK);
     }
     piptr=pbptr;
     fiptr=fbptr;
     nxpstg=nxpack();
     fbptr->fflags=FLASHY;
     for (i=0 ; i < piptr->nchans ; i++) {
          fiptr=piptr->faps[i];
          if (!(fiptr->fflags&XMTING)) {
               chious(fiptr->chno,nxpstg);
               fiptr->nxxbyt=fbptr->nxxbyt;
               fiptr->fflags|=XMTING;
          }
     }
     btuchi(usrnum,flachi);
     btuech(usrnum,0);
     btuche(usrnum,1);
     enairp();

     usrptr->substt=FLHING;
     usrptr->flags|=NOINJO;
     clrprf();
     prfmsg(USGONE,usaptr->userid,pbptr->gamnam);
     outtlc();
     prf("");
}

char *
astuid(chno)
int chno;
{
     static char astbuf[UIDSIZ+1];

     sprintf(astbuf,"*%s",usracc[chno].userid);
     return(astbuf+(tlclst[chno].prvchn != tlcptr->channel));
}

lvpool()
{
     int i;
     char *nxpstg;

     dsairp();
     fiptr=&fapyrs[usrnum];
     piptr=fiptr->poolpt;
     fiptr->fflags=0;
     piptr->pdata[piptr->nxtbyt]=REMOVE;
     piptr->nxtbyt=((piptr->nxtbyt+1)&PDMASK);
     piptr->pdata[piptr->nxtbyt]=fiptr->oneten+'0';
     piptr->nxtbyt=((piptr->nxtbyt+1)&PDMASK);
     if (--(piptr->nchans) > fiptr->oneten) {
          fbptr=piptr->faps[piptr->nchans];
          piptr->faps[fiptr->oneten]=fbptr;
          fbptr->oneten=fiptr->oneten;
     }
     for (i=0 ; i < piptr->nchans ; i++) {
          fiptr=piptr->faps[i];
          if (!(fiptr->fflags&XMTING)) {
               chious(fiptr->chno,nxpstg=nxpack());
               fiptr->fflags|=XMTING;
               for (i++ ; i < piptr->nchans ; i++) {
                    fiptr=piptr->faps[i];
                    if (!(fiptr->fflags&XMTING)) {
                         chious(fiptr->chno,nxpstg);
                         fiptr->nxxbyt=piptr->nxtbyt;
                         fiptr->fflags|=XMTING;
                    }
               }
               break;
          }
     }
     btuchi(usrnum,NULL);
     btuche(usrnum,0);
     enairp();
     echon();
     btuxnf(usrnum,0,19);
     usrptr->flags&=~NOINJO;
}

flachi(chan,c)
int chan,c;
{
     register int i;
     char *nxpstg;

     fiptr=&fapyrs[chan];
     piptr=fiptr->poolpt;
     if (c == -1) {
          if (fiptr->nxxbyt != piptr->nxtbyt) {
               chious(chan,nxpack());
          }
          else {
               fiptr->fflags&=~XMTING;
          }
     }
     else if (fiptr->fflags&NAKLST) {
          fiptr->nxxbyt=((((c&127)<<2)+fiptr->bytoff)&PDMASK);
          chious(chan,napack(c));
          fiptr->fflags&=~NAKLST;
          fiptr->fflags|=XMTING;
     }
     else if ((c&127) == CAN) {
          if (++(fiptr->cancnt) == 3) {
               chiinj(chan,STPFLA);
          }
     }
     else if (c == odd(c)) {
          c&=127;
          if (c == NAK) {
               fiptr->fflags|=NAKLST;
          }
          else {
               fiptr->cancnt=0;
               if (c < 11) {
                    piptr->pdata[piptr->nxtbyt]=c*10+fiptr->oneten;
               }
               else {
                    piptr->pdata[piptr->nxtbyt]=110+fiptr->oneten;
                    piptr->nxtbyt=((piptr->nxtbyt+1)&PDMASK);
                    piptr->pdata[piptr->nxtbyt]=c;
               }
               piptr->nxtbyt=((piptr->nxtbyt+1)&PDMASK);
               for (i=0 ; i < piptr->nchans ; i++) {
                    fiptr=piptr->faps[i];
                    if (!(fiptr->fflags&XMTING)) {
                         chious(fiptr->chno,nxpstg=nxpack());
                         fiptr->fflags|=XMTING;
                         for (i++ ; i < piptr->nchans ; i++) {
                              fiptr=piptr->faps[i];
                              if (!(fiptr->fflags&XMTING)) {
                                   chious(fiptr->chno,nxpstg);
                                   fiptr->nxxbyt=piptr->nxtbyt;
                                   fiptr->fflags|=XMTING;
                              }
                         }
                         break;
                    }
               }
          }
     }
     return(0);
}

char *
nxpack()
{
     static char pakbuf[18];
     char *pkp;
     int crc,i;

     pkp=pakbuf+1;
     crc=0;
     i=0;
     do {
          crc=calcrc(crc,*pkp++=odd(piptr->pdata[fiptr->nxxbyt]));
          fiptr->nxxbyt=((fiptr->nxxbyt+1)&PDMASK);
     } while (++i < 15 && fiptr->nxxbyt != piptr->nxtbyt);
     pakbuf[0]=0x80^odd(((crc>>3)&0x70)+i);
     *pkp++=odd(crc&0x7F);
     *pkp++='\0';
     return(pakbuf);
}

char *
napack(c)
char c;
{
     static char pakbuf[18];
     char *pkp;
     int crc,i;

     crc=calcrc(0,pakbuf[1]=odd(NAKACK));
     crc=calcrc(crc,pakbuf[2]=odd(c));
     pkp=pakbuf+3;
     i=1;
     while (++i < 15 && fiptr->nxxbyt != piptr->nxtbyt) {
          crc=calcrc(crc,*pkp++=odd(piptr->pdata[fiptr->nxxbyt]));
          fiptr->nxxbyt=((fiptr->nxxbyt+1)&PDMASK);
     }
     pakbuf[0]=0x80^odd(((crc>>3)&0x70)+i);
     *pkp++=odd(crc&0x7F);
     *pkp++='\0';
     return(pakbuf);
}

/* The following section will compile under both Microsoft C and Turbo C    */
/* just fine.  However, for better performance, you may wish to comment out */
/* the following C source, and un-comment out the assembly source following */
/* it.  If you do this, and you have TASM.EXE in your Turbo C subdirectory  */
/* then everything should compile fine.  Otherwise, if you have MASM,       */
/* together with some version of Turbo C, you may ignore the error message  */
/* returned by the compiler and assemble the resulting FLASH.ASM file by    */
/* typing "MASM FLASH;" at the DOS prompt.                                  */

flarti()
{
     static char *tckstg={"qz]"};
     int i;

     for (i=0,piptr=pools ; i < NPOOLS ; i++,piptr++) {
          if (piptr->nchans > 0) {
               piptr->pdata[piptr->nxtbyt]=TICK;
               piptr->nxtbyt=((piptr->nxtbyt+1)&PDMASK);
          }
     }
     for (i=0,fiptr=fapyrs ; i < fnterms ; i++,fiptr++) {
          if ((fiptr->fflags&(FLASHY+XMTING)) == FLASHY) {
               chious(i,tckstg);
               fiptr->nxxbyt=((fiptr->nxxbyt+1)&PDMASK);
               fiptr->fflags|=XMTING;
          }
     }

/*
#pragma inline

asm       mov  cx,NPOOLS
asm       les  si,dword ptr pools
    pool:
asm       cmp  word ptr es:[si].nchans,0
asm       je   notk
asm       lea  di,[si].pdata
asm       add  di,es:[si].nxtbyt
asm       mov  byte ptr es:[di],TICK
asm       inc  word ptr es:[si].nxtbyt
asm       and  word ptr es:[si].nxtbyt,PDMASK
    notk:
asm       add  si,.pdata+PDSIZE
asm       loop pool
asm       mov  di,0
asm       les  si,dword ptr fapyrs
    pyrs:
asm       mov  ax,es:[si].fflags
asm       and  ax,FLASHY+XMTING
asm       cmp  ax,FLASHY
asm       jne  noxm
asm       push tckstg+2
asm       push tckstg
asm       push di
asm       call far ptr _chious
asm       add  sp,6
asm       inc  word ptr es:[si].nxxbyt
asm       and  word ptr es:[si].nxxbyt,PDMASK
asm       or   word ptr es:[si].fflags,XMTING
    noxm:
asm       add  si,.fflags+2
asm       inc  di
asm       cmp  di,fnterms
asm       jl   pyrs
*/
}
