/***************************************************************************
 *                                                                         *
 *     QUEST FOR MAGIC Version 3.0                                         *
 *                                                                         *
 *     Copyright (C) 1986-1992 GALACTICOMM, Inc.    All Rights Reserved.   *
 *                                                                         *
 ***************************************************************************
 * GALACTICOMM Software License Agreement                                  *
 *                                                                         *
 * GALACTICOMM, Inc., grants you a fully paid, perpetual, worldwide,       *
 * non-exclusive license to use, transfer, share, modify, delete, and      *
 * incorporate this Software into products copyrighted, patented,          *
 * subject to trade secret or other intellectual protection rights         *
 * asserted by you.                                                        *
 *                                                                         *
 * This Software is provided "as is", without warranty of any kind,        *
 * either expressed or implied, including, but not limited to, the implied *
 * warranties of merchantability and fitness for a particular purpose.     *
 *                                                                         *
 * This license is effective as long as this declaration is preserved in   *
 * its entirety in this Software and any copies or derivatives.            *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *     QMUTL.C                                                             *
 *     Quest for Magic Game Handler Utilities                              *
 *                                                                         *
 *     By - Tim Stryker and Scott Brinker      11/18/86                    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galqm.h"
#include "qm.h"

static
int nrooms;                   /* scratch vbl for use by qmoutnear & outfar   */
static
struct room *rooms[17];       /* scratch array for use by qmoutnear & outfar */
static
struct qmplayer *pspp;          /* scratch vbl used by inpsee & nxpsee       */

void outlist(struct room *roompt);

void
outothr(void)                           /* send prf to all others in room  */
{
     struct qmplayer *pp;

     for (pp=playpt->room->roomhdr ; pp != NULL ; pp=pp->plink) {
          if (pp != playpt) {
               outprf(pp->channel);
          }
     }
     clrprf();
}

void
outowfs(playpt,auraf)                   /*  send prf to others/with flags  */
struct qmplayer *playpt;
long auraf;
{
     struct qmplayer *pp;

     for (pp=playpt->room->roomhdr ; pp != NULL ; pp=pp->plink) {
          if (pp != playpt && (pp->aura&auraf)) {
               outprf(pp->channel);
          }
     }
     clrprf();
}

void
outevbt(doplyr)                         /*  send prf w/ two exceptions     */
struct qmplayer *doplyr;
{
     struct qmplayer *pp;

     for (pp=playpt->room->roomhdr ; pp != NULL ; pp=pp->plink) {
          if (pp != playpt && pp != doplyr) {
               outprf(pp->channel);
          }
     }
     clrprf();
}

void
qmoutroom(rmptr)                          /*  send prf to all in a room      */
struct room *rmptr;
{
     struct qmplayer *pp;

     for (pp=rmptr->roomhdr ; pp != NULL ; pp=pp->plink) {
          outprf(pp->channel);
     }
     clrprf();
}

void
qmoutall(void)                            /*  send prf to all on game        */
{
     int i;
     struct qmplayer *pp;

     for (i=0,pp=qmplayer ; i < nterms ; i++,pp++) {
          if (pp->flags&INQM) {
               outprf(pp->channel);
          }
     }
     clrprf();
}

void
qmoutnear(void)                           /*  send prf to nearby rooms       */
{
     nrooms=1;
     rooms[0]=playpt->room;
     outnsew(playpt->room);
}

void
outfar(void)                            /*  send prf to far rooms          */
{                                       /* must call qmoutnear before this!! */
     outnsew(&qmrooms[playpt->room->inorth]);
     outnsew(&qmrooms[playpt->room->isouth]);
     outnsew(&qmrooms[playpt->room->ieast]);
     outnsew(&qmrooms[playpt->room->iwest]);
}

void
outnsew(plyroom)                        /* qmoutnear/outfar utility          */
struct room *plyroom;
{
     if (plyroom != NOROOM) {
          outlist(&qmrooms[plyroom->inorth]);
          outlist(&qmrooms[plyroom->isouth]);
          outlist(&qmrooms[plyroom->ieast]);
          outlist(&qmrooms[plyroom->iwest]);
     }
}

void
outlist(roompt)                  /* qmoutnear/outfar utility          */
struct room *roompt;
{
     struct room **rmptpt;
     int i;

     if (roompt != NOROOM) {
          for (i=0,rmptpt=rooms ; i < nrooms ; i++,rmptpt++) {
               if (roompt == *rmptpt) {
                    return;
               }
          }
          *rmptpt=roompt;
          nrooms++;
          qmoutroom(roompt);
     }
}

long
seeflg(invflg)
long invflg;
{
     long retval;

     if (invflg&INVIS3) {
          retval=0L;
     }
     else if (invflg&INVIS2) {
          retval=SEEIN2;
     }
     else if (invflg&INVIS1) {
          retval=SEEIN1|SEEIN2;
     }
     else  {
          retval=SEEPYR;
     }
     return(retval);
}

void
qmxitroom(pp,xitdesc)                     /*  exit room function             */
struct qmplayer *pp;
char *xitdesc;
{
     struct qmplayer **pyptpt;

     prf("***\r%s has just %s!\r",pp->plyrid,xitdesc);
     outowfs(pp,seeflg(pp->aura));
     for (pyptpt=&(pp->room->roomhdr) ; *pyptpt != pp ; ) {
          pyptpt=&((*pyptpt)->plink);
     }
     *pyptpt=pp->plink;
}

void
qmentroom(pp,destrm,entdesc)            /*  enter room function            */
struct qmplayer *pp;
struct room *destrm;
char *entdesc;
{
     pp->plink=destrm->roomhdr;
     destrm->roomhdr=pp;
     pp->room=destrm;
     prf("***\r%s has just %s!\r",pp->plyrid,entdesc);
     outowfs(pp,seeflg(pp->aura));
     if (pp->flags&BRIEF) {
          prfmsg(QMUTL102,(char *)(pp->room->brdesc));
     }
     else {
          prfmsg(pp->room->desc);
     }
     seeitms(pp);
     seepyrs(pp);
     outprf(pp->channel);
}

void
seeitms(pp)                             /*  see items in room function     */
struct qmplayer *pp;
{
     char *pprobl;
     char *iitems;
     char *anitno();
     int nitms,i;

     if (pp->aura&SEEOBJ) {
          pprobl=(char *)(pp->room->objloc);
          iitems=pp->room->iitems;
          switch (nitms=pp->room->nitems) {
          case 0:
               prfmsg(QMUTL103,pprobl);
               break;
          case 1:
               prfmsg(QMUTL104,anitno(iitems[0]),pprobl);
               break;
          case 2:
               prfmsg(QMUTL105,anitno(iitems[0]));
               prfmsg(QMUTL106,anitno(iitems[1]),pprobl);
               break;
          default:
               prfmsg(QMUTL107);
               for (i=0 ; i < nitms-1 ; i++) {
                    prfmsg(QMUTL108,anitno(iitems[i]));
               }
               prfmsg(QMUTL109,anitno(iitems[nitms-1]),pprobl);
          }
     }
}

char *
anitno(itmno)                        /* a/an and item name by item number  */
int itmno;
{
     char *anitmn();

     return(anitmn(&qmitems[itmno]));
}

void
invrou(void)                            /*  see items in room function     */
{
     prfmsg(QMUTL110);
     invutl(playpt);
     outprf(usrnum);
     if (playpt->flags&INQM) {
          prfmsg(QMUTL111,playpt->altid);
          outowfs(playpt,SEEPYR);
     }
}

void
invutl(ppt)
struct qmplayer *ppt;
{
     struct item **items;
     char *anitmn();
     int nitms,i;

     items=ppt->items;
     switch (nitms=ppt->nitems) {
     case 0:
          prfmsg(QMUTL112);
          break;
     case 1:
          prfmsg(QMUTL113,anitmn(items[0]));
          break;
     case 2:
          prfmsg(QMUTL114,anitmn(items[0]));
          prfmsg(QMUTL115,anitmn(items[1]));
          break;
     default:
           for (i=0 ; i < nitms-1 ; i++) {
               prfmsg(QMUTL116,anitmn(items[i]));
          }
          prfmsg(QMUTL117,anitmn(items[nitms-1]));
     }
}

char *
anitmn(itm)                             /* "a" or "an" for object utlity   */
struct item *itm;
{

     static char rtval[30];

     if (itm->flags&USEAN) {
          strcpy(rtval,"an ");
     }
     else {
          strcpy(rtval,"a ");
     }
     strcat(rtval,itm->name);
     return(rtval);
}

char *
aoran(noun)                             /* "a" or "an" utility for any noun*/
char *noun;                             /* (returns "a foo" or "an akko")  */
{
     static char totstg[40];

     switch (tolower(*noun)) {
     case 'a':
     case 'e':
     case 'i':
     case 'o':
     case 'u':
          strcpy(totstg,"an ");
          break;
     default:
          strcpy(totstg,"a ");
     }
     strcat(totstg,noun);
     return(totstg);
}

void
seepyrs(pp)                             /*  see players in room function   */
struct qmplayer *pp;
{
     struct qmplayer *nxpsee();
     int npyr,i;

     if (pp->aura&SEEPYR) {
          inpsee(pp);
          switch (npyr=npysee(pp)) {
          case 0:
               break;
          case 1:
               prfmsg(QMUTL118,nxpsee(pp)->plyrid);
               break;
          case 2:
               prfmsg(QMUTL119,nxpsee(pp)->plyrid,nxpsee(pp)->plyrid);
               break;
          default:
               prfmsg(QMUTL120);
               for (i=0 ; i < npyr-1 ; i++) {
                    prfmsg(QMUTL121,nxpsee(pp)->plyrid);
               }
               prfmsg(QMUTL122,nxpsee(pp)->altid);
          }
     }
}

int
npysee(pp)                              /* function: how many players seen */
struct qmplayer *pp;
{
     struct qmplayer *op;
     int retval;

     for (op=pp->room->roomhdr,retval=0 ; op != NULL ; op=op->plink) {
          if (op != pp && (!(op->aura&INVIS1) || (pp->aura&SEEIN1))) {
               retval++;
          }
     }
     return(retval);
}

void
inpsee(pp)                              /* initialization of see players utl*/
struct qmplayer *pp;
{
     pspp=pp->room->roomhdr;
}

struct qmplayer *
nxpsee(pp)                              /* link-list continuation: seeplyrs*/
struct qmplayer *pp;
{
     struct qmplayer *opspp;

     while (pspp != NULL) {
          opspp=pspp;
          pspp=pspp->plink;
          if (opspp != pp && (!(opspp->aura&INVIS1) || (pp->aura&SEEIN1))) {
               return(opspp);
          }
     }
     return(NULL);
}

int
npyroom(room)                           /* number of players in room utl.  */
struct room *room;
{
     struct qmplayer *pp;
     int retval;

     for (pp=room->roomhdr,retval=0 ; pp != NULL ; pp=pp->plink,retval++) {
     }
     return(retval);
}

void
rst4say(void)                           /* prepare input for "say" format  */
{
     int i;

     for (i=1 ; i < margc-1 ; i++) {
          *margn[i]=' ';
     }
}

void
rst4whs(void)
{
     int i;

     for (i=3 ; i < margc-1 ; i++) {
          *margn[i]=' ';
     }
}

struct item *
getpitm(who,name)                       /* get a player's item utlity      */
struct qmplayer *who;                   /* for use: get/drop/look/becute et*/
char *name;
{
     int i,looplim;
     struct item **itmppt,*retval;

     for (i=0,itmppt=who->items,looplim=who->nitems ; i < looplim ; i++) {
          if (sameto(name,(*itmppt)->name)) {
               retval=*itmppt;
               if (i != looplim-1) {
                    *itmppt=who->items[looplim-1];
               }
               who->nitems--;
               return(retval);
          }
          itmppt++;
     }
     return(NULL);
}

struct item *
getritm(where,name)                     /* get item in room utility        */
struct room *where;                     /* for use: get/look/becute etc.   */
char *name;
{
     int i,looplim;
     char *itm;
     struct item *retval;

     for (i=0,itm=where->iitems,looplim=where->nitems ; i < looplim ; i++) {
          if (sameto(name,qmitems[itm[i]].name)) {
               retval=&qmitems[itm[i]];
               if (i != looplim-1) {
                    where->iitems[i]=where->iitems[looplim-1];
               }
               where->nitems--;
               return(retval);
          }
     }
     return(NULL);
}

int
putpitm(who,itmptr)
struct qmplayer *who;
struct item *itmptr;
{
     if (who->nitems >= MXITEM) {
          return(0);
     }
     who->items[who->nitems++]=itmptr;
     return(1);
}

int
putritm(where,itmptr)
struct room *where;
struct item *itmptr;
{
     if (where->nitems >= MXITEM) {
          return(0);
     }
     where->iitems[where->nitems++]=(char)(itmptr-qmitems);
     return(1);
}

struct item *
locitm(itmnam)
char *itmnam;
{
     struct item *itmptr;

     if ((itmptr=getpitm(playpt,itmnam)) == NULL) {
          if ((itmptr=getritm(playpt->room,itmnam)) == NULL) {
               return(NULL);
          }
          putritm(playpt->room,itmptr);
     }
     else {
          putpitm(playpt,itmptr);
     }
     return(itmptr);
}

struct qmplayer *
qmfndplyr(name)
char *name;
{
     struct qmplayer *pp;

     for (pp=playpt->room->roomhdr ; pp != NULL ; pp=pp->plink) {
          if ((seeflg(pp->aura)&playpt->aura) && sameto(name,pp->plyrid)) {
               return(pp);
          }
     }
     return(NULL);
}

struct qmplayer *
plyrqm(name)
char *name;
{
     int i;
     struct qmplayer *pp;

     for (i=0,pp=qmplayer ; i < nterms ; i++,pp++) {
          if ((pp->flags&INQM) && sameas(name,pp->plyrid)) {
               return(pp);
          }
     }
     return(NULL);
}

void
bagthe(void)
{
     int i;

     for (i=0 ; i < margc-1 ; i++) {
          if (sameas(margv[i],"the")
           || sameas(margv[i],"a")
           || sameas(margv[i],"an")) {
               *margn[i]=' ';
               margc--;
               movmem(&margv[i+1],&margv[i],(margc-i)*sizeof(char *));
               movmem(&margn[i+1],&margn[i],(margc-i)*sizeof(char *));
          }
     }
}

void
qmbagprep(void)
{
     int i;

     for (i=0 ; i < margc-1 ; i++) {
          if (sameas(margv[i],"at")
           || sameas(margv[i],"in")
           || sameas(margv[i],"to")
           || sameas(margv[i],"on")
           || sameas(margv[i],"of")
           || sameas(margv[i],"under")
           || sameas(margv[i],"inside")) {
               *margn[i]=' ';
               margc--;
               movmem(&margv[i+1],&margv[i],(margc-i)*sizeof(char *));
               movmem(&margn[i+1],&margn[i],(margc-i)*sizeof(char *));
          }
     }
}

void
killpyr(pp)
struct qmplayer *pp;
{
     qmxitroom(pp,rawmsg(QMUTL201));
     inipyr(pp->channel,pp->plyrid);
     pp->flags|=INQM;
     qmentroom(pp,&qmrooms[0],rawmsg(QMUTL200));
}

char *
namize(stg)
char *stg;
{
     char *tmp;
     static char namstg[40];

     namstg[0]=toupper(*stg);
     for (tmp=namstg+1 ; *++stg != '\0' ; ) {
          *tmp++=tolower(*stg);
     }
     *tmp='\0';
     return(namstg);
}

void
xmunum(msgno)
int msgno;
{
     btuxmt(usrnum,rawmsg(msgno));
}

