/***************************************************************************
 *                                                                         *
 *     QUEST FOR MAGIC Version 3.0                                         *
 *                                                                         *
 *     Copyright (C) 1986-1992 GALACTICOMM, Inc.    All Rights Reserved.   *
 *                                                                         *
 ***************************************************************************
 * GALACTICOMM Software License Agreement                                  *
 *                                                                         *
 * GALACTICOMM, Inc., grants you a fully paid, perpetual, worldwide,       *
 * non-exclusive license to use, transfer, share, modify, delete, and      *
 * incorporate this Software into products copyrighted, patented,          *
 * subject to trade secret or other intellectual protection rights         *
 * asserted by you.                                                        *
 *                                                                         *
 * This Software is provided "as is", without warranty of any kind,        *
 * either expressed or implied, including, but not limited to, the implied *
 * warranties of merchantability and fitness for a particular purpose.     *
 *                                                                         *
 * This license is effective as long as this declaration is preserved in   *
 * its entirety in this Software and any copies or derivatives.            *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *     QMSPCL.C                                                            *
 *     Quest for Magic Room Specific Routines and Sysop Functions          *
 *                                                                         *
 *     By - Scott Brinker and Tim Stryker      11/21/86                    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galqm.h"
#include "qm.h"

extern
int nov3rs;                   /* number of players for Virtue 3       */

void
cojrou (void)                                /*  Summon Item (SysOp)       */
{
     int i;

     if (margc == 2) {
          if (playpt->nitems < MXITEM) {
               for (i=0 ; i < 23 ; i++) {
                    if (sameto(margv[1],qmitems[i].name)) {
                         putpitm(playpt,&qmitems[i]);
                         prfmsg(QMSPC100);
                         outprf(usrnum);
                         return;
                    }
               }
               prfmsg(QMSPC101);
               outprf(usrnum);
               return;
          }
          prfmsg(QMSPC102);
          outprf(usrnum);
          return;
     }
     prfmsg(QMSPC103);
     outprf(usrnum);
}

void
drajspk(void)
{
     rst4say();
     prfmsg(QMSPC104);
     outprf(usrnum);
     prfmsg(DSPEAK);
     prfmsg(QMSPC105,margv[1]);
     qmoutall();
}

void
quake(void)
{
     prfmsg(QMSPC106);
     outprf(usrnum);
     prfmsg(EARTHQ);
     qmoutall();
}

void
brodcst(void)
{
     rst4say();
     prfmsg(QMSPC107);
     outprf(usrnum);
     prfmsg(QMSPC108,margv[1]);
     qmoutall();
}

void
fairy(void)
{
     if ((othppt=plyrqm(margv[1])) != NULL) {
          rstrin();
          prfmsg(FAIRYMSG,margv[2]);
          outprf(othppt->channel);
          prfmsg(QMSPC109);
          outprf(usrnum);
     }
     else {
          prfmsg(QMSPC110,namize(margv[1]));
          outprf(usrnum);
     }
}

void
vision(void)
{
     if ((othppt=plyrqm(margv[1])) != NULL) {
          rstrin();
          prfmsg(VISOMSG,margv[2]);
          outprf(othppt->channel);
          prfmsg(QMSPC111);
          outprf(usrnum);
     }
     else {
          prfmsg(QMSPC112,namize(margv[1]));
          outprf(usrnum);
     }
}

void
nulrou(void)
{
     return;
}

int
inulrou(void)
{
     return(1);
}

int
examine(void)
{
     if (sameas(margv[0],"look")
      || sameas(margv[0],"examine")
      || sameas(margv[0],"see")
      || sameas(margv[0],"inspect")) {
          return(1);
     }
     return(0);
}

int
chprou(void)
{
     if (sameas(margv[0],"pray") || sameas(margv[0],"commune")) {
          prfmsg(PRAYER);
          outprf(usrnum);
          prfmsg(PRAYOT,playpt->altid);
          outothr();
          return(0);
     }
     else if (sameas(margv[0],"place") && sameas(margv[1],"triangle")
       && sameas(margv[2],"on") && sameas(margv[3],"altar")) {
          if (getpitm(playpt,"triangle") != NULL) {
               prfmsg(USETRI);
               outprf(usrnum);
               playpt->flags&=~BRIEF;
               qmxitroom(playpt,rawmsg(QMSPC216));
               qmentroom(playpt,&qmrooms[189],rawmsg(QMSPC200));
               return(0);
          }
     }
     else if (sameas(margv[0],"marry") || sameas(margv[0],"wed")
        && hasmkey(DEMKEY)) {
          qmbagprep();
          bagthe();
          if (playpt->aura&MARIED) {
               prfmsg(ALREDM);
               outprf(usrnum);
               prfmsg(ADULTRY,playpt->altid);
               outothr();
               return(0);
          }
          else if (((othppt=qmfndplyr(margv[1])) != NULL) && margc == 2) {
               prfmsg(MARRYP,othppt->altid);
               outprf(usrnum);
               playpt->aura|=MARIED;
               prfmsg(MARRYY,playpt->altid,playpt->hisher);
               outprf(othppt->channel);
               prfmsg(MARRYO,playpt->altid,othppt->altid);
               outevbt(othppt);
               return(0);
          }
     }
     else if (examine()) {
          bagthe();
          qmbagprep();
          if (sameas(margv[1],"altar")) {
               prfmsg(ALTAR);
               outprf(usrnum);
               prfmsg(QMSPC113,playpt->altid);
               outothr();
               return(0);
          }
     }
     else if (sameas(margv[1],"altar") || sameas(margv[2],"altar")) {
          prfmsg(QMSPC114);
          outprf(usrnum);
          prfmsg(QMSPC115,playpt->altid);
          outothr();
          return(0);
     }
     return(1);
}

int
luvrou(void)
{
     if (sameas(margv[0],"kiss") && hasmkey(DEMKEY)) {
          if ((othppt=qmfndplyr(margv[1])) != NULL) {
               prfmsg(KISSP,othppt->altid);
               outprf(usrnum);
               prfmsg(KISSY,playpt->altid,playpt->hisher);
               outprf(othppt->channel);
               prfmsg(KISSO,playpt->altid,othppt->altid);
               outevbt(othppt);
               return(0);
          }
          else {
               prfmsg(QMSPC116,namize(margv[1]));
               outprf(usrnum);
               prfmsg(QMSPC117,playpt->altid);
               outothr();
               return(0);
          }
     }
     else if (sameas(margv[0],"embrace") && hasmkey(DEMKEY)) {
          if ((othppt=qmfndplyr(margv[1])) != NULL) {
               prfmsg(EMBRP,othppt->altid,othppt->altid);
               outprf(usrnum);
               prfmsg(EMBRY,playpt->altid,playpt->hisher);
               outprf(othppt->channel);
               prfmsg(EMBRO,playpt->altid,othppt->altid,playpt->hisher);
               outevbt(othppt);
               return(0);
          }
          else {
               prfmsg(QMSPC118,namize(margv[1]));
               outprf(usrnum);
               prfmsg(QMSPC119,playpt->altid);
               outothr();
               return(0);
          }
     }
     else if (examine()) {
          bagthe();
          qmbagprep();
          if (sameas(margv[1],"waterfall")) {
               prfmsg(WTRFALL);
               outprf(usrnum);
               prfmsg(QMSPC120,
                 playpt->altid);
               outothr();
               return(0);
          }
          if (sameas(margv[1],"pool")) {
               prfmsg(WTFPOOL);
               outprf(usrnum);
               prfmsg(QMSPC121,
                 playpt->altid);
               outothr();
               return(0);
          }
     }
     if (margc > 1) {
          if (sameas(margv[margc-1],"waterfall")
           || sameas(margv[margc-1],"pool")) {
               prfmsg(QMSPC122);
               outprf(usrnum);
               prfmsg(QMSPC123,
                 playpt->altid,margv[margc-1]);
               outothr();
               return(0);
          }
     }
     return(1);
}

int
nghrou(void)
{
     if (sameas(margv[0],"place") && sameas(margv[1],"hand")
        && hasmkey(DEMKEY)) {
          if (sameas(margv[3],"painting")
           || sameas(margv[3],"hand")) {
               prfmsg(HANDNH);
               outprf(usrnum);
               qmxitroom(playpt,rawmsg(QMSPC217));
               qmentroom(playpt,&qmrooms[187],rawmsg(QMSPC201));
               return(0);
          }
     }
     else if (examine()) {
          bagthe();
          qmbagprep();
          if (sameas(margv[1],"painting") || sameas(margv[1],"hand")) {
               prfmsg(PAINTIN);
               outprf(usrnum);
               prfmsg(QMSPC124,playpt->altid);
               outothr();
               return(0);
          }
     }
     if (margc > 1) {
               if (sameas(margv[1],"painting") || sameas(margv[2],"painting")) {
               prfmsg(QMSPC125);
               outprf(usrnum);
               prfmsg(QMSPC126,
                 playpt->altid,margv[0]);
               outothr();
               return(0);
          }
     }
     return(1);
}

int
orbrou(void)
{
     if (sameas(margv[0],"think") && (othppt=plyrqm(margv[1])) != NULL
        && hasmkey(DEMKEY)) {
          if (othppt->aura&SCRPRO) {
               if ((rnd()&0x0E) != 0) {
                    playpt->descrpt=(sameas(playpt->hisher,"his") ? DESC2M : DESC2F);
                    prfmsg(NOSCRY);
                    outprf(usrnum);
                    prfmsg(GOTONE,playpt->altid);
                    outothr();
                    return(0);
               }
               else {
                    prfmsg(OHSHT);
                    outprf(usrnum);
                    qmxitroom(playpt,rawmsg(QMSPC218));
                    qmentroom(playpt,&qmrooms[199],rawmsg(QMSPC202));
                    return(0);
               }
          }
          else {
               prfmsg(ORBTHK,othppt->plyrid);
               prfmsg(othppt->room->desc);
               prfmsg(ORBFIN);
               outprf(usrnum);
               prfmsg(SCRYING);
               outprf(othppt->channel);
               prfmsg(SCRY,playpt->altid);
               outevbt(othppt);
               return(0);
          }
     }
     else if (sameas(margv[0],"rub") && sameas(margv[1],"orb")) {
          prfmsg(ORBMSG);
          qmoutroom(&qmrooms[26]);
          prfmsg(USEORB);
          outprf(usrnum);
          prfmsg(ORBOTH,playpt->altid);
          outothr();
          return(0);
     }
     else if (examine()) {
          bagthe();
          qmbagprep();
          if (sameas(margv[1],"orb")) {
               prfmsg(LKORB);
               outprf(usrnum);
               prfmsg(QMSPC127,playpt->altid);
               outothr();
               return(0);
          }
     }
     if (margc > 1) {
               if (sameas(margv[1],"orb") || sameas(margv[2],"orb")) {
               prfmsg(QMSPC128);
               outprf(usrnum);
               prfmsg(QMSPC129,playpt->altid);
               outothr();
               return(0);
          }
     }
     return(1);
}

int
echorou(void)
{
     if (sameas(margv[0],"echo") && hasmkey(DEMKEY)) {
          playpt->descrpt=(sameas(playpt->hisher,"his") ? DESC2M : DESC2F);
          prfmsg(QMSPC130);
          outprf(usrnum);
          prfmsg(QMSPC131);
          qmoutall();
          return(0);
     }
     return(1);
}

int
wotrou(void)
{
     if (sameas(margv[0],"speak") && sameas(margv[1],"the")
      && sameas(margv[2],"word") && sameas(margv[3],"of")
      && sameas(margv[4],"truth")) {
          prfmsg(WOTMSG);
          outprf(usrnum);
          qmxitroom(playpt,rawmsg(QMSPC219));
          qmentroom(playpt,&qmrooms[111],rawmsg(QMSPC203));
          return(0);
     }
     return(1);
}

int
qmrosrou(void)
{
     if ((sameas(margv[0],"look") || sameas(margv[0],"examine")
      || sameas(margv[0],"read") || sameas(margv[0],"see"))
      && (sameas(margv[1],"diagrams") || sameas(margv[1],"symbol"))) {
          prfmsg(KYRATRI);
          outprf(usrnum);
          prfmsg(QMSPC132,playpt->altid);
          outothr();
          return(0);
     }
     return(1);
}

int
pyrrou(void)
{
     if (sameas(margv[0],"raise") && sameas(margv[1],"sceptre")) {
          if (getpitm(playpt,"sceptre") == NULL) {
               prfmsg(QMSPC133);
               outprf(usrnum);
               prfmsg(QMSPC134,playpt->altid);
               outothr();
          }
          else {
               putpitm(playpt,&qmitems[5]);
               prfmsg(PYRMSG);
               outprf(usrnum);
               playpt->flags&=~BRIEF;
               qmxitroom(playpt,rawmsg(QMSPC220));
               qmentroom(playpt,&qmrooms[15],rawmsg(QMSPC204));
          }
          return(0);
     }
     return(1);
}

int
hovrou(void)
{
     if (sameas(margv[0],"chant") && sameas(margv[1],"mantra")) {
          if (getpitm(playpt,"necklace") != NULL) {
               prfmsg(PVISON);
               outprf(usrnum);
               return(0);
          }
     }
     return(1);
}

int
sohrou(void)
{
     struct item *itmptr;

     if ((sameas(margv[0],"look") || sameas(margv[0],"examine")
      || sameas(margv[0],"read") || sameas(margv[0],"see"))
      && (sameas(margv[1],"inscription") || sameas(margv[1],"inscriptions"))) {
          prfmsg(SOHINS);
          outprf(usrnum);
          prfmsg(QMSPC135,playpt->altid);
          outothr();
          return(0);
     }
     else if (sameas(margv[0],"w") || sameas(margv[0],"west")) {
          qmxitroom(playpt,rawmsg(QMSPC221));
          qmentroom(playpt,&qmrooms[183],rawmsg(QMSPC205));
          return(0);
     }
     else if (sameas(margv[0],"tiwyrilas")) {
          prfmsg(GVOFF);
          outprf(usrnum);
          playpt->aura|=VIRTU3;
          prfmsg(QMSPC136,playpt->altid);
          outothr();
          return(0);
     }
     else if (sameas(margv[0],"pray") || sameas (margv[0],"meditate")) {
          prfmsg(SOHMSG);
          outprf(usrnum);
          prfmsg(QMSPC137,playpt->altid);
          outothr();
          return(0);
     }
     else if (sameas(margv[0],"kyrajen")) {
          if ((itmptr=getpitm(playpt,"amethyst")) != NULL &&
               (itmptr=getpitm(playpt,"staff")) != NULL &&
               npyroom(playpt->room) >= nov3rs) {
               prfmsg(WOWEE);
               outprf(usrnum);
               prfmsg(COLORS,playpt->altid,playpt->altid);
               outothr();
               playpt->aura|=VIRTU1;
               return(0);
          }
          else {
               return(1);
          }
     }
     else if (sameas(margv[0],"offer")
      && ((itmptr=getpitm(playpt,margv[1])) != NULL)
      && sameas(margv[2],"to")
      && sameto(margv[3],"Kyrannalussi")) {
          if (playpt->room->nitems >= MXITEM) {
               putpitm(qmplayer,itmptr);
               prfmsg(FORCEY);
               outprf(usrnum);
               prfmsg(FORCEO,playpt->altid,aoran(margv[1]));
               outothr();
               return(0);
          }
          else {
               playpt->descrpt=(sameas(playpt->hisher,"his") ? DESC4M : DESC4F);
               if (sameas(margv[1],"crystal")) {
                    prfmsg(BSSSSB);
                    outprf(usrnum);
                    prfmsg(BSSSSA,playpt->altid);
                    outothr();
                    putritm(playpt->room,&qmitems[16]);
                    return(0);
               }
               else if (sameas(margv[1],"orb")) {
                    prfmsg(BSSSSE);
                    outprf(usrnum);
                    prfmsg(BSSSSD,playpt->altid);
                    outothr();
                    putritm(playpt->room,&qmitems[12]);
                    return(0);
               }
               else {
                    prfmsg(NOITMY);
                    outprf(usrnum);
                    prfmsg(NOITMO,playpt->altid,aoran(margv[1]));
                    outothr();
                    return(0);
               }
/*             putpitm(playpt,itmptr);     this is not desirable */
          }
     }
     return(1);
}

int
walrou(void)
{
     if ((sameas(margv[0],"put") || sameas(margv[0],"place"))
      && sameas(margv[1],"moonstone") && sameas(margv[3],"niche")) {
          if (getpitm(playpt,margv[1]) == NULL) {
               prfmsg(QMSPC138);
               outprf(usrnum);
               prfmsg(QMSPC139,playpt->altid);
               outothr();
          }
          else {
               prfmsg(WALMSG);
               outprf(usrnum);
               qmxitroom(playpt,rawmsg(QMSPC222));
               qmentroom(playpt,&qmrooms[136],rawmsg(QMSPC206));
          }
          return(0);
     }
     return(1);
}

int
coprou(void)
{
     if (sameas(margv[0],"command") && sameas(margv[1],"portal")
      && sameas(margv[2],"to") && sameas(margv[3],"open")
      && (playpt->aura&(VIRTU1+VIRTU2+VIRTU3)) == VIRTU1+VIRTU2+VIRTU3) {
          if (getpitm(playpt,"staff") == NULL) {
               prfmsg(QMSPC140);
               outprf(usrnum);
               prfmsg(QMSPC141,playpt->altid);
               outothr();
               return(0);
          }
          else {
               prfmsg(WINNER);
               outprf(usrnum);
               qmxitroom(playpt,rawmsg(QMSPC223));
               qmentroom(playpt,&qmrooms[196],rawmsg(QMSPC207));
               shocst("USER WON QUEST FOR MAGIC","User-ID: %s",usaptr->userid);
               return(0);
          }
     }
     return(1);
}

int
cpsrou(void)
{
     if ((sameas(margv[0],"look") || sameas(margv[0],"examine"))
      && (sameas(margv[1],"statues") || sameas(margv[1],"statue"))) {
          prfmsg(STATUES);
          outprf(usrnum);
          prfmsg(QMSPC142,playpt->altid);
          outothr();
          return(0);
     }
     else if (sameas(margv[1],"statues") || sameas(margv[2],"statues")) {
          prfmsg(QMSPC143);
          outprf(usrnum);
          prfmsg(QMSPC144,playpt->altid);
          outothr();
          return(0);
     }
     else {
          return(1);
     }
}

int
eplrou(void)
{
     if ((sameas(margv[0],"look") || sameas(margv[0],"examine"))
      && (sameas(margv[1],"lion") || sameas(margv[1],"gold"))) {
          prfmsg(GLION);
          outprf(usrnum);
          prfmsg(QMSPC145,playpt->altid);
          outothr();
          return(0);
     }
     if (margc > 1) {
          if (sameas(margv[1],"lion") || sameas(margv[2],"lion")) {
               prfmsg(QMSPC146);
               outprf(usrnum);
               prfmsg(QMSPC147,playpt->altid);
               outothr();
               return(0);
          }
     }
     return(1);
}

int
wplrou(void)
{
     if ((sameas(margv[0],"look") || sameas(margv[0],"examine"))
      && (sameas(margv[1],"lion") || sameas(margv[1],"silver"))) {
          prfmsg(SLION);
          outprf(usrnum);
          prfmsg(QMSPC148,playpt->altid);
          outothr();
          return(0);
     }
     else if (margc > 1) {
          if (sameas(margv[1],"lion")
            || (margc > 2 && sameas(margv[2],"lion"))) {
               prfmsg(QMSPC149);
               outprf(usrnum);
               prfmsg(QMSPC150,playpt->altid);
               outothr();
               return(0);
          }
     }
     return(1);
}

int
nplrou(void)
{
     if (sameas(margv[0],"look") || sameas(margv[0],"examine")
      && (sameas(margv[1],"lion") || sameas(margv[1],"iron"))) {
          prfmsg(ILION);
          outprf(usrnum);
          prfmsg(QMSPC151,playpt->altid);
          outothr();
          return(0);
     }
     else if (sameas(margv[0],"tiwyrilas") && playpt->aura&GOODBY) {
          prfmsg(GVOFF);
          outprf(usrnum);
          playpt->aura|=VIRTU2;
          prfmsg(QMSPC152,playpt->altid);
          outothr();
          return(0);
     }
     return(1);
}

int
osrrou(void)
{
     if (examine()) {
          bagthe();
          qmbagprep();
          if (sameas(margv[1],"spot")) {
               prfmsg(SILVSPT);
               outprf(usrnum);
               prfmsg(QMSPC153,playpt->altid);
               outothr();
               return(0);
          }
     }
     else if (sameas(margv[0],"kyrajen") && playpt->spluse <= 0) {
          playpt->descrpt=(sameas(playpt->hisher,"his") ? DESC5M : DESC5F);
          prfmsg(KYRASPT);
          outprf(usrnum);
          prfmsg(ORBNSPT);
          qmoutroom(&qmrooms[21]);
          prfmsg(HOWNSPT);
          qmoutroom(&qmrooms[26]);
          prfmsg(ERRNSPT);
          qmoutroom(&qmrooms[125]);
          prfmsg(SHNNSPT);
          qmoutroom(&qmrooms[187]);
          prfmsg(NOWHERE,playpt->altid);
          outothr();
          sspdly(30);
          return(0);
     }
     return(1);
}

int
pokrou(void)
{
     if (!(playpt->aura&BLESSD) && (!(sameas(margv[0],"bathe")
         && sameas(margv[1],"in") && sameas(margv[2],"pool")))
         && (!sameas(margv[0],"look"))) {
          prfmsg(BIEBIE);
          outprf(usrnum);
          qmxitroom(playpt,rawmsg(QMSPC224));
          qmentroom(playpt,&qmrooms[187],rawmsg(QMSPC208));
          return(0);
     }
     else if (sameas(margv[0],"bathe") && sameas(margv[1],"in")
         && sameas(margv[2],"pool")) {
          playpt->aura|=BLESSD;
          playpt->hits=playpt->maxhit;
          prfmsg(POOLMSG);
          outprf(usrnum);
          prfmsg(QMSPC154,playpt->altid);
          outothr();
          return(0);
     }
     else if (sameas(margv[0],"throw") || sameas(margv[0],"drop")) {
          if (getpitm(playpt,margv[1]) != NULL
           && (sameas(margv[2],"pool") || sameas(margv[3],"pool"))) {
               if (sameas(margv[1],"emerald")) {
                    prfmsg(POOLEM);
                    outprf(usrnum);
                    qmxitroom(playpt,rawmsg(QMSPC225));
                    qmentroom(playpt,&qmrooms[140],rawmsg(QMSPC209));
                    return(0);
               }
               if (sameas(margv[1],"ruby")) {
                    prfmsg(POOLEM);
                    outprf(usrnum);
                    qmxitroom(playpt,rawmsg(QMSPC226));
                    qmentroom(playpt,&qmrooms[21],rawmsg(QMSPC210));
                    return(0);
               }
               if (sameas(margv[1],"diamond")) {
                    prfmsg(POOLEM);
                    outprf(usrnum);
                    qmxitroom(playpt,rawmsg(QMSPC227));
                    qmentroom(playpt,&qmrooms[26],rawmsg(QMSPC211));
                    return(0);
               }
               if (sameas(margv[1],"sapphire")) {
                    prfmsg(POOLEM);
                    outprf(usrnum);
                    qmxitroom(playpt,rawmsg(QMSPC228));
                    qmentroom(playpt,&qmrooms[195],rawmsg(QMSPC212));
                    return(0);
               }
               if (sameas(margv[1],"amethyst")) {
                    prfmsg(POOLEM);
                    outprf(usrnum);
                    qmxitroom(playpt,rawmsg(QMSPC229));
                    qmentroom(playpt,&qmrooms[187],rawmsg(QMSPC213));
                    return(0);
               }
               else {
                    qmdrprou();
                    return(0);
               }
          }
          else {
               qmdrprou();
               return(0);
          }
     }
     return(1);
}

int
sumhall(void)
{
     if (sameas(margv[0],"summon") && (othppt=plyrqm(margv[1])) != NULL
        && hasmkey(DEMKEY)) {
          if (othppt->aura&MAGPRO) {
               prfmsg(TOOBAD);
               outprf(usrnum);
               prfmsg(QMSPC155,playpt->altid);
               outothr();
               return(0);
          }
          else {
               prfmsg(USUMMD);
               outprf(othppt->channel);
               prfmsg(YOUSUM);
               outprf(usrnum);
               qmxitroom(othppt,rawmsg(QMSPC230));
               qmentroom(othppt,&qmrooms[195],rawmsg(QMSPC214));
               return(0);
          }
     }
     else if (sameas(margv[0],"summon")) {
          if (sameas(margv[1],"drajorth")) {
               prfmsg(DRAJSUM);
               outprf(usrnum);
               prfmsg(DEEPSHT,playpt->altid,playpt->altid);
               outothr();
               othppt=playpt;
               bamoth(40);
               return(0);
          }
          if (sameas(margv[1],"kyrannalussi")) {
               playpt->aura|=GOODBY;
               prfmsg(KYRASUM);
               outprf(usrnum);
               prfmsg(GOODBOY,playpt->altid,playpt->altid);
               outothr();
               return(0);
          }
     }
     return(1);
}

int
hokrou(void)
{
     if (examine()) {
          bagthe();
          qmbagprep();
          if (sameas(margv[1],"painting") || sameas(margv[1],"oak")) {
               prfmsg(OAKTREE);
               outprf(usrnum);
               prfmsg(QMSPC156,playpt->altid);
               outothr();
               return(0);
          }
          else {
               return(1);
          }
     }
     else if (sameas(margv[0],"istmagic")) {
               prfmsg(TADA);
               outprf(usrnum);
               qmxitroom(playpt,rawmsg(QMSPC231));
               qmentroom(playpt,&qmrooms[198],rawmsg(QMSPC215));
               return(0);
     }
     else if (margc > 1) {
          if (sameas(margv[1],"painting") || sameas(margv[2],"painting")) {
               prfmsg(QMSPC157);
               outprf(usrnum);
               prfmsg(QMSPC158,playpt->altid);
               outothr();
               return(0);
          }
     }
     return(1);
}

int
chlrou(void)
{
     if (sameas(margv[0],"look") || sameas(margv[0],"examine")
      && (sameas(margv[1],"lore") || sameas(margv[1],"inscription"))) {
          prfmsg(LORE);
          outprf(usrnum);
          prfmsg(QMSPC159,playpt->altid);
          outothr();
          return(0);
     }
     return(1);
}

int
frgrou(void)
{
     if (sameas(margv[0],"forge") && sameas(margv[1],"triangle")) {
          if (getpitm(playpt,"medallion") != NULL
           && getpitm(playpt,"pendant") != NULL
           && getpitm(playpt,"locket") != NULL) {
               prfmsg(TRIFRG);
               outprf(usrnum);
               prfmsg(TRIWOW,playpt->altid);
               outothr();
               putpitm(playpt,&qmitems[23]);
               return(0);
          }
          else {
               prfmsg(WRNGF);
               outprf(usrnum);
               prfmsg(QMSPC160,playpt->altid);
               outothr();
               return(0);
          }
     }
     return(1);
}

int
sample(void)
{
     if (sameas(margv[0],"jump")) {
          prfmsg(QMSPC161);
          outprf(usrnum);
          prfmsg(QMSPC162,playpt->altid);
          outothr();
          return(0);
     }
     return(1);
}


