/***************************************************************************
 *                                                                         *
 *     QUEST FOR MAGIC Version 3.0                                         *
 *                                                                         *
 *     Copyright (C) 1986-1992 GALACTICOMM, Inc.    All Rights Reserved.   *
 *                                                                         *
 ***************************************************************************
 * GALACTICOMM Software License Agreement                                  *
 *                                                                         *
 * GALACTICOMM, Inc., grants you a fully paid, perpetual, worldwide,       *
 * non-exclusive license to use, transfer, share, modify, delete, and      *
 * incorporate this Software into products copyrighted, patented,          *
 * subject to trade secret or other intellectual protection rights         *
 * asserted by you.                                                        *
 *                                                                         *
 * This Software is provided "as is", without warranty of any kind,        *
 * either expressed or implied, including, but not limited to, the implied *
 * warranties of merchantability and fitness for a particular purpose.     *
 *                                                                         *
 * This license is effective as long as this declaration is preserved in   *
 * its entirety in this Software and any copies or derivatives.            *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *     QMCMDS.C                                                            *
 *     Quest for Magic Command List and Handler                            *
 *                                                                         *
 *     By - Tim Stryker and Scott Brinker      11/21/86                    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "qm.h"
#include "galqm.h"

#define CARSIZ (sizeof(cmdarr)/sizeof(struct arrent))

struct arrent cmdarr[]={
     {"abuse",   qmbemean,1},
     {"act",     anyrou,1},
     {"admit",   qmsayrou,0},
     {"advise",  qmsayrou,0},
     {"agree",   qmsayrou,0},
     {"aim",     aimrou,1},
     {"alter",   fixrou,1},
     {"amble",   moving,1},
     {"annihilate",qmbemean,1},
     {"announce",qmsayrou,0},
     {"answer",  qmsayrou,1},
     {"applaud", approu,0},
     {"argue",   qmsayrou,1},
     {"articulate",qmsayrou,1},
     {"ask",     qmsayrou,1},
     {"ass",     nasty,1},
     {"asshole", nasty,1},
     {"assume",  qmsayrou,1},
     {"attack",  qmbemean,1},
     {"aver",    qmsayrou,0},
     {"babble",  qmsayrou,1},
     {"barf",    sicrou,1},
     {"bargain", qmsayrou,1},
     {"bark",    qmsayrou,1},
     {"bash",    qmbemean,1},
     {"bastard", nasty,1},
     {"bathe",   anyrou,1},
     {"battle",  qmbemean,1},
     {"bawl",    cryrou,1},
     {"be",      anyrou,1},
     {"beat",    qmbemean,1},
     {"beg",     begrou,1},
     {"belch",   burrou,1},
     {"bellow",  yelrou,1},
     {"bet",     gamrou,1},
     {"blast",   qmbemean,1},
     {"blink",   blkrou,1},
     {"blurt",   qmsayrou,0},
     {"blush",   blurou,0},
     {"boast",   qmsayrou,1},
     {"boo",     boorou,0},
     {"bow",     bowrou,0},
     {"bribe",   qmbemean,1},
     {"brief",   brfrou,0},
     {"broadcast",brodcst,3},
     {"bruise",  qmbemean,1},
     {"brush",   clnrou,1},
     {"bug",     qmbemean,1},
     {"bump",    qmbemean,1},
     {"burn",    anyrou,1},
     {"burp",    burrou,0},
     {"butcher", qmbemean,1},
     {"buy",     trdrou,1},
     {"cackle",  cacrou,1},
     {"canter",  moving,1},
     {"capture", qmbemean,1},
     {"catch",   qmbemean,1},
     {"change",  fixrou,1},
     {"chant",   qmsayrou,1},
     {"charm",   becute,1},
     {"chat",    qmsayrou,1},
     {"chatter", qmsayrou,0},
     {"cheer",   chrrou,1},
     {"chirp",   qmsayrou,0},
     {"chivalry",chvrou,1},
     {"choke",   wherou,1},
     {"chortle", chorou,1},
     {"chuckle", churou,0},
     {"clap",    approu,0},
     {"clean",   clnrou,1},
     {"club",    qmbemean,1},
     {"cogitate",thkrou,1},
     {"comfort", becute,1},
     {"command", qmsayrou,1},
     {"comment", qmsayrou,1},
     {"commune", prarou,1},
     {"concentrate",thkrou,1},
     {"conjure", cojrou,3},
     {"control", qmbemean,1},
     {"correct", qmsayrou,1},
     {"cough",   courou,1},
     {"cower",   cowrou,1},
     {"crawl",   moving,0},
     {"cry",     cryrou,0},
     {"cuddle",  becute,1},
     {"cuff",    qmbemean,1},
     {"cunt",    nasty,1},
     {"curse",   swerou,1},
     {"cuss",    nasty,1},
     {"cuunol",  cuuspl,1},
     {"damage",  qmbemean,1},
     {"dance",   danrou,1},
     {"date",    becute,1},
     {"declare", qmsayrou,1},
     {"defend",  becute,1},
     {"demand",  qmsayrou,0},
     {"destroy", qmbemean,1},
     {"dick",    nasty,1},
     {"dictate", qmsayrou,1},
     {"direct",  aimrou,1},
     {"divorce", qmbemean,1},
     {"dragmorp",draspl,1},
     {"drajspeak",drajspk,3},
     {"draw",    anyrou,1},
     {"drop",    qmdrprou,1},
     {"dust",    fixrou,1},
     {"e",       east,  0},
     {"east",    east,  0},
     {"eat",     qmbemean,1},
     {"embrace", becute,1},
     {"emulate", qmbemean,1},
     {"enchant", anyrou,1},
     {"erimandr",erispl,1},
     {"examine", qmlokrou,0},
     {"exchange",trdrou,1},
     {"exclaim", qmsayrou,1},
     {"explain", qmsayrou,1},
     {"express", qmsayrou,1},
     {"exult",   qmsayrou,0},
     {"fairy",   fairy ,3},
     {"fart",    farrou,1},
     {"fblutu",  fblspl,1},
     {"fight",   qmbemean,1},
     {"find",    anyrou,1},
     {"fix",     fixrou,1},
     {"fizzganf",fizspl,1},
     {"fly",     moving,1},
     {"follow",  becute,1},
     {"fondle",  nasty,1},
     {"forgive", becute,1},
     {"fpandl",  fpaspl,1},
     {"frown",   frnrou,0},
     {"fuck",    nasty,1},
     {"full",    lonrou,0},
     {"fuss",    whmrou,1},
     {"gag",     wherou,1},
     {"gamble",  gamrou,1},
     {"gasp",    gasrou,0},
     {"get",     qmgetrou,1},
     {"giggle",  gigrou,0},
     {"give",    givrou,1},
     {"glare",   glrrou,1},
     {"go",      moving,0},
     {"grab",    qmgetrou,1},
     {"grasp",   qmgetrou,1},
     {"grin",    grnrou,0},
     {"gripe",   qmsayrou,1},
     {"groan",   gonrou,0},
     {"grovel",  grvrou,1},
     {"growl",   grwrou,0},
     {"grumble", qmsayrou,1},
     {"grunt",   grurou,1},
     {"gupityuu",gupspl,1},
     {"hammer",  qmbemean,1},
     {"hand",    givrou,1},
     {"harm",    qmbemean,1},
     {"help",    helrou,0},
     {"hijtupi", hijspl,1},
     {"hike",    moving,1},
     {"hint",    qmsayrou,1},
     {"hiss",    hisrou,1},
     {"hit",     qmbemean,1},
     {"hits",    hpts,0},
     {"hobble",  moving,1},
     {"hold",    becute,1},
     {"holler",  yelrou,1},
     {"hook",    qmbemean,1},
     {"hoot",    qmsayrou,0},
     {"hop",     moving,1},
     {"hug",     becute,0},
     {"hum",     humrou,0},
     {"hurt",    qmbemean,1},
     {"i",       invrou,0},
     {"impress", becute,1},
     {"incant",  qmsayrou,1},
     {"injure",  qmbemean,1},
     {"inquire", qmsayrou,1},
     {"insist",  qmsayrou,0},
     {"inv",     invrou,0},
     {"inventory",invrou,0},
     {"istmagic",istspl,1},
     {"jabber",  qmsayrou,1},
     {"jostle",  qmbemean,1},
     {"jump",    jmprou,1},
     {"jynxid", linspl,1},
     {"kick",    qmbemean,0},
     {"kill",    qmbemean,1},
     {"kiss",    becute,1},
     {"kyrajen", kyrspl,1},
     {"laugh",   lghrou,0},
     {"lay",     anyrou,1},
     {"leap",    moving,1},
     {"lecture", qmsayrou,1},
     {"lick",    nasty,1},
     {"lie",     lierou,1},
     {"long",    lonrou,0},
     {"look",    qmlokrou,0},
     {"love",    becute,1},
     {"maim",    qmbemean,1},
     {"mangle",  qmbemean,1},
     {"march",   moving,1},
     {"marry",   becute,1},
     {"mash",    qmbemean,1},
     {"maul",    qmbemean,1},
     {"masturbate",nasty,1},
     {"meditate",thkrou,1},
     {"mention", qmsayrou,0},
     {"mhistuui",mhispl,1},
     {"moan",    monrou,1},
     {"move",    moving,1},
     {"mug",     qmbemean,1},
     {"mumble",  qmsayrou,1},
     {"murmur",  qmsayrou,1},
     {"mutilate",qmbemean,1},
     {"mutter",  qmsayrou,0},
     {"muzzle",  qmbemean,1},
     {"n",       north, 0},
     {"name",    qmsayrou,1},
     {"neck",    nasty,1},
     {"nod",     nodrou,0},
     {"nonbrief",lonrou,0},
     {"north",   north, 0},
     {"note",    qmsayrou,1},
     {"notice",  qmsayrou,1},
     {"nubulide",nubspl,1},
     {"obey",    becute,1},
     {"object",  qmsayrou,0},
     {"observe", qmsayrou,0},
     {"obtain",  qmgetrou,1},
     {"offer",   qmsayrou,1},
     {"ooyendo", ooyspl,1},
     {"operate", anyrou,1},
     {"opine",   qmsayrou,0},
     {"osispell",osispl,1},
     {"pant",    qmsayrou,1},
     {"pat",     becute,1},
     {"pee",     nasty,1},
     {"pester",  qmbemean,1},
     {"pet",     becute,1},
     {"pick",    qmbemean,1},
     {"pickpocket",qmgetrou,1},
     {"pilfer",  qmgetrou,1},
     {"pinch",   qmbemean,1},
     {"piss",    nasty,1},
     {"place",   anyrou,1},
     {"plead",   begrou,0},
     {"please",  becute,1},
     {"point",   aimrou,1},
     {"poke",    qmbemean,1},
     {"polish",  clnrou,1},
     {"pommel",  qmbemean,1},
     {"ponder",  thkrou,1},
     {"pout",    potrou,0},
     {"pray",    prarou,1},
     {"predict", qmsayrou,1},
     {"proclaim",qmsayrou,1},
     {"project", anyrou,1},
     {"promise", qmsayrou,1},
     {"propose", qmsayrou,0},
     {"protect", becute,1},
     {"protest", qmsayrou,1},
     {"puke",    sicrou,1},
     {"punch",   qmbemean,1},
     {"punish",  qmbemean,1},
     {"purchase",trdrou,1},
     {"purloin", qmgetrou,1},
     {"push",    shvrou,1},
     {"pussy",   nasty,1},
     {"put",     anyrou,1},
     {"puzzle",  qmbemean,1},
     {"quack",   qmsayrou,1},
     {"quake",   quake,3},
     {"qyrstunn",qyrspl,1},
     {"radiate", anyrou,1},
     {"raise",   anyrou,1},
     {"ramble",  moving,1},
     {"rant",    qmsayrou,0},
     {"rape",    nasty,1},
     {"rave",    qmsayrou,0},
     {"rebuke",  qmsayrou,1},
     {"redeyes", redeye,1},
     {"relate",  qmsayrou,1},
     {"remark",  qmsayrou,1},
     {"repair",  fixrou,1},
     {"repeat",  qmsayrou,1},
     {"report",  qmsayrou,1},
     {"respond", qmsayrou,1},
     {"restrain",qmbemean,1},
     {"restrict",qmbemean,1},
     {"roar",    yelrou,1},
     {"rob",     qmgetrou,1},
     {"roll",    moving,1},
     {"romance", becute,1},
     {"rub",     rubrou,1},
     {"run",     moving,0},
     {"s",       south, 0},
     {"sacrifice",qmbemean,1},
     {"say",     qmsayrou,0},
     {"scamper", moving,1},
     {"scold",   qmsayrou,1},
     {"scourge", qmbemean,1},
     {"scramble",moving,1},
     {"scratch", qmbemean,1},
     {"scream",  yelrou,1},
     {"screw",   nasty,1},
     {"scurry",  moving,1},
     {"seduce",  qmbemean,1},
     {"see",     qmlokrou,0},
     {"sell",    trdrou,1},
     {"shake",   becute,1},
     {"shine",   clnrou,1},
     {"shit",    swerou,1},
     {"shout",   yelrou,1},
     {"shove",   shvrou,1},
     {"shrug",   shgrou,1},
     {"shuffle", moving,1},
     {"sigh",    sihrou,1},
     {"silence", qmbemean,1},
     {"sing",    sinrou,1},
     {"sit",     sitrou,1},
     {"skip",    moving,1},
     {"slap",    qmbemean,1},
     {"slay",    qmbemean,0},
     {"smack",   qmbemean,1},
     {"smash",   qmbemean,1},
     {"smile",   smlrou,0},
     {"smirk",   smkrou,1},
     {"smite",   qmbemean,1},
     {"smoke",   smorou,1},
     {"snap",    qmsayrou,1},
     {"snarl",   snlrou,1},
     {"sneer",   snrrou,1},
     {"sneeze",  snzrou,0},
     {"snicker", snkrou,0},
     {"sniff",   snfrou,0},
     {"sniffle", snfrou,0},
     {"snore",   snorou,1},
     {"sob",     qmsayrou,1},
     {"sock",    qmbemean,1},
     {"south",   south, 0},
     {"spank",   qmbemean,1},
     {"speak",   qmsayrou,0},
     {"spell",   qmsayrou,1},
     {"spit",    spirou,1},
     {"splutter",qmsayrou,1},
     {"sputter", qmsayrou,1},
     {"squawk",  qmsayrou,1},
     {"squeal",  yelrou,1},
     {"stammer", qmsayrou,1},
     {"state",   qmsayrou,1},
     {"steal",   qmgetrou,1},
     {"stomp",   stmrou,1},
     {"strangle",qmbemean,1},
     {"strike",  qmbemean,1},
     {"strip",   nasty,0},
     {"stroll",  moving,1},
     {"stutter", qmsayrou,0},
     {"suck",    nasty,1},
     {"suggest", qmsayrou,0},
     {"suppress",qmbemean,1},
     {"suyendo", suyspl,1},
     {"swear",   swerou,1},
     {"take",    qmgetrou,1},
     {"talk",    qmsayrou,1},
     {"tap",     qmbemean,1},
     {"taste",   anyrou,1},
     {"taunt",   qmbemean,1},
     {"teach",   qmsayrou,1},
     {"tell",    qmsayrou,0},
     {"thank",   becute,1},
     {"think",   thkrou,1},
     {"thrash",  qmbemean,1},
     {"threaten",qmsayrou,1},
     {"throw",   qmdrprou,1},
     {"tickle",  becute,1},
     {"tinguleg",tinspl,1},
     {"tinker",  fixrou,1},
     {"tiptoe",  moving,1},
     {"torment", qmbemean,1},
     {"torture", qmbemean,1},
     {"toss",    qmdrprou,1},
     {"trade",   trdrou,1},
     {"tramp",   moving,1},
     {"travel",  moving,1},
     {"trip",    qmbemean,1},
     {"urge",    qmsayrou,1},
     {"use",     anyrou,1},
     {"utilize", anyrou,1},
     {"utter",   qmsayrou,1},
     {"vision",  vision,3},
     {"vocalize",qmsayrou,1},
     {"w",       west,  0},
     {"wail",    yelrou,1},
     {"walk",    moving,1},
     {"wander",  moving,1},
     {"warn",    qmsayrou,0},
     {"waste",   qmbemean,1},
     {"wed",     becute,1},
     {"weep",    cryrou,1},
     {"west",    west,  0},
     {"wheeze",  wherou,1},
     {"whimper", whmrou,1},
     {"whine",   qmsayrou,1},
     {"whip",    qmbemean,1},
     {"whisper", qmwhsrou,1},
     {"whistle", wisrou,1},
     {"wiggle",  moving,1},
     {"wink",    wnkrou,1},
     {"worship", becute,1},
     {"wound",   qmbemean,1},
     {"wrestle", qmbemean,1},
     {"write",   anyrou,1},
     {"yap",     qmsayrou,1},
     {"yawn",    yawrou,1},
     {"yell",    yelrou,1},
     {"yelp",    qmsayrou,0},
     {"yip",     qmsayrou,1},
     {"you",     anyrou,1},
     {"yowl",    yelrou,1},
     {"zap",     qmbemean,1},
     {"zebrandr",zebspl,1},
     {"zigzag",  anyrou,1}
};

struct arrent *
qmbinary(stgptr,table,length)
char *stgptr;
struct arrent table[];
int length;
{
     int cond;
     struct arrent *low,*mid,*high;

     low=&table[0];
     high=&table[length-1];
     while (low <= high) {
          mid=low+((int)(high-low))/2;
          if ((cond=strcmp(stgptr,mid->command)) < 0) {
               if (mid == low) {
                    break;
               }
               high=mid-1;
          }
          else if (cond > 0) {
               if (mid == high) {
                    break;
               }
               low=mid+1;
          }
          else {
               return(mid);
          }
     }
     return(NULL);
}

void
decode(void)
{
     struct arrent *areptr;
     char *mv0ptr;

     if (margc == 0) {
          if (usrptr->flags&ABOIP) {
               prf("\r");
          }
          else {
               prfmsg(TYHELP);
          }
          outprf(usrnum);
     }
     else {
          for (mv0ptr=margv[0] ; *mv0ptr != '\0' ; mv0ptr++) {
               *mv0ptr=tolower(*mv0ptr);
          }
          if ((*(playpt->room->rmcmd))()) {
               if ((areptr=qmbinary(margv[0],cmdarr,CARSIZ)) != NULL) {
                    if (areptr->liveuse == 1 && !hasmkey(DEMKEY)) {
                         prfmsg(MUSTBL);
                         howbuy();
                         outprf(usrnum);
                    }
                    else if (areptr->liveuse == 3 && !(usrptr->flags&MASTER)) {
                         prfmsg(HEYGIV);
                         outprf(usrnum);
                         prfmsg(LOOKCN,playpt->altid);
                         outothr();
                    }
                    else {
                         (*(areptr->routine))();
                    }
               }
               else {
                    switch (margc) {
                    case 1:
                         prfmsg(HEYGIV);
                         break;
                    case 2:
                         prfmsg(WHYTHT,margv[0],margv[1]);
                         break;
                    case 3:
                         prfmsg(WHAGAB);
                         break;
                    case 4:
                         prfmsg(SEREXP,margv[0],margv[1],margv[2],margv[3]);
                         break;
                    default:
                         prfmsg(UHHUH);
                         break;
                    }
                    outprf(usrnum);
                    prfmsg(LOOKCN,playpt->altid);
                    outothr();
               }
          }
     }
}

unsigned
rnd(void)
{
     static unsigned seed=3569;
     long tmp;

     tmp=seed*62891L+871L;
     seed=(unsigned)tmp&0xFFFF;
     return(seed);
/*     return(seed=((seed*62891L+871L)&0xFFFF)); */
}


