/***************************************************************************
 *                                                                         *
 *     QUEST FOR MAGIC Version 3.0                                         *
 *                                                                         *
 *     Copyright (C) 1986-1992 GALACTICOMM, Inc.    All Rights Reserved.   *
 *                                                                         *
 ***************************************************************************
 * GALACTICOMM Software License Agreement                                  *
 *                                                                         *
 * GALACTICOMM, Inc., grants you a fully paid, perpetual, worldwide,       *
 * non-exclusive license to use, transfer, share, modify, delete, and      *
 * incorporate this Software into products copyrighted, patented,          *
 * subject to trade secret or other intellectual protection rights         *
 * asserted by you.                                                        *
 *                                                                         *
 * This Software is provided "as is", without warranty of any kind,        *
 * either expressed or implied, including, but not limited to, the implied *
 * warranties of merchantability and fitness for a particular purpose.     *
 *                                                                         *
 * This license is effective as long as this declaration is preserved in   *
 * its entirety in this Software and any copies or derivatives.            *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *     QM.C                                                                *
 *     Quest for Magic Game Service Handler                                *
 *                                                                         *
 *     By - Tim Stryker and Scott Brinker            11/17/86              *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "qm.h"
#include "galqm.h"

STATIC int qfminj(void);

int qfmstt;
struct module qfmmod={        /* module interface block               */
     "",                      /*    name used to refer to this module */
     NULL,                    /*    user logon supplemental routine   */
     magicq,                  /*    input routine if selected         */
     dfsthn,                  /*    status-input routine if selected  */
     qfminj,                  /*    "injoth" routine for this module  */
     NULL,                    /*    user logoff supplemental routine  */
     qmhup,                   /*    hangup (lost carrier) routine     */
     NULL,                    /*    midnight cleanup routine          */
     qmdela,                  /*    delete-account routine            */
     qmsdn                    /*    finish-up (sys shutdown) routine  */
};

int nov3rs;                   /* number of players for Virtue 3       */

BTVFILE *qmbb;
FILE *qmmsg;

struct qmplayer *qmplayer,*playpt;
struct qmplayer *othppt;

char *qfmatr;                 /* attribute for displayed QFM text          */

void EXPORT
init__questfm(void)
{
     stzcpy(qfmmod.descrp,gmdnam("GALQFM.MDF"),MNMSIZ);
     qfmstt=register_module(&qfmmod);
     inispl();
     qmmsg=opnmsg("galqm.mcv");
     qfmatr=stgopt(QFMATR);
     nov3rs=numopt(NOV3RS,1,64);
     qmbb=opnbtv("galqusr.dat",sizeof(struct qmplayer));
     qmplayer=(struct qmplayer *)alczer(nterms*sizeof(struct qmplayer));
}

int
magicq(void)
{
     int i,bad=0,len;

     setmbk(qmmsg);
     setbtv(qmbb);
     playpt=&qmplayer[usrnum];
     if (sameas(margv[0],"exit") || sameas(margv[0],"x")) {
          if (playpt->flags&INQM) {
               qmxitroom(playpt,rawmsg(QMXXX205));
          }
          prfmsg(QMXXX100);
          playpt->flags&=~INQM;
          btupmt(usrnum,0);
          return(0);
     }
     switch (usrptr->substt) {
     case 0:
          prf(qfmatr);
          if (playpt->flags&ONSYS) {
               invrou();
               playpt->flags|=INQM;
               playpt->channel=usrnum;
               if (playpt->flags&SYSOP) {
                   qmentroom(playpt,playpt->room,rawmsg(QMXXX200));
               }
               else {
                    qmentroom(playpt,playpt->room,rawmsg(QMXXX201));
               }
               usrptr->substt=7;
               btupmt(usrnum,'>');
          }
          else if (acqbtv(playpt,usaptr->userid,0)) {
               rest4p();
               playpt->flags&=~INQM;
               prfmsg(QMXXX101);
               qmoutall();
               invrou();
               playpt->channel=usrnum;
               playpt->flags|=INQM;
               if (playpt->flags&SYSOP) {
                    qmentroom(playpt,playpt->room,rawmsg(QMXXX202));
               }
               else {
                    qmentroom(playpt,playpt->room,rawmsg(QMXXX203));
               }
               usrptr->substt=7;
               btupmt(usrnum,'>');
          }
          else {
               prfmsg(B4PLAY);
               outprf(usrnum);
               usrptr->substt=1;
          }
          break;
     case 1:
          strlwr(margv[0]);
          margv[0][0]=toupper(margv[0][0]);
          len=strlen(margv[0]);
          if (pfnlvl > 0) {
               prfmsg(FOULID);
               outprf(usrnum);
               break;
          }
          if (margc != 1) {
               bad=1;
          }
          else {
               for (i=0 ; i < len ; i++) {
                    if (digalw ? !isalnum(margv[0][i])
                        : !isalpha(margv[0][i])) {
                         bad=1;
                         break;
                    }
               }
          }
          if (bad || len < 3 || len > (PIDSIZ-1)) {
               prfmsg(BADPID);
               prfmsg(B4PLA2);
          }
          else if ((sameas(margv[0],"Sysop") && !sameas(usaptr->userid,"Sysop"))
                   || qeqbtv(margv[0],1)) {
               prfmsg(NTGOOD);
               prfmsg(B4PLA2);
          }
          else {
               inipyr(usrnum,margv[0]);
               prep4d();
               insbtv(playpt);
               rest4p();
               prfmsg(GOODPD,margv[0]);
               usrptr->substt=2;
               btupmt(usrnum,'>');
          }
          outprf(usrnum);
          break;
     case 2:
          prfmsg(INTROA);
          outprf(usrnum);
          usrptr->substt=3;
          break;
     case 3:
          prfmsg(INTROB);
          outprf(usrnum);
          usrptr->substt=4;
          break;
     case 4:
          prfmsg(INTROC);
          outprf(usrnum);
          usrptr->substt=5;
          break;
     case 5:
          prfmsg(QMXXX102);
          qmoutall();
          playpt->flags|=INQM;
          qmentroom(playpt,&qmrooms[0],rawmsg(QMXXX204));
          usrptr->substt=7;
          break;
     case 6:
     case 7:
          switch (margc) {
          case 0:
               margv[0]="nada";
          case 1:
               margv[1]="nobody";
          case 2:
               margv[2]="nothing";
          case 3:
               margv[3]="noway";
          case 4:
               margv[4]="nowhere";
          case 5:
               margv[5]="nohow";
          }
          decode();
          break;
     }
     return(1);
}

STATIC int
qfminj(void)                  /* Quest for Magic injoth() routine handler  */
{
     dftinj();
     btuxmn(othusn,qfmatr);
     return(1);
}

void
inipyr(usrnum,plyrid)
int usrnum;
char *plyrid;
{
     char newpid[PIDSIZ];
     struct qmplayer *playpt;
     struct usracc *usaptr;

     stzcpy(newpid,plyrid,PIDSIZ);
     playpt=&qmplayer[usrnum];
     usaptr=uacoff(usrnum);
     setmem(playpt,sizeof(struct qmplayer),0);
     strcpy(playpt->plyrid,newpid);
     strcpy(playpt->userid,usaptr->userid);
     strcpy(playpt->altid,newpid);
     playpt->descrpt=(usaptr->sex == 'M' ? NORMM : NORMF);
     strcpy(playpt->hisher,usaptr->sex == 'M' ? "his" : "her");
     playpt->hits=playpt->maxhit=10;
     playpt->aura=SEEOBJ+SEEPYR+PICOBJ;
     playpt->flags=ONSYS+(usrptr->flags&MASTER ? SYSOP : 0);
     playpt->room=&qmrooms[0];
     playpt->channel=usrnum;
}

void
qmhup(void)
{
     playpt=&qmplayer[usrnum];
     if (playpt->flags&ONSYS) {
          setmbk(qmmsg);
          setbtv(qmbb);
          if (playpt->flags&INQM) {
               qmxitroom(playpt,rawmsg(QMXXX206));
          }
          prep4d();
          geqbtv(NULL,usaptr->userid,0);
          updbtv(playpt);
          setmem(playpt,sizeof(struct qmplayer),0);
     }
}

void
prep4d(void)
{
     int i;

     playpt->room=(struct room *)(playpt->room-qmrooms);
     for (i=0 ; i < playpt->nitems ; i++) {
          playpt->items[i]=(struct item *)(playpt->items[i]-qmitems);
     }
}

void
rest4p(void)
{
     int i;

     playpt->room=&qmrooms[(int)playpt->room];
     for (i=0 ; i < playpt->nitems ; i++) {
          playpt->items[i]=&qmitems[(int)playpt->items[i]];
     }
}

void
qmdela(userid)
char *userid;
{
     setbtv(qmbb);
     if (acqbtv(NULL,userid,0)) {
          delbtv();
     }
}

void
qmsdn(void)
{
     clsbtv(qmbb);
}

