/*{(************************************************************************
 *
 *    RJSMMUTL.C
 *
 *    Match Maker Utility Functions - V2.20
 *
 * Copyright (c) 1992-1993, by Ronald Struempf, Sirius Software Development
 ***************************************************************************/
#include "rjsmmk.h"
#include "rjsmmmsg.h"

/*-------------------------------------------------------------------------*
 * Local functions
 *-------------------------------------------------------------------------*/
void
eprompt(                      /* display error msg, clear input, & reprompt*/
     INT optno )                   /* message option number                */
{
     btuclo( usrnum );
     if( optno ) {
          prfmsg( optno );
     }
     outprf( usrnum );
     cncall();
     btucli( usrnum );
     reprompt( 0 );
}                             /* end eprompt                               */

void
prompt(                       /* send prompt, set new state/dftinp char    */
     INT msgopt )                  /* option number for prompt/new state   */
{
     char lc;
     INT  prvstt;

     setmbk( mmkmb );
     prvstt=usrptr->substt;
     usrptr->substt=msgopt;
     if( cycling() ) {
          cncall();
     }
     if( !morcnc() || injoip() ) {
          switch( msgopt ) {
          case MMENU2:
               mchusr->listexit=NO;
               mchusr->prvrou=NULL;
               prfmsg( mchusr->syspr || mmkop() ? SMMENU2 : MMENU2 );
               mchmail->editflgs=mchusr->srch=mchusr->qizrsps=0;
               mchusr->alwpfn=mchusr->syspr=sysop();
               break;
          case SMENU:
               mchusr->listexit=NO;
               if( concex() ) {
                    xitmmk();
                    btuoes( usrnum, 0 );
                    btutru( usrnum, 'O'&0x1F );
                    condex();
               }
               if( prvstt != SMENU && prvstt != MMENU2 ) {
                    prfmsg( RETMAIN );
               }
               mchusr->prvrou=NULL;
               mchmail->editflgs=mchusr->srch=mchusr->qizrsps=0;
               mchusr->alwpfn=mchusr->syspr=sysop();
               prfmsg( mchusr->syspr || mmkop() ? SSMENU : SMENU );
               break;
          case EDITFLD:
               mchusr->listexit=NO;
               shomst( usrentp, EDTFMT );
               rstrwid();
               prfmsg( EDITFLD, edtcnt );
               break;
          case EDTNAM:
          case ENTALS:
               prf( mmkcls );
               setwid( UIDSIZ-1 );
               prfmsg( msgopt );
               break;
          case CHGNAM:
               setwid( UIDSIZ-1 );
               prfmsg( msgopt, usrent.name );
               break;
          case EDITAGE:
          case CHGAGE:
               setwid( 2 );
               prfmsg( msgopt );
               break;
          case EDITSEX:
          case CHGSEX:
               setwid( 1 );
               prfmsg( msgopt );
               break;
          case SRCHMST:
               prfmsg( msgopt, MAXKWD );
               break;
          case BROWSING:
               mchusr->ival=0;
               prf( mmkcls );
               prfmsg( BROWSING,
                useage ? "Age " : "", usesex ? "Sex " : "", usrqiz.brfqst ? "Comments" : "",
                useage ? "----" : "", usesex ? "----" : "", usrqiz.brfqst ? "-------------" : "" );
               cycle();
               return;
          case MODWCH2:
               mchusr->prvrou=x2modwch;
               prfmsg( msgopt );
               break;
          case DQIZCYCL:
          case RENQIZU:
          case RENENTSU:
          case RENQIZD:
          case RENENTSD:
          case RENQSTU:
          case RENQSTD:
          case RFMTTXT:
          case UPDENTS:
          case CLRRSP:
               mchusr->ival=0;
               prfmsg( msgopt );
               working( NO );
               cycle();
               return;
          case QUIZLIST:
          case QSTNLIST:
               mchusr->ival=0;
               prf( mmkcls );
               prfmsg( msgopt, usrqiz.quizno, usrqiz.name );
               cycle();
               return;
          case ADDQIZ:
               prf( mmkcls );
          case NEWQNAM:
               setwid( 50 );
               prfmsg( msgopt, usrqiz.quizno );
               break;
          case NUMRSPS:
          case NUMRSPMC:
               prf( mmkcls );
               prfmsg( msgopt, usrqst.qstnno );
               break;
          case TRSPLEN:
               prfmsg( msgopt, spcavl()-1 );
               break;
          case TRSPLEN2:
               prf( mmkcls );
               prfmsg( msgopt, usrqst.qstnno, spcavl()-1 );
               break;
          case ADDQST:
               prfmsg( msgopt, usrqst.qstnno );
               outprf( usrnum );
               bgnedt( QSTSIZ, mchusr->edtbuf, 0, NULL, endaddq,
                    ED_CLRTXT|ED_LINEMO );
               break;
          case MODWHT:
               mchusr->prvrou=x2modwht;
               mchusr->qizrsps=qizrsps( usrqiz.quizno );
               prfmsg( msgopt );
               break;
          case MODQST:
               mchusr->prvrou=x2modqst;
               prfmsg( txtresp() ? MODQSTT : msgopt );
               break;
          case ADDRSP:
               setwid( RSPLEN );
               prfmsg( msgopt, mchusr->rspno );
               break;
          case NEWRSP2:
               setwid( RSPLEN );
               prfmsg( NEWRSP2, mchusr->rspno, mchusr->edtbuf );
               break;
          case EDITQST:
               prf( mmkcls );
               prfmsg( msgopt, usrqst.qstnno );
               outprf( usrnum );
               memmove( mchusr->edtbuf+1, usrqst.qrsspc,
                    strlen(usrqst.qrsspc)+1 );
               mchusr->edtbuf[0]='\n';
               bgnedt( QSTSIZ, mchusr->edtbuf, 0, NULL, endedtq, ED_LINEMO );
               break;
          case NEWNRSPS:
               prfmsg( txtresp() || !usrqst.rspcnt ? msgopt : NEWNRSP,
                    usrqst.qstnno );
               break;
          case NEWNRSPM:
               prfmsg( msgopt, usrqst.qstnno );
               break;
          case NEWRSPL:
               prfmsg( msgopt, usrqst.qstnno, usrqst.txtlen+spcavl()-1 );
               break;
          case INSRSP:
               setwid( RSPLEN );
               prfmsg( msgopt, mchusr->rspno );
               break;
          case SEAAGE:
               if( usrqiz.fage ) {
                    prfmsg( msgopt,
                         bsp("%d %s",usrqiz.fage,usrqiz.fagemax ? "MAX" : "MIN") );
               }
               else {
                    prfmsg( msgopt, "NONE" );
               }
               break;
          case ENTRKEY:
               prfmsg( msgopt, usrqiz.fkey[0] ? usrqiz.fkey : "NONE" );
               break;
          case SEAKEY:
               prfmsg( msgopt, usrqiz.fkey[0] ? usrqiz.fkey : "NONE" );
               break;
          case NXTRSP2:
               if( mchusr->srch ) {
                    prfmsg( NXTRSPS );
               }
               else {
                    prfmsg( alwnan ? NXTRSP2 : NXTRSPM2,
                     (usrqst.maxrsp ? usrqst.maxrsp : usrqst.rspcnt) );
               }
               break;
          case NXTRSPT:
               prfmsg( alwnan ? NXTRSPT : NXTRSPTM );
               break;
          case TXTALT:
               setwid( usrqst.txtlen );
               prfmsg( msgopt );
               break;
          case EDTTRSP:
               if( usrqst.txtlen > MAXNED ) {
                    prf( "" );
                    outprf( usrnum );
                    memmove( mchusr->rspp+1, mchusr->rspp, strlen(mchusr->rspp)+1 );
                    mchusr->rspp[0]='\n';
                    bgnedt( usrqst.txtlen+1, mchusr->rspp, 0, NULL, endedtr,
                         (mchusr->rspp[1] ? 0 : ED_CLRTXT)|ED_LINEMO );
               }
               else {
                    setwid( usrqst.txtlen );
               }
               break;
          case SAVNXIT:
               prfmsg( mchusr->srch ? SAVNSRCH : SAVNXIT );
               break;
          case TXTOMCH:
               prfmsg( usrqiz.txtoffs ? (textquiz() ? TXTOBRWS :
                (usebrws ? (txtsch ? TMCHOBR : MCHOBRWS) : TXTOMCH)) : MCHOBRWS );
               break;
          case SRCHSEX:
               prfmsg( SRCHSEX, (usrent.srchmale == usrent.srchfem ? 'B' :
                         (usrent.srchfem ? 'F' : 'M')) );
               break;
          case SRCHAGE:
               if( usrent.agemax <= 0 ) {
                    usrent.agemax=99;
               }
               prfmsg( msgopt, usrent.agemin, usrent.agemax );
               break;
          case SRCHPCT:
               prfmsg( SRCHPCT, usrent.pctmin );
               break;
          case SRCHLST2:
               mchusr->ival=0;
               prfmsg( SRCHLST2, usrqiz.quizno, usrqiz.name,
                    useage ? "Age " : "", usesex ? "Sex " : "",
                    (!mchusr->browse && (!mchusr->txtsrch || mchusr->argv[0]))
                         ? "Match " : "",
                    usrqiz.brfqst ? "Comments" : "",
                    useage ? "----" : "", usesex ? "----" : "",
                    (!mchusr->browse && (!mchusr->txtsrch || mchusr->argv[0]))
                         ? "------" : "",
                    usrqiz.brfqst ? "-------------" : "" );
               cycle();
               return;
          case WRITMAIL:
               prf( mmkcls );
               outprf( usrnum );
               bgnedt( msgsize+1, msg.text, SUBSIZ, msg.subject, endwrit,
                    ED_CLRTOP|ED_CLRTXT );
               break;
          case MSGLIST:
               memset( mchmail->msglist, 0, sizeof(mchmail->msglist) );
          case RLSTMSGS:
               mchmail->ival=0;
               prf( mmkcls );
               prfmsg( MSGLIST, mchmail->name, ncdate(today()), nctime(now()) );
               cycle();
               return;
          case YESREM2:
               prfmsg( YESREM2, mchusr->allusrs ? "ALL USERS" : ukey.userid );
               break;
          case REMUSRS2:
               mchusr->ival=0;
               prfmsg( REMUSRS2, mchusr->allusrs ? "ALL USERS" : ukey.userid );
               working( NO );
               cycle();
               return;
          case KEYWDS:
               prfmsg( msgopt, MAXKWD );
               break;
          case MAINLIST:
               mchusr->ival=0;
               cycle();
               return;
          case RSPLIST2:
               mchusr->ival=0;
               prf( mmkcls );
               prfmsg( RSPLIST2, usrent.name, usrqiz.quizno, usrqiz.name );
               cycle();
               return;
          case USERLST:
               mchusr->ival=0;
               prfmsg( useanon ? USERLSTA : USERLST );
               cycle();
               return;
          case ENTLIST2:
               mchusr->ival=0;
               prf( mmkcls );
               prfmsg( ENTLIST2, usrent.name );
               cycle();
               return;
          default:
               prfmsg( msgopt );
          }
          if( prfptr > prfbuf ) {
               lc=prfptr[-1];
               if( !isspace(lc) ) {
                    mchusr->dftinp=lc;
                    *(--prfptr)=0;
               }
               else {
                    mchusr->dftinp=0;
               }
          }
          else {
               mchusr->dftinp=0;
          }
     }
     else {
          prf("");
     }
     rstmbk();
}                             /* end prompt                                */

void
reprompt(                     /* request a reprompt - YES=reprompt         */
	INT level )                   /* 0 - Reprompt request                 */
                                   /* 1 - CR input - Abort if possible     */
                                   /* 1 - ^O input - Abort                 */
{
     if( !cycling() ) {
          switch( usrptr->substt ) {
          case EDITFLD:
          case FILLWCH:
          case SRCHWCH:
               prompt( mchusr->listexit ? SMENU : usrptr->substt );
               break;
          default:
               prompt( usrptr->substt );
          }
          return;
     }
     switch( level ) {
     case 0:
          prf( "\n " );
          break;
     case 1:
          switch( usrptr->substt ) {
          case DQIZCYCL:
          case RENQIZU:
          case RENQIZD:
          case RFMTTXT:
          case RENQSTU:
          case RENQSTD:
          case RENENTSU:
          case RENENTSD:
          case UPDENTS:
               prf( "\n " );
               break;
          case BROWSING:
          case QUIZLIST:
          case QSTNLIST:
          case SRCHLST2:
          case CLRRSP:
          case MSGLIST:
          case RLSTMSGS:
          case REMUSRS2:
          case MAINLIST:
          case RSPLIST2:
          case ENTLIST2:
          case USERLST:
          default:
               reprompt( 2 );
               break;
          }
          break;
     case 2:
          btuclo( usrnum );
          switch( usrptr->substt ) {
          case BROWSING:
               prompt( BRWSNXT );
               break;
          case QUIZLIST:
               prompt( QLSTNXT );
               break;
          case DQIZCYCL:
               prfmsg( QMUSTDEL );
               return;
          case RENQIZU:
               setbtv( entbb );
               memset( bbekyp, 0, sizeof(Namekey) );
               bbekyp->quizno=MAXQIZ;
               if( qltbtv(NULL,ENTKEY) && bbekyp->quizno >= usrqiz.quizno ) {
                    prompt( QMUSTREN );
                    return;
               }
               else {
                    usrqiz.quizno=0;
                    prfmsg( QRENABTG );
               }
               break;
          case RENENTSU:
               usrqiz.quizno=0;
               prfmsg( QRENABTG );
               break;
          case RENQIZD:
               setbtv( entbb );
               memset( bbekyp, 0, sizeof(Namekey) );
               bbekyp->quizno=usrqiz.quizno;
               if( qgtbtv(NULL,ENTKEY) ) {
                    prompt( QMUSTREN );
                    return;
               }
               else {
                    usrqiz.quizno=MAXQIZ;
                    prfmsg( QRENABTG );
               }
               break;
          case RENENTSD:
               usrqiz.quizno=MAXQIZ;
               prfmsg( QRENABTG );
               break;
          case CLRRSP:
               break;
          case QSTNLIST:
               prompt( QSTLNXT );
               break;
          case RFMTTXT:
               prfmsg( MUSTRFMT );
               return;
          case RENQSTU:
               usrqst.qstnno=0;
               prfmsg( RENABTG );
               break;
          case RENQSTD:
               usrqst.qstnno=MAXQIZ;
               prfmsg( RENABTG );
               break;
          case SRCHLST2:
               prompt( SRCHLNXT );
               break;
          case UPDENTS:
               prompt( usrptr->substt );
               break;
          case MSGLIST:
               prompt( MSGLNXT );
               break;
          case RLSTMSGS:
               mchmail->nxtrou();
               break;
          case REMUSRS2:
               mchusr->allusrs=NO;
               prfmsg( REMABTG );
               break;
          case MAINLIST:
               prompt( BRWSWHO );
               break;
          case RSPLIST2:
               mchusr->nxtrou();
               break;
          case USERLST:
               prompt( SMENU );
               break;
          case ENTLIST2:
               prompt( WCHQIZ );
               break;
          }
     }
}                             /* end reprompt                              */

void
shomst(                       /* prf a main entry                          */
     Entry *ep,                    /* entry to prf                         */
     INT fmt )                     /* msg option for format                */
{
     char desc[58], *cp;

     switch( fmt ) {
     case EDTFMT:
          prf( mmkcls );
          prfmsg( EDTFMT );
          if( useanon ) {
               prfmsg( EDTMNME2, 1, ep->name );
          }
          if( useage ) {
               prfmsg( EDTMAGE2, useanon+1, ep->age );
          }
          if( usesex ) {
               prfmsg( EDTMSEX2, useanon+useage+1, ep->sex );
          }
          prfmsg( EDTMDET2, useanon+useage+usesex+1 );
          break;
     case FULFMT2:
          prf( mmkcls );
          if( mchusr->syspr ) {
               if( useanon ) {
                    prfmsg( SYSFMTA2, ep->name, ep->userid );
               }
               else {
                    prfmsg( SYSFMT2, ep->userid );
               }
          }
          else {
               prfmsg( FULFMT2, ep->name );
          }
          if( useage ) {
               prfmsg( MSTAGE2, ep->age );
          }
          if( usesex ) {
               prfmsg( MSTSEX2, (ep->sex == 'M' ? "Male" : "Female") );
          }
          break;
     case BRFFMT2:
          if( usrqiz.brfqst > 0 ) {
               strzcpy( desc, ep->rspspc+usrqiz.brftxt,
                    sizeof(desc)-(useage ? 4 : 0)-(usesex ? 4 : 0) );
               trm2( desc );
          }
          else {
               *desc=0;
          }
          if( (cp=strchr(desc,'\r')) != NULL ) {
               *cp=0;
          }
          if( (cp=strchr(desc,'\n')) != NULL ) {
               *cp=0;
          }
          prfmsg( BRFFMT2, ep->name );
          if( useage ) {
               prf( " %2d ", ep->age );
          }
          if( usesex ) {
               prf( " %c  ", ep->sex );
          }
          prf( "%s\n", desc );
          break;
     }
}                             /* end shomst                                */

void
shoqiz(                       /* prf a quiz header                         */
     INT fmt )                     /* msg option for format                */
{
     Questionnaire *qz;
     char *qtyp;
     char *itoa();

     qz=usrqzp;
     switch( fmt ) {
     case FULLQFM2:
          prf( mmkcls );
          switch( qz->qiztyp ) {
          case MULTC:
               qtyp="Multiple Choice";
               break;
          case TEXTQ:
               qtyp="Text Responses";
               break;
          case MIXED:
               qtyp="Multiple Choice and Text Responses";
               break;
          default:
               qtyp="UNKNOWN";
          }
          prfmsg( FULLQFM2, qz->quizno, qz->name, qz->qsthi, yesno(qz->alwpfn),
               qtyp, ((qz->qiztyp&TEXTQ) && qz->brfqst) ? spr("%d",qz->brfqst) : "NONE",
               qz->fage, altyp(qz->fage,qz->fagemax), sexrst(qz->fsexrst,qz->ffemale),
               qz->fkey, qz->sage, altyp(qz->sage,qz->sagemax), sexrst(qz->ssexrst,qz->sfemale),
               dftsex(qz->defsex), qz->skey );
          break;
     case BRFQFMT2:
          prfmsg( BRFQFMT2, qz->quizno, qz->name );
          break;
     }
}                             /* end shoqiz                                */


void
shoqst(                       /* prf a qstn                                */
     INT fmt,                      /* msg option for format                */
     long sel )                    /* selected responses                   */
{
     INT     rspcnt, cols, len, wid, rsphi;
     INT     maxlen;
     char    *rspstr, *txtstr;
     boolean sys;
     Question *qs;
     char     *ptr;

     qs=usrqsp;
     switch( fmt ) {
     case FQSTFMT:
          if( sel == -1L ) {
               sel=0;
               sys=YES;
          }
          else {
               sys=NO;
          }
          prf( mmkcls );
          prfmsg( fmt, qs->qstnno );
          mlprf( qs->qrsspc, rawmsg(MLIND) );
          prfmsg( MLTXT2 );
          if( txtresp() ) {
               if( !sys && (mchusr->rspp != rtrsh && *mchusr->rspp) ) {
                    prfmsg( MLTXT1 );
                    mlprf( mchusr->rspp, rawmsg(MLIND) );
                    prfmsg( MLTXT2 );
               }
               else {
                    prf( "\n" );
               }
               prf( "\n" );
          }
          else {
               rspcnt=0;
               ptr=qs->qrsspc;
               len=qs->rsplen;
               rsphi=qs->rspcnt;
               prf( "\n" );
               if( rsphi <= 5 || len > MAXTWO ) {
                    cols=1;
                    wid=1;
               }
               else if( rsphi <= 10 || len > MAXTHR ) {
                    cols=2;
                    wid=MAXTWO;
               }
               else if( rsphi <= 15 || len > MAXFOR ) {
                    cols=3;
                    wid=MAXTHR;
               }
               else {
                    cols=4;
                    wid=MAXFOR;
               }
               while( rspcnt < qs->rspcnt ) {
                    rspcnt++;
                    ptr=nxtzstr( ptr );
                    if( (sel&((long)1<<(rspcnt-1))) != 0 ) {
                         prfmsg( RSPFMTS2, ifansi(' ','*'), rspcnt,
                              bsp("%-*s",wid,ptr) );
                    }
                    else {
                         prfmsg( RSPFMT2, rspcnt, bsp("%-*s",wid,ptr) );
                    }
                    if( !(rspcnt%cols) ) {
                         prf( "\n" );
                    }
               }
               if( rspcnt%cols ) {
                    prf( "\n" );
               }
               if( !sys && usrqst.txtlen && mchusr->rspp != rtrsh &&
                         (sel&((long)1<<(usrqst.rspcnt-1))) != 0 ) {
                    prfmsg( ALTRSP, mchusr->rspp );
               }
          }
          break;
     case EQSTFMT2:
          prf( mmkcls );
          rspstr=(txtresp() ? "Text Response" : qs->maxrsp ? bsp("%d",qs->maxrsp) : "UNLIMITED" );
          txtstr=(txtresp() ? "Text Only" : qs->txtlen ? "Last Response" : "NONE" );
          prfmsg( EQSTFMT2, qs->quizno, qs->qstnno, qs->qrsspc, rspstr, txtstr,
               qs->txtlen, qs->exclude || txtresp() ? "NO" : "YES" );
          maxlen=0;
          rspcnt=0;
          ptr=qs->qrsspc;
          if( !txtresp() ) {
               len=qs->rsplen;
               rsphi=qs->rspcnt;
               if( rsphi <= 5 || len > MAXTWO ) {
                    cols=1;
                    wid=1;
               }
               else if( rsphi <= 10 || len > MAXTHR ) {
                    cols=2;
                    wid=MAXTWO;
               }
               else if( rsphi <= 15 || len > MAXFOR ) {
                    cols=3;
                    wid=MAXTHR;
               }
               else {
                    cols=4;
                    wid=MAXFOR;
               }
               prf( "Responses:\n" );
               while( rspcnt < qs->rspcnt ) {
                    rspcnt++;
                    ptr=nxtzstr( ptr );
                    if( (len=strlen(ptr)) > maxlen ) {
                         maxlen=len;
                    }
                    if( sel&((long)1<<(rspcnt-1)) ) {
                         prfmsg( RSPFMTS2, ' ', rspcnt, bsp("%-*s",wid,ptr) );
                    }
                    else {
                         prfmsg( RSPFMT2, rspcnt, bsp("%-*s",wid,ptr) );
                    }
                    if( !(rspcnt%cols) ) {
                         prf( "\n" );
                    }
               }
               if( rspcnt%cols ) {
                    prf( "\n" );
               }
          }
          if( qs == usrqsp && usrqst.rsplen != maxlen ) {
               usrqst.rsplen=maxlen;
               mchusr->qstedited=YES;
               updqiz();
          }
          break;
     case BQSTFMT:
          prfmsg( fmt, qs->qstnno );
          mlprf( qs->qrsspc, rawmsg(MLIND) );
          prfmsg( MLTXT2 );
          break;
     }
}                             /* end shoqst                                */

void
shomsg(                       /* prf a message header                      */
     Message *mp,                  /* message to prf                       */
     INT fmt )                     /* msg option for format                */
{
     switch( fmt ) {
     case BMSGFMT2:
          if( mp->read ) {
               prfmsg( BMSGFMTC, mchmail->ival+1, ltoa(mp->sequence),
                    ncdate(mp->credat), msgfrom(mp), mp->subject );
          }
          else {
               prfmsg( BMSGFMT2, ifansi(' ','*'), mchmail->ival+1,
                    ltoa(mp->sequence), ncdate(mp->credat), msgfrom(mp),
                    mp->subject );
          }
          break;
     case TMSGFMT:
          prfmsg( TMSGFMT, ltoa(mp->sequence), ncdate(mp->credat),
               dthour(mp->cretim), dtmin(mp->cretim),
               mp->replyto ? bsp("Reply to #%lu",mp->replyto) : "",
               msgfrom(mp), mp->subject );
          break;
     case FMSGFMT:
          prfmsg( FMSGFMT, ltoa(mp->sequence), ncdate(mp->credat),
               dthour(mp->cretim), dtmin(mp->cretim),
               mp->replyto ? bsp("Reply to #%lu",mp->replyto) : "",
               msgto(mp), mp->subject );
          break;
     }
}                             /* end shomsg                                */

boolean
getmst()                      /* load main entry for current user          */
{
     initmain();
     mchusr->alwpfn=sysop();
     if( mmk_mst(usaptr->userid) ) {
          gcrbtv( usrentp, UIDKEY );
          mchusr->hasmst=YES;
          mchusr->age=usrent.age;
          mchusr->female=(usrent.sex == 'F');
          mchusr->alwpfn=sysop();
          strzcpy( mchusr->name, usrent.name, UIDSIZ );
          return( YES );
     }
     else if( !useanon && autoreg ) {
          mchusr->hasmst=YES;
          memset( usrentp, 0, sizeof(Entry) );
          setuid( usrent.userid, usaptr->userid );
          setuid( usrent.name, usaptr->userid );
          usrent.age=usaptr->age;
          usrent.sex=usaptr->sex;
          usrent.entsiz=mmk_entsiz();
          mchusr->entedited=YES;
          updusr();
          return( YES );
     }
     else {
          mchusr->hasmst=NO;
          memset( usrentp, 0, sizeof(Entry) );
          setuid( usrent.userid, usaptr->userid );
          usrent.entsiz=mmk_entsiz();
          return( NO );
     }
}                             /* end getmst                                */

boolean
qizrsps(                      /* does quiz have any responses              */
     INT quizno )                  /* quiz to check                        */
{
     setbtv( entbb );
     memset( bbekyp, 0, sizeof(Namekey) );
     bbekyp->quizno=quizno;
     return( qnxent(NULL,quizno) != 0 );
}                             /* end qizrsps                               */

boolean
updusr()                      /* update entry for current user             */
{
     if( mchusr->entedited ) {
          if( !equstri(usrent.userid,usaptr->userid) ) {
               catastro( "UPDUSR: Invalid update %s -> %s", usaptr->userid,
                    usrent.userid );
          }
          setbtv( entbb );
          clrflgs();
          if( !usrent.quizno )  {
               mchusr->hasmst=YES;
               mchusr->age=usrent.age;
               mchusr->female=(usrent.sex == 'F');
               strzcpy( mchusr->name, usrent.name, UIDSIZ );
          }
          strzcpy( bbukyp->userid, usaptr->userid, UIDSIZ );
          bbukyp->quizno=usrent.quizno;
          if( qeqbtv(NULL,UIDKEY) ) {
               gcrbtv( NULL, UIDKEY );
               if( usrent.quizno ) {
                    usrentp->crdate=today();
               }
               upvbtv( usrentp, usrent.entsiz );
               return( YES );
          }
          else {
               usrentp->crdate=today();
               invbtv( usrentp, usrent.entsiz );
               return( YES );
          }
     }
     return( NO );
}                             /* end updusr                                */

boolean
updqiz()                      /* update mmkqiz stuff for current user      */
{
     boolean ret;

     if( !sysop() && !mmkop() ) {
          return( NO );
     }
     ret=NO;
     setbtv( qizbb );
     if( mchusr->qstedited && *usrqst.qrsspc ) {
          if( usrqst.type != QSTN ) {
               catastro( "UPDQIZ: Invalid type (QSTN)" );
          }
          ret=YES;
          if( txtresp() && usrqst.rspcnt != 0 ) {
               catastro( "UPDQIZ: Invalid response count on text question %d",
                    usrqst.rspcnt );
          }
          if( usrqst.qrssiz != zstrlen(usrqst.qrsspc,usrqst.rspcnt+1) ) {
               catastro( "UPDQIZ: Invalid record length %d/%d",
                    usrqst.qrssiz, zstrlen(usrqst.qrsspc,usrqst.rspcnt+1) );
          }
          if( qeqbtv(usrqsp,TYPKEY) ) {
               gcrbtv( NULL, TYPKEY );
               upvbtv( usrqsp, qstsiz(usrqsp) );
          }
          else {
               invbtv( usrqsp, qstsiz(usrqsp) );
          }
          if( usrqst.qstnno > usrqiz.qsthi ) {
               usrqiz.qsthi=usrqst.qstnno;
               mchusr->qizedited=YES;
          }
     }
     if( mchusr->qizedited && *usrqiz.name ) {
          if( usrqiz.type != QUIZ ) {
               catastro( "UPDQIZ: Invalid type (QUIZ)" );
          }
          ret=YES;
          if( qeqbtv(usrqzp,TYPKEY) ) {
               gcrbtv( NULL, TYPKEY );
               upvbtv( usrqzp, qizsiz(usrqzp) );
          }
          else {
               invbtv( usrqzp, qizsiz(usrqzp) );
          }
     }
     clrflgs();
     return( ret );
}                             /* end updqiz                                */

boolean
delqiz()                      /* deletes quiz in usrqiz                    */
{
     setbtv( qizbb );
     if( qnxqzn(nkyp,usrqiz.quizno) ) {
          memcpy( nkyp, bbnkyp, sizeof(SeqKey) );
          gcrbtv( NULL, NUMKEY );
          delbtv();
          return( YES );
     }
     return( NO );
}                             /* end delqiz                                */

void
newsrch()                     /* reset search information                  */
{
     usrent.agemax=99;
     usrent.pctmin=0;
     if( !usesex ) {
          usrent.srchmale=usrent.srchfem=YES;
     }
     else if( usrqiz.fsexrst ) {                /* only one sex can fill ou*/
          usrent.srchmale=!usrqiz.ffemale;
          usrent.srchfem=usrqiz.ffemale;
     }
     else {
          switch( usrqiz.defsex ) {
          case OPPO:
               usrent.srchmale=mchusr->female;
               usrent.srchfem=!mchusr->female;
               break;
          case SAME:
               usrent.srchmale=!mchusr->female;
               usrent.srchfem=mchusr->female;
               break;
          default:
               usrent.srchmale=usrent.srchfem=YES;
          }
     }
     if( !textquiz() ) {
          memset( searchp(usrentp), 0, rspsiz(usrqiz.qsthi)/2 );
     }
}                             /* end newsrch                               */

void
cycle()                       /* start a cycling process                   */
{
     mchusr->dftinp=0;
     prf( "" );
     cncall();
     btuinj( usrnum, CYCLE );
}                             /* end cycle                                 */

void
nxtqstn()                     /* setup, show, and prompt for next question */
{
     INT opt;

     if( txtresp() ) {
          mchusr->sel=0;
          mchusr->rspp=rsppos();
     }
     else {
          mchusr->sel=(mchusr->srch ? sselect() : eselect() );
          mchusr->rspp=(usrqst.txtlen && !mchusr->srch ? rsppos() : rtrsh );
     }
     rstrwid();
     mchusr->seledited=NO;
     shoqst( FQSTFMT, mchusr->sel );
     opt=(txtresp() ? (*mchusr->rspp ? NXTRSPT : EDTTRSP) : NXTRSP2);
     prompt( opt );
}                             /* end nxtqstn                               */

boolean
cycling()                     /* cycled substates                          */
{
     switch( usrptr->substt ) {
     case ADDQST:                  /* these are editor states, but follow  */
     case EDITQST:                 /* the same rules on prompting          */
     case EDTTRSP:
     case WRITMAIL:

     case BROWSING:
     case QUIZLIST:
     case CLRRSP:
     case DQIZCYCL:
     case RENQIZU:
     case RENENTSU:
     case RENQIZD:
     case RENENTSD:
     case QSTNLIST:
     case RFMTTXT:
     case RENQSTU:
     case RENQSTD:
     case SRCHLST2:
     case UPDENTS:
     case MSGLIST:
     case RLSTMSGS:
     case REMUSRS2:
     case MAINLIST:
     case RSPLIST2:
     case ENTLIST2:
     case USERLST:
          return( YES );
     }
     return( NO );
}                             /* end cycling                               */

void
initmain()                    /* initialize usrqiz for main entry          */
{
     clrflgs();
     memset( usrqzp, 0, sizeof(Questionnaire) );
     iniqzk( usrqzp, 0 );
     setbtv( qizbb );
     if( qeqbtv(usrqzp,TYPKEY) ) {
          gcrbtv( usrqzp, TYPKEY );
     }
     else {
          usrqiz.type=QUIZ;
          usrqiz.qiztyp=TEXTQ;
          usrqiz.txtoffs=0;
          strcpy( usrqiz.name, "Registry Entry" );
     }
}                             /* end initmain                              */

void
mainqstns()                   /* begin answering main questionnaire        */
{
     setbtv( qizbb );
     iniqzk( usrqzp, 0 );
     if( qeqbtv(usrqzp,TYPKEY) ) {
          gcrbtv( usrqzp, TYPKEY );
          if( mmk_qizacc(NO) ) {
               mchusr->alwpfn=usrqiz.alwpfn;
               setbtv( qizbb );
               iniqsk( usrqsp, 0, 0 );
               if( qnxqst(usrqsp,0) ) {
                    gcrbtv( usrqsp, TYPKEY );
                    nxtqstn();
                    return;
               }
               else if( mchusr->hasmst ) {
                    prfmsg( NOMAINQ );
               }
          }
          else if( mchusr->hasmst ) {
               prfmsg( ENOACC );
          }
     }
     else if( mchusr->hasmst ) {
          prfmsg( NOMAINQ );
     }
     mchusr->nxtrou();
}                             /* end mainqstns                             */

void
bgnsrch()                     /* begin quiz search                         */
{
     DateKey dkey;

     setbtv( entbb );
     dkey.crdate=0x7FFF;
     dkey.quizno=usrqiz.quizno;
     mchusr->found=NO;
     if( qlstdat(&dkey,usrqiz.quizno) ) {
          ekey.quizno=usrqiz.quizno;
          mchusr->allusrs=NO;
          prompt( SRCHLST2 );
     }
     else {
          prfmsg( NOENTS );
          setbtv( qizbb );
          iniqzk( usrqzp, 0 );
          if( qnxqiz(usrqzp) ) {
               gcrbtv( usrqzp, TYPKEY );
               mchusr->nxtrou=srchwch;
               prompt( QUIZLIST );
               if( shwall || mmk_qizacc(YES) ) {
                    shoqiz( BRFQFMT2 );
               }
          }
          else {
               eprompt( NOQIZ );
          }
     }
}                             /* end bgnsrch                               */

void
bgnlist()                     /* begin user list                           */
{
     setbtv( entbb );
     memset( &ekey, 0, sizeof(Namekey) );
     if( qnxent(ekyp,ekey.quizno) ) {
          prompt( USERLST );
     }
     else {
          prfmsg( NOUSERS );
          prompt( SMENU );
     }
}                             /* end bgnlist                               */

void
bgnmail(                      /* begin writing message                     */
     char *to,                     /* who to write to                      */
     long repto )                  /* reply to message number              */
{
     if( !hasmkey(MAILKEY)) {
          prfmsg( NOEMLACC );
          mchmail->nxtrou();
     }
     else if( !tstcrd(mailchg) ) {
          prfmsg( EMLCREDS );
          mchmail->nxtrou();
     }
     else {
          memset( msgp, 0, NOVMSZ );
          strzcpy( msg.to, to, UIDSIZ );
          strzcpy( msg.from, usaptr->userid, UIDSIZ );
          mchmail->editflgs=0;
          strzcpy( msg.fromname, mchusr->name, UIDSIZ );
          strzcpy( msg.toname, to, UIDSIZ );
          msg.replyto=repto;
          cncall();
          prompt( WRITMAIL );
     }
}                             /* end bgnmail                               */

void
working(                      /* show work in progress                     */
     boolean done )                /* last call?                           */
{
     static char chrs[5]="|/-\\";

     if( done ) {
          prf( "\b" );
     }
     else {
          mchusr->ival=(mchusr->ival+1)&3;
          prf( "\b%c", chrs[mchusr->ival] );
     }
}                             /* end working                               */


