/*{(************************************************************************
 *
 *    RJSMMK.H
 *
 *    Header file for The Match Maker - V2.20
 *
 * Copyright (c) 1992-1993, by Ronald Struempf, Sirius Software Development
 ***************************************************************************/
#include "rjsdef.h"
#include "rjsutl.h"
#include "message.h"

/*-------------------------------------------------------------------------*
 * Constants and macros
 *-------------------------------------------------------------------------*/
#define QUIZ        1         /* type flag for quizes                      */
#define QSTN        2         /* type flag for questions                   */

#define BOTH        0         /* default search sex - include both         */
#define OPPO        1         /* default search sex - opposite of user     */
#define SAME        2         /* default search sex - same as user         */

#define MULTC       1         /* multiple choice                           */
#define TEXTQ       2         /* text only                                 */
#define MIXED       (MULTC|TEXTQ) /* texted and multiple choice            */

#define REMUSR      0         /* cfg ival value - remove users             */
#define CFGUSR      1         /* cfg ival value - configure user access    */

#define NVQSIZ      75        /* non-variant quiz struct size              */
#define MAXQIZ      500       /* maximum questionnaires - for aborting only*/
#define MAXQST      200       /* maximum number of questions per quiz      */
#define MAXKWD      20        /* maximum number of words in search         */
#define QSTLEN      199       /* maximum length of question/answer/name    */
#define QSTSIZ      (QSTLEN+1)/* size of buffer for questions              */
#define RSPLEN      70        /* maximum response length                   */
#define RSPSIZ      (RSPLEN+1)/* size of buffer for responses              */
#define MAXRSP      32        /* maximum number of responses - (A-W)       */
#define QRSSIZ      2500      /* maximum combine size of question/responses*/
#define TXTRESP     'T'       /* maxrsp if text response only              */
#define NVESIZ      100       /* non-variant entry size                    */
#define RECSIZ      4000      /* maximum size of entry record              */
#define EDTSIZ      200       /* maximum edit buffer size                  */
#define MAXNED      70        /* maximum response length for no editor     */
#define NOVMSZ      175       /* non-variable message size                 */
#define SUBSIZ      40        /* message subject size                      */


#define MAXTWO      32        /* maximum response length for two columns   */
#define MAXTHR      19        /* maximum response length for three columns */
#define MAXFOR      13        /* maximum response length for four columns  */

/*-------------------------------------------------------------------------*
 * Structure definitions, key definitions, key no.s, and extern declarations
 *-------------------------------------------------------------------------*/
typedef struct {              /* quiz header structure                     */
   word   type;               /* always equals QUIZ                        */
   word   quizno;             /* quiz number                               */
   word   qstnno;             /* question number - always zero             */
   word   fage;               /* age limit for filling out entry           */
   char   fkey[KEYSIZ];       /* key required for filling out qstnare      */
   word   alwpfn:1,           /* allow profanity in this questionnaire     */
          fagemax:1,          /* entry age limit is a max value            */
          fsexrst:1,          /* sex restriction on entry                  */
          ffemale:1,          /* sex restricted to female if fsexrst       */
          qiztyp:2,           /* questionnare type (mc,text,mixed)         */
          funused:10;         /* unused entry flags                        */
   word   sage;               /* age limit for searching entries           */
   char   skey[KEYSIZ];       /* key required to search questionnaire      */
   word   sagemax:1,          /* search age limit is a max value           */
          ssexrst:1,          /* sex restriction on search                 */
          sfemale:1,          /* sex restricted to female if ssexrst       */
          defsex:2,           /* default sex (0=both,1=opposite,2=same)    */
          sunused:11;         /* unused search flags                       */
   word   qsthi;              /* highest question number                   */
   word   txtoffs;            /* offset of end of text responses           */
   word   brfqst;             /* # of resp for breif description           */
   word   brftxt;             /* offset of text for brief comment          */
   char   spare[NVQSIZ-55];   /* spare space                               */
   char   name[QRSSIZ];       /* variable length name                      */
} Questionnaire;

#if( sizeof(Questionnaire) != NVQSIZ+QRSSIZ-1 )
     #error Invalid size: Questionnaire
#endif

typedef struct {              /* question structure                        */
   word   type;               /* always equals QSTN                        */
   word   quizno;             /* quiz number                               */
   word   qstnno;             /* question number                           */
   word   rsplen;             /* longest rsp for formatting                */
   word   maxrsp;             /* maximum responses when filling out        */
   word   rspcnt;             /* number of responses                       */
   word   txtlen;             /* length of text response                   */
   word   rspoffs;            /* offset of response text in entry          */
   word   exclude:1,          /* don't use this question in matching       */
          unused:15;          /* unused flags                              */
   word   qrssiz;             /* length of qstn and responses buffer       */
   char   spare[NVQSIZ-21];   /* spare space                               */
   char   qrsspc[QRSSIZ];     /* variable length qstn/responses            */
} Question;

#if( sizeof(Questionnaire) != sizeof(Question) )
     #error Invalid size: Question
#endif

#define  TYPKEY   0           /* record type key                           */
typedef struct {
   word   type;               /* record type                               */
   word   quizno;             /* quiz number                               */
   word   qstnno;             /* question number                           */
} TypeKey;

#define  NUMKEY   1           /* record number key                         */
typedef struct {
   word   quizno;             /* quiz number                               */
   word   qstnno;             /* question number                           */
   word   type;               /* record type                               */
} SeqKey;

typedef struct {              /* quiz/search entry                         */
   char   name[UIDSIZ];       /* users name (first, nickname, or alias)    */
   char   userid[UIDSIZ];     /* user's id                                 */
   word   quizno;             /* quiz number                               */
   word   crdate;             /* creation date                             */
   char   sex;                /* user's sex                                */
   char   age;                /* user's age                                */
   word   searched:1,         /* user has filled out search entry          */
          srchmale:1,         /* search should include males               */
          srchfem:1,          /* search should include females             */
          filled:1,           /* user has filled out entry                 */
          notnew:1,           /* not considered a new user - main only     */
          unused:11;          /* unused flags                              */
   word   agemin;             /* minimum age to search for                 */
   word   agemax;             /* maximum age to search for                 */
   word   pctmin;             /* minimum match percentage                  */
   word   entsiz;             /* calculated record size                    */
   char   spare[NVESIZ-76];   /* spare space - for adding to header info   */
   char   rspspc[RECSIZ-NVESIZ];  /* space for responses                   */
} Entry;

#if( sizeof(Entry) != RECSIZ )
     #error Invalid size: Entry
#endif

#define  UIDKEY   0           /* record type key                           */
typedef struct {
   char   userid[UIDSIZ];     /* user's id                                 */
   word   quizno;             /* quiz number                               */
} UserKey;

#define  ENTKEY   1           /* quiz number key                           */
typedef struct {
   word   quizno;             /* quiz number                               */
   char   name[UIDSIZ];       /* user's name/userid                        */
} Namekey;

#define  DATEKEY  2           /* quiz number/date key                      */
typedef struct {
   word   quizno;             /* quiz number                               */
   word   crdate;             /* creation date                             */
} DateKey;


typedef
struct _message {
     char from[UIDSIZ];            /* user writing the message             */
     char fromname[UIDSIZ];        /* MM name of sender                    */
     char to[UIDSIZ];              /* user the message is to               */
     char toname[UIDSIZ];          /* MM name of receiver                  */
     char subject[SUBSIZ];         /* subject of message                   */
     INT  credat;                  /* creation date                        */
     INT  cretim;                  /* creation time                        */
     word read:1,                  /* message has been read                */
          unused:15;               /* extra flags                          */
     long sequence;                /* message sequence number              */
     long replyto;                 /* sequence number of parent message    */
     char text[1];                 /* variable length message              */
} Message;

#if( sizeof(Message) != 175 )
     #error Invalid size: Message
#endif

#define SEQKEY      0         /* sequence number key                       */
#define FRMKEY      1         /* sender userid key                         */
#define TOKEY       2         /* receiver userid key                       */

typedef
struct {                      /* composite user-id/msg# for searches       */
     char userid[UIDSIZ];          /* user-id to or from, or SIG name      */
     long sequence;                /* message number                       */
} Compos;

/***************************************************************************
 * NOTE:
 *    If you modify the following structures, add to the bottom of them.
 *    The offset of the existing variables from the top is an integral part
 *    of the some of the utility functions.
 ***************************************************************************/

typedef struct {              /* per user structure - when modifying quizes*/
   void        (*nxtrou)(void); /* next routine after common function      */
   void        (*prvrou)(void); /* last menu routine                       */
   word        syspr:1,       /* user has sysop access                     */
               alwpfn:1,      /* currently in quiz allowing profanity      */
               hasmst:1,      /* user has a main entry                     */
               entedited:1,   /* entry has been edited                     */
               qizedited:1,   /* quiz entry has been edited                */
               qstedited:1,   /* qstn entry has been edited                */
               seledited:1,   /* selection bit field has been modified     */
               srch:1,        /* is user searching questionnaires          */
               female:1,      /* is user female                            */
               qizrsps:1,     /* quiz has responses - sysop only           */
               txtsrch:1,     /* word search                               */
               found:1,       /* entry was found while browsing            */
               srched:1,      /* user has already done a search            */
               allusrs:1,     /* all users are being configured/listed     */
               listexit:1,    /* condex before relisting questionnaires    */
               browse:1,      /* user is browsing                          */
               unused:16;     /* unused flags                              */
   char        dftinp;        /* default input                             */
   char        age;           /* user's age                                */
   char        name[UIDSIZ];  /* user's name                               */
   char        edtbuf[EDTSIZ];/* edit buffer                               */
   char        *argv[MAXKWD+1];/* keyword pointers for word search         */
   INT         ival;          /* general purpose counter                   */
   long        srchpos;       /* search position                           */
   Namekey     entrykey;      /* entry key                                 */
   UserKey     useridkey;     /* userid key                                */
   TypeKey     qizkey;        /* general purpose key                       */
   long        sel;           /* current selection bits                    */
   word        rspno;         /* which response are we working with        */
   char        *rspp;         /* pointer to text response in entry         */
   Questionnaire quiz;        /* quiz structure                            */
   Question    qstn;          /* question structure                        */
   Entry       entry;         /* entry for user                            */
} MatchUser;

typedef struct {              /* per user structure - when writing mail    */
   void   (*nxtrou)(void);    /* next routine after common function        */
   void   (*prvrou)(void);    /* last menu routine                         */
   word   syspr:1,            /* user has sysop access                     */
          alwpfn:1,           /* currently in quiz allowing profanity      */
          hasmst:1,           /* user has a main entry                     */
          editflgs:4,         /* edit flags                                */
          srch:1,             /* is user searching questionnaires          */
          female:1,           /* is user female                            */
          qizrsps:1,          /* quiz has responses - sysop only           */
          txtsrch:1,          /* word search - unused                      */
          found:1,            /* msg was found while scanning mail         */
          srched:1,           /* mchusr only                               */
          allusrs:1,          /* sysop/mchusr only                         */
          listexit:1,         /* condex before relisting questionnaires    */
          browse:1,           /* user is browsing                          */
          unused:16;          /* unused flags                              */
   char   dftinp;             /* default input                             */
   char   age;                /* user's age                                */
   char   name[UIDSIZ];       /* user's name                               */
   char   edtbuf[EDTSIZ];     /* edit buffer                               */
   char   *argv[MAXKWD+1];    /* keyword pointers for word search          */
   INT    ival;               /* general purpose counter                   */
   long   srchpos;            /* search position                           */
   Namekey entrykey;          /* entry key                                 */
   Compos msgkey;             /* vesigs key                                */
   long   msglist[15];        /* list of messages found                    */
   Message mesg;              /* message block for writing messages        */
} MatchMail;

typedef struct {              /* common struct to all vda formats          */
   void   (*nxtrou)(void);    /* next routine after common function        */
   void   (*prvrou)(void);    /* last menu routine                         */
   word   flags[2];           /* flags                                     */
   char   dftinp;             /* default input                             */
   char   age;                /* user's age                                */
   char   name[UIDSIZ];       /* user's name                               */
   char   edtbuf[EDTSIZ];     /* edit buffer                               */
   char   *argv[MAXKWD+1];    /* keyword pointers for word search          */
   INT    ival;               /* general purpose counter                   */
   long   srchpos;            /* search position                           */
   Namekey entrykey;          /* entry key                                 */
} VdaBase;

/*-------------------------------------------------------------------------*
 * Data access macros
 *-------------------------------------------------------------------------*/
#define mmkacc()    (!mmkkey[0] || haskey(mmkkey))
#define mmkop()     (modkey[0] && haskey(modkey))

#define mchusr      ((MatchUser*)vdaptr)     /* user data structure (QUIZ) */
#define mchmail     ((MatchMail*)vdaptr)     /* user data structure (MAIL) */

#define usrent      (mchusr->entry)          /* entry                      */
#define usrentp     (&mchusr->entry)         /* entry pointer              */

#define ekey        (mchusr->entrykey)       /* vda Namekey structure      */
#define ekyp        (&ekey)                  /* vda key structure pointer  */
#define ukey        (mchusr->useridkey)      /* vda UserKey structure      */
#define ukyp        (&ukey)                  /* vda key structure pointer  */
#define bbentp      ((Entry*)entbb->data)    /* btrieve block reference    */
#define bbukyp      ((UserKey*)entbb->key)   /* btrieve block reference    */
#define bbekyp      ((Namekey*)entbb->key)   /* btrieve block reference    */
#define bbdkyp      ((DateKey*)entbb->key)   /* btrieve block reference    */

#define usrqiz      (mchusr->quiz)           /* vda quiz structure         */
#define usrqzp      (&mchusr->quiz)          /* vda quiz structure pointer */
#define usrqst      (mchusr->qstn)           /* vda qstn structure         */
#define usrqsp      (&mchusr->qstn)          /* vda qstn structure pointer */

#define qkey        (mchusr->qizkey)         /* vda typkey structure       */
#define qkyp        (&qkey)                  /* vda key structure pointer  */
#define nkyp        ((SeqKey*)(&qkey))       /* vda SeqKey structure       */

#define bbqzp       ((Questionnaire*)qizbb->data)/* btrieve block reference*/
#define bbqsp       ((Question*)qizbb->data) /* btrieve block reference    */
#define bbkyp       ((TypeKey*)qizbb->key)   /* btrieve block reference    */
#define bbnkyp      ((SeqKey*)qizbb->key)    /* btrieve block reference    */

#define msg         (mchmail->mesg)          /* vda message struct         */
#define msgp        (&msg)                   /* vda message struct pointer */
#define mkey        (mchmail->msgkey)        /* vda compos struct          */
#define mkyp        (&mkey)                  /* vda compos struct pointer  */

#define bbmsg       ((Message*)mailbb->data) /* rjsmmeml btrieve ref       */
#define bbmkyp      ((Compos*)mailbb->key)   /* rjsmmeml btrieve ref       */
#define bbseq       (*(long*)mailbb->key)    /* rjsmmeml btrieve ref       */

#define clrflgs()   (mchmail->editflgs=0)

#define qizsiz(p)   (NVQSIZ+strlen(p->name))
#define qstsiz(p)   (NVQSIZ+p->qrssiz-1)
#define rspsiz(n)   (textquiz() ? 0 : n*2*sizeof(long))
#define txtresp()   (usrqst.maxrsp == TXTRESP)
#define textquiz()  (usrqiz.qiztyp == TEXTQ)
#define txtspc(n,o) (RECSIZ-(NVESIZ+o+rspsiz(n)))
#define spcavl()    (txtspc(max(usrqiz.qsthi,usrqst.qstnno),usrqiz.txtoffs))

#define answers(p)  ((long*)p->rspspc)
#define clrqiz      strqzc
#define searchp(p)  ((long*)(p->rspspc+rspsiz(usrqiz.qsthi)/2))
#define txtpos(p)   (p->rspspc+(textquiz() ? 0 : rspsiz(usrqiz.qsthi)))
#define rsppos()    ((char*)txtpos(usrentp)+usrqst.rspoffs)

#define eselect()   (answers(usrentp)[usrqst.qstnno-1])
#define sselect()   (searchp(usrentp)[usrqst.qstnno-1])

#define msgto(p)    (useanon ? p->toname : p->to)
#define msgfrom(p)  (useanon ? p->fromname : p->from)

/*-------------------------------------------------------------------------*
 * Condition string macros
 *-------------------------------------------------------------------------*/
#define altyp(a,f)  (a ? (f ? "MAX" : "MIN") : "None Set")
#define sexrst(s,f) (s ? (f ? "Female Only" : "Male Only") : "None")
#define dftsex(ds)  (ds ? (ds == OPPO ? "Opposite" : "Same") : "Include Both")

/*-------------------------------------------------------------------------*
 * Key initialization macros
 *-------------------------------------------------------------------------*/
#define iniqzk(p,q)     {p->type=QUIZ; p->quizno=q; p->qstnno=0;}
#define iniqsk(p,q,n)   {p->type=QSTN; p->quizno=q; p->qstnno=n;}
#define ininmk(p,q,n)   {p->quizno=q; p->qstnno=n; p->type=0;}

/*-------------------------------------------------------------------------*
 * Database query macros
 *-------------------------------------------------------------------------*/
#define qnxqiz(p)        (qgtbtv(p,TYPKEY) && bbkyp->type == QUIZ)
#define qprqiz(p)        (qltbtv(p,TYPKEY) && bbkyp->type == QUIZ && \
                          bbkyp->quizno)

#define qnxqst(p,q)      (qgtbtv(p,TYPKEY) && bbkyp->type == QSTN && \
                          bbkyp->quizno == q)
#define qprqst(p,q)      (qltbtv(p,TYPKEY) && bbkyp->type == QSTN && \
                          bbkyp->quizno == q)

#define qnxqzn(p,q)      (qgtbtv(p,NUMKEY) && (q == 0xFFFF || bbnkyp->quizno == q))
#define qprqzn(p,q,n)    (qltbtv(p,NUMKEY) && ((n == 0xFFFF && bbnkyp->quizno >= q) || \
                         (bbnkyp->quizno == q && bbnkyp->qstnno >= n)))

#define qryent(p,q,n)    (qgebtv(p,ENTKEY) && bbekyp->quizno == q &&\
                          (equstri(n,bbekyp->name) || \
                          (n && strlen(n) > 2 && equstr2(n,bbekyp->name))))
#define qprent(p,q)      (qltbtv(p,ENTKEY) && bbekyp->quizno == q)
#define qnxent(p,q)      (qgtbtv(p,ENTKEY) && bbekyp->quizno == q)

#define qprdat(q)        (qprbtv() && bbdkyp->quizno == q)
#define qlstdat(p,q)     (qltbtv(p,DATEKEY) && bbdkyp->quizno == q)

/*-------------------------------------------------------------------------*
 * External function declarations
 *-------------------------------------------------------------------------*/
void      hdlstt(void),       /* handle status 3 input                     */
		eprompt(            /* display error msg, clear input, & reprompt*/
			INT optno ),        /* message option number                */
		prompt(             /* send prompt, set new state/dftinp char    */
			INT msgopt ),       /* option number for prompt/new state   */
		reprompt(           /* request a reprompt                        */
			INT level ),        /* 0 - Reprompt request                 */
                                   /* 1 - CR input - Abort if possible     */
                                   /* 1 - ^O input - Abort                 */
		shomst(             /* prf a main entry                          */
			Entry *ep,          /* entry to prf                         */
			INT fmt ),          /* msg option for format                */
		shoqiz(             /* prf a quiz header                         */
			INT fmt ),          /* msg option for format                */
		shoqst(             /* prf usrqst header                         */
			INT fmt,            /* msg option for format                */
			long sel ),         /* selection bitfield                   */
		shomsg(             /* prf a message header                      */
			Message *mp,        /* message to prf                       */
			INT fmt ),          /* msg option for format                */
		bgnsrch(void),      /* begin quiz search                         */
		bgnlist(void),      /* begin listing MM users                    */
		bgnmail(            /* begin writing message                     */
			char *to,           /* who to write to                      */
			long repto ),       /* reply to message number              */
		newsrch(void),      /* clear search information                  */
		mmk_xmtmsg(         /* transmit text to user                     */
			Message *mp ),      /* message to transmit                  */
          xitmmk(void),       /* exiting match maker                       */
          srchwch(void),      /* search which quiz?      - state linker    */
		nxtqstn(void),      /* set up, show, and prompt for next question*/
		initmain(void),     /* initialize usrqiz for main entry          */
		mainqstns(void);    /* ask questions for main questionnaire      */


INT       mmk_match(void),    /* check for match, return %match            */
		mmk_entsiz(void);   /* size of entry record                      */

boolean   mmk_mst( char *userid ),  /* utility function                    */
		getmst(void),       /* load the main entry for current user      */
		mmk_ents( char *userid ), /* utility function                    */
		qizrsps(            /* does quiz have responses                  */
			INT quizno ),       /* quiz to check                        */
		updusr(void),       /* update entry, current user                */
		updqiz(void),       /* update quiz entry, current user           */
		delqiz(void),       /* deletes quiz in usrqiz                    */
		delqst(void),       /* deletes question in usrqst                */
		mmk_qizacc(         /* does the cur user have access to qstnare  */
			boolean srch ),     /* searching or entering                */
		mmk_match2(void),   /* check for match, main entry               */
		cycling(void);      /* is current substate cycled                */

void      x2modwch(void),     /* exiting to smodwch      - state linker    */
		x2modwht(void),     /* exiting to smodwht      - state linker    */
		x2modqst(void);     /* exiting to smodqst      - state linker    */

long      mmk_lnl(void);      /* reset ival and return last message in msgl*/


/*-------------------------------------------------------------------------*
 * dunedt function declarations
 *-------------------------------------------------------------------------*/
INT       endaddq(            /* add a new question      - dunedt routine  */
               INT rflags ),       /* return flags from editor             */
          endedtq(            /* end of edit question    - dunedt routine  */
               INT rflags ),       /* return flags from editor             */
          endedtr(            /* end of edit response     - dunedt routine  */
               INT rflags ),       /* return flags from editor             */
          endwrit(            /* end of message edit     - dunedt routine  */
               INT rflags );       /* return flags from editor             */


/*-------------------------------------------------------------------------*
 * External variable declarations
 *-------------------------------------------------------------------------*/
extern
word      msgsize,            /* size of message buffer                    */
		edtcnt;             /* count of edit options                     */

extern
dword     mailchg;            /* charge for writing email                  */

extern
BTVFILE   *accbb,             /* account database                          */
		*entbb,             /* quiz entry database                       */
		*qizbb,             /* questionnaire database                    */
		*mailbb;            /* email database                            */

extern
FILE      *mmkmb;             /* match maker email block                   */

extern
char      mmkcls[],           /* clear screen command                      */
          modkey[],           /* key required for moderator                */
		rtrsh[];            /* trash pointer for rspp                    */

extern
boolean   useanon,            /* keep users anonymous                      */
		useage,             /* use sex as a search criteria              */
		usesex,             /* use sex as a search criteria              */
		txtsch,             /* allow text searches on mixed qstnnaires   */
		usebrws,            /* allow browsing of questionnaire entries   */
		alwnan,             /* allow users to not answer questions       */
          shwall,             /* show all questionnaires to users          */
          autoreg;            /* auto register new entries                 */
/*)}*/

