/*{(************************************************************************
 *
 *    RJSMMK.C
 *
 *    Match Maker - V2.20
 *
 * Copyright (c) 1992-1993, by Ronald Struempf, Sirius Software Development
 ***************************************************************************/
/* Previous changes available.  Recorded in a separate database            *
 *                                                                         *
 * 2.16c - 03/03/93 - Reset questionnaire number to avoid read past end of *
 *                    file on partial match with last user when writing    *
 *                    mail                                                 *
 *                                                                         *
 * 2.16d - 03/05/93 - Added support for command concatenation when filling *
 *                    registry, and in error conditions from search and    *
 *                    fill out questionnaires                              *
 *                  - Relist questionnaires before SRCHWCH and FILLWCH     *
 *                  - Fixed problem that corrupted questionnaires when     *
 *                    deleting or inserting a questionnaire                *
 *                                                                         *
 * 2.16e - 03/24/93 - Reply to match mail was not being sent to user due   *
 *                    to msgp being cleared in bgnmail()                   *
 *                                                                         *
 * 2.20  - 06/19/93 - Separated Match Maker and Employment Service         *
 *                  - Removed auto-colorization                            *
 *                  - Built library in to avoid need for RJSUTL.DLL        *
 *                  - Use GComm E-Mail if anonymous feature not enabled    *
 *                  - Added MMKCCR to allow for a surcharge while in MM    *
 *                  - Added MAILKEY to restrict access to Match Mail       *
 *                  - Added MAILCHG to allow for charging for Match Mail   *
 *       - 08/31/93 - Moved entry to bottom of MatchUser                   *
 * 2.20b - 09/08/93 - Browse-View-Restart was not reloading user entry     *
 *                                                                         *
 ***************************************************************************/
#include "rjsmmk.h"
#include "rjsmmmsg.h"

char *version="#VER# RJSMMK V2.20b";

/*-------------------------------------------------------------------------*
 * Module interface definition
 *-------------------------------------------------------------------------*/
LOCAL
INT       mmklon(void),       /* user logon supplemental routine           */
          mmkstt(void);       /* standard input entry point                */

LOCAL
void      mmksts(void),       /* status-input routine if selected          */
          mmkhup(void),       /* hangup/lost carrier routine               */
          mmkmcu(void),       /*    midnight cleanup routine               */
          mmkdla(             /* delete-account routine                    */
               char *userid ),     /* userid deleted                       */
          mmkfin(void);       /*    finish-up (sys shutdown) routine       */


struct module  mmk_module={   /* module interface block                    */
          "",                 /*    description for main menu  (cfg'able)  */
          mmklon,             /*    user logon supplemental routine        */
          mmkstt,             /*    input routine if selected              */
          mmksts,             /*    status-input routine if selected       */
          NULL,               /*    "injoth" routine for this module       */
          NULL,               /*    user logoff supplemental routine       */
          mmkhup,             /*    hangup (lost carrier) routine          */
          mmkmcu,             /*    midnight cleanup routine               */
          mmkdla,             /*    delete-account routine                 */
          mmkfin              /*    finish-up (sys shutdown) routine       */
};

/*-------------------------------------------------------------------------*
 * Local state function declarations
 *-------------------------------------------------------------------------*/
LOCAL
void      smmenu(void),       /* main menu state         - input handler   */
          seditfld(void),     /* which field to edit     - input handler   */
          seditnam(void),     /* edit name               - input handler   */
          seditage(void),     /* edit age                - input handler   */
          seditsex(void),     /* edit sex                - input handler   */
          ssrchmst(void),     /* enter search words      - input handler   */
          sbrwswho(void),     /* browse registry - first - input handler   */
          sbrwsnxt(void),     /* browse registry - next  - input handler   */
          sbrowsing(void),    /* browse registry - cont  - status handler  */
          sqlstnxt(void),     /* list current quizes     - input handler   */
          squizlist(void),    /* list current quizes     - status handler  */
          smodwch(void),      /* add/modify which quiz   - input handler   */
          saddqiz(void),      /* quiz' name              - input handler   */
          sqizpfn(void),      /* allow profanity         - input handler   */
          sentage(void),      /* quiz' entry age limits  - input handler   */
          sentsex(void),      /* quiz' entry sex restrict- input handler   */
          sentrkey(void),     /* quiz' entry key         - input handler   */
          sdefsex(void),      /* quiz search default sex - input handler   */
          sseaage(void),      /* quiz' search age limits - input handler   */
          sseasex(void),      /* quiz' search sex restric- input handler   */
          sseakey(void),      /* quiz' search key        - input handler   */
          sqiztyp(void),      /* questionnaire type      - input handler   */
          snumrsps(void),     /* how many responses      - input handler   */
          snumrspmc(void),    /* how many responses, mc  - input handler   */
          sexclude(void),     /* don't use in search     - input handler   */
          strsplen(void),     /* length of text response - input handler   */
          saddrsp(void),      /* add a new response      - input handler   */
          sqdelwch(void),     /* delete which quiz       - input handler   */
          sqyesdel(void),     /* delete this quiz        - input handler   */
          sdqizcycl(void),    /* delete quiz             - status handler  */
          srenqizu(void),     /* renumbering quiz up     - status handler  */
          srenentsu(void),    /* renumbering entries up  - status handler  */
          srenqizd(void),     /* renumbering quiz down   - status handler  */
          srenentsd(void),    /* renumbering entries down- status handler  */
          sqinsbfr(void),     /* insert quiz before?     - input handler   */
          smodwht(void),      /* modify what item        - input handler   */
          snewqnam(void),     /* new quiz name           - input handler   */
          sdelwch(void),      /* delete which question   - input handler   */
          syesdel(void),      /* delete this question    - input handler   */
          srfmttxt(void),     /* reformat text after del - status handler  */
          srenqstu(void),     /* renumbering questions up- status handler  */
          srenqstd(void),     /* renumbering questions dn- status handler  */
          sinsbfr(void),      /* insert question before? - input handler   */
          sqstlnxt(void),     /* list questions          - input handler   */
          sqstnlist(void),    /* list questions          - status handler  */
          syesclr(void),      /* verify clear reponses   - input handler   */
          smstclr(void),      /* must clear reponses     - input handler   */
          sclrrsp(void),      /* clear responses         - status handler  */
          smodqst(void),      /* what to do with question- input handler   */
          sedttrsp(void),     /* edit text response      - input handler   */
          snewnrsps(void),    /* new number of responses - input handler   */
          snewnrspm(void),    /* new number of responses - input handler   */
          snewrspl(void),     /* new response length     - input handler   */
          srdelwch(void),     /* delete which response   - input handler   */
          srinsbfr(void),     /* insert response before? - input handler   */
          sfillwch(void),     /* fill out which quiz?    - input handler   */
          snxtrsp(void),      /* next response to qstn   - input handler   */
          snxtrspt(void),     /* text response to qstn   - input handler   */
          stxtalt(void),      /* alternate text response - input handler   */
          ssavnxit(void),     /* save questionnaire?     - input handler   */
          ssrchwch(void),     /* search which quiz?      - input handler   */
          sentogo(void),      /* redo search criteria?   - input handler   */
          ssrchsex(void),     /* search sex criteria     - input handler   */
          ssrchage(void),     /* search age criteria     - input handler   */
          stxtomch(void),     /* text or match search    - input handler   */
          ssrchpct(void),     /* search pct criteria     - input handler   */
          ssrchlnxt(void),    /* write to who or list mor- input handler   */
          ssrchlist(void),    /* list matching entries   - status handler  */
          sdetlwho(void),     /* detail on what user     - input handler   */
          swritwho(void),     /* write to what user      - input handler   */
          supdents(void),     /* update entries          - status handler  */
          smsglist(void),     /* list mail               - status handler  */
          smsglnxt(void),     /* pause in mail list      - input handler   */
          smsgreply(void),    /* what, after write mail  - input handler   */
          srlstmsgs(void),    /* relist mail             - status handler  */
          sremwho(void),      /* remove who              - input handler   */
          syesrem(void),      /* remove user(s)?         - input handler   */
          sremusrs(void),     /* remove user(s)          - status handler  */
          seraswch(void),     /* erase which message     - input handler   */
          skeywds(void),      /* enter search words      - input handler   */
          smainlist(void),    /* list main entry rsps    - status handler  */
          srsplist(void),     /* list questionnaire rsps - status handler  */
          suserlist(void),    /* list MM users           - status handler  */
          snewonly(void),     /* list new users only?    - input handler   */
          sbrftxtn(void),     /* brief description #     - input handler   */
          sviewwho(void),     /* view who's responses    - input handler   */
          swchqiz(void),      /* view which questionnaire- input handler   */
          sentlist(void);     /* list user's entries     - status handler  */


/*-------------------------------------------------------------------------*
 * Local state linking function declarations
 *-------------------------------------------------------------------------*/
LOCAL
void      smenu(void),        /* return to main menu     - state linker    */
          qiztyp(void),       /* qiz type && add 1st qstn- state linker    */
          numrsp(void),       /* number of responses     - state linker    */
          newnrsp(void),      /* new number of responses - state linker    */
          addnqst(void),      /* add next question       - state linker    */
          modwch(void),       /* edit which quiz?        - state linker    */
          qdelwch(void),      /* reprompt QDELWCH        - state linker    */
          qnowdel(void),      /* now delete quiz         - state liner     */
          qdelren(void),      /* renumber after delete   - state linker    */
          qinsbfr(void),      /* insert quiz before?     - state linker    */
          insqiz(void),       /* insert a questionnaire  - state linker    */
          modwht(void),       /* edit questionnaire      - state linker    */
          delwch(void),       /* reprompt DELWCH         - state linker    */
          delren(void),       /* renumber after delete   - state linker    */
          delrfmt(void),      /* reformat text after del - state linker    */
          insbfr(void),       /* insert question before? - state linker    */
          insqst(void),       /* insert a question       - state linker    */
          modqst(void),       /* edit question           - state linker    */
          reformat(void),     /* start reformatting text - state linker    */
          fillwch(void),      /* fill out which quiz?    - state linker    */
          srchlist(void),     /* begin quiz search       - state linker    */
          srchlnxt(void),     /* search again after mail - state linker    */
          editnext(void),     /* after updating entries  - state linker    */
          editfld(void),      /* after updating entries  - state linker    */
          relist(void),       /* relist current messages - state linker    */
          msglnxt(void),      /* after relist            - state linker    */
          msgreply(void),     /* after reply             - state linker    */
          txtomch(void),      /* determine search type   - input handler   */
          srchtxt(void),      /* text search             - state linker    */
          srchpct(void),      /* match search            - state linker    */
          srchmst(void),      /* search main entry       - state linker    */
          brwsnxt(void),      /* search again after mail - state linker    */
          srchmain(void),     /* search main entries     - state linker    */
          catrou(void),       /* call catastro if invoked- state linker    */
          entlist(void);      /* relist user entries     - state linker    */

/*-------------------------------------------------------------------------*
 * Local utility function declarations
 *-------------------------------------------------------------------------*/
LOCAL
boolean   hasmail(            /* see if a user has mail                    */
               char *userid );     /* userid to check                      */

void      mmk_setdbs(         /* set databases                             */
               BTVFILE *ebb,       /* entry database                       */
               BTVFILE *mbb );     /* mail database                        */

boolean   inmmk(              /* check to see if user is in Match Maker    */
               char *uid );        /* userid, or NULL for anyone           */

LOCAL
MatchUser *othmch;            /* auxilliary MatchUser pointer              */

LOCAL
char      *mmkdesc(void);     /* return match maker description            */


/*-------------------------------------------------------------------------*
 * Local variables
 *-------------------------------------------------------------------------*/
/*
 *  System variables
 */
BTVFILE   *entbb,             /* quiz entry database                       */
          *qizbb,             /* questionnaire database                    */
          *mailbb;            /* email database                            */

FILE      *mmkmb;             /* match maker message block                 */

LOCAL
INT       lockout=-1;         /* match maker locked out for configuration  */

LOCAL
word      mmkmod;             /* match maker state                         */

word      edtcnt,             /* count of edit options                     */
          msgsize;            /* size of message text allowed              */

char      rtrsh[100];         /* trash spot for rspp to point to           */

/*
 *  Configuration variables
 */
boolean   useanon,            /* keep users anonymous                      */
          useage,             /* use sex as a search criteria              */
          usesex,             /* use sex as a search criteria              */
          alwnan,             /* allow users to not answer questions       */
          indsrch,            /* allow searches w/o completing qstnnare    */
          txtsch,             /* text searches on mixed questionnaires     */
          usebrws,            /* allow browsing of questionnaire entries   */
          shwall,             /* show all questionnaires to users          */
          chgals,             /* allow users to change their alias         */
          regd,               /* has match maker been registered           */
          autoreg;            /* automatically complete registry entry     */

dword     mailchg;            /* charge for writing Match Mail             */

LOCAL
boolean   askent,             /* ask user to fill out main entry at log-on */
          alwpfn;             /* allow profanity in Match Maker            */

LOCAL
INT       maillife,           /* match mail lifetime                       */
          entlife,            /* questionnaire entry lifetime              */
          mmkccr;             /* credit consumption rate while in MM       */

char      mmkcls[15],         /* clear screen command                      */
          mmkkey[KEYSIZ],     /* key required to enter match maker         */
          modkey[KEYSIZ],     /* key required for moderator                */
          alsfile[80];        /* list of alias changes                     */

struct
message   *mesg;              /* GComm style message buffer                */


/*-------------------------------------------------------------------------*
 * Local functions
 *-------------------------------------------------------------------------*/
void EXPORT
init__match()                 /* system initialization routine             */
{
     word vdasz;

     entbb=opnbtv( "RJSMMENT.DAT", sizeof(Entry) );
     qizbb=opnbtv( "RJSMMQIZ.DAT", sizeof(Question) );
     mmkmb=opnmsg( "RJSMMMSG.MCV" );
     strcpy( mmkkey, rawmsg(MMKKEY) );
     strcpy( modkey, rawmsg(MODKEY) );
     mmkccr=numopt( MMKCCR, -1, 32767 );
     useanon=ynopt( USEANON );
     autoreg=ynopt( AUTOREG );
     msgsize=outbsz-500;
     if( useanon ) {
          mailbb=opnbtv( "RJSMMEML.DAT", sizeof(Message)+msgsize );
     }
     else {
          mesg=(struct message*)alcmem( sizeof(struct message)+msgsize );
     }
     mmk_setdbs( entbb, mailbb );
     useage=ynopt( USEAGE );
     usesex=ynopt( USESEX );
     askent=ynopt( ASKENT );
     alwpfn=ynopt( ALWPFN );
     alwnan=ynopt( ALWNAN );
     indsrch=ynopt( INDSRCH );
     txtsch=ynopt( TXTSCH );
     usebrws=ynopt( USEBRWS );
     shwall=ynopt( SHWALL );
     chgals=ynopt( CHGALS );
     maillife=numopt( MAILLIFE, -1, 32767 );
     entlife=numopt( ENTLIFE, -1, 32767 );
     mailchg=lngopt( MAILCHG, 0, 2000000L );
     if( ynopt(CLRSCNS) ) {
          strcpy( mmkcls, "[[[2J|]" );
     }
     else {
          strcpy( mmkcls, "\n" );
     }
     edtcnt=useanon+usesex+useage+1;
     vdasz=max( (sizeof(MatchMail)+msgsize), sizeof(MatchUser) );
     regd=sirius_register( &mmkmod, &mmk_module, "RJSMMK.MDF", vdasz );
     if( regd ) {
          register_textvar( "RJSMMK_DESC", mmkdesc );
          if( chgals ) {
               strzcpy( alsfile, getmsg(ALSFILE), sizeof(alsfile) );
          }
     }
}                             /* end init__match                           */

LOCAL INT  DEBUGEXP
mmklon()                      /* log-on handler                            */
{
     setmbk( mmkmb );
     if( regd && (sysop() || mmkacc()) ) {
          clrprf();
          if( !mmk_mst(usaptr->userid) ) {
               if( askent ) {
                    prfmsg( FILLENT );
               }
          }
          else if( hasmail(usaptr->userid) ) {
               prfmsg( NEWMAIL2 );
          }
          outprf( usrnum );
     }
     return( DONE );
}                             /* end mmklon                                */

LOCAL INT  DEBUGEXP
mmkstt()                      /* input handler                             */
{
     setmbk( mmkmb );
     setbtv( qizbb );
     clrprf();
     if( !regd ) {
          prfmsg( NOTACTIV );
          outprf( usrnum );
          return( DONE );
     }
     if( !usrptr->substt && !(sysop() || mmkacc()) ) {
          prfmsg( NOACCES );
          outprf( usrnum );
          return( DONE );
     }
     if( alwpfn || !usrptr->substt || mchusr->alwpfn ) {
          usrptr->pfnacc=0;
          pfnlvl=0;
     }
     if( usrptr->substt != 0 && injoip() ) {
          reprompt( aboip() ? 2 : 0 );
     }
     else if( usrptr->substt != 0 && usrptr->pfnacc > MAXPFN ) {
          byenow( PFNBYE );
     }
     else if( usrptr->substt != 0 && usrptr->pfnacc > WRNPFN && pfnlvl > 0 ) {
          eprompt( PFNWRN2 );
     }
     else if( usrptr->substt != 0 && pfnlvl >= 2 ) {
          eprompt( PFNWRN1 );
     }
     else {
          if( usrptr->substt ) {
               chkdft( mchusr->dftinp );
          }
          else {
               if( lockout >= 0 ) {
                    if( sysop() ) {
                         prfmsg( OTHCFG );
                    }
                    else {
                         prfmsg( SYSCFGN );
                         outprf( usrnum );
                         return( DONE );
                    }
               }
          }
          do {
               if( margc == 1 && equstri(margv[0],"x") ) {
                    rstrwid();
                    if( usrptr->substt <= SMENU ) {
                         xitmmk();
                         outprf( usrnum );
                         return( DONE );
                    }
                    if( usrptr->substt == REMWHO2 ) {
                         clrxrf();
                    }
                    *margv[0]=0;
                    margc=0;
                    clrflgs();
                    mchusr->srch=mchusr->qizrsps=0;
                    mchusr->sel=0;
                    mchusr->alwpfn=mchusr->syspr=sysop();
                    mchusr->rspp=rtrsh;
                    mchusr->nxtrou=catrou;
                    if( mchusr->prvrou ) {
                         mchusr->prvrou();
                    }
                    else {
                         prompt( SMENU );
                    }
               }
               else {
                    hdlstt();
               }
          } while( !endcnc() );
     }
     outprf( usrnum );
     return( NOTDONE );
}                             /* end mmkstt                                */

LOCAL void DEBUGEXP
hdlstt()                      /* handle status 3 input                     */
{
     bgncnc();
     switch( usrptr->substt ) {
     case 0:
          cncchr();
          rstrwid();
          if( mmkccr > 0 ) {
               usrptr->crdrat=mmkccr;
          }
          memset( mchusr, 0, sizeof(VdaBase) );
          mchusr->alwpfn=mchusr->syspr=sysop();
          mchusr->nxtrou=catrou;
          prf( mmkcls );
          if( getmst() ) {
               prfmsg( RENTMMK, mchusr->name );
          }
          else if( autoreg ) {
               usrent.age=usaptr->age;
               usrent.sex=usaptr->sex;
               cncall();
               prompt( ENTALS );
               break;
          }
          else {
               prfmsg( ENTMMK1 );
          }
          prompt( MMENU2 );
          break;
     case MMENU2:
     case SMENU:
          smmenu();
          break;
     case EDITFLD:
          seditfld();
          break;
     case ENTALS:
     case EDTNAM:
     case CHGNAM:
          seditnam();
          break;
     case EDITAGE:
     case CHGAGE:
          seditage();
          break;
     case EDITSEX:
     case CHGSEX:
          seditsex();
          break;
     case BRWSWHO:
          sbrwswho();
          break;
     case BRWSNXT:
          sbrwsnxt();
          break;
     case BROWSING:
          reprompt( 1 );
          break;
     case QLSTNXT:
          sqlstnxt();
          break;
     case QUIZLIST:
          reprompt( 1 );
          break;
     case MODWCH2:
          smodwch();
          break;
     case ADDQIZ:
          saddqiz();
          break;
     case QIZPFN:
          sqizpfn();
          break;
     case ENTAGE:
          sentage();
          break;
     case ENTSEX:
          sentsex();
          break;
     case ENTRKEY:
          sentrkey();
          break;
     case DEFSEX:
          sdefsex();
          break;
     case SEAAGE:
          sseaage();
          break;
     case SEASEX2:
          sseasex();
          break;
     case SEAKEY:
          sseakey();
          break;
     case QIZTYP:
          sqiztyp();
          break;
     case NUMRSPS:
          snumrsps();
          break;
     case NUMRSPMC:
          snumrspmc();
          break;
     case EXCLUDE:
          sexclude();
          break;
     case TRSPLEN:
     case TRSPLEN2:
          strsplen();
          break;
     case NEWRSP2:
     case ADDRSP:
     case INSRSP:
          saddrsp();
          break;
     case QDELWCH:
          sqdelwch();
          break;
     case QYESDEL:
          sqyesdel();
          break;
     case DQIZCYCL:
     case RENQIZU:
     case RENQIZD:
          reprompt( 1 );
          break;
     case QINSBFR:
          sqinsbfr();
          break;
     case MODWHT:
          smodwht();
          break;
     case NEWQNAM:
          snewqnam();
          break;
     case DELWCH:
          sdelwch();
          break;
     case YESDEL:
          syesdel();
          break;
     case RFMTTXT:
     case RENQSTU:
     case RENQSTD:
          reprompt( 1 );
          break;
     case INSBFR:
          sinsbfr();
          break;
     case QSTLNXT:
          sqstlnxt();
          break;
     case QSTNLIST:
          reprompt( 1 );
          break;
     case YESCLR:
          syesclr();
          break;
     case MSTCLR:
          smstclr();
          break;
     case CLRRSP:
          reprompt( 1 );
          break;
     case MODQST:
          smodqst();
          break;
     case EDTTRSP:
          sedttrsp();
          break;
     case NEWNRSPS:
          snewnrsps();
          break;
     case NEWNRSPM:
          snewnrspm();
          break;
     case NEWRSPL:
          snewrspl();
          break;
     case RDELWCH:
          srdelwch();
          break;
     case RINSBFR:
          srinsbfr();
          break;
     case RENENTSU:
     case RENENTSD:
          reprompt( 1 );
          break;
     case FILLWCH:
          sfillwch();
          break;
     case NXTRSP2:
          snxtrsp();
          break;
     case NXTRSPT:
          snxtrspt();
          break;
     case TXTALT:
          stxtalt();
          break;
     case SAVNXIT:
          ssavnxit();
          break;
     case SRCHWCH:
          ssrchwch();
          break;
     case ENTOGO:
          sentogo();
          break;
     case SRCHSEX:
          ssrchsex();
          break;
     case SRCHAGE:
          ssrchage();
          break;
     case TXTOMCH:
          stxtomch();
          break;
     case SRCHPCT:
          ssrchpct();
          break;
     case SRCHLNXT:
     case XORWRIT:
          ssrchlnxt();
          break;
     case SRCHLST2:
          reprompt( 1 );
          break;
     case DETLWHO:
          sdetlwho();
          break;
     case WRITWHO:
          swritwho();
          break;
     case UPDENTS:
          reprompt( 1 );
          break;
     case MSGLIST:
          reprompt( 1 );
          break;
     case MSGLNXT:
     case WCHMSG:
          smsglnxt();
          break;
     case MSGREPLY:
     case MSGREPL2:
          smsgreply();
          break;
     case RLSTMSGS:
          reprompt( 1 );
          break;
     case REMWHO2:
          sremwho();
          break;
     case YESREM2:
          syesrem();
          break;
     case REMUSRS2:
          reprompt( 1 );
          break;
     case ERASWCH:
          seraswch();
          break;
     case KEYWDS:
          skeywds();
          break;
     case MAINLIST:
     case RSPLIST2:
     case ENTLIST2:
          reprompt( 1 );
          break;
     case SRCHMST:
          ssrchmst();
          break;
     case USERLST:
          reprompt( 1 );
          break;
     case NEWONLY:
          snewonly();
          break;
     case BRFTXTN:
          sbrftxtn();
          break;
     case VIEWWHO:
          sviewwho();
          break;
     case WCHQIZ:
          swchqiz();
          break;
     default:
          catastro( "MATCH MAKER INPUT STATE ERROR (substt=%d)",
               usrptr->substt );
     }
}                             /* end hdlstt                                */

LOCAL void DEBUGEXP
mmksts()                      /* status-input routine if selected          */
{
     INT oldstt;

     setmbk( mmkmb );
     setbtv( qizbb );
     prf( "" );
     if( status == OUTMT ) {
          btuoes( usrnum, 0 );
          btutru( usrnum, 'O'&0x1F );
     }
     else if( status == CYCLE ) {
          if( btuoba(usrnum) < 100 ) {
               btuinj( usrnum, CYCLE );
               return;
          }
          nxtcmd=margv[0]="";
          margc=0;
          oldstt=usrptr->substt;
          switch( usrptr->substt ) {
          case BROWSING:
               sbrowsing();
               break;
          case QUIZLIST:
               squizlist();
               break;
          case DQIZCYCL:
               sdqizcycl();
               break;
          case RENQIZU:
               srenqizu();
               break;
          case RENENTSU:
               srenentsu();
               break;
          case RENQIZD:
               srenqizd();
               break;
          case RENENTSD:
               srenentsd();
               break;
          case QSTNLIST:
               sqstnlist();
               break;
          case CLRRSP:
               sclrrsp();
               break;
          case RFMTTXT:
               srfmttxt();
               break;
          case RENQSTU:
               srenqstu();
               break;
          case RENQSTD:
               srenqstd();
               break;
          case SRCHLST2:
               ssrchlist();
               break;
          case UPDENTS:
               supdents();
               break;
          case MSGLIST:
               smsglist();
               break;
          case RLSTMSGS:
               srlstmsgs();
               break;
          case REMUSRS2:
               sremusrs();
               break;
          case MAINLIST:
               smainlist();
               break;
          case RSPLIST2:
               srsplist();
               break;
          case USERLST:
               suserlist();
               break;
          case ENTLIST2:
               sentlist();
               break;
          default:
               return;
          }
          outprf( usrnum );
          if( usrptr->substt == oldstt ) {
               cycle();
          }
     }
     else {
          dfsthn();
     }
}                             /* end mmksts                                */

LOCAL void DEBUGEXP
mmkhup()                      /* hangup/lost carrier routine               */
{
     if( usrptr->state == mmkmod ) {
          xitmmk();
          clrprf();
     }
}                             /* end mmkhup                                */

LOCAL void DEBUGEXP
mmkmcu()                      /*    midnight cleanup routine               */
{
     INT age, cnttdy;

     cnttdy=cofdat(today());
     if( useanon ) {
          setbtv( mailbb );
          if( maillife >= 0 && qlobtv(TOKEY) ) {
               do {
                    gcrbtv( NULL, TOKEY );
                    age=cnttdy-cofdat( bbmsg->credat );
                    if( age > maillife ) {
                         delbtv();
                    }
               } while( qnxbtv() );
          }
     }
     setbtv( entbb );
     if( entlife >= 0 && qlobtv(UIDKEY) ) {
          do {
               if( bbukyp->quizno ) {
                    gcrbtv( NULL, UIDKEY );
                    age=cnttdy-cofdat( bbentp->crdate );
                    if( age > entlife ) {
                         delbtv();
                    }
               }
          } while( qnxbtv() );
     }
}                             /* end mmkmcu                                */

LOCAL void DEBUGEXP
mmkdla(                       /* delete-account routine                    */
     char *userid )                /* userid deleted                       */
{
     setbtv( entbb );
     strzcpy( bbukyp->userid, userid, UIDSIZ );
     bbukyp->quizno=0;
     while( agebtv(NULL,NULL,UIDKEY) && equstri(bbentp->userid,userid) ) {
          delbtv();
     }
     if( useanon ) {
          setbtv( mailbb );
          setuid( bbmkyp->userid, userid );
          bbmkyp->sequence=0;
          while( agebtv(NULL,NULL,TOKEY) && equstri(bbmsg->to,userid) ) {
               delbtv();
          }
     }
}                             /* end mmkdla                                */

LOCAL void DEBUGEXP
mmkfin()                      /*    finish-up (sys shutdown) routine       */
{
     clsbtv( entbb );
     clsbtv( qizbb );
     if( useanon ) {
          clsbtv( mailbb );
     }
     clsmsg( mmkmb );
}                             /* end mmkfin                                */

/*-------------------------------------------------------------------------*
 * state functions
 *-------------------------------------------------------------------------*/
LOCAL void DEBUGEXP
smmenu()                      /* main menu state handler                   */
{
     boolean hasmst;

     usrptr->substt=SMENU;
     switch( cncchr() ) {
     case '.':                     /* no response on short menu            */
          prf( mmkcls );
          prompt( MMENU2 );
          break;
     case 'B':                     /* browse other users                   */
          if( !mchusr->hasmst ) {
               eprompt( MST1ST );
               break;
          }
          prf( mmkcls );
          initmain();
          srchmain();
          break;
     case 'D':                     /* configure/remove users               */
          if( mchusr->syspr ) {
               prompt( REMWHO2 );
          }
          else {
               eprompt( BADSEL );
          }
          break;
     case 'Q':                     /* answer questionnaire                 */
          if( !mchusr->hasmst ) {
               eprompt( MST1ST );
               break;
          }
          if( morcnc() ) {
               mchusr->listexit=YES;
               prompt( FILLWCH );
               break;
          }
          mchusr->listexit=NO;
          setbtv( qizbb );
          iniqzk( usrqzp, 0 );
          if( qnxqiz(usrqzp) ) {
               gcrbtv( usrqzp, TYPKEY );
               mchusr->nxtrou=fillwch;
               prompt( QUIZLIST );
               if( shwall || mmk_qizacc(NO) ) {
                    shoqiz( BRFQFMT2 );
               }
          }
          else {
               eprompt( NOQIZ );
          }
          break;
     case 'R':                     /* user's main entry                    */
          getmst();
          if( mchusr->hasmst ) {
               mchusr->listexit=(morcnc() ? YES : NO);
               prompt( EDITFLD );
          }
          else {
               mchusr->listexit=NO;
               if( useanon ) {
                    prompt( EDTNAM );
               }
               else {
                    strzcpy( usrent.name, usrent.userid, UIDSIZ );
                    if( useage ) {
                         prompt( EDITAGE );
                    }
                    else {
                         usrent.age=usaptr->age;
                         mchusr->entedited=YES;
                         hasmst=mchusr->hasmst;
                         updusr();
                         mchusr->hasmst=hasmst;
                         if( !usesex ) {
                              usrent.sex=usaptr->sex;
                              mchusr->entedited=YES;
                              hasmst=mchusr->hasmst;
                              updusr();
                              mchusr->hasmst=hasmst;
                              mchusr->nxtrou=editfld;
                              mainqstns();
                         }
                         else {
                              prompt( EDITSEX );
                         }
                    }
               }
          }
          break;
     case 'S':                     /* search responses                     */
          if( !mchusr->hasmst ) {
               eprompt( MST1ST );
               break;
          }
          if( morcnc() ) {
               mchusr->listexit=YES;
               prompt( SRCHWCH );
               break;
          }
          mchusr->listexit=NO;
          setbtv( qizbb );
          iniqzk( usrqzp, 0 );
          if( qnxqiz(usrqzp) ) {
               gcrbtv( usrqzp, TYPKEY );
               mchusr->nxtrou=srchwch;
               prompt( QUIZLIST );
               if( shwall || mmk_qizacc(YES) ) {
                    shoqiz( BRFQFMT2 );
               }
          }
          else {
               eprompt( NOQIZ );
          }
          break;
     case 'V':                     /* view quiz responses                  */
          if( !mchusr->hasmst ) {
               eprompt( MST1ST );
               break;
          }
          prompt( VIEWWHO );
          break;
     case 'E':                     /* read responses                       */
          if( !useanon ) {
               eprompt( NOMAILER );
               break;
          }
          if( !mchusr->hasmst ) {
               eprompt( MST1ST );
               break;
          }
          setuid( mkey.userid, usaptr->userid );
          mkey.sequence=0;
          mchmail->found=NO;
          prompt( MSGLIST );
          break;
     case 'W':                     /* write date mail                      */
          if( !mchusr->hasmst ) {
               eprompt( MST1ST );
               break;
          }
          mchusr->nxtrou=smenu;
          initmain();
          prompt( WRITWHO );
          break;
     case '?':                     /* instructions                         */
          prf( mmkcls );
          prfmsg( useanon ? MMKINSA : MMKINS );
          cncall();
          prompt( usrptr->substt );
          break;
     case 'L':                     /* list users                           */
          if( mchusr->syspr ) {
               prompt( NEWONLY );
               break;
          }
     case 'M':                     /* add/modify questionnaire             */
          if( mchusr->syspr || mmkop() ) {
               if( lockout < 0 && inmmk(NULL) ) {
                    prfmsg( USRSIN );
                    prompt( usrptr->substt );
                    break;
               }
               lockout=usrnum;
               if( morcnc() ) {
                    prompt( MODWCH2 );
                    break;
               }
               setbtv( qizbb );
               iniqzk( usrqzp, 0 );
               if( qnxqiz(usrqzp) ) {
                    gcrbtv( usrqzp, TYPKEY );
                    mchusr->nxtrou=modwch;
                    prompt( QUIZLIST );
                    shoqiz( BRFQFMT2 );
               }
               else {
                    prfmsg( NOQIZ );
                    prompt( MODWCH2 );
               }
               break;
          }
     default:
          eprompt( BADSEL );
     }
}                             /* end smmenu                                */

LOCAL void DEBUGEXP
seditfld()                    /* edit field number state handler           */
{
     INT rsp;

     if( isdigit(morcnc()) && (rsp=cncint()) >= 0 && rsp <= edtcnt ) {
          if( rsp == 0 ) {
               usrptr->substt=EDITFLD;
               reprompt( 0 );
          }
          else if( useanon && rsp == 1 ) {
               if( chgals ) {
                    prompt( CHGNAM );
               }
               else {
                    prfmsg( NCHGALS );
               }
          }
          else if( useage && rsp == useanon+1 ) {
               prompt( CHGAGE );
          }
          else if( usesex && rsp == useanon+useage+1 ) {
               prompt( CHGSEX );
          }
          else if( rsp == edtcnt ) {
               mchusr->nxtrou=editfld;
               mainqstns();
          }
          else {
               prfmsg( BADNUM, 1, edtcnt );
               eprompt( 0 );
          }
     }
     else {
          eprompt( BADSEL );
     }
}                             /* end seditfld                              */

LOCAL void DEBUGEXP
seditnam()                    /* edit name               - input handler   */
{
     boolean hasmst;
     FILE    *aliasfp=NULL;

     strzcpy( ekey.name, cncall(), UIDSIZ );
     ekey.quizno=0;
     setbtv( entbb );
     trm2( ekey.name );
     if( strlen(ekey.name) < 3 ) {
          eprompt( MINTHREE );
     }
     else if( equstr(ekey.name,mchusr->name) ) {
          eprompt( SAMENAME );
     }
     else if( !equstri(ekey.name,mchusr->name) && qeqbtv(ekyp,ENTKEY) ) {
          eprompt( NAMNUSE );
     }
     else {
          rstrwid();
          setbtv( accbb );
          if( qeqbtv(ekey.name,0) && !equstri(ekey.name,usaptr->userid) ) {
               eprompt( NAMNUSE );
               return;
          }
          if( mchusr->hasmst && *alsfile && (aliasfp=fopen(alsfile,"wa")) != NULL ) {
               fprintf( aliasfp, "Match Maker: %-30s %-20s -> %-20s  %s %s\n",
                    usaptr->userid, mchusr->name, ekey.name, ncdate(today()),
                    nctime(now()) );
               fclose( aliasfp );
          }
          mchusr->entedited=YES;
          strzcpy( usrent.name, ekey.name, UIDSIZ );
          hasmst=mchusr->hasmst;
          updusr();
          mchusr->hasmst=hasmst;
          if( usrptr->substt == ENTALS ) {
               mchusr->hasmst=YES;
               prfmsg( RENTMMK, mchusr->name );
               prompt( MMENU2 );
          }
          else if( mchusr->hasmst && mmk_ents(usaptr->userid) ) {
               strzcpy( ukey.userid, usaptr->userid, UIDSIZ );
               ukey.quizno=0;
               mchusr->nxtrou=editnext;
               prompt( UPDENTS );
          }
          else {
               editnext();
          }
     }
}                             /* end seditnam                              */

LOCAL void DEBUGEXP
supdents()                    /* update entries          - status handler  */
{
     setbtv( entbb );
     if( qgtbtv(ukyp,UIDKEY) && equstri(bbukyp->userid,usaptr->userid) ) {
          memcpy( ukyp, bbukyp, sizeof(UserKey) );
          gcrbtv( NULL, UIDKEY );
          strzcpy( bbentp->name, mchusr->name, UIDSIZ );
          bbentp->age=mchusr->age;
          bbentp->sex=(mchusr->female ? 'F' : 'M');
          upvbtv( NULL, bbentp->entsiz );
          working( NO );
     }
     else {
          working( YES );
          mchusr->nxtrou();
     }
}                             /* end supdents                              */

LOCAL void DEBUGEXP
seditage()                    /* edit age                - input handler   */
{
     INT age;
     boolean hasmst;

     age=cncint();
     if( age <= 0 || age > 120 ) {
          eprompt( BADAGE );
     }
     else {
          rstrwid();
          mchusr->entedited=YES;
          usrent.age=age;
          hasmst=mchusr->hasmst;
          updusr();
          mchusr->hasmst=hasmst;
          if( usrent.age != usaptr->age ) {
               prfmsg( WHTLIE );
          }
          if( mchusr->hasmst ) {
               if( mmk_ents(usaptr->userid) ) {
                    strzcpy( ukey.userid, usaptr->userid, UIDSIZ );
                    ukey.quizno=0;
                    mchusr->nxtrou=editfld;
                    prompt( UPDENTS );
               }
               else {
                    usrptr->substt=EDITFLD;
                    reprompt( 0 );
               }
          }
          else if( !usesex ) {
               usrent.sex=usaptr->sex;
               mchusr->entedited=YES;
               hasmst=mchusr->hasmst;
               updusr();
               mchusr->hasmst=hasmst;
               mchusr->nxtrou=editfld;
               mainqstns();
          }
          else {
               prompt( EDITSEX );
          }
     }
}                             /* end seditage                              */

LOCAL void DEBUGEXP
seditsex()                    /* edit sex                - input handler   */
{
     char sex;
     boolean hasmst;

     switch( sex=cncchr() ) {
     case 'M':
     case 'F':
          rstrwid();
          mchusr->entedited=YES;
          mchusr->female=((usrent.sex=sex) == 'F');
          hasmst=mchusr->hasmst;
          updusr();
          mchusr->hasmst=hasmst;
          if( mchusr->hasmst ) {
               if( usrent.sex != usaptr->sex ) {
                    prfmsg( UPDSEX );
               }
               if( mmk_ents(usaptr->userid) ) {
                    strzcpy( ukey.userid, usaptr->userid, UIDSIZ );
                    ukey.quizno=0;
                    mchusr->nxtrou=editfld;
                    prompt( UPDENTS );
               }
               else {
                    usrptr->substt=EDITFLD;
                    reprompt( 0 );
               }
          }
          else {
               if( usrent.sex != usaptr->sex ) {
                    prfmsg( OTHSEX );
               }
               mchusr->nxtrou=editfld;
               mainqstns();
          }
          break;
     default:
          usrent.sex=usaptr->sex;
          eprompt( MORF );
     }
}                             /* end seditsex                              */

LOCAL void DEBUGEXP
sbrwswho()                    /* browse main entries     - input handler   */
{
     strzcpy( ekey.name, cncall(), UIDSIZ-1 );
     ekey.quizno=0;
     setbtv( entbb );
     if( ekey.name[0] == '.' && ekey.name[1] == 0 ) {
          srchmain();
     }
     else if( qryent(ekyp,0,ekey.name) ) {
          gcrbtv( usrentp, ENTKEY );
          shomst( usrentp, FULFMT2 );
          mchusr->nxtrou=brwsnxt;
          prompt( MAINLIST );
     }
     else if( qnxent(ekyp,0) ) {
          memcpy( ekyp, bbekyp, sizeof(Namekey) );
          gcrbtv( NULL, ENTKEY );
          prompt( BROWSING );
          shomst( bbentp, BRFFMT2 );
     }
     else {
          prfmsg( NOENTRY, ekey.name );
          prompt( BRWSNXT );
     }
}                             /* end sbrwswho                              */

LOCAL void DEBUGEXP
sbrwsnxt()                    /* browse main entries     - input handler   */
{
     switch( cncchr() ) {
     case 'V':                     /* view user questionnaire reponses     */
          prompt( BRWSWHO );
          break;
     case 'R':                     /* restart search                       */
          memset( ekyp, 0, sizeof(Namekey) );
          prompt( BROWSING );
          break;
     case 'N':                     /* new search                           */
          srchmain();
          break;
     case 'M':                     /* match mail                           */
          mchusr->nxtrou=brwsnxt;
          prompt( WRITWHO );
          break;
     case 'C':                     /* continue listing                     */
          setbtv( entbb );
          if( qnxent(ekyp,0) ) {
               prompt( BROWSING );
          }
          else {
               prfmsg( mchusr->found ? ENDENTS : NOENTS );
               prompt( SMENU );
          }
          break;
     default:
          eprompt( BNXTHLP );
     }
}                             /* end sbrwsnxt                              */

LOCAL void DEBUGEXP
sbrowsing()                   /* browse continues       - status handler   */
{
     setbtv( entbb );
     if( qnxent(ekyp,0) ) {
          memcpy( ekyp, bbekyp, sizeof(Namekey) );
          gcrbtv( NULL, ENTKEY );
          if( mmk_match2() ) {
               shomst( bbentp, BRFFMT2 );
               mchusr->found=YES;
               if( ++mchusr->ival >= 15 ) {
                    prompt( BRWSNXT );
               }
          }
     }
     else if( mchusr->found ) {
          prfmsg( ENDENTS );
          prompt( BRWSNXT );
     }
     else {
          prfmsg( NOENTS );
          prompt( SMENU );
     }
}                             /* end sbrowsing                             */

LOCAL void DEBUGEXP
sqlstnxt()                    /* list current quizes     - input handler   */
{
     if( morcnc() == 'C' ) {
          prompt( QUIZLIST );
     }
     else {
          mchusr->nxtrou();
     }
}                             /* end sqlstnxt                              */

LOCAL void DEBUGEXP
squizlist()                   /* list current quizes     - status handler  */
{
     setbtv( qizbb );
     if( qnxqiz(usrqzp) ) {
          gcrbtv( usrqzp, TYPKEY );
          if( shwall || mmk_qizacc(mchusr->srch) ) {
               shoqiz( BRFQFMT2 );
               if( ++mchusr->ival >= 15 ) {
                    prompt( QLSTNXT );
                    return;
               }
          }
     }
     else {
          prfmsg( ENDQIZ );
          mchusr->nxtrou();
     }
}                             /* end squizlist                             */

LOCAL void DEBUGEXP
smodwch()                     /* add/modify which quiz   - input handler   */
{
     if( !mchusr->syspr && !mmkop() ) {
          catastro( "Match Maker, MODWCH invalid user %s", usaptr->userid );
     }
     setbtv( qizbb );
     mchmail->editflgs=0;
     if( isdigit(morcnc()) ) {     /* edit quiz                            */
          iniqzk( usrqzp, cncint() );
          if( usrqiz.quizno && qeqbtv(usrqzp,TYPKEY) ) {
               gcrbtv( usrqzp, TYPKEY );
               mchusr->qizrsps=qizrsps( usrqiz.quizno );
               if( mchusr->qizrsps ) {
                    prfmsg( MODWDEL );
               }
               if( usrqiz.brfqst && (!(usrqiz.qiztyp&TEXTQ) || !usrqiz.txtoffs) ) {
                    usrqiz.brfqst=usrqiz.brftxt=0;
                    mchusr->qizedited=YES;
                    updqiz();
               }
               shoqiz( FULLQFM2 );
               prompt( MODWHT );
          }
          else {
               eprompt( QNOHERE );
          }
     }
     else {
          switch( cncchr() ) {
          case 'A':                  /* add new quiz                           */
               memset( usrqzp, 0, sizeof(Questionnaire) );
               iniqzk( bbkyp, MAXQIZ );
               if( qprqiz(NULL) ) {
                    iniqzk( usrqzp, bbkyp->quizno+1 );
               }
               else {
                    iniqzk( usrqzp, 1 );
               }
               prompt( ADDQIZ );
               break;
          case 'D':                  /* delete a quiz                          */
               prompt( QDELWCH );
               break;
          case 'I':                  /* insert a quiz                          */
               iniqzk( usrqzp, 0 );
               if( qnxqiz(usrqzp) ) {
                    prompt( QINSBFR );
               }
               else {
                    eprompt( QUSEADD );
               }
               break;
          case 'R':                  /* edit main entry questionnaire          */
               iniqzk( usrqzp, 0 );
               if( qeqbtv(usrqzp,TYPKEY) ) {
                    gcrbtv( usrqzp, TYPKEY );
               }
               else {
                    memset( usrqzp, 0, sizeof(Questionnaire) );
                    iniqzk( usrqzp, 0 );
                    usrqiz.qiztyp=TEXTQ;
                    strcpy( usrqiz.name, "Main Entry" );
               }
               mchusr->qizrsps=qizrsps( usrqiz.quizno );
               if( mchusr->qizrsps ) {
                    prfmsg( MODWDEL );
               }
               shoqiz( FULLQFM2 );
               prompt( MODWHT );
               break;
          case 'L':                  /* list existing quizes                   */
               iniqzk( usrqzp, 0 );
               if( qnxqiz(usrqzp) ) {
                    gcrbtv( usrqzp, TYPKEY );
                    mchusr->nxtrou=modwch;
                    prompt( QUIZLIST );
                    shoqiz( BRFQFMT2 );
               }
               else {
                    eprompt( NOQIZS );
               }
               break;
          default:
               eprompt( MDWHLP2 );
          }
     }
}                             /* end smodwch                               */

LOCAL void DEBUGEXP
saddqiz()                     /* quiz name               - input handler   */
{
     rstrwid();
     strcpy( usrqiz.name, cncall() );
     if( usrqiz.name[0] ) {
          mchusr->nxtrou=qiztyp;
          if( alwpfn ) {
               usrqiz.alwpfn=YES;
               prompt( ENTAGE );
          }
          else {
               prompt( QIZPFN );
          }
     }
     else {
          eprompt( NEEDNAME );
     }
}                             /* end saddqiz                               */

LOCAL void DEBUGEXP
sqizpfn()                     /* allow profanity         - input handler   */
{
     usrqiz.alwpfn=NO;
     switch( cncyesno() ) {
     case 'Y':
          usrqiz.alwpfn=YES;
     case 'N':
          prompt( ENTAGE );
          break;
     default:
          eprompt( YORN );
     }
}                             /* end sqizpfn                               */

LOCAL void DEBUGEXP
sentage()                     /* quiz entry age restrict - input handler   */
{
     if( morcnc() == '-' ) {
          usrqiz.fagemax=YES;
          cncchr();
     }
     else {
          usrqiz.fagemax=NO;
     }
     if( isdigit(morcnc()) ) {
          usrqiz.fage=cncint();
          if( usesex ) {
               prompt( ENTSEX );
          }
          else {
               usrqiz.fsexrst=usrqiz.ffemale=NO;
               prompt( ENTRKEY );
          }
     }
     else {
          prf( mmkcls );
          eprompt( EAGEHLP );
     }
}                             /* end sentage                               */

LOCAL void DEBUGEXP
sentsex()                     /* quiz entry sex restrict - input handler   */
{
     usrqiz.fsexrst=usrqiz.ffemale=NO;
     switch( cncchr() ) {
     case 'F':                     /* female only                          */
          usrqiz.ffemale=YES;
     case 'M':                     /* male only                            */
          usrqiz.fsexrst=YES;
     case 'N':                     /* no restriction                       */
          break;
     default:
          prf( mmkcls );
          eprompt( ESEXHLP );
          return;
     }
     prompt( ENTRKEY );
}                             /* end sentsex                               */

LOCAL void DEBUGEXP
sentrkey()                    /* quiz entry key          - input handler   */
{
     if( morcnc() == '?' ) {
          eprompt( HLPKEY );
          return;
     }
     else if( morcnc() == '-' ) {
          memset( usrqiz.fkey, 0, KEYSIZ );
     }
     else if( morcnc() != '.' ) {
          strzcpy( usrqiz.fkey, cncall(), KEYSIZ );
          strupr( usrqiz.fkey );
     }
     cncall();
     prompt( !usesex || usrqiz.fsexrst ? SEAAGE : DEFSEX );
}                             /* end sentrkey                              */

LOCAL void DEBUGEXP
sdefsex()                     /* quiz search default sex - input handler   */
{
     usrqiz.defsex=BOTH;
     switch( cncchr() ) {
     case 'O':                     /* opposite sex                         */
          usrqiz.defsex=OPPO;
          break;
     case 'S':                     /* same sex                             */
          usrqiz.defsex=SAME;
          break;
     case 'B':                     /* include both                         */
          break;
     case '?':
          prf( mmkcls );
          eprompt( HLPDFSEX );
          return;
     default:
          eprompt( BADSEL );
          return;
     }
     prompt( SEAAGE );
}                             /* end sdefsex                               */

LOCAL void DEBUGEXP
sseaage()                     /* quiz search age restrict- input handler   */
{
     if( morcnc() == '-' ) {
          usrqiz.sagemax=YES;
          cncchr();
     }
     else {
          usrqiz.sagemax=NO;
     }
     if( isdigit(morcnc()) ) {
          usrqiz.sage=cncint();
     }
     else if( cncchr() == '.' ) {
          usrqiz.sage=usrqiz.fage;
          usrqiz.sagemax=usrqiz.fagemax;
     }
     else {
          prf( mmkcls );
          eprompt( SAGEHLP );
          return;
     }
     if( usesex ) {
          prompt( SEASEX2 );
     }
     else {
          usrqiz.ssexrst=usrqiz.sfemale=NO;
          prompt( SEAKEY );
     }
}                             /* end sseaage                               */

LOCAL void DEBUGEXP
sseasex()                     /* quiz search sex restrict- input handler   */
{
     usrqiz.ssexrst=usrqiz.sfemale=NO;
     switch( cncchr() ) {
     case 'F':                     /* female only                          */
          usrqiz.sfemale=YES;
     case 'M':                     /* male only                            */
          usrqiz.ssexrst=YES;
     case 'N':                     /* no restriction                       */
          break;
     case 'S':                     /* same as entry restrictions           */
          usrqiz.ssexrst=usrqiz.fsexrst;
          usrqiz.sfemale=usrqiz.ffemale;
          break;
     default:
          eprompt( SSEXHLP2 );
          return;
     }
     prompt( SEAKEY );
}                             /* end sseasex                               */

LOCAL void DEBUGEXP
sseakey()                     /* quiz search key         - input handler   */
{
     if( morcnc() == '?' ) {
          eprompt( HLPKEY );
          return;
     }
     else if( morcnc() == '-' ) {
          memset( usrqiz.fkey, 0, KEYSIZ );
     }
     else if( morcnc() == '.' ) {
          strzcpy( usrqiz.skey, usrqiz.fkey, KEYSIZ );
     }
     else {
          strzcpy( usrqiz.skey, cncall(), KEYSIZ );
          strupr( usrqiz.skey );
     }
     cncall();
     mchusr->qizedited=YES;
     updqiz();
     mchusr->nxtrou();
}                             /* end sseacls                               */

LOCAL void DEBUGEXP
sqiztyp()                     /* questionnaire type      - input handler   */
{
     switch( cncchr() ) {
     case 'T':                     /* text only                            */
          usrqiz.qiztyp=TEXTQ;
          break;
     case 'M':                     /* multiple choice                      */
          usrqiz.qiztyp=MULTC;
          break;
     case 'B':                     /* mixed, multiple choice and text      */
          usrqiz.qiztyp=MIXED;
          break;
     default:
          eprompt( TYPHLP );
          return;
     }
     mchusr->qizedited=YES;
     updqiz();
     memset( usrqsp, 0, sizeof(Question) );
     iniqsk( usrqsp, usrqiz.quizno, 1 );
     if( qeqbtv(usrqsp,TYPKEY) ) {
          mchusr->nxtrou=catrou;
          prompt( MODWHT );
     }
     else {
          mchusr->nxtrou=addnqst;
          numrsp();
     }
}                             /* end sqiztyp                               */

LOCAL void DEBUGEXP
snumrsps()                    /* how many responses      - input handler   */
{
     INT maxrsp=-1;

     if( isdigit(morcnc()) ) {
          maxrsp=cncint();
     }
     if( morcnc() == 'T' ) {
          cncchr();
          if( !usrqst.txtlen && spcavl() < 2 ) {
               eprompt( NOTXTSPC );
          }
          else {
               if( maxrsp < 0 ) {
                    usrqst.maxrsp=TXTRESP;
               }
               else {
                    usrqst.maxrsp=maxrsp;
               }
               usrqst.rspoffs=usrqiz.txtoffs;
               prompt( TRSPLEN );
          }
     }
     else if( maxrsp < 0 ) {
          eprompt( HLPNRSP );
     }
     else {
          usrqst.maxrsp=maxrsp;
          prompt( EXCLUDE );
     }
}                             /* end snumrsps                              */

LOCAL void DEBUGEXP
snumrspmc()                   /* number of rspn, mc only - input handler   */
{
     if( isdigit(morcnc()) ) {
          usrqst.maxrsp=cncint();
          prompt( EXCLUDE );
     }
     else {
          eprompt( NRMCHLP );
     }
}                             /* end snumrspmc                             */

LOCAL void DEBUGEXP
strsplen()                    /* text response length    - input handler   */
{
     if( isdigit(morcnc()) && (usrqst.txtlen=cncint())+1 <= spcavl() ) {
          if( !usrqiz.txtoffs && usrqst.txtlen ) {
               usrqiz.brfqst=usrqst.qstnno;
               usrqiz.brftxt=0;
          }
          usrqiz.txtoffs+=usrqst.txtlen+1;
          mchusr->qstedited=mchusr->qizedited=YES;
          updqiz();
          if( mchusr->nxtrou != catrou ) {
               prompt( txtresp() ? ADDQST : EXCLUDE );
          }
          else {
               shoqst( EQSTFMT2, 0 );
               prompt( MODQST );
          }
     }
     else {
          usrqst.txtlen=0;
          prfmsg( BADNUM, 1, spcavl()-1 );
          eprompt( 0 );
     }
}                             /* end strsplen                              */

LOCAL void DEBUGEXP
sexclude()                    /* use in search           - input handler   */
{
     switch( cncyesno() ) {
     case 'Y':
          usrqst.exclude=NO;
          break;
     case 'N':
          usrqst.exclude=YES;
          break;
     default:
          eprompt( EXCHLP );
          return;
     }
     prompt( ADDQST );
}                             /* end sexclude                              */

LOCAL void DEBUGEXP
saddrsp()                     /* add new response        - input handler   */
{
     strzcpy( mchusr->edtbuf, cncall(), RSPSIZ );
     mchusr->edtbuf[RSPLEN]=0;
     trm2( mchusr->edtbuf );
     if( *mchusr->edtbuf ) {
          switch( usrptr->substt ) {
          case ADDRSP:
               if( usrqst.rspcnt+1 > MAXRSP ) {
                    catastro( "SADDRSP: Attempt to add too many responses" );
               }
               mchusr->rspno=usrqst.rspcnt+1;
               usrqst.qrssiz=inszstr( mchusr->rspno, usrqst.rspcnt+1,
                    mchusr->edtbuf, usrqst.qrsspc );
               usrqst.rspcnt++;
               break;
          case INSRSP:
               if( usrqst.rspcnt+1 > MAXRSP ) {
                    catastro( "SADDRSP: Attempt to insert too many responses (%d)",
                         mchusr->rspno );
               }
               if( mchusr->rspno > usrqst.rspcnt ) {
                    catastro( "SADDRSP: Invalid response number on insert (%d)",
                         mchusr->rspno );
               }
               usrqst.qrssiz=inszstr( mchusr->rspno, usrqst.rspcnt+1,
                    mchusr->edtbuf, usrqst.qrsspc );
               usrqst.rspcnt++;
               break;
          case NEWRSP2:
               if( mchusr->rspno > usrqst.rspcnt ) {
                    catastro( "SADDRSP: Invalid response number on replace (%d)",
                         mchusr->rspno );
               }
               usrqst.qrssiz=repzstr( mchusr->rspno, usrqst.rspcnt+1,
                    mchusr->edtbuf, usrqst.qrsspc );
               break;
          }
          if( strlen(mchusr->edtbuf) > usrqst.rsplen ) {
               usrqst.rsplen=strlen( mchusr->edtbuf );
          }
          mchusr->qstedited=YES;
          updqiz();
          if( usrqst.rspcnt < MAXRSP && usrptr->substt == ADDRSP ) {
               shoqst( FQSTFMT, -1 );
               setwid( RSPLEN );
               mchusr->rspno=usrqst.rspcnt+1;
               prompt( ADDRSP );
               return;
          }
     }
     rstrwid();
     mchusr->nxtrou();
}                             /* end saddrsp                               */

LOCAL void DEBUGEXP
sqdelwch()                    /* delete which quiz       - input handler   */
{
     if( isdigit(morcnc()) ) {
          iniqzk( usrqzp, cncint() );
          if( !usrqiz.quizno ) {
               usrqiz.quizno=MAXQIZ+1;
          }
          if( qizrsps(usrqiz.quizno) ) {
               mchusr->nxtrou=qnowdel;
               prompt( MSTCLR );
          }
          else {
               qnowdel();
          }
     }
     else if( cncchr() == 'L' ) {
          setbtv( qizbb );
          iniqzk( usrqzp, 0 );
          if( qnxqiz(usrqzp) ) {
               gcrbtv( usrqzp, TYPKEY );
               mchusr->nxtrou=qdelwch;
               prompt( QUIZLIST );
               shoqiz( BRFQFMT2 );
          }
          else {
               prfmsg( NOQIZS );
               prompt( MODWCH2 );
          }
     }
     else {
          eprompt( BADSEL );
     }
}                             /* end sqdelwch                              */

LOCAL void DEBUGEXP
sqyesdel()                    /* verify delete quiz      - input handler   */
{
     switch( cncyesno() ) {
     case 'Y':
          mchusr->nxtrou=qdelren;
          ininmk( nkyp, usrqiz.quizno, 0 );
          if( delqiz() ) {
               prompt( DQIZCYCL );
               break;
          }
          prf( "Unknown error attempting to delete.  Nothing deleted.\n\n" );
     case 'N':
          qdelwch();
          break;
     default:
          eprompt( YORN );
     }
}                             /* end sqyesdel                              */

LOCAL void DEBUGEXP
sdqizcycl()                   /* delete quiz             - status handler  */
{
     if( delqiz() ) {
          working( NO );
     }
     else {
          working( YES );
          mchusr->nxtrou();
     }
}                             /* end sdqizcycl                             */

LOCAL void DEBUGEXP
srenqizu()                    /* renumbering quiz up     - status handler  */
{
     setbtv( qizbb );
     if( qprqzn(nkyp,usrqiz.quizno,0xFFFF) ) {
          memcpy( nkyp, bbnkyp, sizeof(SeqKey) );
          gcrbtv( NULL, NUMKEY );
          bbqzp->quizno++;
          upvbtv( NULL, bbqzp->type == QUIZ ? qizsiz(bbqzp) : qstsiz(bbqsp) );
          working( NO );
     }
     else {
          working( YES );
          setbtv( entbb );
          memset( ekyp, 0, sizeof(Namekey) );
          ekyp->quizno=MAXQIZ;
          if( usrqiz.quizno != 0 && qltbtv(ekyp,ENTKEY) && bbekyp->quizno >= usrqiz.quizno ) {
               prompt( RENENTSU );
          }
          else {
               prfmsg( usrqiz.quizno == 0 ? RENABTD : RENDUN );
               mchusr->nxtrou();
          }
     }
}                             /* end srenqizu                              */

LOCAL void DEBUGEXP
srenentsu()                   /* renumbering entries up  - status handler  */
{
     setbtv( entbb );
     if( qltbtv(ekyp,ENTKEY) && bbekyp->quizno >= usrqiz.quizno ) {
          memcpy( ekyp, bbekyp, sizeof(Namekey) );
          gcrbtv( NULL, ENTKEY );
          bbentp->quizno++;
          upvbtv( NULL, bbentp->entsiz );
          working( NO );
     }
     else {
          working( YES );
          prfmsg( usrqiz.quizno == 0 ? RENABTD : RENDUN );
          mchusr->nxtrou();
     }
}                             /* end srenentsu                             */

LOCAL void DEBUGEXP
srenqizd()                    /* renumbering quiz down   - status handler  */
{
     setbtv( qizbb );
     if( qnxqzn(nkyp,0xFFFF) ) {
          memcpy( nkyp, bbnkyp, sizeof(SeqKey) );
          gcrbtv( NULL, NUMKEY );
          bbqzp->quizno--;
          upvbtv( NULL, bbqzp->type == QUIZ ? qizsiz(bbqzp) : qstsiz(bbqsp) );
          working( NO );
     }
     else {
          working( YES );
          setbtv( entbb );
          memset( ekyp, 0, sizeof(Namekey) );
          ekyp->quizno=usrqiz.quizno;
          if( usrqiz.quizno != MAXQIZ && qgtbtv(ekyp,ENTKEY) ) {
               prompt( RENENTSD );
          }
          else {
               prfmsg( usrqiz.quizno == MAXQIZ ? RENABTD : RENDUN );
               mchusr->nxtrou();
          }
     }
}                             /* end srenqizd                              */

LOCAL void DEBUGEXP
srenentsd()                   /* renumbering entries down- status handler  */
{
     setbtv( entbb );
     if( qgtbtv(ekyp,ENTKEY) ) {
          memcpy( ekyp, bbekyp, sizeof(Namekey) );
          gcrbtv( NULL, ENTKEY );
          bbentp->quizno--;
          upvbtv( NULL, bbentp->entsiz );
          working( NO );
     }
     else {
          working( YES );
          prfmsg( usrqiz.quizno == MAXQIZ ? RENABTD : RENDUN );
          mchusr->nxtrou();
     }
}                             /* end srenentsd                             */

LOCAL void DEBUGEXP
sqinsbfr()                    /* insert questionnaire    - input handler   */
{
     INT quizno;

     setbtv( qizbb );
     if( isdigit(morcnc()) ) {
          quizno=cncint();
          if( quizno <= 0 || quizno >= MAXQIZ ) {
               eprompt( INVQZN );
               return;
          }
          iniqzk( usrqzp, quizno );
          if( qeqbtv(usrqzp,TYPKEY) ) {
               memset( usrqzp, 0, sizeof(Questionnaire) );
               iniqzk( usrqzp, quizno );
               ininmk( nkyp, MAXQIZ, 0 );
               mchusr->nxtrou=insqiz;
               prompt( RENQIZU );
          }
          else if( qnxqiz(usrqzp) ) {
               prompt( ADDQIZ );
          }
          else {
               eprompt( QUSEADD );
          }
     }
     else if( cncchr() == 'L' ) {
          iniqzk( usrqzp, 0 );
          if( qnxqiz(usrqzp) ) {
               gcrbtv( usrqzp, TYPKEY );
               mchusr->nxtrou=qinsbfr;
               prompt( QUIZLIST );
               shoqiz( BRFQFMT2 );
          }
          else {
               prfmsg( NOQIZS );
               prompt( MODWCH2 );
          }
     }
     else {
          eprompt( BADSEL );
     }
}                             /* end sqinsbfr                              */

LOCAL void DEBUGEXP
smodwht()                     /* modify what item        - input handler   */
{
     if( !mchusr->syspr && !mmkop() ) {
          catastro( "Match Maker, MODWHT invalid user %s", usaptr->userid );
     }
     if( isdigit(morcnc()) ) {     /* edit a question                      */
          setbtv( qizbb );
          iniqsk( usrqsp, usrqiz.quizno, cncint() );
          if( qeqbtv(usrqsp,TYPKEY) ) {
               gcrbtv( usrqsp, TYPKEY );
               shoqst( EQSTFMT2, 0 );
               prompt( MODQST );
          }
          else {
               eprompt( NOTHERE );
          }
     }
     else {
          switch( cncchr() ) {
          case 'N':                  /* change quiz name                       */
               prompt( NEWQNAM );
               break;
          case 'R':                  /* change age restrictions                */
               mchusr->nxtrou=modwht;
               prompt( QIZPFN );
               break;
          case 'A':                  /* add questions                          */
               if( mchusr->qizrsps ) {
                    mchusr->nxtrou=modwht;
                    prompt( MSTCLR );
                    break;
               }
               else if( spcavl() < rspsiz(1) ) {
                    eprompt( NOSPACE );
                    break;
               }
               setbtv( qizbb );
               memset( usrqsp, 0, sizeof(Question) );
               iniqsk( bbkyp, usrqiz.quizno, MAXQIZ );
               if( qprqst(NULL,usrqiz.quizno) ) {
                    iniqsk( usrqsp, bbkyp->quizno, bbkyp->qstnno+1 );
               }
               else {
                    iniqsk( usrqsp, usrqiz.quizno, 1 );
               }
               if( usrqiz.qsthi != usrqst.qstnno ) {
                    usrqiz.qsthi=usrqst.qstnno;
                    mchusr->qizedited=YES;
                    updqiz();
               }
               if( usrqst.qstnno > MAXQST ) {
                    eprompt( TOOMANY );
               }
               else {
                    mchusr->nxtrou=addnqst;
                    numrsp();
               }
               break;
          case 'D':                  /* delete a question                      */
               if( mchusr->qizrsps ) {
                    mchusr->nxtrou=modwht;
                    prompt( MSTCLR );
                    break;
               }
               prompt( DELWCH );
               break;
          case 'I':                  /* insert a question                      */
               if( mchusr->qizrsps ) {
                    mchusr->nxtrou=modwht;
                    prompt( MSTCLR );
                    break;
               }
               else if( spcavl() < rspsiz(1) ) {
                    eprompt( NOSPACE );
                    break;
               }
               setbtv( qizbb );
               iniqsk( usrqsp, usrqiz.quizno, 0 );
               if( qnxqst(usrqsp,usrqst.quizno) ) {
                    prompt( INSBFR );
               }
               else {
                    eprompt( USEADD );
               }
               break;
          case 'L':                  /* list questions                         */
               setbtv( qizbb );
               iniqsk( usrqsp, usrqiz.quizno, 0 );
               if( qnxqst(usrqsp,usrqiz.quizno) ) {
                    gcrbtv( usrqsp, TYPKEY );
                    mchusr->nxtrou=modwht;
                    prompt( QSTNLIST );
                    shoqst( BQSTFMT, 0 );
               }
               else {
                    eprompt( NOQSTN );
               }
               break;
          case 'C':                  /* clear responses                        */
               if( mchusr->qizrsps ) {
                    prompt( YESCLR );
               }
               else {
                    eprompt( NORSPS );
               }
               break;
          case 'B':                  /* brief description question             */
               if( !usrqiz.txtoffs ) {
                    eprompt( (usrqiz.qiztyp&TEXTQ) ? NQSTYET : NOBRF );
               }
               else {
                    prompt( BRFTXTN );
               }
               break;
          case '.':
               shoqiz( FULLQFM2 );
               prompt( MODWHT );
               break;
          default:
               eprompt( MODQHLP );
          }
     }
}                             /* end smodwht                               */

LOCAL void DEBUGEXP
snewqnam()                    /* new quiz name           - input handler   */
{
     rstrwid();
     strcpy( usrqiz.name, cncall() );
     if( usrqiz.name[0] ) {
          mchusr->qizedited=YES;
          updqiz();
          shoqiz( FULLQFM2 );
          prompt( MODWHT );
     }
     else {
          eprompt( NEEDNAME );
     }
}                             /* end snewqnam                              */

LOCAL void DEBUGEXP
sdelwch()                     /* delete which question   - input handler   */
{
     setbtv( qizbb );
     if( isdigit(morcnc()) ) {
          iniqsk( usrqsp, usrqiz.quizno, cncint() );
          if( qeqbtv(usrqsp,TYPKEY) ) {
               gcrbtv( usrqsp, TYPKEY );
               shoqst( FQSTFMT, -1 );
               prompt( YESDEL );
          }
          else if( usrqiz.quizno && qnxqst(usrqsp,usrqst.quizno) ) {
               delren();
          }
          else {
               prfmsg( NOTHERE );
               prompt( MODWHT );
          }
     }
     else if( cncchr() == 'L' ) {
          iniqsk( usrqsp, usrqiz.quizno, 0 );
          if( qnxqst(usrqsp,usrqst.quizno) ) {
               gcrbtv( usrqsp, TYPKEY );
               mchusr->nxtrou=delwch;
               prompt( QSTNLIST );
               shoqst( BQSTFMT, 0 );
          }
          else {
               prfmsg( NOQSTN );
               prompt( MODWHT );
          }
     }
     else {
          eprompt( BADSEL );
     }
}                             /* end sdelwch                               */

LOCAL void DEBUGEXP
syesdel()                     /* verify delete question  - input handler   */
{
     switch( cncyesno() ) {
     case 'Y':
          if( usrqst.rspoffs ) {
               mchusr->nxtrou=delrfmt;
          }
          else {
               mchusr->nxtrou=delren;
          }
          iniqsk( bbqsp, usrqst.quizno, usrqst.qstnno );
          setbtv( qizbb );
          if( qeqbtv(NULL,TYPKEY) ) {
               gcrbtv( NULL, TYPKEY );
               delbtv();
               if( usrqiz.brfqst == usrqst.qstnno ) {
                    usrqiz.brfqst=usrqiz.brftxt=0;
                    mchmail->editflgs=0;
                    mchusr->qizedited=YES;
                    updqiz();
               }
               if( !qnxqst(usrqsp,usrqiz.quizno) ) {
                    if( qprqst(usrqsp,usrqiz.quizno) ) {
                         usrqiz.qsthi=bbkyp->qstnno;
                    }
                    else {
                         usrqiz.qsthi=0;
                    }
                    mchmail->editflgs=NO;
                    mchusr->qizedited=YES;
                    updqiz();
               }
               mchusr->nxtrou();
               break;
          }
          prf( "Unknown error attempting to delete.  Nothing deleted.\n\n" );
     case 'N':
          delwch();
          break;
     default:
          eprompt( YORN );
     }
}                             /* end syesdel                               */

LOCAL void DEBUGEXP
srfmttxt()                    /* reformat text after del - status handler  */
{
     if( qnxqst(qkyp,usrqst.quizno) ) {
          memcpy( qkyp, bbkyp, sizeof(TypeKey) );
          gcrbtv( NULL, TYPKEY );
          if( bbqsp->txtlen ) {
               bbqsp->rspoffs=usrqiz.txtoffs;
               usrqiz.txtoffs+=bbqsp->txtlen+1;
               if( usrqiz.brfqst == usrqst.qstnno ) {
                    usrqiz.brfqst=usrqst.qstnno;
                    usrqiz.brftxt=bbqsp->rspoffs;
               }
               upvbtv( NULL, qstsiz(bbqsp) );
          }
          working( NO );
     }
     else {
          mchusr->qizedited=YES;
          updqiz();
          working( YES );
          mchusr->nxtrou();
     }
}                             /* end srfmttxt                              */

LOCAL void DEBUGEXP
srenqstu()                    /* renumbering questions up- status handler  */
{
     setbtv( qizbb );
     if( qprqzn(nkyp,usrqst.quizno,usrqst.qstnno) ) {
          memcpy( nkyp, bbnkyp, sizeof(SeqKey) );
          gcrbtv( NULL, NUMKEY );
          bbqsp->qstnno++;
          upvbtv( NULL, qstsiz(bbqsp) );
          if( bbqsp->qstnno > usrqiz.qsthi ) {
               usrqiz.qsthi=bbqsp->qstnno;
               mchusr->qizedited=YES;
               updqiz();
          }
          working( NO );
     }
     else {
          working( YES );
          prfmsg( usrqst.qstnno == 0 ? RENABTD : RENDUN );
          mchusr->nxtrou();
     }
}                             /* end srenqstu                              */

LOCAL void DEBUGEXP
srenqstd()                    /* renumbering questions dn- status handler  */
{
     setbtv( qizbb );
     if( qnxqzn(nkyp,usrqst.quizno) ) {
          memcpy( nkyp, bbnkyp, sizeof(SeqKey) );
          gcrbtv( NULL, NUMKEY );
          bbqsp->qstnno--;
          upvbtv( NULL, qstsiz(bbqsp) );
          working( NO );
     }
     else {
          if( nkyp->qstnno <= usrqiz.qsthi ) {
               usrqiz.qsthi=nkyp->qstnno-1;
               mchusr->qizedited=YES;
               updqiz();
          }
          working( YES );
          prfmsg( usrqst.qstnno == MAXQIZ ? RENABTD : RENDUN );
          mchusr->nxtrou();
     }
}                             /* end srenqstd                              */

LOCAL void DEBUGEXP
sinsbfr()                     /* insert question before?   input handler   */
{
     INT qstnno;

     setbtv( qizbb );
     if( isdigit(morcnc()) ) {
          qstnno=cncint();
          memset( usrqsp, 0, sizeof(Question) );
          iniqsk( usrqsp, usrqiz.quizno, qstnno );
          if( qeqbtv(usrqsp,TYPKEY) ) {
               ininmk( nkyp, usrqiz.quizno, MAXQST );
               mchusr->nxtrou=insqst;
               prompt( RENQSTU );
          }
          else if( qnxqst(usrqsp,usrqiz.quizno) ) {
               mchusr->nxtrou=modwht;
               numrsp();
          }
          else {
               eprompt( USEADD );
          }
     }
     else if( cncchr() == 'L' ) {
          iniqsk( usrqsp, usrqiz.quizno, 0 );
          if( qnxqst(usrqsp,usrqst.quizno) ) {
               gcrbtv( usrqsp, TYPKEY );
               mchusr->nxtrou=insbfr;
               prompt( QSTNLIST );
               shoqst( BQSTFMT, 0 );
          }
          else {
               prfmsg( NOQSTN );
               prompt( MODWHT );
          }
     }
     else {
          eprompt( BADSEL );
     }
}                             /* end sinsbfr                               */

LOCAL void DEBUGEXP
sqstlnxt()                    /* list current quiz questn- input handler   */
{
     if( morcnc() == 'C' ) {
          prompt( QSTNLIST );
     }
     else {
          mchusr->nxtrou();
     }
}                             /* end sqstlnxt                              */

LOCAL void DEBUGEXP
sqstnlist()                   /* list current quiz questn- status handler  */
{
     setbtv( qizbb );
     if( qnxqst(usrqsp,usrqiz.quizno) ) {
          gcrbtv( usrqsp, TYPKEY );
          shoqst( BQSTFMT, 0 );
          if( ++mchusr->ival >= 15 ) {
               prompt( QSTLNXT );
          }
     }
     else {
          prfmsg( ENDQST );
          mchusr->nxtrou();
     }
}                             /* end sqstnlist                             */

LOCAL void DEBUGEXP
syesclr()                     /* verify clear responses  - input handler   */
{
     switch( cncyesno() ) {
     case 'Y':
          mchusr->nxtrou=modwht;
          memset( ekyp, 0, sizeof(Namekey) );
          ekey.quizno=usrqiz.quizno;
          prompt( CLRRSP );
          break;
     case 'N':
          modwht();
          break;
     default:
          eprompt( YORN );
     }
}                             /* end syesclr                               */

LOCAL void DEBUGEXP
smstclr()                     /* must clear responses    - input handler   */
{
     switch( cncyesno() ) {
     case 'Y':
          memset( ekyp, 0, sizeof(Namekey) );
          ekey.quizno=usrqiz.quizno;
          prompt( CLRRSP );
          break;
     case 'N':
          mchusr->nxtrou();
          break;
     default:
          eprompt( YORN );
     }
}                             /* end smstclr                               */

LOCAL void DEBUGEXP
sclrrsp()                     /* clear responses to quiz - status handler  */
{
     setbtv( entbb );
     if( qnxent(ekyp,ekey.quizno) ) {
          working( NO );
          gcrbtv( NULL, ENTKEY );
          delbtv();
     }
     else {
          working( YES );
          mchusr->qizrsps=NO;
          mchusr->nxtrou();
     }
}                             /* end sclrrsp                               */

LOCAL void DEBUGEXP
smodqst()                     /* modify what item        - input handler   */
{
     if( !mchusr->syspr && !mmkop() ) {
          catastro( "Match Maker, MODQST invalid user %s", usaptr->userid );
     }
     setbtv( qizbb );
     if( isdigit(morcnc()) ) {     /* edit a response                      */
          mchusr->rspno=cncint();
          if( mchusr->rspno && mchusr->rspno <= usrqst.rspcnt ) {
               strzcpy( mchusr->edtbuf, fndzstr(mchusr->rspno,usrqst.qrsspc),
                    EDTSIZ );
               mchusr->nxtrou=modqst;
               prompt( NEWRSP2 );
          }
          else {
               eprompt( RNOHERE );
          }
     }
     else {
          switch( cncchr() ) {
          case 'Q':                  /* replace question text                  */
               prompt( EDITQST );
               break;
          case 'N':                  /* change number of selections            */
               if( mchusr->qizrsps && usrqst.txtlen ) {
                    mchusr->nxtrou=newnrsp;
                    prompt( MSTCLR );
               }
               else {
                    newnrsp();
               }
               break;
          case 'A':                  /* add responses                          */
               if( txtresp() ) {
                    eprompt( BADSEL );
                    break;
               }
               if( (mchusr->rspno=usrqst.rspcnt+1) > MAXRSP ) {
                    eprompt( RTOOMANY );
               }
               else {
                    mchusr->nxtrou=modqst;
                    prompt( ADDRSP );
               }
               break;
          case 'D':                  /* delete a reponse                       */
               if( txtresp() ) {
                    eprompt( BADSEL );
                    break;
               }
               if( mchusr->qizrsps ) {
                    mchusr->nxtrou=modqst;
                    prompt( MSTCLR );
                    break;
               }
               prompt( RDELWCH );
               break;
          case 'I':                  /* insert a response                      */
               if( txtresp() ) {
                    eprompt( BADSEL );
                    break;
               }
               if( mchusr->qizrsps ) {
                    mchusr->nxtrou=modqst;
                    prompt( MSTCLR );
                    break;
               }
               if( usrqst.rspcnt >= MAXRSP ) {
                    eprompt( RTOOMANY );
               }
               else if( usrqst.rspcnt ) {
                    prompt( RINSBFR );
               }
               else {
                    eprompt( RUSEADD );
               }
               break;
          case 'E':                  /* toggle exclude flag                    */
               if( txtresp() ) {
                    eprompt( TSCHONLY );
                    break;
               }
               usrqst.exclude=!usrqst.exclude;
               mchusr->qstedited=YES;
               updqiz();
          case 'L':                  /* relist question/responses              */
               shoqst( EQSTFMT2, 0 );
               prompt( MODQST );
               break;
          default:
               eprompt( MQSTHLP );
          }
     }
}                             /* end smodqst                               */

LOCAL void DEBUGEXP
snewnrsps()                   /* how many responses      - input handler   */
{
     INT     maxrsp, len;
     boolean txt;

     maxrsp=-1;
     txt=NO;
     if( isdigit(morcnc()) ) {
          maxrsp=cncint();
     }
     if( morcnc() == 'T' ) {
          cncchr();
          txt=YES;
          if( usrqst.txtlen+spcavl() < 2 ) {
               eprompt( NOTXTSPC );
               return;
          }
          if( maxrsp < 0 ) {
               maxrsp=TXTRESP;
          }
     }
     else if( maxrsp < 0 ) {
          eprompt( HLPNRSP );
          return;
     }
     if( maxrsp == TXTRESP && !txtresp() ) {
        usrqst.rspcnt=0;
        memset( usrqst.qrsspc+(len=strlen(usrqst.qrsspc)), 0, QRSSIZ-len );
        usrqst.qrssiz=len+1;
     }
     if( txt && !usrqst.txtlen ) {
          usrqst.maxrsp=maxrsp;
          usrqst.rspoffs=usrqiz.txtoffs;
          mchusr->qstedited=YES;
          updqiz();
          prompt( TRSPLEN );
     }
     else if( !txt && usrqst.txtlen ) {
          usrqst.maxrsp=maxrsp;
          usrqst.txtlen=usrqst.rspoffs=0;
          mchusr->qstedited=YES;
          updqiz();
          mchusr->nxtrou=modqst;
          reformat();
     }
     else if( usrqst.maxrsp == maxrsp ) {
          prompt( NEWRSPL );
     }
     else {
          usrqst.maxrsp=maxrsp;
          mchusr->qstedited=YES;
          updqiz();
          shoqst( EQSTFMT2, 0 );
          prompt( MODQST );
     }
}                             /* end snewnrsps                             */

LOCAL void DEBUGEXP
snewnrspm()                   /* how many responses      - input handler   */
{
     if( isdigit(morcnc()) ) {
          usrqst.maxrsp=cncint();
          mchusr->qstedited=YES;
          updqiz();
          shoqst( EQSTFMT2, 0 );
          prompt( MODQST );
     }
     else {
          eprompt( NRMCHLP );
     }
}                             /* end snewnrspm                             */

LOCAL void DEBUGEXP
snewrspl()                    /* new text response length- input handler   */
{
     INT txtlen;

     if( isdigit(morcnc()) && (txtlen=cncint()) <= usrqst.txtlen+spcavl()-1 ) {
          usrqst.txtlen=txtlen;
          mchusr->qstedited=YES;
          updqiz();
          mchusr->nxtrou=modqst;
          reformat();
     }
     else {
          prfmsg( BADNUM, 1, usrqst.txtlen+spcavl()-1 );
          eprompt( 0 );
     }
}                             /* end snewrspl                              */

LOCAL void DEBUGEXP
srdelwch()                     /* delete which response  - input handler   */
{
     if( isdigit(morcnc()) ) {
          mchusr->rspno=cncint();
          if( mchusr->rspno && mchusr->rspno <= usrqst.rspcnt ) {
               usrqst.qrssiz=remzstr( mchusr->rspno, usrqst.rspcnt+1,
                    usrqst.qrsspc );
               usrqst.rspcnt--;
               mchusr->qstedited=YES;
               updqiz();
          }
          else {
               prfmsg( RNOHERE );
          }
          prompt( MODQST );
     }
     else if( cncchr() == 'L' ) {
          shoqst( EQSTFMT2, 0 );
          prompt( RDELWCH );
     }
     else {
          eprompt( BADSEL );
     }
}                             /* end srdelwch                              */

LOCAL void DEBUGEXP
srinsbfr()                    /* insert response before?   input handler   */
{
     if( isdigit(morcnc()) ) {
          mchusr->rspno=cncint();
          if( mchusr->rspno && mchusr->rspno <= usrqst.rspcnt ) {
               mchusr->nxtrou=modqst;
               memset( mchusr->edtbuf, 0, EDTSIZ );
               prompt( INSRSP );
          }
          else {
               eprompt( USEADD );
          }
     }
     else if( cncchr() == 'L' ) {
          shoqst( EQSTFMT2, 0 );
          eprompt( RINSBFR );
     }
     else {
          eprompt( BADSEL );
     }
}                             /* end srinsbfr                              */

LOCAL void DEBUGEXP
sfillwch()                    /* fill out which quiz     - input handler   */
{
     setbtv( qizbb );
     if( isdigit(morcnc()) ) {     /* fill out quiz                        */
          iniqzk( usrqzp, cncint() );
          if( usrqiz.quizno && qeqbtv(usrqzp,TYPKEY) ) {
               gcrbtv( usrqzp, TYPKEY );
               if( mmk_qizacc(NO) ) {
                    mchusr->alwpfn=usrqiz.alwpfn;
                    setbtv( entbb );
                    strzcpy( bbukyp->userid, usaptr->userid, UIDSIZ );
                    bbukyp->quizno=usrqiz.quizno;
                    if( !acqbtv(usrentp,NULL,UIDKEY) ) {
                         memset( usrentp, 0, sizeof(Entry) );
                         strzcpy( usrent.userid, usaptr->userid, UIDSIZ );
                         strzcpy( usrent.name, mchusr->name, UIDSIZ );
                         usrent.age=mchusr->age;
                         usrent.sex=(mchusr->female ? 'F' : 'M');
                         usrent.quizno=usrqiz.quizno;
                         usrent.entsiz=mmk_entsiz();
                    }
                    setbtv( qizbb );
                    iniqsk( usrqsp, usrqiz.quizno, 0 );
                    if( qnxqst(usrqsp,usrqst.quizno) ) {
                         gcrbtv( usrqsp, TYPKEY );
                         mchusr->nxtrou=fillwch;
                         usrent.filled=YES;
                         nxtqstn();
                    }
                    else {
                         eprompt( ENOQST );
                    }
               }
               else {
                    eprompt( ENOACC );
               }
          }
          else {
               eprompt( QNOHERE );
          }
     }
     else if( cncchr() == 'L' ) {
          iniqzk( usrqzp, 0 );
          if( qnxqiz(usrqzp) ) {
               gcrbtv( usrqzp, TYPKEY );
               mchusr->nxtrou=fillwch;
               prompt( QUIZLIST );
               if( shwall || mmk_qizacc(NO) ) {
                    shoqiz( BRFQFMT2 );
               }
          }
     }
     else {
          eprompt( BADSEL );
     }
}                             /* end sfillwch                              */

LOCAL void DEBUGEXP
snxtrsp()                     /* next response to qstn   - input handler   */
{
     INT rn;
     long rspbit;

     if( isdigit(morcnc()) ) {     /* selecting response                   */
          rn=cncint();
          if( rn <= 0 || rn > usrqst.rspcnt ) {
               prfmsg( BADNUM, 1, usrqst.rspcnt );
               shoqst( FQSTFMT, mchusr->sel );
               eprompt( 0 );
               return;
          }
          rspbit=(long)1<<(rn-1);
          if( mchusr->sel&rspbit ) {
               mchusr->sel&=~rspbit;
               if( usrqst.txtlen && rn == usrqst.rspcnt && mchusr->rspp != rtrsh ) {
                    memset( mchusr->rspp, 0, usrqst.txtlen+1 );
                    mchusr->entedited=YES;
               }
               mchusr->seledited=YES;
          }
          else if( !mchusr->srch && usrqst.maxrsp > 1 &&
                    btctr(mchusr->sel) >= usrqst.maxrsp ) {
               prfmsg( RSPLMT, usrqst.maxrsp );
          }
          else {
               if( !mchusr->srch && usrqst.maxrsp == 1 ) {
                    mchusr->sel=rspbit;
               }
               else {
                    mchusr->sel|=rspbit;
               }
               mchusr->seledited=YES;
               if( !mchusr->srch && rn == usrqst.rspcnt && usrqst.txtlen
                && mchusr->rspp != rtrsh ) {
                    prompt( TXTALT );
                    return;
               }
               if( !morcnc() && btctr(mchusr->sel) >= (!mchusr->srch
                && usrqst.maxrsp ? usrqst.maxrsp : usrqst.rspcnt) ) {
                    if( mchusr->srch ) {
                         sselect()=mchusr->sel;
                    }
                    else {
                         eselect()=mchusr->sel;
                    }
                    mchusr->seledited=NO;
                    mchusr->entedited=YES;
                    setbtv( qizbb );
                    setbtv( qizbb );
                    while( qnxqst(usrqsp,usrqst.quizno) ) {
                         gcrbtv( usrqsp, TYPKEY );
                         if( !mchusr->srch || !(txtresp() || usrqst.exclude) ) {
                              nxtqstn();
                              return;
                         }
                    }
                    prompt( SAVNXIT );
                    return;
               }
          }
          shoqst( FQSTFMT, mchusr->sel );
          prompt( NXTRSP2 );
     }
     else {
          if( mchusr->seledited ) {
               if( mchusr->srch ) {
                    sselect()=mchusr->sel;
               }
               else {
                    eselect()=mchusr->sel;
               }
               mchusr->seledited=NO;
               mchusr->entedited=YES;
          }
          switch( cncchr() ) {
          case 'P':                  /* previous question                      */
               setbtv( qizbb );
               rn=usrqst.qstnno;
               while( qprqst(usrqsp,usrqst.quizno) ) {
                    gcrbtv( usrqsp, TYPKEY );
                    if( !mchusr->srch || !(txtresp() || usrqst.exclude) ) {
                         nxtqstn();
                         return;
                    }
               }
               if( mchusr->srch ) {
                    usrqst.qstnno=rn;
                    geqbtv( usrqsp, usrqsp, TYPKEY );
               }
               eprompt( NOPRVQ );
               break;
          case 'N':                  /* next question                          */
               if( mchusr->srch || alwnan || mchusr->sel ) {
                    setbtv( qizbb );
                    while( qnxqst(usrqsp,usrqst.quizno) ) {
                         gcrbtv( usrqsp, TYPKEY );
                         if( !mchusr->srch || !(txtresp() || usrqst.exclude) ) {
                              nxtqstn();
                              return;
                         }
                    }
                    prompt( SAVNXIT );
               }
               else {
                    eprompt( MSTANS );
               }
               break;
          case 'D':                  /* save entry and exit                    */
               if( mchusr->srch || alwnan ) {
                    rstrwid();
                    if( !mchusr->srch ) {
                         usrent.filled=YES;
                    }
                    else {
                         usrent.searched=YES;
                    }
                    updusr();
                    mchusr->nxtrou();
               }
               else {
                    eprompt( BADSEL );
               }
               break;
          case '?':                  /* help                                   */
               eprompt( mchusr->srch ? RSPHLPS : RSPHLPE );
               break;
          default:
               eprompt( BADSEL );
          }
     }
}                             /* end snxtrsp                               */

LOCAL void DEBUGEXP
snxtrspt()                    /* text response to qstn   - input handler   */
{
     INT qn;

     switch( cncchr() ) {
     case 'E':                  /* edit response                           */
          if( usrqst.txtlen <= MAXNED ) {
               mchusr->rspp[0]=0;
          }
          shoqst( FQSTFMT, 0 );
          prompt( EDTTRSP );
          break;
     case 'P':                  /* previous question                       */
          setbtv( qizbb );
          qn=usrqst.qstnno;
          while( qprqst(usrqsp,usrqst.quizno) ) {
               gcrbtv( usrqsp, TYPKEY );
               if( !mchusr->srch || !(txtresp() || usrqst.exclude) ) {
                    nxtqstn();
                    return;
               }
          }
          if( mchusr->srch ) {
               usrqst.qstnno=qn;
               geqbtv( usrqsp, usrqsp, TYPKEY );
          }
          eprompt( NOPRVQ );
          break;
     case 'N':                  /* next question                           */
          if( mchusr->srch || alwnan || *mchusr->rspp ) {
               setbtv( qizbb );
               while( qnxqst(usrqsp,usrqst.quizno) ) {
                    gcrbtv( usrqsp, TYPKEY );
                    if( !mchusr->srch || !(txtresp() || usrqst.exclude) ) {
                         nxtqstn();
                         return;
                    }
               }
               prompt( SAVNXIT );
          }
          else {
               eprompt( MSTANS );
          }
          break;
     case 'C':                  /* clear response                          */
          if( usrqst.txtlen && mchusr->rspp != rtrsh && *mchusr->rspp ) {
               memset( mchusr->rspp, 0, usrqst.txtlen+1 );
               mchusr->entedited=YES;
          }
          if( !alwnan ) {
               if( usrqst.txtlen <= MAXNED ) {
                    mchusr->rspp[0]=0;
               }
               shoqst( FQSTFMT, 0 );
          }
          prompt( alwnan ? usrptr->substt : EDTTRSP );
          break;
     case 'D':                  /* save entry and exit                     */
          if( mchusr->srch || alwnan ) {
               rstrwid();
               if( !mchusr->srch ) {
                    usrent.filled=YES;
               }
               else {
                    usrent.searched=YES;
               }
               updusr();
               mchusr->nxtrou();
          }
          else {
               eprompt( BADSEL );
          }
          break;
     case '?':                  /* help                                    */
          eprompt( mchusr->srch ? RSPHLPS : RSPHLPE );
          break;
     default:
          eprompt( BADSEL );
     }
}                             /* end snxtrspt                              */

LOCAL void DEBUGEXP
sedttrsp()                    /* edit text response      - input handler   */
{
     endedtr( 0 );
     clrprf();
}                             /* end sedttrsp                              */


LOCAL void DEBUGEXP
stxtalt()                     /* text alternative resp   - input handler   */
{
     char *cp;

     rstrwid();
     if( !*(cp=cncall()) ) {
          mchusr->sel&=~((long)1<<(usrqst.rspcnt-1));
          memset( mchusr->rspp, 0, usrqst.txtlen+1 );
     }
     else {
          strzcpy( mchusr->rspp, cp, usrqst.txtlen+1 );
     }
     mchusr->entedited=YES;
     if( btctr(mchusr->sel) >= (usrqst.maxrsp ? usrqst.maxrsp : usrqst.rspcnt) ) {
          eselect()=mchusr->sel;
          mchusr->seledited=NO;
          setbtv( qizbb );
          if( qnxqst(usrqsp,usrqst.quizno) ) {
               gcrbtv( usrqsp, TYPKEY );
               nxtqstn();
          }
          else {
               prompt( SAVNXIT );
          }
          return;
     }
     shoqst( FQSTFMT, mchusr->sel );
     prompt( NXTRSP2 );
}                             /* end stxtalt                               */

LOCAL void DEBUGEXP
ssavnxit()                    /* save questionnaire?     - input handler   */
{
     setbtv( qizbb );
     switch( cncchr() ) {
     case 'R':                     /* restart questionnaire                */
          iniqsk( usrqsp, usrqiz.quizno, 0 );
          while( qnxqst(usrqsp,usrqst.quizno) ) {
               gcrbtv( usrqsp, TYPKEY );
               if( !mchusr->srch || !(txtresp() || usrqst.exclude) ) {
                    nxtqstn();
                    return;
               }
          }
          eprompt( ENOQST );
          break;
     case 'L':                     /* last question                        */
          iniqsk( usrqsp, usrqiz.quizno, MAXQST );
          while( qprqst(usrqsp,usrqst.quizno) ) {
               gcrbtv( usrqsp, TYPKEY );
               if( !mchusr->srch || !(txtresp() || usrqst.exclude) ) {
                    nxtqstn();
                    return;
               }
          }
          eprompt( ENOQST );
          break;
     case 'S':                     /* save entry and exit                  */
          if( mchusr->srch ) {
               usrent.searched=YES;
               updusr();
               rstrwid();
               mchusr->nxtrou();
          }
          else {
               eprompt( BADSEL );
          }
          break;
     case 'D':                     /* save entry and exit                  */
          if( !mchusr->srch ) {
               usrent.filled=YES;
               updusr();
               rstrwid();
               mchusr->nxtrou();
               break;
          }
     default:
          eprompt( mchusr->srch ? SNSHLP : SNXHLP );
     }
}                             /* end ssavnxit                              */

LOCAL void DEBUGEXP
ssrchwch()                    /* search which quiz       - input handler   */
{
     setbtv( qizbb );
     if( isdigit(morcnc()) ) {     /* search quiz                          */
          iniqzk( usrqzp, cncint() );
          if( usrqiz.quizno && qeqbtv(usrqzp,TYPKEY) ) {
               gcrbtv( usrqzp, TYPKEY );
               if( mmk_qizacc(YES) ) {
                    mchusr->alwpfn=usrqiz.alwpfn;
                    setbtv( entbb );
                    strzcpy( bbukyp->userid, usaptr->userid, UIDSIZ );
                    bbukyp->quizno=usrqiz.quizno;
                    mchusr->srch=YES;
                    mchusr->srched=NO;
                    mchusr->browse=NO;
                    mchusr->txtsrch=NO;
                    if( acqbtv(usrentp,NULL,UIDKEY) ) {
                         if( usrent.filled || mchusr->syspr || indsrch || !mmk_qizacc(NO) ) {
                              if( usrent.searched ) {
                                   mchusr->srched=YES;
                                   txtomch();
                                   return;
                              }
                         }
                         else {
                              eprompt( FILL1ST );
                              return;
                         }
                    }
                    else if( mchusr->syspr || indsrch || !mmk_qizacc(NO) ) {
                         memset( usrentp, 0, sizeof(Entry) );
                         strzcpy( usrent.userid, usaptr->userid, UIDSIZ );
                         strzcpy( usrent.name, mchusr->name, UIDSIZ );
                         usrent.age=mchusr->age;
                         usrent.sex=(mchusr->female ? 'F' : 'M');
                         usrent.quizno=usrqiz.quizno;
                         usrent.entsiz=mmk_entsiz();
                    }
                    else {
                         eprompt( FILL1ST );
                         return;
                    }
                    newsrch();
                    mchusr->srched=NO;
                    usrent.searched=YES;
                    mchusr->entedited=YES;
                    updusr();
                    txtomch();
               }
               else {
                    eprompt( ENOACC );
               }
          }
          else {
               eprompt( QNOHERE );
          }
     }
     else if( cncchr() == 'L' ) {
          iniqzk( usrqzp, 0 );
          if( qnxqiz(usrqzp) ) {
               gcrbtv( usrqzp, TYPKEY );
               mchusr->nxtrou=srchwch;
               prompt( QUIZLIST );
               if( mmk_qizacc(YES) ) {
                    shoqiz( BRFQFMT2 );
               }
          }
          else {
               eprompt( NOQIZ );
          }
     }
     else {
          eprompt( BADSEL );
     }
}                             /* end ssrchwch                              */

LOCAL void DEBUGEXP
stxtomch()                    /* text or match search    - input handler   */
{
     mchusr->srch=YES;
     switch( cncchr() ) {
     case 'B':                     /* browse entries                       */
          if( !usebrws ) {
               eprompt( BADSEL );
               return;
          }
          mchusr->browse=YES;
          mchusr->txtsrch=NO;
          mchusr->found=NO;
          mchusr->argv[0]=NULL;
          bgnsrch();
          return;
     case 'T':                     /* text search                          */
          if( !usrqiz.txtoffs || !txtsch ) {
               eprompt( BADSEL );
               return;
          }
          mchusr->browse=NO;
          mchusr->txtsrch=YES;
          mchusr->found=NO;
          mchusr->argv[0]=NULL;
          rstrwid();
          mchusr->nxtrou=srchtxt;
          break;
     case 'M':                     /* match search                         */
          if( usrqiz.type&MULTC ) {
               mchusr->browse=NO;
               mchusr->txtsrch=NO;
               mchusr->found=NO;
               mchusr->argv[0]=NULL;
               mchusr->nxtrou=srchpct;
               if( mchusr->srched ) {
                    prompt( ENTOGO );
                    return;
               }
          }
          else {
               prompt( BADSEL );
               return;
          }
          break;
     case '?':                     /* help                                 */
          eprompt( HLPSRCH );
          return;
     default:
          eprompt( BADSEL );
          return;
     }
     if( !usesex || usrqiz.fsexrst ) { /* only one sex can fill out */
          usrent.srchmale=usrent.srchfem=YES;
          if( useage ) {
               prompt( SRCHAGE );
          }
          else {
               usrent.agemax=99;
               usrent.agemin=0;
               mchusr->nxtrou();
          }
     }
     else {
          prompt( SRCHSEX );
     }
}                             /* end stxtomch                              */

LOCAL void DEBUGEXP
sentogo(void)                 /* redo search criteria?   - input handler   */
{
     switch( cncchr() ) {
     case 'R':                     /* redo criteria                        */
          newsrch();
     case 'E':                     /* edit existing criteria               */
          if( !usesex || usrqiz.fsexrst ) {
               usrent.srchfem=usrent.srchmale=YES;
               if( useage ) {
                    prompt( SRCHAGE );
               }
               else {
                    usrent.agemax=99;
                    usrent.agemin=0;
                    mchusr->nxtrou();
               }
          }
          else {
               prompt( SRCHSEX );
          }
          break;
     case 'B':                     /* begin search                         */
          mchusr->nxtrou=catrou;
          mchusr->txtsrch=NO;
          bgnsrch();
          break;
     case '?':                     /* help                                 */
          eprompt( HLPEOG );
          break;
     default:
          eprompt( BADSEL );
     }
}                             /* end sentogo                               */

LOCAL void DEBUGEXP
ssrchsex(void)                /* search sex criteria     - input handler   */
{
     switch( cncchr() ) {
     case 'M':                     /* search for male only                 */
          usrent.srchmale=YES;
          usrent.srchfem=NO;
          break;
     case 'F':                     /* search for female only               */
          usrent.srchfem=YES;
          usrent.srchmale=NO;
          break;
     case 'B':                     /* search for both                      */
          usrent.srchmale=usrent.srchfem=YES;
     case '.':
          break;
     default:
          eprompt( BADSEL );
          return;
     }
     mchusr->entedited=YES;
     usrent.searched=YES;
     if( useage ) {
          prompt( SRCHAGE );
     }
     else {
          usrent.agemax=99;
          usrent.agemin=0;
          mchusr->nxtrou();
     }
}                             /* end ssrchsex                              */

LOCAL void DEBUGEXP
ssrchage()                    /* search age criteria     - input handler   */
{
     if( isdigit(morcnc()) ) {     /* age range                            */
          usrent.agemin=cncint();
          if( cncchr() == '-' ) {
               usrent.agemax=cncint();
          }
          else {
               usrent.agemax=99;
          }
          if( usrent.agemax < usrent.agemin ) {
               eprompt( INVAGER );
               return;
          }
          mchusr->entedited=YES;
          usrent.searched=YES;
          mchusr->nxtrou();
     }
     else if( cncchr() != '.' ) {  /* use current values?                  */
          eprompt( BADSEL );
     }
     else {
          mchusr->entedited=YES;
          usrent.searched=YES;
          mchusr->nxtrou();
     }
}                             /* end ssrchage                              */

LOCAL void DEBUGEXP
ssrchpct(void)                /* search pct criteria     - input handler   */
{
     if( isdigit(morcnc()) ) {     /* percent match                        */
          usrent.pctmin=cncint();
     }
     else if( cncchr() != '.' ) {
          eprompt( PCTHLP );
          return;
     }
     usrent.searched=YES;
     mchusr->entedited=YES;
     setbtv( qizbb );
     iniqsk( usrqsp, usrqiz.quizno, 0 );
     mchusr->srch=YES;
     while( qnxqst(usrqsp,usrqst.quizno) ) {
          gcrbtv( usrqsp, TYPKEY );
          if( !(txtresp() || usrqst.exclude) ) {
               mchusr->nxtrou=srchlist;
               prfmsg( PREFENT );
               nxtqstn();
               return;
          }
     }
     updusr();
     prfmsg( ENOQST );
     mchusr->txtsrch=NO;
     bgnsrch();
}                             /* end ssrchpct                              */

LOCAL void DEBUGEXP
ssrchlnxt()                   /* list matching quizes    - input handler   */
{
     switch( cncchr() ) {
     case 'V':                     /* view a users responses               */
          mchusr->nxtrou=srchlnxt;
          prompt( DETLWHO );
          break;
     case 'M':                     /* match mail                           */
          mchusr->nxtrou=srchlnxt;
          prompt( WRITWHO );
          break;
     case 'R':                     /* restart search                       */
          setbtv( entbb );
          if( qeqbtv(usrent.userid,UIDKEY) ) {
               gcrbtv( usrentp, UIDKEY );
          }
          mchusr->srched=YES;
          txtomch();
          break;
     case 'X':                     /* return to main menu                  */
          if( usrptr->substt == XORWRIT ) {
               cncall();
               prompt( SMENU );
          }
          else {
               eprompt( BADSEL );
          }
          break;
     case 'C':                     /* continue searching                   */
          if( usrptr->substt == SRCHLNXT ) {
               prompt( SRCHLST2 );
               break;
          }
     default:
          eprompt( SNXTHLP );
     }
}                             /* end ssrchlnxt                             */

LOCAL void DEBUGEXP
ssrchlist()                   /* list matching quizes    - status handler  */
{
     INT     pct;
     char    *cp;
     char    desc[58];
     DateKey dkey;

     setbtv( entbb );
     if( !mchusr->allusrs ) {
          dkey.crdate=0x7FFF;
          dkey.quizno=usrqiz.quizno;
     }
     else {
          gabbtv( NULL, mchusr->srchpos, DATEKEY );
     }
     if( mchusr->allusrs ? qprdat(usrqiz.quizno) : qlstdat(&dkey,usrqiz.quizno) ) {
          gcrbtv( NULL, DATEKEY );
          mchusr->srchpos=absbtv();
          mchusr->allusrs=YES;
          if( !bbentp->filled ) {
               return;
          }
          if( mchusr->browse ) {
               pct=1;
          }
          else {
               pct=mmk_match();
          }
          if( pct > 0 || (pct == 0 && (!mchusr->txtsrch || !mchusr->argv[0])) ) {
               mchusr->found=YES;
               if( usrqiz.brfqst > 0 ) {
                    strzcpy( desc, bbentp->rspspc+rspsiz(usrqiz.qsthi)+usrqiz.brftxt,
                         sizeof(desc)-(useage ? 4 : 0)-(usesex ? 4 : 0)-6 );
                    trm2( desc );
               }
               else {
                    *desc=0;
               }
               if( (cp=strchr(desc,'\r')) != NULL ) {
                    *cp=0;
               }
               prfmsg( BRFFMT2, bbentp->name );
               if( useage ) {
                    prf( " %2d ", bbentp->age );
               }
               if( usesex ) {
                    prf( " %c  ", bbentp->sex );
               }
               if( !mchusr->browse && (!mchusr->txtsrch || mchusr->argv[0]) ) {
                    prf( mchusr->txtsrch ? " %3d  " : "%3d%%  ", pct );
               }
               prf( "%s\n", desc );
               if( ++mchusr->ival >= 15 ) {
                    prompt( SRCHLNXT );
                    return;
               }
          }
     }
     else {
          mchusr->browse=NO;
          prfmsg( mchusr->found ? ENDENT : NOENTS );
          prompt( XORWRIT );
     }
}                             /* end ssrchlist                             */

LOCAL void DEBUGEXP
sdetlwho()                    /* detail on who           - input handler   */
{
     char tmpname[UIDSIZ];

     setbtv( entbb );
     strzcpy( tmpname, cncall(), UIDSIZ );
     strzcpy( bbekyp->name, tmpname, UIDSIZ );
     bbekyp->quizno=usrqiz.quizno;
     if( qryent(bbekyp,usrqiz.quizno,tmpname) ) {
          gcrbtv( usrentp, ENTKEY );
          if( usrent.filled ) {
               prompt( RSPLIST2 );
               return;
          }
     }
     prfmsg( NOENTRY, tmpname );
     eprompt( 0 );
}                             /* end sdetlwho                              */

LOCAL void DEBUGEXP
swritwho()                    /* write to whom           - input handler   */
{
     char tmpname[UIDSIZ];

     setbtv( entbb );
     strzcpy( tmpname, cncall(), UIDSIZ );
     trm2( tmpname );
     if( !tmpname[0] ) {
          reprompt( 0 );
          return;
     }
     strzcpy( bbekyp->name, tmpname, UIDSIZ );
     bbekyp->quizno=usrqiz.quizno;
     if( qgebtv(NULL,ENTKEY) && bbekyp->quizno == usrqiz.quizno
      && equstr2(tmpname,bbekyp->name) ) {
          if( strlen(bbekyp->name) == strlen(tmpname) || !qgtbtv(NULL,ENTKEY)
           || bbekyp->quizno != usrqiz.quizno
           || !equstr2(tmpname,bbekyp->name) ) {
               strzcpy( bbekyp->name, tmpname, UIDSIZ );
               bbekyp->quizno=usrqiz.quizno;
               ggebtv( NULL, NULL, ENTKEY );
               if( !usrqiz.quizno || bbentp->filled ) {
                    bgnmail( bbentp->userid, 0 );
                    return;
               }
          }
          else {
               prfmsg( NUNIQID, tmpname );
               eprompt( 0 );
               return;
          }
     }
     prfmsg( usrqiz.quizno ? NOTNQST : NOTMMUSR, tmpname );
     eprompt( 0 );
}                             /* end swritwho                              */

LOCAL void DEBUGEXP
smsglist()                    /* list mail               - status handler  */
{
     if( !useanon ) {
          prfmsg( NOMAILER );
          prompt( SMENU );
          return;
     }
     setbtv( mailbb );
     if( qgtbtv(mkyp,TOKEY) && equstr(bbmkyp->userid,mkey.userid) ) {
          gcrbtv( msgp, TOKEY );
          mkey.sequence=msg.sequence;
          mchmail->found=YES;
          shomsg( msgp, BMSGFMT2 );
          mchmail->msglist[mchmail->ival]=msg.sequence;
          if( ++mchmail->ival >= 15 ) {
               prompt( MSGLNXT );
               return;
          }
     }
     else if( !mchmail->ival ) {
          prfmsg( mchmail->found ? ENDMSGS : NOMAIL );
          prompt( SMENU );
     }
     else {
          prompt( WCHMSG );
     }
}                             /* end msglist                               */

LOCAL void DEBUGEXP
smsglnxt()                    /* what after msg list     - input handler   */
{
     long sequence;

     if( !useanon ) {
          prfmsg( NOMAILER );
          prompt( SMENU );
          return;
     }
     if( isdigit(morcnc()) ) {
          sequence=cnclon();
          if( sequence < 0 ) {
               eprompt( BADSEL );
          }
          else if( sequence && sequence <= 15 && mchmail->msglist[(INT)sequence-1] ) {
               setbtv( mailbb );
               mkey.sequence=mchmail->msglist[(INT)sequence-1];
               if( !qeqbtv(mkyp,TOKEY) ) {
                    rmvseq( mchmail->msglist, mkey.sequence, 15 );
                    prfmsg( MSGGONE );
                    relist();
               }
               else {
                    gcrbtv( msgp, TOKEY );
                    prf( mmkcls );
                    shomsg( msgp, TMSGFMT );
                    outprf( usrnum );
                    mmk_xmtmsg( msgp );
                    prompt( msg.replyto ? MSGREPLY : MSGREPL2 );
               }
          }
          else {
               if( sequence ) {
                    mkey.sequence=sequence-1;
               }
               else {
                    mkey.sequence=0;
               }
               prompt( MSGLIST );
          }
     }
     else {
          switch( cncchr() ) {
          case 'E':                /* erase message                       */
               prompt( ERASWCH );
               break;
          case 'X':                /* return to main menu                 */
               if( usrptr->substt == WCHMSG ) {
                    cncall();
                    prompt( SMENU );
               }
               else {
                    eprompt( BADSEL );
               }
               break;
          case 'C':                /* continue listing messages           */
               if( usrptr->substt == MSGLNXT ) {
                    strzcpy( mkey.userid, usaptr->userid, UIDSIZ );
                    if( mmk_lnl() ) {
                         mkey.sequence=mchmail->msglist[mchmail->ival-1];
                    }
                    prompt( MSGLIST );
                    break;
               }
          default:
               eprompt( MLNHLP );
          }
     }
}                             /* end smsglnxt                              */

LOCAL void DEBUGEXP
smsgreply()                   /* message read - now what - input handler   */
{
     if( !useanon ) {
          prfmsg( NOMAILER );
          prompt( SMENU );
          return;
     }
     switch( cncchr() ) {
     case 'R':                     /* reply to this message                */
          setbtv( entbb );
          strzcpy( bbukyp->userid, msg.from, UIDSIZ );
          bbukyp->quizno=0;
          if( qeqbtv(NULL,UIDKEY) ) {
               mchmail->nxtrou=msgreply;
               bgnmail( bbukyp->userid, msg.sequence );
          }
          else {
               prfmsg( WNOTUSR );
               prompt( usrptr->substt );
          }
          break;
     case 'A':                     /* re-read this message                 */
          prf( mmkcls );
          shomsg( msgp, TMSGFMT );
          outprf( usrnum );
          mmk_xmtmsg( msgp );
          prompt( msg.replyto ? MSGREPLY : MSGREPL2 );
          break;
     case 'E':                     /* erase this message                   */
          setbtv( mailbb );
          geqbtv( NULL, mkyp, TOKEY );
          delbtv();
          rmvseq( mchmail->msglist, mkey.sequence, 15 );
          mmk_lnl();
          relist();
          break;
     case 'C':                     /* continue listing messages            */
          relist();
          break;
     case 'V':                     /* read parent message                  */
          if( usrptr->substt == MSGREPLY ) {
               setbtv( mailbb );
               strzcpy( bbmkyp->userid, usaptr->userid, UIDSIZ );
               bbmkyp->sequence=msg.replyto;
               if( !bbmkyp->sequence ) {
                    eprompt( NOTREPLY );
               }
               else if( !qeqbtv(NULL,FRMKEY) ) {
                    eprompt( REPGONE );
               }
               else {
                    prf( mmkcls );
                    gcrbtv( NULL, FRMKEY );
                    shomsg( bbmsg, TMSGFMT );
                    outprf( usrnum );
                    mmk_xmtmsg( bbmsg );
                    prompt( bbmsg->replyto ? MSGREPLY : MSGREPL2 );
               }
               break;
          }
     default:
          eprompt( MREPHLP );
     }
}                             /* end smsgreply                             */

LOCAL void DEBUGEXP
srlstmsgs()                   /* relist mail             - status handler  */
{
     if( !useanon ) {
          prfmsg( NOMAILER );
          prompt( SMENU );
          return;
     }
     if( (mkey.sequence=mchmail->msglist[mchmail->ival]) != 0L ) {
          setbtv( mailbb );
          if( qeqbtv(mkyp,TOKEY) ) {
               gcrbtv( NULL, TOKEY );
               mchmail->found=YES;
               shomsg( bbmsg, BMSGFMT2 );
               if( ++mchmail->ival >= 15 ) {
                    mchmail->nxtrou();
                    return;
               }
          }
          else {
               rmvseq( mchmail->msglist, mkey.sequence, 15 );
          }
     }
     else {
          if( mchmail->ival < 15 ) {
               if( mchmail->ival ) {
                    mkey.sequence=mchmail->msglist[mchmail->ival-1];
               }
               else {
                    mkey.sequence=0;
               }
               usrptr->substt=MSGLIST;
               cycle();
          }
          else {
               mchmail->nxtrou();
          }
     }
}                             /* end rlstmsgs                              */

LOCAL void DEBUGEXP
sremwho()                     /* configure who           - input handler   */
{
     if( morcnc() == '.' ) {
          cncchr();
          mchusr->allusrs=YES;
          memset( ukyp, 0, sizeof(UserKey) );
          prompt( YESREM2 );
     }
     else {
          switch( hdluid(cncall()) ) {
          case UIDPMT:
               reprompt( 0 );
          case UIDCAL:
               return;
          case UIDFND:
               strzcpy( ukey.userid, uidxrf.userid, UIDSIZ );
          }
          mchusr->allusrs=NO;
          ukey.quizno=0;
          setbtv( entbb );
          if( qeqbtv(ukyp,UIDKEY) ) {
               prompt( YESREM2 );
          }
          else {
               prfmsg( NOTMMUSR, ukey.userid );
               eprompt( 0 );
          }
     }
}                             /* end sremwho                               */

LOCAL void DEBUGEXP
syesrem()                     /* remove user(s)?         - input handler   */
{
     switch( cncyesno() ) {
     case 'Y':
          prompt( REMUSRS2 );
          break;
     case 'N':
          prompt( REMWHO2 );
          break;
     default:
          eprompt( YORN );
     }
}                             /* end syesrem                               */

LOCAL void DEBUGEXP
sremusrs()                    /* delete user(s)          - status handler  */
{
     setbtv( entbb );
     if( qgebtv(ukyp,UIDKEY) && (mchusr->allusrs
      || equstri(ukyp->userid,bbukyp->userid)) ) {
          working( NO );
          gcrbtv( NULL, UIDKEY );
          delbtv();
     }
     else {
          working( YES );
          prompt( SMENU );
     }
}                             /* end sremusrs                              */

LOCAL void DEBUGEXP
seraswch()                    /* erase which message     - input handler   */
{
     INT num;

     if( !useanon ) {
          prfmsg( NOMAILER );
          prompt( SMENU );
          return;
     }
     if( isdigit(morcnc()) ) {
          num=cncint();
          if( num > 0 && num <= 15 && mchmail->msglist[num-1] ) {
               setbtv( mailbb );
               mkey.sequence=mchmail->msglist[num-1];
               if( qeqbtv(mkyp,TOKEY) ) {
                    gcrbtv( NULL, TOKEY );
                    delbtv();
                    rmvseq( mchmail->msglist, mkey.sequence, 15 );
                    relist();
                    return;
               }
          }
     }
     eprompt( BADSEL );
}                             /* end seraswch                              */

LOCAL void DEBUGEXP
skeywds()                     /* enter search words      - input handler   */
{
     strzcpy( mchusr->edtbuf, cncall(), EDTSIZ );
     if( equstr(mchusr->edtbuf,"?") ) {
          eprompt( HLPKWDS );
     }
     else {
          parse( mchusr->edtbuf, mchusr->argv, MAXKWD );
          mchusr->txtsrch=YES;
          bgnsrch();
     }
}                             /* end skeywds                               */

LOCAL void DEBUGEXP
smainlist()                   /* list main entry rsps    - status handler  */
{
     if( ++mchusr->ival <= usrqiz.qsthi ) {
          setbtv( qizbb );
          iniqsk( usrqsp, usrqiz.quizno, mchusr->ival );
          if( qeqbtv(usrqsp,TYPKEY) ) {
               gcrbtv( usrqsp, TYPKEY );
               prfmsg( LSTMQST, usrqsp->qrsspc );
               mchusr->rspp=rsppos();
               if( mchusr->rspp == rtrsh || !*mchusr->rspp ) {
                    prfmsg( NOTANSD );
               }
               else {
                    prfmsg( MLTXT1 );
                    mlprf( mchusr->rspp, rawmsg(MLIND) );
                    prfmsg( MLTXT2 );
               }
          }
     }
     else {
          mchusr->nxtrou();
     }
}                             /* end smainlist                             */

LOCAL void DEBUGEXP
srsplist()                    /* list user responses     - status handler  */
{
     INT     rspnno;
     boolean rspfnd;

     if( ++mchusr->ival <= usrqiz.qsthi ) {
          setbtv( qizbb );
          iniqsk( usrqsp, usrqiz.quizno, mchusr->ival );
          if( qeqbtv(usrqsp,TYPKEY) ) {
               gcrbtv( usrqsp, TYPKEY );
               shoqst( BQSTFMT, 0 );
               if( txtresp() ) {
                    mchusr->rspp=rsppos();
                    if( mchusr->rspp == rtrsh || !*mchusr->rspp ) {
                         prfmsg( NOTANSD );
                    }
                    else {
                         prfmsg( MLTXT1 );
                         mlprf( mchusr->rspp, rawmsg(MLIND) );
                         prfmsg( MLTXT2 );
                    }
               }
               else {
                    mchusr->sel=eselect();
                    mchusr->rspp=(usrqst.txtlen ? rsppos() : rtrsh );
                    for( rspnno=1, rspfnd=NO ; rspnno <= usrqst.rspcnt ; rspnno++ ) {
                         if( !(mchusr->sel&((long)1<<(rspnno-1))) ) {
                              continue;
                         }
                         rspfnd=YES;
                         prfmsg( ALTTXT1, fndzstr(rspnno,usrqst.qrsspc) );
                         if( mchusr->rspp != rtrsh && rspnno == usrqst.rspcnt
                          && *mchusr->rspp ) {
                              prfmsg( ALTTXT2, mchusr->rspp );
                         }
                    }
                    if( rspfnd ) {
                         prf( "\n" );
                    }
                    else {
                         prfmsg( NOTANSD );
                    }
               }
               prf( "\n" );
          }
     }
     else {
          prfmsg( ENDQST );
          mchusr->nxtrou();
     }
}                             /* end srsplist                              */

LOCAL void DEBUGEXP
ssrchmst()                    /* enter search words      - input handler   */
{
     updusr();
     strzcpy( mchusr->edtbuf, cncall(), EDTSIZ );
     mchusr->edtbuf[EDTSIZ-1]=0;
     if( equstr(mchusr->edtbuf,"?") ) {
          eprompt( HLPKWDS );
          return;
     }
     parse( mchusr->edtbuf, mchusr->argv, MAXKWD );
     memset( ekyp, 0, sizeof(Namekey) );
     mchusr->found=NO;
     setbtv( entbb );
     if( qnxent(ekyp,0) ) {
          prompt( BROWSING );
     }
     else {
          prfmsg( NOENTS );
          prompt( SMENU );
     }
}                             /* end ssrchmst                              */

LOCAL void DEBUGEXP
suserlist()                   /* list MM users           - status handler  */
{
     setbtv( entbb );
     if( qnxent(ekyp,ekey.quizno) ) {
          memcpy( ekyp, bbekyp, sizeof(Namekey) );
          gcrbtv( NULL, ENTKEY );
          if( mchusr->allusrs || !bbentp->notnew ) {
               if( useanon ) {
                    prfmsg( USRLSTA, bbentp->userid, bbentp->name );
               }
               else {
                    prfmsg( USRLST, bbentp->userid );
               }
          }
          if( !bbentp->notnew ) {
               bbentp->notnew=YES;
               upvbtv( NULL, bbentp->entsiz );
          }
     }
     else {
          prfmsg( ENDUSRS );
          prompt( SMENU );
     }
}                             /* end suserlist                             */

LOCAL void DEBUGEXP
snewonly()                    /* list new users only?    - input handler   */
{
     switch( cncyesno() ) {
     case 'Y':
          mchusr->allusrs=NO;
          break;
     case 'N':
          mchusr->allusrs=YES;
          break;
     default:
          eprompt( YORN );
          return;
     }
     prf( mmkcls );
     bgnlist();
}                             /* end snewonly                              */

LOCAL void DEBUGEXP
sbrftxtn()                    /* brief description #     - input handler   */
{
     INT i;

     if( isdigit(morcnc()) ) {
          if( (i=cncint()) > 0 ) {
               iniqsk( bbkyp, usrqiz.quizno, i );
               if( qeqbtv(NULL,TYPKEY) ) {
                    geqbtv( NULL, NULL, TYPKEY );
                    if( bbqsp->txtlen ) {
                         usrqiz.brfqst=i;
                         usrqiz.brftxt=bbqsp->rspoffs;
                         mchusr->qizedited=YES;
                         updqiz();
                         shoqiz( FULLQFM2 );
                         prompt( MODWHT );
                         return;
                    }
               }
          }
          else if( i == 0 ) {
               usrqiz.brfqst=usrqiz.brftxt=0;
               mchusr->qizedited=YES;
               updqiz();
               shoqiz( FULLQFM2 );
               prompt( MODWHT );
               return;
          }
     }
     eprompt( BRTXTHLP );
}                             /* end sbrftxtn                              */

LOCAL void DEBUGEXP
sviewwho()                    /* view who's responses    - input handler   */
{
     char tmpname[UIDSIZ];

     setbtv( entbb );
     strzcpy( tmpname, cncall(), UIDSIZ );
     trm2( tmpname );
     if( !tmpname[0] ) {
          reprompt( 0 );
          return;
     }
     strzcpy( bbekyp->name, tmpname, UIDSIZ );
     bbekyp->quizno=0;
     if( qryent(bbekyp,0,tmpname) ) {
          gcrbtv( usrentp, ENTKEY );
          strzcpy( ukey.userid, usrent.userid, UIDSIZ );
          ukey.quizno=0;
          if( qgtbtv(ukyp,UIDKEY) && equstri(bbukyp->userid,usrent.userid) ) {
               mchusr->ival=0;
               prompt( ENTLIST2 );
          }
          else {
               prfmsg( NOENTRY2, tmpname );
               eprompt( 0 );
          }
     }
     else {
          prfmsg( NOTMMUSR, tmpname );
          eprompt( 0 );
     }
}                             /* end sviewwho                              */

LOCAL void DEBUGEXP
sentlist()                    /* list user's entries     - status handler  */
{
     setbtv( entbb );
     if( qgtbtv(ukyp,UIDKEY) && equstri(bbukyp->userid,usrent.userid) ) {
          ukey.quizno=bbukyp->quizno;
          acqbtv( NULL, NULL, UIDKEY );
          if( bbentp->filled ) {
               mchusr->ival=1;
               setbtv( qizbb );
               iniqzk( bbkyp, ukey.quizno );
               if( acqbtv(usrqzp,NULL,TYPKEY) ) {
                    shoqiz( BRFQFMT2 );
               }
          }
     }
     else if( !mchusr->ival ) {
          prfmsg( NOENTRY2, usrent.name );
          prompt( VIEWWHO );
     }
     else {
          prompt( WCHQIZ );
     }
}                             /* end sentlist                              */

LOCAL void DEBUGEXP
swchqiz()                     /* which questionnaire     - input handler   */
{
     int quizno;

     if( isdigit(morcnc()) && (quizno=cncint()) > 0 ) {
          ukey.quizno=quizno;
          setbtv( entbb );
          if( acqbtv(usrentp,ukyp,UIDKEY) && usrent.filled ) {
               setbtv( qizbb );
               iniqzk( bbkyp, ukey.quizno );
               if( acqbtv(usrqzp,NULL,TYPKEY) && mmk_qizacc(YES) ) {
                    if( !mchusr->syspr && !indsrch && mmk_qizacc(NO) ) {
                         setbtv( entbb );
                         strzcpy( bbukyp->userid, usaptr->userid, UIDSIZ );
                         bbukyp->quizno=usrqiz.quizno;
                         if( !acqbtv(NULL,NULL,UIDKEY) || !bbentp->filled ) {
                              eprompt( FILL1ST );
                              return;
                         }
                    }
                    mchusr->nxtrou=entlist;
                    prompt( RSPLIST2 );
               }
               else {
                    eprompt( ENOACC );
               }
          }
          else {
               prfmsg( ENOTFND, usrent.name, quizno );
               eprompt( 0 );
          }
     }
     else if( morcnc() == '.' ) {
          cncall();
          ukey.quizno=0;
          mchusr->ival=0;
          prompt( ENTLIST2 );
     }
     else {
          eprompt( BADSEL );
     }
}                             /* end swchqiz                               */

/*-------------------------------------------------------------------------*
 * state linking functions
 *-------------------------------------------------------------------------*/
void
x2modwch()                    /* exiting to smodwch      - state linker    */
{
     mchusr->prvrou=NULL;
     if( usrptr->substt == MODWCH2 ) {
          prompt( SMENU );
     }
     else {
          prompt( MODWCH2 );
     }
}                             /* end x2modwch                              */

void
x2modwht()                    /* exiting to smodwht      - state linker    */
{
     mchusr->prvrou=NULL;
     if( usrptr->substt == MODWHT ) {
          iniqzk( usrqzp, 0 );
          if( qnxqiz(usrqzp) ) {
               gcrbtv( usrqzp, TYPKEY );
               mchusr->nxtrou=modwch;
               prompt( QUIZLIST );
               shoqiz( BRFQFMT2 );
          }
          else {
               prfmsg( NOQIZ );
               prompt( MODWCH2 );
          }
     }
     else {
          prompt( MODWHT );
     }
}                             /* end x2modwht                              */

void
x2modqst()                    /* exiting to smodqst      - state linker    */
{
     mchusr->prvrou=NULL;
     if( usrptr->substt == MODQST ) {
          shoqiz( FULLQFM2 );
          prompt( MODWHT );
     }
     else {
          prompt( MODQST );
     }
}                             /* end x2modqst                              */

LOCAL void DEBUGEXP
smenu()                       /* return to main menu     - state linker    */
{
     mchusr->nxtrou=catrou;
     cncall();
     prompt( SMENU );
}                             /* end smenu                                 */

LOCAL void DEBUGEXP
qiztyp()                      /* quiz type/add 1st qstn  - state linker    */
{
     mchusr->nxtrou=addnqst;
     prompt( QIZTYP );
}                             /* end qiztyp                                */

LOCAL void DEBUGEXP
numrsp()                      /* number of responses     - state linker    */
{
     switch( usrqiz.qiztyp ) {
     case TEXTQ:
          usrqst.maxrsp=TXTRESP;
          usrqst.rspoffs=usrqiz.txtoffs;
          prompt( TRSPLEN2 );
          break;
     case MULTC:
          prompt( NUMRSPMC );
          break;
     case 0:
          usrqiz.qiztyp=MIXED;
          mchusr->qizedited=YES;
          updqiz();
     case MIXED:
          prompt( NUMRSPS );
     }
}                             /* end numrsp                                */

LOCAL void DEBUGEXP
newnrsp()                     /* new number of responses - state linker    */
{
     mchusr->nxtrou=catrou;
     switch( usrqiz.qiztyp ) {
     case TEXTQ:
          usrqst.maxrsp=TXTRESP;
          prompt( NEWRSPL );
          break;
     case MULTC:
          prompt( NEWNRSPM );
          break;
     case 0:
          usrqiz.qiztyp=MIXED;
          mchusr->qizedited=YES;
          updqiz();
     case MIXED:
          prompt( NEWNRSPS );
     }
}                             /* end newnrsp                               */

LOCAL void DEBUGEXP
addnqst()                     /* add next question                         */
{
     INT qstnno;

     if( ++usrqst.qstnno <= MAXQST && !qeqbtv(usrqsp,TYPKEY) &&
        spcavl() > 0 ) {
          qstnno=usrqst.qstnno;
          memset( usrqsp, 0, sizeof(Question) );
          iniqsk( usrqsp, usrqiz.quizno, qstnno );
          numrsp();
     }
     else {
          usrqst.qstnno--;
          mchusr->nxtrou=catrou;
          modwht();
     }
}                             /* end addqst                                */

LOCAL void DEBUGEXP
modwch()                      /* modify which quiz?      - state linker    */
{
     mchusr->nxtrou=catrou;
     prompt( MODWCH2 );
}                             /* end modwch                                */

LOCAL void DEBUGEXP
qdelwch()                     /* delete which quiz?      - state linker    */
{
     mchusr->nxtrou=catrou;
     prompt( QDELWCH );
}                             /* end qdelwch                               */

LOCAL void DEBUGEXP
qdelren()                     /* renumber after delete   - state linker    */
{
     ininmk( nkyp, usrqiz.quizno, 0 );
     if( qnxqzn(nkyp,0xFFFF) ) {
          mchusr->nxtrou=modwch;
          prompt( RENQIZD );
     }
     else {
          mchusr->nxtrou=catrou;
          prompt( MODWCH2 );
     }
}                             /* end qdelren                               */

LOCAL void DEBUGEXP
qinsbfr()                     /* insert quiz before      - state linker    */
{
     mchusr->nxtrou=catrou;
     prompt( QINSBFR );
}                             /* end qinsbfr                               */

LOCAL void DEBUGEXP
insqiz()                      /* insert questionnaire    - state linker    */
{
     mchusr->nxtrou=catrou;
     if( qeqbtv(usrqzp,TYPKEY) ) {
          prompt( MODWCH2 );
     }
     else {
          prompt( ADDQIZ );
     }
}                             /* end insqiz                                */

LOCAL void DEBUGEXP
modwht()                      /* modify quiz             - state linker    */
{
     mchusr->nxtrou=catrou;
     shoqiz( FULLQFM2 );
     prompt( MODWHT );
}                             /* end modwht                                */

LOCAL void DEBUGEXP
delwch()                      /* delete which question?  - state linker    */
{
     mchusr->nxtrou=catrou;
     prompt( DELWCH );
}                             /* end delwch                                */

LOCAL void DEBUGEXP
delren()                      /* renumber after delete   - state linker    */
{
     ininmk( nkyp, usrqst.quizno, usrqst.qstnno );
     if( qnxqzn(nkyp,usrqst.quizno) ) {
          mchusr->nxtrou=modwht;
          prompt( RENQSTD );
     }
     else {
          mchusr->nxtrou=catrou;
          prompt( MODWHT );
     }
}                             /* end delren                                */

LOCAL void DEBUGEXP
delrfmt()                     /* reformat text after del - state linker    */
{
     iniqsk( qkyp, usrqst.quizno, 0 );
     if( qnxqst(qkyp,usrqst.quizno) ) {
          mchusr->nxtrou=delren;
          reformat();
     }
     else {
          mchusr->nxtrou=catrou;
          delren();
     }
}                             /* end delrfmt                               */

LOCAL void DEBUGEXP
insbfr()                      /* insert question before  - state linker    */
{
     mchusr->nxtrou=catrou;
     prompt( INSBFR );
}                             /* end insbfr                                */

LOCAL void DEBUGEXP
insqst()                      /* insert question         - state linker    */
{
     INT qstnno;

     if( qeqbtv(usrqsp,TYPKEY) ) {
          gcrbtv( usrqsp, TYPKEY );
          mchusr->nxtrou=catrou;
          prompt( MODWHT );
     }
     else {
          qstnno=usrqst.qstnno;
          memset( usrqsp, 0, sizeof(Question) );
          iniqsk( usrqsp, usrqiz.quizno, qstnno );
          mchusr->nxtrou=modwht;
          numrsp();
     }
}                             /* end insqst                                */

LOCAL void DEBUGEXP
modqst()                      /* modify question         - state linker    */
{
     mchusr->nxtrou=catrou;
     shoqst( EQSTFMT2, 0 );
     prompt( MODQST );
}                             /* end modqst                                */

LOCAL void DEBUGEXP
reformat()                    /* start reformatting text - state linker    */
{
     iniqsk( qkyp, usrqst.quizno, 0 );
     usrqiz.txtoffs=0;
     prompt( RFMTTXT );
}                             /* end reformat                              */

LOCAL void DEBUGEXP
fillwch()                     /* fill out which quiz?    - state linker    */
{
     mchusr->nxtrou=catrou;
     usrptr->substt=FILLWCH;
     reprompt( 0 );
}                             /* end fillwch                               */

void DEBUGEXP
srchwch()                     /* search which quiz?      - state linker    */
{
     mchusr->nxtrou=catrou;
     usrptr->substt=SRCHWCH;
     reprompt( 0 );
}                             /* end srchwch                               */

LOCAL void DEBUGEXP
srchlist()                    /* begin quiz search       - state linker    */
{
     mchusr->nxtrou=catrou;
     bgnsrch();
}                             /* end srchlist                              */

LOCAL void DEBUGEXP
srchlnxt()                    /* search again after mail - state linker    */
{
     mchusr->nxtrou=catrou;
     setbtv( qizbb );
     iniqzk( usrqzp, ekey.quizno );
     geqbtv( usrqzp, usrqzp, TYPKEY );
     mchusr->alwpfn=usrqiz.alwpfn;
     setbtv( entbb );
     strzcpy( bbukyp->userid, usaptr->userid, UIDSIZ );
     bbukyp->quizno=usrqiz.quizno;
     if( acqbtv(usrentp,NULL,UIDKEY) ) {
          gabbtv( NULL, mchusr->srchpos, DATEKEY );
          if( qprdat(usrqiz.quizno) ) {
               prompt( SRCHLST2 );
               return;
          }
     }
     else {
          catastro( "SRCHLNXT: Questionnaire entry missing!" );
     }
     prompt( XORWRIT );
}                             /* end srchlnxt                              */

LOCAL void DEBUGEXP
editnext()                    /* after updating entries  - state linker    */
{
     boolean hasmst;

     mchusr->nxtrou=catrou;
     if( mchusr->hasmst ) {
          usrptr->substt=EDITFLD;
          reprompt( 0 );
     }
     else {
          rstrwid();
          if( useage ) {
               prompt( EDITAGE );
          }
          else {
               usrent.age=usaptr->age;
               hasmst=mchusr->hasmst;
               updusr();
               mchusr->hasmst=hasmst;
               if( !usesex ) {
                    usrent.sex=usaptr->sex;
                    mchusr->entedited=YES;
                    hasmst=mchusr->hasmst;
                    updusr();
                    mchusr->hasmst=hasmst;
                    mchusr->nxtrou=editfld;
                    mainqstns();
               }
               else {
                    prompt( EDITSEX );
               }
          }
     }
}                             /* end editnext                              */

LOCAL void DEBUGEXP
editfld()                     /* after updating entries  - state linker    */
{
     mchusr->nxtrou=catrou;
     if( !mchusr->hasmst ) {
          mchusr->entedited=YES;
          updusr();
          prfmsg( QIZNOW2 );
          prompt( SMENU );
     }
     else {
          usrptr->substt=EDITFLD;
          reprompt( 0 );
     }
}                             /* end editfld                               */

LOCAL void DEBUGEXP
relist()                     /* relist current messages  - state linker    */
{
     if( !mchmail->msglist[0] ) {
          mchmail->nxtrou=catrou;
          prompt( MSGLIST );
     }
     else {
          mchmail->nxtrou=msglnxt;
          prompt( RLSTMSGS );
     }
}                             /* end relist                                */

LOCAL void DEBUGEXP
msglnxt()                     /* after relisting,        - state linker    */
{
     mchmail->nxtrou=catrou;
     if( !mchmail->msglist[0] ) {
          cncall();
          prfmsg( ENDMSGS );
          prompt( SMENU );
     }
     else {
          prompt( MSGLNXT );
     }
}                             /* end msglnxt                               */

LOCAL void DEBUGEXP
msgreply()                    /* after replying          - state linker    */
{
     if( !useanon ) {
          prfmsg( NOMAILER );
          prompt( SMENU );
          return;
     }
     setbtv( mailbb );
     strzcpy( bbmkyp->userid, usaptr->userid, UIDSIZ );
     bbmkyp->sequence=msg.replyto;
     if( qeqbtv(NULL,TOKEY) ) {
          mchusr->nxtrou=catrou;
          gcrbtv( msgp, TOKEY );
          prompt( MSGREPLY );
     }
     else {
          strzcpy( mkey.userid, usaptr->userid, UIDSIZ );
          mkey.sequence=mmk_lnl();
          relist();
     }
}                             /* end msgreply                              */

LOCAL void DEBUGEXP
qnowdel()                     /* now delete quiz         - state linker    */
{
     mchusr->nxtrou=catrou;
     if( qizrsps(usrqiz.quizno) ) {
          prompt( MODWCH2 );
          return;
     }
     setbtv( qizbb );
     if( qeqbtv(usrqzp,TYPKEY) ) {
          gcrbtv( usrqzp, TYPKEY );
          shoqiz( FULLQFM2 );
          prompt( QYESDEL );
     }
     else if( qnxqiz(usrqzp) ) {
          qdelren();
     }
     else {
          prfmsg( QNOHERE );
          prompt( MODWCH2 );
     }
}                             /* end qnowdel                               */

LOCAL void DEBUGEXP
srchtxt()                     /* text search             - state linker    */
{
     mchusr->nxtrou=catrou;
     prompt( KEYWDS );
}                             /* end srchtxt                               */

LOCAL void DEBUGEXP
srchpct()                     /* match search            - state linker    */
{
     mchusr->nxtrou=catrou;
     prompt( SRCHPCT );
}                             /* end srchpct                               */

LOCAL void DEBUGEXP
srchmst()                     /* search main entries     - state linker    */
{
     mchusr->nxtrou=catrou;
     prompt( SRCHMST );
}                             /* end srchtxt                               */

LOCAL void DEBUGEXP
brwsnxt()                     /* search again after mail - state linker    */
{
     mchusr->nxtrou=catrou;
     getmst();
     prompt( BRWSNXT );
}                             /* end brwsnxt                              */

LOCAL void DEBUGEXP
srchmain()                    /* search main entries     - state linker    */
{
     getmst();
     if( !usrent.searched ) {
          newsrch();
     }
     usrent.searched=YES;
     rstrwid();
     mchusr->nxtrou=srchmst;
     if( !usesex ) {                            /* only one sex can fill ou*/
          usrent.srchfem=usrent.srchmale=YES;
          if( useage ) {
               prompt( SRCHAGE );
          }
          else {
               usrent.agemax=99;
               usrent.agemin=0;
               mchusr->nxtrou();
          }
     }
     else {
          prompt( SRCHSEX );
     }
}                             /* end srchmain                              */

LOCAL void DEBUGEXP
catrou()                      /* call catastro           - state linker    */
{
     catastro( "Invalid call to nxtrou()" );
}                             /* end catrou                                */

LOCAL void DEBUGEXP
entlist()                     /* relist user entries     - state linker    */
{
     mchusr->nxtrou=catrou;
     strzcpy( ukey.userid, usrent.userid, UIDSIZ );
     ukey.quizno=0;
     mchusr->ival=0;
     prompt( ENTLIST2 );
}                             /* end entlist                               */

/*-------------------------------------------------------------------------*
 * dunedt routines
 *-------------------------------------------------------------------------*/
INT
endaddq(                      /* add new question        - dunedt routine  */
     INT rflags )                  /* flags returned                       */
{
     INT l;

     setmbk( mmkmb );
     setbtv( qizbb );
     usrptr->state=mmkmod;
     if( !(rflags&ED_QUITEX) ) {
          mchusr->edtbuf[QSTSIZ-1]=0;
          trm2( mchusr->edtbuf );
          xltctls( mchusr->edtbuf );
          l=strlen( mchusr->edtbuf );
          if( l > 1 || usrqst.qstnno <= usrqiz.qsthi ) {
               usrqst.rspcnt=0;
               if( usrqst.rspcnt == 0 ) {
                    usrqst.qrssiz=inszstr( 0, 0, mchusr->edtbuf,
                         usrqst.qrsspc );
               }
               else {
                    usrqst.qrssiz=repzstr( 0, usrqst.rspcnt+1, mchusr->edtbuf,
                         usrqst.qrsspc );
               }
               mchusr->qstedited=YES;
               updqiz();
               rstrwid();
               if( !txtresp() ) {
                    if( l > 0 && usrqst.rspcnt == 0 ) {
                         shoqst( FQSTFMT, -1 );
                         memset( usrqst.qrsspc+l, 0, QRSSIZ-l );
                         mchusr->rspno=1;
                         prompt( ADDRSP );
                         outprf( usrnum );
                         return( NOTDONE );
                    }
               }
               else {
                    mchusr->nxtrou();
                    outprf( usrnum );
                    return( NOTDONE );
               }
          }
     }
     usrqst.qstnno=99;
     mchusr->nxtrou();
     outprf( usrnum );
     return( NOTDONE );
}                             /* end endaddq                               */

INT
endedtq(                      /* end of edit question    - dunedt routine  */
     INT rflags )                  /* flags returned                       */
{
     setmbk( mmkmb );
     setbtv( qizbb );
     usrptr->state=mmkmod;
     if( !(rflags&ED_QUITEX) ) {
          mchusr->edtbuf[QSTSIZ-1]=0;
          trm2( mchusr->edtbuf );
          xltctls( mchusr->edtbuf );
          usrqst.qrssiz=repzstr( 0, usrqst.rspcnt+1, mchusr->edtbuf,
               usrqst.qrsspc );
          mchusr->qstedited=YES;
          updqiz();
     }
     shoqst( EQSTFMT2, 0 );
     prompt( MODQST );
     outprf( usrnum );
     return( NOTDONE );
}                             /* end endedtq                               */

INT
endedtr(                     /* end of edit response     - dunedt routine  */
     INT rflags )                  /* flags returned                       */
{
     setmbk( mmkmb );
     setbtv( qizbb );
     usrptr->state=mmkmod;
     mchusr->entedited=YES;
     rstrwid();
     if( mchusr->rspp != rtrsh ) {
          if( rflags&ED_QUITEX ) {
               mchusr->rspp[0]=0;
          }
          if( usrqst.txtlen <= MAXNED && usrqst.txtlen > 0 ) {
               strzcpy( mchusr->rspp, cncall(), usrqst.txtlen+1 );
          }
          trm2( mchusr->rspp );
          if( usrqst.txtlen && !mchusr->rspp[0] ) {
               mchusr->rspp[0]=' ';
               mchusr->rspp[1]=0;
          }
          mchusr->rspp[usrqst.txtlen]=0;
     }
     while( qnxqst(usrqsp,usrqst.quizno) ) {
          gcrbtv( usrqsp, TYPKEY );
          if( !mchusr->srch || !(txtresp() || usrqst.exclude) ) {
               nxtqstn();
               outprf( usrnum );
               return( NOTDONE );
          }
     }
     prompt( SAVNXIT );
     outprf( usrnum );
     return( NOTDONE );
}                             /* end endedtr                               */

INT
endwrit(                      /* end of message edit     - dunedt routine  */
     INT rflags )                  /* flags returned                       */
{
     char *cp;

     setmbk( mmkmb );
     setbtv( qizbb );
     usrptr->state=mmkmod;
     if( !(rflags&ED_QUITEX) ) {
          if( mailchg && !dedcrd(mailchg,0) ) {
               setmbk( mmkmb );
               prfmsg( EMLCREDS );
          }
          else {
               setmbk( mmkmb );
               for( cp=msg.text ; isspace(*cp) ; cp++ );
               if( *cp ) {
                    if( useanon ) {
                         msg.credat=today();
                         msg.cretim=now();
                         setbtv( mailbb );
                         if( qhibtv(SEQKEY) ) {
                              msg.sequence=bbseq+1;
                         }
                         else {
                              msg.sequence=1;
                         }
                         invbtv( msgp, NOVMSZ+strlen(msg.text) );
                    }
                    else {
                         memset( mesg, 0, NVMSIZ );
                         mesg->msgno=++sv.msgtot;
                         strcpy( mesg->to, msg.to );
                         strcpy( mesg->userto, msg.to );
                         strcpy( mesg->from, usaptr->userid );
                         strzcpy( mesg->topic, msg.subject, TPCSIZ-1 );
                         mesg->crdate=today();
                         mesg->crtime=now();
                         clrprf();
                         strzcpy( mesg->text, msg.text, msgsize );
                         sendmsg( mesg, NULL );
                         setmbk( mmkmb );
                         setbtv( qizbb );
                    }
               }
          }
     }
     mchmail->nxtrou();
     outprf( usrnum );
     return( NOTDONE );
}                             /* end endwrit                               */



/*-------------------------------------------------------------------------*
 * Utility functions functions
 *-------------------------------------------------------------------------*/
LOCAL boolean DEBUGEXP
inmmk(                        /* check "uid" to see if in Match Maker      */
     char *uid )                   /* userid, or NULL for anyone           */
{
     if( uid ) {
          if( onsysn(uid,1) && (othusp->state == mmkmod
           || inedit(othusn,endaddq)
           || inedit(othusn,endedtq)
           || inedit(othusn,endedtr)
           || inedit(othusn,endwrit)) ) {
               othmch=(MatchUser*)vdaoff( othusn );
               return( YES );
          }
     }
     else {
          for( othusn=0, othusp=user ; othusn < nterms ; othusn++, othusp++ ) {
               if( othusn != usrnum && (othusp->state == mmkmod
                || inedit(othusn,endaddq)
                || inedit(othusn,endedtq)
                || inedit(othusn,endedtr)
                || inedit(othusn,endwrit)) ) {
                    othmch=(MatchUser*)vdaoff( othusn );
                    return( YES );
               }
          }
     }
     return( NO );
}

void
xitmmk()                      /* exiting match maker - cleanup             */
{
     usrptr->crdrat=mmucrr;
     if( usrnum == lockout ) {
          if( inmmk(NULL) && othmch->syspr ) {
               lockout=othusn;
          }
          else {
               lockout=-1;
          }
     }
}                             /* end xitmmk                                */

LOCAL boolean DEBUGEXP
hasmail(                      /* see if a user has mail                    */
     char *userid )                /* userid to check                      */
{
     if( !useanon ) {
          return( NO );
     }
     setbtv( mailbb );
     setuid( bbmkyp->userid, userid );
     bbmkyp->sequence=-1;
     if( qltbtv(NULL,TOKEY) && equstri(bbmkyp->userid,userid) ) {
          gcrbtv( NULL, TOKEY );
          if( !bbmsg->read ) {
               return( YES );
          }
     }
     rstbtv();
     return( NO );
}                             /* end hasmail                               */

LOCAL void DEBUGEXP
txtomch()                     /* determine types of searches allowed       */
{
     if( (usrqiz.txtoffs && txtsch) || usebrws ) {
          prompt( TXTOMCH );
     }
     else {
          if( usrqiz.type&MULTC ) {
               mchusr->nxtrou=srchpct;
               if( mchusr->srched ) {
                    prompt( ENTOGO );
                    return;
               }
          }
          else {
               usrent.srchmale=usrent.srchfem=YES;
               usrent.agemax=99;
               usrent.agemin=0;
               usrent.pctmin=0;
               if( textquiz() ) {
                    mchusr->argv[0]=NULL;
                    mchusr->txtsrch=YES;
               }
               else {
                    mchusr->txtsrch=NO;
               }
               bgnsrch();
               return;
          }
          if( !usesex || usrqiz.fsexrst ) {      /* only one sex can fill out */
               usrent.srchfem=usrent.srchmale=YES;
               if( useage ) {
                    prompt( SRCHAGE );
               }
               else {
                    usrent.agemax=99;
                    usrent.agemin=0;
                    mchusr->nxtrou();
               }
          }
          else {
               prompt( SRCHSEX );
          }
     }
}                             /* end txtomch                               */

LOCAL char* DEBUGEXP
mmkdesc()                     /* return match maker description            */
{
     return( mmk_module.descrp );
}                             /* end mmkdesc                               */

/*)}*/
