/*{(************************************************************************
 *
 *   RJSDEF.H
 *
 *   Standard definitions and macros for Sirius code.
 *
 * Copyright (c) 1992, by Ronald J. Struempf, Sirius Software Development
 ***************************************************************************/

#ifndef __RJSDEF_H
#define __RJSDEF_H

#include "..\src\gcomm.h"
#include "..\src\majorbbs.h"


/*-------------------------------------------------------------------------*
 * Debugging defines
 *-------------------------------------------------------------------------*/
#define LOCAL     static     /* helps with debug, and clarifies notation  */
#undef DEBUGEXP
#define DEBUGEXP //  EXPORT

#ifndef INT
#define INT int
#endif

typedef short            boolean;
typedef signed char      schar;
typedef unsigned char    byte;
typedef unsigned short   word;
typedef unsigned long    dword;


/*-------------------------------------------------------------------------*
 * Bit field definitions and macros
 *-------------------------------------------------------------------------*/
typedef
byte           bit_t;         /* type used for bit fields                  */

#define NBITS       (sizeof(bit_t)*8) /* number of bits per element        */
#define BITSIZ(n)   ((word)(((word)(n)+NBITS-1)/NBITS))

void      setbit(             /* set a bit                                 */
               bit_t a[],          /* bit array                            */
               word  bn ),         /* bit number to set                    */
          clrbit(             /* clear a bit                               */
               bit_t a[],          /* bit array                            */
               word  bn );         /* bit number to clear                  */

boolean   tstbit(             /* check value of a bit                      */
               bit_t a[],          /* bit array                            */
               word  bn );         /* bit number to test                   */

#define   ba_offs(bn)         ((word)((word)(bn)/NBITS))
#define   ba_value(bn)        ((bit_t)1<<(NBITS-1-((word)(bn)%NBITS)))

#define   setbit(a,n)         (a[ba_offs(n)]|=ba_value(n))
#define   clrbit(a,n)         (a[ba_offs(n)]&=~ba_value(n))
#define   tstbit(a,n)         ((a[ba_offs(n)]&ba_value(n)) ? YES : NO)



#define beep()      prf("")


/*-------------------------------------------------------------------------*
 * General definitions and macros
 *-------------------------------------------------------------------------*/
#undef  DONE
#define DONE        0          /* function complete                         */
#define NOTDONE     1          /* function not complete                     */

#undef  TRUE
#define TRUE        1         /* to clarify Boolean variables              */
#undef  FALSE
#define FALSE       0

#undef  YES
#define YES         1
#undef  NO
#define NO          0

#undef  ON
#define ON          1
#undef  OFF
#define OFF         0

#undef  OK
#define OK          0         /* to clarify return values                  */

#undef  FAIL
#define FAIL        (-1)      /* function failed                           */

#define Sunday      0    /* day of week values for global dayofweek        */
#define Monday      1
#define Tuesday     2
#define Wednesday   3
#define Thursday    4
#define Friday      5
#define Saturday    6

#define dddow(d)       ((cofdat(d)+2)%7)     /* dos date to day of week    */
#define weekend(dow)   (dow == SATURDAY || dow == SUNDAY)
#define dos2sec(t)     (dthour(t)*3600L+dtmin(t)*60L+dtsec(t))
#define dos2min(t)     (dthour(t)*60+dtmin(t))
#define min2dos(m)     (dttime(m/60,m%60,0))

#define byteswap(n)    ((word)(((n&0xFF)<<8)+((n>>8)&0xFF)))

#define equstr(s1,s2)         (strcmp(s1,s2) == 0)
#define equstri(s1,s2)        (stricmp(s1,s2) == 0)
#define equstrn(s1,s2,n)      (strncmp(s1,s2,n) == 0)
#define equstr2(s1,s2)        (sameto(s1,s2))
/*
#define equstr2(s1,s2)        (strnicmp(s1,s2,strlen(s1)) == 0)
#define equstrni(s1,s2,n)     (strnicmp(s1,s2,n) == 0)
*/
#define concex()              ((usrptr->flags&CONCEX) ? YES : NO)
#define injoip()              ((usrptr->flags&INJOIP) ? YES : NO)
#define aboip()               ((usrptr->flags&ABOIP) ? YES : NO)
#define nonhdw()              ((usrptr->flags&NOHDWE) ? YES : NO)
#define serial()              ((usrptr->flags&ISRIAL) ? YES : NO)
#undef  sysop()
#define sysop()               (((usrptr->flags&MASTER) || (usaptr->flags&HASMST)) ? YES : NO)
#define othsys()              (((othusp->flags&MASTER) || (othuap->flags&HASMST)) ? YES : NO)
#define yesno(f)              ((f) ? 'Y' : 'N')
#define ifansi(i1,i2)         ((usaptr->ansifl&ANSON) ? i1 : i2)
#define setwid(w)             (btumil( usrnum, w ))
#define rstroth()             (btumil( othusn, othuap->scnwid ))
#define rstrwid()             (btumil( usrnum, usaptr->scnwid ))
#define himorher(s)           (s == 'F' || s == 'f' ? "her" : "him")
#define hisorher(s)           (s == 'F' || s == 'f' ? "her" : "his")
#define heorshe(s)            (s == 'F' || s == 'f' ? "she" : "he")

                              /* keyboard characters                       */
#define kbF1             0x3b00    /* F1 - F12                             */
#define kbF2             0x3c00
#define kbF3             0x3d00
#define kbF4             0x3e00
#define kbF5             0x3f00
#define kbF6             0x4000
#define kbF7             0x4100
#define kbF8             0x4200
#define kbF9             0x4300
#define kbF10            0x4400
#define kbF11            0x9800
#define kbF12            0x9900
#define kbShiftF1        0x5400    /* SHIFT-F1 - SHIFT-F12                 */
#define kbShiftF2        0x5500
#define kbShiftF3        0x5600
#define kbShiftF4        0x5700
#define kbShiftF5        0x5800
#define kbShiftF6        0x5900
#define kbShiftF7        0x5a00
#define kbShiftF8        0x5b00
#define kbShiftF9        0x5c00
#define kbShiftF10       0x5d00
#define kbShiftF11       0xa200
#define kbShiftF12       0xa300
#define kbAltF1          0x6800    /* ALT-F1 - ALT-F12                     */
#define kbAltF2          0x6900
#define kbAltF3          0x6a00
#define kbAltF4          0x6b00
#define kbAltF5          0x6c00
#define kbAltF6          0x6d00
#define kbAltF7          0x6e00
#define kbAltF8          0x6f00
#define kbAltF9          0x7000
#define kbAltF10         0x7100
#define kbAltF11         0xb600
#define kbAltF12         0xb700
#define kbCtrlF1         0x5e00    /* CTL-F1 - CTL-F12                     */
#define kbCtrlF2         0x5f00
#define kbCtrlF3         0x6000
#define kbCtrlF4         0x6100
#define kbCtrlF5         0x6200
#define kbCtrlF6         0x6300
#define kbCtrlF7         0x6400
#define kbCtrlF8         0x6500
#define kbCtrlF9         0x6600
#define kbCtrlF10        0x6700
#define kbCtrlF11        0xac00
#define kbCtrlF12        0xad00
#define kbAlt1           0x7800    /* ALT-1                                */
#define kbAlt2           0x7900    /* ALT-2                                */
#define kbAlt3           0x7a00    /* ALT-3                                */
#define kbAlt4           0x7b00    /* ALT-4                                */
#define kbAlt5           0x7c00    /* ALT-5                                */
#define kbAlt6           0x7d00    /* ALT-6                                */
#define kbAlt7           0x7e00    /* ALT-7                                */
#define kbAlt8           0x7f00    /* ALT-8                                */
#define kbAlt9           0x8000    /* ALT-9                                */
#define kbAlt0           0x8100    /* ALT-0                                */
#define kbAltMinus       0x8200    /* ALT-MINUS                            */
#define kbAltPlus        0x8300    /* ALT-PLUS                             */
#define kbAltA           0x1e00    /* ALT-A                                */
#define kbAltB           0x3000    /* ALT-B                                */
#define kbAltC           0x2e00    /* ALT-C                                */
#define kbAltD           0x2000    /* ALT-D                                */
#define kbAltE           0x1200    /* ALT-E                                */
#define kbAltF           0x2100    /* ALT-F                                */
#define kbAltG           0x2200    /* ALT-G                                */
#define kbAltH           0x2300    /* ALT-H                                */
#define kbAltI           0x1700    /* ALT-I                                */
#define kbAltJ           0x2400    /* ALT-J                                */
#define kbAltK           0x2500    /* ALT-K                                */
#define kbAltL           0x2600    /* ALT-L                                */
#define kbAltM           0x3200    /* ALT-M                                */
#define kbAltN           0x3100    /* ALT-N                                */
#define kbAltO           0x1800    /* ALT-O                                */
#define kbAltP           0x1900    /* ALT-P                                */
#define kbAltQ           0x1000    /* ALT-Q                                */
#define kbAltR           0x1300    /* ALT-R                                */
#define kbAltS           0x1f00    /* ALT-S                                */
#define kbAltT           0x1400    /* ALT-T                                */
#define kbAltU           0x1600    /* ALT-U                                */
#define kbAltV           0x2f00    /* ALT-V                                */
#define kbAltW           0x1100    /* ALT-W                                */
#define kbAltX           0x2d00    /* ALT-X                                */
#define kbAltY           0x1500    /* ALT-Y                                */
#define kbAltZ           0x2c00    /* ALT-Z                                */
#define kbEsc            0x001b    /* ESCAPE                               */
#define kbLF             0x000a    /* Line Feed                            */
#define kbCR             0x000d    /* Carriage Return (ENTER)              */
#define kbEnter          0x000d    /* Carriage Return (ENTER)              */
#define kbBS             0x0008    /* BACKSPACE                            */
#define kbBackSpace      0x0008    /* BACKSPACE                            */
#define kbTab            0x0009    /* TAB                                  */
#define kbBTab           0x0f00    /* BACK-TAB                             */
#define kbBackTab        0x0f00    /* BACK-TAB                             */
#define kbHome           0x4700    /* HOME                                 */
#define kbUp             0x4800    /* UP-ARROW                             */
#define kbPgUp           0x4900    /* PGUP                                 */
#define kbLeft           0x4b00    /* LEFT-ARROW                           */
#define kbRight          0x4d00    /* RIGHT-ARROW                          */
#define kbEnd            0x4f00    /* END                                  */
#define kbDown           0x5000    /* DOWN-ARROW                           */
#define kbPgDn           0x5100    /* PGDN                                 */
#define kbIns            0x5200    /* INS                                  */
#define kbDel            0x5300    /* DEL                                  */
#define kbCtrlCR         kbLF      /* CTL-CR                               */
#define kbCtrlEnter      kbLF      /* CTL-CR                               */
#define kbCtrlHome       0x7700    /* CTL-HOME                             */
#define kbCtrlUp         0x9000    /* CTL-UP-ARROW                         */
#define kbCtrlPgUp       0x8400    /* CTL-PGUP                             */
#define kbCtrlLeft       0x7300    /* CTL-LEFT-ARROW                       */
#define kbCtrlRight      0x7400    /* CTL-RIGHT-ARROW                      */
#define kbCtrlEnd        0x7500    /* CTL-END                              */
#define kbCtrlDown       0x9600    /* CTL-DOWN-ARROW                       */
#define kbCtrlPgDn       0x7600    /* CTL-PGDN                             */
#define kbCtrlIns        0x9f00    /* CTL-INS                              */
#define kbCtrlDel        0x9d00    /* CTL-DEL                              */
#define kbShiftHome      0x4a00    /* SHFT-HOME                            */
#define kbShiftUp        0x8500    /* SHFT-UP-ARROW                        */
#define kbShiftLeft      0x8700    /* SHFT-LEFT-ARROW                      */
#define kbShiftRight     0x8800    /* SHFT-RIGHT-ARROW                     */
#define kbShiftDown      0x8600    /* SHFT-DOWN-ARROW                      */
#define kbAltEsc         0x8b00    /* ALT-ESC                              */
#define kbAltCR          0x8f00    /* ALT-CR                               */
#define kbAltEnter       0x8f00    /* ALT-CR                               */
#define kbAltHome        0xa600    /* ALT-HOME                             */
#define kbAltUp          0x9100    /* ALT-UP-ARROW                         */
#define kbAltLeft        0x9200    /* ALT-LEFT-ARROW                       */
#define kbAltRight       0xea00    /* ALT-RIGHT-ARROW                      */
#define kbAltDown        0x9700    /* ALT-DOWN-ARROW                       */
#define kbAltIns         0xa000    /* ALT-INS                              */
#define kbAltDel         0x9e00    /* ALT-DEL                              */
#define kbBreak          0x0003    /* Break key                            */

                              /* bits of DOS shift status byte             */
#define skInsert         0x80      /* insert mode active                   */
#define skCap            0x40      /* caps lock active                     */
#define skNum            0x20      /* num lock active                      */
#define skScroll         0x10      /* scroll lock active                   */
#define skAlt            0x08      /* alt key pressed                      */
#define skCtrl           0x04      /* ctrl key pressed                     */
#define skLShift         0x02      /* left shift key pressed               */
#define skRShift         0x01      /* right shift key pressed              */

                              /* other keys                                */
#define kbSpace          ' '       /* space                                */
#define kbDot            '.'       /* period                               */
#define kbPeriod         '.'       /* period                               */
#define kbSemiColon      ';'       /* semi-colon                           */
#define kbColon          ':'       /* colon                                */
#define kbSQuote         '''       /* single quote                         */
#define kbQuote          '"'       /* quote                                */
#define kbQuestion       '?'       /* question mark                        */
#define kbSlash          '/'       /* forward slash                        */
#define kbBSlash         '\\'      /* slash                                */
#define kbSplat          '*'       /* asterisk                             */
#define kbBang           '!'       /* exclamation point                    */
#define kbEqual          '='       /* equal sign                           */
#define kbTilde          '~'       /* tilde                                */

#define BS              '\b'
#define HT              '\t'
#define LF              '\n'
#define VT              '\13'
#define FF              '\f'
#define CR              '\r'

/*-------------------------------------------------------------------------*
 * Structure definitions
 *-------------------------------------------------------------------------*/

typedef
struct {                      /* state handling routine array              */
     int       substt;             /* user substate                        */
     void      (*inprou)(void);    /* input routine                        */
     void      (*cycrou)(void);    /* status routine                       */
     boolean   (*xitrou)(void);    /* "x" input routine                    */
     int       xitstt;             /* substt for "x" if no xitrou          */
} SubState;

#endif

/*)}*/
