
#include "gcomm.h"
#include "majorbbs.h"
#include "escgraf.h"

#define grafrnd(num)     (rand() % (num))

void    EXPORT  init__escgraf(void);

/* module entry points */
STATIC  int     grafrou(void);
STATIC  void    savemsg(void);
STATIC  void    delmsg(void);
STATIC  int     procxs(void);
STATIC  void    gansws(void);
STATIC  void    scramble(void);
STATIC  void    startshow(void);
STATIC  void    stopshow(void);
STATIC  void    displaymsg(int);
STATIC  void    wallstat(void);
STATIC  void    readwall(int);
STATIC  void    clswall(void);
STATIC  void    lmenu(void);
STATIC  void    shmenu(void);
STATIC  void    cleanwall(void);


struct module graffiti = {      /* module interface block               */
    "",                         /* name used to refer to this module    */
    NULL,                       /* user logon supplemental routine      */
    grafrou,                    /* input routine if selected            */
    wallstat,                   /* status-input routine if selected     */
    NULL,                       /* "injoth" routine for this module     */
    NULL,                       /* user logoff supplemental routine     */
    NULL,                       /* hangup (lost carrier) routine        */
    cleanwall,                  /* midnight cleanup routine             */
    NULL,                       /* delete-account routine               */
    clswall                     /* finish-up (sys shutdown) routine     */
};

#define RUMORSIZE 81

static
FILE *wallmb;                   /* Message file                         */

static
BTVFILE *wallbt;                /* Graffiti wall btrieve data file      */

STATIC
int     grfstt;                 /* module state number                  */

struct wallrec {                /* btrieve record definition            */
    long        msgid;          /* unique identifier                    */
    char        userid[UIDSIZ]; /* user-id                              */
    int         count;          /* when limit is reached, delete this msg*/
    char        msg[RUMORSIZE]; /* message text                         */
} wallrcd;

struct wallmem {                /* Wall memory resident structure:      */
    long        currec;         /* current record reading               */
    char        userid[UIDSIZ]; /* user-id                              */
    char        msg[RUMORSIZE]; /* current message entered              */
};

#define wallmp ((struct wallmem *)vdaptr)

static char readch, writech, delch, listch, helpch;
static char maxmsgs;
static char msgcount;
static char curuser[UIDSIZ];

/* Initialize the graffiti wall.  Open message file and      */
/* Btrieve file.  And allocate all needed memory.            */
void    EXPORT  init__escgraf(void)
{

    stzcpy(graffiti.descrp, gmdnam("ESCGRAF.MDF"), MNMSIZ);
    grfstt = register_module(&graffiti);

    wallmb     = opnmsg("escgraf.mcv");
    wallbt     = opnbtv("escgraf.dat", sizeof(struct wallrec));
    dclvda(sizeof(struct wallmem));

    readch     = chropt(READOPT);
    writech    = chropt(WRITEOPT);
    delch      = chropt(DELOPT);
    listch     = chropt(LISTOPT);
    helpch     = chropt(HELPOPT);
    maxmsgs    = numopt(MAXMSGS, 0, 100);
    msgcount   = 0;
    curuser[0] = '\0';
}

/* grafrou -- Main input routine handeler for The Wall */
STATIC
int grafrou(void)
{
    /* indicate our message file and the Btrieve file */
    setmbk(wallmb);
    setbtv(wallbt);

    /* preprocess a possible "X" entry.  "X" ALWAYS backs up!  */
    if ((margc == 1) && sameas(margv[0], "X")) {
        return(procxs());
    }

    do {
        bgncnc();
        switch (usrptr->substt) {
            case 0:             /* User just arrived */
                cncchr();
                prfmsg(HITHERE, usaptr->userid);
                /* NOTE:  absence of "break;" */
            case LMENU:         /* At main menu */
                lmenu();
                break;

            case SMENU:         /* At short menu prompt */
                shmenu();
                break;

            case ANSWER:        /* Entered a response */
                gansws();
                break;

            case DISPLAY:       /* was reading wall.  Abort */
            case SYSLIST:       /* Was listing wall.  Abort */
                stopshow();
                prf("");
                outprf(usrnum);
                break;

            case NEWMSG:        /* Entered a new message */
                savemsg();
                cncall();
                break;

            case DELMSG:        /* Entered message to delete */
                delmsg();
                break;
        }
    } while (!endcnc());
    outprf(usrnum);
    return(1);
}

/* savemsg -- Message is already entered in input.  Find the current    */
/*            highest message id, add one to it.                        */
STATIC
void savemsg(void)
{
    if ((margc) && (!sameas("X", margv[0]))) {
        rstrin();
        ++msgcount;
        prfmsg(WALLSAV);

        if (qhibtv(0)) {
            ghibtv(&wallrcd, 0);
            wallrcd.msgid += 1;
        }
        else {
            wallrcd.msgid = 1;
        }

        wallmp->currec = wallrcd.msgid;
        strncpy(wallrcd.msg, input, RUMORSIZE);
        wallrcd.msg[(RUMORSIZE - 1)] = '\0';

        memmove(wallrcd.userid, usaptr->userid, UIDSIZ);
        wallrcd.count = 0;
        insbtv(&wallrcd);       /* insert the new record */
        prfmsg(WALLDON);
    }
    btumil(usrnum, 0);
    shmenu();
}

/* delmsg -- A message number of a message to be erased has been        */
/*           entered.  Erase the message.                               */
STATIC
void delmsg(void)
{
    wallrcd.msgid = cnclon();
    if (wallrcd.msgid != 0) {
        if (acqbtv(&wallrcd, &wallrcd, 0)) {
            delbtv();
            prfmsg(WALLDEL);
        }
        else {
            prfmsg(BADNUM);
        }
    }
    shmenu();
}

/* procxs -- Global "X" processor for Graffiti.  If currently           */
/*           displaying the wall, then abort it, otherwise if not at    */
/*           the short menu return to it.  If at the short menu, "X"    */
/*           means to leave.                                            */
STATIC
int procxs(void)
{
    if ((usrptr->substt == DISPLAY) || (usrptr->substt == SYSLIST)) {
        stopshow();
        clrinp();
        return(1);
    }
    else if (usrptr->substt > ANSWER) {
        shmenu();
        outprf(usrnum);
        return(1);
    }
    else {
        prfmsg(LEAVE);
        return(0);
    }
}

/* gansw -- Get, and verify the menu responses                          */
STATIC
void gansws(void)
{
    char        ch;

    ch = cncchr();
    ch = toupper(ch);

    if (ch == '\0') {
        lmenu();
    } else if (ch == '?') {
        lmenu();
    } else if (ch == helpch) {
        prfmsg(ABOUT);
        lmenu();
    } else if (ch == readch) {
        readwall(DISPLAY);
    } else if (ch == writech) {
        if (strcmp(curuser, usaptr->userid) == 0) {
            if ((msgcount >= maxmsgs) && (maxmsgs > 0)) {
                prfmsg(MSGDENY);
                shmenu();
                return;
            }
        }
        else if (!hasmkey(WRTKEY)) {
            prfmsg(NOTVAL);
            lmenu();
            return;
        }
        else {
            strcpy(curuser, usaptr->userid);
            msgcount = 0;
        }
        btumil(usrnum, (RUMORSIZE - 1));
        prfmsg(usrptr->substt = NEWMSG);
    } else if ((ch == listch) && hasmkey(SYSKEY)) {
        readwall(SYSLIST);
    } else if ((ch == delch) && hasmkey(SYSKEY)) {
        prfmsg(usrptr->substt = DELMSG);
    }
    else {
        prfmsg(NOTVAL);
        lmenu();
    }
}


/* scramble -- responsible for simulating the "graffiti look" of the    */
/*             wall.  If ANSI is ON then change to a random color.      */
/*             And ALWAYS add a random number of leading spaces.        */
STATIC
void scramble(void)
{
    char        msg[20];
    int         ch;

    /* makes the WALL look more like graffiti */
    ch = (grafrnd(7) + 31);

    memset(msg, ' ', 11);
    msg[grafrnd(10)] = '\0';

    prf("%c[[%c[%dm%s|%s]", 27, 27, ch, msg, msg);
}


/* startshow -- Sets up the display/list of the wall messages.          */
STATIC
void startshow(void)
{
    prfmsg(WALLHEAD);
    ghibtv(&wallrcd, 0);
    wallmp->currec = wallrcd.msgid;
    strcpy(wallmp->msg, wallrcd.msg);
    strcpy(wallmp->userid, wallrcd.userid);
/*  outprf(usrnum); */
    btuinj(usrnum, 240);
}


/* stopshow -- ends the display/list of the wall messages.              */
STATIC
void stopshow(void)
{
    cncall();
    btucli(usrnum);
    btuclo(usrnum);
    prf("\r\r");

    shmenu();
    outprf(usrnum);
}


/* displaymsg -- Displays the current, buffered message.  And then      */
/*               attempts to find the next one.  If not found the       */
/*               display is stopped                                     */
STATIC
void displaymsg(int state)
{
    char        *msgnum;

    if ((btuoba(usrnum)) >= 500) {
        if (state == DISPLAY) {
            scramble();
            prf("%s\r", wallmp->msg);
        }
        else {
            msgnum = NULL;
            msgnum = ltoa(wallmp->currec);
            prf("%6s %-10s %s\r", msgnum, wallmp->userid, wallmp->msg);
        }
        outprf(usrnum);

        /* get next record */
        wallrcd.msgid = wallmp->currec;
        if (qltbtv(&wallrcd, 0)) {
            gltbtv(&wallrcd, &wallrcd, 0);
            wallmp->currec = wallrcd.msgid;
            strcpy(wallmp->msg, wallrcd.msg);
            strcpy(wallmp->userid, wallrcd.userid);
            usrptr->substt = state;
            btuinj(usrnum, 240);
        }
        else {
            prf("\r\r");
            shmenu();
            outprf(usrnum);
        }
    }
    else {
        btuinj(usrnum, 240);
    }
}


/* wallstat -- The status handeler for the graffiti wall.               */
STATIC
void wallstat(void)
{
    if (status == 240) {
        /* indicate our message file and the Btrieve file */
        setmbk(wallmb);
        setbtv(wallbt);
        usrptr->pfnacc = 0;

        if (usrptr->substt == DISPLAY) {
            displaymsg(usrptr->substt);
        }
        else if (usrptr->substt == SYSLIST) {
            displaymsg(usrptr->substt);
        }
    }
    else {
        dfsthn();
    }
}


/* readwall -- Starts the reading of the wall.  Reading is performed    */
/*             in REVERSE order.  So this jumps to the last message.    */
STATIC
void readwall(int state)
{
    /* skip to highest message on wall to scan BACKwards */
    if (qhibtv(0)) {
        startshow();
        usrptr->substt = state;
    }
    else {
        prfmsg(EMPTY);
        lmenu();
    }
}


/* clswall -- Shut down the wall routine.  Closes files                 */
STATIC
void clswall(void)
{
    clsbtv(wallbt);     /* Close the Btrieve File */
    clsmsg(wallmb);     /* Close the .MCV file */
}

/* lmenu -- Display the full LONG menu                                  */
STATIC
void lmenu(void)
{
    if (hasmkey(SYSKEY)) {
        prfmsg(SYSLMENU);
    }
    else if (hasmkey(WRTKEY)) {
        prfmsg(LWMENU);
    }
    else {
        prfmsg(LMENU);
    }

    usrptr->substt = ANSWER;
}


/* shmenu -- Displays the short message prompt                          */
STATIC
void shmenu(void)
{
    usrptr->substt = ANSWER;

    if (hasmkey(SYSKEY)) {
        prfmsg(SYSSMENU);
    }
    else if (hasmkey(WRTKEY)) {
        prfmsg(SWMENU);
    }
    else {
        prfmsg(SMENU);
    }
}

/* cleanwall -- Scan all messages.  Add one to the "life" of each       */
/*              message.  If the life becomes older than the Sysop      */
/*              definable value then delete the message.                */
STATIC
void cleanwall(void)
{
    unsigned long       newnum = 0;
    int                 maxdays;

    /* loop through messages in msgnum order.  Delete old messages */
    setbtv(wallbt);
    setmbk(wallmb);

    msgcount      = 0;
    curuser[0]    = '\0';
    maxdays       = numopt(MAXDAYS, 0, 365);
    wallrcd.msgid = newnum;

    while (qgtbtv(&wallrcd, 0)) {
        ggtbtv(&wallrcd, &wallrcd, 0);
        if (++wallrcd.count > maxdays) {
            delbtv();
        }
        else {
            wallrcd.msgid = ++newnum;
            updbtv(&wallrcd);
        }
        wallrcd.msgid = newnum;
    }
}

