/***************************************************************************
 *                                                                         *
 *   GALUPX2.C                                                             *
 *                                                                         *
 *   Copyright (C) 1994 GALACTICOMM, Inc.    All Rights Reserved.          *
 *                                                                         *
 *   Uploading example II                                                  *
 *                                                                         *
 *                                              - R. Stein  12/6/93        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "filexfer.h"
#include "galupx2.h"

STATIC int uplinp(void);
STATIC void uplfil(char *filnam,char *protoc);
STATIC int fupupl(int fupcod);
STATIC void uplfin(void);

int uplstt;                        /* Enhanded uploader module state number*/
static FILE *uplmb;                /* file pointer for GALUPX2.MCV         */
char *upldir;                      /* UPLDIR upload directory              */
long uplbmax;                      /* max bytes allowed in UPLDIR          */
long uplfmax;                      /* max files allowed in UPLDIR          */

struct module uplmodule={          /* module interface block               */
     "",                           /*    name used to refer to this module */
     NULL,                         /*    user logon supplemental routine   */
     uplinp,                       /*    input routine if selected         */
     dfsthn,                       /*    status-input routine if selected  */
     NULL,                         /*    "injoth" routine for this module  */
     NULL,                         /*    user logoff supplemental routine  */
     NULL,                         /*    hangup (lost carrier) routine     */
     NULL,                         /*    midnight cleanup routine          */
     NULL,                         /*    delete-account routine            */
     uplfin                        /*    finish-up (sys shutdown) routine  */
};

void EXPORT
init__uploader(void)                    /* Uploader initialization         */
{
     stzcpy(uplmodule.descrp,gmdnam("GALUPX2.MDF"),MNMSIZ);
     uplstt=register_module(&uplmodule);
     uplmb=opnmsg("GALUPX2.MCV");
     mkdir(spr("%s.",upldir=stgopt(UPLDIR)));
     uplbmax=lngopt(UPLBMAX,0,2147483647L);
     uplfmax=numopt(UPLFMAX,0,32767);
     dclvda(8+1+3+1);
}

STATIC int
uplinp(void)                            /* Uploader input handler          */
{
     setmbk(uplmb);
     if (margc == 1 && sameas(margv[0],"X")) {
          return(0);
     }
     do {
          bgncnc();
          switch (usrptr->substt) {
          case 0:
               cncchr();
               prfmsg(usrptr->substt=UPLNAME);
               break;
          case UPLNAME:
               if (usrptr->flags&INJOIP) {
                    prfmsg(UPLNAME);
                    break;
               }
               cncall();
               parsin();
               switch (margc) {
               case 0:
                    uplfil("","?");
                    break;
               case 1:
                    uplfil(margv[0],"?");
                    break;
               default:
                    uplfil(margv[0],margv[1]);
               }
               break;
          }
     } while (!endcnc());
     outprf(usrnum);
     return(1);
}

STATIC void
uplfil(                                 /* upload file(s)                  */
char *filnam,                           /* file name, or "" for multi-file */
char *protoc)                           /* protocol, or "?" for list       */
{
     if (sameas(filnam,"*")) {
          filnam="";
     }
     if (rsvnam(filnam)
      || strchr(filnam,':') != NULL
      || strchr(filnam,'\\') != NULL
      || strstr(filnam,"..") != NULL) {
          prfmsg(UPLRSV);
          prfmsg(UPLNAME);
     }
     else {
          stzcpy(vdaptr,filnam,8+1+3+1);
          fileup(filnam,protoc,fupupl);
     }
}

int
fupupl(                                 /* Upload handling routine         */
int fupcod)
{
     int rc=0;

     setmbk(uplmb);
     switch(fupcod) {
     case FUPBEG:                /* Begin upload, check permission, reserve */
          if (vdaptr[0] == '\0' && rsvnam(ftfscb->fname)) {
               strcpy(ftfbuf,"File name is a reserved DOS device name.");
               break;
          }
          cntdir(spr("%s*.*",upldir));
          if (numfils >= uplfmax) {
               strcpy(ftfbuf,"Upload directory is full.");
               break;
          }
          ftfscb->maxbyt=uplbmax-numbyts;
          sprintf(ftfbuf,"%s%s",upldir,vdaptr[0] == '\0' ? ftfscb->fname
                                                         : vdaptr);
          rc=1;
          break;
     case FUPEND:               /* End complete upload of a file, unreserve */
          sprintf(ftfbuf,"%s%s",upldir,vdaptr[0] == '\0' ? ftfscb->fname
                                                         : vdaptr);
          break;
     case FUPSKP:                       /* Skip incomplete upload of a file */
          unlink(spr("%s%s",upldir,vdaptr[0] == '\0' ? ftfscb->fname
                                                     : vdaptr));
          break;
     case FUPFIN:                             /* Finish file upload session */
          usrptr->state=uplstt;
          if (ftfscb->actfil >= 1) {
              prfmsg(UPLTHX);
          }
          break;                 /* rc == 0, so we exit to parent menu page */
     }
     return(rc);
}

STATIC void
uplfin(void)                            /* Finalize uploading example      */
{
     clsmsg(uplmb);
}
