/***************************************************************************
 *                                                                         *
 *     QUEST FOR MAGIC Version 3.0                                         *
 *                                                                         *
 *     Copyright (C) 1986-1992 GALACTICOMM, Inc.    All Rights Reserved.   *
 *                                                                         *
 ***************************************************************************
 * GALACTICOMM Software License Agreement                                  *
 *                                                                         *
 * GALACTICOMM, Inc., grants you a fully paid, perpetual, worldwide,       *
 * non-exclusive license to use, transfer, share, modify, delete, and      *
 * incorporate this Software into products copyrighted, patented,          *
 * subject to trade secret or other intellectual protection rights         *
 * asserted by you.                                                        *
 *                                                                         *
 * This Software is provided "as is", without warranty of any kind,        *
 * either expressed or implied, including, but not limited to, the implied *
 * warranties of merchantability and fitness for a particular purpose.     *
 *                                                                         *
 * This license is effective as long as this declaration is preserved in   *
 * its entirety in this Software and any copies or derivatives.            *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *     QMSPLUTL.C                                                          *
 *     Quest for Magic Spell Utilities and Timer Routines                  *
 *                                                                         *
 *     By - Scott Brinker and Tim Stryker      11/21/86                    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "galqm.h"
#include "qm.h"

extern
FILE *qmmsg;

int bs,sbs,mbs,embs;

void
inispl(void)                  /* initialization at system boot time   */
{
     bs=0;
     mbs=0;
     embs=0;
     sbs=0;
     rtkick(5,decspu);
}

void
decspu(void)
{
     int i;

     setmbk(qmmsg);
     if (bs < 32) {
          bs++;
     }
     else {
          bs=0;
          prfmsg(QMSPL100);
          qmoutall();
     }
     if (mbs < 67) {
          mbs++;
     }
     else {
          mbs=0;
          prfmsg(QMSPL101);
          qmoutall();
     }
     if (sbs < 51) {
          sbs++;
     }
     else {
          sbs=0;
          prfmsg(QMSPL102);
          qmoutroom(&qmrooms[187]);
     }
     if (embs < 100) {
          embs++;
     }
     else {
          embs=0;
          prfmsg(QMSPL103);
          qmoutroom(&qmrooms[21]);
     }
     for (i=0,playpt=qmplayer ; i < nterms ; i++,playpt++) {
          usaptr=uacoff(i);
          if (playpt->flags&INQM) {
               if (playpt->spluse > 0) {
                    playpt->spluse-=10;
               }
               if (playpt->invtimer > 0 && (playpt->invtimer-=10) <= 0) {
                    if (playpt->aura&(INVIS1+INVIS2+INVIS3)) {
                         playpt->aura&=~(INVIS1+INVIS2+INVIS3);
                         prfmsg(BVISP);
                    }
                    else {
                         prfmsg(BNODRG);
                    }
                    outprf(playpt->channel);
                    prfmsg(BVISO1,playpt->altid);
                    strcpy(playpt->altid,playpt->plyrid);
                    strcpy(playpt->hisher,usaptr->sex == 'M' ? "his" : "her");
                    if (playpt->descrpt == DRAGON) {
                         playpt->descrpt=(sameas(playpt->hisher,"his") ? NORMM : NORMF);
                    }
                    prfmsg(BVISO2,playpt->altid);
                    outothr();
               }
               if (playpt->crstimer > 0 && (playpt->crstimer-=10) <= 0) {
                    playpt->aura&=(SEEPYR+SEEOBJ+PICOBJ);
                    prfmsg(LOSCP);
                    outprf(playpt->channel);
                    prfmsg(LOSCO,playpt->altid);
                    outothr();
               }
               if (playpt->prttimer > 0 && (playpt->prttimer-=10) <= 0) {
                    playpt->aura&=~(FIRPRO+LIGPRO+ICEPRO+CURPRO+MAGPRO+STLPRO+SCRPRO);
                    prfmsg(LOSPP);
                    outprf(playpt->channel);
                    prfmsg(LOSPO,playpt->altid);
                    outothr();
               }
               if (playpt->pwrtimer > 0 && (playpt->pwrtimer-=10) <= 0) {
                    playpt->aura&=~(SEEIN1+SEEIN2);
                    prfmsg(LOSPWP);
                    outprf(playpt->channel);
                    prfmsg(LOSPWO,playpt->altid);
                    outothr();
               }
          }
     }
     rtkick(10,decspu);
}

void
sspdly(seconds)
int seconds;
{
     playpt->spluse=seconds;
}

void
nsplcs(void)
{
    prfmsg(NOCAST,playpt->altid);
    outothr();
    prfmsg(NOPOWR);
    outprf(usrnum);
}


