/***************************************************************************
 *                                                                         *
 *     QUEST FOR MAGIC Version 3.0                                         *
 *                                                                         *
 *     Copyright (C) 1986-1992 GALACTICOMM, Inc.    All Rights Reserved.   *
 *                                                                         *
 ***************************************************************************
 * GALACTICOMM Software License Agreement                                  *
 *                                                                         *
 * GALACTICOMM, Inc., grants you a fully paid, perpetual, worldwide,       *
 * non-exclusive license to use, transfer, share, modify, delete, and      *
 * incorporate this Software into products copyrighted, patented,          *
 * subject to trade secret or other intellectual protection rights         *
 * asserted by you.                                                        *
 *                                                                         *
 * This Software is provided "as is", without warranty of any kind,        *
 * either expressed or implied, including, but not limited to, the implied *
 * warranties of merchantability and fitness for a particular purpose.     *
 *                                                                         *
 * This license is effective as long as this declaration is preserved in   *
 * its entirety in this Software and any copies or derivatives.            *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *     QMINTER.C                                                           *
 *     Quest for Magic Player Interaction Commands                         *
 *                                                                         *
 *     By - Tim Stryker and Scott Brinker      11/21/86                    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "qm.h"
#include "galqm.h"

void
qmsayrou(void)
{
     if (margc == 1) {
          prfmsg(UNSURE,playpt->altid);
          outothr();
          xmunum(SPCLES);
     }
     else if (pfnlvl >= 2) {
          prfmsg(SHADES,playpt->altid);
          outothr();
          xmunum(HEYKCL);
     }
     else {
          rst4say();
          prfmsg(QMINT100,playpt->altid,margv[0],margv[1]);
          outothr();
          prfmsg(NEARBY);
          qmoutnear();
          xmunum(NOSAYB);
     }
}

void
qmwhsrou(void)
{

     if (margc < 3) {
          prfmsg(LKSTRA,playpt->altid);
          outothr();
          prfmsg(QMINT101);
          outprf(usrnum);
     }
     else if (pfnlvl >= 2) {
          prfmsg(BNASTY,playpt->altid);
          outothr();
          xmunum(UNOTNI);
     }
     else {
          if ((othppt=qmfndplyr(margv[2])) != NULL) {
               rst4whs();
               prfmsg(WHIS2U,playpt->altid,margv[3]);
               outprf(othppt->channel);
               prfmsg(HEARSU,othppt->plyrid);
               outprf(usrnum);
               prfmsg(WHIS2S,playpt->altid,othppt->altid);
               outevbt(othppt);
          }
          else {
               prfmsg(LKEXAS,playpt->altid);
               outothr();
               prfmsg(SNOTHR,namize(margv[2]));
               outprf(usrnum);
          }
     }
}

void
yelrou(void)
{
     char *yelptr;

     if (margc == 1) {
          prfmsg(SINGLD,playpt->altid,margv[0]);
          outothr();
          prfmsg(SINGNR,margv[0]);
          qmoutnear();
          prfmsg(SINGDS,margv[0]);
          outfar();
          xmunum(ULOUDE);
     }
     else if (pfnlvl >= 2) {
          prfmsg(BRUDEV,playpt->altid);
          outothr();
          prfmsg(QMINT102);
          outprf(usrnum);
     }
     else {
          rst4say();
          for (yelptr=margv[1] ; *yelptr != '\0' ; yelptr++) {
               *yelptr=toupper(*yelptr);
          }
          prfmsg(QMINT103,playpt->altid,margv[0],margv[1]);
          outothr();
          prfmsg(QMINT104,margv[0],margv[1]);
          qmoutnear();
          prfmsg(SINGDS,margv[0]);
          outfar();
          xmunum(ULOUDV);
     }
}

void
moving(void)
{
     if (margc < 2) {
          xmunum(ENJSLF);
          prfmsg(DAYDRM,playpt->altid);
          outothr();
     }
     else if (sameas(margv[1],"n") || sameas(margv[1],"north")) {
          north();
     }
     else if (sameas(margv[1],"s") || sameas(margv[1],"south")) {
          south();
     }
     else if (sameas(margv[1],"e") || sameas(margv[1],"east")) {
          east();
     }
     else if (sameas(margv[1],"w") || sameas(margv[1],"west")) {
          west();
     }
     else {
          xmunum(CANTDU);
          prfmsg(PONDPS,playpt->altid);
          outothr();
     }
}

void
nasty(void)
{
     xmunum(STOPCN);
     prfmsg(ACRUDE,playpt->altid);
     outothr();
}

void
becute(void)
{
     cumnut("***\r%s is looking wishful!\r",
            "...I'm sure the %s appreciates it!\r",
            "...I'm sure your %s appreciates it!\r",
            "...Now, Isn't that cute!\r",
            "***\r%s is longing for a friend!\r");
}

void
qmbemean(void)
{
     cumnut("***\r%s has a nasty look!\r",
            "...Why, what did the %s do to you?\r",
            "...A little weird, no?\r",
            "...Now why would you want to do that?\r",
            "***\r%s is savagely looking around!\r");
}

void
cumnut(stg1,stg2,stg3,stg4,stg5)
char *stg1,*stg2,*stg3,*stg4,*stg5;
{
     struct item *itmptr;

     bagthe();
     qmbagprep();
     if (margc == 1) {
          prfmsg(SWHOWT,namize(margv[0]),namize(margv[0]));
          outprf(usrnum);
          prf(stg1,playpt->altid);
          outothr();
     }
     else if ((itmptr=getritm(playpt->room,margv[1])) != NULL) {
          putritm(playpt->room,itmptr);
          prfmsg(ATTSTS,playpt->altid,margv[0],itmptr->name);
          outothr();
          prf(stg2,itmptr->name);
          outprf(usrnum);
     }
     else if ((itmptr=getpitm(playpt,margv[1])) != NULL) {
          putpitm(playpt,itmptr);
          prfmsg(ATTSSS,playpt->altid,margv[0],playpt->hisher,itmptr->name);
          outothr();
          prf(stg3,itmptr->name);
          outprf(usrnum);
     }
     else if ((othppt=qmfndplyr(margv[1])) != NULL) {
          if (sameas(margv[0],"kiss") || sameas(margv[0],"hug")) {
               prfmsg(GIVUAS,playpt->altid,margv[0]);
               outprf(othppt->channel);
               prfmsg(GIVSAS,playpt->altid,othppt->altid,margv[0]);
               outevbt(othppt);
               xmunum(AWWWWW);
          }
          else {
               prfmsg(BESTSU,playpt->altid,playpt->hisher,margv[0]);
               outprf(othppt->channel);
               prfmsg(BESTSS,
                    playpt->altid,playpt->hisher,margv[0],othppt->altid);
               outevbt(othppt);
               btuxmt(usrnum,stg4);
          }
     }
     else if (margc >= 2 && sameas(margv[1],"presence")
               || sameas(margv[1],"invisible")
               || sameas(margv[1],"unseen")
               || sameas(margv[1],"mystical")
               || sameas(margv[1],"magical")) {
               playpt->descrpt=(sameas(playpt->hisher,"his") ? DESC7M : DESC7F);
               xmunum(FRCNTN);
               prfmsg(CLUTCH,playpt->altid);
               outothr();
     }
     else {
          prf(stg5,playpt->altid);
          outothr();
          prfmsg(SNOTHR,namize(margv[1]));
          outprf(usrnum);
     }
}

void
givrou(void)
{
     bagthe();
     if (margc == 3) {
          givutl(margv[1],margv[2]);
     }
     else if (margc == 4 && sameas(margv[2],"to")) {
          givutl(margv[3],margv[1]);
     }
     else {
          xmunum(GIVMEB);
          prfmsg(FUMBLE,playpt->altid);
          outothr();
     }
}

void
givutl(givee,givwhat)
char *givee,*givwhat;
{
     struct item *itmptr,*itmpt2;

     if ((othppt=qmfndplyr(givee)) == NULL) {
          prfmsg(SNOTHR,namize(givee));
          outprf(usrnum);
          prfmsg(SEETHN,playpt->altid);
          outothr();
     }
     else if ((itmptr=getpitm(playpt,givwhat)) == NULL) {
          prfmsg(ARENTH,aoran(givwhat));
          outprf(usrnum);
          prfmsg(LK4SOM,playpt->altid);
          outothr();
     }
     else if (othppt->nitems >= MXITEM) {
          if (playpt->room->nitems >= MXITEM) {
          playpt->descrpt=(sameas(playpt->hisher,"his") ? DESC7M : DESC7F);
               putpitm(playpt,itmptr);
               xmunum(NICTHT);
               prfmsg(WRSMYS,playpt->altid);
               outothr();
          }
          else if (rnd()&1) {
               putritm(playpt->room,itmptr);
               prfmsg(DROPSS,playpt->altid,playpt->hisher,itmptr->name);
               outothr();
               xmunum(OOOOPS);
          }
          else {
               itmpt2=getpitm(othppt,othppt->items[0]->name);
               putritm(playpt->room,itmpt2);
               putpitm(othppt,itmptr);
               prfmsg(GIVUDP,playpt->altid,aoran(itmptr->name),itmpt2->name);
               outprf(othppt->channel);
               prfmsg(GIVSDP,
                   playpt->altid,othppt->altid,aoran(itmptr->name),
                   othppt->altid,othppt->hisher,itmpt2->name);
               outevbt(othppt);
               prfmsg(UMADED,othppt->altid,othppt->hisher,itmpt2->name);
               outprf(usrnum);
          }
     }
     else {
          putpitm(othppt,itmptr);
          prfmsg(GIVEUS,playpt->altid,aoran(itmptr->name));
          outprf(othppt->channel);
          prfmsg(GIVESS,playpt->altid,othppt->altid,
                aoran(itmptr->name));
          outevbt(othppt);
          xmunum(CONSDN);
     }
}

void
qmgetrou(void)
{
     bagthe();
     if (margc == 2) {
          getrut(margv[1]);
     }
     else if (margc == 3 && sameas(margn[1]-2,"'s")) {
          *(margn[1]-2)='\0';
          getput(margv[1],margv[2]);
     }
     else if (margc == 4 && sameto(margv[2],"from")) {
          getput(margv[3],margv[1]);
     }
     else {
          xmunum(INTCNC);
          prfmsg(SFREAK,playpt->altid);
          outothr();
     }
}

void
getput(who,getwhat)
char *who,*getwhat;
{
     struct item *itmptr;

     if ((othppt=qmfndplyr(who)) == NULL) {
          prfmsg(SNOTHR,namize(who));
          outprf(usrnum);
          prfmsg(SSEEIN,playpt->altid);
          outothr();
     }
     else if ((itmptr=getpitm(othppt,getwhat)) == NULL) {
          playpt->descrpt=(sameas(playpt->hisher,"his") ? DESC6M : DESC6F);
          prfmsg(SNOTHL,othppt->altid,aoran(getwhat));
          outprf(usrnum);
          prfmsg(LKSUSP,playpt->altid);
          outothr();
     }
     else if (playpt->nitems >= MXITEM) {
          playpt->descrpt=(sameas(playpt->hisher,"his") ? DESC6M : DESC6F);
          putpitm(othppt,itmptr);
          xmunum(HNDFUL);
          prfmsg(FUMBIT,playpt->altid,playpt->hisher);
          outothr();
     }
     else if (othppt->aura&STLPRO) {
          putpitm(othppt,itmptr);
          xmunum(KYPREV);
          prfmsg(KYPURB,playpt->altid);
          outprf(othppt->channel);
          prfmsg(KYPSRB,othppt->altid,playpt->altid);
          outevbt(othppt);
     }
     else if ((rnd()&0x0E) != 0) {
          putpitm(othppt,itmptr);
          prfmsg(STEALU,playpt->altid,itmptr->name);
          outprf(othppt->channel);
          prfmsg(STEALS,playpt->altid,othppt->altid,itmptr->name);
          outevbt(othppt);
          xmunum(UATTFL);
     }
     else {
          putpitm(playpt,itmptr);
          prfmsg(STOLEU,playpt->altid,itmptr->name);
          outprf(othppt->channel);
          prfmsg(STOLES,playpt->altid,othppt->altid,itmptr->name);
          outevbt(othppt);
          xmunum(UGOTIT);
     }
}

void
getrut(getwhat)
char *getwhat;
{
     struct item *itmptr;

     if ((itmptr=getritm(playpt->room,getwhat)) == NULL) {
          xmunum(WHUSEE);
          prfmsg(BYHELP,playpt->altid);
          outothr();
     }
     else if (playpt->nitems >= MXITEM) {
          putritm(playpt->room,itmptr);
          xmunum(LILGRD);
          prfmsg(GGLINT,playpt->altid,playpt->hisher);
          outothr();
     }
     else {
          putpitm(playpt,itmptr);
          xmunum(ITYOUR);
          prfmsg(STOOKS,
               playpt->altid,itmptr->name,(char *)(playpt->room->objloc));
          outothr();
     }
}

void
north(void)
{
     if (playpt->room->inorth != 255) {
          qmxitroom(playpt,rawmsg(QMINT204));
          qmentroom(playpt,&qmrooms[playpt->room->inorth],rawmsg(QMINT200));
     }
     else {
          prfmsg(BLUNDR,playpt->altid);
          outothr();
          xmunum(NONORT);
     }
}

void
south(void)
{
     if (playpt->room->isouth != 255) {
          qmxitroom(playpt,rawmsg(QMINT205));
          qmentroom(playpt,&qmrooms[playpt->room->isouth],rawmsg(QMINT201));
     }
     else {
          prfmsg(BLUNDR,playpt->altid);
          outothr();
          xmunum(NOSOUT);
     }
}

void
east(void)
{
     if (playpt->room->ieast != 255) {
          qmxitroom(playpt,rawmsg(QMINT206));
          qmentroom(playpt,&qmrooms[playpt->room->ieast],rawmsg(QMINT202));
     }
     else {
          prfmsg(BLUNDR,playpt->altid);
          outothr();
          xmunum(NOEAST);
     }
}

void
west(void)
{
     if (playpt->room->iwest != 255) {
          qmxitroom(playpt,rawmsg(QMINT207));
          qmentroom(playpt,&qmrooms[playpt->room->iwest],rawmsg(QMINT203));
     }
     else {
          prfmsg(BLUNDR,playpt->altid);
          outothr();
          xmunum(NOWEST);
     }
}

void
qmlokrou(void)
{
     struct item *itempt;

     bagthe();
     qmbagprep();
     if (margc >= 2 && (itempt=getritm(playpt->room,margv[1])) != NULL) {
          putritm(playpt->room,itempt);
          prfmsg(itempt->descip);
          outprf(usrnum);
          prfmsg(SEXMTS,playpt->altid,itempt->name);
          outothr();
     }
     else if (margc >= 2 && (itempt=getpitm(playpt,margv[1])) != NULL) {
          putpitm(playpt,itempt);
          prfmsg(itempt->descip);
          outprf(usrnum);
          prfmsg(SEXMSS,playpt->altid,playpt->hisher,itempt->name);
          outothr();
     }
     else if (margc >= 2 && (othppt=qmfndplyr(margv[1])) != NULL) {
          prfmsg(othppt->descrpt,othppt->plyrid);
          prfmsg(QMINT105,namize(othppt->hisher));
          invutl(othppt);
          outprf(usrnum);
          prfmsg(LKUCAR,playpt->altid);
          outprf(othppt->channel);
          prfmsg(SEXAMS,playpt->altid,othppt->altid);
          outevbt(othppt);
     }
     else if (margc >= 2 && sameto(margv[1],"brief")) {
          prfmsg(QMINT106,(char *)(playpt->room->brdesc));
          seeitms(playpt);
          seepyrs(playpt);
          outprf(usrnum);
          prfmsg(GLIMPS,playpt->altid);
          outothr();
     }
     else if (margc >= 2 && sameas(margv[1],"presence")
               || sameas(margv[1],"invisible")
               || sameas(margv[1],"unseen")
               || sameas(margv[1],"mystical")
               || sameas(margv[1],"magical")) {
               xmunum(FRCNVI);
               prfmsg(STARTA,playpt->plyrid);
               outothr();
     }
     else {
          prfmsg(playpt->room->desc);
          seeitms(playpt);
          seepyrs(playpt);
          outprf(usrnum);
          prfmsg(SCARFI,playpt->altid);
          outothr();
     }
}

void
shvrou(void)
{
     qmbagprep();
     bagthe();
     if (margc == 3) {
          if ((othppt=qmfndplyr(margv[1])) != NULL) {
               if (sameto(margv[2],"north")
                && shvutl("the south","north",&qmrooms[playpt->room->inorth])) {
               }
               else if (sameto(margv[2],"south")
                && shvutl("the north","south",&qmrooms[playpt->room->isouth])) {
               }
               else if (sameto(margv[2],"east")
                && shvutl("the west","east",&qmrooms[playpt->room->ieast])) {
               }
               else if (sameto(margv[2],"west")
                && shvutl("the east","west",&qmrooms[playpt->room->iwest])) {
               }
               else {
                    prfmsg(HAVHAL,playpt->altid);
                    outothr();
                    prfmsg(NOEXIT,margv[2]);
                    outprf(usrnum);
               }
          }
          else {
               prfmsg(SSEEIN,playpt->altid);
               outothr();
               prfmsg(SNOTHR,margv[1]);
               outprf(usrnum);
          }
     }
     else {
          prfmsg(MEDEMR,playpt->altid);
          outothr();
          xmunum(SEEDOC);
     }
}

int
shvutl(from,to,entrp)
char *from,*to;
struct room *entrp;
{
     if (entrp != NOROOM) {
          prfmsg(CAUGHT,othppt->plyrid);
          outprf(usrnum);
          qmxitroom(othppt,spr("been shoved %s",to));
          prfmsg(SHOVUS,playpt->altid,to);
          outprf(othppt->channel);
          qmentroom(othppt,entrp,spr("been shoved from %s",from));
          return(1);
     }
     return(0);
}

void
qmdrprou(void)
{
     struct item *itmptr;

     bagthe();
     qmbagprep();
     if (margc >= 2) {
          if ((itmptr=getpitm(playpt,margv[1])) != NULL) {
               if (playpt->room->nitems >= MXITEM) {
                    putpitm(playpt,itmptr);
                    xmunum(FRCPRV);
                    prfmsg(GRAPAF,playpt->altid);
                    outothr();
               }
               else {
                    putritm(playpt->room,itmptr);
                    xmunum(UDROPT);
                    prfmsg(SDROPS,playpt->altid,
                         aoran(itmptr->name),(char *)(playpt->room->objloc));
                    outothr();
               }
          }
          else {
               xmunum(NICEID);
               prfmsg(ACTODD,playpt->altid);
               outothr();
          }
     }
     else {
          xmunum(NVRKNU);
          prfmsg(LILQUR,playpt->altid);
          outothr();
     }
}

void
wnkrou(void)
{
     qmbagprep();
     bagthe();
     if (margc == 1) {
          prfmsg(QMINT107);
          outprf(usrnum);
          prfmsg(WINKGR,playpt->altid);
          outothr();
     }
     else if ((othppt=qmfndplyr(margv[1])) != NULL) {
          xmunum(UWINKS);
          prfmsg(WINKSL,playpt->altid);
          outprf(othppt->channel);
          prfmsg(WINKSS,playpt->altid,othppt->altid);
          outevbt(othppt);
     }
     else {
          xmunum(UFLBLU);
          prfmsg(FLBLUE,playpt->altid);
          outothr();
     }
}

void
glrrou(void)
{
     qmbagprep();
     bagthe();
     if (margc == 1) {
          xmunum(WHATUA);
          prfmsg(GLARAN,playpt->altid);
          outothr();
     }
     else if ((othppt=qmfndplyr(margv[1])) != NULL) {
          xmunum(ULKSOA);
          prfmsg(GLARUR,playpt->altid);
          outprf(othppt->channel);
          prfmsg(GLARSA,playpt->altid,othppt->altid);
          outevbt(othppt);
     }
     else {
          xmunum(EYEBRN);
          prfmsg(AGLINT,playpt->altid);
          outothr();
     }
}


