/***************************************************************************
 *                                                                         *
 *     QUEST FOR MAGIC Version 3.0                                         *
 *                                                                         *
 *     Copyright (C) 1986-1992 GALACTICOMM, Inc.    All Rights Reserved.   *
 *                                                                         *
 ***************************************************************************
 * GALACTICOMM Software License Agreement                                  *
 *                                                                         *
 * GALACTICOMM, Inc., grants you a fully paid, perpetual, worldwide,       *
 * non-exclusive license to use, transfer, share, modify, delete, and      *
 * incorporate this Software into products copyrighted, patented,          *
 * subject to trade secret or other intellectual protection rights         *
 * asserted by you.                                                        *
 *                                                                         *
 * This Software is provided "as is", without warranty of any kind,        *
 * either expressed or implied, including, but not limited to, the implied *
 * warranties of merchantability and fitness for a particular purpose.     *
 *                                                                         *
 * This license is effective as long as this declaration is preserved in   *
 * its entirety in this Software and any copies or derivatives.            *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *     QMROOMS.C                                                           *
 *     Quest for Magic Array of Rooms                                      *
 *                                                                         *
 *     By - Scott Brinker and Tim Stryker      11/21/86                    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "qm.h"
#include "galqm.h"

struct room qmrooms[200]={

     {"in a large welcome hall",              /*  Room 000                  */
     QM0001,
     "on the marble floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     2,4,10,1},

     {"in a small chapel",              /*  Room 001  */
     QM0002,
     "lying near the altar",
     chprou,
     MAGIC+GOOD,
     NULL,
     1,
     {2,255,255,255,255,255},
     11,255,0,255},

     {"in a short corridor",              /*  Room 002     */
     QM0003,
     "lying in the mud",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     3,0,255,255},

     {"in the mud-filled chamber",              /*  Room 003      */
     QM0004,
     "lying in the mud",
     inulrou,
     EVIL,
     NULL,
     0,
     {255,255,255,255,255,255},
     108,2,106,32},

     {"in the North Grand Hall",              /*  Room 004       */
     QM0005,
     "on the marble floor",
     nghrou,
     MAGIC,
     NULL,
     0,
     {255,255,255,255,255,255},
     0,5,255,255},

     {"in the South Grand Hall",              /*  Room 005        */
     QM0006,
     "lying on the marble floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     4,6,255,255},

     {"in the Triangular Room",              /*  Room 006       */
     QM0007,
     "lying on the marble floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     5,7,8,9},

     {"in the Mystical Ante-Chamber",         /*  Room 007       */
     QM0008,
     "lying in the mist",
     wotrou,
     MAGIC,
     NULL,
     1,
     {4,255,255,255,255,255},
     6,255,255,255},

     {"in the rubble-filled Room",            /*  Room 008       */
     QM0009,
     "lying in the rubble",
     inulrou,
     0,
     NULL,
     1,
     {0,255,255,255,255,255},
     255,255,33,6},

     {"standing on the marble walkway",       /*  Room 009       */
     QM0031,
     "on the marble walkway",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,255,6,13},

     {"near the sacrificial altar",          /*  Room 010       */
     QM0030,
     "near the altar",
     inulrou,
     0,
     NULL,
     1,
     {9,255,255,255,255,255},
     255,255,255,0},

     {"in the abandoned priest's chamber",   /*  Room 011       */
     QM0032,
     "lying on the cold stone",
     inulrou,
     0,
     NULL,
     1,
     {1,255,255,255,255,255},
     255,1,255,12},

     {"near the small shrine",             /*  Room 012       */
     QM0033,
     "near the shrine",
     inulrou,
     GOOD,
     NULL,
     2,
     {2,8,255,255,255,255},
     255,255,11,255},

     {"in the Hall of Pillars",          /*  Room 013       */
     QM0024,
     "lying near the pillars",
     inulrou,
     0,
     NULL,
     1,
     {2,255,255,255,255,255},
     14,22,9,21},

     {"in the Room of the Pyramid",          /*  Room 014       */
     QM0023,
     "lying near the pyramid",
     pyrrou,
     MAGIC,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,13,255,255},

     {"in the ante-chamber of the pyramid",  /*  Room 015       */
     QM0034,
     "lying in the dust",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     18,255,255,255},

     {"in the vertex of the pyramid",        /*  Room 016       */
     QM0035,
     "lying on the stone out-cropping",
     inulrou,
     0,
     NULL,
     1,
     {1,255,255,255,255,255},
     255,255,255,255},

     {"in the Northen Chamber of the Pyramid", /*  Room 017       */
     QM0036,
     "lying on the cold stone",
     nplrou,
     MAGIC,
     NULL,
     1,
     {19,255,255,255,255,255},
     255,18,255,255},

     {"in the Burial Chamber of the Pyramid",  /*  Room 018       */
     QM0037,
     "lying near the crypt",
     cpsrou,
     MAGIC,
     NULL,
     1,
     {11,255,255,255,255,255},
     17,15,19,20},

     {"in the Eastern Chamber of the Pyramid", /*  Room 019       */
     QM0038,
     "lying on the cold stone",
     eplrou,
     MAGIC,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,255,255,18},

     {"in the Western Chamber of the Pyramid", /*  Room 020       */
     QM0039,
     "lying on the cold stone",
     wplrou,
     MAGIC,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,255,18,255},

     {"in the Room of the Orb",              /*  Room 021       */
     QM0025,
     "lying near the orb",
     orbrou,
     MAGIC,
     NULL,
     0,
     {255,255,255,255,255,255},
     30,255,13,255},

     {"in the Strange Cubicle",          /*  Room 022       */
     QM0040,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     13,23,255,255},

     {"in the Hall of Echos",            /*  Room 023       */
     QM0041,
     "lying on the black floor",
     echorou,
     MAGIC,
     NULL,
     1,
     {2,255,255,255,255,255},
     22,24,255,255},

     {"in a long passageway",            /*  Room 024       */
     QM0042,
     "lying on the damp stone",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     23,25,255,255},

     {"in the Alchemical Laboratory",        /*  Room 025       */
     QM0043,
     "lying on the floor",
     inulrou,
     MAGIC,
     NULL,
     1,
     {0,255,255,255,255,255},
     24,26,28,27},

     {"in the Hall of Wizardry",            /*  Room 026       */
     QM0028,
     "lying on the floor",
     inulrou,
     MAGIC,
     NULL,
     0,
     {255,255,255,255,255,255},
     25,29,255,255},

     {"in a strange Cone Room",             /*  Room 027       */
     QM0044,
     "lying on the floor",
     inulrou,
     MAGIC,
     NULL,
     1,
     {9,255,255,255,255,255},
     255,255,25,255},

     {"in an ancient forge",               /*  Room 028       */
     QM0045,
     "lying on the floor",
     frgrou,
     MAGIC,
     NULL,
     1,
     {1,255,255,255,255,255},
     255,255,255,25},

     {"in the Hall of Stars",               /*  Room 029       */
     QM0046,
     "lying on the floor",
     inulrou,
     MAGIC,
     NULL,
     1,
     {4,255,255,255,255,255},
     26,255,255,255},

     {"in a damp stone passageway",         /*  Room 030       */
     QM0047,
     "lying on the damp stone",
     inulrou,
     0,
     NULL,
     1,
     {7,255,255,255,255,255},
     255,21,255,31},

     {"in a square room",               /*  Room 031       */
     QM0048,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {4,255,255,255,255,255},
     255,255,30,255},

     {"near some ancient ruins",            /*  Room 032       */
     QM0049,
     "lying amongst the ruins",
     inulrou,
     MAGIC,
     NULL,
     1,
     {9,255,255,255,255,255},
     255,255,3,255},

     {"in a twisty cave",              /*  Room 033                  */
     QM0010,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,43,34,8},

     {"in a twisty cave",              /*  Room 034                  */
     QM0017,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {1,255,255,255,255,255},
     90,44,35,33},

     {"in a twisty cave",              /*  Room 035                  */
     QM0020,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     91,53,255,34},

     {"in a twisty cave",              /*  Room 036                  */
     QM0015,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {2,255,255,255,255,255},
     91,45,37,255},

     {"in a twisty cave",              /*  Room 037                  */
     QM0017,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     92,46,38,36},

     {"in a twisty cave",              /*  Room 038                  */
     QM0017,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     93,57,39,37},

     {"in a twisty cave",              /*  Room 039                  */
     QM0016,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     100,255,40,38},

     {"in a twisty cave",              /*  Room 040                  */
     QM0017,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {6,255,255,255,255,255},
     94,48,41,39},

     {"in a twisty cave",              /*  Room 041                  */
     QM0020,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     102,49,255,40},

     {"in a twisty cave",              /*  Room 042                  */
     QM0055,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,50,43,255},

     {"in a twisty cave",              /*  Room 043                  */
     QM0017,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {0,255,255,255,255,255},
     33,51,44,42},

     {"in a twisty cave",              /*  Room 044                  */
     QM0020,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     34,52,255,43},

     {"in a twisty cave",              /*  Room 045                  */
     QM0015,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     36,54,46,255},

     {"in a twisty cave",              /*  Room 046                  */
     QM0020,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     37,55,255,45},

     {"in a twisty cave",              /*  Room 047                  */
     QM0055,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     2,
     {1,2,255,255,255,255},
     255,57,48,255},

     {"in a twisty cave",              /*  Room 048                  */
     QM0017,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     40,66,49,47},

     {"in a twisty cave",              /*  Room 049                  */
     QM0020,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     41,58,255,48},

     {"in a twisty cave",              /*  Room 050                  */
     QM0015,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     42,60,51,255},

     {"in a twisty cave",              /*  Room 051                  */
     QM0017,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {10,255,255,255,255,255},
     43,60,52,50},

     {"in a twisty cave",              /*  Room 052                  */
     QM0017,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     44,61,53,51},

     {"in a twisty cave",              /*  Room 053                  */
     QM0016,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     45,255,54,52},

     {"in a twisty cave",              /*  Room 054                  */
     QM0020,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     45,63,255,53},

     {"in a twisty cave",              /*  Room 055                  */
     QM0015,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {9,255,255,255,255,255},
     46,64,56,255},

     {"in a twisty cave",              /*  Room 056                  */
     QM0013,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,65,57,55},

     {"in a twisty cave",              /*  Room 057                  */
     QM0020,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     47,66,255,56},

     {"in a twisty cave",              /*  Room 058                  */
     QM0051,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     49,68,255,255},

     {"in a twisty cave",              /*  Room 059                  */
     QM0050,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {7,255,255,255,255,255},
     255,69,255,255},

     {"in a twisty cave",              /*  Room 060                  */
     QM0015,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     51,71,61,255},

     {"in a twisty cave",              /*  Room 061                  */
     QM0016,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     52,83,62,60},

     {"in a twisty cave",              /*  Room 062                  */
     QM0053,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,72,255,61},

     {"in a twisty cave",              /*  Room 063                  */
     QM0015,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     54,73,64,255},

     {"in a twisty cave",              /*  Room 064                  */
     QM0017,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {1,255,255,255,255,255},
     55,74,65,63},

     {"in a twisty cave",              /*  Room 065                  */
     QM0020,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     56,75,255,64},

     {"in a twisty cave",              /*  Room 066                  */
     QM0015,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     57,76,67,255},

     {"in a twisty cave",              /*  Room 067                  */
     QM0013,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {2,255,255,255,255,255},
     255,77,68,66},

     {"in a twisty cave",              /*  Room 068                  */
     QM0020,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     58,78,255,67},

     {"in a twisty cave",              /*  Room 069                  */
     QM0015,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     59,79,70,255},

     {"in a twisty cave",              /*  Room 070                  */
     QM0013,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {14,255,255,255,255,255},
     255,80,71,69},

     {"in a twisty cave",              /*  Room 071                  */
     QM0020,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     60,81,255,70},

     {"in a twisty cave",              /*  Room 072                  */
     QM0015,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     62,83,73,255},

     {"in a twisty cave",              /*  Room 073                  */
     QM0017,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     63,84,74,72},

     {"in a twisty cave",              /*  Room 074                  */
     QM0017,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {4,255,255,255,255,255},
     64,85,75,73},

     {"in a twisty cave",              /*  Room 075                  */
     QM0020,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     65,86,255,74},

     {"in a twisty cave",              /*  Room 076                  */
     QM0015,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     66,87,77,255},

     {"in a twisty cave",              /*  Room 077                  */
     QM0016,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     67,255,76,78},

     {"in a twisty cave",              /*  Room 078                  */
     QM0020,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     68,89,255,77},

     {"in a twisty cave",              /*  Room 079                  */
     QM0012,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     69,255,80,255},

     {"in a twisty cave",              /*  Room 080                  */
     QM0011,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {10,255,255,255,255,255},
     70,255,255,79},

     {"in a twisty cave",              /*  Room 081                  */
     QM0012,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     71,255,82,255},

     {"in a twisty cave",              /*  Room 082                  */
     QM0019,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,255,83,81},

     {"in a twisty cave",              /*  Room 083                  */
     QM0011,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     72,255,255,82},

     {"in a twisty cave",              /*  Room 084                  */
     QM0012,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     73,255,85,255},

     {"in a twisty cave",              /*  Room 085                  */
     QM0011,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     74,255,255,84},

     {"in a twisty cave",              /*  Room 086                  */
     QM0012,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     75,255,87,255},

     {"in a twisty cave",              /*  Room 087                  */
     QM0011,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     76,255,255,86},

     {"in a twisty cave",              /*  Room 088                  */
     QM0054,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {2,255,255,255,255,255},
     255,255,89,255},

     {"in a twisty cave",              /*  Room 089                  */
     QM0011,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     78,255,255,88},

     {"in a twisty cave",              /*  Room 090                  */
     QM0051,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     96,34,255,255},

     {"in a twisty cave",              /*  Room 091                  */
     QM0051,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     98,36,255,255},

     {"in a twisty cave",              /*  Room 092                  */
     QM0051,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     99,37,255,255},

     {"in a twisty cave",              /*  Room 093                  */
     QM0051,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {1,255,255,255,255,255},
     100,38,255,255},

     {"in a twisty cave",              /*  Room 094                  */
     QM0051,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     102,40,255,255},

     {"in a twisty cave",              /*  Room 095                  */
     QM0054,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,255,96,255},

     {"in a twisty cave",              /*  Room 096                  */
     QM0013,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,90,97,95},

     {"in a twisty cave",              /*  Room 097                  */
     QM0019,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,255,98,96},

     {"in a twisty cave",              /*  Room 098                  */
     QM0013,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,91,99,97},

     {"in a twisty cave",              /*  Room 099                  */
     QM0053,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,92,255,98},

     {"in a twisty cave",              /*  Room 100                  */
     QM0014,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {9,255,255,255,255,255},
     255,93,101,255},

     {"in a twisty cave",              /*  Room 101                  */
     QM0052,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,255,255,100},

     {"in a twisty cave",              /*  Room 102                  */
     QM0051,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     103,102,255,255},

     {"in a twisty cave",              /*  Room 103                  */
     QM0014,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,102,104,255},

     {"in a twisty cave",              /*  Room 104                  */
     QM0011,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     105,255,255,103},

     {"in a twisty cave",              /*  Room 105                  */
     QM0050,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {6,255,255,255,255,255},
     255,104,255,255},

     {"in a damp cavern",              /*  Room 106                  */
     QM0056,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     107,255,255,3},

     {"in a damp cavern",              /*  Room 107                  */
     QM0057,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     109,106,255,108},

     {"in a damp cavern",              /*  Room 108                  */
     QM0058,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,3,107,255},

     {"in a damp cavern",              /*  Room 109                  */
     QM0059,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,107,255,110},

     {"at the Gateway to Peyennuu",    /*  Room 110                  */
     QM0060,
     "lying on the floor",
     inulrou,
     MAGIC,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,255,109,255},

     {"in the Room of Hidden Magic",   /*  Room 111                  */
     QM0061,
     "lying on the floor",
     inulrou,
     MAGIC,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,255,255,112},

     {"in a large meeting center",   /*  Room 112                  */
     QM0080,
     "lying on the marble floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     121,113,111,255},

     {"in a damp, musty passageway",   /*  Room 113                  */
     QM0079,
     "lying on the damp floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     112,114,255,255},

     {"in the barracks entrance hall",   /*  Room 114                  */
     QM0075,
     "lying on the mouldy floor",
     inulrou,
     0,
     NULL,
     1,
     {1,255,255,255,255,255},
     113,117,115,116},

     {"in the guards barracks",   /*  Room 115                  */
     QM0076,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,255,255,114},

     {"in the officers quarters",   /*  Room 116                  */
     QM0077,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,255,114,255},

     {"in the dungeon entrance hall",   /*  Room 117                */
     QM0071,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     114,120,119,118},

     {"in a dank, musty dungeon cell",   /*  Room 118                  */
     QM0072,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {2,255,255,255,255,255},
     255,255,117,255},

     {"in the ancient torture chamber",   /*  Room 119                  */
     QM0073,
     "lying on the floor",
     inulrou,
     EVIL,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,255,255,117},

     {"in the gaurd watchroom",   /*  Room 120                  */
     QM0074,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {18,255,255,255,255,255},
     117,255,255,255},

     {"in the Hall of Battles",   /*  Room 121                  */
     QM0062,
     "lying near the statues",
     inulrou,
     MAGIC,
     NULL,
     1,
     {11,255,255,255,255,255},
     122,112,255,255},

     {"in the Southern Hall of Feasting",   /*  Room 122                  */
     QM0063,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     123,121,255,255},

     {"in the Northern Hall of Feasting",   /*  Room 123                  */
     QM0064,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     124,122,141,255},

     {"in the Central Hall",   /*  Room 124                  */
     QM0081,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     126,123,125,131},

     {"in the Enchanted Recreation Hall",   /*  Room 125                  */
     QM0065,
     "lying on the floor",
     inulrou,
     MAGIC,
     NULL,
     1,
     {2,255,255,255,255,255},
     255,255,255,124},

     {"in the Hall of Arches",   /*  Room 126                  */
     QM0082,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     127,124,255,255},

     {"in the War Planning Room",   /*  Room 127                  */
     QM0083,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     128,126,255,255},

     {"on the Speaking Platform",   /*  Room 128                  */
     QM0084,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {10,255,255,255,255,255},
     255,127,255,129},

     {"in the Short Hallway",   /*  Room 129                  */
     QM0085,
     "lying on the floor",
     inulrou,
     MAGIC,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,255,128,130},

     {"in the Room of Maps",   /*  Room 130                  */
     QM0078,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {4,255,255,255,255,255},
     255,255,129,255},

     {"in the Eastern Library of the Ancients",   /*  Room 131        */
     QM0066,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,255,124,132},

     {"in the Central Library of the Ancients",   /*  Room 132        */
     QM0067,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     133,134,131,135},

     {"in the Northern Library of the Ancients",   /*  Room 133        */
     QM0068,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {0,255,255,255,255,255},
     255,132,255,255},

     {"in the Southern Library of the Ancients",   /*  Room 134        */
     QM0069,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {7,255,255,255,255,255},
     132,255,255,255},

     {"in the Western Library of the Ancients",   /*  Room 135        */
     QM0070,
     "lying on the floor",
     walrou,
     MAGIC,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,255,132,255},

     {"in a damp stone passageway",   /*  Room 136        */
     QM0086,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,137,255,255},

     {"in a broken stone passagway",   /*  Room 137        */
     QM0087,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {1,255,255,255,255,255},
     136,138,255,255},

     {"in the Chamber of Lost Spells",   /*  Room 138        */
     QM0026,
     "lying on the floor",
     inulrou,
     MAGIC+GOOD+EVIL,
     NULL,
     2,
     {11,4,255,255,255,255},
     137,140,139,255},

     {"in the Odd-shaped Room",   /*  Room 139        */
     QM0089,
     "lying on the floor",
     osrrou,
     MAGIC,
     NULL,
     1,
     {9,255,255,255,255,255},
     255,255,255,138},

     {"in the Hall of Sorcery",   /*  Room 140    */
     QM0088,
     "lying on the floor",
     inulrou,
     MAGIC,
     NULL,
     2,
     {12,18,255,255,255,255},
     138,255,255,255},

     {"in the Central Kitchen",   /*  Room 141        */
     QM0090,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,142,143,123},

     {"in the Pantry",   /*  Room 142        */
     QM0105,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {18,255,255,255,255,255},
     141,255,255,255},

     {"in a long stone passageway",   /*  Room 143        */
     QM0091,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,255,144,141},

     {"in the servants quarters",   /*  Room 144        */
     QM0092,
     "lying on the floor",
     inulrou,
     0,
     NULL,
     1,
     {2,255,255,255,255,255},
     255,255,145,143},

     {"near the abandoned mine entrance",   /*  Room 145        */
     QM0093,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     146,255,255,144},

     {"in a dark, damp tunnel",   /*  Room 146        */
     QM0094,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,145,148,147},

     {"in a dark, damp tunnel",   /*  Room 147        */
     QM0095,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     1,
     {9,255,255,255,255,255},
     149,255,146,255},

     {"in a dark, damp tunnel",   /*  Room 148        */
     QM0096,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     159,255,255,146},

     {"in a dark, damp tunnel",   /*  Room 149        */
     QM0097,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     1,
     {1,255,255,255,255,255},
     160,147,150,255},

     {"in a dark, damp tunnel",   /*  Room 150        */
     QM0096,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     161,255,255,149},

     {"in a dark, damp tunnel",   /*  Room 151        */
     QM0095,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     158,255,152,255},

     {"in a dark, damp tunnel",   /*  Room 152        */
     QM0098,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     1,
     {7,255,255,255,255,255},
     154,255,153,151},

     {"in a dark, damp tunnel",   /*  Room 153        */
     QM0098,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     155,255,155,152},

     {"in a dark, damp tunnel",   /*  Room 154        */
     QM0099,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     164,152,156,158},

     {"in a dark, damp tunnel",   /*  Room 155        */
     QM0096,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     1,
     {9,255,255,255,255,255},
     156,255,255,153},

     {"in a dark, damp tunnel",   /*  Room 156        */
     QM0100,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     157,155,255,154},

     {"in a dark, damp tunnel",   /*  Room 157        */
     QM0101,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     1,
     {0,255,255,255,255,255},
     255,156,255,165},

     {"in a dark, damp tunnel",   /*  Room 158        */
     QM0103,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,151,154,159},

     {"in a dark, damp tunnel",   /*  Room 159        */
     QM0102,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,148,158,255},

     {"in a dark, damp tunnel",   /*  Room 160        */
     QM0102,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     1,
     {6,255,255,255,255,255},
     255,149,161,255},

     {"in a dark, damp tunnel",   /*  Room 161        */
     QM0100,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     170,150,255,160},

     {"in a dark, damp tunnel",   /*  Room 162        */
     QM0095,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     170,255,163,255},

     {"in a dark, damp tunnel",   /*  Room 163        */
     QM0098,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     1,
     {10,255,255,255,255,255},
     168,255,164,162},

     {"in a dark, damp tunnel",   /*  Room 164        */
     QM0100,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     166,154,255,163},

     {"in a dark, damp tunnel",   /*  Room 165        */
     QM0102,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,156,157,255},

     {"in a dark, damp tunnel",   /*  Room 166        */
     QM0104,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     167,164,255,255},

     {"in a dark, damp tunnel",   /*  Room 167        */
     QM0101,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     1,
     {1,255,255,255,255,255},
     255,166,255,168},

     {"in a dark, damp tunnel",   /*  Room 168        */
     QM0099,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     171,163,167,169},

     {"in a dark, damp tunnel",   /*  Room 169        */
     QM0102,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,170,168,255},

     {"in a dark, damp tunnel",   /*  Room 170        */
     QM0097,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     1,
     {13,255,255,255,255,255},
     169,162,163,255},

     {"in dense underground forest",   /*  Room 171        */
     QM0106,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     177,168,173,172},

     {"in dense underground forest",   /*  Room 172        */
     QM0107,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     1,
     {9,255,255,255,255,255},
     178,255,171,255},

     {"in dense underground forest",   /*  Room 173        */
     QM0108,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     176,255,174,171},

     {"in dense underground forest",   /*  Room 174        */
     QM0109,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     1,
     {10,255,255,255,255,255},
     175,255,255,173},

     {"in dense underground forest",    /*  Room 175        */
     QM0110,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     182,174,255,176},

     {"in dense underground forest",    /*  Room 176        */
     QM0111,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     181,173,175,177},

     {"in dense underground forest",    /*  Room 177        */
     QM0111,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     180,171,176,178},

     {"in dense underground forest",    /*  Room 178        */
     QM0112,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     1,
     {2,255,255,255,255,255},
     179,172,177,255},

     {"in dense underground forest",   /*  Room 179        */
     QM0112,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     186,178,180,255},

     {"in dense underground forest",    /*  Room 180        */
     QM0111,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     1,
     {1,255,255,255,255,255},
     185,177,181,179},

     {"in dense underground forest",    /*  Room 181        */
     QM0111,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     184,176,182,180},

     {"in dense underground forest",    /*  Room 182        */
     QM0110,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     183,175,255,181},

     {"near a sparkling waterfall",   /*  Room 183        */
     QM0022,
     "floating, magically, in the pool",
     luvrou,
     GOOD,
     NULL,
     3,
     {6,14,10,255,255,255},
     255,182,255,184},

     {"in dense underground forest",    /*  Room 184        */
     QM0114,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     1,
     {9,255,255,255,255,255},
     255,181,183,185},

     {"in dense underground forest",    /*  Room 185        */
     QM0114,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,180,184,186},

     {"in dense underground forest",    /*  Room 186        */
     QM0115,
     "lying in the dirt",
     inulrou,
     0,
     NULL,
     2,
     {0,15,255,255,255,255},
     255,179,185,255},

     {"at the Shrine of Hearts",    /*  Room 187        */
     QM0117,
     "lying near the statue",
     sohrou,
     MAGIC+GOOD,
     NULL,
     4,
     {12,8,10,7,255,255},
     255,188,255,183},

     {"in dark crack in a cavern",    /*  Room 188        */
     QM0122,
     "lying in the dark",
     inulrou,
     0,
     NULL,
     1,
     {1,255,255,255,255,255},
     187,255,255,166},

     {"at the Pool of Kyrannalussi",    /*  Room 189        */
     QM0120,
     "lying near the water",
     pokrou,
     MAGIC,
     NULL,
     2,
     {17,19,255,255,255,255},
     197,255,255,255},

     {"in the Chamber of Shadows",    /*  Room 190        */
     QM0118,
     "lying in the dirt",
     qmrosrou,
     0,
     NULL,
     1,
     {11,255,255,255,255,255},
     255,255,197,194},

     {"in the Room of Visions",      /*  Room 191        */
     QM0119,
     "lying in the dirt",
     hovrou,
     MAGIC,
     NULL,
     1,
     {6,255,255,255,255,255},
     255,255,255,197},

     {"in the Hall of Kings",    /*  Room 192        */
     QM0125,
     "lying in the dirt",
     hokrou,
     MAGIC,
     NULL,
     2,
     {7,5,255,255,255,255},
     255,197,255,255},

     {"in the Chamber of the Portal",    /*  Room 193        */
     QM0121,
     "lying in the dirt",
     coprou,
     MAGIC,
     NULL,
     2,
     {11,5,255,255,255,255},
     255,195,255,255},

     {"in the Hall of Astrology",    /*  Room 194        */
     QM0123,
     "lying in the dirt",
     inulrou,
     MAGIC,
     NULL,
     2,
     {18,13,255,255,255,255},
     255,255,190,255},

     {"in the Hall of Summoning",    /*  Room 195        */
     QM0124,
     "lying in the dirt",
     sumhall,
     MAGIC,
     NULL,
     2,
     {15,4,255,255,255,255},
     193,255,255,255},

     {"in the Winner's Hall",    /*  Room 196       */
     QM0200,
     "lying in the mist",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     255,255,255,255},

     {"in the Wizard's Forum",    /*  Room 197       */
     QM0201,
     "lying in the mist",
     inulrou,
     MAGIC,
     NULL,
     2,
     {22,18,255,255,255,255},
     192,189,191,190},

     {"in the Chamber of Hidden Lore",    /*  Room 198      */
     QM0202,
     "lying in the mist",
     chlrou,
     MAGIC,
     NULL,
     1,
     {17,255,255,255,255,255},
     255,255,255,255},

     {"in the netherworld",    /*  Room 199      */
     QM0203,
     "lying in the mist",
     inulrou,
     0,
     NULL,
     0,
     {255,255,255,255,255,255},
     199,199,199,199}
};


