/***************************************************************************
 *                                                                         *
 *     QUEST FOR MAGIC Version 3.0                                         *
 *                                                                         *
 *     Copyright (C) 1986-1992 GALACTICOMM, Inc.    All Rights Reserved.   *
 *                                                                         *
 ***************************************************************************
 * GALACTICOMM Software License Agreement                                  *
 *                                                                         *
 * GALACTICOMM, Inc., grants you a fully paid, perpetual, worldwide,       *
 * non-exclusive license to use, transfer, share, modify, delete, and      *
 * incorporate this Software into products copyrighted, patented,          *
 * subject to trade secret or other intellectual protection rights         *
 * asserted by you.                                                        *
 *                                                                         *
 * This Software is provided "as is", without warranty of any kind,        *
 * either expressed or implied, including, but not limited to, the implied *
 * warranties of merchantability and fitness for a particular purpose.     *
 *                                                                         *
 * This license is effective as long as this declaration is preserved in   *
 * its entirety in this Software and any copies or derivatives.            *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *     QMIROUS.C                                                           *
 *     Quest for Magic Command List and Handler                            *
 *                                                                         *
 *     By - Scott Brinker and Tim Stryker      11/21/86                    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "qm.h"
#include "galqm.h"

void
rubrou(void)
{
     struct item *itmptr;

     bagthe();
     if (margc < 2) {
          prfmsg(QMIRO100);
          outprf(usrnum);
          prfmsg(QMIRO101,playpt->altid);
          outothr();
     }
     else if ((itmptr=getpitm(playpt,margv[1])) == NULL) {
          prfmsg(QMIRO102,
               aoran(margv[1]));
          outprf(usrnum);
          prfmsg(QMIRO103,playpt->altid);
          outothr();
     }
     else {
          putpitm(playpt,itmptr);
          if (!(itmptr->flags&RUBABL)) {
               becute();
          }
          else {
               (*(itmptr->rubcmd))();
          }
     }
}

void
thkrou(void)
{
     struct item *itmptr;

     bagthe();
     qmbagprep();
     if (margc < 2) {
          prfmsg(QMIRO104,namize(margv[0]));
          outprf(usrnum);
          prfmsg(QMIRO105,playpt->altid,margv[0]);
          outothr();
     }
     else if ((itmptr=locitm(margv[1])) == NULL) {
          prfmsg(QMIRO106);
          outprf(usrnum);
          prfmsg(QMIRO107,playpt->altid);
          outothr();
     }
     else if (!(itmptr->flags&THKABL)) {
          prfmsg(QMIRO108,itmptr->name);
          outprf(usrnum);
          prfmsg(QMIRO109,
                 playpt->altid);
          outothr();
     }
     else {
          (*(itmptr->thkcmd))();
     }
}

void
aimrou(void)
{
     struct item *itmptr;

     bagthe();
     qmbagprep();
     if (margc < 2) {
          prfmsg(QMIRO110,namize(margv[0]));
          outprf(usrnum);
          prfmsg(QMIRO111,playpt->altid);
          outothr();
     }
     else if ((itmptr=locitm(margv[1])) == NULL) {
          prfmsg(QMIRO112,aoran(margv[1]));
          outprf(usrnum);
          prfmsg(QMIRO113,playpt->altid);
          outothr();
     }
     else if (!(itmptr->flags&AIMABL)) {
          prfmsg(QMIRO114);
          outprf(usrnum);
          prfmsg(QMIRO115,
               playpt->altid,playpt->hisher,itmptr->name);
          outothr();
     }
     else {
          (*(itmptr->aimcmd))();
     }
}

void
ringin(void)
{
     if (playpt->invtimer > 0) {
          prfmsg(QMIRO116);
          outprf(usrnum);
          prfmsg(QMIRO117,playpt->altid);
          outothr();
     }
     else {
          prfmsg(UGOINV1);
          outprf(usrnum);
          prfmsg(GOINV1,playpt->altid);
          outothr();
          playpt->invtimer=60;
          playpt->aura|=INVIS1;
          strcpy(playpt->altid,"Some invisible presence");
          strcpy(playpt->hisher,"its");
     }
}

void
amltlp(void)
{
     if (playpt->prttimer >0) {
          prfmsg(QMIRO118);
          outprf(usrnum);
          prfmsg(QMIRO119,playpt->altid);
          outothr();
     }
     else {
          prfmsg(UGTALP);
          outprf(usrnum);
          prfmsg(OGTALP,playpt->altid);
          outothr();
          playpt->prttimer=60;
          playpt->aura|=LIGPRO;
     }
}

void
coloring(void)
{
     prfmsg(COLRIN);
     outprf(usrnum);
     prfmsg(COLRINO,playpt->altid);
     outothr();
}

void
teleorb(void)
{
     prfmsg(ORBTLPT);
     outprf(usrnum);
     qmxitroom(playpt,rawmsg(QMIRO205));
     qmentroom(playpt,&qmrooms[21],rawmsg(QMIRO200));
}

void
amltip(void)
{
     if (playpt->prttimer >0) {
          prfmsg(QMIRO120);
          outprf(usrnum);
          prfmsg(QMIRO121,playpt->altid);
          outothr();
     }
     else {
          prfmsg(UGTALP);
          outprf(usrnum);
          prfmsg(OGTALP,playpt->altid);
          outothr();
          playpt->prttimer=60;
          playpt->aura|=ICEPRO;
     }
}

void
prytele(void)
{
     prfmsg(PRYTLPT);
     outprf(usrnum);
     qmxitroom(playpt,rawmsg(QMIRO206));
     qmentroom(playpt,&qmrooms[12],rawmsg(QMIRO201));
}

void
aimwan(void)
{
     if (margc < 3) {
          prfmsg(QMIRO122);
          outprf(usrnum);
          prfmsg(QMIRO123,playpt->altid,playpt->hisher);
          outothr();
     }
     else if ((othppt=qmfndplyr(margv[2])) != NULL) {
          prfmsg(QMIRO124,playpt->altid,playpt->hisher);
          outothr();
          if (othppt->aura&FIRPRO) {
               prfmsg(FIRPRTC,othppt->plyrid);
               outprf(usrnum);
               prfmsg(FPROTH,playpt->altid,othppt->altid);
               outevbt(othppt);
               prfmsg(FPROOP,playpt->altid);
               outprf(othppt->channel);
          }
          else {
               prfmsg(FIRWND);
               outprf(usrnum);
               prfmsg(FRWNDP,playpt->altid,playpt->hisher,playpt->altid);
               outprf(othppt->channel);
               prfmsg(FRWNDO,playpt->altid,playpt->hisher,
                   playpt->altid,othppt->altid);
               outevbt(othppt);
               bamoth(10);
          }
     }
     else {
          prfmsg(QMIRO125);
          outprf(usrnum);
          prfmsg(QMIRO126,playpt->altid,playpt->hisher);
          outothr();
     }
}

void
locket(void)
{
     prfmsg(LCKTLPT);
     outprf(usrnum);
     qmxitroom(playpt,rawmsg(QMIRO207));
     qmentroom(playpt,&qmrooms[187],rawmsg(QMIRO202));
}

void
rubstf(void)
{
     prfmsg(TELESTF);
     outprf(usrnum);
     qmxitroom(playpt,rawmsg(QMIRO208));
     qmentroom(playpt,&qmrooms[140],rawmsg(QMIRO203));
}

void
medall(void)
{
     if (playpt->prttimer >0) {
          prfmsg(QMIRO127);
          outprf(usrnum);
          prfmsg(QMIRO128,playpt->altid);
          outothr();
     }
     else {
          prfmsg(UGTMDP);
          outprf(usrnum);
          prfmsg(OGTMDP,playpt->altid);
          outothr();
          playpt->prttimer=90;
          playpt->aura|=LIGPRO;
          playpt->aura|=FIRPRO;
     }
}

void
thkstf(void)
{
     if (playpt->prttimer > 0) {
          prfmsg(QMIRO129);
          outprf(usrnum);
          prfmsg(QMIRO130,playpt->altid);
          outothr();
     }
     else {
          prfmsg(UGTSTP);
          outprf(usrnum);
          prfmsg(OGTSTP,playpt->altid);
          outothr();
          playpt->prttimer=200;
          playpt->aura|=LIGPRO;
          playpt->aura|=FIRPRO;
          playpt->aura|=ICEPRO;
          playpt->aura|=MAGPRO;
          playpt->aura|=CURPRO;
          playpt->aura|=STLPRO;
          playpt->aura|=SCRPRO;
     }
}

void
penden(void)
{
     if (playpt->prttimer >0) {
          prfmsg(QMIRO131);
          outprf(usrnum);
          prfmsg(QMIRO132,playpt->altid);
          outothr();
     }
     else {
          prfmsg(PENSEY);
          outprf(usrnum);
          prfmsg(PENSEO,playpt->altid);
          outothr();
          playpt->pwrtimer=120;
          playpt->aura|=SEEIN1;
     }
}

void
charm(void)
{
     if (playpt->prttimer >0) {
          prfmsg(QMIRO133);
          outprf(usrnum);
          prfmsg(QMIRO134,playpt->altid);
          outothr();
     }
     else {
          prfmsg(UGTCHP);
          outprf(usrnum);
          prfmsg(OGTCHP,playpt->altid);
          outothr();
          playpt->prttimer=95;
          playpt->aura|=SCRPRO;
          playpt->aura|=STLPRO;
     }
}

void
rodrub(void)
{
     prfmsg(TELEROD);
     outprf(usrnum);
     qmxitroom(playpt,rawmsg(QMIRO209));
     qmentroom(playpt,&qmrooms[197],rawmsg(QMIRO204));
}

void
thkrod(void)
{
     if (playpt->prttimer >0) {
          prfmsg(QMIRO135);
          outprf(usrnum);
          prfmsg(QMIRO136,playpt->altid);
          outothr();
     }
     else {
          prfmsg(UGTRDP);
          outprf(usrnum);
          prfmsg(OGTRDP,playpt->altid);
          outothr();
          playpt->prttimer=110;
          playpt->aura|=SCRPRO;
          playpt->aura|=MAGPRO;
     }
}
