/***************************************************************************
 *                                                                         *
 *     QUEST FOR MAGIC Version 3.0                                         *
 *                                                                         *
 *     Copyright (C) 1986-1992 GALACTICOMM, Inc.    All Rights Reserved.   *
 *                                                                         *
 ***************************************************************************
 * GALACTICOMM Software License Agreement                                  *
 *                                                                         *
 * GALACTICOMM, Inc., grants you a fully paid, perpetual, worldwide,       *
 * non-exclusive license to use, transfer, share, modify, delete, and      *
 * incorporate this Software into products copyrighted, patented,          *
 * subject to trade secret or other intellectual protection rights         *
 * asserted by you.                                                        *
 *                                                                         *
 * This Software is provided "as is", without warranty of any kind,        *
 * either expressed or implied, including, but not limited to, the implied *
 * warranties of merchantability and fitness for a particular purpose.     *
 *                                                                         *
 * This license is effective as long as this declaration is preserved in   *
 * its entirety in this Software and any copies or derivatives.            *
 *                                                                         *
 ***************************************************************************
 *                                                                         *
 *     QM.H                                                                *
 *     Quest for Magic Header Definitions File                             *
 *                                                                         *
 *     By - Scott Brinker and Tim Stryker      11/17/86                    *
 *                                                                         *
 ***************************************************************************/

#define MXITEM  6                       /*  Maximum number of items           */
#define PIDSIZ  10                      /*  size of player ID storage area    */
#define AIDSIZ  30                      /*  size of alt player ID storage area*/
#define SEXID   4                       /*  size of his/her identifier        */

#define NROOMS  199                     /*  number of rooms in dungeon        */
#define NOROOM  (&qmrooms[255])         /*  pointer to no room at all         */

struct arrent {
     char *command;
     void (*routine)();
     int liveuse;
};

struct room {                           /***  Dungeon rooms                     */
     char *brdesc;                      /*  Brief room description            */
     int  desc;                         /*  Complete room description         */
     char *objloc;                      /*  Object location description       */
     int (*rmcmd)();                    /*  Commands routines for room        */
     int  aura;                         /*  Rooms "aura" flags                */
     struct qmplayer *roomhdr;          /*  linked list hdr of players in room*/
     int nitems;                        /*  number of items in rooms right now*/
     char iitems[MXITEM];               /*  Items in room                     */
     char inorth;                       /*  Room to north                     */
     char isouth;                       /*  Room to south                     */
     char ieast;                        /*  Room to east                      */
     char iwest;                        /*  Room to west                      */
};


#define MAGIC   1                       /*  Room gives magical aura           */
#define EVIL    2                       /*  Evil aura in room                 */
#define GOOD    4                       /*  Good aura in room                 */


struct qmplayer {                       /***  Player structure                */
     char userid[UIDSIZ];               /*  Play's user-id for rest of system */
     char plyrid[PIDSIZ];               /*  Player's name                     */
     char altid[AIDSIZ];                /*  Player's alternate name           */
     struct qmplayer *plink;            /*  forward-link in room linked list  */
     int  channel;                      /*  channel this player is on         */
     int  flags;                        /*  Player's game-control flags       */
     int  descrpt;                      /*  Player's description              */
     char hisher[4];                    /*  "his" or "her" (or "its")         */
     struct room *room;                 /*  Player's current room             */
     int  hits;                         /*  Player's hit points               */
     int  maxhit;                       /*  player's max hit count            */
     int  spluse;                       /*  Seconds to go before can spell agn*/
     int  invtimer;                     /*  Seconds to go before visible again*/
     int  crstimer;                     /*  Seconds to go before curse gone   */
     int  prttimer;                     /*  Seconds to go b4 protection gone  */
     int  pwrtimer;                     /*  Seconds to go b4 super-power gone */
     int  nitems;                       /*  Number of items held by player    */
     struct item *items[MXITEM];        /*  Player's items being held         */
     long aura;                         /*  Player's "aura"                   */
     char spare[252-132];               /*  spare space, decrease when adding */
};
                                        /* "flags" bit definitions            */
#define BRIEF 1                         /*   brief room description mode      */
#define INQM  2                         /*   player is playing QM             */
#define ONSYS 4                         /*   player has been in game this ses.*/
#define SYSOP 8                         /*   player status set to SysOp       */
#define DESC1 16                        /*   player description = normal      */
#define DESC2 32                        /*   player description = ragged      */
#define DESC3 64                        /*   player description = powerful    */
#define DESC4 128                       /*   player description = wise        */
#define DESC5 256                       /*   player description = blessed     */
#define DESC6 512                       /*   player description = greedy      */
#define DESC7 1024                      /*   player description = charming    */
#define DESC8 2048                      /*   player description = SysOp       */

                                        /* "aura" bit definitions             */
#define WTRUTH 0x00000001L              /* player has spoken "word of truth"  */
#define SEEIN1 0x00000002L              /* can see invisible flavor 1's       */
#define INVIS1 0x00000004L              /* invisibility-flavor 1 is active    */
#define SEEOBJ 0x00000008L              /* can see objects normally no sweat  */
#define SEEPYR 0x00000010L              /* can see players normally no sweat  */
#define FIRPRO 0x00000020L              /* protection from fire activated     */
#define ICEPRO 0x00000040L              /* protection from ice/cold activated */
#define LIGPRO 0x00000080L              /* protection from lightning activated*/
#define MAGPRO 0x00000100L              /* protection from magic activated    */
#define CURPRO 0x00000200L              /* protection from curses activated   */
#define INVIS2 0x00000400L              /* invisibility-flavor 2 is active    */
#define INVIS3 0x00000800L              /* invisibility-flavor 3 is active    */
#define SEEIN2 0x00001000L              /* can see invisible flavor 2's       */
#define PICOBJ 0x00002000L              /* can pick up objects no sweat       */
#define MARIED 0x00004000L              /* play "marriage bit" set            */
#define VIRTU1 0x00008000L              /* player virtue of patience          */
#define VIRTU2 0x00010000L              /* player virtue of wisdom            */
#define VIRTU3 0x00020000L              /* player virtue of faith             */
#define SCRPRO 0x00040000L              /* protection from being scryed       */
#define STLPRO 0x00080000L              /* protection from being robbed       */
#define BLESSD 0x00100000L
#define GOODBY 0x00200000L

struct item {                           /***  Item structure                  */
     char *name;                        /*  Item name                         */
     int  descip;                       /*  Item description                  */
     void (*rubcmd)();                  /*  Commands routines for rubbing     */
     void (*aimcmd)();                  /*  Commands routines for aiming      */
     void (*thkcmd)();                  /*  Commands routines for thinking on */
     int  flags;                        /*  Item bit 'flags'                  */
};
                                        /* "flags" bit definitions           */
#define PICKUP  1                       /*   item can be picked up           */
#define SURVIV  2                       /*   item can survive player's death */
#define EATITM  4                       /*   item can be eaten               */
#define DRKITM  8                       /*   item can be drunk/swallowed     */
#define USEAN   16                      /*   item name starts with a vowel   */
#define RUBABL  32                      /*   item activated by rubbing       */
#define THKABL  64                      /*   item activated by thinking of it*/
#define AIMABL  128                     /*   item activated by aiming it     */

extern
struct qmplayer *qmplayer,       /* main player data array of structures      */
                *playpt;         /* ptr to current player's player data       */
extern
struct qmplayer *othppt;         /* ptr to current player's player data       */

extern
struct item qmitems[];
extern
struct room qmrooms[];

/* QM.C 03/03/92 16.43.14 */
void EXPORT init__questfm(void);
int magicq(void);
void inipyr(int usrnum,char *plyrid);
void qmhup(void);
void prep4d(void);
void rest4p(void);
void qmdela(char *userid);
void qmsdn(void);
/* QMCMDS.C 03/03/92 16.49.54 */
struct arrent *qmbinary(char *stgptr,struct arrent table[],int length);
void decode(void);
unsigned rnd(void);
/* QMINTER.C 03/03/92 16.55.32 */
void qmsayrou(void);
void qmwhsrou(void);
void yelrou(void);
void moving(void);
void nasty(void);
void becute(void);
void qmbemean(void);
void cumnut(char *stg1, char *stg2, char *stg3, char *stg4, char *stg5);
void givrou(void);
void givutl(char *givee, char *givwhat);
void qmgetrou(void);
void getput(char *who, char *getwhat);
void getrut(char *getwhat);
void north(void);
void south(void);
void east(void);
void west(void);
void qmlokrou(void);
void shvrou(void);
int shvutl(char *from, char *to, struct room *entrp);
void qmdrprou(void);
void wnkrou(void);
void glrrou(void);
/* QMUTL.C 03/03/92 17.09.50 */
void outothr(void);
void outowfs(struct qmplayer *playpt, long auraf);
void outevbt(struct qmplayer *doplyr);
void qmoutroom(struct room *rmptr);
void qmoutall(void);
void qmoutnear(void);
void outfar(void);
void outnsew(struct room *plyroom);
long seeflg(long invflg);
void qmxitroom(struct qmplayer *pp, char *xitdesc);
void qmentroom(struct qmplayer *pp, struct room *destrm, char *entdesc);
void seeitms(struct qmplayer *pp);
char *anitno(int itmno);
void invrou(void);
void invutl(struct qmplayer *ppt);
char *anitmn(struct item *itm);
char *aoran(char *noun);
void seepyrs(struct qmplayer *pp);
int npysee(struct qmplayer *pp);
void inpsee(struct qmplayer *pp);
struct qmplayer *nxpsee(struct qmplayer *pp);
int npyroom(struct room *room);
void rst4say(void);
void rst4whs(void);
struct item *getpitm(struct qmplayer *who, char *name);
struct item *getritm(struct room *where, char *name);
int putpitm(struct qmplayer *who, struct item *itmptr);
int putritm(struct room *where, struct item *itmptr);
struct item *locitm(char *itmnam);
struct qmplayer *qmfndplyr(char *name);
struct qmplayer *plyrqm(char *name);
void bagthe(void);
void qmbagprep(void);
void killpyr(struct qmplayer *pp);
char *namize(char *stg);
void xmunum(int msgno);
/* QMSIMP.C 03/03/92 17.03.04 */
void approu(void);
void gigrou(void);
void jmprou(void);
void lghrou(void);
void shgrou(void);
void lierou(void);
void wherou(void);
void sitrou(void);
void grvrou(void);
void snrrou(void);
void cacrou(void);
void swerou(void);
void chorou(void);
void begrou(void);
void chrrou(void);
void blurou(void);
void gasrou(void);
void cowrou(void);
void bowrou(void);
void smkrou(void);
void chvrou(void);
void boorou(void);
void hisrou(void);
void frnrou(void);
void snlrou(void);
void potrou(void);
void grwrou(void);
void grurou(void);
void smlrou(void);
void grnrou(void);
void danrou(void);
void sihrou(void);
void sinrou(void);
void snzrou(void);
void whmrou(void);
void smorou(void);
void spirou(void);
void snkrou(void);
void gonrou(void);
void monrou(void);
void burrou(void);
void farrou(void);
void yawrou(void);
void redeye(void);
void nodrou(void);
void fixrou(void);
void gamrou(void);
void trdrou(void);
void clnrou(void);
void prarou(void);
void anyrou(void);
void sicrou(void);
void stmrou(void);
void cryrou(void);
void courou(void);
void churou(void);
void wisrou(void);
void humrou(void);
void blkrou(void);
void snfrou(void);
void snorou(void);
void helrou(void);
void brfrou(void);
void lonrou(void);
void hpts(void);
/* QMSPCL.C 03/03/92 17.19.22 */
void cojrou(void);
void drajspk(void);
void quake(void);
void brodcst(void);
void fairy(void);
void vision(void);
void nulrou(void);
int inulrou(void);
int examine(void);
int chprou(void);
int luvrou(void);
int nghrou(void);
int orbrou(void);
int echorou(void);
int wotrou(void);
int qmrosrou(void);
int pyrrou(void);
int hovrou(void);
int sohrou(void);
int walrou(void);
int coprou(void);
int cpsrou(void);
int eplrou(void);
int wplrou(void);
int nplrou(void);
int osrrou(void);
int pokrou(void);
int sumhall(void);
int hokrou(void);
int chlrou(void);
int frgrou(void);
int sample(void);
/* QMIROUS.C 03/03/92 17.25.12 */
void rubrou(void);
void thkrou(void);
void aimrou(void);
void ringin(void);
void amltlp(void);
void coloring(void);
void teleorb(void);
void amltip(void);
void prytele(void);
void aimwan(void);
void locket(void);
void rubstf(void);
void medall(void);
void thkstf(void);
void penden(void);
void charm(void);
void rodrub(void);
void thkrod(void);
/* QMSPELLS.C 03/03/92 17.32.06 */
void fpaspl(void);
void suyspl(void);
void istspl(void);
void cuuspl(void);
void draspl(void);
void fizspl(void);
void kyrspl(void);
void mhispl(void);
void linspl(void);
void hijspl(void);
void qyrspl(void);
void tinspl(void);
void bamoth(int nhits);
void oopwer(void);
void fblspl(void);
void erispl(void);
void zebspl(void);
void osispl(void);
void nubspl(void);
void ooyspl(void);
void gupspl(void);
/* QMSPLUTL.C 03/03/92 17.37.40 */
void inispl(void);
void decspu(void);
void sspdly(int seconds);
void nsplcs(void);
