/***************************************************************************
 *                                                                         *
 *   GALDNX.C                                                              *
 *                                                                         *
 *   Copyright (C) 1994 GALACTICOMM, Inc.    All Rights Reserved.          *
 *                                                                         *
 *   Downloading example.                                                  *
 *                                                                         *
 *                                              - R. Stein  12/6/93        *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "filexfer.h"

STATIC int dnlinp(void);
STATIC int tshdnl(int tshcod);

int dnlstt;                             /* Downloading module state number */
struct module dnlmodule={"",NULL,dnlinp,dfsthn,NULL,NULL,NULL,NULL,NULL,NULL};

void EXPORT
init__downloader(void)                  /* Downloader initialization       */
{
     stzcpy(dnlmodule.descrp,gmdnam("GALDNX.MDF"),MNMSIZ);
     dnlstt=register_module(&dnlmodule);
}

STATIC int
dnlinp(void)                            /* Downloader input handler        */
{
     int rc=1;

     switch (usrptr->substt) {
     case 0:
          prf("Name of file to download: ");
          usrptr->substt=1;
          break;
     case 1:
          if (margc == 0) {
               rc=0;
          }
          else if (ftgnew() == 0) {
               ftgsbm("");              /* use warning feature of ftgsbm() */
               rc=0;
          }
          else {
               stzcpy(ftgptr->tagspc,margv[0],TSLENG);
               ftgptr->tshndl=tshdnl;
               ftgsbm("?");
          }
     }
     outprf(usrnum);
     return(rc);
}

int
tshdnl(                                 /* Handle the application-specific */
int tshcod)                             /* aspects of your downloads       */
{                                       /* (tshcod=code for each aspect)   */
     int rc=0;

     switch(tshcod) {
     case TSHVIS:                       /* Visible to this user?           */
          rc=1;
          break;
     case TSHDSC:                       /* Describe the file(s) in English */
          sprintf(tshmsg,"file %s",ftgptr->tagspc);
          break;
     case TSHBEG:                       /* Begin downloading this file     */
          sprintf(tshmsg,"DNLDIR\\%s",ftgptr->tagspc);
          strcpy(ftfscb->fname,ftgptr->tagspc);
          rc=1;
          break;
     case TSHFIN:                       /* End of downloading session      */
          usrptr->state=dnlstt;
     }
     return(rc);
}
