/***************************************************************************
 *                                                                         *
 *   GALCR.C                                                               *
 *                                                                         *
 *   Copyright (C) 1992 GALACTICOMM, Inc.         All Rights Reserved.     *
 *                                                                         *
 *   This module lets you embed carriage returns in module command         *
 *   strings associated with menu options.                                 *
 *                                                                         *
 *                                               - S. Brinker  11/24/92    *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"

#define EMBDCR      '~'            /* embedded cr character                */

STATIC
int (*oldvec)();                   /* original vector for cmd stg handling */

void EXPORT init__cmdstgcr(void);
int ecrvec(void);

void EXPORT
init__cmdstgcr(void)               /* init. "embedded cr in cmd stg" mod   */
{
     oldvec=gomvec;
     gomvec=ecrvec;
}

int
ecrvec(void)                       /* embedded cr cmd stg handler          */
{
     int savmgc;
     char *stgptr;

     stgptr=input;
     rstrin();
     while (*stgptr != '\0') {
          if (*stgptr == EMBDCR) {
               *stgptr='\0';
               savmgc=margc;
               parsin();
               if ((*oldvec)() == 0) {
                    return(0);
               }
               margc=savmgc;
               rstrin();
               movmem(stgptr+1,input,strlen(stgptr+1)+1);
               if (*(stgptr=input) == '\0') {
                    return(1);
               }
               parsin();
               rstrin();
               clrprf();
               btuclo(usrnum);
          }
          else {
               stgptr++;
          }
     }
     parsin();
     return((*oldvec)());
}

