/***************************************************************************
 *                                                                         *
 *   FAZRTK.C    (ZRTKICK.C)                                               *
 *                                                                         *
 *   Copyright (C) 1984, 1986, 1991 GALACTICOMM, Inc. All Rights Reserved. *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "fazdat.h"

#define NRTKNT 20             /* number of rtks poss at one time           */

static struct {               /* 'zuul flavor of real-time kicktable data  */
     int timer;                    /* seconds counter                      */
     void (*xfvec)();              /* transfer vector (addr to invoke)     */
     int param;                    /* parameter to pass when invoking      */
} rtktbl[NRTKNT],*rtkptr;

void
zinirtk(void)                 /* initialize rtkick stuff                   */
{
     for (rtkptr=rtktbl ; rtkptr != rtktbl+NRTKNT ; rtkptr++) {
          rtkptr->timer=0;
     }
}

void
zrtkick(time,rouptr,parm)     /* arrange for an action to take place later */
int time;
void (*rouptr)();
int parm;
{
     for (rtkptr=rtktbl ; rtkptr != rtktbl+NRTKNT ; rtkptr++) {
          if (rtkptr->timer == 0) {
               rtkptr->timer=time;
               rtkptr->xfvec=rouptr;
               rtkptr->param=parm;
               break;
          }
     }
}

void
zrtksvc(void)                 /* service any requests that have come due   */
{
     for (rtkptr=rtktbl ; rtkptr != rtktbl+NRTKNT ; rtkptr++) {
          if (rtkptr->timer != 0 && --(rtkptr->timer) == 0) {
               (*(rtkptr->xfvec))(rtkptr->param);
          }
     }
}
