/***************************************************************************
 *                                                                         *
 *   FAZGUT.C    (GUTILS.C)                                                *
 *                                                                         *
 *   Copyright (C) 1984, 1986, 1991 GALACTICOMM, Inc. All Rights Reserved. *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "fazdat.h"

STATIC void srchrs(void);

void
ucify(stgptr)                 /* upper-case-ify target string              */
char *stgptr;
{
     while ((*stgptr=toupper(*stgptr)) != '\0') {
          stgptr++;
     }
}

int
getrnd(void)                  /* get a pseudorandom integer                */
{
/* alternate form: x=(x*25173L+13849L)%0xFFFF */

     static int rnum=31785;

     return(rnum=(int)((rnum*15483L+7169L)&0x7FFF));
}

void
addmbf(stgptr)                /* "add to message buffer" (archaic)         */
char *stgptr;
{
     prf("%s",stgptr);
}

void
mspstg(stgptr,arg)            /* "make special string" (archaic)           */
char *stgptr;
long arg;
{
     static char result[200];

     sprintf(result,stgptr,arg);
     prf("%s",result);
}

void
prscmd(void)                  /* parse command line                        */
{
     urgc=0;
     fzcptr=pyrcmd;
     while (*fzcptr == ' ') {
          fzcptr++;
     }
     if (*fzcptr == '"') {
          fzcptr++;
          while (*fzcptr == ' ') {
               fzcptr++;
          }
          srchrs();
          if (urgc != 0 && *(arge[urgc]-1) == '"') {
               arge[urgc]-=1;
               *arge[urgc]='\0';
               if (urgv[urgc-1] == arge[urgc]) {
                    urgc--;
               }
          }
     }
     else {
          srchrs();
     }
}

STATIC void
srchrs(void)                  /* search for space characters               */
{
     while (*fzcptr != '\0') {
          urgv[urgc++]=fzcptr;
          while (*fzcptr > ' ') {
               fzcptr++;
          }
          arge[urgc]=fzcptr;
          if (*fzcptr != '\0') {
               *fzcptr++='\0';
          }
          while (*fzcptr == ' ') {
               fzcptr++;
          }
     }
}

void
recomb(void)                  /* re-combine input word array               */
{
     int urgctr;

     for (urgctr=1 ; urgctr < urgc ; ) {
          *arge[urgctr++]=' ';
     }
}

int
nmatch(trmstg,untstg)         /* "near" match -- similar to sameto()       */
char *trmstg,*untstg;
{
     while (*trmstg != '\0') {
          if (*trmstg++ != *untstg++) {
               return(0);
          }
     }
     return(1);
}

int
stgcmp(cmdstg,posmat)         /* string compare -- similar to strcmp()     */
char *cmdstg,*posmat;
{
     for ( ; (*cmdstg) == (*posmat) ; cmdstg++,posmat++) {
          if (*cmdstg == '\0') {
               return(0);
          }
     }
     return((*cmdstg)-(*posmat));
}
