/***************************************************************************
 *                                                                         *
 *   FAZDAT.H                                                              *
 *                                                                         *
 *   Copyright (C) 1984, 1986, 1991 GALACTICOMM, Inc. All Rights Reserved. *
 *                                                                         *
 *   This is the header file for all FAZUUL game sources.                  *
 *                                                                         *
 *                                                 - T. Stryker 1/24/91    *
 *                                                                         *
 ***************************************************************************/

#define USERSZ 30             /* User ID Size                          */
#define ALSSIZ 10             /* maz size of alias name                */
#define AUXSIZ 18             /* max size of auxilliary handle (SUF)   */
#define NVSTMN 5              /* number of visited-rooms maintained    */
#define NOBJHD 6              /* max no. of objects player can hold    */
#define NOBJST 6              /* max no. of objs to fit in one state   */
#define NOBJMS 4              /* max no. of mothers an object can have */
#define SPRSIZ 36             /* amt of spare space, dec when adding   */

#define SGOBIT 0x01           /* pyrptr->logon bit for signed on       */
#define SEXBIT 0x02           /* pyrptr->logon bit for sex (m=1, f=0)  */
#define INGAME 0x04           /* pyrptr->logon bit for in game         */
#define BRFBIT 0x20           /* pyrptr->logon bit for brief descrip   */

#define FLOBIT 0x01           /* pyrptr->newflg bit for first logon    */

#define TOTOBJ 154            /* number of different objects */
#define TOTSTT 353            /* number of different states  */

extern
struct player {                    /* player-specific data:                */
     char handle[USERSZ];               /* User-ID                         */
     char plyrid[ALSSIZ];               /* Alias Name                      */
     int logon;                         /* flag for player-logged-on       */
     int crackl;                        /* crackers left                   */
     int portno;                        /* port number that player is on   */
     char auxhdl[AUXSIZ];               /* "auxillary" handle              */
     int newflg;                        /* "new" player - first-logon bit  */
     struct state *sttptr;              /* room struc ptr that player is in*/
     struct player *nxtpyr;             /* room linked list link ptr       */
     int vsttes[NVSTMN];                /* recently-visited-states codes   */
     int vages[NVSTMN];                 /* recently-visited-states ages    */
     int nobjs;                         /* number of objects in hands      */
     struct object *pyrobj[NOBJHD];     /* ptrs to obj strucs of held objs */
     int pobjct[NOBJHD];                /* command-counter per object held */
     char spare[SPRSIZ];                /* spare space for future enhance  */
};

extern
struct state {                     /* state (room) specific data:          */
     char *sdscrp;                      /* state description string        */
     char *sobjlc;                      /* object "location" within state  */
     int sttmsg;                        /* msg no. of state long descrip.  */
     int (*cmhdlr)();                   /* state-specific command handler  */
     struct player *plhead;             /* player linked-list header       */
     int nobjs;                         /* number of objects in state      */
     struct object *sttobj[NOBJST];     /* ptrs to obj strucs of room objs */
     struct state *north;               /* state northward (NULL if none)  */
     struct state *south;               /* state southward (NULL if none)  */
     struct state *east;                /* state eastward (NULL if none)   */
     struct state *west;                /* state westward (NULL if none)   */
} states[TOTSTT];                  /* state array defined in FAZGST.C      */

extern
struct object {                    /* object (item) specific data:         */
     char *name;                        /* object name                     */
     char *positn;                      /* position sub-description        */
     int flags;                         /* bit flags (see below)           */
     char *cntake;                      /* if not takable and take attempt */
     int objmsg;                        /* msg no. of object long descrip. */
     void (*actvec)();                  /* activation vector               */
     void (*objtvc)();                  /* timeout (pobjct==0) vector      */
     struct object *mothrs[NOBJMS];     /* objs that this obj makes        */
     struct object *dghtr1;             /* object 1 that obj is made of    */
     struct object *dghtr2;             /* object 2 that obj is made of    */
} objcts[TOTOBJ];                  /* object array defined in FAZGOB.C     */

#define OBJNVS 1                 /* zbjptr->flags bit for invisible object */
#define OBJTKB 2                 /* zbjptr->flags bit for takable object   */
#define OBJRDA 4                 /* zbjptr->flags bit for readable object  */
#define ACTBUT 0x0100            /* zbjptr->flags activate via button      */
#define ACTPNT 0x0200            /* zbjptr->flags activate by pointing     */
#define ACTKCK 0x0400            /* zbjptr->flags activate by kicking      */
#define ACTTNK 0x0800            /* zbjptr->flags activate by thinking abt */

extern
struct player *pyrarr,        /* dynam alloc'd player data structure array */
              *pyrptr,        /* ptr to current user's pyrarr element      */
              *othpyr;        /* "other" player ptr -- for actions etc.    */
extern
struct state  *sttptr;        /* global scratch vbl for room structure ptr */
extern
struct object *zbjptr;        /* global scratch vbl for object (item) ptr  */
extern
int pyrctr,                   /* "player counter" - same as usrnum in BBS  */
    urgc;                     /* argument count - same as margc in BBS     */
extern
char pyrcmd[256],             /* "player command" - same as input in BBS   */
     *fzcptr,                 /* global scratch vbl for scanning pyrcmd    */
     *urgv[64],               /* argument values - same as margv in BBS    */
     *arge[65],               /* argument ends - same as marge in BBS      */
     *fazcant;                /* not allowed to play FAZUUL fully (msg)    */
extern
int intmp1,                   /* scratch temporary vbl 1                   */
    intmp2,                   /* scratch temporary vbl 2                   */
    objidx,                   /* global scratch vbl for object indexes     */
    noistt;                   /* flag to whther() for uncond output        */

extern
struct kwtab {                /* keyword table data structure layouts      */
     char *kyword;
     int (*subadr)();
} *kwtptr;
extern
struct kwntab {
     char *kyword;
     int number;
} *kwnptr;

/* FAZCAX.C 19/03/92 15.56.12 */
int diertn(void);
int crflun(void);
int crkrtn(void);
int sayrtn(void);
int yelrtn(void);
int whsrtn(void);
int moven(void);
int moves(void);
int movee(void);
int movew(void);
int shoven(void);
int shoves(void);
int shovee(void);
int shovew(void);
int takrtn(void);
void invrtn(void);
int givrtn(void);

/* FAZCUT.C 19/03/92 17.34.26 */
void game(void);
int move(struct state *dstspt,char *lvmsg,char *entmsg);
int shove(struct state *dstspt,char *lvdir,char *entmsg);
void ntrstt(struct state *svcptr,char *txtptr);
void whoher(void);
void whther(void);
void mobjps(struct object *zbjptr);
void lvstt(char *txtptr);
void zapwrd(char *word);
void donthv(void);
void ainthr(int argno);
int holdng(struct object *obj);
int hold(struct object *obj);
int hldoth(struct object *obj);
int invis(struct player *pyrp);
int iszleen(struct player *pyrp);

/* FAZGAM.C 19/03/92 17.38.02 */
int foon(void);
int umflun(void);
int osmo(void);
void osmwat(void);
void gwirg(void);

/* FAZGUT.C 19/03/92 17.41.04 */
void ucify(char *stgptr);
int getrnd(void);
void addmbf(char *stgptr);
void mspstg();
void prscmd(void);
void recomb(void);
int nmatch(char *trmstg,char *untstg);
int stgcmp(char *cmdstg,char *posmat);

/* FAZMST.C 19/03/92 17.42.42 */
void jabber(int msgnum);
void gibber(void);
void outnis(void);
void fazall(void);
void fazoth(void);
void outpyr(struct player *othpyr);
void outexc(struct player *ptrpyr);
void outner(void);
void fazfar(void);
void outare(struct state *spoint);

/* FAZORU.C 19/03/92 17.47.34 */
void gwing(void);
void snuge(void);
void klonk(void);
void bilge(void);
void bork(void);
void rhuba(void);
void moolk(void);
void wufflar(void);
void suvar(void);
void seppe(struct object *dntcar,int narg);
void palt(struct object *dntcar,int narg);
void cistl(void);
void rommu(void);
void rucku(void);
void bundl(void);
void nabob(void);
void bagl3(struct object *atmptr,int typcod);
void bagl4(struct object *atmptr,int typcod);
void bagl5(struct object *atmptr,int typcod);
void dweez(void);
void koot4(void);
void koot5(void);
void koot6(void);
void kwish(void);
void quoru(void);
void cacap(void);
void wappl(void);
void nebbi(struct player *othpyr,int typcod);
void wongu(void);
void wongo(void);
void narre(void);
void drive(void);
void pasta(void);
void noodl(void);
void scroo(struct player *othpyr,int typcod);
void fashn(void);
void fasho(void);
void fashoo(struct player *pyrp);
void quice(void);
void snaac(void);
void babba(struct player *pyr,int typcod);
void quilbert(struct object *atmptr,int typcod);
void quilb(void);
void zarpnt(struct object *atmptr,int typcod);

/* FAZRTK.C 20/03/92 10.33.34 */
void zinirtk(void);
void zrtkick(int time,void (*rouptr)(),int parm);
void zrtksvc(void);

/* FAZSRO.C 20/03/92 09.33.58 */
void inists(void);
int nocmd(void);
int cm108(void);
int cm152(void);
int cm77(void);
int cm251(void);
int cm284(void);
int cm137(void);
int cm104(void);
int cm109(void);
int cm113(void);
int cm116(void);
int cm193(void);
int cm290(void);
int cm330(void);
int cm351(void);
int sltchk(struct object *objps1,struct object *objps2,struct object *
        objps3,char *apstg);
int cm302(void);
int cm303(void);
int cm306(void);
int cm307(void);
int cm310(void);
int cm311(void);
int cm312(void);
int cm318(void);
int cm352(void);
int cm321(void);
int cm320(void);
int cm322(void);
int cm331(void);
int cm333(void);
int cm334(void);
int cm336(void);
int cm337(void);
int cm338(void);
int cm343(void);
int cm345(void);
int cm349(void);

/* FAZUUL.C 20/03/92 09.39.54 */
void EXPORT init__fazuul(void);

/* FAZCST.C 20/03/92 11.13.02 */
char *zhisher(struct player *pyrp);
char *zheshe(struct player *pyrp);
struct state *fndpyr(char *hdlstg);
struct player *fndhdl(char *schstg);
struct object *fnobjp(char *stgptr,struct player *pyrptr);
struct object *sfnobjs(char *stgptr,struct state *statpt);
struct object *fnobjs(char *stgptr);
void rmvobp(struct player *pyrptr,int wchone);
void insobp(struct player *pyrptr,struct object *zbjptr,int count);
void srmvobs(int wchone,struct state *statpt);
void rmvobs(int wchone);
void insobs(struct object *zbjptr);
int ntnice(void);
void zntifo(void);
int zdsass(void);
void infoth(char *infstg);
struct kwtab *fazbin(char *stgptr,struct kwtab table[],int length);
int stdcmd(void);
