/***************************************************************************
 *                                                                         *
 *   KYRANDIA, Fantasy-world of Legends                     Version 7.00   *
 *                                                                         *
 *   Copyright (C) 1988-1992 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   KYRSYSP.C (KSYSOP.C) - Sysop Editor for KYRANDIA User File            *
 *                                                                         *
 *   Designed/Programmed by: Scott Brinker & Richard Skurnick   03/18/88   *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "kyrandia.h"
#include "kyrspls.h"
#undef LEVEL6
#include "galkyrs.h"
#undef LEVEL6
#include "galkyrm.h"

STATIC void kyrawho(void);
STATIC void kyramnu(void);
STATIC void kyrdsp(void);
STATIC void kyrchg(void);
STATIC void instchg(char *altnam,char *attacknam,long flag);
STATIC void gi_kyrspl(void);
STATIC char kyryn(int i);
STATIC void chgspl(int num);
STATIC void kyrsav(void);
STATIC void beusr(int usn);
STATIC void injax(void);
STATIC void kpmt(int news);

int kinuse,kyrasub,grp;

static
char uid[UIDSIZ];

void
kyraedit(void)                     /* Main Entry for Kyrandia Editor       */
{
    int i,j;

    setmbk(ksmb);
    switch (kyrasub) {
    case 0:
       EditPtr=(struct kplayer *)alcmem(sizeof(struct kplayer));
       kpmt(KYREDT);
       btumil(usrnum,UIDSIZ-1);
       usrptr->substt=90;
       kinuse=1;
       return;
    case KYREDT:
       kyrawho();
       break;
    case KYRMNU:
       kyramnu();
       break;
    case CHGWCH:
       kyrchg();
       break;
    case EDT001:
       if (!margc) {
          kyrdsp();
       }
       else if ((i=atoi(margv[0])) < 1 || i > 5) {
          prfmsg(BADCHO);
          prfmsg(EDT001);
       }
       else {
          switch (i) {
          case 1:
             instchg(EditPtr->alias,EditPtr->alias,0);
             break;
          case 2:
             instchg("Some Unseen Force","Unseen Force",INVISF);
             break;
          case 3:
             instchg("Some pegasus","pegasus",PEGASU);
             break;
          case 4:
             instchg("Some psuedo dragon","psuedo dragon",PDRAGN);
             break;
          case 5:
             instchg("Some willowisp","willowisp",WILLOW);
             break;
          }
       }
       break;
    case EDT002:
       if (!margc) {
          kyrdsp();
       }
       else if ((i=atoi(margv[0])) < 1 || i > 25) {
          prfmsg(BADCHO);
          prfmsg(EDT002);
       }
       else {
          EditPtr->level=i;
          if (EditPtr->flags&FEMALE) {
             EditPtr->pdescr=FDES00+i-1;
          }
          else {
             EditPtr->pdescr=MDES00+i-1;
          }
          EditPtr->hitpts=4*EditPtr->level;
          EditPtr->spts=2*EditPtr->level;
          if (i < 9) {
             EditPtr->flags&=~GOTKYG;
          }
          kyrdsp();
       }
       break;
    case EDT003:
       if (!margc) {
          kyrdsp();
       }
       else if ((i=atoi(margv[0])) < 0 || i > 304) {
          prfmsg(BADCHO);
          prfmsg(EDT003);
       }
       else {
          EditPtr->pgploc=i;
          kyrdsp();
       }
       break;
    case EDT004:
       if (!margc) {
          kyrdsp();
       }
       else if ((i=atoi(margv[0])) < 1 || i > 32766) {
          prfmsg(BADCHO);
          prfmsg(EDT004);
       }
       else {
          EditPtr->gold=(unsigned)i;
          kyrdsp();
       }
       break;
    case EDT005:
       if (!margc) {
          kyrdsp();
       }
       else if ((i=atoi(margv[0])) < 1 || i > 50) {
          prfmsg(BADCHO);
          prfmsg(EDT005);
       }
       else {
          EditPtr->spts=(i > (EditPtr->level*2) ? EditPtr->level*2 : i);
          kyrdsp();
       }
       break;
    case EDT006:
       if (!margc) {
          kyrdsp();
       }
       else if ((i=atoi(margv[0])) < 1 || i > 99) {
          prfmsg(BADCHO);
          prfmsg(EDT006);
       }
       else {
          EditPtr->hitpts=(i > (EditPtr->level*4) ? EditPtr->level*4 : i);
          kyrdsp();
       }
       break;
    case EDT007:
       if (!margc) {
          kyrdsp();
       }
       else if (toupper(*margv[0]) == 'X') {
          EditPtr->spouse[0]='\0';
          EditPtr->flags&=~MARRYD;
          kyrdsp();
       }
       else {
          makhdl(input);
          setmem(EditPtr->spouse,sizeof(UIDSIZ),0);
          movmem(input,EditPtr->spouse,UIDSIZ);
          EditPtr->flags|=MARRYD;
          kyrdsp();
       }
       break;
    case EDT008:
       if (!margc) {
          kyrdsp();
       }
       else if ((i=atoi(margv[0])) < 0 || i > 6) {
          prfmsg(BADCHO);
          prfmsg(EDT008);
       }
       else {
          if (EditPtr->npobjs < i) {
             for (j=EditPtr->npobjs ; j < i ; j++) {
                EditPtr->pobjs[j]=&Objects[2];
             }
          }
          else {
             for (j=i ; j < MXPOBS ; j++) {
                EditPtr->pobjs[j]=NULL;
             }
          }
          EditPtr->npobjs=i;
          kyrdsp();
       }
       break;
    case EDT009:
       gi_kyrspl();
       kpmt(MODSPL);
       break;
    case EDT010:
    case EDT011:
    case EDT012:
    case EDT013:
    case EDT014:
    case EDT015:
       if (!margc) {
          kyrdsp();
       }
       else if ((i=atoi(margv[0])) < 1 || i > 240) {
          prfmsg(BADCHO);
          prfmsg(kyrasub);
       }
       else {
          EditPtr->charms[grp]=i;
          kyrdsp();
       }
       break;
    case EDT016:
    case EDT017:
    case EDT018:
    case EDT019:
    case EDT020:
    case EDT021:
       if (!margc) {
          kyrdsp();
       }
       else {
          j=0;
          for (objptr=Objects ; objptr < Objects+45 ; objptr++) {
             if (sameto(margv[0],objptr->name)) {
                j=1;
                EditPtr->pobjs[grp]=objptr;
                kyrdsp();
                break;
             }
          }
          if (!j) {
             prfmsg(NOSOBJ);
             prfmsg(kyrasub);
          }
       }
       break;
    case EDT022:
       if (!margc) {
          kyrdsp();
       }
       else if ((i=atoi(margv[0])) < 0 || i > 4) {
          prfmsg(BADCHO);
          prfmsg(kyrasub);
       }
       else {
          EditPtr->gemidx=i;
          kyrdsp();
       }
       break;
    case EDT023:
       if (!margc) {
          kyrdsp();
       }
       else if ((i=atoi(margv[0])) < 0 || i > 12) {
          prfmsg(BADCHO);
          prfmsg(kyrasub);
       }
       else {
          EditPtr->stumpi=i;
          kyrdsp();
       }
       break;
    case MODSPL:
       if (!margc) {
          prfmsg(MODSPL);
       }
       else if (sameas(margv[0],"?")) {
          gi_kyrspl();
          prfmsg(MODSPL);
       }
       else if (sameas(margv[0],"x")) {
          kyrdsp();
       }
       else if ((i=atoi(margv[0])) < 1 || i > 67) {
          prfmsg(BADCHO);
          prfmsg(MODSPL);
       }
       else {
          chgspl(i);
          prfmsg(MODSPL);
       }
       break;
    }
    outprf(usrnum);
}

STATIC void
kyrawho(void)                      /* Select User to Edit or Exit to game  */
{

    if (!margc) {
       prfmsg(KYREDT);
    }
    else if (sameas(margv[0],"x")) {
       free(EditPtr);
       btupmt(usrnum,'>');
       btuxmt(usrnum,kyratr);
       entrgp(PlayPtr->pgploc,PlayPtr,"flown down from the heavens on a golden chariot");
       usrptr->substt=7;
       kinuse=kyrasub=0;
       btumil(usrnum,DFTIMX);
       prf("");
    }
    else {
       rstrin();
       makhdl(input);
       movmem(input,uid,UIDSIZ);
       if (sameas(uid,usaptr->userid)) {
          movmem(PlayPtr,EditPtr,sizeof(struct kplayer));
          kpmt(KYRMNU);
          btumil(usrnum,DFTIMX);
       }
       else {
          setbtv(kbb);
          if (acqbtv(EditPtr,uid,0)) {
             gi_rest4p(EditPtr);
             kpmt(KYRMNU);
             btumil(usrnum,DFTIMX);

          }
          else {
             prfmsg(NOSUCH);
             prfmsg(KYREDT);
          }
       }
    }
}

STATIC void
kyramnu(void)                      /* Do what to the user selected?        */
{
    if (!margc) {
       kpmt(KYRMNU);
    }
    else {
       switch (toupper(*margv[0])) {
       case 'E':
          kyrdsp();
          break;
       case 'X':
          kyrsav();
          kpmt(KYREDT);
          break;
       case 'A':
          kpmt(KYREDT);
          setmem(EditPtr,sizeof(struct kplayer),0);
          break;
       case '?':
          prfmsg(KYRMNU,EditPtr->alias);
          break;
       default:
          prfmsg(BADCHO);
          prfmsg(KYRMNU,EditPtr->alias);
       }
    }
}

STATIC void
kyrdsp(void)                       /* Display the users account info       */
{
    int i;

    prfmsg(KYRAC1,EditPtr->alias,EditPtr->altnam,EditPtr->attacknam,
                  EditPtr->level,EditPtr->pgploc,LocArr[EditPtr->pgploc].brfdes,
                  EditPtr->gold,EditPtr->spts,EditPtr->hitpts,
                  (EditPtr->spouse[0] == '\0' ? "<None Yet>" : EditPtr->spouse),
                  EditPtr->npobjs);
    prfmsg(KYRAC2,EditPtr->charms[0],EditPtr->charms[1],EditPtr->charms[2],
                  EditPtr->charms[3],EditPtr->charms[4],EditPtr->charms[5]);
    for (i=0 ; i < 6 ; i++) {
       prfmsg(OBJLST,i+16,
             (i < EditPtr->npobjs ? EditPtr->pobjs[i]->name : "---------"));
       if (i == 2 || i == 5) {
          prf("\r");
       }
    }
    prfmsg(KYRAC3,EditPtr->gemidx,
            Objects[EditPtr->stones[0]].name,Objects[EditPtr->stones[1]].name,
            Objects[EditPtr->stones[2]].name,Objects[EditPtr->stones[3]].name,
            EditPtr->stumpi);
    kpmt(CHGWCH);
}

STATIC void
kyrchg(void)                       /* Change what aspect of the account    */
{
    int i;

    if (!margc) {
       prfmsg(CHGWCH);
    }
    else if (sameas(margv[0],"x")) {
       kpmt(KYRMNU);
    }
    else if (sameas(margv[0],"?")) {
       kyrdsp();
    }
    else if ((i=atoi(margv[0])) < 1 || i > 23) {
       prfmsg(BADCHO);
       prfmsg(CHGWCH);
    }
    else if (i == 9) {
       gi_kyrspl();
       kpmt(MODSPL);
    }
    else {
       kpmt(EDT001+i-1);
       if (i > 9 && i < 16) {
          grp=i-10;
       }
       if (i > 15 && i < 22) {
          grp=i-16;
       }
    }
}

STATIC void
instchg(altnam,attacknam,flag)        /* Change the users alternate names     */
char *altnam,*attacknam;
long flag;
{
    strcpy(EditPtr->altnam,altnam);
    strcpy(EditPtr->attacknam,attacknam);
    EditPtr->flags&=~(INVISF+PEGASU+WILLOW+PDRAGN);
    if (flag) {
       EditPtr->flags|=flag;
       if (EditPtr->charms[ALTNAM] == 0) {
          EditPtr->charms[ALTNAM]=4;
       }
    }
    else {
       EditPtr->charms[ALTNAM]=0;
    }
    kyrdsp();
}

STATIC void
gi_kyrspl(void)                       /* Display the spells the user has      */
{
    int i,j,k;

    k=1;
    prf("\r");
    for (i=0 ; i < 13 ; i++) {
       for (j=0 ; j < 5 ; j++,k++) {
          prfmsg(SPLLST,k,spells[k-1].name,kyryn(k-1));
       }
    }
    for (j=0 ; j < 2 ; j++,k++) {
       prfmsg(SPLLST,k,spells[k-1].name,kyryn(k-1));
    }
    prf("\r");
    prfmsg(KSPLS0);
}

STATIC char
kyryn(i)                           /* Display a Y or N for a spell         */
int i;
{
    char retval;

    switch (spells[i].sbkref) {
    case 1:
       if (EditPtr->offspls&(spells[i].bitdef)) {
          retval='Y';
       }
       else {
          retval='N';
       }
       break;
    case 2:
       if (EditPtr->defspls&(spells[i].bitdef)) {
          retval='Y';
       }
       else {
          retval='N';
       }
       break;
    case 3:
       if (EditPtr->othspls&(spells[i].bitdef)) {
          retval='Y';
       }
       else {
          retval='N';
       }
    }
    return(retval);
}

STATIC void
chgspl(num)                        /* Change the flags on a spell          */
int num;
{
    num--;
    splptr=&spells[num];
    switch (splptr->sbkref) {
    case 1:
       if (EditPtr->offspls&(splptr->bitdef)) {
          EditPtr->offspls&=~(splptr->bitdef);
       }
       else {
          EditPtr->offspls|=(splptr->bitdef);
       }
       break;
    case 2:
       if (EditPtr->defspls&(splptr->bitdef)) {
          EditPtr->defspls&=~(splptr->bitdef);
       }
       else {
          EditPtr->defspls|=(splptr->bitdef);
       }
       break;
    case 3:
       if (EditPtr->othspls&(splptr->bitdef)) {
          EditPtr->othspls&=~(splptr->bitdef);
       }
       else {
          EditPtr->othspls|=(splptr->bitdef);
       }
       break;
    }
}


STATIC void
kyrsav(void)                       /* Save changes back to the account     */
{
    int hldusn;
    extern int kyrstt;

    setbtv(kbb);
    if (!onsysn(EditPtr->uidnam,1) || !(Players[othusn].flags&LOADED)) {
       if (acqbtv(NULL,EditPtr->uidnam,0)) {
          gi_prep4d(EditPtr);
          updbtv(EditPtr);
          prfmsg(RECUPD);
       }
       else {
          prfmsg(RECNPD);
       }
    }
    else {
       hldusn=usrnum;
       beusr(othusn);
       if (usrptr->state == kyrstt && usrptr->substt == 7) {
          injax();
       }
       movmem(EditPtr,PlayPtr,sizeof(struct kplayer));
       if (acqbtv(NULL,EditPtr->uidnam,0)) {
          gi_prep4d(EditPtr);
          updbtv(EditPtr);
       }
       beusr(hldusn);
       setmbk(ksmb);
       prfmsg(RECUPD);
    }
    setmem(EditPtr,sizeof(struct kplayer),0);
}

STATIC void
beusr(usn)                         /* act as a usrnum for a minute         */
int usn;
{
    curusr(usn);
    PlayPtr=&Players[usrnum];
}

STATIC void
injax(void)                        /* inject an 'X' to current channel     */
{                                  /*    (re-prompt current text)          */
    usrptr->flags|=INJOIP;
    status=CRSTG;
    clrinp();
    strcpy(input,"x");
    parsin();
    hdlinp();
    usrptr->flags&=~INJOIP;
}

STATIC void
kpmt(news)                         /* Print generic prompts and set substt */
int news;
{
    switch (kyrasub=news) {
    case KYRMNU:
       prfmsg(news,uid);
       break;
    default:
       prfmsg(news);
       break;
    }
}

