/***************************************************************************
 *                                                                         *
 *   KYRANDIA, Fantasy-world of Legends                     Version 7.00   *
 *                                                                         *
 *   Copyright (C) 1988-1992 GALACTICOMM, Inc.    All Rights Reserved.     *
 *                                                                         *
 *   KYRROUS.C (KLCROUS.C) - Room-specific command routines                *
 *                                                                         *
 *   Designed/Programmed by: Scott Brinker & Richard Skurnick   03/18/88   *
 *                                                                         *
 ***************************************************************************/

#include "gcomm.h"
#include "majorbbs.h"
#include "kyrandia.h"
#include "galkyrm.h"
#include "kyrspls.h"

STATIC int drkutl(void);
STATIC int chklvl(int level);
STATIC void glvutl(void);

struct binwrd *wrdptr;

struct binwrd seewrds[3]={
     {"examine",NULL},
     {"look",NULL},
     {"see",NULL}
};

int
willow(void)                       /* willow tree room specific handling   */
{
    char *stg;

    gi_bagthe();
    bagprep();
    if ((wrdptr=binchk(margv[0],seewrds,3)) != NULL) {
       if (margc > 1
           && (sameto(margv[1],"tree") || sameto(margv[1],"willow"))) {
          prfmsg(KID046);
          outprf(usrnum);
          return(0);
       }
       return(1);
    }
    stg=getmsg(WILCMD);              /* LEVEL4 string option */
    if (sameas(margv[0],stg)) {
       if (chklvl(2)) {
          glvutl();
          PlayPtr->defspls|=SBD053;
          msgutl2(LVL200,GETLVL);
       }
       return(0);
    }
    return(1);
}

struct binwrd trdwrds[3]={
     {"give", NULL},
     {"sell", NULL},
     {"trade",NULL}
};

static
struct gemlst {
     char *name;
     int value;
} gemlst[12]={
     {"ruby",      22},
     {"emerald",   25},
     {"garnet",    2 },
     {"pearl",     6 },
     {"aquamarine",9 },
     {"moonstone", 32},
     {"sapphire",  16},
     {"diamond",   30},
     {"amethyst",  10},
     {"onyx",      28},
     {"opal",      12},
     {"bloodstone",20}
};

int
getgol(void)           /* exchange gems for gold or items      */
{
    int i;

    gi_bagthe();
    if ((wrdptr=binchk(margv[0],trdwrds,3)) != NULL) {
       if (margc > 1 && (objptr=fgmpobj(margv[1])) != NULL) {
          for (i=0 ; i < 12 ; i++) {
             if (sameas(objptr->name,gemlst[i].name)) {
                tgmpobj(objno);
                PlayPtr->gold+=gemlst[i].value;
                prfmsg(TRDM00,gemlst[i].value);
                outprf(usrnum);
                prfmsg(TRDM01,PlayPtr->altnam,dobutl(objptr),
                              gemlst[i].value);
                sndoth();
                return(0);
             }
          }
          if (sameas(objptr->name,"kyragem")) {
             tgmpobj(objno);
             pgmpobj(&Objects[28],0);   /* soulstone */
             prfmsg(TRDM02);
             outprf(usrnum);
             prfmsg(TRDM03,PlayPtr->altnam);
             sndoth();
             return(0);
          }
          prfmsg(TRDM04);
          outprf(usrnum);
          prfmsg(TRDM03,PlayPtr->altnam);
          sndoth();
          return(0);
       }
       prfmsg(TRDM05);
       outprf(usrnum);
       prfmsg(TRDM03,PlayPtr->altnam);
       sndoth();
       return(0);
    }
    return(1);
}

static
struct spurch {
     struct spell *spell;
     int price;
} splinv[16]={
     {&spells[5], 80},     /* burnup    */
     {&spells[7], 100},    /* cantcmeha */
     {&spells[10],50},     /* clutzopho */
     {&spells[11],40},     /* cuseme    */
     {&spells[16],60},     /* fpandl    */
     {&spells[27],400},    /* hocus     */
     {&spells[33],25},     /* howru     */
     {&spells[39],60},     /* koolit    */
     {&spells[42],30},     /* noouch    */
     {&spells[47],45},     /* pocus     */
     {&spells[54],35},     /* sunglass  */
     {&spells[57],75},     /* thedoc    */
     {&spells[58],1000},   /* tiltowait */
     {&spells[61],120},    /* weewillo  */
     {&spells[62],100},    /* whereami  */
     {&spells[65],50}      /* zapher    */
}, *s2bptr;

struct binwrd buywrds[4]={
     {"buy",     NULL},
     {"order",   NULL},
     {"pay",     NULL},
     {"purchase",NULL}
};

int
buyspl(void)                       /* buy a spell and pay for it           */
{
    int i;

    gi_bagthe();
    bagprep();
    if ((wrdptr=binchk(margv[0],buywrds,4)) != NULL) {
       for (i=0 ; i < 16 ; i++) {
          if (sameto(splinv[i].spell->name,margv[1])) {
             s2bptr=&splinv[i];
             if (s2bptr->price > PlayPtr->gold) {
                prfmsg(BUYM00);
                outprf(usrnum);
                prfmsg(BUYM01,PlayPtr->altnam,himher(PlayPtr));
                sndoth();
             }
             else {
                prfmsg(BUYM02);
                outprf(usrnum);
                prfmsg(BUYM03,PlayPtr->altnam,hisher(PlayPtr),
                              PlayPtr->altnam);
                sndoth();
                PlayPtr->gold-=s2bptr->price;
                switch (s2bptr->spell->sbkref) {
                case OFFENS:
                   PlayPtr->offspls|=s2bptr->spell->bitdef;
                   break;
                case DEFENS:
                   PlayPtr->defspls|=s2bptr->spell->bitdef;
                   break;
                case OTHERS:
                   PlayPtr->othspls|=s2bptr->spell->bitdef;
                   break;
                }
             }
             return(0);
          }
       }
       prfmsg(BUYM04);
       outprf(usrnum);
       prfmsg(BUYM01,PlayPtr->altnam,himher(PlayPtr));
       sndoth();
       return(0);
    }
    return(1);
}

struct binwrd putwrds[3]={
     {"lay",  NULL},
     {"place",NULL},
     {"put",  NULL}
};

extern
int chantd;

int
temple(void)                       /* temple room specific command handling*/
{
    int gold,offer;
    char *stg;

    gi_bagthe();
    if ((wrdptr=binchk(margv[0],putwrds,3)) != NULL) {
       if ((objptr=fgmpobj(margv[1])) != NULL && chantd == 5) {
          offer=(int)(objptr-Objects);
          tgmpobj(objno);
          switch (offer) {
          case 18:                  /* charm */
             if (chklvl(9)) {
                glvutl();
                msgutl2(LVL9M0,LVL9M1);
             }
             break;
          case 21:                  /* tiara */
             if (chklvl(10)) {
                glvutl();
                msgutl2(LV10M0,LVL9M1);
             }
             break;
          default:
             msgutl2(OFFER0,OFFER1);
          }
          return(0);
       }
    }
    if (margc > 1
         && sameas(margv[0],"chant")
         && sameas(margv[1],"tashanna")) {
       btuxmt(usrnum,"...Done.\r");
       prf("***\rThe altar ");
       if (!chantd) {
          prf("begins to glow dimly.\r");
       }
       else {
          prf("glows even brighter!\r");
       }
       sndloc(7);
       chantd++;
       return(0);
    }
    rstrin();
    stg=getmsg(TEMPLE);                           /* LEVEL4 string option */
    if (margc > 1 && sameas(margv[1],stg)) {
       if (chklvl(3)) {
          glvutl();
          msgutl2(LVL300,GETLVL);
       }
       return(0);
    }
    parsin();
    if (sameas(margv[0],"pray") || sameas(margv[0],"meditate")) {
       prfmsg(TMPRAY);
       outprf(usrnum);
       sndutl("praying to the Goddess Tashanna.");
       return(0);
    }
    if (sameas(margv[0],"marry")
        || sameas(margv[0],"wed")) {
       if (findgp(margv[1])) {
          if (PlayPtr->flags&MARRYD) {
             prfmsg(MARRY0,PlayPtr->spouse);
             outprf(usrnum);
             prfmsg(MARRY1,PlayPtr->altnam);
             sndoth();
          }
          else if (PlayPtr == OthPtr) {
             msgutl2(MARRY2,MARRY3);
          }
          else {
             PlayPtr->flags|=MARRYD;
             strcpy(PlayPtr->spouse,OthPtr->alias);
             prfmsg(MARRY4,OthPtr->alias);
             outprf(usrnum);
             prfmsg(MARRY5,PlayPtr->altnam,hisher(PlayPtr));
             outprf(OthPtr->modno);
             prfmsg(MARRY6,PlayPtr->altnam,hisher(PlayPtr),OthPtr->altnam);
             sndbt2();
          }
       }
       else {
          msgutl2(MARRY7,MARRY8);
       }
       return(0);
    }
    if (margc > 2 && sameas(margv[0],"offer")
        && (sameas(margv[2],"gold") || sameas(margv[2],"pieces"))) {
       if ((gold=atoi(margv[1])) > PlayPtr->gold || gold <= 0) {
          prfmsg(CHEAPO);
          outprf(usrnum);
          sndutl("looking somewhat cheap.");
       }
       else {
          if (!hasmkey(KYRKEY)) {
             msgutl2(NPAY02,NPAY03);
             PlayPtr->gold-=gold;
          }
          else if (!givrcrd) {
             prfmsg(NOGTCR);
             outprf(usrnum);
             prfmsg(OGETCR,PlayPtr->altnam);
             sndoth();
             PlayPtr->gold-=gold;
          }
          else {
             prfmsg(UGETCR,gold);
             outprf(usrnum);
             prfmsg(OGETCR,PlayPtr->altnam);
             sndoth();
             PlayPtr->gold-=gold;
             crdusr(usaptr->userid,l2as((long)gold),0,0);
             shocst("KYRANDIA","GAME CREDITED: %-9s %d Cr.",usaptr->userid,gold);
          }
       }
       return(0);
    }
    return(1);
}

int
vhealr(void)                       /* healer room specific command handling*/
{
    int max;

    gi_bagthe();
    if (margc > 1 && sameas(margv[0],"offer")) {
       if (sameto(margv[1],"rose")) {
          if ((objptr=fgmpobj(margv[1])) != NULL) {
             tgmpobj(objno);
             prfmsg(TAKROS);
             outprf(usrnum);
             PlayPtr->hitpts+=10;
             if (PlayPtr->hitpts > (max=(PlayPtr->level*4))) {
                PlayPtr->hitpts=max;
             }
          }
          else {
             msgutl2(NOHAVE,NOROSE);
          }
          return(0);
       }
       prfmsg(NOGOOD);
       outprf(usrnum);
       return(0);
    }
    return(1);
}

struct binwrd digwrds[4]={
     {"dig",   NULL},
     {"hunt",  NULL},
     {"look",  NULL},
     {"search",NULL}
};

int
gquest(void)                  /* brook room specific command handling */
{
    int find;

    gi_bagthe();
    bagprep();
    if ((wrdptr=binchk(margv[0],digwrds,4)) != NULL) {
       if (margc > 1
           && sameas(margv[1],"gold")
           || sameas(margv[1],"brook")
           || sameas(margv[1],"water")
           || sameas(margv[1],"stream")) {
          sndutl("searching the brook for something.");
          if ((find=genrdn(2,102)) < 10 && PlayPtr->gold < 101) {
             prfmsg(FNDGOL,find);
             outprf(usrnum);
             PlayPtr->gold+=(unsigned)find;
          }
          else {
             prfmsg(NOFNDG);
             outprf(usrnum);
          }
          return(0);
       }
    }
    if (drkutl() || rosutl()) {
       return(0);
    }
    return(1);
}

int
terrac(void)                       /* terrace room specific command handler*/
{
    if (drkutl()) {
       return(0);
    }
    return(1);
}

int
waterf(void)
{
    if (drkutl() || rosutl()) {
       return(0);
    }
    return(1);
}

struct binwrd getwrds[4]={
     {"get", NULL},
     {"grab",NULL},
     {"pick",NULL},
     {"take",NULL}
};

int
gpcone(void)
{
    gi_bagthe();
    if ((wrdptr=binchk(margv[0],getwrds,4)) != NULL) {
       if (margc > 1 && sameto(margv[1],"pinecone")) {
          if ((genrdn(0,100)) < 40 && PlayPtr->npobjs < MXPOBS) {
             pgmpobj(&Objects[32],0);      /* pinecone */
             msgutl2(PINEC0,PINEC1);
          }
          else {
             msgutl2(PINEC2,PINEC3);
          }
          return(0);
       }
    }
    return(1);
}

struct binwrd drpwrds[5]={
     {"drop",  NULL},
     {"insert",NULL},
     {"put",   NULL},
     {"stick", NULL},
     {"thrust",NULL}
};

int
stumpr(void)
{
    int obj;

    gi_bagthe();
    if ((wrdptr=binchk(margv[0],drpwrds,5)) != NULL) {
       if ((objptr=fgmpobj(margv[1])) != NULL) {
          obj=(int)(objptr-Objects);
          tgmpobj(objno);
          if (PlayPtr->level == 5) {
             if (PlayPtr->stumpi == obj) {
                PlayPtr->stumpi++;
                if (PlayPtr->stumpi == 12) {
                   if (chklvl(6)) {
                      glvutl();
                      PlayPtr->offspls|=SBD032;
                      msgutl2(BGEM00,BGEM01);
                   }
                   else {
                      PlayPtr->stumpi=0;
                   }
                }
                else {
                   msgutl2(BGEM02,BGEM03);
                }
             }
             else {
                msgutl2(BGEM04,BGEM03);
             }
          }
          else {
             msgutl2(BGEM04,BGEM03);
          }
       }
       else {
          msgutl2(BGEM05,BGEM06);
       }
       return(0);
    }
    return(1);
}

int
silver(void)
{
    int obj;

    gi_bagthe();
    if (sameas(margv[0],"offer")) {
       if ((objptr=fgmpobj(margv[1])) != NULL) {
          obj=(int)(objptr-Objects);
          tgmpobj(objno);
          if (PlayPtr->gemidx < 4
               && obj == PlayPtr->stones[PlayPtr->gemidx]) {
             PlayPtr->gemidx++;
             if (PlayPtr->gemidx == 4) {
                if (chklvl(4)) {
                   glvutl();
                   PlayPtr->defspls|=SBD033;
                   msgutl2(SILVM0,SILVM1);
                }
                else {
                   PlayPtr->gemidx=0;
                }
             }
             else {
                msgutl2(SILVM2,SILVM3);
             }
          }
          else {
             msgutl2(SILVM4,SILVM3);
          }
       }
       else {
          msgutl2(TRDM05,SILVM5);
       }
       return(0);
    }
    if (sameas(margv[0],"pray") || sameas(margv[0],"meditate")) {
       prfmsg(SAPRAY);
       outprf(usrnum);
       sndutl("praying to the Goddess Tashanna.");
       return(0);
    }
    return(1);
}

int
rubies(void)
{
    gi_bagthe();
    if ((wrdptr=binchk(margv[0],getwrds,4)) != NULL) {
       if (margc > 1 && sameas(margv[1],"ruby")) {
          if ((genrdn(0,100)) < 20 && PlayPtr->npobjs < MXPOBS) {
             pgmpobj(&Objects[0],0);
             msgutl2(RUBY00,RUBY01);
          }
          else {
             msgutl2(RUBY02,RUBY03);
             OthPtr=PlayPtr;
             hitoth(8);
          }
          return(0);
       }
    }
    return(1);
}

int
druids(void)
{
    static long dspells[5]={
         SBD010,SBD018,SBD019,SBD021,SBD030
    };
    int i;

    gi_bagthe();
    if (margc > 2
        && sameas(margv[0],"touch")
        && sameas(margv[1],"orb")
        && sameas(margv[3],"sceptre")) {
       if ((objptr=fgmpobj(margv[3])) != NULL) {
          tgmpobj(objno);
          i=genrdn(0,5);
          PlayPtr->offspls|=(dspells[i]);
          msgutl2(DRUID0,DRUID1);
       }
       else {
          msgutl2(DRUID2,DRUID1);
       }
       return(0);
    }
    return(1);
}

int
fthick(void)
{
    gi_bagthe();
    bagprep();
    bagwrd("flaming");
    if (margc > 1 && sameas(margv[0],"walk") && sameas(margv[1],"thicket")) {
       btuxmt(usrnum,"...Ouch!\r");
       sndutl("burning in the flaming thicket!");
       OthPtr=PlayPtr;
       hitoth(10);
       return(0);
    }
    return(1);
}

int
fearno(void)
{
    char *stg;

    rstrin();
    stg=getmsg(EGLADE);             /* LEVEL4 string option */
    if (sameas(margv[0],stg)) {
       if (chklvl(5)) {
          glvutl();
          msgutl2(FEAR01,FEAR02);
       }
       return(0);
    }
    parsin();
    return(1);
}

extern
int rockpr;

int
swrock(void)
{
    gi_bagthe();
    bagprep();
    if (sameas(margv[0],"pray")) {
         btuxmt(usrnum,"...Your prayers are heard.\r");
       prf("***\rThe mists around the rock begin to swirl magically!\r");
       sndloc(27);
       rockpr++;
    }
    if ((wrdptr=binchk(margv[0],drpwrds,5)) != NULL) {
       if (margc > 2
           && sameto(margv[1],"sword")
           && sameto(margv[2],"rock")
           && rockpr) {
          if ((objptr=fgmpobj(margv[1])) != NULL) {
             tgmpobj(objno);
             pgmpobj(&Objects[21],0);
             msgutl2(ROCK00,ROCK01);
          }
          else {
             msgutl2(ROCK02,ROCK01);
          }
          return(0);
       }
    }
    return(1);
}

int
ashtre(void)
{
    gi_bagthe();
    bagprep();
    if (sameas(margv[0],"cry")
        || sameas(margv[0],"weep")) {
       if (margc > 1
            && (sameto(margv[1],"trees")
                || sameto(margv[1],"ashes"))) {
          msgutl2(ASHM00,ASHM01);
          if (CurLoc->nlobjs < MXLOBS) {
             pgmlobj(&Objects[43]);
          }
          else {
             prfmsg(ASHM02);
             sndloc(PlayPtr->gamloc);
          }
          return(0);
       }
    }
    return(1);
}

int
spring(void)
{
    if (drkutl() || rosutl()) {
       return(0);
    }
    return(1);
}

int
rosutl(void)
{
    if ((wrdptr=binchk(margv[0],getwrds,4)) != NULL) {
       if (margc > 1 && sameas(margv[1],"rose")) {
          if (PlayPtr->npobjs >= MXPOBS) {
             msgutl2(GROSE3,GROSE4);
          }
          else {
             pgmpobj(&Objects[40],0);
             msgutl2(GROSE1,GROSE2);
          }
          return(1);
       }
    }
    return(0);
}

struct binwrd toswrds[3]={
     {"drop", NULL},
     {"throw",NULL},
     {"toss", NULL}
};

int
magicf(void)
{
    int var,sloc;
    static int scroll,shard;
    char *stg;

    rstrin();
    stg=getmsg(FOUNTI);             /* LEVEL4 string option */
    if (sameas(margv[0],stg)) {
       btuxmt(usrnum,"...The Goddess blesses you.\r");
       PlayPtr->flags|=BLESSD;
       return(0);
    }
    parsin();
    gi_bagthe();
    if ((wrdptr=binchk(margv[0],toswrds,3)) != NULL) {
       if ((objptr=fgmpobj(margv[1])) != NULL) {
          if (margc > 3 && sameas(margv[3],"fountain")) {
             tgmpobj(objno);
             var=(int)(objptr-Objects);
             switch (var) {
             case 32:                         /* pinecone */
                if (PlayPtr->flags&BLESSD) {
                   scroll++;
                }
                if (scroll == 3) {
                   scroll=0;
                   sloc=genrdn(0,168);
                   if (LocArr[sloc].nlobjs < MXLOBS) {
                      putlobj(&LocArr[sloc],&Objects[35]);  /* scroll */
                   }
                   msgutl2(MAGF00,MAGF01);
                }
                else {
                   msgutl2(MAGF04,MAGF07);
                }
                break;
             case 43:                          /* shard */
                shard++;
                if (shard == 6) {
                   shard=0;
                   pgmpobj(&Objects[16],0);     /* amulet */
                   msgutl2(MAGF05,MAGF03);
                }
                else {
                   msgutl2(MAGF06,MAGF03);
                }
                break;
             default:
                msgutl2(MAGF02,MAGF03);
             }
             return(0);
          }
       }
    }
    if (drkutl()) {
       return(0);
    }
    return(1);
}

int
hnsrou(void)
{
    if (margc && sameas(margv[0],"offer")) {
       if (margc > 3
            && sameas(margv[1],"heart")
            && sameas(margv[3],"soul")) {
          if (sameas(margv[5],"tashanna")) {
             if (chklvl(7)) {
                glvutl();
                PlayPtr->othspls|=SBD062;
                msgutl2(HNSYOU,HNSOTH);
             }
             return(0);
          }
       }
    }
    return(1);
}

int
tashas(void)
{
    gi_bagthe();
    if (margc > 1 && sameas(margv[0],"imagine")
        && sameas(margv[1],"dagger")) {
       if (PlayPtr->npobjs < MXPOBS) {
          pgmpobj(&Objects[33],0);
          msgutl2(DAGM00,DAGM01);
       }
       else {
          msgutl2(DAGM02,DAGM01);
       }
       return(0);
    }
    bagprep();
    if ((wrdptr=binchk(margv[0],seewrds,3)) != NULL
          && sameas(margv[1],"statue")) {
       msgutl2(DAGM03,DAGM04);
       return(0);
    }
    return(1);
}

int
refpoo(void)
{
    gi_bagthe();
    bagprep();
    if ((wrdptr=binchk(margv[0],toswrds,3)) != NULL && margc > 2
         && sameas(margv[2],"pool")) {
       if (sameas(margv[1],"dagger") && (objptr=fgmpobj(margv[1])) != NULL) {
          tgmpobj(objno);
          pgmpobj(&Objects[34],0);
          msgutl2(REFM00,REFM01);
       }
       else {
          msgutl2(REFM02,REFM01);
       }
       return(0);
    }
    if ((wrdptr=binchk(margv[0],seewrds,3)) != NULL && margc > 1
         && sameas(margv[1],"pool")) {
       msgutl2(REFM03,REFM04);
       return(0);
    }
    return(1);
}

struct binwrd saywrds[3]={
     {"say",  NULL},
     {"speak",NULL},
     {"state",NULL}
};

int
panthe(void)
{
    if ((wrdptr=binchk(margv[0],saywrds,3)) != NULL) {
       if (margc == 13
           && sameas(margv[1],"legends")
           && sameas(margv[4],"time")
           && sameas(margv[8],"true")
           && sameas(margv[11],"never")
           && sameas(margv[12],"die")) {
          if (PlayPtr->npobjs < MXPOBS) {
             pgmpobj(&Objects[14],0);
             msgutl2(PANM00,PANM01);
          }
          else {
             msgutl2(PANM02,PANM01);
          }
          return(0);
       }
    }
    gi_bagthe();
    bagprep();
    if ((wrdptr=binchk(margv[0],seewrds,3)) != NULL) {
       if (sameto(margv[1],"symbols")
           || sameto(margv[1],"pillars")) {
          msgutl2(PANM03,PANM04);
          return(0);
       }
    }
    return(1);
}

int
portal(void)
{
    int i;

    gi_bagthe();
    if (margc > 1
         && sameas(margv[0],"enter")
         && sameto(margv[1],"portal")) {
       i=genrdn(1,10);
       prfmsg(PORTAL);
       prfmsg(PORTAL+i);
       prfmsg(ENDPOR);
       outprf(usrnum);
       prfmsg(OEPORT,PlayPtr->altnam,kheshe(PlayPtr));
       sndoth();
       return(0);
    }
    return(1);
}

extern
int sesame;

int
waller(void)
{
    gi_bagthe();
    bagprep();
    if (margc > 2
         && (wrdptr=binchk(margv[0],drpwrds,5)) != NULL
         && sameas(margv[2],"crevice")) {
       if (sameas(margv[1],"key")
            && (objptr=fgmpobj(margv[1])) != NULL
            && sesame) {
          tgmpobj(objno);
          prfmsg(WALM00);
          remvgp(PlayPtr,"vanished in a golden flash of light");
          entrgp(186,PlayPtr,"appeared in a golden flash of light");
       }
       else {
          msgutl2(WALM01,WALM02);
       }
       return(0);
    }
    if (sameas(margv[0],"chant") || sameas(margv[1],"opensesame")) {
       sesame=1;
       msgutl2(WALM03,WALM04);
       return(0);
    }
    return(1);
}

int
slotma(void)
{
    int objidx;

    gi_bagthe();
    bagprep();
    if (margc > 2
        && (wrdptr=binchk(margv[0],drpwrds,5)) != NULL
        && sameas(margv[2],"slot")) {
       if (sameas(margv[1],"garnet")
           && (objptr=fgmpobj(margv[1])) != NULL) {
          tgmpobj(objno);
          if ((genrdn(1,11)) < 3) {
             objidx=genrdn(0,12);
             pgmpobj(&Objects[objidx],0);
             msgutl2(SLOT00,SLOT01);
             prfmsg(SLOT02,dobutl(&Objects[objidx]));
             outprf(usrnum);
          }
          else {
             msgutl2(SLOT03,SLOT04);
          }
          return(0);
       }
    }
    return(1);
}

int
mistyr(void)
{
    gi_bagthe();
    if (sameas(margv[0],"touch")
        || sameas(margv[0],"get")) {
       if (sameas(margv[1],"orb")) {
          prfmsg(MISM00);
          outprf(usrnum);
          remvgp(PlayPtr,"vanished in a bright blue flash");
          entrgp(34,PlayPtr,"appeared in a bright blue flash");
          return(0);
       }
    }
    if (sameas(margv[0],"think")
         || sameas(margv[0],"concentrate")
         || sameas(margv[0],"meditate")) {
       if (sameas(margv[1],"orb")
           || sameas(margv[2],"orb")) {
          if (PlayPtr->npobjs < MXPOBS) {
             pgmpobj(&Objects[18],0);
             msgutl2(MISM01,MISM02);
          }
          else {
             msgutl2(MISM03,MISM02);
          }
          return(0);
       }
    }
    bagprep();
    if (margc > 2
         && (wrdptr=binchk(margv[0],drpwrds,5)) != NULL
         && sameas(margv[2],"orb")) {
       if (sameas(margv[1],"dagger")
           && (objptr=fgmpobj(margv[1])) != NULL) {
          if (chklvl(8)) {
             tgmpobj(objno);
             glvutl();
             msgutl2(MISM04,MISM05);
          }
          return(0);
       }
    }
    return(1);
}

int
sanman(void)
{
    gi_bagthe();
    bagprep();
    if ((wrdptr=binchk(margv[0],digwrds,4)) != NULL) {
       if (sameas(margv[1],"sand")) {
          if ((genrdn(0,100)) < 10) {
             PlayPtr->gold++;
             msgutl2(SANM00,SANM01);
          }
          else {
             msgutl2(SANM02,SANM01);
          }
          return(0);
       }
    }
    return(1);
}

int
tulips(void)
{
    gi_bagthe();
    if ((wrdptr=binchk(margv[0],getwrds,4)) != NULL
         && sameas(margv[1],"tulip")) {
       if (PlayPtr->npobjs < MXPOBS) {
          pgmpobj(&Objects[44],0);
          msgutl2(TULM00,TULM01);
       }
       else {
          msgutl2(TULM02,TULM01);
       }
       return(0);
    }
    return(1);
}

int
crystt(void)
{
    gi_bagthe();
    bagprep();
    bagwrd("crystal");
    if (sameas(margv[0],"aim")
        && sameas(margv[2],"tree")) {
       if (sameas(margv[1],"wand")
           && (objptr=fgmpobj(margv[1])) != NULL) {
          if (chklvl(11)) {
             glvutl();
             msgutl2(CTREM0,CTREM1);
          }
          return(0);
       }
    }
    return(1);
}

int
rainbo(void)
{
    gi_bagthe();
    if (sameas(margv[0],"break")) {
       if (sameto(margv[1],"wand")
           && (objptr=fgmpobj("wand")) != NULL) {
          tgmpobj(objno);
          if (PlayPtr->flags&GOTKYG) {
             msgutl2(RABOM0,RABOM1);
          }
          else {
             msgutl2(RABOM2,RABOM3);
             pgmpobj(&Objects[29],0);  /* kyragem */
             PlayPtr->flags|=GOTKYG;
          }
          return(0);
       }
    }
    return(1);
}

int
sunshi(void)
{
    gi_bagthe();
    bagprep();
    if (sameas(margv[0],"cast")) {
       if (sameas(margv[1],"zapher")) {
          if (sameas(margv[2],"tulip")
               && (objptr=fgmpobj("tulip")) != NULL) {
             tgmpobj(objno);
             pgmpobj(&Objects[26],0);     /* wand */
             msgutl2(SUNM00,SUNM01);
             return(0);
          }
       }
       if (sameas(margv[1],"zennyra")) {
          msgutl2(SUNM02,SUNM01);
          return(0);
       }
    }
    if (sameas(margv[0],"offer")) {
       if (sameas(margv[1],"kyragem")
            && (objptr=fgmpobj(margv[1])) != NULL) {
          if (chklvl(12)) {
             glvutl();
             msgutl2(SUNM03,SUNM04);
          }
          return(0);
       }
    }
    return(1);
}

int
demong(void)
{
    gi_bagthe();
    bagprep();
    if ((wrdptr=binchk(margv[0],drpwrds,5)) != NULL) {
       if (sameas(margv[1],"soulstone")
            && (objptr=fgmpobj("soulstone")) != NULL) {
          if (sameas(margv[2],"niche")) {
             prfmsg(SOUKEY);
             outprf(usrnum);
             remvgp(PlayPtr,"vanished through the demon gate");
             entrgp(219,PlayPtr,"appeared in a column of blue flame");
             return(0);
          }
       }
    }
    return(1);
}

int
bodyma(void)
{
    gi_bagthe();
    bagwrd("across");
    if (margc > 1
        && (sameas(margv[0],"jump")
            || sameas(margv[0],"leap"))) {
       if (sameas(margv[1],"chasm")) {
          if (PlayPtr->charms[OBJPRO]) {
             if (chklvl(13)) {
                msgutl2(BODM01,BODM02);
                if (PlayPtr->npobjs == MXPOBS) {
                   tgmpobj(0);
                   prfmsg(BODM03);
                   outprf(usrnum);
                }
                pgmpobj(&Objects[23],0);
                glvutl();
             }
          }
          else {
             msgutl2(BODM04,BODM05);
             OthPtr=PlayPtr;
             hitoth(100);
          }
          return(0);
       }
    }
    return(1);
}

int
mindma(void)
{
    if (sameas(margv[0],"answer")
        && sameas(margv[1],"time")) {
       if (chklvl(14)) {
          msgutl2(MINM01,MINM02);
          if (PlayPtr->npobjs == MXPOBS) {
             tgmpobj(0);
             prfmsg(MINM03);
             outprf(usrnum);
          }
          pgmpobj(&Objects[17],0);    /* pendant */
          glvutl();
       }
       return(0);
    }
    return(1);
}

int
heartm(void)
{
    bagprep();
    if (margc == 3
        && sameas(margv[0],"offer")
        && sameas(margv[1],"heart")) {
       if (sameas(margv[2],PlayPtr->spouse)) {
          if (chklvl(15)) {
             msgutl2(HEAR01,HEAR02);
             if (PlayPtr->npobjs == MXPOBS) {
                tgmpobj(0);
                prfmsg(HEAR03);
                outprf(usrnum);
             }
             pgmpobj(&Objects[15],0);
             glvutl();
          }
          return(0);
       }
    }
    return(1);
}

int
soulma(void)
{
    if (sameas(margv[0],"ignore")
        && sameas(margv[1],"time")) {
       if (chklvl(16)) {
          msgutl2(SOUL01,SOUL02);
          if (PlayPtr->npobjs == MXPOBS) {
             tgmpobj(0);
             prfmsg(SOUL03);
             outprf(usrnum);
          }
          pgmpobj(&Objects[39],0);       /* ring */
          glvutl();
       }
       return(0);
    }
    return(1);
}

int
devote(void)
{
    if (sameas(margv[0],"devote")) {
       if (chklvl(17)) {
          if (fouris()) {
             msgutl2(DEVM01,DEVM02);
             glvutl();
          }
          else {
             msgutl2(DEVM03,DEVM04);
          }
       }
       return(0);
    }
    return(1);
}

int
truthy(void)
{
    gi_bagthe();
    if (sameas(margv[0],"seek")
        && sameas(margv[1],"truth")) {
       if (chklvl(18)) {
          if (genrdn(0,100) < 50) {
             prfmsg(TRUM01);
             outprf(usrnum);
             OthPtr=PlayPtr;
             hitoth(100);
          }
          else {
             msgutl2(TRUM02,TRUM03);
             glvutl();
          }
       }
       return(0);
    }
    return(1);
}

int
fouris(void)
{
    if ((objptr=fgmpobj("broach")) == NULL) {
       return(0);
    }
    if ((objptr=fgmpobj("pendant")) == NULL) {
       return(0);
    }
    if ((objptr=fgmpobj("locket")) == NULL) {
       return(0);
    }
    if ((objptr=fgmpobj("ring")) == NULL) {
       return(0);
    }
    fgmpobj("broach");
    tgmpobj(objno);
    fgmpobj("pendant");
    tgmpobj(objno);
    fgmpobj("locket");
    tgmpobj(objno);
    fgmpobj("ring");
    tgmpobj(objno);
    return(1);
}

int
singer(void)
{
    if (sameas(margv[0],"sing")
         || sameas(margv[0],"hum")
         || sameas(margv[0],"whistle")) {
       if (chklvl(19)) {
          msgutl2(LEVL19,LVL9M1);
          glvutl();
       }
       return(0);
    }
    return(1);
}

int
forgtr(void)
{
    if (sameas(margv[0],"forget")) {
       if (chklvl(20)) {
          msgutl2(LEVL20,LVL9M1);
          glvutl();
       }
       return(0);
    }
    return(1);
}

int
oflove(void)
{
    if (sameas(margv[0],"offer")
        && (sameas(margv[1],"love")
            || sameas(margv[2],"love"))) {
       if (chklvl(22)) {
          msgutl2(LEVL22,LVL9M1);
          glvutl();
       }
       return(0);
    }
    return(1);
}

int
believ(void)
{
    if (sameas(margv[0],"believe")
         && sameas(margv[1],"in")
         && sameas(margv[2],"magic")) {
       if (chklvl(21)) {
          msgutl2(LEVL21,LVL9M1);
          glvutl();
       }
       return(0);
    }
    return(1);
}

int
philos(void)
{
    if (sameas(margv[0],"wonder")
        || sameas(margv[0],"consider")) {
       if (chklvl(23)) {
          msgutl2(LEVL23,LVL9M1);
          glvutl();
       }
       return(0);
    }
    return(1);
}

int
fanbel(void)
{
    char *stg;

    rstrin();
    stg=getmsg(BELINF);              /* LEVEL4 string option */
    if (sameas(margv[0],stg)) {
       if (chklvl(24)) {
          msgutl2(LEVL24,LVL9M1);
          glvutl();
       }
       return(0);
    }
    parsin();
    return(1);
}

extern
int zloc;

int
wingam(void)
{
    char *stg;

    if (sameas(margv[0],"answer") && zloc == 302) {
       rstrin();
       stg=getmsg(RIDDLE);               /* LEVEL4 string option */
       if (sameas(stg,margv[1])) {
          if (chklvl(25)) {
             shocst("KYRANDIA","%s COMPLETED KYRANDIA!",usaptr->userid);
             msgutl2(YOUWIN,SHEWON);
             glvutl();
          }
          return(0);
       }
    }
    return(1);
}

STATIC int
drkutl(void)
{
    gi_bagthe();
    if (margc && sameas(margv[0],"drink")
         && sameas(margv[1],"water")) {
       msgutl2(DRINK0,DRINK1);
       return(1);
    }
    return(0);
}

STATIC int
chklvl(                     /* can player move to this level? */
int level)
{
    if (PlayPtr->level == (level-1)) {
       if (!hasmkey(KYRKEY)) {
          msgutl2(NPAY00,NPAY01);
          return(0);
       }
       return(1);
    }
    if (PlayPtr->level >= level) {
       msgutl2(LVLM00,LVLM01);
    }
    else {
       msgutl2(LVLM02,LVLM03);
    }
    return(0);
}

STATIC void
glvutl(void)                /* increment player level */
{
    PlayPtr->level++;
    PlayPtr->pdescr++;
    PlayPtr->hitpts+=4;
    PlayPtr->spts+=2;
}

