'****************************************************************************
'*                                                                          *
'*  TAGMSG.BAS                                                              *
'*                                                                          *
'*  Copyright (c) 1994-1997 Galacticomm, Inc.    All Rights Reserved.        *
'*                                                                          *
'*  Functions for tagging/getting messages and threads                      *
'*                                                                          *
'*                                                  - J. Alvrus  10/23/95   *
'*                                                                          *
'****************************************************************************

Option Explicit

Type tagstruct                      ' tagged message structure
    id As Long                      '   message ID
    forum As Integer                '   forum ID
End Type

Type tagxrefs                       ' forum ID to name crossref
    forum As Integer                '   forum ID
    fornam As String * FORNSZ       '   forum name
End Type

Dim tagdthrs() As tagstruct
Dim tagdmsgs() As tagstruct
Dim untagdmsgs() As tagstruct
Dim tagxref() As tagxrefs
Dim ttinited As Integer             ' any memory for tagdthrs() alloc'ed?
Dim tminited As Integer             ' any memory for tagdmsgs() alloc'ed?
Dim utminited As Integer            ' any memory for untagdmsgs() alloc'ed?
Dim tagxrefinited As Integer        ' any memory for tagxref alloc'ed?

Private Sub add2lst (ByVal id As Long, taglist() As tagstruct, inited As Integer, ByVal forum As Integer)
' add an ID to list utility
' id:       message or thread ID to add
' taglist:  tag array
' inited:   True if taglist() has been ReDim'd
' forum:    forum ID message or thread is in

    If inited Then
        ReDim Preserve taglist(UBound(taglist) + 1)
    Else
        ReDim taglist(0)
        inited = True
    End If
    taglist(UBound(taglist)).id = id
    taglist(UBound(taglist)).forum = forum
End Sub

Function addtagxref (ByVal fornam As String) As Integer
' create a forum name/ID cross reference
' fornam:   name of forum to create crossref for
' returns forum ID if already exists or able to add, EMLID if not

    Dim i As Integer, j As Integer, comp As Integer, forum As Integer
    Dim forinf As foruminf

    i = nearforum(comp, fornam)
    If i >= 0 And comp = 0 Then
        addtagxref = tagxref(i).forum
        Exit Function
    End If
    addtagxref = EMLID
    Do
        If getforinf(forinf, fornam) Then
            forum = forinf.forum
            Exit Do
        ElseIf connected() Then
            Exit Function
        ElseIf Not appconnect() Then
            Exit Function
        End If
    Loop
    If i < 0 Then
        i = 0
        ReDim tagxref(0)
        tagxrefinited = True
    Else
        ReDim Preserve tagxref(UBound(tagxref) + 1)
        If comp > 0 Then
            i = i + 1
        End If
    End If
    For j = UBound(tagxref) To i + 1 Step -1
        tagxref(j) = tagxref(j - 1)
    Next
    tagxref(i).forum = forum
    tagxref(i).fornam = fornam
    addtagxref = forum
End Function

Function anytagged () As Integer
' are there any tagged messages or threads?

    anytagged = ttinited Or tminited
End Function

Sub clrtags ()
' clear all tagged messages and threads

    Erase tagdthrs
    ttinited = False
    Erase tagdmsgs
    tminited = False
    Erase untagdmsgs
    utminited = False
End Sub

Function for2get (forum As Integer, fornam As String) As Integer
' get next forum with tagged messages/threads
' forum:    forum ID of next forum
' fornam:   name of next forum
' returns True if there is another forum with tagged messages/threads

    If tagxrefinited Then
        forum = tagxref(0).forum
        fornam = Trim$(tagxref(0).fornam)
        for2get = True
    Else
        for2get = False
    End If
End Function

Function fornam2id (ByVal fornam As String) As Integer
' get a forum ID given the name
' returns 0 if not in cross reference array

    Dim i As Integer, comp As Integer

    fornam2id = 0
    i = nearforum(comp, fornam)
    If i >= 0 And comp = 0 Then
        fornam2id = tagxref(i).forum
    End If
End Function

Sub gotmsg (ByVal msgid As Long, ByVal forum As Integer)
' got a message, remove it from tag list

    rmvfmlst msgid, tagdmsgs(), tminited, forum
End Sub

Function id2fornam (ByVal forum As Integer) As String
' get the forum name given the forum ID

    Dim i As Integer

    id2fornam = ""
    If tagxrefinited Then
        For i = 0 To UBound(tagxref)
            If tagxref(i).forum = forum Then
                id2fornam = Trim$(tagxref(i).fornam)
                Exit Function
            End If
        Next
    End If
End Function

Private Function inlist (ByVal id As Long, taglist() As tagstruct, ByVal inited As Integer, ByVal forum As Integer) As Integer
' find a given ID is in a given tag list
' id:       message or thread ID to add
' taglist:  tag array
' inited:   True if taglist() has been ReDim'd
' forum:    forum ID message or thread is in
' returns index if found or -1 if not found

    Dim i As Integer

    If inited Then
        For i = 0 To UBound(taglist)
            If taglist(i).id = id And taglist(i).forum = forum Then
                inlist = i
                Exit Function
            End If
        Next i
    End If
    inlist = -1
End Function

Private Sub lowrmvlst (ByVal idx As Integer, taglist() As tagstruct, inited As Integer)
' low-level remove-tag-from-list utility
' idx:      index of element to remove
' taglist:  array to remove from
' inited:   taglist ReDim'd flag

    Dim i As Integer

    If UBound(taglist) = 0 Then
        Erase taglist
        inited = False
    Else
        For i = idx To UBound(taglist) - 1
            taglist(i) = taglist(i + 1)
        Next
        ReDim Preserve taglist(UBound(taglist) - 1)
    End If
End Sub

Function msg2get (ByVal forum As Integer, msgid As Long) As Integer
' get message ID of next tagged message to get in a given forum
' forum:    forum ID of in which forum to look for messages
' msgid:    message ID of next tagged message
' returns True if a tagged message was found

    Dim i As Integer

    If tminited Then
        For i = 0 To UBound(tagdmsgs)
            If tagdmsgs(i).forum = forum Then
                msgid = tagdmsgs(i).id
                msg2get = True
                Exit Function
            End If
        Next
    End If
    msg2get = False
End Function

Function msgtagged (ByVal msgid As Long, ByVal thrid As Long, ByVal forum As Integer) As Integer
' is the specified message tagged?

    If inlist(msgid, untagdmsgs(), utminited, forum) <> -1 Then
        msgtagged = False
    ElseIf inlist(msgid, tagdmsgs(), tminited, forum) <> -1 Then
        msgtagged = True
    ElseIf inlist(thrid, tagdthrs(), ttinited, forum) <> -1 Then
        msgtagged = True
    Else
        msgtagged = False
    End If
End Function

Private Function nearforum (comp As Integer, ByVal fornam As String) As Integer
' find index of nearest forum in tagxref array
' comp:     result of last name comparison (<0 if fornam < array, >0 if fornam > array, =0 if fornam = array)
' fornam:   forum name to search for
' returns index of nearest cross reference or -1 if there are no cross references

    Dim lo As Integer, md As Integer, hi As Integer

    md = -1
    If tagxrefinited Then
        lo = 0
        hi = UBound(tagxref)
        Do While lo <= hi
            md = lo + Int((hi - lo) / 2)
            comp = stricmp(fornam, Trim$(tagxref(md).fornam))
            If comp > 0 Then
                lo = md + 1
            ElseIf comp < 0 Then
                hi = md - 1
            Else
                Exit Do
            End If
        Loop
    End If
    nearforum = md
End Function

Function ntagdmsgs () As Integer
' returns number of explicitly tagged messages

    If Not tminited Then
        ntagdmsgs = 0
    Else
        ntagdmsgs = UBound(tagdmsgs) + 1
    End If
End Function

Private Sub rmvfmlst (ByVal id As Long, taglist() As tagstruct, inited As Integer, ByVal forum As Integer)
' remove given message/thread ID from given list

    Dim i As Integer

    i = inlist(id, taglist(), inited, forum)
    If i >= 0 Then
        lowrmvlst i, taglist(), inited
    End If
End Sub

Sub tagmsg (ByVal msgid As Long, ByVal fornam As String)
' tag the given message

    Dim forum As Integer

    forum = addtagxref(Trim$(fornam))
    If forum <> EMLID Then
        rmvfmlst msgid, untagdmsgs(), utminited, forum
        add2lst msgid, tagdmsgs(), tminited, forum
    End If
End Sub

Sub tagthr (ByVal thrid As Long, ByVal fornam As String)
' tag the given thread

    Dim forum As Integer

    forum = addtagxref(Trim$(fornam))
    If forum <> EMLID Then
        add2lst thrid, tagdthrs(), ttinited, forum
    End If
End Sub

Function thr2get (ByVal forum As Integer, thrid As Long) As Integer
' get thread ID of the next tagged thread to get in a given forum
' forum:    forum ID of in which forum to look for messages
' thrid:    thread ID of next tagged thread
' returns True if a tagged thread was found

    Dim i As Integer

    If ttinited Then
        For i = 0 To UBound(tagdthrs)
            If tagdthrs(i).forum = forum Then
                thrid = tagdthrs(i).id
                thr2get = True
                Exit Function
            End If
        Next
    End If
    thr2get = False
End Function

Function thrtagged (ByVal thrid As Long, ByVal forum As Integer) As Integer
' is the given thread tagged?

    thrtagged = inlist(thrid, tagdthrs(), ttinited, forum) <> -1
End Function

Sub togglemsg (ByVal msgid As Long, ByVal thrid As Long, ByVal fornam As String)
' toggle the tag for the given message

    Dim forum As Integer

    forum = fornam2id(fornam)
    If msgtagged(msgid, thrid, forum) Then
        untagmsg msgid, fornam
    Else
        tagmsg msgid, fornam
    End If
End Sub

Sub togglethr (ByVal thrid As Long, ByVal fornam As String)
' toggle the tag for the given thread

    Dim forum As Integer

    forum = fornam2id(fornam)
    If thrtagged(thrid, forum) Then
        untagthr thrid, fornam
    Else
        tagthr thrid, fornam
    End If
End Sub

Sub untagfor (ByVal fornam As String)
' untag a forum
' fornam:   name of forum to untag
' Note: this does NOT untag all messages and threads in the forum

    Dim i As Integer, j As Integer, comp As Integer

    i = nearforum(comp, fornam)
    If i >= 0 And comp = 0 Then
        If UBound(tagxref) = 0 Then
            Erase tagxref
            tagxrefinited = False
        Else
            For j = i To UBound(tagxref) - 1
                tagxref(j) = tagxref(j + 1)
            Next
            ReDim Preserve tagxref(UBound(tagxref) - 1)
        End If
    End If
End Sub

Sub untagmsg (ByVal msgid As Long, ByVal fornam As String)
' untag a message

    Dim i As Integer, forum As Integer

    forum = fornam2id(fornam)
    If forum <> 0 Then
        i = inlist(msgid, tagdmsgs(), tminited, forum)
        If i < 0 Then
            add2lst msgid, untagdmsgs(), utminited, forum
        Else
            lowrmvlst i, tagdmsgs(), tminited
        End If
    End If
End Sub

Sub untagthr (ByVal thrid As Long, ByVal fornam As String)
' untag a thread

    Dim forum As Integer

    forum = fornam2id(fornam)
    If forum <> 0 Then
        rmvfmlst thrid, tagdthrs(), ttinited, forum
        If Not ttinited Then
            Erase untagdmsgs
            utminited = False
        End If
    End If
End Sub

