VERSION 2.00
Begin Form selfor
   BackColor       =   &H00C0C0C0&
   Caption         =   "Online Forums"
   ClientHeight    =   4755
   ClientLeft      =   1605
   ClientTop       =   2985
   ClientWidth     =   7560
   Height          =   5220
   HelpContextID   =   47
   Icon            =   0
   Left            =   1515
   MinButton       =   0   'False
   ScaleHeight     =   4755
   ScaleWidth      =   7560
   Top             =   2610
   Width           =   7740
   Begin SSOption foropt
      Caption         =   "All &Forums"
      Height          =   255
      Left            =   4920
      TabIndex        =   15
      Top             =   390
      Width           =   1275
   End
   Begin SSOption grpopt
      Caption         =   "Forum &Groups"
      Height          =   255
      Left            =   3300
      TabIndex        =   14
      Top             =   390
      Width           =   1575
   End
   Begin TextBox fornam
      Height          =   315
      Left            =   60
      TabIndex        =   0
      Top             =   360
      Width           =   2415
   End
   Begin SSList forlsts
      Prop47          =   SELFOR.FRX:0000
      AllowForPicture =   SELFOR.FRX:0037
      BorderStyle     =   1  'Fixed Single
      Case            =   0  'Unchanged
      DividerStyle    =   0  'None
      FixedHeight     =   17
      Font3D          =   0  'None
      Height          =   4035
      IntegralSize    =   0   'False
      Left            =   180
      ListStyle       =   0  '2D (BackColor used)
      MultiColumn     =   0   'False
      ReFreshOnUpdate =   -1  'True
      ScrollHorizontal=   0   'False
      ScrollVertical  =   -1  'True
      SelectionType   =   0  'Single
      ShadowColor     =   0  'Dark Grey
      Sorted          =   0   'False
      TabIndex        =   2
      Top             =   660
      Width           =   6195
      WndStyle        =   1151336785
   End
   Begin SSPanel butpic
      BevelOuter      =   0  'None
      ForeColor       =   &H00000000&
      Height          =   3060
      Left            =   6480
      TabIndex        =   3
      Top             =   660
      Width           =   960
      Begin CommandButton selbtn
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Select"
         Height          =   360
         Left            =   0
         TabIndex        =   6
         Top             =   900
         Width           =   960
      End
      Begin CommandButton clrbtn
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Clear"
         Height          =   360
         Left            =   0
         TabIndex        =   8
         Top             =   1740
         Width           =   960
      End
      Begin CommandButton allbtn
         BackColor       =   &H00C0C0C0&
         Caption         =   "&All"
         Height          =   360
         Left            =   0
         TabIndex        =   7
         Top             =   1320
         Width           =   960
      End
      Begin CommandButton okbtn
         BackColor       =   &H00C0C0C0&
         Caption         =   "&OK"
         Height          =   360
         Left            =   0
         TabIndex        =   4
         Top             =   0
         Width           =   960
      End
      Begin CommandButton detbtn
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Details..."
         Height          =   360
         Left            =   0
         TabIndex        =   9
         Top             =   2220
         Width           =   960
      End
      Begin CommandButton cancelbtn
         BackColor       =   &H00C0C0C0&
         Cancel          =   -1  'True
         Caption         =   "Cancel"
         Height          =   360
         Left            =   0
         TabIndex        =   5
         Top             =   420
         Width           =   960
      End
      Begin CommandButton helpbtn
         BackColor       =   &H00C0C0C0&
         Caption         =   "Help"
         Height          =   360
         Left            =   0
         TabIndex        =   10
         Top             =   2700
         Width           =   960
      End
   End
   Begin SSList forlstm
      Prop47          =   SELFOR.FRX:0131
      AllowForPicture =   SELFOR.FRX:0168
      BorderStyle     =   1  'Fixed Single
      Case            =   0  'Unchanged
      DividerStyle    =   0  'None
      FixedHeight     =   17
      Font3D          =   0  'None
      Height          =   4035
      IntegralSize    =   0   'False
      Left            =   180
      ListStyle       =   0  '2D (BackColor used)
      MultiColumn     =   0   'False
      ReFreshOnUpdate =   -1  'True
      ScrollHorizontal=   0   'False
      ScrollVertical  =   -1  'True
      SelectionType   =   1  'Multiple
      ShadowColor     =   0  'Dark Grey
      Sorted          =   0   'False
      TabIndex        =   1
      Top             =   660
      Width           =   6195
      WndStyle        =   1151336793
   End
   Begin Label optlbl
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Show:"
      Height          =   195
      Left            =   2640
      TabIndex        =   13
      Top             =   420
      Width           =   540
   End
   Begin Shape optbox
      BackColor       =   &H00C0C0C0&
      BackStyle       =   1  'Opaque
      Height          =   315
      Left            =   2460
      Top             =   360
      Width           =   3915
   End
   Begin Label curgrplbl
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "curgrplbl"
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Left            =   1380
      TabIndex        =   12
      Top             =   90
      Width           =   600
   End
   Begin Label curgrplbllbl
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Current Group:"
      Height          =   195
      Left            =   60
      TabIndex        =   11
      Top             =   90
      Width           =   1260
   End
End
'****************************************************************************
'*                                                                          *
'*  SELFOR.FRM                                                              *
'*                                                                          *
'*  Copyright (c) 1994-1997 Galacticomm, Inc.    All Rights Reserved.       *
'*                                                                          *
'*  Forum selector form.  To be invoked using formfunc().                   *
'*  Input:              selection mode (single-select, multi-select),       *
'*                      default list mode (groups/forums), form caption,    *
'*                      default forum name, default group string, number    *
'*                      selected, maximum number to select, all flag        *
'*  Implicit Input:     array of selected forum IDs                         *
'*  Output:             for single-select:  name of forum selected;         *
'*                      for multi-select:  number of forums selected;       *
'*                      then last list mode, last group string, and all     *
'*                      flag value for multi-select                         *
'*  Implicit Output:    selected forum info in curforinf (single-select)    *
'*                                                                          *
'*                                          revised - J. Alvrus 12/12/95    *
'*                                                                          *
'****************************************************************************

Option Explicit

Const FLISTMFRM = "flistmfrm"

Dim mouseclick As Integer
Dim ignoreclick As Integer
Dim textfoc As Integer
Dim flbroff As Single
Dim flbboff As Single
Dim bploff As Single
Dim minh As Single
Dim minw As Single
Dim retstr As String
Dim selmode As Integer
Dim lstmode As Integer
Dim grpstr As String
Dim forlst As SSList
Dim numsel As Integer
Dim maxsel As Integer
Dim allflag As Integer

Function addf (forum As Integer) As Integer
' add Forum to the Forum list, return true if successful

    If numsel >= maxsel Then
        Beep
        addf = False
        Exit Function
    End If
    selforarr(numsel) = forum
    numsel = numsel + 1
    addf = True
End Function

Sub allbtn_Click ()
    Dim i As Integer, lstidx As Integer

    screen.MousePointer = HOURGLASS
    If lstmode = LSTMODEGRP Then
        ignoreclick = True
        For i = fstgrplstforidx() To lastgrplstforidx()
            forlst.Selected(i) = fortag(grplstforid(forlst, i))
            If numsel >= maxsel Then
                Exit For
            End If
        Next
        ignoreclick = False
    Else
        If selmode = SELMULT Then
            allflag = True
            numsel = 0
            showsel
        Else
            ignoreclick = True
            For i = 0 To ninfarr(forinfarr()) - 1
                If fortag(forinfarr(i).forum) Then
                    lstidx = forlstidx(i)
                    If lstidx >= 0 Then
                        forlst.Selected(lstidx) = True
                    End If
                End If
                If numsel >= maxsel Then
                    Exit For
                End If
            Next
            ignoreclick = False
        End If
    End If
    rstfoc
    clrbtn.Enabled = True
    allbtn.Enabled = False
    screen.MousePointer = Default
End Sub

Sub cancelbtn_Click ()
    Unload Me
End Sub

Sub clrbtn_Click ()
    Dim i As Integer

    screen.MousePointer = HOURGLASS
    If lstmode = LSTMODEGRP Then
        For i = fstgrplstforidx() To lastgrplstforidx()
            junk = foruntag(grplstforid(forlst, i))
            If numsel >= maxsel Then
                Exit For
            End If
        Next
    Else
        If selmode = SELMULT Then
            allflag = False
            numsel = 0
        Else
            For i = 0 To ninfarr(forinfarr()) - 1
                junk = foruntag(forinfarr(i).forum)
                If numsel >= maxsel Then
                    Exit For
                End If
            Next
        End If
    End If
    ignoreclick = True
    forlst.Selected(-1) = False
    ignoreclick = False
    rstfoc
    clrbtn.Enabled = False
    allbtn.Enabled = True
    screen.MousePointer = Default
End Sub

Sub detbtn_Click ()
    Dim tmps As String

    If lstmode = LSTMODEGRP Then
        tmps = grplstfornam(forlst, getlbcaret(forlst))
    Else
        tmps = forlstfornam(getlbcaret(forlst))
    End If
    rstfoc
    If Len(tmps) Then
        showdetails fdetails, tmps
    End If
End Sub

Function finlst (forum As Integer) As Integer
' check to see if Forum is in a scan's Forum list

    Dim i As Integer

    finlst = False
    For i = 0 To numsel - 1
        If selforarr(i) = forum Then
            finlst = True
            Exit Function
        End If
    Next
End Function

Sub fixbtns ()
' enable/disable all and clear buttons

    Dim i As Integer, numingrp As Integer, selingrp As Integer

    If lstmode = LSTMODEGRP Then
        If selmode <> SELSINGLE Then
            numingrp = lastgrplstforidx() - fstgrplstforidx() + 1
            selingrp = 0
            For i = fstgrplstforidx() To lastgrplstforidx()
                If fortagged(grplstforid(forlst, i)) Then
                    selingrp = selingrp + 1
                End If
            Next
            allbtn.Enabled = selingrp < numingrp
            clrbtn.Enabled = selingrp > 0
        End If
        detbtn.Enabled = (forlst.ListIndex >= fstgrplstforidx() And forlst.ListIndex <= lastgrplstforidx())
    Else
        If selmode = SELMULT Then
            allbtn.Enabled = Not allflag Or numsel <> 0
            clrbtn.Enabled = allflag Or numsel <> 0
        ElseIf selmode = SELMULTNA Then
            allbtn.Enabled = numsel < maxsel And numsel < ninfarr(forinfarr())
            clrbtn.Enabled = numsel <> 0
        End If
        detbtn.Enabled = True
    End If
End Sub

Sub forlstm_Click ()
    Dim lstidx As Integer, arridx As Integer, forum As Integer

    If Not ignoreclick Then
        ignoreclick = True
        forum = EMLID
        lstidx = getlbcaret(forlstm)
        If lstmode = LSTMODEGRP Then
            grplstclick fornam, forlst
            If isgrplstforum(lstidx) Then
                arridx = getfidx(fornam, forinfarr())
                If arridx >= 0 Then
                    forum = forinfarr(arridx).forum
                End If
            End If
        Else
            forlstclick fornam, lstidx
            arridx = getfidx(fornam, forinfarr())
            If arridx >= 0 Then
                forum = forinfarr(arridx).forum
            End If
        End If
        If forum = EMLID Then
            forlstm.Selected(lstidx) = False
        Else
            If forlstm.Selected(lstidx) Then
                forlstm.Selected(lstidx) = fortag(forum)
            Else
                forlstm.Selected(lstidx) = foruntag(forum)
            End If
        End If
        fixbtns
        ignoreclick = False
    End If
End Sub

Sub forlstm_DblClick ()
    selbtn_Click
End Sub

Sub forlstm_GotFocus ()
    textfoc = False
End Sub

Sub forlsts_Click ()
    If Not ignoreclick Then
        If lstmode = LSTMODEGRP Then
            grplstclick fornam, forlst
        Else
            forlstclick fornam, forlst.ListIndex
        End If
        fixbtns
    End If
End Sub

Sub forlsts_DblClick ()
    okbtn_Click
End Sub

Sub forlsts_GotFocus ()
    textfoc = False
End Sub

Sub Form_Load ()
    retstr = ""
    mouseclick = False
    textfoc = True
    selmode = Val(itemidx(formxchg, 0))
    lstmode = Val(itemidx(formxchg, 1))
    Caption = itemidx(formxchg, 2)
    fornam = itemidx(formxchg, 3)
    grpstr = itemidx(formxchg, 4)
    Select Case selmode
    Case SELSINGLE
        forlsts.Visible = True
        forlstm.Visible = False
        Set forlst = forlsts
        selbtn.Visible = False
        allbtn.Visible = False
        clrbtn.Visible = False
        detbtn.Top = selbtn.Top
        helpbtn.Top = detbtn.Top + detbtn.Height + DIFFDIST
        butpic.Height = helpbtn.Top + helpbtn.Height
        okbtn.Caption = "OK"
        okbtn.Default = True
        HelpContextID = Select_a_Forum
    Case SELMULT, SELMULTNA
        forlsts.Visible = False
        forlstm.Visible = True
        Set forlst = forlstm
        numsel = Val(itemidx(formxchg, 5))
        maxsel = Val(itemidx(formxchg, 6))
        If selmode = SELMULT Then
            allflag = Val(itemidx(formxchg, 7))
        Else
            allflag = False
        End If
        okbtn.Caption = "&OK"
        selbtn.Default = True
        HelpContextID = Select_Scan_Forums
    End Select
    setffont Me, forlst
    forlst.TabPos(0) = TextWidth(String$(FORNSZ, "M"))
    flbroff = calcoff(forlst, Nothing, RIGHT2RIGHT)
    flbboff = calcoff(forlst, Nothing, BOTTOM2BOTTOM)
    bploff = calcoff(butpic, Nothing, LEFT2RIGHT)
    minh = butpic.Top + butpic.Height + (ScaleHeight - (forlst.Top + forlst.Height))
    minw = foropt.Left + foropt.Width + screen.TwipsPerPixelX + DIFFDIST + butpic.Width + DIFFDIST
    posiload Me, FLISTMFRM
    If Not anygroups() Then
        lstmode = LSTMODEFOR
        optlbl.Visible = False
        grpopt.Visible = False
        foropt.Visible = False
        optbox.Visible = False
        curgrplbllbl.Visible = False
        curgrplbl.Visible = False
        fornam.Top = SAMEDIST
        forlst.Top = fornam.Top + fornam.Height - screen.TwipsPerPixelY
        butpic.Top = forlst.Top
    End If
    ignoreclick = True
    If lstmode = LSTMODEGRP Then
        grpopt.Value = True
    Else
        foropt.Value = True
    End If
    ignoreclick = False
End Sub

Sub Form_Resize ()
    applymin forlst, Nothing, RIGHT2RIGHT, flbroff, minh, minw
    applymin optbox, Nothing, RIGHT2RIGHT, flbroff, minh, minw
    applymin forlst, Nothing, BOTTOM2BOTTOM, flbboff, minh, minw
    applymin butpic, Nothing, LEFT2RIGHT, bploff, minh, minw
End Sub

Sub Form_Unload (Cancel As Integer)
    posisave Me, FLISTMFRM, True
    formxchg = retstr
End Sub

Sub fornam_GotFocus ()
    textfoc = True
    If Not mouseclick Then
        fornam.SelStart = 0
        fornam.SelLength = Len(fornam)
    End If
End Sub

Sub fornam_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    mouseclick = True
End Sub

Sub fornam_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
    mouseclick = False
End Sub

Sub foropt_Click (Value As Integer)
    If Value Then
        screen.MousePointer = HOURGLASS
        lstmode = LSTMODEFOR
        showforlst fornam, forlst
        setgrplbl
        If selmode <> SELSINGLE Then
            showsel
        End If
        rstfoc
        fixbtns
        screen.MousePointer = Default
    End If
End Sub

Function fortag (forum As Integer) As Integer
' tag a Forum to be part of a scan, return true if successful
' forum:    forum ID to tag
' returns new value of tag

    Dim revflg As Integer

    fortag = True
    revflg = (selmode = SELMULT And allflag)
    If finlst(forum) Then
        If revflg Then
            removef forum
        End If
    Else
        If Not revflg Then
            fortag = addf(forum)
        End If
    End If
End Function

Function fortagged (forum As Integer) As Integer
' is passed Forum tagged as part of the passed scan?

    If selmode = SELMULT And allflag Then
        fortagged = Not finlst(forum)
    Else
        fortagged = finlst(forum)
    End If
End Function

Function fortoggle (ByVal forum As Integer) As Integer
' toggle currently-highlighted Forum's check box
' forum:    forum ID to toggle
' returns new tag value

    Dim lstflg As Integer, tagflg As Integer, revflg As Integer

    revflg = (selmode = SELMULT And allflag)
    lstflg = finlst(forum)
    If revflg Then
        tagflg = lstflg
    Else
        tagflg = Not lstflg
    End If
    If lstflg Then
        If (tagflg And revflg) Or (Not tagflg And Not revflg) Then
            removef forum
        End If
    Else
        If (tagflg And Not revflg) Or (Not tagflg And revflg) Then
            If Not addf(forum) Then
                tagflg = Not tagflg
            End If
        End If
    End If
    fortoggle = tagflg
End Function

Function foruntag (forum As Integer) As Integer
' untag a Forum to *not* be part of a scan, return true if successful

    Dim revflg As Integer

    foruntag = False
    revflg = (selmode = SELMULT And allflag)
    If finlst(forum) Then
        If Not revflg Then
            removef forum
        End If
    Else
        If revflg Then
            foruntag = Not addf(forum)
        End If
    End If
End Function

Sub grpopt_Click (Value As Integer)
    If Value Then
        screen.MousePointer = HOURGLASS
        lstmode = LSTMODEGRP
        showgrplst fornam, grpstr, forlst
        setgrplbl
        If selmode <> SELSINGLE Then
            showsel
        End If
        rstfoc
        fixbtns
        screen.MousePointer = Default
    End If
End Sub

Sub helpbtn_Click ()
    rstfoc
    dohelp helpbtn, HELP_CONTEXT
End Sub

Sub okbtn_Click ()
    Dim tmps As String

    screen.MousePointer = HOURGLASS
    Select Case selmode
    Case SELSINGLE
        If lstmode = LSTMODEGRP Then
            tmps = selgrpfor(fornam, grpstr, curforinf, False, forlst)
        Else
            tmps = selforum(fornam, curforinf, False, forlst)
        End If
        If Len(tmps) Then
            retstr = tmps & tb & CStr(lstmode) & tb & grpstr
            prefs.curfor = tmps
            Unload Me
        Else
            setgrplbl
            rstfoc
            forlsts_Click
        End If
    Case SELMULT, SELMULTNA
        retstr = numsel & tb & CStr(lstmode) & tb & grpstr & tb & allflag
        Unload Me
    End Select
    screen.MousePointer = Default
End Sub

Sub removef (forum As Integer)
' remove Forum from a scan's Forum list

    Dim i As Integer, j As Integer

    For i = 0 To numsel - 1
        If selforarr(i) = forum Then
            numsel = numsel - 1
            For j = i + 1 To numsel
                selforarr(j - 1) = selforarr(j)
            Next
            Exit Sub
        End If
    Next
End Sub

Sub rstfoc ()
' reset focus to what should have it (list or textbox)

    On Error Resume Next
    If textfoc Then
        fornam.SetFocus
    Else
        forlst.SetFocus
    End If
End Sub

Sub selbtn_Click ()
    Dim i As Integer, reshow As Integer, oldfirsti As Integer
    Dim tmps As String, oldgrp As String
    Dim forinf As foruminf

    screen.MousePointer = HOURGLASS
    If lstmode = LSTMODEGRP Then
        oldgrp = grpstr
        tmps = selgrpfor(fornam, grpstr, forinf, True, forlst)
        grplstclick fornam, forlst
        reshow = Not sameas(grpstr, oldgrp)
    Else
        oldfirsti = forlstarridx(fstforlstforidx())
        tmps = selforum(fornam, forinf, True, forlst)
        forlstclick fornam, getlbcaret(forlst)
        reshow = oldfirsti <> forlstarridx(fstforlstforidx())
    End If
    If Len(tmps) Then
        ignoreclick = True
        forlst.Selected(getlbcaret(forlst)) = fortoggle(forinf.forum)
        ignoreclick = False
    ElseIf reshow Then
        showsel
    End If
    setgrplbl
    rstfoc
    fixbtns
    screen.MousePointer = Default
End Sub

Sub setgrplbl ()
' set group label to appropriate contents

    If lstmode = LSTMODEGRP Then
        If Len(grpstr) Then
            curgrplbl = dblamp(grpstr)
        Else
            curgrplbl = ROOTGRPSTR
        End If
    Else
        curgrplbl = "(all forums)"
    End If
End Sub

Sub showsel ()
' show selected forums in current list

    Dim i As Integer, arridx As Integer, savidx As Integer

    ignoreclick = True
    savidx = getlbcaret(forlst)
    forlst.Selected(-1) = False
    If lstmode = LSTMODEGRP Then
        For i = fstgrplstforidx() To lastgrplstforidx()
            arridx = getfidx(grplstfornam(forlst, i), forinfarr())
            If arridx >= 0 Then
                If fortagged(forinfarr(arridx).forum) Then
                    forlst.Selected(i) = True
                End If
            End If
        Next
    Else
        For i = fstforlstforidx() To lastforlstforidx()
            arridx = getfidx(forlstfornam(i), forinfarr())
            If arridx >= 0 Then
                If fortagged(forinfarr(arridx).forum) Then
                    forlst.Selected(i) = True
                End If
            End If
        Next
    End If
    setlbidx forlst, savidx
    ignoreclick = False
End Sub

