'****************************************************************************
'*                                                                          *
'*  SCAN.BAS                                                                *
'*                                                                          *
'*  Copyright (c) 1995-1997 Galacticomm, Inc.    All Rights Reserved.       *
'*                                                                          *
'*  This file contains declarations and functions for managing online       *
'*  forum scans.                                                            *
'*                                                                          *
'*                                                  - J. Alvrus 12/15/95    *
'*                                                                          *
'****************************************************************************

Option Explicit

Dim scanrqid As Integer             ' request ID of scan message read
Dim firstmsg As Integer             ' is this the first message found by scan?
Dim nextmsg As Integer              ' is this the first "more..." message found?
Dim abterm As Integer               ' scan read was terminated abnormally
Dim morescan As Integer             ' is the last item in the list "more..."
Dim nummore As Integer              ' number of "more..." messages read
Dim totmsgs As Integer              ' total number of messages found by scan
Dim totunrd As Integer              ' total number of unread messages found by scan
Dim msgarr() As msgdpkshrt          ' array of scan message headers

Private Sub add2lst (msg As msgdpkshrt)
' add a message to the list of messages in scan

    Dim flags As Integer, lstw As Integer

    flags = MLF_TGABLE
    If msgtagged(msg.msgid, msg.thrid, msg.forum) Then
        flags = flags Or MLF_TAGGED
    End If
    flags = mlflags(msg, flags)
    totmsgs = totmsgs + 1
    If (flags And MLF_READ) = 0 Then
        totunrd = totunrd + 1
    End If
    lstw = getlbwidth(mainform!msglist)
    mainform!msglist.ReFreshOnUpdate = False
    mainform!msglist.AddItem Trim$(msg.fornam) & tb & getminf(msg.info, FROMFLD) & tb & getminf(msg.info, TOFLD) & tb & getminf(msg.info, TPCFLD) & tb & Format$(msg.crdatim, DATEFMT) & tb & flags
    setmlpic mainform!msglist, mainform!msglist.LastAdded, flags
    mainform!msglist.ReFreshOnUpdate = True
    If getlbwidth(mainform!msglist) <> lstw Or totmsgs = 1 Then
        adjmsgtabs
    End If
End Sub

Private Function addf (forumid As Integer, scan As otscan) As Integer
' add Forum to a scan's Forum list, return true if successful

    addf = True
    If finlst(forumid, scan) Then
        Exit Function
    End If
    If scan.nforums >= globforacc.maxscnfor Then
        Beep
        addf = False
        Exit Function
    End If
    scan.forlst(scan.nforums) = forumid
    scan.nforums = scan.nforums + 1
End Function

Private Sub canscan ()
' cancel current scan request without causing unnecessary messages

    Dim tmprqid As Integer

    If scanrqid >= 0 Then
        tmprqid = scanrqid
        scanrqid = -1
        abodpk tmprqid
    End If
    scncls
End Sub

Function cfgscan (scancap As String) As Integer
' allow the user to configure his scan
' scancap: caption to put on the scan form
' returns False if user cancelled

    cfgscan = Len(formfunc(fscan, scancap)) <> 0
End Function

Private Function delarr (ByVal fornam As String, ByVal msgid As Long) As Integer
' delete specified message from array of scan headers
' fornam:   forum name of message to delete
' msgid:    message ID of message to delete
' returns index of message that was deleted or -1 if not found

    Dim i As Integer, delidx As Integer

    delidx = -1
    delidx = getsmidx(fornam, msgid)
    If delidx >= 0 Then
        For i = delidx To UBound(msgarr) - 1
            msgarr(i) = msgarr(i + 1)
        Next i
        If UBound(msgarr) = 0 Then
            Erase msgarr
        Else
            ReDim Preserve msgarr(UBound(msgarr) - 1)
        End If
    End If
    delarr = delidx
End Function

Private Function finlst (forumid As Integer, scan As otscan) As Integer
' check to see if Forum is in a scan's Forum list

    Dim i As Integer

    finlst = False
    For i = 0 To scan.nforums - 1
        If scan.forlst(i) = forumid Then
            finlst = True
            Exit For
        End If
    Next
End Function

Private Function getmore () As Integer
' get more messages in ongoing scan
' returns True if more messages found

    Dim i As Integer

    getmore = False
    screen.MousePointer = DEFAULT   ' other code sets hourglass when reading
    If Not connected() Then
        If Not appconnect() Then
            Exit Function
        End If
        If Not scnini() Then
            Exit Function
        End If
    End If
    progopen PRGT_INF, "Continuing Scan", "", "Searching for more messages...", ""
    nomore
    nextmsg = True
    abterm = False
    nummore = prefs.onfgetsiz
    scanrqid = rgtdpk(SCNHDRDPK & scnidstr(UBound(msgarr)), wtspace(SCNHDRMIN), nummore, mainform!loadcbk)
    Do
        DoEvents
        If progcancel() Then
            canscan
            progclose
            Exit Function
        End If
    Loop Until scanrqid < 0 Or Not nextmsg
    progclose
    getmore = Not nextmsg
End Function

Private Function getsmidx (ByVal fornam As String, ByVal msgid As Long) As Integer
' find specified message in array of scan message headers
' fornam:   forum name to find
' msgid:    message ID to find
' returns index of message in msgarr() or -1 if not found

    Dim i As Integer
    Dim comp As Integer

    getsmidx = -1
    i = nearsmidx(comp, fornam, msgid)
    If i >= 0 And comp = 0 Then
        getsmidx = i
    End If
End Function

Sub listscan ()
' list messages in a scan

    If Not abtonact() Then
        Exit Sub
    End If
    junk = scnldft()
    If Not cfgscan("Scan Setup") Then
        Exit Sub
    End If
    cursource = SRCONLSCN
    stdmlsetup
    tbvis mtbid, CStr(MTB_DELETE)
    tbinvis mtbid, MTB_JFIRST & SETSEP & MTB_JSPEC & SETSEP & MTB_JLAST & SETSEP & MTB_LSTMSG & SETSEP & MTB_LSTTHR
    mainform!mfdel.Visible = True
    jmpmnuvis False
    tagmnuvis True
    mainform!mfgettag.Visible = True
    lopmnuvis False
    fopmnuvis False, ""
    mainform!lsttitle(0) = "Messages in Scan"
    mainform!lstname(0) = ""
    mainform!lsttitle(0).Visible = True
    mainform!lstname(0).Visible = False
    setmlntab 4
    mainform!caplbl(0).Caption = "Forum"
    mainform!caplbl(1).Caption = "From"
    mainform!caplbl(2).Caption = "To"
    mainform!caplbl(3).Caption = "Topic"
    mainform!caplbl(4).Caption = "Date"
    mainform!msglist.ReFreshOnUpdate = True
    adjmsgtabs
    caplblvis True
    screen.MousePointer = DEFAULT
    If Not startscan() Then
        nosource
    End If
    fixmtb
End Sub

Private Function nearsmidx (comp As Integer, ByVal fornam As String, ByVal msgid As Long) As Integer
' find index of message nearest to specified forum name/message ID in array of scan headers
' comp:     result of last comparison
' fornam:   forum name being searched for
' msgid:    message ID being searched for
' returns index in msgarr() array

    Dim lo As Integer, md As Integer, hi As Integer

    md = -1
    lo = 0
    On Error GoTo notdimmed
    hi = UBound(msgarr)
    Do While lo <= hi
        md = lo + Int((hi - lo) / 2)
        comp = fmcomp(fornam, msgid, Trim$(msgarr(md).fornam), msgarr(md).msgid)
        If comp < 0 Then
            hi = md - 1
        ElseIf comp > 0 Then
            lo = md + 1
        Else
            Exit Do
        End If
    Loop
notdimmed:
    nearsmidx = md
    Exit Function
End Function

Private Sub nomore ()
' remove "more..." item from list (if any)
' Note: this assumes cursource = SRCONLSCN

    If morescan Then
        remlbitem mainform!msglist, ninmarr(msgarr())
    End If
    morescan = False
End Sub

Private Sub removef (forumid As Integer, scan As otscan)
' remove Forum from a scan's Forum list

    Dim i As Integer, j As Integer

    For i = 0 To scan.nforums - 1
        If scan.forlst(i) = forumid Then
            scan.nforums = scan.nforums - 1
            For j = i + 1 To scan.nforums
                scan.forlst(j - 1) = scan.forlst(j)
            Next
            Exit Sub
        End If
    Next
End Sub

Sub scancbk (ByVal evtstg As String, ByVal reqid As Integer)
' scan load callback handler

    Dim n As Integer, topidx As Integer
    Dim tmps As String

    If reqid = scanrqid Then
        Select Case evtstg
        Case "Dynapak received", "Dynapak available"
            If firstmsg Then
                firstmsg = False
                Erase msgarr
            ElseIf nextmsg Then
                nextmsg = False
                screen.MousePointer = HOURGLASS
                topidx = mainform!msglist.TopIndex
                For n = nummore To UBound(msgarr)
                    msgarr(n - nummore) = msgarr(n)
                Next
                ReDim Preserve msgarr(UBound(msgarr) - nummore)
                mainform!msglist.ReFreshOnUpdate = False
                For n = 1 To nummore
                    mainform!msglist.RemoveItem 0
                Next
                topidx = topidx - nummore
                If topidx < 0 Then
                    topidx = 0
                End If
                mainform!msglist.TopIndex = topidx
                mainform!msglist.ReFreshOnUpdate = True
                screen.MousePointer = DEFAULT
            End If
            n = ninmarr(msgarr())
            ReDim Preserve msgarr(n)
            junk = cbkrsp(Len(msgarr(n)), msgarr(n))
            stpnls msgarr(n).info
            add2lst msgarr(n)
            If n >= MAXLIST - 1 Then
                scanrqid = -1
                morescan = True
                mainform!msglist.AddItem "more..."
                mainform!msglist.Picture(mainform!msglist.LastAdded) = mainform!morefwd
            End If
        Case Else
            scanrqid = -1
            abterm = evtstg <> "No more dynapaks"
            freeup
            scncls
            If Not firstmsg Then
                If abterm Then
                    tmps = "Scan aborted." & nl
                Else
                    tmps = "Scan complete." & nl
                End If
                tmps = tmps & totmsgs & " message(s) found"
                If totunrd Then
                    tmps = tmps & "," & nl & totunrd & " unread."
                Else
                    tmps = tmps & "."
                End If
                popmsg tmps, ""
            End If
        End Select
    End If
End Sub

Function scnabtact () As Integer
' abort ongoing scan activity
' Note: this assumes cursource = SRCONLSCN

    scnabtact = True
    If scanipg Then
        If gmsgbox("Your scan is still in progress.  Are you sure you wish to abort it?", MB_ICONQUESTION Or MB_YESNO, "") <> IDYES Then
            scnabtact = False
            Exit Function
        End If
        canscan
        nomore
    End If
End Function

Function scnapvmsg (ByVal msgidstr As String, ByVal setto As Integer) As Integer
' Online Scan:  approve attachment to a message
' msgidstr: message ID string
' setto:    True to approve, False to unapprove
' returns True if successful

    Dim i As Integer
    Dim fornam As String
    Dim msgid As Long

    scnapvmsg = False
    fornam = itemidxd(msgidstr, 0, " ")
    msgid = Val(itemidxd(msgidstr, 1, " "))
    If forapvmsg(fornam, msgid, setto) Then
        i = getsmidx(fornam, msgid)
        If i >= 0 Then
            setflg setto, msgarr(i).flags, FILAPV
        End If
        scnapvmsg = True
    End If
End Function

Function scncandell (ByVal lstidx As Integer)
' can user delete this message (from list)
' lstidx:   index in message list of messages

    scncandell = False
    If ninmarr(msgarr()) Then
        If morescan Then
            If lstidx >= ninmarr(msgarr()) Then
                Exit Function
            End If
        End If
        scncandell = forcandel(msgarr(lstidx))
    End If
End Function

Function scncanread (ByVal msgidstr As String, ByVal direc As Integer) As Integer
' Online Scan: can user read message in specified direction?
' msgidstr: identifier of current message (updated if successful)
' direc:    direction to read (-1=prev, 0=exact, 1=next)

    Dim i As Integer
    Dim msgid As Long
    Dim fornam As String

    fornam = itemidxd(msgidstr, 0, " ")
    msgid = Val(itemidxd(msgidstr, 1, " "))
    i = getsmidx(fornam, msgid)
    Select Case direc
    Case READPREV
        scncanread = i > 0
    Case READTHIS
        scncanread = i >= 0
    Case READNEXT
        scncanread = (i < ninmarr(msgarr()) - 1) Or morescan
    End Select
End Function

Sub scnclr (scan As otscan)
' clear all fields in a scan

    scan.keywds = ""
    scan.stmsgid = 0
    scan.flags = Chr$(0)
    scan.nforums = 0
End Sub

Sub scncls ()
' end the current scan

    junk = wrtdpk(CLSSCNDPK, 0, junk, 0)
    scanipg = False
    mainform!mlscan.Enabled = True
    tbsetbutstt mtbid, MTB_SCAN, UP
End Sub

Function scndelmsg (ByVal msgidstr As String) As Integer
' Online Scan:  delete a message
' msgidstr: ID string of message to delete
' returns True if deleted

    Dim i As Integer
    Dim msgid As Long
    Dim fornam As String

    scndelmsg = False
    fornam = itemidxd(msgidstr, 0, " ")
    msgid = Val(itemidxd(msgidstr, 1, " "))
    If fordelmsg(fornam, msgid) Then
        junk = scndelmsgl(msgidstr)
        scndelmsg = True
    End If
End Function

Function scndelmsgl (ByVal msgidstr As String) As Integer
' Online Scan:  delete local copy of a message
' msgidstr: ID string of message to delete
' returns True if deleted

    Dim i As Integer

    If cursource = SRCONLSCN Then
        i = delarr(itemidxd(msgidstr, 0, " "), Val(itemidxd(msgidstr, 1, " ")))
        If i >= 0 Then
            remlbitem mainform!msglist, i
        End If
    End If
    scndelmsgl = True
End Function

Function scndpknam (ByVal fulmsg As Integer, ByVal fornam As String, ByVal msgid As Long) As String
    Dim dpknam As String

    If fulmsg Then
        dpknam = SCNMSGDPK
    Else
        dpknam = SCNHDRDPK
    End If
    scndpknam = dpknam & fornam & " " & Format$(msgid, MNMFMT)
End Function

Private Function scnidstr (ByVal idx As Integer) As String
' get message ID string of a scan message
' idx:  index of message in msgarr()

    scnidstr = Trim$(msgarr(idx).fornam) & " " & Format$(msgarr(idx).msgid, MNMFMT)
End Function

Function scnini () As Integer
' begin current (global) scan

    Dim resp As Integer

    scanipg = False
    If appconnect() Then
        resp = 0
        junk = swrtdpk(INISCNDPK, sdpklen(curscan), curscan, Len(resp), resp)
        Select Case evtdpk()
        Case "Write ok"
            scanipg = True
            mainform!mlscan.Enabled = False
            tbsetbutstt mtbid, MTB_SCAN, UPDISABLED
        Case "Offline write denied", "Write may be incomplete"
            'do nothing
        Case Else
            Select Case resp
            Case SCINVR
                poperror "Scans are not supported on this system.", ""
            Case SCINOW
                poperror "The server is unable to service your scan request at this time. Please try again in a little while.", ""
            Case SCINVF
                poperror "Your scan setup does not contain any valid forums.", ""
            Case Else
                poperror "Unable to initialize scan request!  (error = " & resp & ")", ""
            End Select
        End Select
    End If
    scnini = scanipg
End Function

Function scnldft () As Integer
' load up the user's default scan settings
' returns False if no scan saved

    If sreadpk(DFTSCNDPK, Len(curscan), curscan) Then
        stpnls curscan.keywds
        If curscan.nforums > globforacc.maxscnfor Then
            curscan.nforums = globforacc.maxscnfor
        End If
        scnldft = True
    Else
        scnclr curscan
        scnldft = False
    End If
End Function

Function scnlistidx (ByVal msgidstr As String) As Integer
' Online Scan: get index of specified message in list of messages
' msgidstr: source-specific message ID string
' returns index or -1 if not found

    Dim msgid As Long
    Dim fornam As String

    scnlistidx = -1
    fornam = itemidxd(msgidstr, 0, " ")
    msgid = Val(itemidxd(msgidstr, 1, " "))
    If cursource = SRCONLSCN Then
        scnlistidx = getsmidx(fornam, msgid)
    End If
End Function

Function scnmm (ByVal fulmsg As Integer, ByVal fornam As String) As String
    Dim mm As String

    If fulmsg Then
        mm = SCNMSGMIN
    Else
        mm = SCNHDRMIN
    End If
    scnmm = mm & fornam & " "
End Function

Sub scnpreprd (ByVal lstidx As Integer, capstr As String, btnflgs As Integer, capflgs As Integer, msgidstr As String)
' Online Scan:  prepare arguments to launch read form with
' lstidx:   index in message list of message to prepare
' capstr:   read form caption
' btnflgs:  button flags
' capflgs:  capability flags
' msgidstr: message ID string

    Dim cmpidx As Integer

    If ninmarr(msgarr()) Then
        If lstidx = ninmarr(msgarr()) And morescan Then
            msgidstr = Chr$(1)
            Exit Sub
        End If
        capstr = "Message in Scan"
        btnflgs = RDBNXTPRV Or RDBTHREAD
        capflgs = RDCDEL Or RDCFOROP Or RDCSILENT
        msgidstr = scnidstr(lstidx)
    End If
End Sub

Function scnreadmsg (msgidstr As String, ByVal direc As Integer) As Integer
' Online Scan: read a message
' msgidstr: identifier of current message (updated if successful)
' direc:    direction to read (-1=prev, 0=exact, 1=next)
' returns:  True if message found
' implicit output: message is in msgindpk if returns True

    Dim i As Integer
    Dim msgid As Long
    Dim fornam As String, tmps As String

    scnreadmsg = False
    If msgidstr = Chr$(1) Then  ' user selected "more..." from list
        junk = getmore()
        Exit Function
    End If
    fornam = itemidxd(msgidstr, 0, " ")
    msgid = Val(itemidxd(msgidstr, 1, " "))
    i = getsmidx(fornam, msgid)
    If i < 0 Then
        Exit Function
    End If
    Do
        Select Case direc
        Case READPREV
            i = i - 1
            If i < 0 Then
                popmsg "There are no previous messages in your scan.", ""
                Exit Function
            End If
        Case READNEXT
            i = i + 1
            If i >= ninmarr(msgarr()) Then
                If morescan Then
                    If getmore() Then
                        i = i - nummore
                    Else
                        Exit Function
                    End If
                ElseIf scanrqid >= 0 Then   ' still searching
                    popmsg "Your scan is still in progress, but no next message has been found yet.", ""
                    Exit Function
                Else
                    popmsg "There are no more messages in your scan.", ""
                    adjrdbtn
                    Exit Function
                End If
            End If
        End Select
        If appconnect() Then
            If sreadpk(FORMSGDPK & scnidstr(i), Len(msgindpk), msgindpk) Then
                msgidstr = Trim$(msgindpk.fornam) & " " & Format$(msgindpk.msgid, MNMFMT)
                stpnls msgindpk.info
                scnreadmsg = True
                Exit Function
            ElseIf direc = READTHIS Then
                poperror "That message no longer exists on the server.", ""
                Exit Function
            End If
        Else
            Exit Function
        End If
    Loop
End Function

Function scnreadthr (msgidstr As String, ByVal fornam As String, ByVal msgid As Long, ByVal thrid As Long, rplto As globid, ByVal direc As Integer) As Integer
' Online Scan: read a message in a thread
' msgidstr: identifier of current message (updated if successful)
' fornam:   forum name or "" if email
' msgid:    current message ID
' thrid:    current thread ID
' rplto:    reply-to ID of current message
' direc:    direction to read (-1=prev, 0=parent, 1=next)
' source:   message source in effect (must be SRCFORUM or SRCTHREAD or SRCUNAPV)
' returns:  True if message found
' implicit output: message is in msgindpk if returns True

    scnreadthr = False
    If appconnect() Then
        If forreadthr(fornam, msgid, thrid, direc) Then
            stpnls msgindpk.info
            msgidstr = Trim$(msgindpk.fornam) & " " & Format$(msgindpk.msgid, MNMFMT)
            scnreadthr = True
        Else
            endofthr direc
        End If
    End If
End Function

Sub scnsdft (dftscn As otscan)
' save dftscn as the user's default scan settings

    junk = swrtdpkv(DFTSCNDPK, sdpklen(dftscn), dftscn)
End Sub

Sub scnsynclst (ByVal msgidstr As String)
' Online Scan: synchronize list with given message
' msgidstr: ID string of message to synchronize with

    setmsgidx scnlistidx(msgidstr)
End Sub

Function scntag (forumid As Integer, scan As otscan) As Integer
' tag a Forum to be part of a scan, return true if successful

    scntag = True
    If finlst(forumid, scan) Then
        If Asc(scan.flags) And SCALL Then
            removef forumid, scan
        End If
    Else
        If Not (Asc(scan.flags) And SCALL) Then
            scntag = addf(forumid, scan)
        End If
    End If
End Function

Sub scntaga (scan As otscan)
' tag all Forums to be part of a scan

    scan.flags = Chr$(Asc(scan.flags) Or SCALL)
    scan.nforums = 0
End Sub

Function scntagged (forumid As Integer, scan As otscan) As Integer
' is passed Forum tagged as part of the passed scan?

    If Asc(scan.flags) And SCALL Then
        scntagged = Not finlst(forumid, scan)
    Else
        scntagged = finlst(forumid, scan)
    End If
End Function

Function scntogtag (flags As Integer, ByVal idx As Integer) As Integer
' Online Scan: toggle a message's tagged status from list of messages
' flags:    current message list flags (updated by handler)
' idx:      index in list of message to tag
' returns True if message tag toggled successfully

    togglemsg msgarr(idx).msgid, msgarr(idx).thrid, Trim$(msgarr(idx).fornam)
    setflg msgtagged(msgarr(idx).msgid, msgarr(idx).thrid, msgarr(idx).forum), flags, MLF_TAGGED
    scntogtag = True
End Function

Sub scnupdmtg (ByVal fornam As String, ByVal msgid As Long)
' update message list due to change in message tagged status
' fornam:   name of forum in which message tag changed
' msgid:    message ID of message that changed

    Dim i As Integer

    i = getsmidx(fornam, msgid)
    If i >= 0 Then
        mainform!msglist.ReFreshOnUpdate = False
        updmtag i, msgarr(i).forum, msgarr(i).thrid, msgarr(i).msgid
        mainform!msglist.ReFreshOnUpdate = True
    End If
End Sub

Sub scnupdtgs ()
' update message list icons e.g. due to toggling thread tag

    Dim i As Integer, oldflg As Integer, newflg As Integer
    Dim tmps As String

    mainform!msglist.ReFreshOnUpdate = False
    For i = 0 To ninmarr(msgarr()) - 1
        tmps = mainform!msglist.List(i)
        oldflg = Val(iteminfo(tmps, MLI_FLAGS))
        newflg = oldflg
        setflg msgtagged(msgarr(i).msgid, msgarr(i).thrid, msgarr(i).forum), newflg, MLF_TAGGED
        If newflg <> oldflg Then
            mainform!msglist.List(i) = setitminf(tmps, MLI_FLAGS, CStr(newflg))
            setmlpic mainform!msglist, i, newflg
        End If
    Next
    mainform!msglist.ReFreshOnUpdate = True
End Sub

Function scnutag (forumid As Integer, scan As otscan) As Integer
' untag a Forum to *not* be part of a scan, return true if successful

    scnutag = True
    If finlst(forumid, scan) Then
        If Not (Asc(scan.flags) And SCALL) Then
            removef forumid, scan
        End If
    Else
        If Asc(scan.flags) And SCALL Then
            scnutag = addf(forumid, scan)
        End If
    End If
End Function

Sub scnutaga (scan As otscan)
' untag all Forums to *not* be part of a scan

    scan.flags = Chr$(Asc(scan.flags) And Not SCALL)
    scan.nforums = 0
End Sub

Function scnxmtmsg (ByVal msgidstr As String, ByVal setto As Integer) As Integer
' Online Scan:  approve attachment to a message
' msgidstr: message ID string
' setto:    True to approve, False to unapprove
' returns True if successful

    Dim i As Integer
    Dim fornam As String
    Dim msgid As Long

    scnxmtmsg = False
    fornam = itemidxd(msgidstr, 0, " ")
    msgid = Val(itemidxd(msgidstr, 1, " "))
    If forxmtmsg(fornam, msgid, setto) Then
        If cursource = SRCONLSCN Then
            i = getsmidx(fornam, msgid)
            If i >= 0 Then
                setflg setto, msgarr(i).flags, EXEMPT
            End If
        End If
        scnxmtmsg = True
    End If
End Function

Private Function sdpklen (scan As otscan) As Integer
' get length of scan as written out in dynapak form

    sdpklen = Len(scan) - Len(scan.forlst(0)) * (MAXSCF - scan.nforums)
End Function

Private Function startscan () As Integer
' start getting messages in a scan
' returns False if aborted

    startscan = False
    If appconnect() Then
        progopen PRGT_INF, "Starting Scan", "", "Searching for first message...", ""
        If Not scnini() Then
            progclose
            Exit Function
        End If
        If cursource = SRCONLSCN Then
            nomore
        End If
        firstmsg = True
        abterm = False
        morescan = False
        totmsgs = 0
        totunrd = 0
        scanrqid = rgtdpk(wtspace(SCNHDRDPK), wtspace(SCNHDRMIN), MAXLIST, mainform!loadcbk)
        Do
            DoEvents
            If progcancel() Then
                canscan
                progclose
                Exit Function
            End If
        Loop Until scanrqid < 0 Or Not firstmsg
        progclose
        If firstmsg Then
            If abterm Then
                popmsg "Scan terminated abnormally.", ""
            Else
                popmsg "No messages were found by your scan.", ""
            End If
        Else
            setmsgidx 0
        End If
        On Error Resume Next
        mainform!msglist.SetFocus
        startscan = Not firstmsg
    End If
End Function

