'****************************************************************************
'*                                                                          *
'*  PROGRESS.BAS                                                            *
'*                                                                          *
'*  Copyright (c) 1996-1997 Galacticomm, Inc.    All Rights Reserved.       *
'*                                                                          *
'*  Progress indicator API.                                                 *
'*                                                                          *
'*                                                  - J. Alvrus 4/24/96     *
'*                                                                          *
'****************************************************************************

Option Explicit

' progress indicator type codes
Global Const PRGT_BAR = 1
Global Const PRGT_INF = 2

Function progcancel () As Integer
' has user clicked cancel button on progress form?

    progcancel = Len(progress.Tag) = 0
End Function

Sub progclose ()
' close progress window

    Dim i As Integer

    For i = 0 To forms.Count - 1
        forms(i).Enabled = True
    Next
    Unload progress
End Sub

Function proginuse () As Integer
' is the progress box currently in use?

    proginuse = False
    If isloaded(progress) Then
        proginuse = Len(progress.Tag) <> 0
    End If
End Function

Sub progopen (ByVal prgtype As Integer, ByVal Caption As String, ByVal geninfo As String, ByVal prgttl As String, ByVal maxinf As String)
' open a progress indicator window
' prgtype:  type of progress indicator (bar or text)
' caption:  progress window caption
' geninfo:  general info at top of window
' prgttl:   progress info title (text type only)
' maxinf:   maximum-length progress info string (text type only), this is used for initial placement of progress
'           info text within the window

    Dim i As Integer

    Load progress
    modsysmnu progress, MOVCLS
    repoctr progress, mainform
    progress.Tag = CStr(prgtype)
    progress.Caption = Caption
    progress!geninfo = dblamp(geninfo)
    If Len(geninfo) Then
        progress!progbar.Top = progress!geninfo.Top + progress!geninfo.Height + DIFFDIST
    Else
        progress!geninfo.Visible = False
        progress!progbar.Top = 3 * DIFFDIST
    End If
    progress!cancelbtn.Top = progress!progbar.Top + progress!progbar.Height + 2 * DIFFDIST
    mdinisiz progress, progress.ScaleWidth, progress!cancelbtn.Top + progress!cancelbtn.Height + 2 * DIFFDIST
    Select Case prgtype
    Case PRGT_BAR
        progress!proginfo.Visible = False
        progress!progtitle.Visible = False
        progress!progbar.BackColor = &H808080
        progress!progbar.FloodShowPct = True
        progress!progbar.FloodPercent = 0
    Case PRGT_INF
        progress!progbar.FloodShowPct = False
        progress!progtitle = dblamp(prgttl)
        progress!proginfo = dblamp(maxinf)
        i = progress!progtitle.Width + SAMEDIST + progress!proginfo.Width
        progress!progtitle.Left = (progress!progbar.Width - i) / 2
        progress!proginfo.Left = progress!progtitle.Left + progress!progtitle.Width + SAMEDIST
        progress!proginfo = ""
    End Select
    junk = ShowWindow(progress.hWnd, 5) 'SW_SHOW
    For i = 0 To forms.Count - 1
        If Not forms(i) Is progress Then
            forms(i).Enabled = False
        End If
    Next
End Sub

Sub progupdate (ByVal info As String)
' update progress indicator
' info: new progress info (percent if bar type, info text if text type)

    Dim i As Integer

    If Len(progress.Tag) Then
        Select Case Val(progress.Tag)
        Case PRGT_BAR
            i = ival(info)
            If i < 0 Then
                i = 0
            ElseIf i > 100 Then
                i = 100
            End If
            progress!progbar.FloodPercent = i
        Case PRGT_INF
            progress!proginfo = dblamp(info)
        End Select
    End If
End Sub

