'****************************************************************************
'*                                                                          *
'*  OUTBOX.BAS                                                              *
'*                                                                          *
'*  Copyright (c) 1994-1997 Galacticomm, Inc.    All Rights Reserved.       *
'*                                                                          *
'*  This file contains declarations and functions for managing the out box. *
'*                                                                          *
'*                                                  - J. Alvrus 11/2/94     *
'*                                                                          *
'****************************************************************************

Option Explicit

Global Const OBXINF = 16332         ' max size of info string in obxdpk
Global Const LOBXDPK = "(h=n)lsau:obx " ' local out-box dynapak name
Global Const LOBXMIN = "obx "       ' out box dynapak minimum match
Global Const LOBXCC = "obxcc "      ' out box cc: list dynapak suffix-prefix
Global Const OBXFMT = "000000.00000" ' out box dynapak msg date formater
Global Const OBXMSKYSZ = 13         ' size of message dpk date/time key
Global Const BSMDAT = -36522#       ' 1/1/1800: base date for out box dpks
Global Const FILEIN = 5             ' info index of folder to file msg in when sent
Const MTLIST = 2000                 ' client-side error code - to fld contains empty dist list
Const CCATT = &H80                  ' cc: list attached to message
Const WRTCCERR = "wrtccerr "        ' unsolicited dpk for error in cc:

' out box status strings
Const OBXSTHOLD = "Holding"
Const OBXSTWAIT = "Waiting to send"
Const OBXSTSEND = "Sending now"
Const OBXSTEDIT = "Being edited"

' out box states
Const OBXGET2GO = 1                 ' getting a message to send
Const OBXSNDING = 2                 ' sending a message to server
Const OBXDELAST = 3                 ' deleting successfully sent message

Global obarrintd As Integer
Global msgkey() As String * OBXMSKYSZ ' out box item-to-dynapak cross reference
Global obxidx As Integer
Global obxdidc As Integer           ' out box initiated this connect

Dim obxinit As Integer              ' has inioutbox been called yet?
Dim obxstate As Integer             ' what out box is doing
Dim obxrqid As Integer              ' out box request ID
Dim obxccrq As Integer              ' request ID of cc: list write
Dim obxattrq As Integer             ' request ID of attachment write
Dim cursndnam As String             ' name of out box dynapak being sent
Dim cursndflg As Integer            ' flags for out box dynapak being sent
Dim curcclist As String             ' actual cc: list for current message (w/client lists expanded)

Type obxdpk                         ' out box dynapak structure
    flags As Integer                '   message status flags
    axes As String * 1              '   per-message access info
    fornam As String * FORNSZ       '   name of forum msg in ("" if E-mail)
    msghdr As newmsg                '   message header
    info As String * OBXINF         '   info string
End Type

Type obxmem                         ' in-memory out box structure
    flags As Integer                '   message status flags
    axes As String * 1              '   per-message access info
    fornam As String * FORNSZ       '   name of forum msg in ("" if E-mail)
    msghdr As newmsg                '   message header
    info As String                  '   info string
End Type

Global globobx As obxmem            ' global buffer used when writing msgs

' out box message status flags
Global Const W2SEND = &H1           ' waiting to send ("holding" if not set)
Global Const ISREPLY = &H2          ' message is a reply
Global Const APNDCC = &H4           ' append cc: list to end of message text
Global Const QUOTMSG = &H8          ' quote message when replying
Global Const ISFWD = &H10           ' message is being forwarded
Global Const DELOMSG = &H20         ' delete original message after forwarding
Global Const ATTONSRV = &H40        ' attachment is on server, don't upload
Global Const ISMODIFY = &H80        ' message is being modified
Global Const FMTTEXT = &H8000       ' message body is formatted

Dim obxindpk As obxdpk              ' buffer for out box dpks
Dim sndindpk As newdpk              ' buffer for sending messages
Dim bkmsgdpk As msgdpk              ' buffer for filing when sent
Dim wrterr As wrterr                ' error that occurred on last message
Global obxready As Integer          ' out box is finished loading
Global emptythyself As Integer      ' tell the out box to start emptying after finished load
Global OBXDFT As String             ' tells out box to ignore auto-file preference

Private Function attdpknam (ByVal reqid As Integer) As String
' generate appropriate dynapak name for sending an attachment

    If appflgs And EMLAPP Then
        attdpknam = "(p=b)sa=" & EMLAPID & ";f:msgatt " & obxrqid
    Else
        attdpknam = "(p=b)sa=" & FORAPID & ";f:msgatt " & obxrqid
    End If
End Function

Private Sub chk4old ()
' check for old E-mail/Forums out box dynapaks

    Dim oldeml As Integer, oldfor As Integer
    Dim tmps As String

    If sameas(curapid(), MSGAPID) Then
        oldeml = Len(srgtdpkv("sa=" & EMLAPID & ";ul:" & wtspace(LOBXMIN), wtspace(LOBXMIN))) <> 0
        oldfor = Len(srgtdpkv("sa=" & FORAPID & ";ul:" & wtspace(LOBXMIN), wtspace(LOBXMIN))) <> 0
        If oldeml Or oldfor Then
            tmps = "You have messages in your old "
            If oldeml And oldfor Then
                tmps = tmps & "E-mail and Forums out boxes. "
            ElseIf oldeml Then
                tmps = tmps & "E-mail out box. "
            Else
                tmps = tmps & "Forums out box. "
            End If
            tmps = tmps & "Would you like to convert them now?"
            If gmsgbox(tmps, MB_ICONQUESTION Or MB_YESNO, "") = IDYES Then
                cvtoldobx
            End If
        End If
    End If
End Sub

Private Sub curerror (ByVal srcflg As Integer)
' handle error while sending current message
' srcflg:   the source of the error (message, cc: list, or attachment)

    Dim errdpknam As String
    Dim errfrm As New obxerrfrm

    errdpknam = cursndnam
    obxupdstat obxlstidx(errdpknam), OBXSTHOLD
    freeup
    junk = sreadpk(errdpknam, Len(obxindpk), obxindpk)
    obxchkbtn
    obxerrsetup srcflg, errfrm
    obxstate = 0
    obxstart
    errfrm.Show 1
    Select Case formxchg
    Case "E"
        obxedit errdpknam
    Case "D"
        junk = swrtdpkv(errdpknam, 0, 0)
        junk = swrtdpkv(lccdpknam(errdpknam), 0, 0)
        If isloaded(outbox) Then
            obxldel obxlstidx(errdpknam)
            If (outbox.WindowState = MINIMIZED) And (outbox!outlist.ListCount = 0) Then
                Unload outbox
            End If
        End If
    End Select
End Sub

Sub obxadd (dpk As obxdpk, ByVal dpknam As String, ByVal sendasap As Integer)
' add a message to out box form list

    Dim idx As Integer
    Dim itemstg As String
    Dim tmpdate As Double

    idx = obxlstidx(dpknam)
    If idx >= 0 Then
        If sendasap Then
            obxupdstat idx, OBXSTWAIT
        End If
        Exit Sub
    End If
    If Not obarrintd Then
        ReDim msgkey(0)
        obarrintd = True
        obxidx = 0
    Else
        obxidx = obxidx + 1
        ReDim Preserve msgkey(obxidx + 1)
    End If
    msgkey(obxidx) = itemidxd(dpknam, 1, " ")
    stpnls dpk.info
    outbox!outlist.AddItem obxitem(dpk, sendasap, msgkey(obxidx))
    If outbox!outlist.ListIndex = -1 Then
        outbox!outlist.ListIndex = outbox!outlist.LastAdded
    End If
    obxchkbtn
End Sub

Sub obxcanedt (ByVal dpknam As String)
'notify out box of cancelled editing of message

    Dim i As Integer

    If isloaded(outbox) Then
        i = obxlstidx(dpknam)
        If i >= 0 Then
            obxupdstat i, OBXSTHOLD
            obxchkbtn
        End If
    End If
End Sub

Sub obxcbkhlr (evtstg As String, reqid As Integer)
'out box callback handler

    Dim i As Integer, length As Integer
    Dim newmid As Long, longrsp As Long
    Dim cclst As String, tmps As String

    If (reqid = -1) Or (obxrqid = -1) Then
        Exit Sub
    End If
    If (reqid <> obxrqid) And (reqid <> obxccrq) And (reqid <> obxattrq) Then
        Exit Sub
    End If
    If (reqid <> obxrqid) And (obxstate <> OBXSNDING) Then
        Exit Sub
    End If
    Select Case obxstate
    Case OBXGET2GO
        Select Case evtstg
        Case "Dynapak available"
            If cbkrsp(Len(obxindpk), obxindpk) Then
                cursndnam = LOBXDPK & itemidxd(namdpk(), 1, " ")
                stpnls obxindpk.info
                cursndflg = obxindpk.flags
                obxstate = OBXSNDING
                obxupdstat obxlstidx(cursndnam), OBXSTSEND
                obxchkbtn
                obxccrq = -1
                obxattrq = -1
                curcclist = ""
                If cursndflg And ISFWD Then
                    tmps = getminf(obxindpk.info, TOFLD) & FLDSEP & wordwrap(getminf(obxindpk.info, TEXTFLD), MXLLEN)
                    obxrqid = wrtdpk(fwddpknam(obxindpk), STGLEN, tmps, outbox!obxsndcbk)
                ElseIf cursndflg And ISMODIFY Then
                    tmps = getminf(obxindpk.info, TPCFLD) & FLDSEP & getminf(obxindpk.info, TEXTFLD)
                    obxrqid = wrtdpk(moddpknam(obxindpk), STGLEN, tmps, outbox!obxsndcbk)
                Else
                    obx2snd obxindpk, sndindpk
                    freeup
                    cclst = sreadpkv(lccdpknam(cursndnam))
                    If obxindpk.flags And APNDCC Then
                        appendccl sndindpk.info, cclst
                    End If
                    If Not xpandplst(sndindpk, cclst) Then
                        wrterr.flags = ADDRESS
                        wrterr.code = MTLIST
                        curerror THEMSG
                        Exit Sub
                    End If
                    If cclst <> "" Then
                        sndindpk.flags = sndindpk.flags Or CCATT
                        curcclist = cclst
                    End If
                    If obxindpk.flags And ISREPLY Then
                        obxrqid = wrtdpk(rpldpknam(), Len(sndindpk) - NINFSIZ + Len(RTrim$(sndindpk.info)), sndindpk, outbox!obxsndcbk)
                    Else
                        obxrqid = wrtdpk(newdpknam(), Len(sndindpk) - NINFSIZ + Len(RTrim$(sndindpk.info)), sndindpk, outbox!obxsndcbk)
                    End If
                    If sndindpk.flags And CCATT Then
                        obxccrq = wrtdpk(sccdpknam(obxrqid), STGLEN, cclst, outbox!obxsndcbk)
                    End If
                    If ((sndindpk.flags And FILATT) <> 0) And ((obxindpk.flags And ATTONSRV) = 0) Then
                        obxattrq = wrtdpk(attdpknam(obxrqid), STGLEN, itemidxd(obxindpk.info, ATTPATH, FLDSEP), outbox!obxsndcbk)
                        dspprg obxattrq
                    End If
                End If
            Else
                obxstate = 0
                freeup
                Unload outbox
            End If
        End Select
    Case OBXSNDING
        If reqid = obxrqid Then
            Select Case evtstg
            Case "Write ok"
                junk = cbkrsp(Len(newmid), newmid)
                freeup
                If (cursndflg And (ISFWD Or ISMODIFY)) = 0 Then
                    If sreadpk(cursndnam, Len(obxindpk), obxindpk) Then
                        stpnls obxindpk.info
                        tmps = getminf(obxindpk.info, FILEIN)
                        If tmps = OBXDFT Then
                            If ((prefs.flags And PAUTFIL) <> 0) Then
                                tmps = Trim$(prefs.autofile)
                            Else
                                tmps = ""
                            End If
                        End If
                        If tmps <> "" Then
                            obx2msg obxindpk, bkmsgdpk
                            bkmsgdpk.msgid = newmid
                            cclst = sreadpkv(lccdpknam(cursndnam))
                            If obxindpk.flags And APNDCC Then
                                appendccl bkmsgdpk.info, cclst
                            End If
                            filemsg tmps, bkmsgdpk, ""
                        End If
                    End If
                End If
                junk = swrtdpkv(cursndnam, 0, junk)
                junk = swrtdpkv(lccdpknam(cursndnam), 0, junk)
                obxldel obxlstidx(cursndnam)
                cursndnam = ""
                obxstate = 0
                obxstart
            Case "Write denied"
                If cursndflg And ISFWD Then
                    junk = cbkrsp(Len(longrsp), longrsp)
                    wrterr.flags = THEFWD
                    wrterr.code = longrsp
                ElseIf cursndflg And ISMODIFY Then
                    wrterr.flags = THEMOD
                    junk = cbkrsp(Len(wrterr.code), wrterr.code)
                Else
                    junk = cbkrsp(Len(wrterr), wrterr)
                End If
                obxrqid = -1
                obxabort
                If wrterr.code = TRYAGAIN Then
                    obxstate = OBXGET2GO
                    obxrqid = readpk(cursndnam, outbox!obxsndcbk)
                Else
                    curerror THEMSG
                End If
            Case "Offline write denied", "Write may be incomplete"
                obxstate = 0
                For i = 0 To outbox!outlist.ListCount - 1
                    obxupdstat i, OBXSTHOLD
                Next
                obxchkbtn
            End Select
        ElseIf reqid = obxccrq Then
            obxccrq = -1
            Select Case evtstg
            Case "Write denied"
                junk = cbkrsp(Len(wrterr), wrterr)
                obxabort
                curerror CCOPY
            End Select
        ElseIf reqid = obxattrq Then
            obxattrq = -1
            Select Case evtstg
            Case "Write denied"
                junk = cbkrsp(Len(wrterr), wrterr)
                obxabort
                curerror FILATT
            Case "Write denied (file not found)"
                wrterr.flags = FILATT
                wrterr.code = GMENFND
                obxabort
                curerror FILATT
            Case "Write denied (I/O error)"
                wrterr.flags = FILATT
                wrterr.code = GMENOAT
                obxabort
                curerror FILATT
            Case "Request aborted"
                If obxrqid <> -1 Then
                    obxabort
                    obxupdstat obxlstidx(cursndnam), OBXSTHOLD
                    obxchkbtn
                    freeup
                    obxstart
                End If
            Case "Offline write denied", "Write may be incomplete"
                ' do nothing, user disconnected
            End Select
        End If
    End Select
End Sub

Sub obxchkbtn ()
' check out box buttons for enabled/disabled

    Dim i As Integer
    Dim sendflg As Integer, waitflg As Integer, holdflg As Integer, editflg As Integer
    Dim tmpflg As Integer
    Dim curstat As String

    If Not isloaded(outbox) Then
        Exit Sub
    End If
    If outbox!outlist.ListCount > 0 Then
        curstat = itemidx(outbox!outlist.Text, 4)
        sendflg = (curstat = OBXSTSEND)
        waitflg = (curstat = OBXSTWAIT)
        holdflg = (curstat = OBXSTHOLD)
        editflg = (curstat = OBXSTEDIT)
        outbox!editbtn.Enabled = Not sendflg
        outbox!delbtn.Enabled = waitflg Or holdflg
        outbox!sendbtn.Enabled = holdflg
        tmpflg = False
        For i = 0 To outbox!outlist.ListCount - 1
            If itemidx(outbox!outlist.List(i), 4) = OBXSTHOLD Then
                tmpflg = True
                Exit For
            End If
        Next
        outbox!emptybtn.Enabled = tmpflg
        outbox!holdbtn.Enabled = sendflg Or waitflg
    Else
        outbox!editbtn.Enabled = False
        outbox!delbtn.Enabled = False
        outbox!sendbtn.Enabled = False
        outbox!emptybtn.Enabled = False
        outbox!holdbtn.Enabled = False
    End If
End Sub

Sub obxconn ()
' out box handle-connect function

    Dim dummy As Integer
    Static oneatatime As Integer    ' assumes this is initialized to False

    If oneatatime Then
        Exit Sub
    End If
    If Not obxinit Then
        Exit Sub
    End If
    If srgtdpk(wtspace(LOBXDPK), wtspace(LOBXMIN), Len(dummy), dummy) = 0 Then
        Exit Sub
    End If
    oneatatime = True
    If (prefs.flags And PALWMT) > 0 Then
        loadobx
        emptyobx
    ElseIf prefs.flags And PPMTMT Then
        If obxdidc Then
            oneatatime = False
            Exit Sub
        End If
        If gmsgbox("There is mail in your out box.  Would you like to send it now?", MB_ICONQUESTION + MB_YESNO, "Outgoing Mail") = IDYES Then
            loadobx
            emptyobx
        End If
    End If
    oneatatime = False
End Sub

Sub obxdel ()
' delete an item from out box

    Dim i As Integer
    Dim s As String

    If itemidx(outbox!outlist.Text, 4) = OBXSTSEND Then
        obxabort
        obxstart
    End If
    s = lstdpknam(outbox!outlist.ListIndex)
    junk = swrtdpkv(s, 0, junk)
    junk = swrtdpkv(lccdpknam(s), 0, junk)
    i = findedtfrm(s)
    If i >= 0 Then
        Unload forms(i)
    End If
    obxldel outbox!outlist.ListIndex
End Sub

Sub obxdisconn ()
' notify out box of connection lost

    emptythyself = False
End Sub

Function obxdpknam (ByVal mdatim As Double) As String
' generate dynapak name for reading local out box dpk
' mdatim: date/time of message

    Dim dummy As Integer
    Dim cflchr As Integer
    Dim tmpnam As String

    cflchr = Asc("{")
    Do
        tmpnam = LOBXDPK & Format$(mdatim, OBXFMT) & Chr$(cflchr)
        cflchr = cflchr + 1
    Loop While sreadpk(tmpnam, Len(dummy), dummy)
    obxdpknam = tmpnam
End Function

Sub obxedit (ByVal dpknam As String)
' edit message in out box
' dpknam:   out box dynapak name

    Dim i As Integer
    Dim cclist As String, msgtype As String, capstr As String, tmps As String

    screen.MousePointer = HOURGLASS
    i = findedtfrm(dpknam)
    If i >= 0 Then
        forms(i).Visible = True
        forms(i).SetFocus
        If forms(i).WindowState = MINIMIZED Then
            junk = sndmsg(forms(i).hWnd, WM_SYSCOMMAND, SC_RESTORE, 0&)
        End If
    ElseIf sreadpk(dpknam, Len(obxindpk), obxindpk) Then
        stpnls obxindpk.info
        globobx.flags = obxindpk.flags
        globobx.axes = obxindpk.axes
        globobx.fornam = obxindpk.fornam
        globobx.msghdr = obxindpk.msghdr
        globobx.info = RTrim$(obxindpk.info)
        If globobx.flags And ISFWD Then
            tmps = ""
            tmps = setminf(tmps, CStr(False), FWIFIRST)
            tmps = setminf(tmps, getminf(globobx.info, TOFLD), FWITOADR)
            tmps = setminf(tmps, getminf(globobx.info, TEXTFLD), FWICMT)
            tmps = setminf(tmps, CStr((globobx.flags And DELOMSG) <> 0), FWIDELV)
            tmps = setminf(tmps, globobx.axes, FWIDELE)
            tmps = setminf(tmps, Trim$(globobx.fornam), FWIFNAM)
            tmps = setminf(tmps, CStr(globobx.msghdr.msgid), FWIMSGID)
            tmps = setminf(tmps, getminf(globobx.info, FROMFLD), FWIFROM)
            tmps = setminf(tmps, getminf(globobx.info, TPCFLD), FWITPC)
            tmps = setminf(tmps, CStr(globobx.msghdr.thrid), FWITXLEN)
            screen.MousePointer = DEFAULT
            tmps = formfunc(fwdmsgfrm, tmps)
            If Len(tmps) Then
                setflg Val(getminf(tmps, FWOSEND)), globobx.flags, W2SEND
                setflg Val(getminf(tmps, FWODELO)), globobx.flags, DELOMSG
                globobx.info = setminf(globobx.info, getminf(tmps, FWOTOADR), TOFLD)
                globobx.info = setminf(globobx.info, getminf(tmps, FWOCMT), TEXTFLD)
                xst2obx dpknam, globobx, ""
            End If
        ElseIf ok2edit() Then
            cclist = sreadpkv(lccdpknam(dpknam))
            If globobx.flags And ISMODIFY Then
                msgtype = "modify"
                capstr = "Modify #" & globobx.msghdr.msgid & " in " & Trim$(globobx.fornam)
            ElseIf globobx.flags And ISREPLY Then
                msgtype = "reply"
                capstr = "Edit Reply to #" & globobx.msghdr.msgid
                If globobx.msghdr.forum <> EMLID Then
                    capstr = capstr & " in " & Trim$(globobx.fornam)
                End If
            Else
                msgtype = "new"
                capstr = "Edit New Message"
            End If
            showedit capstr & tb & cclist & tb & msgtype & tb & dpknam
            obxupdstat outbox!outlist.ListIndex, OBXSTEDIT
            obxchkbtn
        End If
    End If
    screen.MousePointer = DEFAULT
End Sub

Private Sub obxerrsetup (ByVal srcflg As Integer, errfrm As obxerrfrm)
' this sub puts the appropriate information on the out box error form
' it assumes the error info is in wrterr and the message is in obxindpk
' it puts the name of the bad dynapak in the tag
' srcflg is the dynapak write that caused the error (message, cc: list, or attachment)

    Dim applyctl As control

    repoctr errfrm, Nothing
    errfrm!addr = getminf(obxindpk.info, TOFLD)
    errfrm!topic = getminf(obxindpk.info, TPCFLD)
    modsysmnu errfrm, MOVCLS
    errfrm!edtbtn.Enabled = mainform.Enabled
    errfrm!delbtn.Enabled = mainform.Enabled
    If srcflg = CCOPY Then
        If wrterr.flags < 0 Then
            Select Case wrterr.code
            Case TOOMNY
                errfrm!errmsg = "This message has too many carbon copies.  You are only allowed to send " & emlacc.ccmax & " carbon copies at once."
            Case GMEMEM
                errfrm!errmsg = "The server is unable to process your cc: list at this time.  You may need to reduce the number of carbon copies."
            Case Else
                errfrm!errmsg = "An unknown error has occurred while sending the cc: list for this message (error = " & wrterr.code & ")."
            End Select
        Else
            Select Case wrterr.code
            Case GMEERR
                errfrm!errmsg = "The following cc: address is not valid on this system:  """ & Trim$(itemidxd(curcclist, wrterr.flags, ";")) & """."
            Case GMEACC
                errfrm!errmsg = "You do not have access to write to the following cc: address:  """ & Trim$(itemidxd(curcclist, wrterr.flags, ";")) & """."
            Case Else
                errfrm!errmsg = "An unknown error has occurred with the following carbon copy address:  """ & Trim$(itemidxd(curcclist, wrterr.flags, ";")) & """ (error = " & wrterr.code & ")."
            End Select
        End If
    Else
        Select Case wrterr.flags
        Case ADDRESS
            Select Case wrterr.code
            Case GMEACC
                errfrm!errmsg = "You do not have access to write to this address."
            Case GMECRD
                errfrm!errmsg = "You do not have enough credits to send this message."
            Case PFNERR
                errfrm!errmsg = "The User-ID to which this message is directed does not exist and contains profanity which is not allowed on this system."
            Case MTLIST
                errfrm!errmsg = "This message is addressed to an empty distribution list."
            Case Else
                If addrtyp(errfrm!addr) = ISPLIST Then
                    errfrm!errmsg = "The first address in your distribution list is invalid."
                Else
                    errfrm!errmsg = """" & errfrm!addr & """ is not a valid address on this system."
                End If
            End Select
        Case FORUMID
            Select Case wrterr.code
            Case GMEACC
                errfrm!errmsg = "You do not have access to write messages in the " & Trim$(obxindpk.fornam) & " forum."
            Case Else
                errfrm!errmsg = "This message has an invalid forum specified as its destination."
            End Select
        Case CCOPY
            errfrm!errmsg = "You cannot send carbon copies with this message."
        Case FILIND
            Select Case wrterr.code
            Case GMEACC
                errfrm!errmsg = "You do not have access to utilize files on the server as attachments."
            Case GMEIVA
                errfrm!errmsg = "The attachment you specified for this message, """ & itemidxd(obxindpk.info, ATTPATH, FLDSEP) & """ does not exist on the server."
            Case GMENOAT
                errfrm!errmsg = "An I/O error of some sort occurred while making a copy of the attachment for this message."
            Case Else
                errfrm!errmsg = "An unknown error has occurred with the indirect attachment to this message (error = " & wrterr.code & ")."
            End Select
        Case FILATT
            Select Case wrterr.code
            Case GMEACC
                errfrm!errmsg = "You do not have access to include a file attachment with this message."
            Case GMECRD
                errfrm!errmsg = "You do not have enough credits to include a file attachment with this message."
            Case PFNERR
                errfrm!errmsg = "The attachment name for this message contains profanity which is not allowed on this system."
            Case GMENFND
                errfrm!errmsg = "The attachment for this message could not be found."
            Case GMENOAT
                errfrm!errmsg = "An I/O error of some sort occurred while reading the attachment for this message."
            Case Else
                errfrm!errmsg = "File attachments are not allowed with this message."
            End Select
        Case RECREQ
            Select Case wrterr.code
            Case GMEACC
                errfrm!errmsg = "You do not have access to request a return receipt for this message."
            Case GMECRD
                errfrm!errmsg = "You do not have enough credits to request a return receipt for this message."
            Case Else
                errfrm!errmsg = "Return receipt requests are not allowed with this message."
            End Select
        Case PRIMSG
            Select Case wrterr.code
            Case GMEACC
                errfrm!errmsg = "You do not have access to send this message priority."
            Case GMECRD
                errfrm!errmsg = "You do not have enough credits to send this message priority."
            Case Else
                errfrm!errmsg = "This message can not be sent priority."
            End Select
        Case THEMSG
            Select Case wrterr.code
            Case GMEACC
                errfrm!errmsg = "You do not have access to send this message."
            Case GMECRD
                errfrm!errmsg = "You do not have enough credits to send this message."
            Case PFNERR
                errfrm!errmsg = "The topic or body of this message contains profanity which is not allowed on this system."
            Case Else
                errfrm!errmsg = "An unknown error has occurred while sending this message (error = " & wrterr.code & ")."
            End Select
        Case THEFWD
            Select Case wrterr.code
            Case GMENFND
                errfrm!errmsg = "This message could not be forwarded because it is no longer available on the server. You can Resend it instead."
            Case GMECRD
                errfrm!errmsg = "You do not have enough credits to forward this message."
            Case GMEACC
                errfrm!errmsg = "You do not have access to forward this message."
            Case GMENCFL
                errfrm!errmsg = "You can not forward a message to a distribution list."
            Case GMEUSE
                errfrm!errmsg = "This message could not be forwarded because someone else is working with it right now."
            Case PFNERR
                errfrm!errmsg = "Your comments contain profanity which is not allowed on this system."
            Case BADADR
                errfrm!errmsg = """" & errfrm!addr & """ is not a valid address on this system."
            Case GMEIVA
                errfrm!errmsg = "You cannot forward a message with an attachment to """ & errfrm!addr & """."
            Case CMTERR
                errfrm!errmsg = "The server was unable to add your comments to the message.  You may need to reduce or remove your comments."
            Case Else
                errfrm!errmsg = "An unknown error has occurred while forwarding this message (error = " & wrterr.code & ")."
            End Select
        Case THEMOD
            Select Case wrterr.code
            Case GMENFND
                errfrm!errmsg = "This message could not be modified because it is no longer present on the server."
            Case GMEACC
                errfrm!errmsg = "You do not have access to modify this message."
            Case GMEUSE
                errfrm!errmsg = "This message could not be modified because someone else is working with it right now."
            Case Else
                errfrm!errmsg = "An unknown error has occurred while modifying this message (error = " & wrterr.code & ")."
            End Select
        Case Else
            errfrm!errmsg = "An unknown error has occurred while sending this message."
        End Select
    End If
    If errfrm!errmsg.Height > errfrm!exclam.Height Then
        applyoff errfrm!exclam, errfrm!errmsg, VCENTER, 0
        Set applyctl = errfrm!errmsg
    Else
        applyoff errfrm!errmsg, errfrm!exclam, VCENTER, 0
        Set applyctl = errfrm!exclam
    End If
    applyoff errfrm!msgframe, applyctl, TOP2BOTTOM, -DIFFDIST
    applyoff errfrm!btnpic, errfrm!msgframe, TOP2BOTTOM, -DIFFDIST
    mdinisiz errfrm, errfrm.ScaleWidth, errfrm!btnpic.Top + errfrm!btnpic.Height + DIFFDIST
    messagebeep MB_ICONEXCLAMATION
End Sub

Sub obxhold ()
' put an item in the out box on hold

    Dim length As Integer
    Dim tmps As String

    tmps = itemidx(outbox!outlist.Text, 4)
    If tmps = OBXSTHOLD Or tmps = OBXSTEDIT Then
        Exit Sub
    End If
    If tmps = OBXSTSEND Then
        obxabort
    End If
    obxupdstat outbox!outlist.ListIndex, OBXSTHOLD
    obxchkbtn
    obxstart
End Sub

Private Function obxitem (dpk As obxdpk, ByVal sendasap As Integer, ByVal keystr As String) As String
' generate out box list item string
' dpk:      out box dynapak
' sendasap: should status be "Waiting to Send"?
' keystr:   date/time stamp

    Dim itemstr As String

    If dpk.flags And ISFWD Then
        itemstr = "(Forward)" & tb
    ElseIf dpk.flags And ISMODIFY Then
        itemstr = "(Modify)" & tb
    ElseIf dpk.msghdr.forum = EMLID Then
        itemstr = "(E-mail)" & tb
    Else
        itemstr = Trim$(dpk.fornam) & tb
    End If
    itemstr = itemstr & getminf(dpk.info, TOFLD) & tb
    itemstr = itemstr & getminf(dpk.info, TPCFLD) & tb
    itemstr = itemstr & Format$(Val(Left$(keystr, Len(keystr) - 1)), DATEFMT) & tb
    If sendasap Then
        itemstr = itemstr & OBXSTWAIT
    Else
        itemstr = itemstr & OBXSTHOLD
    End If
    obxitem = itemstr
End Function

Sub obxldel (ByVal idx As Integer)
' delete an item from the out box list

    Dim i As Integer

    If obxidx = 0 Then
        obarrintd = False
    Else
        For i = idx To outbox!outlist.ListCount - 2
            msgkey(i) = msgkey(i + 1)
        Next
        obxidx = obxidx - 1
        ReDim Preserve msgkey(obxidx)
    End If
    remlbitem outbox!outlist, idx
    obxchkbtn
End Sub

Function obxlstidx (ByVal dpknam As String) As Integer
' get index of this dynapak in out box list

    Dim tmpidx As Integer
    Dim tmps As String

    If isloaded(outbox) Then
        tmps = itemidxd(dpknam, 1, " ")
        For tmpidx = 0 To outbox!outlist.ListCount - 1
            If msgkey(tmpidx) = tmps Then
                obxlstidx = tmpidx
                Exit Function
            End If
        Next
    End If
    obxlstidx = -1
End Function

Function obxqryunl () As Integer
' handle Form_QueryUnload for out box form

    Dim tmpi As Integer

    obxqryunl = False
    If Not shutdnipg Then
        If obxstate Then
            obxqryunl = gmsgbox("The Out Box is sending messages. Are you sure you wish to quit?", MB_ICONQUESTION Or MB_YESNO Or MB_DEFBUTTON2, "Out Box") = IDNO
        End If
    End If
End Function

Sub obxsend (ByVal idx As Integer)
' send an out box item

    If itemidx(outbox!outlist.List(idx), 4) = OBXSTHOLD Then
        obxupdstat idx, OBXSTWAIT
    End If
End Sub

Sub obxstart ()
' kick off background send process

    Dim i As Integer

    If obxstate <> 0 Then
        Exit Sub
    End If
    If (outbox!outlist.ListCount = 0) And (outbox.WindowState = MINIMIZED) Then
        Unload outbox
        Exit Sub
    End If
    For i = 0 To outbox!outlist.ListCount - 1
        If itemidx(outbox!outlist.List(i), 4) = OBXSTWAIT Then
            obxstate = OBXGET2GO
            obxrqid = readpk(lstdpknam(i), outbox!obxsndcbk)
            Exit Sub
        End If
    Next
End Sub

Sub obxupd (ByVal idx As Integer, dpk As obxdpk, ByVal sendasap As Integer)
' update info in out box list

    Dim item As String

    If idx < 0 Then
        Exit Sub
    End If
    stpnls dpk.info
    outbox!outlist.List(idx) = obxitem(dpk, sendasap, msgkey(idx))
End Sub

Sub obxupdstat (ByVal idx As Integer, ByVal status As String)
' updates the status of a message in the out box list

    If idx >= 0 Then
        outbox!outlist.ReFreshOnUpdate = False
        outbox!outlist.List(idx) = itemset(outbox!outlist.List(idx), 4, status)
        outbox!outlist.ReFreshOnUpdate = True
        frcupd outbox!outlist
    End If
End Sub

Function obxusdpk (reqid As Integer) As Integer
' handle any unsolicited dynapaks directed toward the out box

    Dim errcode As Integer
    Dim dpknam As String
    Dim errmsg As String

    dpknam = namdpk()
    dpknam = Mid$(dpknam, InStr(dpknam, ":") + 1)
    If (sameto(WRTCCERR, dpknam)) Then
        errcode = Val(Mid$(dpknam, Len(WRTCCERR) + 1))
        Select Case errcode
        Case GMENFND
            errmsg = "The address """ & cbkrspv() & """ does not exist, so you cannot send a cc: there."
        Case GMEACC
            errmsg = "You do not have access to send a cc: to """ & cbkrspv() & """."
        Case GMECRD
            errmsg = "You do not have enough credits to send a cc: to """ & cbkrspv() & """."
        Case Else
            errmsg = "An unknown error has occurred while sending a cc: to """ & cbkrspv() & """."
        End Select
        freeup
        poperror errmsg, "Outgoing cc: Error."
        obxusdpk = True
        Exit Function
    End If
    obxusdpk = False
End Function

Private Function rpldpknam () As String
' generate appropriate dynapak name for sending a reply

    If appflgs And EMLAPP Then
        rpldpknam = "(p=b)sa=" & EMLAPID & ";:wrtrpl"
    Else
        rpldpknam = "(p=b)sa=" & FORAPID & ";:wrtrpl"
    End If
End Function

Private Function sccdpknam (ByVal reqid As Integer) As String
' generate appropriate dynapak name for sending a cc: list to the server

    If appflgs And EMLAPP Then
        sccdpknam = "(p=b)sa=" & EMLAPID & ";:cclist " & reqid
    Else
        sccdpknam = "(p=b)sa=" & FORAPID & ";:cclist " & reqid
    End If
End Function

Private Sub cvtanapp (ByVal appid As String)
' convert old out box dynapaks associated with a given app
' appid:    App-ID to convert

    Dim rdlen As Integer
    Dim dpknam As String, newnam As String, tmps As String

    dpknam = "sa=" & appid & ";ul:" & wtspace(LOBXMIN)
    Do
        rdlen = srgtdpk(dpknam, wtspace(LOBXMIN), Len(obxindpk), obxindpk)
        If rdlen Then
            dpknam = namdpk()
            tmps = itemidxd(suffix(dpknam), 1, " ")
            newnam = obxdpknam(Val(Left$(tmps, Len(tmps) - 1)))
            junk = swrtdpkv(newnam, rdlen, obxindpk)
            junk = swrtdpkv(dpknam, 0, 0)
            tmps = sreadpkv(lccdpknam(dpknam))
            If Len(tmps) Then
                junk = swrtdpkv(lccdpknam(newnam), STGLEN, tmps)
            End If
        End If
    Loop While rdlen
End Sub

Private Sub cvtoldobx ()
' convert old E-mail/Forums out box contents

    screen.MousePointer = HOURGLASS
    cvtanapp EMLAPID
    cvtanapp FORAPID
    screen.MousePointer = DEFAULT
End Sub

Sub emptyobx ()
' send all messages in the out box

    If obxready Then
        outbox!emptybtn.Value = True
    Else
        emptythyself = True
        loadobx
    End If
End Sub

Function findedtfrm (ByVal edtdpknam As String) As Integer
' find edit form associated with given out box message

    Dim i As Integer

    edtdpknam = itemidxd(edtdpknam, 1, " ")     'get key part
    For i = 0 To forms.Count - 1
        If TypeOf forms(i) Is wrtedt Then
            If edtdpknam = itemidxd(forms(i)!edtdpknam, 1, " ") Then
                findedtfrm = i
                Exit Function
            End If
        End If
    Next
    findedtfrm = -1
End Function

Private Function fwddpknam (obx As obxdpk) As String
' generate dynapak name for when forwarding a message
' obx:  dynapak form of out box dynapak

    If obxindpk.flags And DELOMSG Then
        If obxindpk.msghdr.orgfor = EMLID Then
            fwddpknam = "(p=b)sa=" & EMLAPID & ";:fwdeml " & Format$(obxindpk.msghdr.msgid, MNMFMT)
        Else
            fwddpknam = "(p=b)sa=" & FORAPID & ";:fwdmsg " & Trim$(obxindpk.fornam) & " " & Format$(obxindpk.msghdr.msgid, MNMFMT)
        End If
    Else
        If obxindpk.msghdr.orgfor = EMLID Then
            fwddpknam = "(p=b)sa=" & EMLAPID & ";:cpyeml " & Format$(obxindpk.msghdr.msgid, MNMFMT)
        Else
            fwddpknam = "(p=b)sa=" & FORAPID & ";:cpymsg " & Trim$(obxindpk.fornam) & " " & Format$(obxindpk.msghdr.msgid, MNMFMT)
        End If
    End If
End Function

Sub inioutbox (ByVal handleconn As Integer)
' initialize out box
' handleconn:   do standard connect-time operations if already connected

    obxstate = 0
    obxrqid = -1
    obxccrq = -1
    obxattrq = -1
    obxinit = True
    chk4old
    If Len(srgtdpkv(wtspace(LOBXDPK), wtspace(LOBXMIN))) Then
        loadobx
    End If
    If connected() And handleconn Then
        obxconn
    End If
End Sub

Private Function lccdpknam (ByVal primdpk As String) As String
'get name for local cc: list dynapak given out box message dpk name

    Dim i As Integer

    i = InStr(primdpk, LOBXMIN)
    If i = 0 Then
        lccdpknam = ""
        Exit Function
    End If
    lccdpknam = Left$(primdpk, i - 1) & LOBXCC & Mid$(primdpk, i + Len(LOBXMIN))
End Function

Private Sub loadobx ()
' make sure out box form is loaded

    If Not isloaded(outbox) Then
        Load outbox
        outbox.ZOrder 1
        junk = ShowWindow(outbox.hWnd, 7)   'SW_SHOWMINNOACTIVE
    End If
End Sub

Function lstdpknam (ByVal idx As Integer) As String
' generate dynapak name for out box dynapak given index

    lstdpknam = LOBXDPK & msgkey(idx)
End Function

Private Function moddpknam (obx As obxdpk) As String
' generate dynapak name for when modifying a message
' obx:  dynapak form of out box dynapak

    moddpknam = "(p=b)" & FORMODDPK & Trim$(obx.fornam) & " " & Format$(obx.msghdr.msgid, MNMFMT)
End Function

Sub new2obx (omsg As obxmem, ByVal cclist As String)
'submit a new message to the out box

    Dim primdpk As String

    obxindpk.flags = omsg.flags And Not W2SEND
    obxindpk.axes = omsg.axes
    obxindpk.fornam = omsg.fornam
    obxindpk.msghdr = omsg.msghdr
    obxindpk.info = omsg.info
    primdpk = obxdpknam(CDbl(Now))
    junk = swrtdpkv(primdpk, Len(obxindpk) - OBXINF + Len(omsg.info), obxindpk)
    If Len(cclist) <> 0 And (omsg.flags And (ISFWD Or ISMODIFY)) = 0 Then
        junk = swrtdpkv(lccdpknam(primdpk), STGLEN, cclist)
    End If
    loadobx
    obxadd obxindpk, primdpk, False
    If omsg.flags And W2SEND Then
        obxdidc = True
        If appconnect() Then
            obxupdstat obxlstidx(primdpk), OBXSTWAIT
            obxstart
        End If
        obxdidc = False
    End If
    obxchkbtn
End Sub

Private Function newdpknam () As String
' generate appropriate dynapak name for sending a new message

    If appflgs And EMLAPP Then
        newdpknam = "(p=b)sa=" & EMLAPID & ";:wrtnew"
    Else
        newdpknam = "(p=b)sa=" & FORAPID & ";:wrtnew"
    End If
End Function

Sub obx2msg (obx As obxdpk, msg As msgdpk)
' copy out box dpk structure to msgdpk structure in prep for filing

    Dim tmpinf As String
    Dim msgstg As String

    msg.forum = obx.msghdr.forum
    msg.fornam = obx.fornam
    msg.msgid = 0
    msg.axes = obx.axes
    msg.gmid.sysid = 0
    msg.gmid.msgid = 0
    If obx.flags And ISREPLY Then
        msg.thrid = obx.msghdr.thrid
        msg.rplto = obx.msghdr.gmid
    Else
        msg.thrid = 0
        msg.rplto.sysid = 0
        msg.rplto.msgid = 0
    End If
    msg.attname = obx.msghdr.attname
    msg.flags = obx.msghdr.flags
    msg.crdatim = Now
    msg.nrpl = 0
    tmpinf = curuid()
    tmpinf = tmpinf & FLDSEP & getminf(obx.info, TOFLD)
    tmpinf = tmpinf & FLDSEP & getminf(obx.info, TPCFLD) & FLDSEP & FLDSEP
    msg.info = tmpinf & getminf(obx.info, TEXTFLD)
End Sub

Sub obx2snd (obx As obxdpk, snd As newdpk)
' copy out box form dynapak to send form

    Dim tmpinfo As String, txtstg As String, txtfmt As String
    Dim aline As String

    snd.orgfor = obx.msghdr.orgfor
    snd.forum = obx.msghdr.forum
    snd.msgid = obx.msghdr.msgid
    snd.gmid = obx.msghdr.gmid
    snd.thrid = obx.msghdr.thrid
    snd.attname = obx.msghdr.attname
    snd.flags = obx.msghdr.flags
    If ((obx.msghdr.flags And FILATT) <> 0) And ((obx.flags And ATTONSRV) <> 0) Then
        tmpinfo = getminf(obx.info, ATTPATH)
    Else
        tmpinfo = ""
    End If
    tmpinfo = tmpinfo & FLDSEP & getminf(obx.info, TOFLD) & FLDSEP & getminf(obx.info, TPCFLD) & FLDSEP & getminf(obx.info, HISTFLD)
    txtfmt = getminf(obx.info, TEXTFLD)
    snd.info = tmpinfo & FLDSEP & txtfmt
End Sub

Sub obxabort ()
' abort out box send process

    If obxstate = 0 Then
        Exit Sub
    End If
    If obxrqid <> -1 Then
        abodpk obxrqid
        obxrqid = -1
    End If
    If obxccrq <> -1 Then
        abodpk obxccrq
        obxccrq = -1
    End If
    If obxattrq <> -1 Then
        abodpk obxattrq
        obxattrq = -1
    End If
    obxstate = 0
End Sub

Private Function xpandplst (dpk As newdpk, cclist As String) As Integer
' expand client-side lists in to field and cc: list

    Dim i As Integer
    Dim curlstnam As String
    Dim curlist As String

    curlstnam = itemidxd(dpk.info, TOFLD, FLDSEP)
    If addrtyp(curlstnam) = ISPLIST Then
        curlist = getplist(curlstnam)
        If curlist = "" Then
            xpandplst = False
            Exit Function
        End If
        i = InStr(curlist, ";")
        If i = 0 Then
            dpk.info = itemsetd(dpk.info, TOFLD, curlist, FLDSEP)
            curlist = ""
        Else
            dpk.info = itemsetd(dpk.info, TOFLD, Trim$(Left$(curlist, i - 1)), FLDSEP)
            curlist = Trim$(Mid$(curlist, i + 1))
        End If
        If Len(curlist) = 0 Then
            i = 0
        Else
            i = itemcntd(curlist, ";")
            If Trim$(cclist) = "" Then
                cclist = curlist
            Else
                cclist = curlist & ";" & cclist
            End If
        End If
    End If
    curlstnam = Trim$(itemidxd(cclist, i, ";"))
    Do While curlstnam <> ""
        If addrtyp(curlstnam) = ISPLIST Then
            curlist = getplist(curlstnam)
            If curlist = "" Then
                cclist = itemdeld(cclist, i, ";")
            Else
                cclist = itemsetd(cclist, i, curlist, ";")
                i = i + itemcntd(curlist, ";")
            End If
        Else
            i = i + 1
        End If
        curlstnam = Trim$(itemidxd(cclist, i, ";"))
    Loop
    xpandplst = True
End Function

Sub xst2obx (ByVal dpknam As String, omsg As obxmem, ByVal cclist As String)
' submit an existing out box message after editing

    junk = sreadpk(dpknam, Len(obxindpk), obxindpk)
    obxindpk.flags = omsg.flags And Not W2SEND
    obxindpk.msghdr = omsg.msghdr
    obxindpk.info = omsg.info
    junk = swrtdpkv(dpknam, Len(obxindpk) - OBXINF + Len(omsg.info), obxindpk)
    If (omsg.flags And (ISFWD Or ISMODIFY)) = 0 Then
        junk = swrtdpkv(lccdpknam(dpknam), STGLEN, cclist)
    End If
    loadobx
    obxupd obxlstidx(dpknam), obxindpk, False
    If (omsg.flags And W2SEND) <> 0 Then
        obxdidc = True
        If appconnect() Then
            obxupdstat obxlstidx(dpknam), OBXSTWAIT
            obxstart
        End If
        obxdidc = False
    End If
    obxchkbtn
End Sub

