'****************************************************************************
'*                                                                          *
'*  ONLFOR.BAS                                                              *
'*                                                                          *
'*  Copyright (c) 1995-1997 Galacticomm, Inc.    All Rights Reserved.       *
'*                                                                          *
'*  This file contains declarations and functions for managing online       *
'*  forum messages.                                                         *
'*                                                                          *
'*                                                  - J. Alvrus 12/12/95    *
'*                                                                          *
'****************************************************************************

Option Explicit

Dim curonfor As Integer             ' current online forum ID
Dim curonnam As String              ' current online forum name
Dim curonthr As Long                ' currently displayed thread ID
Dim curontpc As String              ' currently displayed thread topic
Dim lastrdjmp As Integer            ' last read was a jump flag

Dim ldfornam As String              ' name of forum being loaded
Dim nmsgexp As Long                 ' number of messages expected
Dim nmsginfor As Long               ' total number of messages in current forum
Dim bakrqid As Integer              ' request ID for backward load read
Dim fwdrqid As Integer              ' request ID for forward load read
Dim numtoget As Integer             ' total number of messages to be gotten
Dim baktot As Integer               ' number of messages gotten by backward read
Dim fwdtot As Integer               ' number of messages gotten by forward read
Dim baktoget As Integer             ' expected number of backward-load messages
Dim fwdtoget As Integer             ' expected number of forward-load messages
Dim bakmore As Integer              ' there are more messages in backward direction
Dim fwdmore As Integer              ' there are more messages in forward direction
Dim bakarr() As msgdpkshrt          ' array of backward-loaded messages
Dim fwdarr() As msgdpkshrt          ' array of forward-loaded messages
Dim msgarr() As msgdpkshrt          ' array of messages currently in use

Dim finfrqid As Integer             ' forum details read request ID
Dim thrrqid As Integer              ' thread info read request ID
Dim nthrexp As Integer              ' number of threads expected
Dim thrtmp() As thrinfarrstruct     ' temporary array of threads used while loading
Dim thrarr() As thrinfarrstruct     ' array of threads currently in use

Dim unarqid As Integer              ' request ID of unapproved attachment read
Dim firstmsg As Integer             ' is this the first message with unapproved attachment found?
Dim abterm As Integer               ' unapproved attachment read was terminated abnormally

Private Sub listfmsg (ByVal fornam As String, ByVal forum As Integer, ByVal inilist As Integer, ByVal inimsgid As Long)
' list messages in a given forum
' fornam:   name of forum to list
' forum:    forum ID of forum to list
' inilist:  initialize list to non-default location?
' inimsgid: message ID to initialize list to

    Dim i As Integer
    Dim savsrc As Integer
    Dim comp As Long, mainmsg As Long

    savsrc = cursource
    cursource = SRCFORUM
    If inilist Then
        mainmsg = inimsgid
    Else
        mainmsg = hireadmsg(forum) + 1
    End If
    If Not loadforum(fornam, forum, mainmsg) Then
        cursource = savsrc
        Exit Sub
    End If
    setonlfor fornam, forum
    mainform!molstuna.Checked = False
    stdmlsetup
    setupmain
    stdmlcap "Forum:", fornam
    i = 0
    If ninmarr(msgarr()) Then
        i = nearmidx(comp, mainmsg, msgarr())
        If comp > 0 And i < ninmarr(msgarr()) - 1 Then
            i = i + 1
        End If
    End If
    showmsgs i
    stdmlfin
End Sub

Sub listforum ()
' select and list an online forum

    Dim tmps As String

    If Not abtonact() Then
        Exit Sub
    End If
    If Not chkforlst() Then
        If Not getforusrinf(True, mainform!forlstcbk) Then
            Exit Sub
        End If
    End If
    tmps = formfunc(selfor, CStr(SELSINGLE) & tb & CStr(curlstmode) & tb & "Select a Forum" & tb & Trim$(prefs.curfor) & tb & curgrpstr)
    If Len(tmps) Then
        curlstmode = Val(itemidx(tmps, 1))
        curgrpstr = itemidx(tmps, 2)
        saveflstpref
        prefs.curfor = itemidx(tmps, 0)
        lowlistfor itemidx(tmps, 0), curforinf.forum
    End If
End Sub

Private Sub listfthr (ByVal fornam As String, ByVal forum As Integer, ByVal inilist As Integer, ByVal inimsgid As Long, ByVal inithrid As Long)
' list threads in a given forum
' fornam:   name of forum to list
' forum:    forum ID of forum to list
' inilist:  initialize list to non-default location?
' inimsgid: message ID to initialize list to
' inithrid: thread ID to initialize list to

    Dim i As Integer, initidx As Integer
    Dim savsrc As Integer
    Dim comp As Long, mainmsg As Long

    savsrc = cursource
    cursource = SRCTHREAD
    If Not loadthreads(fornam, forum) Then
        cursource = savsrc
        Exit Sub
    End If
    setonlfor fornam, forum
    curonthr = 0
    curontpc = ""
    mainform!molstuna.Checked = False
    stdtlsetup True
    setupmain
    mainform!mttag.Visible = True
    stdtlcap "Forum:", curonnam
    showthrlst
    If inilist Then
        screen.MousePointer = DEFAULT
        initidx = findinlist(Trim$(thrarr(gettidx(inithrid, thrarr())).topic), mainform!thrlist)
        If initidx >= 0 Then
            mainform!thrlist.ListIndex = initidx
            ontlstmsg initidx, inimsgid
        End If
    Else
        Erase msgarr
        If nintarr(thrarr()) Then
            mainform!thrlist.ListIndex = 0
        End If
    End If
    stdtlfin
End Sub

Sub listunapv ()
' list messages with unapproved attachments in the current online forum

    Dim i As Integer
    Dim comp As Long, mainmsg As Long

    If Not abtonact() Then
        Exit Sub
    End If
    cursource = SRCUNAPV
    stdmlsetup
    mainform!molstuna.Checked = True
    mainform!molstmsg.Checked = False
    setupmain
    tbinvis mtbid, MTB_JFIRST & SETSEP & MTB_JSPEC & SETSEP & MTB_JLAST
    jmpmnuvis False
    stdmlcap "Forum:", curonnam
    maxlstlbl = 1
    Load mainform!lsttitle(1)
    Load mainform!lstname(1)
    mainform!lsttitle(1).Left = mainform!lstname(0).Left + mainform!lstname(0).Width + 2 * DIFFDIST
    mainform!lsttitle(1) = "(messages with unapproved attachments)"
    mainform!lstname(1) = ""
    mainform!lsttitle(1).Visible = True
    mainform!lstname(1).Visible = False
    caplblvis True
    mainform!msglist.ReFreshOnUpdate = True
    adjmsgtabs
    screen.MousePointer = DEFAULT
    If Not startuna() Then
        nosource
    End If
    fixmtb
End Sub

Private Function loadbak () As Integer
' load more backward message headers from a forum
' returns False if aborted

    Dim i As Integer, tmpmore As Integer

    loadbak = False
    screen.MousePointer = DEFAULT   ' other code sets hourglass when reading
    If Not appconnect() Then
        Exit Function
    End If
    progopen PRGT_BAR, "Loading Forum", "Retrieving headers in " & curonnam, "", ""
    tmpmore = fwdmore
    fwdmore = False     ' keep callback handler from trying to get more
    baktot = 0
    fwdtot = 0
    numtoget = prefs.onfgetsiz
    baktoget = numtoget
    fwdtoget = 0
    nmsgexp = nmsginfor - ninmarr(msgarr())
    If nmsgexp <= 0 Then
        nmsgexp = 1
    End If
    If numtoget < nmsgexp Then
        nmsgexp = numtoget
    End If
    ReDim bakarr(numtoget - 1)
    bakrqid = rltdpk("(c=n)" & FORHDRDPK & curonnam & " " & Format$(msgarr(0).msgid, MNMFMT), wtspace(FORHDRMIN & curonnam & " "), baktoget, mainform!loadcbk)
    Do
        DoEvents
        If progcancel() Then
            progclose
            fwdmore = tmpmore
            If bakrqid >= 0 Then
                abodpk bakrqid
            End If
            Erase bakarr
            Exit Function
        End If
        DoEvents
    Loop Until bakrqid < 0
    progupdate "100"
    fwdmore = tmpmore
    If baktot Then
        If baktot + ninmarr(msgarr()) > MAXLIST Then
            fwdmore = True
            If ninmarr(msgarr()) < MAXLIST Then
                ReDim Preserve msgarr(MAXLIST - 1)
            End If
        Else
            ReDim Preserve msgarr(baktot + ninmarr(msgarr()) - 1)
        End If
        For i = UBound(msgarr) To baktot Step -1
            msgarr(i) = msgarr(i - baktot)
        Next
        For i = 0 To baktot - 1
            msgarr(i) = bakarr(baktot - 1 - i)
        Next
        Erase bakarr
    Else
        bakmore = False
    End If
    progclose
    loadbak = True
End Function

Private Function loadforum (ByVal fornam As String, ByVal forum As Integer, ByVal hilitmid As Long) As Integer
' load message headers from a forum into memory
' fornam:   name of forum to load
' forum:    forum ID of forum to load
' hilitmid: message ID to center on
' returns False if aborted

    Dim i As Integer
    Dim bakmorsav As Integer, fwdmorsav As Integer
    Dim minmat As String, dpknam As String

    loadforum = False
    If Not appconnect() Then
        Exit Function
    End If
    screen.MousePointer = DEFAULT   ' other code sets hourglass when reading
    progopen PRGT_BAR, "Loading Forum", "Retrieving headers in " & fornam, "", ""
    ldfornam = fornam
    bakmorsav = bakmore
    fwdmorsav = fwdmore
    bakmore = True
    fwdmore = True
    baktot = 0
    fwdtot = 0
    baktoget = prefs.onfgetsiz
    fwdtoget = prefs.onfgetsiz
    numtoget = baktoget + fwdtoget
    nmsginfor = 0
    nmsgexp = numtoget
    ReDim bakarr(numtoget - 1)
    ReDim fwdarr(numtoget - 1)
    finfrqid = readpk(FDETDPK & Trim$(fornam), mainform!loadcbk)
    dpknam = "(c=n)" & FORHDRDPK & fornam & " " & Format$(hilitmid, MNMFMT)
    minmat = wtspace(FORHDRMIN & fornam & " ")
    bakrqid = rltdpk(dpknam, minmat, baktoget, mainform!loadcbk)
    fwdrqid = rgtdpk(olthan(dpknam, Len(dpknam)), minmat, fwdtoget, mainform!loadcbk)
    Do
        DoEvents
        If progcancel() Then
            progclose
            If finfrqid >= 0 Then
                abodpk finfrqid
            End If
            If bakrqid >= 0 Then
                abodpk bakrqid
            End If
            If fwdrqid >= 0 Then
                abodpk fwdrqid
            End If
            bakmore = bakmorsav
            fwdmore = fwdmorsav
            Erase bakarr
            Erase fwdarr
            Exit Function
        End If
        DoEvents
    Loop Until bakrqid < 0 And fwdrqid < 0
    progupdate "100"
    If finfrqid >= 0 Then
        abodpk finfrqid
    End If
    If baktot + fwdtot Then
        ReDim msgarr(baktot + fwdtot - 1)
        For i = 0 To baktot - 1
            msgarr(i) = bakarr(baktot - 1 - i)
        Next
        For i = 0 To fwdtot - 1
            msgarr(i + baktot) = fwdarr(i)
        Next
    Else
        Erase msgarr
    End If
    Erase bakarr
    Erase fwdarr
    progclose
    loadforum = True
End Function

Private Function loadfwd () As Integer
' load more backward message headers from a forum
' returns False if aborted

    Dim i As Integer, tmpmore As Integer, gap As Integer

    loadfwd = False
    screen.MousePointer = DEFAULT   ' other code sets hourglass when reading
    If Not appconnect() Then
        Exit Function
    End If
    progopen PRGT_BAR, "Loading Forum", "Retrieving headers in " & curonnam, "", ""
    tmpmore = bakmore
    bakmore = False     ' keep callback handler from trying to get more
    baktot = 0
    fwdtot = 0
    numtoget = prefs.onfgetsiz
    fwdtoget = numtoget
    baktoget = 0
    nmsgexp = nmsginfor - ninmarr(msgarr())
    If nmsgexp <= 0 Then
        nmsgexp = 1
    End If
    If numtoget < nmsgexp Then
        nmsgexp = numtoget
    End If
    ReDim fwdarr(numtoget - 1)
    fwdrqid = rgtdpk("(c=n)" & FORHDRDPK & curonnam & " " & Format$(msgarr(UBound(msgarr)).msgid, MNMFMT), wtspace(FORHDRMIN & curonnam & " "), fwdtoget, mainform!loadcbk)
    Do
        DoEvents
        If progcancel() Then
            progclose
            bakmore = tmpmore
            If fwdrqid >= 0 Then
                abodpk fwdrqid
            End If
            Erase fwdarr
            Exit Function
        End If
        DoEvents
    Loop Until fwdrqid < 0
    progupdate "100"
    bakmore = tmpmore
    If fwdtot Then
        If fwdtot + ninmarr(msgarr()) > MAXLIST Then
            bakmore = True
            gap = ninmarr(msgarr()) + fwdtot - MAXLIST
            For i = gap To ninmarr(msgarr()) - 1
                msgarr(i - gap) = msgarr(i)
            Next
            If ninmarr(msgarr()) < MAXLIST Then
                ReDim Preserve msgarr(MAXLIST - 1)
            End If
        Else
            ReDim Preserve msgarr(fwdtot + ninmarr(msgarr()) - 1)
        End If
        For i = 0 To fwdtot - 1
            msgarr(UBound(msgarr) + 1 - fwdtot + i) = fwdarr(i)
        Next
        Erase fwdarr
    Else
        fwdmore = False
    End If
    progclose
    loadfwd = True
End Function

Private Function loadthreads (ByVal fornam As String, ByVal forum As Integer) As Integer
' load message headers from a forum into memory
' fornam:   name of forum to load
' forum:    forum ID of forum to load
' hilitmid: message ID to center on
' returns False if aborted

    Dim i As Integer
    Dim minmat As String, dpknam As String

    loadthreads = False
    If Not appconnect() Then
        Exit Function
    End If
    progopen PRGT_BAR, "Loading Threads", "Retrieving threads in " & fornam, "", ""
    bakmore = False
    fwdmore = False
    nthrexp = 0
    Erase thrtmp
    finfrqid = readpk(FDETDPK & Trim$(fornam), mainform!loadcbk)
    thrrqid = rgtdpk("(c=n)" & THREADDPK & fornam & " 0", wtspace(THREADMIN & fornam & " "), -1, mainform!loadcbk)
    Do
        DoEvents
        If progcancel() Then
            progclose
            If thrrqid >= 0 Then
                abodpk thrrqid
            End If
            If finfrqid >= 0 Then
                abodpk finfrqid
            End If
            Erase thrtmp
            Exit Function
        End If
        DoEvents
    Loop Until thrrqid < 0
    progupdate "100"
    If nintarr(thrtmp()) Then
        ReDim thrarr(UBound(thrtmp))
        For i = 0 To UBound(thrtmp)
            thrarr(i) = thrtmp(i)
        Next
    Else
        Erase thrarr
    End If
    Erase thrtmp
    progclose
    loadthreads = True
End Function

Private Function loadtmsg (ByVal idx As Integer) As Integer
' load messages in a thread in current forum
' idx:  index in thrarr() of thread to load
' returns False if aborted

    Dim i As Integer
    Dim minmat As String, dpknam As String

    loadtmsg = False
    If Not appconnect() Then
        Exit Function
    End If
    progopen PRGT_BAR, "Loading Thread", "Retrieving headers in thread """ & Trim$(thrarr(idx).topic) & """", "", ""
    bakmore = False
    fwdmore = False
    fwdtot = 0
    numtoget = thrarr(idx).nmsgs
    If numtoget <= 0 Then
        numtoget = 1
    End If
    Erase fwdarr
    fwdrqid = rgtdpk(threxcdpknam(curonnam, thrarr(idx).thrid, 0), threxcmm(curonnam, thrarr(idx).thrid), -1, mainform!loadcbk)
    Do
        DoEvents
        If progcancel() Then
            progclose
            If fwdrqid >= 0 Then
                abodpk fwdrqid
            End If
            Erase fwdarr
            Exit Function
        End If
        DoEvents
    Loop Until fwdrqid < 0
    progupdate "100"
    If fwdtot Then
        ReDim msgarr(UBound(fwdarr))
        For i = 0 To fwdtot - 1
            msgarr(i) = fwdarr(i)
        Next
        Erase fwdarr
    Else
        Erase msgarr
    End If
    progclose
    loadtmsg = True
End Function

Sub lowlistfor (ByVal fornam As String, ByVal forum As Integer)
' low-level list an online forum (forum already selected)
' fornam:   name of forum to list
' forum:    forum ID of forum

    If prefs.sticky And SONLMSG Then
        listfmsg fornam, forum, False, 0
    Else
        listfthr fornam, forum, False, 0, 0
    End If
End Sub

Function onapvmsg (ByVal source As Integer, ByVal msgidstr As String, ByVal setto As Integer) As Integer
' Online Forums:  approve attachment to a message
' source:   message source in effect
' msgidstr: message ID string
' setto:    True to approve, False to unapprove
' returns True if successful

    Dim i As Integer
    Dim fornam As String
    Dim msgid As Long

    onapvmsg = False
    If source = SRCTHREAD Then
        fornam = itemidxd(msgidstr, 0, " ")
        msgid = Val(itemidxd(msgidstr, 2, " "))
    Else
        fornam = itemidxd(msgidstr, 0, " ")
        msgid = Val(itemidxd(msgidstr, 1, " "))
    End If
    If forapvmsg(fornam, msgid, setto) Then
        If sameas(curonnam, fornam) Then
            i = getmidx(msgid, msgarr())
            If i >= 0 Then
                setflg setto, msgarr(i).flags, FILAPV
            End If
        End If
        onapvmsg = True
    End If
End Function

Function oncandell (ByVal lstidx As Integer)
' can user delete this message (from list)
' lstidx:   index in message list of messages

    oncandell = False
    If ninmarr(msgarr()) Then
        If bakmore Then
            If lstidx = 0 Then
                Exit Function
            End If
            lstidx = lstidx - 1
        End If
        If fwdmore Then
            If lstidx >= ninmarr(msgarr()) Then
                Exit Function
            End If
        End If
        oncandell = forcandel(msgarr(lstidx))
    End If
End Function

Function oncanread (ByVal msgidstr As String, ByVal direc As Integer) As Integer
' Online Forums: can user read message in specified direction?
' msgidstr: identifier of current message (updated if successful)
' direc:    direction to read (-1=prev, 0=exact, 1=next)

    oncanread = True
End Function

Function oncanswthr (ByVal msgidstr As String, ByVal fornam As String, ByVal thrid As Long, ByVal direc As Integer) As Integer
' can user switch threads?
' msgidstr: message ID string
' fornam:   name of forum being read from
' thrid:    current thread ID
' direc:    direction to switch (previous/next)
' returns True if thread available

    Dim i As Integer

    oncanswthr = False
    If cursource = SRCTHREAD And sameas(fornam, curonnam) Then
        i = gettlstidx(thrid, thrarr())
        If i >= 0 Then
            Select Case direc
            Case READNEXT
                oncanswthr = (i < nintarr(thrarr()) - 1)
            Case READPREV
                oncanswthr = i > 0
            End Select
        End If
    End If
End Function

Function ondelmsg (ByVal msgidstr As String, ByVal source As Integer) As Integer
' Online Forums:  delete a message
' msgidstr: ID string of message to delete
' source:   source ID of message
' returns True if deleted

    Dim msgid As Long
    Dim fornam As String

    ondelmsg = False
    fornam = itemidxd(msgidstr, 0, " ")
    If source = SRCTHREAD Then
        msgid = Val(itemidxd(msgidstr, 2, " "))
    Else
        msgid = Val(itemidxd(msgidstr, 1, " "))
    End If
    If fordelmsg(fornam, msgid) Then
        junk = ondelmsgl(msgidstr, source)
        ondelmsg = True
    End If
End Function

Function ondelmsgl (ByVal msgidstr As String, ByVal source As Integer) As Integer
' Online Forums:  delete local copy of a message
' msgidstr: ID string of message to delete
' source:   source ID of message
' returns True if deleted

    Dim i As Integer
    Dim msgid As Long, thrid As Long
    Dim fornam As String

    fornam = itemidxd(msgidstr, 0, " ")
    If source = SRCTHREAD Then
        msgid = Val(itemidxd(msgidstr, 2, " "))
        thrid = thrid2num(itemidxd(msgidstr, 1, " "))
    Else
        msgid = Val(itemidxd(msgidstr, 1, " "))
    End If
    If sameas(curonnam, fornam) And ((cursource = SRCTHREAD And thrid = curonthr) Or cursource = SRCFORUM Or cursource = SRCUNAPV) Then
        i = delmarr(msgid, msgarr())
        If i >= 0 Then
            If bakmore Then
                i = i + 1
            End If
            remlbitem mainform!msglist, i
        End If
        updcurthr
    End If
    ondelmsgl = True
End Function

Function onforinuse () As Integer
' is online forums currently in use (the current source)?

    onforinuse = (cursource = SRCFORUM Or cursource = SRCTHREAD Or cursource = SRCUNAPV)
End Function

Function onfornam () As String
' get name of currently listed online forum

    onfornam = ""
    If onforinuse() Then
        onfornam = curonnam
    End If
End Function

Private Sub onjumpto (ByVal msgid As Long)
' jump message list to a specific message

    Dim i As Integer
    Dim comp As Long

    If msgid < msgarr(0).msgid Then
        If bakmore Then
            reloadat msgid
        Else
            setmsgidx 0
        End If
    ElseIf msgid > msgarr(UBound(msgarr)).msgid Then
        If fwdmore Then
            reloadat msgid
        Else
            setmsgidx UBound(msgarr)
        End If
    Else
        i = nearmidx(comp, msgid, msgarr())
        If comp < 0 And i > 0 Then
            i = i - 1
        End If
        If bakmore Then
            i = i + 1
        End If
        setmsgidx i
    End If
End Sub

Function onlistidx (ByVal msgidstr As String) As Integer
' Online Forums: get index of specified message in list of messages
' msgidstr: source-specific message ID string
' returns index or -1 if not found

    Dim i As Integer

    onlistidx = -1
    If sameas(curonnam, itemidxd(msgidstr, 0, " ")) Then
        i = getmidx(Val(itemidxd(msgidstr, 1, " ")), msgarr())
        If i >= 0 And bakmore Then
            i = i + 1
        End If
        onlistidx = i
    End If
End Function

Sub onlistjmp (ByVal jumpto As Integer)
' Online Forums:  move list selection to specified message
' jumpto:   which message to jump to code

    Dim tmpid As Long

    Select Case jumpto
    Case JUMPFRST
        If bakmore Then
            reloadat 0
        Else
            setmsgidx 0
        End If
    Case JUMPSPEC
        tmpid = getjmpmid()
        If tmpid >= 0 Then
            onjumpto tmpid
        End If
    Case JUMPLAST
        If fwdmore Then
            reloadat &H7FFFFFFF
        ElseIf bakmore Then
            setmsgidx UBound(msgarr) + 1
        Else
            setmsgidx UBound(msgarr)
        End If
    End Select
End Sub

Sub onloadcbk (ByVal evtstg As String, ByVal reqid As Integer)
' online forum load messages callback handler

    Dim msg As msgdpkshrt
    Dim fdet() As viewfdpk

    If reqid = bakrqid Then
        Select Case evtstg
        Case "Dynapak received"
            junk = cbkrsp(Len(msg), msg)
            stpnls msg.info
            bakarr(baktot) = msg
            baktot = baktot + 1
            If baktot >= baktoget Then
                bakrqid = -1
                If (baktot + fwdtot) < numtoget And fwdrqid < 0 And fwdtot < fwdtoget And Not fwdmore Then
                    baktoget = baktoget + fwdtoget - fwdtot
                    bakrqid = rltdpk("(c=n)" & FORHDRDPK & ldfornam & " " & Format$(bakarr(baktot - 1).msgid, MNMFMT), wtspace(FORHDRMIN & ldfornam & " "), fwdtoget - fwdtot, mainform!loadcbk)
                End If
            End If
            progupdate CStr(100& * (baktot + fwdtot) \ nmsgexp)
        Case "No more dynapaks"
            bakmore = False
            bakrqid = -1
            If (baktot + fwdtot) < numtoget And fwdrqid < 0 And fwdmore Then
                fwdtoget = fwdtoget + baktoget - baktot
                fwdrqid = rgtdpk("(c=n)" & FORHDRDPK & ldfornam & " " & Format$(fwdarr(fwdtot - 1).msgid, MNMFMT), wtspace(FORHDRMIN & ldfornam & " "), baktoget - baktot, mainform!loadcbk)
            End If
        Case Else
            bakrqid = -1
        End Select
    ElseIf reqid = fwdrqid Then
        Select Case evtstg
        Case "Dynapak received"
            junk = cbkrsp(Len(msg), msg)
            stpnls msg.info
            fwdarr(fwdtot) = msg
            fwdtot = fwdtot + 1
            If fwdtot >= fwdtoget Then
                fwdrqid = -1
                If (baktot + fwdtot) < numtoget And bakrqid < 0 And baktot < baktoget And Not bakmore Then
                    fwdtoget = fwdtoget + baktoget - baktot
                    fwdrqid = rgtdpk("(c=n)" & FORHDRDPK & ldfornam & " " & Format$(fwdarr(fwdtot - 1).msgid, MNMFMT), wtspace(FORHDRMIN & ldfornam & " "), baktoget - baktot, mainform!loadcbk)
                End If
            End If
            progupdate CStr(100& * (baktot + fwdtot) \ nmsgexp)
        Case "No more dynapaks"
            fwdmore = False
            fwdrqid = -1
            If (baktot + fwdtot) < numtoget And bakrqid < 0 And bakmore Then
                baktoget = baktoget + fwdtoget - fwdtot
                bakrqid = rltdpk("(c=n)" & FORHDRDPK & ldfornam & " " & Format$(bakarr(baktot - 1).msgid, MNMFMT), wtspace(FORHDRMIN & ldfornam & " "), fwdtoget - fwdtot, mainform!loadcbk)
            End If
        Case Else
            fwdrqid = -1
        End Select
    ElseIf reqid = finfrqid Then
        finfrqid = -1
        Select Case evtstg
        Case "Dynapak received", "Dynapak available"
            ReDim fdet(0)
            junk = cbkrsp(Len(fdet(0)), fdet(0))
            nmsginfor = fdet(0).nmsgs
            If nmsginfor <= 0 Then
                nmsginfor = 1
            End If
            If nmsginfor < numtoget Then
                nmsgexp = nmsginfor
            End If
            Erase fdet
        End Select
    End If
End Sub

Sub onlstypchg (ByVal msgtype As Integer)
' Online Forums: change list type option
' msgtype:  change to message type if True, thread type if False
' Note: this code assumes that online forums is the current source

    Dim newsource As Integer, idx As Integer
    Dim msgid As Long, thrid As Long

    setflg msgtype, prefs.sticky, SONLMSG
    mainform!molstmsg.Checked = (prefs.sticky And SONLMSG) <> 0
    mainform!molstthr.Checked = (prefs.sticky And SONLMSG) = 0
    mainform!molstuna.Checked = False
    If prefs.sticky And SONLMSG Then
        newsource = SRCFORUM
    Else
        newsource = SRCTHREAD
    End If
    If cursource <> newsource Then
        idx = mainform!msglist.ListIndex
        If bakmore Then
            idx = idx - 1
        End If
        If idx < 0 Or idx >= ninmarr(msgarr()) Then
            newsource = False
            msgid = 0
            thrid = 0
        Else
            newsource = True
            msgid = msgarr(idx).msgid
            thrid = msgarr(idx).thrid
        End If
        If prefs.sticky And SONLMSG Then
            listfmsg curonnam, curonfor, newsource, msgid
        Else
            listfthr curonnam, curonfor, newsource, msgid, thrid
        End If
    End If
End Sub

Sub onpreprd (ByVal lstidx As Integer, capstr As String, btnflgs As Integer, capflgs As Integer, msgidstr As String)
' Online Forums:  prepare arguments to launch read form with
' lstidx:   index in message list of message to prepare
' capstr:   read form caption
' btnflgs:  button flags
' capflgs:  capability flags
' msgidstr: message ID string

    Dim cmpidx As Integer

    If ninmarr(msgarr()) Then
        If lstidx = 0 And bakmore Then
            msgidstr = Chr$(0)
            Exit Sub
        End If
        cmpidx = UBound(msgarr) + 1
        If bakmore Then
            cmpidx = cmpidx + 1
        End If
        If lstidx = cmpidx And fwdmore Then
            msgidstr = Chr$(1)
            Exit Sub
        End If
        capstr = "Message in " & curonnam
        btnflgs = RDBALL
        capflgs = RDCDEL Or RDCFOROP
        If bakmore Then
            lstidx = lstidx - 1
        End If
        msgidstr = curonnam & " " & Format$(msgarr(lstidx).msgid, MNMFMT)
    End If
End Sub

Function onreadjmp (msgidstr As String, ByVal jumpto As Integer) As Integer
' Online Forums: jump to (and read) a message
' msgidstr: message ID string of current message (updated if new message found)
' jumpto:   what message to jump to
' returns True if message found

    Dim i As Integer, direc As Integer
    Dim tmpid As Long, comp As Long
    Dim tmps As String

    onreadjmp = False
    Select Case jumpto
    Case JUMPFRST
        tmps = itemidxd(msgidstr, 0, " ") & " " & Format$(0, MNMFMT)
        If onreadmsg(tmps, READNEXT) Then
            msgidstr = tmps
            onreadjmp = True
            lastrdjmp = True
        End If
    Case JUMPSPEC
        tmpid = getjmpmid()
        If tmpid >= 0 Then
            tmps = itemidxd(msgidstr, 0, " ") & " " & Format$(tmpid + 1, MNMFMT)
            If onreadmsg(tmps, READPREV) Then
                msgidstr = tmps
                onreadjmp = True
                lastrdjmp = True
                Exit Function
            End If
            tmps = itemidxd(msgidstr, 0, " ") & " " & Format$(tmpid, MNMFMT)
            If onreadmsg(tmps, READNEXT) Then
                msgidstr = tmps
                onreadjmp = True
                lastrdjmp = True
            End If
        End If
    Case JUMPLAST
        tmps = itemidxd(msgidstr, 0, " ") & " " & Format$(&H7FFFFFFF, MNMFMT)
        If onreadmsg(tmps, READPREV) Then
            msgidstr = tmps
            onreadjmp = True
            lastrdjmp = True
        End If
    End Select
End Function

Function onreadmsg (msgidstr As String, ByVal direc As Integer) As Integer
' Online Forums:  read-a-message function
' msgidstr: identifier of current message (updated if successful)
' direc:    direction to read (-1=prev, 0=exact, 1=next)
' returns:  True if message found
' implicit output: message is in msgindpk if returns True

    Dim rsplen As Integer
    Dim fornam As String

    onreadmsg = False
    lastrdjmp = False
    If msgidstr = Chr$(0) Then      ' load backward messages
        If loadbak() Then
            If baktot Then
                redisplay baktot - 1
            Else
                redisplay 0
            End If
        End If
        Exit Function
    ElseIf msgidstr = Chr$(1) Then  ' load forward messages
        If loadfwd() Then
            If fwdtot Then
                redisplay ninmarr(msgarr()) - fwdtot
            Else
                redisplay ninmarr(msgarr()) - 1
            End If
        End If
        Exit Function
    End If
    rsplen = 0
    If appconnect() Then
        fornam = itemidxd(msgidstr, 0, " ")
        Select Case direc
        Case READPREV
            rsplen = srltdpk(FORMSGDPK & msgidstr, wtspace(FORMSGMIN & fornam & " "), Len(msgindpk), msgindpk)
        Case READTHIS
            rsplen = sreadpk(FORMSGDPK & msgidstr, Len(msgindpk), msgindpk)
            lastrdjmp = True        ' return from thread may exceed bounds
        Case READNEXT
            rsplen = srgtdpk(FORMSGDPK & msgidstr, wtspace(FORMSGMIN & fornam & " "), Len(msgindpk), msgindpk)
        End Select
        If rsplen Then
            msgidstr = Trim$(msgindpk.fornam) & " " & Format$(msgindpk.msgid, MNMFMT)
            stpnls msgindpk.info
        End If
    End If
    onreadmsg = rsplen <> 0
End Function

Function onreadthr (msgidstr As String, ByVal fornam As String, ByVal msgid As Long, ByVal thrid As Long, rplto As globid, ByVal direc As Integer, ByVal source As Integer) As Integer
' Online Forums: read a message in a thread
' msgidstr: identifier of current message (updated if successful)
' fornam:   forum name or "" if email
' msgid:    current message ID
' thrid:    current thread ID
' rplto:    reply-to ID of current message
' direc:    direction to read (-1=prev, 0=parent, 1=next)
' source:   message source in effect (must be SRCFORUM or SRCTHREAD or SRCUNAPV)
' returns:  True if message found
' implicit output: message is in msgindpk if returns True

    onreadthr = False
    If appconnect() Then
        If forreadthr(fornam, msgid, thrid, direc) Then
            If source = SRCTHREAD Then
                msgidstr = Trim$(msgindpk.fornam) & " " & thrid2stg(msgindpk.thrid) & " " & Format$(msgindpk.msgid, MNMFMT)
            Else
                msgidstr = Trim$(msgindpk.fornam) & " " & Format$(msgindpk.msgid, MNMFMT)
                If source = SRCFORUM Then
                    lastrdjmp = True    'can't be sure how far thread will go
                End If
            End If
            onreadthr = True
        ElseIf source = SRCUNAPV Then
            endofthr direc
        End If
    End If
End Function

Function onswthr (msgidstr As String, capstr As String, ByVal fornam As String, ByVal thrid As Long, ByVal direc As Integer) As Integer
' switch threads
' msgidstr: message ID string (updated if successful)
' capstr:   message window caption (updated if successful)
' fornam:   name of forum being read from
' thrid:    current thread ID
' direc:    direction to switch (previous/next)
' returns True if thread available

    Dim lstidx As Integer
    Dim tmps As String

    onswthr = False
    If cursource = SRCTHREAD And sameas(fornam, curonnam) Then
        lstidx = gettlstidx(thrid, thrarr())
        Select Case direc
        Case READNEXT
            If lstidx < nintarr(thrarr()) - 1 Then
                If appconnect() Then
                    If forreadthr(fornam, 0&, thrarr(Val(iteminfo(mainform!thrlist.List(lstidx + 1), MLI_THRIDX))).thrid, READNEXT) Then
                        msgidstr = Trim$(msgindpk.fornam) & " " & thrid2stg(msgindpk.thrid) & " " & Format$(msgindpk.msgid, MNMFMT)
                        capstr = """" & frontstr(getminf(RTrim$(msgindpk.info), TPCFLD), 15) & """ Thread in " & curonnam
                        onswthr = True
                    Else
                        nothr direc
                    End If
                End If
            End If
        Case READPREV
            If lstidx > 0 Then
                If appconnect() Then
                    If forreadthr(fornam, &H7FFFFFFF, thrarr(Val(iteminfo(mainform!thrlist.List(lstidx - 1), MLI_THRIDX))).thrid, READPREV) Then
                        msgidstr = Trim$(msgindpk.fornam) & " " & thrid2stg(msgindpk.thrid) & " " & Format$(msgindpk.msgid, MNMFMT)
                        capstr = """" & frontstr(getminf(RTrim$(msgindpk.info), TPCFLD), 15) & """ Thread in " & curonnam
                        onswthr = True
                    Else
                        nothr direc
                    End If
                End If
            End If
        End Select
    Else
        popmsg "You can only switch between threads in the currently selected forum.", "Forums"
    End If
End Function

Sub onsynclst (ByVal msgidstr As String)
' Online Forums: synchronize list with given message
' msgidstr: ID string of message to synchronize with

    Dim i As Integer
    Dim msgid As Long, comp As Long

    If cursource = SRCFORUM And sameas(curonnam, itemidxd(msgidstr, 0, " ")) Then
        msgid = Val(itemidxd(msgidstr, 1, " "))
        If lastrdjmp Then
            onjumpto msgid
        Else
            If msgid < msgarr(0).msgid Then
                If loadbak() Then
                    i = nearmidx(comp, msgid, msgarr())
                    If comp < 0 And i > 0 Then
                        i = i - 1
                    End If
                    redisplay i
                End If
            ElseIf msgid > msgarr(UBound(msgarr)).msgid Then
                If loadfwd() Then
                    i = nearmidx(comp, msgid, msgarr())
                    If comp < 0 And i > 0 Then
                        i = i - 1
                    End If
                    redisplay i
                End If
            Else
                i = nearmidx(comp, msgid, msgarr())
                If comp < 0 And i > 0 Then
                    i = i - 1
                End If
                If bakmore Then
                    i = i + 1
                End If
                setmsgidx i
            End If
        End If
        lastrdjmp = False
    End If
End Sub

Function ontjmpidx (ByVal jumpto As Integer) As Integer
' get index of message in msgarr() to jump to
' jumpto:   which message to jump to code
' returns index or -1 if cancelled

    Dim i As Integer
    Dim msgid As Long, comp As Long

    ontjmpidx = -1
    Select Case jumpto
    Case JUMPFRST
        ontjmpidx = 0
    Case JUMPSPEC
        msgid = getjmpmid()
        If msgid >= 0 Then
            If msgid < msgarr(0).msgid Then
                ontjmpidx = 0
            ElseIf msgid > msgarr(UBound(msgarr)).msgid Then
                ontjmpidx = UBound(msgarr)
            Else
                i = nearmidx(comp, msgid, msgarr())
                If comp < 0 And i > 0 Then
                    i = i - 1
                End If
                ontjmpidx = i
            End If
        End If
    Case JUMPLAST
        ontjmpidx = UBound(msgarr)
    End Select
End Function

Function ontlistidx (ByVal msgidstr As String) As Integer
' Online Forums: get index of specified message in list of messages
' msgidstr: source-specific message ID string
' returns index or -1 if not found

    Dim i As Integer

    ontlistidx = -1
    If sameas(curonnam, itemidxd(msgidstr, 0, " ")) And curonthr = thrid2num(itemidxd(msgidstr, 1, " ")) Then
        ontlistidx = getmidx(Val(itemidxd(msgidstr, 2, " ")), msgarr())
    End If
End Function

Sub ontlistjmp (ByVal jumpto As Integer)
' Online Forums (Thread):  move list selection to specified message
' jumpto:   which message to jump to code

    Dim i As Integer

    i = ontjmpidx(jumpto)
    If i >= 0 Then
        setmsgidx i
    End If
End Sub

Sub ontloadcbk (ByVal evtstg As String, ByVal reqid As Integer)
' online forum load messages callback handler

    Dim i As Integer
    Dim thrinf As threadinf
    Dim msg As msgdpkshrt
    Dim fdet() As viewfdpk

    If reqid = thrrqid Then
        Select Case evtstg
        Case "Dynapak received", "Dynapak available"
            junk = cbkrsp(Len(thrinf), thrinf)
            stpnls thrinf.topic
            i = nintarr(thrtmp())
            ReDim Preserve thrtmp(i)
            thrtmp(i).thrid = thrid2num(itemidxd(suffix(namdpk()), 2, " "))
            thrtmp(i).nmsgs = thrinf.nmsgs
            thrtmp(i).topic = thrinf.topic
            If nthrexp Then
                progupdate CStr(100& * nintarr(thrtmp()) \ nthrexp)
            End If
        Case Else
            thrrqid = -1
        End Select
    ElseIf reqid = finfrqid Then
        finfrqid = -1
        Select Case evtstg
        Case "Dynapak received", "Dynapak available"
            ReDim fdet(0)
            junk = cbkrsp(Len(fdet(0)), fdet(0))
            nthrexp = fdet(0).nthrs
            If nthrexp < 0 Then
                nthrexp = 0
            End If
            Erase fdet
        End Select
    ElseIf reqid = fwdrqid Then
        Select Case evtstg
        Case "Dynapak received"
            junk = cbkrsp(Len(msg), msg)
            stpnls msg.info
            ReDim Preserve fwdarr(fwdtot)
            fwdarr(fwdtot) = msg
            fwdtot = fwdtot + 1
            progupdate CStr(100& * fwdtot \ numtoget)
        Case Else
            fwdrqid = -1
        End Select
    End If
End Sub

Sub ontlstmsg (ByVal lstidx As Integer, ByVal inimsgid As Long)
' Online Forums: list messages in a thread in the current forum
' lstidx:   index in thread list of thread to list
' inimsgid: message ID to initialize list at or 0 for default

    Dim arridx As Integer

    arridx = Val(iteminfo(mainform!thrlist.List(lstidx), MLI_THRIDX))
    If Not loadtmsg(arridx) Then
        Exit Sub
    End If
    screen.MousePointer = HOURGLASS
    curonthr = thrarr(arridx).thrid
    curontpc = Trim$(thrarr(arridx).topic)
    updcurthr
    mainform!msglist.ReFreshOnUpdate = False
    mainform!msglist.Clear
    mainform!lstname(1) = dblamp(curontpc)
    showtmsgs inimsgid
    stdmlfin
End Sub

Function ontogtag (flags As Integer, ByVal idx As Integer, ByVal source As Integer) As Integer
' Online Forums: toggle a message's tagged status from list of messages
' flags:    current message list flags (updated by handler)
' idx:      index in list of message to tag
' source:   message source code (must be SRCFORUM or SRCTHREAD or SRCUNAPV)
' returns True if message tag toggled successfully

    ontogtag = False
    If source = SRCFORUM Then
        If (bakmore And idx = 0) Or (fwdmore And idx = ninmarr(msgarr()) - 1) Then
            Exit Function
        End If
        If bakmore Then
            idx = idx - 1
        End If
    End If
    togglemsg msgarr(idx).msgid, msgarr(idx).thrid, curonnam
    setflg msgtagged(msgarr(idx).msgid, msgarr(idx).thrid, curonfor), flags, MLF_TAGGED
    ontogtag = True
End Function

Function ontogthrtg (flags As Integer, ByVal idx As Integer) As Integer
' Online Forums: toggle a message's tagged status from list of messages
' flags:    current message list flags (updated by handler)
' idx:      index in list of message to tag
' returns True if message tag toggled successfully

    Dim thrid As Long

    ontogthrtg = False
    idx = Val(iteminfo(mainform!thrlist.List(idx), MLI_THRIDX))
    thrid = thrarr(idx).thrid
    togglethr thrid, curonnam
    setflg thrtagged(thrid, curonfor), flags, MLF_TAGGED
    If thrid = curonthr Then
        updmlstpic
    End If
    ontogthrtg = True
End Function

Sub ontpreprd (ByVal lstidx As Integer, capstr As String, btnflgs As Integer, capflgs As Integer, msgidstr As String)
' Online Forums (Thread):  prepare arguments to launch read form with
' lstidx:   index in message list of message to prepare
' capstr:   read form caption
' btnflgs:  button flags
' capflgs:  capability flags
' msgidstr: message ID string

    Dim cmpidx As Integer

    If ninmarr(msgarr()) Then
        capstr = """" & frontstr(curontpc, 15) & """ Thread in " & curonnam
        btnflgs = RDBTHREAD Or RDBNPTHR Or RDBJUMP
        capflgs = RDCDEL Or RDCFOROP
        msgidstr = curonnam & " " & thrid2stg(curonthr) & " " & Format$(msgarr(lstidx).msgid, MNMFMT)
    End If
End Sub

Function ontreadjmp (msgidstr As String, ByVal jumpto As Integer) As Integer
' Online Forums (Thread): jump to (and read) a message
' msgidstr: message ID string of current message (updated if new message found)
' jumpto:   what message to jump to
' returns True if message found

    Dim i As Integer
    Dim msgid As Long, thrid As Long
    Dim tmps As String, fornam As String
    Dim bogusrplto As globid

    ontreadjmp = False
    fornam = itemidxd(msgidstr, 0, " ")
    thrid = thrid2num(itemidxd(msgidstr, 1, " "))
    If sameas(fornam, curonnam) And thrid = curonthr Then
        i = ontjmpidx(jumpto)
        If i >= 0 Then
            tmps = fornam & " " & thrid2stg(thrid) & " " & Format$(msgarr(i).msgid, MNMFMT)
            If ontreadmsg(tmps, READTHIS) Then
                ontreadjmp = True
                msgidstr = tmps
            End If
        End If
    Else
        Select Case jumpto
        Case JUMPFRST
            tmps = fornam & " " & thrid2stg(thrid) & " " & Format$(0, MNMFMT)
            If onreadthr(tmps, fornam, 0, thrid, bogusrplto, READNEXT, SRCTHREAD) Then
                ontreadjmp = True
                msgidstr = tmps
            End If
        Case JUMPSPEC
            msgid = getjmpmid()
            If msgid >= 0 Then
                tmps = fornam & " " & thrid2stg(thrid) & " " & Format$(msgid + 1, MNMFMT)
                If onreadthr(tmps, fornam, msgid, thrid, bogusrplto, READPREV, SRCTHREAD) Then
                    ontreadjmp = True
                    msgidstr = tmps
                    Exit Function
                End If
                tmps = fornam & " " & thrid2stg(thrid) & " " & Format$(msgid, MNMFMT)
                If onreadthr(tmps, fornam, msgid, thrid, bogusrplto, READNEXT, SRCTHREAD) Then
                    ontreadjmp = True
                    msgidstr = tmps
                End If
            End If
        Case JUMPLAST
            tmps = fornam & " " & thrid2stg(thrid) & " " & Format$(&H7FFFFFFF, MNMFMT)
            If onreadthr(tmps, fornam, &H7FFFFFFF, thrid, bogusrplto, READPREV, SRCTHREAD) Then
                ontreadjmp = True
                msgidstr = tmps
            End If
        End Select
    End If
End Function

Function ontreadmsg (msgidstr As String, ByVal direc As Integer) As Integer
' Online Forums (Thread):  read-a-message function
' msgidstr: identifier of current message (updated if successful)
' direc:    direction to read (-1=prev, 0=exact, 1=next)
' returns:  True if message found
' implicit output: message is in msgindpk if returns True

    ontreadmsg = False
    If direc = READTHIS Then
        If appconnect() Then
            If sreadpk(THRMSGDPK & msgidstr, Len(msgindpk), msgindpk) Then
                msgidstr = Trim$(msgindpk.fornam) & " " & thrid2stg(msgindpk.thrid) & " " & Format$(msgindpk.msgid, MNMFMT)
                stpnls msgindpk.info
                ontreadmsg = True
            End If
        End If
    End If
End Function

Sub ontsynclst (ByVal msgidstr As String)
' Online Forums (Thread): synchronize list with given message
' msgidstr: ID string of message to synchronize with

    Dim lstidx As Integer, mpsave As Integer
    Dim msgid As Long, thrid As Long

    If cursource = SRCTHREAD And sameas(curonnam, itemidxd(msgidstr, 0, " ")) Then
        thrid = thrid2num(itemidxd(msgidstr, 1, " "))
        msgid = Val(itemidxd(msgidstr, 2, " "))
        If thrid = curonthr Then
            lstidx = getmidx(msgid, msgarr())
            If lstidx >= 0 Then
                setmsgidx lstidx
            End If
        Else
            lstidx = gettlstidx(thrid, thrarr())
            If lstidx >= 0 Then
                mpsave = screen.MousePointer
                screen.MousePointer = NORMAL
                ontlstmsg lstidx, msgid
                screen.MousePointer = mpsave
                If curonthr = thrid Then
                    mainform!thrlist.ListIndex = lstidx
                End If
            End If
        End If
    End If
End Sub

Sub ontupdtgs (ByVal fornam As String, ByVal thrid As Long)
' update lists due to change in thread tagged status
' fornam:   name of forum in which thread tag changed
' thrid:    thread ID of thread that changed

    Dim i As Integer, flags As Integer
    Dim tmps As String

    If fornam = curonnam Then
        i = gettidx(thrid, thrarr())
        If i >= 0 Then
            i = findinlist(Trim$(thrarr(i).topic), mainform!thrlist)
            If i >= 0 Then
                tmps = mainform!thrlist.List(i)
                flags = Val(iteminfo(tmps, MLI_FLAGS))
                setflg thrtagged(thrid, curonfor), flags, MLF_TAGGED
                mainform!thrlist.ReFreshOnUpdate = False
                mainform!thrlist.List(i) = setitminf(tmps, MLI_FLAGS, CStr(flags))
                settlpic mainform!thrlist, i, flags
                mainform!thrlist.ReFreshOnUpdate = True
                updmlstpic
            End If
        End If
    End If
End Sub

Private Sub onupdmsgtg (ByVal arridx As Integer)
' update a message's tagged status

    Dim lstidx As Integer

    lstidx = arridx
    If bakmore Then
        lstidx = lstidx + 1
    End If
    updmtag lstidx, msgarr(arridx).forum, msgarr(arridx).thrid, msgarr(arridx).msgid
End Sub

Sub onupdmtg (ByVal fornam As String, ByVal msgid As Long)
' update message list due to change in message tagged status
' fornam:   name of forum in which tag changed
' msgid:    message ID of message that changed

    Dim i As Integer

    If fornam = curonnam Then
        i = getmidx(msgid, msgarr())
        If i >= 0 Then
            mainform!msglist.ReFreshOnUpdate = False
            onupdmsgtg i
            mainform!msglist.ReFreshOnUpdate = True
        End If
    End If
End Sub

Sub onupdtgs (ByVal fornam As String)
' update lists due to change in thread/message tagged status
' fornam:   name of forum in which change has occurred

    If fornam = curonnam Then
        updmlstpic
    End If
End Sub

Function onxmtmsg (ByVal source As Integer, ByVal msgidstr As String, ByVal setto As Integer) As Integer
' Online Forums:  approve attachment to a message
' source:   message source in effect
' msgidstr: message ID string
' setto:    True to approve, False to unapprove
' returns True if successful

    Dim i As Integer
    Dim fornam As String
    Dim msgid As Long

    onxmtmsg = False
    If source = SRCTHREAD Then
        fornam = itemidxd(msgidstr, 0, " ")
        msgid = Val(itemidxd(msgidstr, 2, " "))
    Else
        fornam = itemidxd(msgidstr, 0, " ")
        msgid = Val(itemidxd(msgidstr, 1, " "))
    End If
    If forxmtmsg(fornam, msgid, setto) Then
        If sameas(curonnam, fornam) Then
            i = getmidx(msgid, msgarr())
            If i >= 0 Then
                setflg setto, msgarr(i).flags, EXEMPT
            End If
        End If
        onxmtmsg = True
    End If
End Function

Private Sub redisplay (ByVal hilite As Integer)
' redisplay list of messages
' hilite:   index of message to highlight

    screen.MousePointer = HOURGLASS
    mainform!msglist.ReFreshOnUpdate = False
    mainform!msglist.Clear
    showmsgs hilite
    mainform!msglist.ReFreshOnUpdate = True
    screen.MousePointer = DEFAULT
End Sub

Private Sub reloadat (ByVal hilitmid As Long)
' reload messages at a particular message
' hilitmid: message ID to center on

    Dim i As Integer
    Dim comp As Long

    If loadforum(curonnam, curonfor, hilitmid) Then
        i = nearmidx(comp, hilitmid, msgarr())
        If comp < 0 And i > 0 Then
            i = i - 1
        End If
        redisplay i
    End If
End Sub

Private Sub add2tmlst (flags As Integer, msg As msgdpkshrt)
' add a message to the list of messages in a thread
' flags:    message info flags
' msg:      message header structure

    flags = MLF_TGABLE
    If msgtagged(msg.msgid, msg.thrid, msg.forum) Then
        flags = flags Or MLF_TAGGED
    End If
    flags = mlflags(msg, flags)
    mainform!msglist.AddItem Format$(msg.crdatim, DATEFMT) & tb & getminf(msg.info, FROMFLD) & tb & getminf(msg.info, TPCFLD) & tb & flags
    setmlpic mainform!msglist, mainform!msglist.LastAdded, flags
End Sub

Private Sub canunapv ()
' cancel unapproved attachments read request

    Dim tmpid As Integer

    If unarqid >= 0 Then
        tmpid = unarqid
        unarqid = -1
        abodpk tmpid
    End If
End Sub

Sub setonlfor (ByVal fornam As String, ByVal forum As Integer)
' set current online forum context
' fornam:   current online forum name
' forum:    current online forum ID

    curonfor = forum
    curonnam = fornam
End Sub

Private Sub setupmain ()
' set up main form menu/toolbar

    tbvis mtbid, MTB_DELETE & SETSEP & MTB_JFIRST & SETSEP & MTB_JSPEC & SETSEP & MTB_JLAST & SETSEP & MTB_LSTMSG & SETSEP & MTB_LSTTHR
    mainform!mfdel.Visible = True
    jmpmnuvis True
    tagmnuvis True
    mainform!mfgettag.Visible = True
    lopmnuvis True
    fopmnuvis True, curonnam
End Sub

Private Sub showmsgs (ByVal hilite As Integer)
' show list of messages
' hilite:   index of message to highlight

    Dim i As Integer

    If ninmarr(msgarr()) Then
        If bakmore Then
            mainform!msglist.AddItem "more..."
            mainform!msglist.Picture(0) = mainform!morebak
        End If
        For i = 0 To ninmarr(msgarr()) - 1
            add2mlst msgarr(i)
        Next
        If fwdmore Then
            mainform!msglist.AddItem "more..."
            mainform!msglist.Picture(mainform!msglist.LastAdded) = mainform!morefwd
        End If
        If ninmarr(msgarr()) Then
            If hilite < 0 Then
                hilite = 0
            ElseIf hilite >= ninmarr(msgarr()) Then
                hilite = ninmarr(msgarr()) - 1
            End If
            If bakmore Then
                hilite = hilite + 1
            End If
            If hilite Then
                mainform!msglist.TopIndex = hilite - 1
            End If
            setmsgidx hilite
        ElseIf bakmore Or fwdmore Then
            setmsgidx 0
        End If
    End If
End Sub

Private Sub showthrlst ()
' show thread list

    Dim i As Integer, flags As Integer

    For i = 0 To nintarr(thrarr()) - 1
        mainform!thrlist.AddItem thrlstitem(i, flags)
        settlpic mainform!thrlist, mainform!thrlist.LastAdded, flags
    Next
    For i = 0 To nintarr(thrarr()) - 1
        thrarr(Val(iteminfo(mainform!thrlist.List(i), MLI_THRIDX))).lstidx = i
    Next
End Sub

Private Sub showtmsgs (ByVal inimsgid As Long)
' show list of messages in a thread
' inimsgid: message ID to put cursor on (or 0 for default)

    Dim i As Integer, flags As Integer, lastread As Integer, rdfnd As Integer
    Dim comp As Long

    lastread = 0
    rdfnd = False
    If ninmarr(msgarr()) Then
        For i = 0 To ninmarr(msgarr()) - 1
            add2tmlst flags, msgarr(i)
            If flags And MLF_READ Then
                lastread = i
                rdfnd = True
            End If
        Next
        If inimsgid Then
            i = nearmidx(comp, inimsgid, msgarr())
            If comp > 0 And i < ninmarr(msgarr()) - 1 Then
                i = i + 1
            End If
        Else
            i = lastread
            If i + 1 < mainform!msglist.ListCount And rdfnd Then
                i = i + 1
            End If
        End If
        If i Then
            mainform!msglist.TopIndex = i - 1
        End If
        setmsgidx i
    End If
End Sub

Private Function startuna () As Integer
' load messages in a scan
' returns False if aborted

    Dim tmps As String

    startuna = False
    If appconnect() Then
        progopen PRGT_INF, "Starting Scan", "", "Searching for first unapproved attachment...", ""
        firstmsg = True
        abterm = False
        tmps = wtspace(curonnam & " ")
        unarqid = rgtdpk(UNAHDRDPK & tmps, UNAHDRMIN & tmps, -1, mainform!loadcbk)
        Do
            DoEvents
            If progcancel() Then
                progclose
                canunapv
                Exit Function
            End If
        Loop Until unarqid < 0 Or Not firstmsg
        progclose
        If firstmsg Then
            If abterm Then
                popmsg "Scan for unapproved attachments terminated abnormally.", ""
            Else
                popmsg "No messages with unapproved attachments were found.", ""
            End If
        Else
            bakmore = False
            fwdmore = False
            setmsgidx 0
        End If
        On Error Resume Next
        mainform!msglist.SetFocus
        startuna = Not firstmsg
    End If
End Function

Private Function threxcdpknam (ByVal fornam As String, ByVal thrid As Long, ByVal msgid As Long)
' create thread excerpt dynapak name
' fornam:   forum name to use
' thrid:    thread ID to use
' msgid:    message ID to use

    threxcdpknam = THREXCDPK & fornam & " " & thrid2stg(thrid) & " " & Format$(msgid, MNMFMT)
End Function

Private Function threxcmm (ByVal fornam As String, ByVal thrid As Long)
' create thread excerpt minimum match
' fornam:   forum name to use
' thrid:    thread ID to use

    threxcmm = wtspace(THREXCMIN & fornam & " " & thrid2stg(thrid) & " ")
End Function

Private Function thrlstitem (ByVal idx As Integer, flags As Integer)
' generate thread list item string
' idx:      index in thrarr() of thread
' flags:    message attribute flags (returned to caller)

    flags = MLF_TGABLE
    If thrtagged(thrarr(idx).thrid, curonfor) Then
        flags = flags Or MLF_TAGGED
    End If
    thrlstitem = Trim$(thrarr(idx).topic) & tb & thrarr(idx).nmsgs & tb & flags & FLDSEP & idx
End Function

Function unaabtact () As Integer
' abort ongoing scan for unapproved attachments
' Note: this assumes cursource = SRCUNAPV

    unaabtact = True
    If unarqid >= 0 Then
        If gmsgbox("Your scan for unapproved attachments is still in progress.  Are you sure you wish to abort it?", MB_ICONQUESTION Or MB_YESNO, "") <> IDYES Then
            unaabtact = False
            Exit Function
        End If
        canunapv
    End If
    remread "", SRCUNAPV
End Function

Function unacanread (ByVal msgidstr As String, ByVal direc As Integer) As Integer
' Unapproved Attachments: can user read message in specified direction?
' msgidstr: identifier of current message (updated if successful)
' direc:    direction to read (-1=prev, 0=exact, 1=next)

    Dim i As Integer
    Dim msgid As Long

    unacanread = False
    If sameas(curonnam, itemidxd(msgidstr, 0, " ")) Then
        msgid = Val(itemidxd(msgidstr, 1, " "))
        i = getmidx(msgid, msgarr())
        Select Case direc
        Case READPREV
            unacanread = i > 0
        Case READTHIS
            unacanread = i >= 0
        Case READNEXT
            unacanread = (i < ninmarr(msgarr()) - 1) Or unarqid >= 0
        End Select
    End If
End Function

Sub unacbk (ByVal evtstg As String, ByVal reqid As Integer)
' scan load callback handler

    Dim i As Integer
    Dim tmps As String

    If reqid = unarqid Then
        Select Case evtstg
        Case "Dynapak received", "Dynapak available"
            If firstmsg Then
                firstmsg = False
                Erase msgarr
            End If
            i = ninmarr(msgarr())
            ReDim Preserve msgarr(i)
            junk = cbkrsp(Len(msgarr(i)), msgarr(i))
            stpnls msgarr(i).info
            add2mlst msgarr(i)
        Case Else
            unarqid = -1
            abterm = evtstg <> "No more dynapaks"
            freeup
            If Not firstmsg Then
                If abterm Then
                    tmps = "Scan for unapproved attachments terminated abnormally." & nl
                Else
                    tmps = "Scan for unapproved attachments complete." & nl
                End If
                tmps = tmps & ninmarr(msgarr()) & " message(s) found." & nl
                popmsg tmps, ""
            End If
        End Select
    End If
End Sub

Sub unapreprd (ByVal lstidx As Integer, capstr As String, btnflgs As Integer, capflgs As Integer, msgidstr As String)
' Unapproved Attachments:  prepare arguments to launch read form with
' lstidx:   index in message list of message to prepare
' capstr:   read form caption
' btnflgs:  button flags
' capflgs:  capability flags
' msgidstr: message ID string

    Dim cmpidx As Integer

    If ninmarr(msgarr()) Then
        capstr = "Unapproved Attachment in " & curonnam
        btnflgs = RDBNXTPRV Or RDBTHREAD
        capflgs = RDCDEL Or RDCFOROP Or RDCSILENT
        msgidstr = curonnam & " " & Format$(msgarr(lstidx).msgid, MNMFMT)
    End If
End Sub

Function unareadmsg (msgidstr As String, ByVal direc As Integer) As Integer
' Unapproved Attachments: read a message
' msgidstr: identifier of current message (updated if successful)
' direc:    direction to read (-1=prev, 0=exact, 1=next)
' returns:  True if message found
' implicit output: message is in msgindpk if returns True

    Dim i As Integer
    Dim msgid As Long
    Dim fornam As String, tmps As String

    unareadmsg = False
    fornam = itemidxd(msgidstr, 0, " ")
    msgid = Val(itemidxd(msgidstr, 1, " "))
    i = getmidx(msgid, msgarr())
    If i < 0 Then
        Exit Function
    End If
    Do
        Select Case direc
        Case READPREV
            i = i - 1
            If i < 0 Then
                popmsg "There are no previous messages with unapproved attachments.", ""
                Exit Function
            End If
        Case READNEXT
            i = i + 1
            If i >= ninmarr(msgarr()) Then
                If unarqid >= 0 Then    ' still searching
                    popmsg "Your scan for unapproved attachments is still in progress, but no next message has been found yet.", ""
                    Exit Function
                Else
                    popmsg "There are no more messages with unapproved attachments.", ""
                    adjrdbtn
                    Exit Function
                End If
            End If
        End Select
        If appconnect() Then
            If sreadpk(FORMSGDPK & fornam & " " & Format$(msgarr(i).msgid, MNMFMT), Len(msgindpk), msgindpk) Then
                msgidstr = Trim$(msgindpk.fornam) & " " & Format$(msgindpk.msgid, MNMFMT)
                stpnls msgindpk.info
                unareadmsg = True
                Exit Function
            ElseIf direc = READTHIS Then
                poperror "That message no longer exists on the server.", ""
                Exit Function
            End If
        Else
            Exit Function
        End If
    Loop
End Function

Sub unasynclst (ByVal msgidstr As String)
' Unapproved Attachments: synchronize list with given message
' msgidstr: ID string of message to synchronize with

    Dim i As Integer
    Dim msgid As Long, comp As Long

    If cursource = SRCUNAPV And sameas(curonnam, itemidxd(msgidstr, 0, " ")) Then
        msgid = Val(itemidxd(msgidstr, 1, " "))
        i = nearmidx(comp, msgid, msgarr())
        If i >= 0 And comp = 0 Then
            setmsgidx i
        End If
    End If
End Sub

Private Sub updcurthr ()
' update number of messages for current thread
' Note:  assumes online threads is current context

    Dim arridx As Integer, lstidx As Integer, tmpflgs As Integer

    arridx = gettidx(curonthr, thrarr())
    If arridx >= 0 Then
        thrarr(arridx).nmsgs = ninmarr(msgarr())
        lstidx = findinlist(Trim$(thrarr(arridx).topic), mainform!thrlist)
        If lstidx >= 0 Then
            mainform!thrlist.List(lstidx) = thrlstitem(arridx, tmpflgs)
        End If
    End If
End Sub

Private Sub updmlstpic ()
' update message list icons e.g. due to toggling thread tag

    Dim i As Integer
    Dim tmps As String

    mainform!msglist.ReFreshOnUpdate = False
    For i = 0 To ninmarr(msgarr()) - 1
        onupdmsgtg i
    Next
    mainform!msglist.ReFreshOnUpdate = True
End Sub

Private Sub add2mlst (msg As msgdpkshrt)
' add a message to the list of messages in a forum

    Dim flags As Integer

    flags = MLF_TGABLE
    If msgtagged(msg.msgid, msg.thrid, msg.forum) Then
        flags = flags Or MLF_TAGGED
    End If
    flags = mlflags(msg, flags)
    mainform!msglist.AddItem getminf(msg.info, FROMFLD) & tb & getminf(msg.info, TOFLD) & tb & getminf(msg.info, TPCFLD) & tb & Format$(msg.crdatim, DATEFMT) & tb & flags
    setmlpic mainform!msglist, mainform!msglist.LastAdded, flags
End Sub

