'****************************************************************************
'*                                                                          *
'*  OFLFOR.BAS                                                              *
'*                                                                          *
'*  Copyright (c) 1995-1997 Galacticomm, Inc.    All Rights Reserved.       *
'*                                                                          *
'*  This file contains declarations and functions for managing offline      *
'*  forum messages.                                                         *
'*                                                                          *
'*                                                  - J. Alvrus 11/29/95    *
'*                                                                          *
'****************************************************************************

Option Explicit

Global Const OFLFORCAP = "Offline Forums"
Const OFLFDPK = "sa=GALMSG;ul:offlineforumdatafile"
Const MSGPERCHUNK = 16
Const OFUINFSIZ = 512               ' per-file information size
Const OFUINFSPARE = OFUINFSIZ - 4 - 29 - 10 ' per-file info spare space
Const OFEXCSIZ = 107                ' offline forums excerpt size (TPCSIZ + 1 + HSTSIZ)

' old Forums In Box dynapaks
Const FINBXDPK = "(h=n)sa=GALFOR;ul:finbx " ' message dpk name
Const FINBXMIN = "finbx "           ' message dpk min match
Const FINBXFLST = "(h=n)sa=GALFOR;ul:finbxforlst " ' list of forums dpk name
Const FINBXFLMIN = "finbxforlst "   ' list of forums min match

Type ofuinfstruct                   ' offline forums user info structure
    sysid As String * VBSIDSIZ      '   system ID file is associated with
    usrid As String * VBUIDSIZ      '   User-ID file is associated with
    flags As Integer                '   file info flags
    lastfor As Integer              '   index of last forum user was reading
    lastmsg As Integer              '   index of last message user was reading
    lastthr As Long                 '   thread ID of last message user was reading
    spare As String * OFUINFSPARE   '   spare space
End Type                            ' (total size should be OFUINFSIZ)

Type ofuinfx                        ' convert structure to string type
    s As String * OFUINFSIZ
End Type

Type oflforum                       ' offline forum info structure
    name As String * FORNSZ         '   forum name
    forum As Integer                '   forum ID
    totmsgs As Integer              '   total number of messages
    nunread As Integer              '   number of unread messages
    startidx As Integer             '   index of first message in forum in message arrays
End Type

Type ofidxstruct                    ' offline forums message index structure
    fpos As Long                    '   file position of message
    forum As Integer                '   ID of forum message belongs to
    msgid As Long                   '   unique message identifier
    gmid As globid                  '   unique global message identifier
    thrid As Long                   '   ID of thread message is part of
    rplto As globid                 '   global ID of msg this is a reply to
End Type

Type formidpos                      ' recover index structure
    fornam As String * FORNSZ       '   forum name
    forum As Integer                '   forum ID
    msgid As Long                   '   message ID
    fpos As Long                    '   file position
End Type

Const FIBINFSZ = 16310              ' old forum in box message info string length

Type finbxmsg                       ' old forum in box message structure
     forum As Integer               '   ID of forum message belongs to
     axes As String * 1             '   per-message access info
     fornam As String * FORNSZ      '   name of forum msg in ("" if E-mail)
     msgid As Long                  '   unique message identifier
     gmid As globid                 '   unique global message identifier
     thrid As Long                  '   ID of thread message is part of
     attname As String * FLNSIZ     '   attached file name
     crdatim As Double              '   message creation date and time
     svdatim As Double              '   message save date and time
     rplto As globid                '   global ID of msg this is a reply to
     nrpl As Integer                '   number of times replied to
     flags As Integer               '   message/attachment flag bits
     info As String * FIBINFSZ      '   info field (see below)
End Type

Dim ofdbf As Integer                ' data file handle
Dim ofdbnam As String               ' data file name
Dim ofusrinf As ofuinfstruct        ' offline forums pre-user info
Dim oforinf() As oflforum           ' forum info array
Dim msgidx() As ofidxstruct         ' message index array
Dim thrarr() As thrinfarrstruct     ' array of threads in forum
Dim curoflfor As Integer            ' ID of offline forum currently in use
Dim prvoflfor As Integer            ' ID of forum before current forum
Dim nxtoflfor As Integer            ' ID of forum after current forum
Dim curofthr As Long                ' currently displayed thread ID
Dim curoftpc As String              ' topic of currently displayed thread
Dim listmsg As msgdpk               ' message buffer for foreground use

Dim getrqid As Integer              ' request ID of get
Dim ofinitted As Integer            ' has initof() been called at least once?
Dim scngetipg As Integer            ' getting messages from scan
Dim curforid As Integer             ' forum ID currently being gotten from
Dim newforid As Integer             ' forum ID from which new messages are currently being gotten
Dim chunkcount As Integer           ' number of message in current chunk gotten so far
Dim thrgetipg As Integer            ' getting messages from tagged thread
Dim getfornam As String             ' name of forum from which tagged messages are being gotten
Dim curthrid As Long                ' current tagged thread being gotten
Dim curmsgid As Long                ' current tagged message being gotten
Dim curtot As Integer               ' number of messages gotten in current forum
Dim totmsgs As Integer              ' number of messages gotten
Dim totnew As Integer               ' number of new (don't already have) messages gotten
Dim totunrd As Integer              ' number of unread messages gotten
Dim anydnlds As Integer             ' are any attachments being downloaded?
Dim wait2disc As Integer            ' are we waiting for attachments to download before disconnecting?
Dim anydel As Integer               ' have any messages been deleted? (so need to compress)
Dim lastforid As Integer            ' forum ID of last message user read
Dim lastthrid As Long               ' thread ID of last message user read
Dim lastmsgid As Long               ' message ID of last message user read
Dim getmsg As msgdpk                ' message buffer for background use
Dim newidx() As ofidxstruct         ' array of just-gotten messages

Private Function add2tmlst (msg As msgdpk, flags As Integer) As Integer
' add a message to the list of messages in a thread
' msg:      message dynapak structure
' flags:    list item flags
' returns index at which item was added

    Dim lstidx As Integer
    Dim hdr As msgdpkshrt

    LSet hdr = msg
    flags = mlflags(hdr, 0)
    mainform!msglist.AddItem Format$(msg.crdatim, DATEFMT) & tb & getminf(msg.info, FROMFLD) & tb & excerpt(getminf(msg.info, TEXTFLD), OFEXCSIZ) & tb & CStr(flags) & FLDSEP & CStr(msg.msgid)
    lstidx = mainform!msglist.LastAdded
    setmlpic mainform!msglist, lstidx, flags
    add2tmlst = lstidx
End Function

Private Sub addfor2arr (ByVal forum As Integer, ByVal fornam As String, ByVal startidx As Integer, ByVal fidx As Integer)
' add a new forum to in-memory array
' forum:    forum ID of new forum
' fornam:   name of new forum
' startidx: index in message arrays of first message in forum
' fidx:     index in forum array at which to add forum

    oforinf(fidx).forum = forum
    oforinf(fidx).name = fornam
    oforinf(fidx).totmsgs = 0
    oforinf(fidx).nunread = 0
    oforinf(fidx).startidx = startidx
End Sub

Private Sub addmsg2idx (msg As msgdpk, ByVal fpos As Long, idx() As ofidxstruct, ByVal ipos As Integer)
' add a message/file position to index array
' msg:  message dynapak structure
' fpos: file position of message
' ipos: index in index to add at

    idx(ipos).fpos = fpos
    idx(ipos).forum = msg.forum
    idx(ipos).msgid = msg.msgid
    idx(ipos).gmid = msg.gmid
    idx(ipos).thrid = msg.thrid
    idx(ipos).rplto = msg.rplto
End Sub

Private Function addmsg2lst (msg As msgdpk, flags As Integer) As Integer
' add a message to message list
' msg:      message dynapak to add to list
' flags:    list item flags
' returns index item added at

    Dim lstidx As Integer
    Dim smsg As msgdpkshrt

    LSet smsg = msg
    flags = mlflags(smsg, 0)
    mainform!msglist.AddItem getminf(smsg.info, FROMFLD) & tb & getminf(smsg.info, TOFLD) & tb & getminf(smsg.info, TPCFLD) & tb & Format$(smsg.crdatim, DATEFMT) & tb & flags
    lstidx = mainform!msglist.LastAdded
    setmlpic mainform!msglist, lstidx, flags
    addmsg2lst = lstidx
End Function

Private Sub cangetrq ()
' cancel get request

    Dim tmpid As Integer

    If getrqid >= 0 Then
        tmpid = getrqid
        getrqid = -1
        abodpk tmpid
    End If
End Sub

Private Function getofdbnam () As String
' get name of offline forum database file

    Dim tmpnam As String

    getofdbnam = ""
    tmpnam = sreadpkv(OFLFDPK)
    If Len(tmpnam) Then
        getofdbnam = sysappdir(MSGAPID) & "\OFDB\" & fnpart(tmpnam)
    End If
End Function

Private Sub gotnewfor (ByVal forum As Integer, ByVal fornam As String)
' got a new forum while getting
' forum:    forum ID of new forum
' fornam:   name of new forum

    Dim fidx As Integer, comp As Integer, i As Integer, stidx As Integer

    newforid = forum
    comp = 1
    fidx = nearfidx(comp, fornam, forum)
    If comp Then
        If comp > 0 Then
            fidx = fidx + 1
        End If
        ReDim Preserve oforinf(noflfors())
        For i = UBound(oforinf) To fidx + 1 Step -1
            oforinf(i) = oforinf(i - 1)
        Next
        If fidx Then
            stidx = oforinf(fidx - 1).startidx + oforinf(fidx - 1).totmsgs
        Else
            stidx = 0
        End If
        addfor2arr forum, fornam, stidx, fidx
    End If
    If isloaded(offlist) And comp <> 0 Then
        offlist!forlist.AddItem fornam & tb & tb & "1", fidx
        If offlist!forlist.ListIndex < 0 Then
            offlist!forlist.ListIndex = offlist!forlist.LastAdded
        End If
        offixbtns
    End If
    adjrdbtn
End Sub

Private Sub gotnewmsg (msg As msgdpk, ByVal fpos As Long)
' a message that has just been gotten
' msg:      message dynapak structure
' fpos:     file position message was saved at

    Dim tmptot As Integer, fidx As Integer
    Dim attspec As String

    ReDim Preserve newidx(curtot)
    addmsg2idx msg, fpos, newidx(), curtot
    curtot = curtot + 1
    If isloaded(offlist) Then
        fidx = fididx(newforid)
        tmptot = oforinf(fidx).totmsgs + curtot
        If tmptot Mod 10 = 0 Then
            offlist!forlist.List(fidx) = Trim$(oforinf(fidx).name) & tb & tb & tmptot
        End If
    End If
    If ((msg.flags And FILATT) <> 0) And ((prefs.sticky And SFDLATT) <> 0) Then
        anydnlds = True
        attspec = autdlnam(Trim$(prefs.fattdir), Trim$(msg.attname))
        dlatt Trim$(msg.fornam), msg.msgid, fnpart(attspec), pppart(attspec), False
    End If
End Sub

Function havemsg (ByVal forum As Integer, ByVal msgid As Long) As Integer
' do we have this message already?
' forum:    forum ID of message to look for
' msgid:    message ID of message to look for

    Dim idx As Integer, oldflg As Integer, newflg As Integer, comp As Integer

    oldflg = False
    idx = fididx(forum)
    If idx >= 0 Then
        oldflg = mididx(msgid, idx) >= 0
    End If
    idx = lnearmidx(comp, msgid, 0, curtot, newidx())
    newflg = comp = 0 And idx >= 0
    havemsg = oldflg Or newflg
End Function

Private Function initget () As Integer
' do common operations in preparation to get messages
' returns False if aborted

    initget = False
    compofdb
    If Not fexist(ofdbnam, False) Then
        ofdbnam = newofdbnam()
        If Not newofdb(ofdbnam, ofusrinf, ofdbf) Then
            Exit Function
        End If
        setofdbnam ofdbnam
    End If
    curforid = 0
    newforid = 0
    curtot = 0
    totmsgs = 0
    totnew = 0
    totunrd = 0
    anydnlds = False
    wait2disc = False
    Erase newidx
    curtot = 0
    initget = True
End Function

Function initof () As Integer
' initialize (load) offline forums
' returns False if unable to load

    Dim fidx As Integer, curfor As Integer, tmpflg As Integer
    Dim i As Long, idxsiz As Long
    Dim fornam As String
    Dim tmpidx() As Long

    If ofinitted Then
        initof = True
        Exit Function
    End If
    initof = False
    getrqid = -1
    anydel = False
    chkreload
    ofdbnam = getofdbnam()
    If Len(ofdbnam) = 0 Then
        initof = True
        Exit Function
    End If
    If Not fexist(ofdbnam, False) Then
        setofdbnam ""
        initof = True
        Exit Function
    End If
    ofdbf = -1
    If mdbopen(ofdbnam, ofdbf) <> 0 Or Not loadusrinf() Then
        If ofdbf >= 0 Then mdbclose ofdbf
        If gmsgbox("Your Offline Forums data file has become unrecoverably damaged. Would you like to clear your Offline Forums now?", MB_ICONEXCLAMATION Or MB_YESNO, OFLFORCAP) = IDYES Then
            clearof
        End If
        Exit Function
    End If
    totmsgs = 0
    idxsiz = mdbidxsiz(ofdbf)
    i = mdbnmsgs(ofdbf)
    If idxsiz = 0 Or idxsiz > i Then
        initof = recover()
        Exit Function
    End If
    anydel = (idxsiz < i)
    ReDim msgidx(idxsiz - 1)
    ReDim tmpidx(idxsiz - 1)
    If mdbreadidx(ofdbf, tmpidx(), idxsiz) <> idxsiz Then
        initof = recover()
        Exit Function
    End If
    progopen PRGT_BAR, "Loading Offline Forums", "", "", ""
    curfor = 0
    totunrd = 0
    For i = 0 To idxsiz - 1
        If Not mdbread(ofdbf, tmpidx(i), getmsg) Then
            progclose
            initof = recover()
            Exit Function
        End If
        DoEvents
        If progcancel() Then
            progclose
            Erase oforinf
            Erase msgidx
            Exit Function
        End If
        progupdate CStr(100& * i \ idxsiz)
        If getmsg.forum <> curfor Then
            fornam = getForumName(getmsg.forum, Trim$(getmsg.fornam))
            tmpflg = False
            If noflfors() Then
                ' duplicate names are allowed, just not out-of-order names
                tmpflg = stricmp(fornam, Trim$(oforinf(UBound(oforinf)).name)) < 0
            End If
            ' recover if forum names are out of order, or messages from the same forum are not all together
            If tmpflg Or fididx(getmsg.forum) >= 0 Then
                progclose
                initof = recover()
                Exit Function
            End If
            curfor = getmsg.forum
            fidx = noflfors()
            ReDim Preserve oforinf(fidx)
            addfor2arr getmsg.forum, fornam, i, fidx
        End If
        addmsg2idx getmsg, tmpidx(i), msgidx(), i
        updftots fidx, getmsg.forum, getmsg.msgid
    Next
    progclose
    lastforid = oforinf(ofusrinf.lastfor).forum
    lastmsgid = msgidx(lst2idx(ofusrinf.lastfor, ofusrinf.lastmsg)).msgid
    lastthrid = ofusrinf.lastthr
    Erase tmpidx
    ofinitted = True
    initof = True
End Function

Private Function jumpmsg (ByVal jumpto As Integer, ByVal fidx As Integer, msglstidx As Integer) As Integer
' get index in message list of message to jump to
' jumpto:       where to jump to code
' fidx:         index of forum in forum info array
' msglstidx:    index in message list of message to jump to
' returns False if user cancels

    Dim comp As Integer
    Dim tmpid As Long

    jumpmsg = False
    Select Case jumpto
    Case JUMPFRST
        msglstidx = 0
        jumpmsg = True
    Case JUMPSPEC
        tmpid = getjmpmid()
        If tmpid >= 0 Then
            If tmpid <= msgidx(oforinf(fidx).startidx).msgid Then
                msglstidx = 0
            ElseIf tmpid >= msgidx(oforinf(fidx).startidx + oforinf(fidx).totmsgs - 1).msgid Then
                msglstidx = oforinf(fidx).totmsgs - 1
            Else
                msglstidx = nearmidx(comp, tmpid, fidx)
                If comp < 0 And msglstidx > 0 Then
                    msglstidx = msglstidx - 1
                End If
            End If
            jumpmsg = True
        End If
    Case JUMPLAST
        msglstidx = oforinf(fidx).totmsgs - 1
        jumpmsg = True
    End Select
End Function

Private Sub killoflfor ()
' unload offline forums due to abnormal shutdown

    ofinitted = False
    Erase msgidx
    Erase oforinf
    If isloaded(offlist) Then
        Unload offlist
    End If
    If cursource = SRCOFLMSG Or cursource = SRCOFLTHR Then
        nosource
    End If
    remread "", SRCOFLMSG
    remread "", SRCOFLTHR
End Sub

Function listof (lst As Control) As Integer
' show list of offline forums
' lst:  list control to put forums in
' returns False if unable to load

    listof = False
    If noflfors() = 0 Then
        If Not initof() Then
            Exit Function
        End If
    End If
    loadlist lst
    listof = True
End Function

Sub listoflfor (ByVal getflg As Integer)
' list an offline forum
' getflg:   initiate message get?

    Dim i As Integer

    If Not abtonact() Then
        Exit Sub
    End If
    If Not seloflfor(getflg) Then
        If cursource = SRCOFLMSG Or cursource = SRCOFLTHR Then
            i = fididx(curoflfor)
            If i < 0 Or (ofgetidx() >= 0 And i >= ofgetidx()) Or noflfors() = 0 Then
                remread "", SRCOFLMSG
                remread "", SRCOFLTHR
                nosource
            End If
        End If
        Exit Sub
    End If
    If ofgetidx() >= 0 Then
        adjrdbtn
    End If
    If prefs.sticky And SOFLMSG Then
        If curoflfor = lastforid Then
            listofmsgs lastmsgid
        Else
            listofmsgs 0
        End If
    Else
        If curoflfor = lastforid Then
            listofthrs True, lastthrid, lastmsgid
        Else
            listofthrs False, 0, 0
        End If
    End If
End Sub

Private Sub listofmsgs (ByVal himsgid As Long)
' list messages in current offline forum
' himsgid:  message ID to highlight or 0 for default

    cursource = SRCOFLMSG
    stdmlsetup
    setupmain
    stdmlcap "Offline Forum:", Trim$(oforinf(fididx(curoflfor)).name)
    showmsgs himsgid
    stdmlfin
End Sub

Private Sub listofthrs (ByVal highlight As Integer, ByVal hithrid As Long, ByVal himsgid As Long)
' list threads in offline forum
' highlight:    highlight a specific thread/message?
' hithrid:      thread ID of thread to highlight
' himsghd:      message ID of message to highlight

    Dim i As Integer

    cursource = SRCOFLTHR
    stdtlsetup False
    makthrlst
    setupmain
    mainform!mttag.Visible = False
    stdtlcap "Offline Forum:", Trim$(oforinf(fididx(curoflfor)).name)
    i = showthrs(highlight, hithrid)
    If highlight And i >= 0 Then
        oftlstmsg i, himsgid
    End If
    stdtlfin
End Sub

Private Function lnearmidx (comp As Integer, ByVal msgid As Long, ByVal startidx As Integer, ByVal nmsgs As Integer, msgarr() As ofidxstruct) As Integer
' low-level find index of nearest message in forum in message cross reference array
' comp:     result of last name comparison (<0 if msgid < array, >0 if msgid > array, =0 if msgid = array)
' msgid:    message ID to search for
' startidx: index in array of first message in forum
' nmsgs:    number of messages in forum
' msgarr:   message cross reference array to search
' returns index of nearest cross reference or -1 if there are no cross references

    Dim lo As Integer, md As Integer, hi As Integer

    md = -1
    If nmsgs Then
        lo = startidx
        hi = lo + nmsgs - 1
        Do While lo <= hi
            md = lo + (hi - lo) \ 2
            comp = Sgn(msgid - msgarr(md).msgid)
            If comp > 0 Then
                lo = md + 1
            ElseIf comp < 0 Then
                hi = md - 1
            Else
                Exit Do
            End If
        Loop
        md = md - startidx
    End If
    lnearmidx = md
End Function

Private Sub loadlist (lst As Control)
' load a list with offline forum info

    Dim i As Integer

    lst.Clear
    If noflfors() Then
        lst.ReFreshOnUpdate = False
        For i = 0 To noflfors() - 1
            If i = ofgetidx() Then
                lst.AddItem Trim$(oforinf(i).name) & tb & tb & oforinf(i).totmsgs + curtot
            Else
                lst.AddItem oflistitem(i)
            End If
        Next
        If getrqid < 0 Then
            showoftot lst
        End If
        lst.ReFreshOnUpdate = True
    End If
End Sub

Private Function loadusrinf () As Integer
' read offline forum user-defined info
' return False if info invalid

    Dim tmps As String

    tmps = mdbreadusr(ofdbf)
    stg2typ tmps, ofusrinf, Len(ofusrinf)
    loadusrinf = sameas(curuid(), Trim$(ofusrinf.usrid))
End Function

Function lst2idx (ByVal forlstidx As Integer, ByVal msglstidx As Integer) As Integer
' get the index in msgidx() given forum list and message list indices

    lst2idx = oforinf(forlstidx).startidx + msglstidx
End Function

Private Sub makthrlst ()
' create list of threads in currently selected offline forum

    Dim i As Integer, j As Integer, comp As Integer, fidx As Integer, tidx As Integer

    fidx = fididx(curoflfor)
    Erase thrarr
    If fidx < 0 Then
        Exit Sub
    End If
    For i = oforinf(fidx).startidx To oforinf(fidx).startidx + oforinf(fidx).totmsgs - 1
        comp = 1
        tidx = neartidx(comp, msgidx(i).thrid, thrarr())
        If comp Then
            If comp > 0 Then
                tidx = tidx + 1
            End If
            If Not mdbread(ofdbf, msgidx(i).fpos, listmsg) Then
                Exit For
            End If
            ReDim Preserve thrarr(nintarr(thrarr()))
            For j = UBound(thrarr) To tidx + 1 Step -1
                thrarr(j) = thrarr(j - 1)
            Next
            thrarr(tidx).thrid = listmsg.thrid
            thrarr(tidx).nmsgs = 1
            thrarr(tidx).topic = getminf(listmsg.info, TPCFLD)
        Else
            thrarr(tidx).nmsgs = thrarr(tidx).nmsgs + 1
        End If
    Next
End Sub

Private Function mididx (ByVal msgid As Long, ByVal foridx As Integer) As Integer
' get index of given message ID within a given forum
' msgid:    message ID to find
' foridx:   index in forum info array of forum to search
' returns index of message if found or -1 if not found

    Dim midx As Integer, comp As Integer

    mididx = -1
    midx = nearmidx(comp, msgid, foridx)
    If midx >= 0 And comp = 0 Then
        mididx = midx
    End If
End Function

Private Function msgarrsiz () As Long
' get number of messages in msgidx() array

    On Error Resume Next
    msgarrsiz = UBound(msgidx) + 1
    If Err Then
        msgarrsiz = 0
    End If
End Function

Private Function nearfidx (comp As Integer, ByVal fornam As String, ByVal forum As Integer) As Integer
' find index of nearest forum in forum info array
' comp:     result of last name comparison (<0 if fornam < array, >0 if fornam > array, =0 if fornam = array)
' fornam:   forum name to search for
' forum:    forum ID to search for
' returns index of nearest cross reference or -1 if there are no cross references

    Dim lo As Integer, md As Integer, hi As Integer

    md = -1
    If noflfors() Then
        lo = 0
        hi = UBound(oforinf)
        Do While lo <= hi
            md = lo + Int((hi - lo) / 2)
            comp = stricmp(fornam, Trim$(oforinf(md).name))
            If comp = 0 And forum <> EMLID Then comp = Sgn(forum - oforinf(md).forum)
            If comp > 0 Then
                lo = md + 1
            ElseIf comp < 0 Then
                hi = md - 1
            Else
                Exit Do
            End If
        Loop
    End If
    nearfidx = md
End Function

Private Function nearmidx (comp As Integer, ByVal msgid As Long, ByVal foridx As Integer) As Integer
' find index of nearest message in forum in msgidx array
' comp:     result of last name comparison (<0 if msgid < array, >0 if msgid > array, =0 if msgid = array)
' msgid:    message ID to search for
' foridx:   index in forum info array of forum to search
' returns index of nearest cross reference or -1 if there are no cross references

    nearmidx = lnearmidx(comp, msgid, oforinf(foridx).startidx, oforinf(foridx).totmsgs, msgidx())
End Function

Private Sub newcurf (ByVal forum As Integer)
' change current get forum

    Dim i As Integer

    If newforid Then
        fincurfor
    End If
    If isloaded(offlist) Then
        If curforid = 0 Or curforid <> newforid Then
            i = ofgetidx()
            If i >= 0 And i < noflfors() Then
                offlist!forlist.List(i) = oflistitem(i)
            End If
        End If
        i = fididx(forum)
        If i >= 0 Then
            offlist!forlist.List(i) = Trim$(oforinf(i).name) & tb & tb & oforinf(i).totmsgs
        End If
    End If
    curforid = forum
    newforid = 0
    curtot = 0
    Erase newidx
End Sub

Private Function newofdb (ByVal filnam As String, usrinf As ofuinfstruct, f As Integer) As Integer
' create a new offline forums database file
' filnam:   path and name of file to create
' usrinf:   user info buffer to initialize
' f:        file handle buffer to initialize
' returns False if unable to create file

    Dim tmpx As ofuinfx
    Dim tmpsau As sauinf

    newofdb = False
    systat tmpsau
    usrinf.sysid = tmpsau.sysid
    usrinf.usrid = tmpsau.usrid
    usrinf.flags = 0
    usrinf.lastfor = 0
    usrinf.lastmsg = 0
    usrinf.spare = String$(Len(usrinf.spare), 0)
    LSet tmpx = usrinf
    If mdbnew(filnam, f, tmpx.s) <> 0 Then
        poperror "Unable to create data file: " & filnam, ""
        Exit Function
    End If
    newofdb = True
End Function

Private Function newofdbnam () As String
' create a new offline forum database file path and name

    Dim tmpnam As String

    tmpnam = sysappdir(MSGAPID) & "\OFDB"
    On Error Resume Next
    MkDir tmpnam
    newofdbnam = uniquefn(tmpnam, MDBFEXT)
End Function

Private Sub nextag (cbk As CallBack)
' kick off read for next tagged thread/message

    Dim tmpfid As Integer
    Dim idstr As String

    If thr2get(curforid, curthrid) Then
        thrgetipg = True
        idstr = getfornam & " " & thrid2stg(curthrid) & " "
        getrqid = rgtdpk(wtspace("(c=n)" & THRMSGDPK & idstr), wtspace(THRMSGMIN & idstr), -1, cbk)
    ElseIf msg2get(curforid, curmsgid) Then
        thrgetipg = False
        idstr = getfornam & " " & Format$(curmsgid, MNMFMT)
        getrqid = readpk("(c=n)" & FORMSGDPK & idstr, cbk)
    Else
        untagfor getfornam
        If for2get(tmpfid, getfornam) Then
            newcurf tmpfid
            nextag cbk
        Else
            freeup
            If totmsgs = 0 Then
                popmsg "None of the messages you tagged could be gotten.", OFLFORCAP
            End If
            finget False
        End If
    End If
End Sub

Function noflfors () As Integer
' get number of offline forums currently loaded

    On Error Resume Next
    noflfors = UBound(oforinf) + 1
    If Err Then
        noflfors = 0
    End If
End Function

Sub ofabtget ()
' abort ongoing offline forum get

    If getrqid >= 0 Then
        cangetrq
        If scngetipg Then
            scncls
        End If
        finget True
    End If
End Sub

Function ofcandel (msg As msgdpk) As Integer
' Offline Forums:  can user delete this message
' msg:  dynapak form of message

    Dim fidx As Integer, tmpflg As Integer
    Dim smsg As msgdpkshrt

    tmpflg = False
    fidx = fididx(msg.forum)
    If fidx >= 0 Then
        tmpflg = mididx(msg.msgid, fidx) >= 0
    End If
    If Not tmpflg Then
        LSet smsg = msg
        tmpflg = forcandel(smsg)
    End If
    ofcandel = tmpflg
End Function

Function ofcanread (ByVal msgidstr As String, ByVal direc As Integer) As Integer
' Offline Forums:  can user read message in specified direction?
' msgidstr: identifier of current message
' direc:    direction to read (-1=prev, 0=exact, 1=next)

    Dim fidx As Integer, midx As Integer, comp As Integer, getidx As Integer

    ofcanread = False
    If Left$(msgidstr, 1) <> "*" Then
        fidx = fididx(Val(itemidxd(msgidstr, 0, " ")))
        If fidx >= 0 Then
            comp = 1
            midx = nearmidx(comp, Val(itemidxd(msgidstr, 1, " ")), fidx)
            If comp > 0 Then
                midx = midx + 1
            End If
            Select Case direc
            Case READPREV
                ofcanread = lst2idx(fidx, midx) > 0
            Case READTHIS
                ofcanread = comp = 0
            Case READNEXT
                getidx = ofgetidx()
                If getidx < 0 Then
                    If comp Then
                        ofcanread = lst2idx(fidx, midx) < msgarrsiz()
                    Else
                        ofcanread = lst2idx(fidx, midx) < msgarrsiz() - 1
                    End If
                Else
                    If fidx = getidx - 1 Then
                        If comp Then
                            ofcanread = midx < oforinf(fidx).totmsgs
                        Else
                            ofcanread = midx + 1 < oforinf(fidx).totmsgs
                        End If
                    Else
                        ofcanread = True
                    End If
                End If
            End Select
        End If
    End If
End Function

Function ofcanswthr (ByVal msgidstr As String, ByVal fornam As String, ByVal thrid As Long, ByVal direc As Integer) As Integer
' can user switch threads?
' msgidstr: message ID string
' fornam:   name of forum being read from
' thrid:    current thread ID
' direc:    direction to switch (previous/next)
' returns True if thread available

    Dim i As Integer

    ofcanswthr = False
    If cursource = SRCOFLTHR And Val(itemidxd(msgidstr, 0, " ")) = curoflfor Then
        i = gettlstidx(thrid, thrarr())
        If i >= 0 Then
            Select Case direc
            Case READNEXT
                ofcanswthr = (i < nintarr(thrarr()) - 1)
            Case READPREV
                ofcanswthr = i > 0
            End Select
        End If
    End If
End Function

Sub ofcbkhlr (ByVal evtstg As String, ByVal reqid As Integer, cbk As CallBack)
' offline forum message get callback handler
' evtstg:   event string of callback
' reqid:    request ID in effect
' cbk:      callback control in use

    Dim i As Integer
    Dim fpos As Long
    Dim tmps As String

    If reqid = getrqid Then
        If scngetipg Then
            Select Case evtstg
            Case "Dynapak received"
                junk = cbkrsp(Len(getmsg), getmsg)
                tmps = namdpk()
                If getmsg.forum <> curforid Then
                    newcurf getmsg.forum
                End If
                If Not havemsg(getmsg.forum, getmsg.msgid) Then
                    If msgarrsiz() + curtot >= MAXINT Then
                        tmps = "The maximum number of messages that can be supported in Offline Forums has been reached."
                        cangetrq
                        freeup
                        popmsg tmps, OFLFORCAP
                        finget True
                        Exit Sub
                    End If
                    i = fididx(getmsg.forum)
                    If i >= 0 Then
                        If oforinf(i).totmsgs + curtot >= MAXLIST Then
                            chunkcount = 0
                            tmps = "There are too many messages in the " & Trim$(getmsg.fornam) & " forum. Only " & curtot & " could be gotten."
                            cangetrq
                            getrqid = rgtdpk("(c=n)" & SCNMSGDPK & Trim$(getmsg.fornam) & " " & Format$(MAXLONG, MNMFMT), wtspace(SCNMSGMIN), MSGPERCHUNK, cbk)
                            freeup
                            popmsg tmps, OFLFORCAP
                            Exit Sub
                        End If
                    End If
                    If getmsg.forum <> newforid Then
                        gotnewfor getmsg.forum, Trim$(getmsg.fornam)
                    End If
                    stpnls getmsg.info
                    fpos = mdbaddmsg(ofdbf, getmsg)
                    If fpos = 0& Then
                        On Error Resume Next
                        junk = UBound(newidx)
                        i = Err
                        On Error GoTo 0
                        If i = 0 Then
                            fincurfor
                        End If
                        mdbclose ofdbf
                        cangetrq
                        freeup
                        If mdberror() = 61 Then     'out of disk space
                            poperror "Out of disk space.", OFLFORCAP
                        Else
                            poperror "An unrecoverable error has occurred while writing to data file", OFLFORCAP
                        End If
                        killoflfor
                        Exit Sub
                    End If
                    gotnewmsg getmsg, fpos
                    totnew = totnew + 1
                End If
                totmsgs = totmsgs + 1
                chunkcount = chunkcount + 1
                If chunkcount = MSGPERCHUNK Then
                    chunkcount = 0
                    getrqid = rgtdpk("(c=n)" & tmps, wtspace(SCNMSGMIN), MSGPERCHUNK, cbk)
                End If
            Case Else
                getrqid = -1
                scncls
                freeup
                If totmsgs = 0 Then
                    popmsg "No messages were gotten by your scan.", OFLFORCAP
                End If
                finget (evtstg <> "No more dynapaks")
            End Select
        Else
            Select Case evtstg
            Case "Dynapak received"
                junk = cbkrsp(Len(getmsg), getmsg)
                If Not havemsg(getmsg.forum, getmsg.msgid) Then
                    If msgarrsiz() + curtot >= MAXINT Then
                        tmps = "The maximum number of messages that can be supported in Offline Forums has been reached."
                        If thrgetipg Then
                            cangetrq
                        End If
                        getrqid = -1
                        freeup
                        popmsg tmps, OFLFORCAP
                        finget True
                        Exit Sub
                    End If
                    i = fididx(getmsg.forum)
                    If i >= 0 Then
                        If oforinf(i).totmsgs + curtot >= MAXLIST Then
                            tmps = "There are too many messages in the " & Trim$(getmsg.fornam) & " forum. Only " & curtot & " could be gotten."
                            If thrgetipg Then
                                cangetrq
                            End If
                            getrqid = -1
                            untagrest
                            nextag cbk
                            freeup
                            popmsg tmps, OFLFORCAP
                            Exit Sub
                        End If
                    End If
                    If getmsg.forum <> newforid Then
                        gotnewfor getmsg.forum, Trim$(getmsg.fornam)
                    End If
                    If msgtagged(getmsg.msgid, getmsg.thrid, getmsg.forum) Then
                        stpnls getmsg.info
                        fpos = mdbaddmsg(ofdbf, getmsg)
                        If fpos = 0& Then
                            On Error Resume Next
                            junk = UBound(newidx)
                            i = Err
                            On Error GoTo 0
                            If i = 0 Then
                                fincurfor
                            End If
                            mdbclose ofdbf
                            If thrgetipg Then
                                cangetrq
                            End If
                            freeup
                            If mdberror() = 61 Then     'out of disk space
                                poperror "Out of disk space.", OFLFORCAP
                            Else
                                poperror "An unrecoverable error has occurred while writing to data file", OFLFORCAP
                            End If
                            killoflfor
                            Exit Sub
                        End If
                        gotnewmsg getmsg, fpos
                        totnew = totnew + 1
                    End If
                End If
                totmsgs = totmsgs + 1
                If Not thrgetipg Then
                    getrqid = -1
                    gotmsg getmsg.msgid, getmsg.forum
                    gotmsgtg Trim$(getmsg.fornam), getmsg.msgid
                    nextag cbk
                End If
            Case Else
                getrqid = -1
                If thrgetipg Then
                    untagthr curthrid, getfornam
                    gotthrtg getfornam, curthrid
                Else
                    gotmsg curmsgid, curforid
                    gotmsgtg getfornam, curmsgid
                End If
                If connected() Then
                    nextag cbk
                Else
                    finget True
                End If
            End Select
        End If
    End If
End Sub

Sub ofchkold ()
' check for any old-style Forums In Box messages

    If Len(srgtdpkv(wtspace(FINBXDPK), wtspace(FINBXMIN))) Then
        If gmsgbox("You still have messages in your old Forums In Box. Would you like to convert them to the new Offline Forums now?", MB_ICONQUESTION Or MB_YESNO, OFLFORCAP) = IDYES Then
            ofcvtold
        End If
    End If
End Sub

Private Sub ofcvtold ()
' convert old-style Forums In Box messages to new style
' Note:  This function assumes the Offline Forums list form is not loaded

    Dim i As Integer, flg As Integer, aborted As Integer, stickysave As Integer
    Dim fpos As Long
    Dim tmps As String, dpknam As String
    Dim buf() As finbxmsg

    If Not initof() Then
        Exit Sub
    End If
    If Not initget() Then
        Exit Sub
    End If
    progopen PRGT_INF, "Converting Forums In Box", "Converting old Forums In Box contents to new Offline Forums. This may take some time.", "Forum/Message #:", String$(FORNSZ, "M") & "/" & MNMFMT
    stickysave = prefs.sticky
    prefs.sticky = prefs.sticky And Not SFDLATT
    aborted = False
    ReDim buf(0)
    dpknam = wtspace(FINBXDPK)
    Do While srgtdpk(dpknam, wtspace(FINBXMIN), Len(buf(0)), buf(0))
        flg = True
        dpknam = namdpk()
        DoEvents
        progupdate dblamp(Trim$(buf(0).fornam)) & " #" & buf(0).msgid
        DoEvents
        junk = swrtdpkv("(h=n)" & dpknam, 0, 0)
        DoEvents
        If buf(0).forum <> curforid Then
            newcurf buf(0).forum
        End If
        DoEvents
        If Not havemsg(buf(0).forum, buf(0).msgid) Then
            If msgarrsiz() + curtot >= MAXINT Then
                popmsg "The maximum number of messages that can be supported in Offline Forums has been reached.", OFLFORCAP
                aborted = True
                Exit Do
            End If
            i = fididx(buf(0).forum)
            If i >= 0 Then
                If oforinf(i).totmsgs + curtot >= MAXLIST Then
                    chunkcount = 0
                    popmsg "There are too many messages in the " & Trim$(buf(0).fornam) & " forum. Only " & curtot & " could be converted.", OFLFORCAP
                    dpknam = FINBXDPK & Trim$(buf(0).fornam) & " " & Format$(MAXLONG, MNMFMT)
                    flg = False
                End If
            End If
            If flg Then
                If buf(0).forum <> newforid Then
                    gotnewfor buf(0).forum, Trim$(buf(0).fornam)
                End If
                stpnls buf(0).info
                listmsg.forum = buf(0).forum
                listmsg.axes = buf(0).axes
                listmsg.fornam = buf(0).fornam
                listmsg.msgid = buf(0).msgid
                listmsg.gmid = buf(0).gmid
                listmsg.thrid = buf(0).thrid
                listmsg.attname = buf(0).attname
                listmsg.crdatim = buf(0).crdatim
                listmsg.rplto = buf(0).rplto
                listmsg.nrpl = buf(0).nrpl
                listmsg.flags = buf(0).flags
                listmsg.info = buf(0).info
                fpos = mdbaddmsg(ofdbf, listmsg)
                If fpos = 0& Then
                    prefs.sticky = stickysave
                    On Error Resume Next
                    junk = UBound(newidx)
                    i = Err
                    On Error GoTo 0
                    If i = 0 Then
                        fincurfor
                    End If
                    mdbclose ofdbf
                    If mdberror() = 61 Then     'out of disk space
                        poperror "Out of disk space.", OFLFORCAP
                    Else
                        poperror "An unrecoverable error has occurred while writing to data file", OFLFORCAP
                    End If
                    killoflfor
                    progclose
                    Exit Sub
                End If
                gotnewmsg listmsg, fpos
                totnew = totnew + 1
            End If
        End If
        If flg Then
            totmsgs = totmsgs + 1
        End If
        DoEvents
        If progcancel() Then
            Exit Do
        End If
        DoEvents
    Loop
    progclose
    screen.MousePointer = HOURGLASS
    prefs.sticky = stickysave
    If newforid Then
        fincurfor
    End If
    closeofdb
    dpknam = wtspace(FINBXFLST)
    Do While Len(srgtdpkv(dpknam, wtspace(FINBXFLMIN)))
        dpknam = namdpk()
        junk = swrtdpkv(dpknam, 0, 0)
    Loop
    screen.MousePointer = DEFAULT
    If mdbopen(ofdbnam, ofdbf) <> 0 Then
        poperror "An unrecoverable error has occurred while writing to data file", OFLFORCAP
        killoflfor
        Exit Sub
    ElseIf totmsgs Then
        If aborted Then
            tmps = "Forums In Box conversion aborted." & nl
        Else
            tmps = "Forums In Box conversion complete." & nl
        End If
        tmps = tmps & totmsgs & " message(s) converted"
        If totmsgs = totnew Then
            tmps = tmps & "."
        Else
            tmps = tmps & "," & nl & totmsgs - totnew & " duplicate(s)."
        End If
        popmsg tmps, OFLFORCAP
    End If
    adjrdbtn
End Sub

Sub ofdelall ()
' delete all messages from Offline forums

    clearof
    If cursource = SRCOFLMSG Or cursource = SRCOFLTHR Then
        nosource
    End If
End Sub

Function ofdelmsg (ByVal msgidstr As String, ByVal source As Integer) As Integer
' Offline Forums:  delete a message
' msgidstr: ID string of message to delete
' source:   source ID of message
' returns True if deleted

    ofdelmsg = ofdelmsgl(msgidstr, source)
End Function

Function ofdelmsgl (ByVal msgidstr As String, ByVal source As Integer) As Integer
' Offline Forums:  delete local copy of a message
' msgidstr: ID string of message to delete
' source:   source ID of message
' returns True if deleted

    Dim fidx As Integer, midx As Integer

    ofdelmsgl = False
    fidx = fididx(Val(itemidxd(msgidstr, 0, " ")))
    If fidx >= 0 Then
        midx = mididx(Val(itemidxd(msgidstr, 1, " ")), fidx)
        If midx >= 0 Then
            ofdelmsgl = delofmsg(fidx, midx, source)
        End If
    End If
End Function

Sub ofdelread ()
' delete all read messages from Offline forums

    Dim i As Integer, source As Integer, n As Integer, orgtot As Integer, totmsgs As Integer, fidx As Integer

    progopen PRGT_BAR, "Deleting Read Messages", "Marking all read messages deleted.", "", ""
    source = SRCNONE
    If cursource = SRCOFLMSG Or cursource = SRCOFLTHR Then
        source = cursource
    End If
    winrefresh mainform!msglist.Hwnd, False
    winrefresh mainform!thrlist.Hwnd, False
    totmsgs = msgarrsiz()
    orgtot = totmsgs
    i = 0
    n = 0
    While i < totmsgs
        If msgmarked(msgidx(i).forum, msgidx(i).msgid) Then
            fidx = fididx(msgidx(i).forum)
            If Not delofmsg(fidx, i - oforinf(fidx).startidx, source) Then
                progclose
                winrefresh mainform!msglist.Hwnd, True
                winrefresh mainform!thrlist.Hwnd, True
                poperror "An unexpected error has occurred while marking messages deleted.", OFLFORCAP
                Exit Sub
            End If
            totmsgs = totmsgs - 1
        Else
            i = i + 1
        End If
        n = n + 1
        progupdate CStr(100& * n \ orgtot)
        DoEvents
        If progcancel() Then
            progclose
            winrefresh mainform!msglist.Hwnd, True
            winrefresh mainform!thrlist.Hwnd, True
            Exit Sub
        End If
    Wend
    progclose
    winrefresh mainform!msglist.Hwnd, True
    winrefresh mainform!thrlist.Hwnd, True
    compofdb
End Sub

Sub ofdlcomp ()
' notify offline forums of "Downloads complete" event string

    anydnlds = False
    If wait2disc Then
        wait2disc = False
        disconnect
    End If
End Sub

Function ofenumstr (ByVal msgidstr As String) As String
' Offline Forums: get enumeration string (e.g. "#1 of 2") given message ID string and source ID
' msgidstr: identifier of current message

    Dim fidx As Integer, midx As Integer

    ofenumstr = ""
    If Left$(msgidstr, 1) <> "*" Then
        fidx = fididx(Val(itemidxd(msgidstr, 0, " ")))
        If fidx >= 0 Then
            midx = mididx(Val(itemidxd(msgidstr, 1, " ")), fidx)
            If midx >= 0 Then
                ofenumstr = "#" & (midx + 1) & " of " & oforinf(fidx).totmsgs
            End If
        End If
    End If
End Function

Sub offixbtns ()
' set enabling on buttons
' Note: this assumes offlist is loaded

    Dim i As Integer, tmpflg As Integer

    tmpflg = offlist!forlist.ListIndex >= 0
    If tmpflg Then
        tmpflg = offlist!forlist.ListIndex < noflfors()
        If getrqid >= 0 And tmpflg Then
            tmpflg = offlist!forlist.ListIndex < ofgetidx()
        End If
    End If
    offlist!okbtn.Enabled = tmpflg
    If getrqid < 0 Then
        offlist!getbtn.Caption = "&Get..."
    Else
        offlist!getbtn.Caption = "&Abort Get"
    End If
    tmpflg = noflfors() <> 0 And getrqid < 0
    offlist!clrallbtn.Enabled = tmpflg
    offlist!clrrdbtn.Enabled = tmpflg
End Sub

Function ofgetidx () As Integer
' get index of forum currently being gotten
' returns -1 if none

    ofgetidx = -1
    If getrqid >= 0 Then
        If curforid Then
            ofgetidx = fididx(curforid)
        Else
            ofgetidx = 0
        End If
    End If
End Function

Sub ofgetscn (cbk As CallBack)
' kick off getting messages from a scan
' Note: scan must already have been initialized on server

    Dim tmpidx As Integer

    If initget() Then
        scngetipg = True
        chunkcount = 0
        getrqid = rgtdpk(wtspace("(c=n)" & SCNMSGDPK), wtspace(SCNMSGMIN), MSGPERCHUNK, cbk)
        If isloaded(offlist) Then
            tmpidx = offlist!forlist.ListIndex
            loadlist offlist!forlist
            If tmpidx < 0 And offlist!forlist.ListCount > 0 Then
                offlist!forlist.ListIndex = 0
            Else
                offlist!forlist.ListIndex = tmpidx
            End If
        End If
    End If
End Sub

Sub ofgettag (cbk As CallBack)
' kick off getting tagged messages

    Dim tmpfid As Integer, tmpidx As Integer

    If initget() Then
        scngetipg = False
        If for2get(tmpfid, getfornam) Then
            newcurf tmpfid
            nextag cbk
            If isloaded(offlist) Then
                tmpidx = offlist!forlist.ListIndex
                loadlist offlist!forlist
                If tmpidx < 0 And offlist!forlist.ListCount > 0 Then
                    offlist!forlist.ListIndex = 0
                Else
                    offlist!forlist.ListIndex = tmpidx
                End If
            End If
        End If
    End If
End Sub

Function oflastfor () As Integer
' get index of last forum user read from
' returns -1 if offline forums not initialized

    Dim foridx As Integer

    oflastfor = -1
    If noflfors() Then
        foridx = fididx(lastforid)
        If foridx < 0 Then
            oflastfor = 0
        Else
            oflastfor = foridx
        End If
    End If
End Function

Function oflistidx (ByVal msgidstr As String) As Integer
' Offline Forums:  get index of given message in displayed list of messages
' msgidstr: source-specific message ID string
' returns index or -1 if not found

    Dim forum As Integer, fidx As Integer

    oflistidx = -1
    forum = Val(itemidxd(msgidstr, 0, " "))
    fidx = fididx(forum)
    If fidx >= 0 And forum = curoflfor Then
        oflistidx = mididx(Val(itemidxd(msgidstr, 1, " ")), fidx)
    End If
End Function

Private Function oflistitem (ByVal idx As Integer) As String
' generate offline forums list item string
' idx:  index of forum for which to generate item

    oflistitem = Trim$(oforinf(idx).name) & tb & oforinf(idx).nunread & tb & oforinf(idx).totmsgs
End Function

Sub oflistjmp (ByVal jumpto As Integer)
' Offline Forums:  move list selection to specified message
' jumpto:   which message to jump to code

    Dim fidx As Integer, midx As Integer

    fidx = fididx(curoflfor)
    If jumpmsg(jumpto, fidx, midx) Then
        setmsgidx midx
    End If
End Sub

Sub oflstypchg (ByVal msgtype As Integer)
' Offline Forums: change list type option
' msgtype:  change to message type if True, thread type if False
' Note: this code assumes that online forums is the current source

    Dim i As Integer, newsource As Integer
    Dim himsgid As Long, hithrid As Long

    setflg msgtype, prefs.sticky, SOFLMSG
    mainform!molstmsg.Checked = (prefs.sticky And SOFLMSG) <> 0
    mainform!molstthr.Checked = (prefs.sticky And SOFLMSG) = 0
    If prefs.sticky And SOFLMSG Then
        newsource = SRCOFLMSG
    Else
        newsource = SRCOFLTHR
    End If
    If cursource <> newsource Then
        If prefs.sticky And SOFLMSG Then
            himsgid = 0
            If mainform!thrlist.ListIndex >= 0 Then
                If mainform!msglist.ListIndex >= 0 Then
                    himsgid = Val(iteminfo(mainform!msglist.Text, MLI_TMSGID))
                End If
            End If
            listofmsgs himsgid
        Else
            If mainform!msglist.ListIndex >= 0 Then
                i = lst2idx(fididx(curoflfor), mainform!msglist.ListIndex)
                hithrid = msgidx(i).thrid
                himsgid = msgidx(i).msgid
                listofthrs True, hithrid, himsgid
            Else
                listofthrs False, 0, 0
            End If
        End If
    End If
End Sub

Private Function ofmcomp (test1 As formidpos, test2 As formidpos) As Integer
' compare forum name/forum ID/message ID pairs
' test1:    first item to test
' test2:    second item to test
' returns >0 if item1 > item2, =0 if item1 = item2, <0 if item1 < item2

    Dim comp As Integer

    comp = stricmp(test1.fornam, test2.fornam)
    If comp = 0 Then
        comp = Sgn(test1.forum - test2.forum)
        If comp = 0 Then
            comp = Sgn(test1.msgid - test2.msgid)
        End If
    End If
    ofmcomp = comp
End Function

Function ofmsgavl () As Integer
' are there any offline forum messages saved?

    Dim tmps As String

    ofmsgavl = False
    If noflfors() Then
        ofmsgavl = True
    Else
        tmps = getofdbnam()
        If Len(tmps) Then
            ofmsgavl = fexist(tmps, False)
        End If
    End If
End Function

Private Function ofmsgidstr (ByVal forum As Integer, ByVal msgid As Long) As String
' generate message ID string for Offline Forums
' forum:    forum ID
' msgid:    message ID

    ofmsgidstr = CStr(forum) & " " & CStr(msgid)
End Function

Function ofnearthr (msgidstr As String, ByVal fornam As String, ByVal msgid As Long, ByVal thrid As Long, rplto As globid) As Integer
' read a message in a thread utility
' msgidstr: identifier of current message (updated if successful)
' fornam:   forum name or "" if email
' msgid:    current message ID
' thrid:    current thread ID
' rplto:    reply-to ID of current message
' direc:    direction to read (-1=prev, 0=parent, 1=next)
' returns True if message found
' implicit output: message is in msgindpk if returns True

    ofnearthr = True
    If Not ofrdthru(msgidstr, fornam, msgid, thrid, rplto, READNEXT, False) Then
        If Not ofrdthru(msgidstr, fornam, msgid, thrid, rplto, READPREV, False) Then
            ofnearthr = False
        End If
    End If
End Function

Function ofnmidx (ByVal fornam As String) As Integer
' get index of named forum in forum info array
' fornam:   name of forum to find
' returns index of forum or -1 if not found

    Dim fidx As Integer, comp As Integer

    ofnmidx = -1
    fidx = nearfidx(comp, fornam, EMLID)
    If fidx >= 0 And comp = 0 Then
        ofnmidx = fidx
    End If
End Function

Sub ofpreprd (ByVal lstidx As Integer, capstr As String, btnflgs As Integer, capflgs As Integer, msgidstr As String)
' Offline Forums:  prepare arguments to launch read form with
' lstidx:   index in message list of message to prepare
' capstr:   read form caption
' btnflgs:  button flags
' capflgs:  capability flags
' msgidstr: message ID string (forumname msgid)

    Dim i As Integer

    capstr = "Offline Forum Message"
    btnflgs = RDBALL
    capflgs = RDCDEL Or RDCSILENT Or RDCENUM
    i = fididx(curoflfor)
    msgidstr = ofmsgidstr(curoflfor, msgidx(lst2idx(i, lstidx)).msgid)
End Sub

Function ofqryunl () As Integer
' Offline Forums: OK if we unload main form

    If ofinitted And getrqid >= 0 Then
        ofqryunl = gmsgbox("Messages are still being gotten for Offline Forums. Are you sure you wish to quit?", MB_ICONQUESTION Or MB_YESNO Or MB_DEFBUTTON2, "") = IDNO
    End If
End Function

Private Function ofrdthru (msgidstr As String, ByVal fornam As String, ByVal msgid As Long, ByVal thrid As Long, rplto As globid, ByVal direc As Integer, ByVal gonline As Integer) As Integer
' read a message in a thread utility
' msgidstr: identifier of current message (updated if successful)
' fornam:   forum name or "" if email
' msgid:    current message ID
' thrid:    current thread ID
' rplto:    reply-to ID of current message
' direc:    direction to read (-1=prev, 0=parent, 1=next)
' gonline:  should we read message from online if not found locally?
' returns True if message found
' implicit output: message is in msgindpk if returns True

    Dim fidx As Integer, midx As Integer, continue As Integer
    Dim tmps As String
    Dim tmpfinf As foruminf

    ofrdthru = False
    If msgidstr = "*" Then
        If getforinf(tmpfinf, fornam) Then
            fidx = fididx(tmpfinf.forum)
            If fidx >= 0 Then
                If forreadthr(fornam, msgid, thrid, direc) Then
                    midx = mididx(msgindpk.msgid, fidx)
                    If midx < 0 Then
                        msgidstr = "*"
                    Else
                        msgidstr = ofmsgidstr(msgindpk.forum, msgindpk.msgid)
                    End If
                    ofrdthru = True
                    Exit Function
                Else
                    endofthr direc
                End If
            End If
        End If
    Else
        fidx = fididx(Val(itemidxd(msgidstr, 0, " ")))
        If fidx >= 0 Then
            midx = findthread(fidx, msgid, thrid, rplto, direc)
            If midx < 0 Then
                If gonline Then
                    continue = True
                    If Not connected() Then
                        screen.MousePointer = DEFAULT
                        Select Case direc
                        Case READPREV
                            continue = gmsgbox("There is no previous message in this thread in your offline forums. Would you like to connect and try to find it?", MB_ICONQUESTION Or MB_YESNO, "") = IDYES
                        Case READTHIS
                            continue = gmsgbox("The parent of this message is not in your offline forums. Would you like to connect and try to find it?", MB_ICONQUESTION Or MB_YESNO, "") = IDYES
                        Case READNEXT
                            continue = gmsgbox("There is no next message in this thread in your offline forums. Would you like to connect and try to find it?", MB_ICONQUESTION Or MB_YESNO, "") = IDYES
                        End Select
                    End If
                    If continue Then
                        screen.MousePointer = HOURGLASS
                        If forreadthr(fornam, msgid, thrid, direc) Then
                            msgidstr = "*"
                            ofrdthru = True
                        Else
                            endofthr direc
                        End If
                    End If
                End If
            Else
                ofrdthru = rdofmsg(fidx, midx, msgidstr, msgindpk)
            End If
        End If
    End If
End Function

Function ofreadjmp (msgidstr As String, ByVal jumpto As Integer) As Integer
' Offline Forums:  jump to (and read) a message
' msgidstr: message ID string of current message (updated if new message found)
' jumpto:   what message to jump to code
' returns True if message found

    Dim fidx As Integer, midx As Integer

    ofreadjmp = False
    fidx = fididx(Val(itemidxd(msgidstr, 0, " ")))
    If fidx < 0 Then
        Exit Function
    End If
    If jumpmsg(jumpto, fidx, midx) Then
        ofreadjmp = rdofmsg(fidx, midx, msgidstr, msgindpk)
    End If
End Function

Function ofreadmsg (msgidstr As String, ByVal direc As Integer) As Integer
' Offline Forums:  read-a-message function
' msgidstr: identifier of current message (updated if successful)
' direc:    direction to read (-1=prev, 0=exact, 1=next)
' returns:  True if message found
' implicit output: message is in msgindpk if returns True

    Dim forum As Integer, fidx As Integer, midx As Integer, found As Integer, comp As Integer
    Dim msgid As Long

    ofreadmsg = False
    found = False
    forum = Val(itemidxd(msgidstr, 0, " "))
    fidx = fididx(forum)
    msgid = Val(itemidxd(msgidstr, 1, " "))
    If fidx >= 0 Then
        Select Case direc
        Case READPREV
            midx = nearmidx(comp, msgid, fidx)
            If comp <= 0 Then
                midx = midx - 1
            End If
            If midx < 0 Then
                fidx = fidx - 1
                If fidx >= 0 Then
                    midx = oforinf(fidx).totmsgs - 1
                    found = True
                End If
            Else
                found = True
            End If
        Case READTHIS
            midx = mididx(msgid, fidx)
            If midx >= 0 Then
                found = True
            End If
        Case READNEXT
            midx = nearmidx(comp, msgid, fidx)
            If comp >= 0 Then
                midx = midx + 1
            End If
            If midx >= oforinf(fidx).totmsgs Then
                fidx = fidx + 1
                If fidx < noflfors() Then
                    midx = 0
                    found = True
                End If
            Else
                found = True
            End If
        End Select
    ElseIf forum = curoflfor Then
        Select Case direc
        Case READPREV
            If prvoflfor <> EMLID Then
                fidx = fididx(prvoflfor)
                If fidx >= 0 Then
                    midx = oforinf(fidx).totmsgs - 1
                    found = True
                End If
            End If
        Case READNEXT
            If nxtoflfor <> EMLID Then
                fidx = fididx(nxtoflfor)
                If fidx >= 0 Then
                    midx = 0
                    found = True
                End If
            End If
        End Select
    End If
    If found Then
        ofreadmsg = rdofmsg(fidx, midx, msgidstr, msgindpk)
    End If
End Function

Function ofreadthr (msgidstr As String, ByVal fornam As String, ByVal msgid As Long, ByVal thrid As Long, rplto As globid, ByVal direc As Integer) As Integer
' read a message in a thread utility
' msgidstr: identifier of current message (updated if successful)
' fornam:   forum name or "" if email
' msgid:    current message ID
' thrid:    current thread ID
' rplto:    reply-to ID of current message
' direc:    direction to read (-1=prev, 0=parent, 1=next)
' returns True if message found
' implicit output: message is in msgindpk if returns True

    ofreadthr = ofrdthru(msgidstr, fornam, msgid, thrid, rplto, direc, True)
End Function

Function ofswthr (msgidstr As String, capstr As String, ByVal fornam As String, ByVal thrid As Long, ByVal direc As Integer) As Integer
' switch threads
' msgidstr: message ID string (updated if successful)
' capstr:   message window caption (updated if successful)
' fornam:   name of forum being read from
' thrid:    current thread ID
' direc:    direction to switch (previous/next)
' returns True if thread available

    Dim forum As Integer, lstidx As Integer, fidx As Integer, midx As Integer, i As Integer
    Dim targetid As Long

    ofswthr = False
    forum = Val(itemidxd(msgidstr, 0, " "))
    If cursource = SRCOFLTHR And forum = curoflfor Then
        lstidx = gettlstidx(thrid, thrarr())
        If lstidx >= 0 Then
            midx = -1
            fidx = fididx(forum)
            Select Case direc
            Case READNEXT
                If lstidx < nintarr(thrarr()) - 1 Then
                    targetid = thrarr(Val(iteminfo(mainform!thrlist.List(lstidx + 1), MLI_THRIDX))).thrid
                    For i = oforinf(fidx).startidx To oforinf(fidx).startidx + oforinf(fidx).totmsgs - 1
                        If msgidx(i).thrid = targetid Then
                            midx = i - oforinf(fidx).startidx
                            Exit For
                        End If
                    Next
                End If
            Case READPREV
                If lstidx > 0 Then
                    targetid = thrarr(Val(iteminfo(mainform!thrlist.List(lstidx - 1), MLI_THRIDX))).thrid
                    For i = oforinf(fidx).startidx + oforinf(fidx).totmsgs - 1 To oforinf(fidx).startidx Step -1
                        If msgidx(i).thrid = targetid Then
                            midx = i - oforinf(fidx).startidx
                            Exit For
                        End If
                    Next
                End If
            End Select
            If midx >= 0 Then
                If rdofmsg(fidx, midx, msgidstr, msgindpk) Then
                    ofswthr = True
                    capstr = """" & frontstr(getminf(msgindpk.info, TPCFLD), 15) & """ Thread in " & Trim$(oforinf(fidx).name)
                End If
            End If
        End If
    Else
        popmsg "You can only switch between threads in the currently selected forum.", OFLFORCAP
    End If
End Function

Sub ofsynclst (ByVal msgidstr As String)
' synchronize list with given message
' msgidstr: ID string of message to synchronize with

    Dim forum As Integer, fidx As Integer, midx As Integer

    If Left$(msgidstr, 1) <> "*" Then
        forum = Val(itemidxd(msgidstr, 0, " "))
        fidx = fididx(forum)
        If fidx >= 0 Then
            midx = mididx(Val(itemidxd(msgidstr, 1, " ")), fidx)
            If midx >= 0 Then
                If forum <> curoflfor Then
                    setcurfor forum
                    mainform!lstname(0) = dblamp(Trim$(oforinf(fidx).name))
                    mainform!msglist.ReFreshOnUpdate = False
                    mainform!msglist.Clear
                    showmsgs msgidx(lst2idx(fidx, midx)).msgid
                    mainform!msglist.ReFreshOnUpdate = True
                    adjmsgtabs
                End If
                setmsgidx midx
            End If
        End If
    End If
End Sub

Function oftlistidx (ByVal msgidstr As String) As Integer
' Offline Forums:  get index of given message in displayed list of messages
' msgidstr: source-specific message ID string
' returns index or -1 if not found

    Dim i As Integer, forum As Integer, fidx As Integer
    Dim msgid As Long

    oftlistidx = -1
    forum = Val(itemidxd(msgidstr, 0, " "))
    fidx = fididx(forum)
    If fidx >= 0 And forum = curoflfor Then
        msgid = Val(itemidxd(msgidstr, 1, " "))
        For i = 0 To mainform!msglist.ListCount - 1
            If Val(iteminfo(mainform!msglist.List(i), MLI_TMSGID)) = msgid Then
                oftlistidx = i
                Exit Function
            End If
        Next
    End If
End Function

Sub oftlistjmp (ByVal jumpto As Integer)
' Offline Forums (thread):  move list selection to specified message
' jumpto:   which message to jump to code

    Dim i As Integer, fidx As Integer
    Dim tmpid As Long

    Select Case jumpto
    Case JUMPFRST
        setmsgidx 0
    Case JUMPSPEC
        tmpid = getjmpmid()
        If tmpid >= 0 Then
            fidx = fididx(curoflfor)
            For i = mainform!msglist.ListCount - 1 To 0 Step -1
                If Val(iteminfo(mainform!msglist.List(i), MLI_TMSGID)) <= tmpid Then
                    setmsgidx i
                    Exit Sub
                End If
            Next
            setmsgidx 0
        End If
    Case JUMPLAST
        setmsgidx mainform!msglist.ListCount - 1
    End Select
End Sub

Sub oftlstmsg (ByVal lstidx As Integer, ByVal himsgid As Long)
' Offline Forums: list messages in a thread in the current forum
' lstidx:   index in thread list of thread to list
' himsgid:  message ID to highlight or 0 for none

    Dim i As Integer, arridx As Integer

    arridx = Val(iteminfo(mainform!thrlist.List(lstidx), MLI_THRIDX))
    curofthr = thrarr(arridx).thrid
    curoftpc = Trim$(thrarr(arridx).topic)
    screen.MousePointer = HOURGLASS
    mainform!msglist.ReFreshOnUpdate = False
    mainform!msglist.Clear
    mainform!lstname(1) = dblamp(curoftpc)
    showtmsgs himsgid
    stdmlfin
End Sub

Sub oftpreprd (ByVal lstidx As Integer, capstr As String, btnflgs As Integer, capflgs As Integer, msgidstr As String)
' Offline Forums (thread):  prepare arguments to launch read form with
' lstidx:   index in message list of message to prepare
' capstr:   read form caption
' btnflgs:  button flags
' capflgs:  capability flags
' msgidstr: message ID string

    capstr = """" & frontstr(curoftpc, 15) & """ Thread in " & Trim$(oforinf(fididx(curoflfor)).name)
    btnflgs = RDBTHREAD Or RDBNPTHR Or RDBJUMP
    capflgs = RDCDEL Or RDCSILENT
    msgidstr = ofmsgidstr(curoflfor, Val(iteminfo(mainform!msglist.List(lstidx), MLI_TMSGID)))
End Sub

Function oftreadjmp (msgidstr As String, ByVal jumpto As Integer) As Integer
' Offline Forums (thread):  jump to (and read) a message
' msgidstr: message ID string of current message (updated if new message found)
' jumpto:   what message to jump to code
' returns True if message found

    Dim i As Integer, fidx As Integer, midx As Integer, found As Integer, arridx As Integer, lastidx As Integer
    Dim startidx As Integer, endidx As Integer
    Dim tmpid As Long

    oftreadjmp = False
    found = False
    fidx = fididx(Val(itemidxd(msgidstr, 0, " ")))
    If fidx < 0 Then
        Exit Function
    End If
    startidx = oforinf(fidx).startidx
    endidx = startidx + oforinf(fidx).totmsgs - 1
    Select Case jumpto
    Case JUMPFRST
        For i = startidx To endidx
            If msgidx(i).thrid = curofthr Then
                midx = i
                found = True
                Exit For
            End If
        Next
    Case JUMPSPEC
        tmpid = getjmpmid()
        If tmpid >= 0 Then
            lastidx = -1
            For i = endidx To startidx Step -1
                If msgidx(i).thrid = curofthr Then
                    If msgidx(i).msgid <= tmpid Then
                        midx = i
                        found = True
                        Exit For
                    Else
                        lastidx = i
                    End If
                End If
            Next
            If Not found And lastidx >= 0 Then
                midx = lastidx
                found = True
            End If
        End If
    Case JUMPLAST
        For i = endidx To startidx Step -1
            If msgidx(i).thrid = curofthr Then
                midx = i
                found = True
                Exit For
            End If
        Next
    End Select
    If found Then
        oftreadjmp = rdofmsg(fidx, midx - startidx, msgidstr, msgindpk)
    End If
End Function

Function oftreadmsg (msgidstr As String, ByVal direc As Integer) As Integer
' Offline Forums (thread):  read-a-message function
' msgidstr: identifier of current message (updated if successful)
' direc:    direction to read (-1=prev, 0=exact, 1=next)
' returns:  True if message found
' implicit output: message is in msgindpk if returns True

    Dim fidx As Integer, midx As Integer, found As Integer

    oftreadmsg = False
    fidx = fididx(Val(itemidxd(msgidstr, 0, " ")))
    If fidx >= 0 Then
        If direc = READTHIS Then
            midx = mididx(Val(itemidxd(msgidstr, 1, " ")), fidx)
            If midx >= 0 Then
                oftreadmsg = rdofmsg(fidx, midx, msgidstr, msgindpk)
            End If
        End If
    End If
End Function

Sub oftsynclst (ByVal msgidstr As String)
' synchronize list with given message
' msgidstr: ID string of message to synchronize with

    Dim i As Integer, forum As Integer, fidx As Integer, midx As Integer
    Dim msgid As Long, thrid As Long

    If Left$(msgidstr, 1) <> "*" Then
        forum = Val(itemidxd(msgidstr, 0, " "))
        fidx = fididx(forum)
        If forum = curoflfor Then
            midx = mididx(Val(itemidxd(msgidstr, 1, " ")), fidx)
            If midx >= 0 Then
                i = lst2idx(fidx, midx)
                msgid = msgidx(i).msgid
                thrid = msgidx(i).thrid
                If thrid = curofthr Then
                    For i = 0 To mainform!msglist.ListCount - 1
                        If Val(iteminfo(mainform!msglist.List(i), MLI_TMSGID)) = msgid Then
                            setmsgidx i
                            Exit Sub
                        End If
                    Next
                Else
                    i = gettlstidx(thrid, thrarr())
                    If i >= 0 Then
                        mainform!thrlist.ListIndex = i
                        oftlstmsg i, msgid
                    End If
                End If
            End If
        End If
    End If
End Sub

Sub ofupdread (ByVal forum As Integer, ByVal msgid As Long)
' Offline Forums:  update message read status
' forum:    forum ID of message to update
' msgid:    message ID of message to update
' Note: this sub should only be called when the message changes from unread to read

    Dim fidx As Integer

    fidx = fididx(forum)
    If fidx >= 0 Then
        If mididx(msgid, fidx) >= 0 And oforinf(fidx).nunread > 0 Then
            oforinf(fidx).nunread = oforinf(fidx).nunread - 1
        End If
    End If
End Sub

Private Function delofmsg (ByVal fidx As Integer, ByVal midx As Integer, ByVal source As Integer) As Integer
' delete a message from Offline Forums file, lists, etc.
' fidx:     index of forum message is in
' midx:     index of message in forum
' source:   source message being deleted from
' returns True if successful

    Dim i As Integer, j As Integer, delidx As Integer, delforum As Integer
    Dim delmsgid As Long, delthrid As Long

    delofmsg = False
    If UBound(msgidx) = 0 Then
        clearof
        If cursource = SRCOFLMSG Or cursource = SRCOFLTHR Then
            mainform!thrlist.Clear
            mainform!msglist.Clear
        End If
        delofmsg = True
        Exit Function
    End If
    delidx = lst2idx(fidx, midx)
    If mdbdelete(ofdbf, msgidx(delidx).fpos) Then
        delforum = msgidx(delidx).forum
        delmsgid = msgidx(delidx).msgid
        delthrid = msgidx(delidx).thrid
        For i = delidx To msgarrsiz() - 2
            msgidx(i) = msgidx(i + 1)
        Next
        ReDim Preserve msgidx(UBound(msgidx) - 1)
        For i = 0 To noflfors() - 1
            If oforinf(i).startidx > delidx Then
                oforinf(i).startidx = oforinf(i).startidx - 1
            End If
        Next
        oforinf(fidx).totmsgs = oforinf(fidx).totmsgs - 1
        If oforinf(fidx).totmsgs Then
            If Not msgmarked(delforum, delmsgid) Then
                oforinf(fidx).nunread = oforinf(fidx).nunread - 1
            End If
            If cursource = source And fidx = fididx(curoflfor) Then
                If source = SRCOFLTHR Then
                    If delthrid = curofthr Then
                        For i = 0 To mainform!msglist.ListCount - 1
                            If Val(iteminfo(mainform!msglist.List(i), MLI_TMSGID)) = delmsgid Then
                                remlbitem mainform!msglist, i
                                Exit For
                            End If
                        Next
                    End If
                    i = gettidx(delthrid, thrarr())
                    If i >= 0 Then
                        delidx = thrarr(i).lstidx
                        If thrarr(i).nmsgs > 1 Then
                            thrarr(i).nmsgs = thrarr(i).nmsgs - 1
                            mainform!thrlist.List(delidx) = Trim$(thrarr(i).topic) & tb & thrarr(i).nmsgs & tb & "0" & FLDSEP & i
                        Else
                            For j = i To UBound(thrarr) - 1
                                thrarr(j) = thrarr(j + 1)
                            Next
                            ReDim Preserve thrarr(UBound(thrarr) - 1)
                            If i > UBound(thrarr) Then
                                i = i - 1
                            End If
                            mainform!thrlist.ReFreshOnUpdate = False
                            mainform!thrlist.Clear
                            junk = showthrs(False, 0)
                            If delidx < mainform!thrlist.ListCount Then
                                mainform!thrlist.ListIndex = delidx
                            Else
                                mainform!thrlist.ListIndex = mainform!thrlist.ListCount - 1
                            End If
                            mainform!thrlist.ReFreshOnUpdate = True
                            On Error Resume Next
                            mainform!thrlist.SetFocus
                            On Error GoTo 0
                        End If
                    End If
                Else
                    remlbitem mainform!msglist, midx
                End If
            End If
        Else
            If cursource = source And fidx = fididx(curoflfor) Then
                Erase thrarr
                mainform!thrlist.Clear
                mainform!msglist.Clear
            End If
            For i = fidx To UBound(oforinf) - 1
                oforinf(i) = oforinf(i + 1)
            Next
            ReDim Preserve oforinf(UBound(oforinf) - 1)
        End If
        anydel = True
        delofmsg = True
    End If
End Function

Function excerpt (ByVal txt As String, ByVal excsiz As Integer) As String
' create an "excerpt" of a message
' txt:      string to excerpt
' excsiz:   max size of excerpt
' Note: txt is assumed to have single-character end-of-line characters

    Dim i As Integer

    If isrtf(txt) Then
        txt = yankrtf(txt)
    End If
    txt = strrpl(txt, Chr$(10), Chr$(13))
    Do
        Do While Len(txt)
            If Asc(txt) > 32 Then   '32 = Asc(" ")
                Exit Do
            End If
            txt = Mid$(txt, 2)
        Loop
        If isquoted(txt) Then
            i = InStr(txt, Chr$(13))
            If i = 0 Then
                Exit Do
            End If
            txt = Mid$(txt, i + 1)
        Else
            Exit Do
        End If
    Loop While Len(txt)
    If Len(txt) = 0 Then
        excerpt = ""
        Exit Function
    End If
    txt = strrpl(txt, Chr$(13), " ")
    txt = strrpl(txt, tb, " ")
    Do
        i = Len(txt)
        txt = strrpl(txt, "  ", " ")
    Loop While i <> Len(txt)
    excerpt = Left$(txt, excsiz)
End Function

Private Function fididx (ByVal forum As Integer) As Integer
' get index of forum in list of forums given forum ID
' forum:    forum ID
' returns index if found or -1 if not

    Dim i As Integer

    fididx = -1
    For i = 0 To noflfors() - 1
        If forum = oforinf(i).forum Then
            fididx = i
            Exit Function
        End If
    Next
End Function

Private Sub fincurfor ()
' finished with current forum being gotten, add new messages to index

    Dim i As Integer, fidx As Integer, insidx As Integer, numnew As Integer, oldnmsgs As Integer
    Dim himsgid As Long, hithrid As Long

    screen.MousePointer = HOURGLASS

    ' save current highlighted items, if we're updating the currently displayed forum
    If (cursource = SRCOFLTHR Or cursource = SRCOFLMSG) And newforid = curoflfor Then
        himsgid = 0
        hithrid = 0
        If cursource = SRCOFLTHR Then
            If mainform!msglist.ListIndex >= 0 Then
                hithrid = curofthr
                himsgid = Val(iteminfo(mainform!msglist.Text, MLI_TMSGID))
            ElseIf mainform!thrlist.ListIndex >= 0 Then
                hithrid = thrarr(Val(iteminfo(mainform!thrlist.Text, MLI_THRIDX))).thrid
            End If
        Else
            If mainform!msglist.ListIndex >= 0 Then
                himsgid = msgidx(lst2idx(fididx(curoflfor), mainform!msglist.ListIndex)).msgid
            End If
        End If
    End If

    ' allocate room in message index for new messages
    oldnmsgs = msgarrsiz()
    numnew = UBound(newidx) + 1
    ReDim Preserve msgidx(oldnmsgs + numnew - 1)

    ' figure out where in message index to put new messages
    fidx = fididx(newforid)
    If fidx = UBound(oforinf) Then
        insidx = oldnmsgs
    Else
        insidx = oforinf(fidx + 1).startidx
        For i = oldnmsgs - 1 To insidx Step -1
            msgidx(numnew + i) = msgidx(i)
        Next
        For i = fidx + 1 To noflfors() - 1
            oforinf(i).startidx = oforinf(i).startidx + numnew
        Next
    End If

    ' put new messages in message index
    For i = 0 To numnew - 1
        msgidx(insidx + i) = newidx(i)
        updftots fidx, newidx(i).forum, newidx(i).msgid
    Next
    sortforum oforinf(fidx).startidx, oforinf(fidx).totmsgs

    ' update list of offline forums
    If isloaded(offlist) Then
        offlist!forlist.List(fidx) = oflistitem(fidx)
    End If

    ' re-display list of threads/messages if this forum is currently displayed
    If (cursource = SRCOFLTHR Or cursource = SRCOFLMSG) And newforid = curoflfor Then
        If cursource = SRCOFLTHR Then
            listofthrs True, hithrid, himsgid
        Else
            listofmsgs himsgid
        End If
    End If

    screen.MousePointer = DEFAULT
End Sub

Private Function findthread (ByVal fidx As Integer, ByVal msgid As Long, ByVal thrid As Long, rplto As globid, ByVal direc As Integer) As Integer
' find specified message in a thread
' fidx:     index of forum to search
' msgid:    current message ID
' thrid:    current thread ID
' rplto:    reply-to ID of current message
' direc:    direction to thread in
' returns index within forum of message if found or -1 if not found

    Dim i As Integer, startidx As Integer, endidx As Integer

    findthread = -1
    startidx = oforinf(fidx).startidx
    endidx = startidx + oforinf(fidx).totmsgs - 1
    Select Case direc
    Case READPREV
        For i = endidx To startidx Step -1
            If msgidx(i).thrid = thrid And msgidx(i).msgid < msgid Then
                findthread = i - startidx
                Exit Function
            End If
        Next
    Case READTHIS
        If rplto.sysid = 0 Or rplto.msgid = 0 Then
            Exit Function
        End If
        For i = startidx To endidx
            If msgidx(i).gmid.sysid = rplto.sysid And msgidx(i).gmid.msgid = rplto.msgid Then
                findthread = i - startidx
                Exit Function
            End If
        Next
    Case READNEXT
        For i = startidx To endidx
            If msgidx(i).thrid = thrid And msgidx(i).msgid > msgid Then
                findthread = i - startidx
                Exit Function
            End If
        Next
    End Select
End Function

Private Sub finget (ByVal aborted As Integer)
' finish up message get process

    Dim i As Integer
    Dim tmps As String

    If newforid Then
        fincurfor
    End If
    If prefs.sticky And SDSWNDN Then
        If anydnlds Then
            wait2disc = True
        Else
            disconnect
        End If
    End If
    If isloaded(offlist) Then
        i = offlist!forlist.ListIndex
        loadlist offlist!forlist
        If i < 0 And offlist!forlist.ListCount > 0 Then
            offlist!forlist.ListIndex = 0
        Else
            offlist!forlist.ListIndex = i
        End If
        offixbtns
    End If
    closeofdb
    If noflfors() = 0 Then  ' no messages before, none gotten
        clearof
    ElseIf mdbopen(ofdbnam, ofdbf) <> 0 Then
        poperror "An unrecoverable error has occurred while writing to data file", OFLFORCAP
        killoflfor
        Exit Sub
    End If
    If totmsgs <> 0 And Not appclsipg Then
        If aborted Then
            tmps = "Offline forum get aborted." & nl
        Else
            tmps = "Offline forum get complete." & nl
        End If
        tmps = tmps & totmsgs & " message(s) gotten"
        If totunrd Then
            tmps = tmps & "," & nl & totunrd & " unread"
        End If
        If totmsgs = totnew Then
            tmps = tmps & "."
        Else
            tmps = tmps & "," & nl & totmsgs - totnew & " duplicate(s)."
        End If
        popmsg tmps, OFLFORCAP
    End If
    adjrdbtn
End Sub

Function rdofdbf (ByVal forlstidx As Integer, ByVal msglstidx As Integer, msg As msgdpk) As Integer
' read a message from Offline Forums database file and generate error message if unsuccessful
' forlstidx:    index of forum message is in
' msglstidx:    index of message within forum
' msg:          buffer into which to read
' returns True if successful

    If mdbread(ofdbf, msgidx(lst2idx(forlstidx, msglstidx)).fpos, msg) Then
        msg.fornam = oforinf(forlstidx).name
        rdofdbf = True
    Else
        rdofdbf = False
        poperror "Error reading Offline Forums data file.", OFLFORCAP
    End If
End Function

Function rdofmsg (ByVal forlstidx As Integer, ByVal msglstidx As Integer, msgidstr As String, msg As msgdpk) As Integer
' read a message from Offline Forums database
' forlstidx:    index of forum message is in
' msglstidx:    index of message within forum
' msgidstr:     identifier of current message (updated if successful)
' msg:          buffer into which to read
' returns True if successful


    rdofmsg = False
    If rdofdbf(forlstidx, msglstidx, msg) Then
        rdofmsg = True
        msgidstr = ofmsgidstr(msg.forum, msg.msgid)
        lastforid = msg.forum
        lastthrid = msg.thrid
        lastmsgid = msg.msgid
    End If
End Function

Private Function recovArraySize (arr() As formidpos) As Integer
' get size of a recover list

    recovArraySize = 0
    On Error GoTo recovArraySize_err
    recovArraySize = UBound(arr) + 1
recovArraySize_err:
    Exit Function
End Function

Private Function recover () As Integer
' try to recover a damaged data file
' returns True if successful

    Dim iRename As Integer, iRecover As Integer, iRecoverUpper As Integer
    Dim newnam As String, fornam As String
    Dim newf As Integer
    Dim fpos As Long
    Dim TempInfo As formidpos
    Dim RecoverIndex() As formidpos
    Dim RenameList() As formidpos
    Dim newidx() As Long
    Dim tmpuinf As ofuinfstruct
    Static norecurs As Integer  'assumes this is initialized to False

    ' initialize return value to False
    recover = False

    ' check for recursion (re-initialization failed)
    If norecurs Then
        If gmsgbox("Recovery failed! Would you like to clear your offline forums now?", MB_ICONEXCLAMATION Or MB_YESNO, OFLFORCAP) = IDYES Then
            clearof
        Else
            Erase oforinf
            Erase msgidx
            mdbclose ofdbf
        End If
        Exit Function
    End If

    ' ask whether user wants to recover
    screen.MousePointer = DEFAULT
    If gmsgbox("Your offline forums data file has become damaged or needs to be re-sorted. Would you like to correct it now?", MB_ICONQUESTION Or MB_YESNO, OFLFORCAP) <> IDYES Then
        Erase oforinf
        Erase msgidx
        mdbclose ofdbf
        Exit Function
    End If

    ' create new data file
    newnam = newofdbnam()
    If Not newofdb(newnam, tmpuinf, newf) Then
        Erase oforinf
        Erase msgidx
        mdbclose ofdbf
        Exit Function
    End If

    ' copy messages from old database to new database and form recover index
    screen.MousePointer = HOURGLASS
    mdbrewind ofdbf
    Do While mdbnext(ofdbf, getmsg)
        fpos = mdbaddmsg(newf, getmsg)
        If fpos Then

            ' see if forum is already on rename list
            iRename = recovFindInList(getmsg.forum, RenameList())
            If iRename >= 0 Then

                ' set forum name
                fornam = Trim$(RenameList(iRename).fornam)

                ' if non-existent forum, track highest message ID
                If Len(fornam) = 0 Then
                    fornam = Trim$(getmsg.fornam)
                    If getmsg.msgid > RenameList(iRename).msgid Then RenameList(iRename).fpos = recovArraySize(RecoverIndex())
                End If
            Else

                ' get forum name from forum ID
                fornam = getForumName(getmsg.forum, "")
            
                ' if name on message is different from actual name, add to rename list
                If Not sameas(fornam, Trim$(getmsg.fornam)) Then
                    TempInfo.fornam = fornam
                    TempInfo.forum = getmsg.forum
                    TempInfo.msgid = getmsg.msgid
                    TempInfo.fpos = recovArraySize(RecoverIndex())
                    iRename = recovArraySize(RenameList())
                    ReDim Preserve RenameList(iRename)
                    RenameList(iRename) = TempInfo
                End If

                ' use forum name from message if forum doesn't exist
                If Len(fornam) = 0 Then fornam = Trim$(getmsg.fornam)
            End If
            
            ' add message info to recover index
            TempInfo.fornam = fornam
            TempInfo.forum = getmsg.forum
            TempInfo.msgid = getmsg.msgid
            TempInfo.fpos = fpos
            iRecover = recovArraySize(RecoverIndex())
            ReDim Preserve RecoverIndex(iRecover)
            RecoverIndex(iRecover) = TempInfo
        Else

            ' if out of disk space, alert user and abort recover
            If mdberror() = 61 Then     'out of disk space
                screen.MousePointer = DEFAULT
                poperror "Insufficient disk space to complete recovery.", OFLFORCAP
                Erase oforinf
                Erase msgidx
                mdbclose ofdbf
                mdbclose newf
                On Error Resume Next
                Kill newnam
                Exit Function
            End If

            ' on all other errors, stop reading from old file and continue with rest of recovery
            Exit Do
        End If
    Loop
    
    ' if we didn't find any messages, clear database and exit
    If recovArraySize(RecoverIndex()) = 0 Then
        screen.MousePointer = DEFAULT
        poperror "No messages were found to be recovered.", OFLFORCAP
        clearof
        mdbclose newf
        On Error Resume Next
        Kill newnam
        Exit Function
    End If

    ' rename forums if necessary
    If recovArraySize(RenameList()) Then

        ' for deleted forums, set forum name to name on latest message
        For iRename = 0 To recovArraySize(RenameList()) - 1
            If Len(Trim$(RenameList(iRename).fornam)) = 0 Then
                iRecover = RenameList(iRename).fpos
                RenameList(iRename).fornam = RecoverIndex(iRecover).fornam
            End If
        Next

        ' run through recover index, renaming any messages that need it
        For iRecover = 0 To recovArraySize(RecoverIndex()) - 1

            ' see if forum is in rename list
            iRename = recovFindInList(RecoverIndex(iRecover).forum, RenameList())
            If iRename >= 0 Then
                
                ' make sure correct name is in recover index
                fornam = Trim$(RenameList(iRename).fornam)
                RecoverIndex(iRecover).fornam = fornam

                ' read message
                fpos = RecoverIndex(iRecover).fpos
                If mdbread(newf, fpos, getmsg) Then

                    ' update message if it has a different forum name
                    If Not sameas(Trim$(getmsg.fornam), fornam) Then
                        getmsg.fornam = fornam
                        fpos = mdbupdate(newf, fpos, getmsg)
                        ' we're assuming position won't change since size hasn't changed
                    End If
                End If
            End If
        Next
    End If

    ' sort recover index
    For iRecover = 0 To recovArraySize(RecoverIndex()) - 2
        For iRecoverUpper = iRecover + 1 To recovArraySize(RecoverIndex()) - 1
            If ofmcomp(RecoverIndex(iRecover), RecoverIndex(iRecoverUpper)) > 0 Then
                TempInfo = RecoverIndex(iRecover)
                RecoverIndex(iRecover) = RecoverIndex(iRecoverUpper)
                RecoverIndex(iRecoverUpper) = TempInfo
            End If
        Next
    Next

    ' save new file index
    ReDim newidx(UBound(RecoverIndex))
    For iRecover = 0 To UBound(RecoverIndex)
        newidx(iRecover) = RecoverIndex(iRecover).fpos
    Next
    junk = mdbsaveidx(newf, newidx(), UBound(newidx) + 1)

    ' clean up arrays
    Erase RecoverIndex
    Erase RenameList
    Erase newidx

    ' set data file to new file
    mdbclose newf
    clearof
    setofdbnam newnam

    ' retry initialization
    screen.MousePointer = DEFAULT
    norecurs = True
    recover = initof()
    norecurs = False
End Function

Private Function recovFindInList (ByVal forum As Integer, arr() As formidpos) As Integer
' find a forum by forum ID in a recover list
' forum:    forum ID to find
' arr:      recover info array to search
' returns index of element if found, -1 if not

    Dim i As Integer

    recovFindInList = -1
    If recovArraySize(arr()) Then
        For i = 0 To UBound(arr)
            If arr(i).forum = forum Then
                recovFindInList = i
                Exit Function
            End If
        Next
    End If
End Function

Function seloflfor (ByVal getflg As Integer) As Integer
' select an offline forum
' getflg:   initiate message get?
' returns False if user cancelled

    Dim tmps As String
    Dim fidx As Integer

    seloflfor = False
    fidx = fididx(curoflfor)
    If fidx >= 0 Then
        tmps = Trim$(oforinf(fidx).name)
    End If
    tmps = formfunc(offlist, tmps & tb & getflg)
    If Len(tmps) Then
        fidx = Val(tmps)
        setcurfor oforinf(fidx).forum
        tmps = Trim$(oforinf(fidx).name)
        If getforinf(curforinf, tmps) Then
            prefs.curfor = tmps
        End If
        seloflfor = True
    End If
End Function

Private Sub setcurfor (ByVal forum As Integer)
' set the current forum context

    Dim fidx As Integer

    fidx = fididx(forum)
    If fidx >= 0 Then
        curoflfor = forum
        prvoflfor = EMLID
        nxtoflfor = EMLID
        If fidx > 0 Then
            prvoflfor = oforinf(fidx - 1).forum
        End If
        If fidx < noflfors() - 1 Then
            nxtoflfor = oforinf(fidx + 1).forum
        End If
    End If
End Sub

Private Sub setofdbnam (ByVal newname As String)
' save offline forum database file name

    newname = fnpart(newname)
    junk = swrtdpkv(OFLFDPK, STGLEN, newname)
End Sub

Private Sub setupmain ()
' set up main form menu/toolbar

    tbvis mtbid, MTB_DELETE & SETSEP & MTB_JFIRST & SETSEP & MTB_JSPEC & SETSEP & MTB_JLAST & SETSEP & MTB_LSTMSG & SETSEP & MTB_LSTTHR
    mainform!mfdel.Visible = True
    jmpmnuvis True
    tagmnuvis False
    lopmnuvis True
    fopmnuvis False, ""
End Sub

Private Sub showmsgs (ByVal himsgid As Long)
'show the messages in the currently selected offline forum
' himsgid:  message ID to highlight after or 0 for default

    Dim i As Integer, j As Integer, fidx As Integer, flags As Integer, lstidx As Integer, rdfnd As Integer

    lstidx = 0
    rdfnd = False
    fidx = fididx(curoflfor)
    If fidx < 0 Then
        Exit Sub
    End If
    For i = 0 To oforinf(fidx).totmsgs - 1
        If Not rdofdbf(fidx, i, listmsg) Then
            Exit For
        End If
        j = addmsg2lst(listmsg, flags)
        If himsgid Then
            If listmsg.msgid = himsgid Then
                lstidx = j
            End If
        Else
            If flags And MLF_READ Then
                lstidx = j
                rdfnd = True
            End If
        End If
    Next
    i = mainform!msglist.ListCount
    If i Then
        If himsgid = 0 And rdfnd And lstidx < i - 1 Then
            lstidx = lstidx + 1
        End If
        If lstidx Then
            mainform!msglist.TopIndex = lstidx - 1
        End If
        setmsgidx lstidx
    End If
End Sub

Private Sub showoftot (lst As Control)
' show total messages items in offline forums list
' lst:  list box to put into

    Dim i As Long
    Dim tmps As String

    setffont lst.Parent, lst
    i = msgarrsiz()
    tmps = ""
    Do
        tmps = tmps & "-"
    Loop While lst.Parent.TextWidth(CStr(i)) > lst.Parent.TextWidth(tmps)
    lst.AddItem tb & tb & tmps
    lst.AddItem tb & tb & CStr(i)
End Sub

Private Function showthrs (ByVal highlight As Integer, ByVal hithrid As Long) As Integer
' show threads in currently selected offline forum
' highlight:    highlight a specific thread?
' hithrid:      thread ID of thread to highlight
' returns list index of thread highlighted if highlight is True and the specified thread was found (else -1)

    Dim i As Integer, found As Integer, arridx As Integer, hiltidx As Integer

    showthrs = -1
    hiltidx = 0
    found = False
    For i = 0 To nintarr(thrarr()) - 1
        mainform!thrlist.AddItem Trim$(thrarr(i).topic) & tb & thrarr(i).nmsgs & tb & "0" & FLDSEP & i
    Next
    For i = 0 To mainform!thrlist.ListCount - 1
        arridx = Val(iteminfo(mainform!thrlist.List(i), MLI_THRIDX))
        thrarr(arridx).lstidx = i
        If highlight And Not found Then
            If thrarr(arridx).thrid = hithrid Then
                found = True
                hiltidx = i
            End If
        End If
    Next
    If mainform!thrlist.ListCount Then
        mainform!thrlist.ListIndex = hiltidx
    End If
    If found Then
        showthrs = hiltidx
    End If
End Function

Private Sub showtmsgs (ByVal inimsgid As Long)
' show list of messages in a thread
' inimsgid: message ID to put cursor on (or 0 for default)

    Dim i As Integer, j As Integer, flags As Integer, fidx As Integer, lstidx As Integer, rdfnd As Integer
    Dim comp As Long

    lstidx = 0
    rdfnd = False
    fidx = fididx(curoflfor)
    For i = oforinf(fidx).startidx To oforinf(fidx).startidx + oforinf(fidx).totmsgs - 1
        If msgidx(i).thrid = curofthr Then
            If Not rdofdbf(fidx, i - oforinf(fidx).startidx, listmsg) Then
                Exit For
            End If
            j = add2tmlst(listmsg, flags)
            If inimsgid Then
                If listmsg.msgid = inimsgid Then
                    lstidx = j
                End If
            Else
                If flags And MLF_READ Then
                    lstidx = j
                    rdfnd = True
                End If
            End If
        End If
    Next
    i = mainform!msglist.ListCount
    If i Then
        If inimsgid = 0 And rdfnd And lstidx < i - 1 Then
            lstidx = lstidx + 1
        End If
        If lstidx Then
            mainform!msglist.TopIndex = lstidx - 1
        End If
        setmsgidx lstidx
    End If
End Sub

Private Sub sortforum (ByVal startidx As Integer, ByVal nummsgs As Integer)
' sort messages in a forum by message ID
' startidx: index in msgidx of first message in forum
' nummsgs:  number of messages in forum

    Dim i As Integer, j As Integer
    Dim swap As ofidxstruct

    For i = startidx To startidx + nummsgs - 2
        For j = i + 1 To startidx + nummsgs - 1
            If msgidx(j).msgid < msgidx(i).msgid Then
                swap = msgidx(i)
                msgidx(i) = msgidx(j)
                msgidx(j) = swap
            End If
        Next
    Next
End Sub

Private Sub untagrest ()
' untag the rest of the messages/threads in the current forum

    Dim tmpid As Long

    While thr2get(curforid, tmpid)
        untagthr tmpid, getfornam
        gotthrtg getfornam, tmpid
    Wend
    While msg2get(curforid, tmpid)
        untagmsg tmpid, getfornam
        gotmsgtg getfornam, tmpid
    Wend
End Sub

Private Sub updftots (ByVal fidx As Integer, ByVal forum As Integer, ByVal msgid As Long)
' update forum counts
' fidx:     index of forum in forum info array
' forum:    forum ID
' msgid:    message ID of new message

    If Not msgmarked(forum, msgid) Then
        totunrd = totunrd + 1
        oforinf(fidx).nunread = oforinf(fidx).nunread + 1
    End If
    oforinf(fidx).totmsgs = oforinf(fidx).totmsgs + 1
End Sub

Private Sub updusrinf ()
' update Offline Forums user info saved in data file

    Dim i As Integer
    Dim tmpx As ofuinfx

    i = fididx(lastforid)
    If i < 0 Then
        ofusrinf.lastfor = 0
        ofusrinf.lastmsg = 0
        ofusrinf.lastthr = 0
    Else
        ofusrinf.lastfor = i
        i = mididx(lastmsgid, i)
        If i < 0 Then
            ofusrinf.lastmsg = 0
        Else
            ofusrinf.lastmsg = i
        End If
        ofusrinf.lastthr = lastthrid
    End If
    LSet tmpx = ofusrinf
    junk = mdbsaveusr(ofdbf, tmpx.s)
End Sub

Private Sub clearof ()
' clear offline forums

    If getrqid >= 0 Then
        cangetrq
    End If
    Erase oforinf
    Erase msgidx
    anydel = False
    mdbclose ofdbf
    On Error Resume Next
    Kill ofdbnam
    setofdbnam ""
End Sub

Sub closeof ()
' close offline forums

    If noflfors() Then
        If getrqid >= 0 Then
            cangetrq
            If newforid Then
                fincurfor
            End If
        End If
        compofdb
        closeofdb
        Erase oforinf
        Erase msgidx
    End If
End Sub

Private Sub closeofdb ()
' close offline forums database file

    Dim i As Integer, tmpidx() As Long

    updusrinf
    If noflfors() Then
        ReDim tmpidx(UBound(msgidx))
        For i = 0 To UBound(tmpidx)
            tmpidx(i) = msgidx(i).fpos
        Next
        junk = mdbsaveidx(ofdbf, tmpidx(), UBound(tmpidx) + 1)
        Erase tmpidx
    End If
    mdbclose ofdbf
End Sub

Private Sub compofdb ()
' compress Offline Forums data file

    Dim i As Integer, newf As Integer, aborted As Integer, totmsgs As Integer
    Dim newidx() As Long
    Dim newnam As String

    If Not anydel Then
        Exit Sub
    End If
    progopen PRGT_BAR, "Compressing Offline Forums", "Removing deleted messages from Offline Forums data file.", "", ""
    aborted = False
    newnam = newofdbnam()
    If Not newofdb(newnam, ofusrinf, newf) Then
        progclose
        poperror "Unable to create new data file.", OFLFORCAP
        Exit Sub
    End If
    updusrinf
    totmsgs = msgarrsiz()
    ReDim newidx(totmsgs - 1)
    For i = 0 To totmsgs - 1
        If Not mdbread(ofdbf, msgidx(i).fpos, getmsg) Then
            progclose
            poperror "Error reading Offline Forums data file.", OFLFORCAP
            killoflfor
            aborted = True
            Exit Sub
        End If
        newidx(i) = mdbaddmsg(newf, getmsg)
        If newidx(i) = 0 Then
            progclose
            If mdberror() = 61 Then
                poperror "Insufficient disk space to complete compression.", OFLFORCAP
            Else
                poperror "An unrecoverable error has occurred while writing to data file.", OFLFORCAP
            End If
            aborted = True
            Exit For
        End If
        progupdate CStr(100& * i \ totmsgs)
        DoEvents
        If progcancel() Then
            aborted = True
            Exit For
        End If
    Next
    If Not aborted Then
        progupdate "100"
        junk = mdbsaveidx(newf, newidx(), totmsgs)
    End If
    progclose
    mdbclose newf
    If aborted Then
        On Error Resume Next
        Kill newnam
    Else
        anydel = False
        mdbclose ofdbf
        On Error Resume Next
        Kill ofdbnam
        On Error GoTo 0
        ofdbnam = newnam
        setofdbnam ofdbnam
        If mdbopen(ofdbnam, ofdbf) <> 0 Then
            poperror "An unrecoverable error has occurred while writing to data file.", OFLFORCAP
            killoflfor
            Exit Sub
        End If
        For i = 0 To totmsgs - 1
            msgidx(i).fpos = newidx(i)
        Next
    End If
End Sub

Function yankrtf (ByVal rtfstr As String) As String
' get a plain-text version of an RTF string

    mfontdlg!sample.Text = ""
    mfontdlg!sample.RTFSelText = rtfstr
    yankrtf = mfontdlg!sample.Text
End Function

