VERSION 2.00
Begin Form mtabdlg
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Tab Setup"
   ClientHeight    =   3015
   ClientLeft      =   2220
   ClientTop       =   3030
   ClientWidth     =   5235
   Height          =   3480
   HelpContextID   =   66
   Left            =   2130
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3015
   ScaleWidth      =   5235
   Top             =   2655
   Width           =   5415
   Begin CommandButton setbtn
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Set"
      Height          =   360
      Left            =   4020
      TabIndex        =   11
      Top             =   1080
      Width           =   960
   End
   Begin CommandButton clallbtn
      BackColor       =   &H00C0C0C0&
      Caption         =   "Clear &All"
      Height          =   360
      Left            =   4020
      TabIndex        =   13
      Top             =   1920
      Width           =   960
   End
   Begin CommandButton clearbtn
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Clear"
      Height          =   360
      Left            =   4020
      TabIndex        =   12
      Top             =   1500
      Width           =   960
   End
   Begin CommandButton okbtn
      BackColor       =   &H00C0C0C0&
      Caption         =   "&OK"
      Default         =   -1  'True
      Height          =   360
      Left            =   4020
      TabIndex        =   9
      Top             =   180
      Width           =   960
   End
   Begin CommandButton cancelbtn
      BackColor       =   &H00C0C0C0&
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   360
      Left            =   4020
      TabIndex        =   10
      Top             =   600
      Width           =   960
   End
   Begin CommandButton helpbtn
      BackColor       =   &H00C0C0C0&
      Caption         =   "Help"
      Height          =   360
      Left            =   4020
      TabIndex        =   14
      Top             =   2400
      Width           =   960
   End
   Begin SSFrame Frame3D2
      Caption         =   "&Type"
      ForeColor       =   &H00000000&
      Height          =   2055
      Left            =   2340
      TabIndex        =   4
      Top             =   720
      Width           =   1455
      Begin SSOption ltabtype
         Caption         =   "Left"
         Height          =   255
         Left            =   180
         TabIndex        =   5
         Top             =   360
         Width           =   795
      End
      Begin SSOption ctabtype
         Caption         =   "Centered"
         Height          =   255
         Left            =   180
         TabIndex        =   6
         Top             =   780
         Width           =   1215
      End
      Begin SSOption rtabtype
         Caption         =   "Right"
         Height          =   255
         Left            =   180
         TabIndex        =   7
         Top             =   1200
         Width           =   915
      End
      Begin SSOption dtabtype
         Caption         =   "Decimal"
         Height          =   255
         Left            =   180
         TabIndex        =   8
         Top             =   1620
         Width           =   1155
      End
   End
   Begin TextBox curpos
      Height          =   300
      Left            =   240
      TabIndex        =   1
      Text            =   "6.88888888"
      Top             =   420
      Width           =   1395
   End
   Begin SpinButton posspin
      Delay           =   150
      Height          =   300
      Left            =   1620
      TdThickness     =   1
      Top             =   420
      Width           =   255
   End
   Begin SSList tablist
      Prop47          =   MTABDLG.FRX:0000
      BorderStyle     =   1  'Fixed Single
      Case            =   0  'Unchanged
      DividerStyle    =   0  'None
      FixedHeight     =   13
      Font3D          =   0  'None
      Height          =   1995
      IntegralSize    =   0   'False
      Left            =   360
      ListStyle       =   0  '2D (BackColor used)
      MultiColumn     =   0   'False
      ReFreshOnUpdate =   -1  'True
      ScrollHorizontal=   0   'False
      ScrollVertical  =   -1  'True
      SelectionType   =   0  'Single
      ShadowColor     =   0  'Dark Grey
      Sorted          =   0   'False
      TabIndex        =   3
      Top             =   780
      Width           =   1815
      WndStyle        =   1151336785
   End
   Begin Label Label4
      BackStyle       =   0  'Transparent
      Caption         =   "&Position:"
      Height          =   195
      Left            =   240
      TabIndex        =   0
      Top             =   180
      Width           =   1335
   End
   Begin Label posscale
      BackStyle       =   0  'Transparent
      Caption         =   "mm."
      Height          =   195
      Left            =   1920
      TabIndex        =   2
      Top             =   480
      Width           =   315
   End
End
'****************************************************************************
'*                                                                          *
'*  MTABDLG.FRM                                                             *
'*                                                                          *
'*  Copyright (c) 1995-1997 Galacticomm, Inc.    All Rights Reserved.       *
'*                                                                          *
'*  Tab setup dialog.                                                       *
'*                                                                          *
'*                                                  - J. Alvrus 11/28/95    *
'*                                                                          *
'****************************************************************************

Option Explicit

Const NOTSET = "not set"
Const POSFMT = "0.0##"

Dim retstr As String
Dim mouseclick As Integer
Dim scaleunits As Integer
Dim pagew As Integer
Dim scaleval As Double
Dim spininc As Single
Dim curtype As String
Dim tabsetup(NTABS) As String

Sub cancelbtn_Click ()
    Unload Me
End Sub

Sub chkbtn ()
    setbtn.Enabled = IsNumeric(curpos) And Val(curpos) > 0 And Val(curpos) < pagew * scaleval
    clearbtn.Enabled = Not (tablist.ListIndex < 0 Or tablist.Text = NOTSET)
End Sub

Sub clallbtn_Click ()
    Dim i As Integer

    For i = 0 To NTABS - 1
        tabsetup(i) = "0"
        tablist.List(i) = NOTSET
    Next
    mouseclick = True
    If tablist.ListIndex Then
        tablist.ListIndex = 0
    Else
        tablist_Click
    End If
    mouseclick = False
    chkbtn
End Sub

Sub clearbtn_Click ()
    tabsetup(tablist.ListIndex) = "0"
    tablist.List(tablist.ListIndex) = NOTSET
    sorttabs
    txtgivef curpos
    chkbtn
End Sub

Sub ctabtype_Click (Value As Integer)
    curtype = "C"
    If tablist.Text <> NOTSET Then
        Mid$(tabsetup(tablist.ListIndex), 1) = curtype
    End If
End Sub

Sub curpos_Change ()
    chkbtn
End Sub

Sub curpos_GotFocus ()
    If Not mouseclick Then
        curpos.SelStart = 0
        curpos.SelLength = Len(curpos)
    End If
    setbtn.Default = True
End Sub

Sub curpos_LostFocus ()
    okbtn.Default = True
End Sub

Sub curpos_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    mouseclick = (Button And KEY_LBUTTON) <> 0
End Sub

Sub curpos_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
    mouseclick = False
End Sub

Sub dtabtype_Click (Value As Integer)
    curtype = "D"
    If tablist.Text <> NOTSET Then
        Mid$(tabsetup(tablist.ListIndex), 1) = curtype
    End If
End Sub

Sub Form_Load ()
    Dim i As Integer

    mouseclick = False
    retstr = ""
    modsysmnu Me, MOVCLS
    repoctr Me, Nothing
    scaleunits = Val(itemidx(formxchg, 0))
    pagew = Val(itemidx(formxchg, 1))
    posscale = scaleabbr(scaleunits)
    scaleval = scalefactor(scaleunits)
    If scaleunits = SCALE_MM Then
        spininc = 1
    Else
        spininc = .1
    End If
    For i = 0 To NTABS - 1
        tabsetup(i) = itemidx(formxchg, i + 2)
        Select Case Left$(tabsetup(i), 1)
        Case "0"
            tablist.AddItem NOTSET
        Case Else
            tablist.AddItem Format$(Val(Mid$(tabsetup(i), 2)) * scaleval, POSFMT)
        End Select
    Next
    tablist.ListIndex = 0
End Sub

Sub Form_Unload (Cancel As Integer)
    formxchg = retstr
End Sub

Sub helpbtn_Click ()
    dohelp helpbtn, HELP_CONTEXT
End Sub

Sub ltabtype_Click (Value As Integer)
    curtype = "L"
    If tablist.Text <> NOTSET Then
        Mid$(tabsetup(tablist.ListIndex), 1) = curtype
    End If
End Sub

Sub okbtn_Click ()
    Dim i As Integer

    retstr = tabsetup(0)
    For i = 1 To NTABS - 1
        retstr = retstr & tb & tabsetup(i)
    Next
    Unload Me
End Sub

Sub posspin_SpinDown ()
    If (Len(curpos) = 0 Or IsNumeric(curpos)) And Val(curpos) - spininc > 0 Then
        curpos = Format$(Val(curpos) - spininc, POSFMT)
    End If
End Sub

Sub posspin_SpinUp ()
    If (Len(curpos) = 0 Or IsNumeric(curpos)) And Val(curpos) + spininc < pagew * scaleval Then
        curpos = Format$(Val(curpos) + spininc, POSFMT)
    End If
End Sub

Sub rtabtype_Click (Value As Integer)
    curtype = "R"
    If tablist.Text <> NOTSET Then
        Mid$(tabsetup(tablist.ListIndex), 1) = curtype
    End If
End Sub

Sub setbtn_Click ()
    Dim i As Integer, twips As Integer

    twips = Val(curpos) / scaleval
    i = tablist.ListIndex
    tabsetup(i) = curtype & twips
    tablist.List(i) = Format$(Val(Mid$(tabsetup(i), 2)) * scaleval, POSFMT)
    sorttabs
    On Error Resume Next
    tablist.SetFocus
    chkbtn
End Sub

Sub sorttabs ()
    Dim lo As Integer, hi As Integer
    Dim hold As String

    winrefresh tablist.Hwnd, False
    For lo = 0 To NTABS - 2
        For hi = lo + 1 To NTABS - 1
            If tabsetup(hi) <> "0" Then
                If tabsetup(lo) = "0" Or Val(Mid$(tabsetup(lo), 2)) > Val(Mid$(tabsetup(hi), 2)) Then
                    hold = tabsetup(lo)
                    tabsetup(lo) = tabsetup(hi)
                    tabsetup(hi) = hold
                    hold = tablist.List(lo)
                    tablist.List(lo) = tablist.List(hi)
                    tablist.List(hi) = hold
                End If
            End If
        Next
    Next
    winrefresh tablist.Hwnd, True
End Sub

Sub tablist_Click ()
    If tablist.Text = NOTSET Then
        curpos = ""
    Else
        curpos = tablist.Text
        Select Case Left$(tabsetup(tablist.ListIndex), 1)
        Case "L"
            ltabtype.Value = True
        Case "C"
            ctabtype.Value = True
        Case "R"
            rtabtype.Value = True
        Case "D"
            dtabtype.Value = True
        End Select
    End If
    chkbtn
    If mouseclick Then
        txtgivef curpos
    End If
End Sub

Sub tablist_KeyPress (KeyAscii As Integer)
    If KeyAscii = Asc(" ") Then
        txtgivef curpos
    End If
End Sub

Sub tablist_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    mouseclick = (Button And KEY_LBUTTON) <> 0
End Sub

Sub tablist_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
    mouseclick = False
End Sub

