'****************************************************************************
'*                                                                          *
'*  MSGGENU.BAS                                                             *
'*                                                                          *
'*  Copyright (c) 1996-1997 Galacticomm Inc.    All Rights Reserved.        *
'*                                                                          *
'*  Generic utility functions for use by messaging-related C/S apps (must   *
'*  be used with MSGDECL.BAS).                                              *
'*                                                                          *
'*                                                   - J. Alvrus 4/29/96    *
'*                                                                          *
'****************************************************************************

Option Explicit

Function addrtyp (ByVal addr As String) As Integer
' classify an address type
' addr: address in question
' returns: address type

    If Left$(addr, 1) = "/" Then
        addrtyp = ISFORUM
    ElseIf sameto(CDLLAB, addr) Then
        addrtyp = ISPLIST
    ElseIf Left$(addr, 1) Like "[@!]" Then
        addrtyp = ISSLIST
    ElseIf cbelocal(addr) Then
        addrtyp = ISLCLAD
    Else
        addrtyp = ISNETAD
    End If
End Function

Function addstr (s As String, ByVal add As String, ByVal maxlen As Integer) As Integer
' concatenate two strings without exceeding a maximum length
' returns False if can't add due to length restriction

    addstr = False
    If Len(s) + Len(add) <= maxlen Then
        s = s & add
        addstr = True
    End If
End Function

Sub allonscr (frm As Form, ByVal minscw As Long, ByVal minsch As Long)
' resize/reposition a form so that it fits entirely on the screen
' minscw:       minimum scale width to allow
' minsch:       minimum scale height to allow

    Dim X As Integer, borderh As Integer, borderw As Integer

    If frm.Left + frm.Width > Screen.Width Then
        borderw = frm.Width - frm.ScaleWidth
        If Screen.Width - frm.Left < minscw + borderw Then
            X = Screen.Width - minscw - borderw
            If X < 0 Then
                X = 0
            End If
            frm.Left = X
        End If
        frm.Width = Screen.Width - frm.Left
    End If
    If frm.Top + frm.Height > Screen.Height Then
        borderh = frm.Height - frm.ScaleHeight
        If Screen.Height - frm.Top < minsch + borderh Then
            X = Screen.Height - minsch - borderh
            If X < 0 Then
                X = 0
            End If
            frm.Top = X
        End If
        frm.Height = Screen.Height - frm.Top
    End If
End Sub

Function appconnect () As Integer
' connect to server if not already

    appconnected = True
    appconnect = connect("default")
    appconnected = False
End Function

Sub appendccl (infostg As String, ByVal cclist As String)
' append cc list to message msgtxt
' infostg: message information string, FLDSEP separated
' cclist: list of cc's, ";" separated

    Dim numccs As Integer
    Dim msgtxt As String, endstr As String
    Dim i As Integer

    cclist = Trim$(cclist)
    If Len(cclist) Then
        numccs = itemcntd(cclist, ";")
        msgtxt = getminf(infostg, TEXTFLD)
        If isrtf(msgtxt) Then
            endstr = "\par}"
            msgtxt = Left$(msgtxt, Len(msgtxt) - 1)
            If addstr(msgtxt, nl & "\par\pard\tx720 to:\tab " & getminf(infostg, TOFLD), emlacc.txtlen - Len(endstr)) Then
                If addstr(msgtxt, nl & "\par cc:\tab " & Trim$(itemidxd(cclist, 0, ";")), emlacc.txtlen - Len(endstr)) Then
                    For i = 1 To numccs - 1
                        If Not addstr(msgtxt, nl & "\par\tab " & Trim$(itemidxd(cclist, i, ";")), emlacc.txtlen - Len(endstr)) Then
                            Exit For
                        End If
                    Next
                End If
            End If
            msgtxt = msgtxt & endstr
        Else
            Do While Right$(msgtxt, 2) <> Chr$(13) & Chr$(13)
                msgtxt = msgtxt & Chr$(13)
            Loop
            msgtxt = msgtxt & "to: " & Trim$(getminf(infostg, TOFLD)) & Chr$(13)
            msgtxt = msgtxt & "cc: " & Trim$(itemidxd(cclist, 0, ";"))
            For i = 1 To numccs - 1
                msgtxt = msgtxt & Chr$(13) & "    " & Trim$(itemidxd(cclist, i, ";"))
            Next
            If Len(msgtxt) > emlacc.txtlen Then
                msgtxt = Left$(msgtxt, emlacc.txtlen)
            End If
        End If
        infostg = itemsetd(infostg, TEXTFLD, msgtxt, FLDSEP)
    End If
End Sub

Function autdlnam (ByVal autpath As String, ByVal filename As String) As String
' form auto-download path+file name
    Dim i As Integer
    Dim idx As Integer
    Dim tmpext As String
    Dim tmps As String

    If Right$(autpath, 1) <> "\" Then
        autpath = autpath & "\"
    End If
    autpath = autpath & UCase$(Trim$(filename))
    If fexist(autpath, True) Then
        i = 0
        idx = InStr(autpath, ".")
        If idx = 0 Then
            tmpext = "000"
            autpath = autpath & "."
        Else
            tmpext = Right$(autpath, Len(autpath) - idx)
            Do While Len(tmpext) < 3
                tmpext = tmpext & "0"
            Loop
            Mid$(tmpext, 3) = "0"
            autpath = Left$(autpath, idx)
        End If
        Do While fexist(autpath & tmpext, True)
            i = i + 1
            tmps = Trim$(Str$(i))
            Mid$(tmpext, Len(tmpext) - Len(tmps) + 1) = tmps
        Loop
        autpath = autpath & tmpext
    End If
    autdlnam = autpath
End Function

Function cbelocal (ByVal addr As String) As Integer
' see if an address could be a local address
' addr: address to check
' returns: TRUE if it could be a local address, FALSE otherwise

    Dim i As Integer
    Dim ch As String

    cbelocal = True
    If Len(addr) < 3 Or Len(addr) > VBUIDSIZ Then
        cbelocal = False
    Else
        For i = 1 To Len(addr)
            ch = Mid$(addr, i, 1)
            ' NOTE: the oddball characters are for compatibility with isuidc()
            If Not (ch Like "[A-Za-z0-9--. ,_'-]") Then
                cbelocal = False
                Exit For
            End If
        Next i
    End If
End Function

Function combkey (ByVal Shift As Integer, ByVal KeyCode As Integer) As Integer
' combine keycode and shift into a single keystroke code

    combkey = Shift * 256 + KeyCode
End Function

Sub copyfont (dst As Control, src As Control)
' copy font settings from one control to another

   dst.FontName = src.FontName
   dst.FontSize = src.FontSize
   If src.FontBold Then  ' use 1 for compatibility w/TextControl
       dst.FontBold = 1
   Else
       dst.FontBold = 0
   End If
   If src.FontItalic Then
       dst.FontItalic = 1
   Else
       dst.FontItalic = 0
   End If
   If src.FontStrikethru Then
       dst.FontStrikethru = 1
   Else
       dst.FontStrikethru = 0
   End If
   If src.FontUnderline Then
       dst.FontUnderline = 1
   Else
       dst.FontUnderline = 0
   End If
End Sub

Function curapid () As String
' get current App-ID

    Dim sauinf As sauinf

    systat sauinf
    curapid = Trim$(sauinf.appid)
End Function

Function curuid () As String
' by hook or by crook, get the User-ID of the current user

    Dim tmps As String
    Dim sysinf As sauinf
    Static userid As String     ' assume this initialized to ""

    If Len(userid) Then
        curuid = userid
    Else
        tmps = sreadpkv("(c=p)su:userinfo userid")
        If Len(tmps) Then
            userid = tmps
            curuid = tmps
        Else
            systat sysinf
            curuid = Trim$(sysinf.usrid)
        End If
    End If
End Function

Function delmarr (ByVal msgid As Long, msgarr() As msgdpkshrt) As Integer
' delete specified message from array of headers
' msgid:    message ID of message to delete
' msgarr(): array of message headers to delete from
' returns index of message that was deleted or -1 if not found

    Dim i As Integer, delidx As Integer

    delidx = getmidx(msgid, msgarr())
    If delidx >= 0 Then
        For i = delidx To UBound(msgarr) - 1
            msgarr(i) = msgarr(i + 1)
        Next i
        If UBound(msgarr) = 0 Then
            Erase msgarr
        Else
            ReDim Preserve msgarr(UBound(msgarr) - 1)
        End If
    End If
    delmarr = delidx
End Function

Sub dpk2msg (dpk As msgdpk, msg As message, info As String)
' copy message from in-dynapak format to in-memory format

    msg.forum = dpk.forum
    msg.msgid = dpk.msgid
    msg.gmid.sysid = dpk.gmid.sysid
    msg.gmid.msgid = dpk.gmid.msgid
    msg.thrid = dpk.thrid
    msg.attname = dpk.attname
    msg.crdatim = dpk.crdatim
    msg.rplto.sysid = dpk.rplto.sysid
    msg.rplto.msgid = dpk.rplto.msgid
    msg.nrpl = dpk.nrpl
    msg.flags = dpk.flags
    info = dpk.info
End Sub

Function dtstr (ByVal datim As Double) As String
' generate a base 26 string representing a given VB date/time

    Dim retstr As String
    Dim tmpval As Double

    retstr = ""
    datim = Int(datim * 86400)   'convert days to seconds
    Do While datim
        tmpval = datim / 26#
        datim = Int(tmpval)
        tmpval = tmpval - datim
        retstr = Chr$(Asc("A") + CInt(tmpval * 26#)) & retstr
    Loop
    dtstr = retstr
End Function

Function facc2flg (axes As Integer) As Integer
' convert forum-style access level to E-mail-style write flags

    Dim tmpflg As Integer

    tmpflg = 0
    If axes >= WRAXES Then
        tmpflg = tmpflg Or EAWRITE
    End If
    If axes >= ULAXES Then
        tmpflg = tmpflg Or EAATTACH
    End If
    facc2flg = tmpflg
End Function

Sub fakebtndown (ctrl As Control, ByVal btn As Integer, dnpic As Control)
' handle MouseDown event for fake button

    If btn And LEFT_BUTTON Then
        ctrl.Tag = "+"
        ctrl.Picture = dnpic.Picture
    End If
End Sub

Sub fakebtnenable (ctrl As Control, ByVal enableflg As Integer, enapic As Control, dispic As Control)
' enable/disable fake button

    ctrl.Enabled = enableflg
    If enableflg Then
        ctrl.Picture = enapic.Picture
    Else
        ctrl.Picture = dispic.Picture
    End If
End Sub

Sub fakebtnmove (ctrl As Control, ByVal X As Single, ByVal y As Single, dnpic As Control, uppic As Control)
' handle MouseMove event for fake button

    If Len(ctrl.Tag) Then
        If ctrl.Tag = "+" Then  ' button depressed
            If X < 0 Or y < 0 Or X > ctrl.Width Or y > ctrl.Height Then
                ctrl.Tag = "-"
                ctrl.Picture = uppic.Picture
            End If
        Else                    ' button up
            If X >= 0 And y >= 0 And X <= ctrl.Width And y <= ctrl.Height Then
                ctrl.Tag = "+"
                ctrl.Picture = dnpic.Picture
            End If
        End If
    End If
End Sub

Sub fakebtnup (ctrl As Control, ByVal btn As Integer, uppic As Control)
' handle MouseUp event for fake button

    If btn And LEFT_BUTTON Then
        ctrl.Tag = ""
        ctrl.Picture = uppic.Picture
    End If
End Sub

Function fexist (ByVal path As String, ByVal incldir As Integer) As Integer
' does a file/path exist
' path:     path and file name to check
' incldir:  search for directories also

    Dim tmps As String

    On Error Resume Next
    If incldir Then
        tmps = Dir$(path, &H1F) 'check all types of files
    Else
        tmps = Dir$(path, &HF)  'check all types of files except directories
    End If
    If Err Then
        fexist = False
        Exit Function
    End If
    On Error GoTo 0
    fexist = Len(path) <> 0 And Len(tmps) <> 0 And sameas(tmps, fnpart(path))
End Function

Function findinlist (ByVal item As String, List As Control) As Integer
' find a string in a list box
' list box must be sorted, and only the first column is searched

    Dim lo As Integer, md As Integer, hi As Integer, comp As Integer

    If List.ListCount Then
        lo = 0
        hi = List.ListCount - 1
        Do While lo <= hi
            md = lo + Int((hi - lo) / 2)
            comp = stricmp(item, itemidx(List.List(md), 0))
            If comp < 0 Then
                If md = lo Then
                    Exit Do
                End If
                hi = md - 1
            ElseIf comp > 0 Then
                If md = hi Then
                    Exit Do
                End If
                lo = md + 1
            Else
                findinlist = md
                Exit Function
            End If
        Loop
    End If
    findinlist = -1
End Function

Function fixtabs (ByVal s As String, ByVal n As Integer) As String
' replace tabs with spaces
' s:    string to replace tabs in (lines must end with CR/LF)
' n:    number of spaces per tab
' returns:  updated string

    Dim tabcol As Integer, nlpos As Integer
    Dim tmps As String, news As String

    news = ""
    While Len(s)
        nlpos = InStr(s, nl)
        If nlpos Then
            tmps = Left$(s, nlpos - 1)
            s = Mid$(s, nlpos + 2)
        Else
            tmps = s
            s = ""
        End If
        Do
            tabcol = InStr(tmps, tb)
            If tabcol Then
                tmps = Left$(tmps, tabcol - 1) & Space$(n - ((tabcol - 1) Mod n)) & Mid$(tmps, tabcol + 1)
            End If
        Loop While tabcol
        news = news & tmps
        If nlpos Then
            news = news & nl
        End If
    Wend
    fixtabs = news
End Function

Function fmcomp (ByVal fornam1 As String, ByVal msgid1 As Long, ByVal fornam2 As String, ByVal msgid2 As Long) As Integer
' compare forum name/message ID pairs
' fornam1:  first forum name
' msgid1:   first message ID
' fornam2:  second forum name
' msgid2:   second message ID
' returns >0 if fornam1/msgid1 > fornam2/msgid2, =0 if fornam1/msgid1 = fornam2/msgid2, <0 if fornam1/msgid1 < fornam2/msgid2

    Dim comp As Integer

    comp = stricmp(fornam1, fornam2)
    If comp = 0 Then
        comp = Sgn(msgid1 - msgid2)
    End If
    fmcomp = comp
End Function

Function fndcar (ByVal carpre As String) As Integer
' find carrier info given prefix
' carpre:   carrier prefix to search for
' returns index in carp array or -1 if not found

    Dim i As Integer

    carpre = Trim$(carpre)
    If Right$(carpre, 1) = ":" Then
        carpre = Left$(carpre, Len(carpre) - 1)
    End If
    For i = 0 To numcar - 1
        If sameas(Trim$(carp(i).prefix), carpre) Then
            fndcar = i
            Exit Function
        End If
    Next
    fndcar = -1
End Function

Function forcandel (msg As msgdpkshrt) As Integer
' can user delete this forum message (header)
' msg:  message header

    forcandel = getaxes(Trim$(msg.fornam), Asc(msg.axes)) >= OPAXES Or sameas(getminf(msg.info, FROMFLD), curuid())
End Function

Function formsgid (ByVal fornam As String, ByVal msgid As Long) As String
' generate message ID string for forum message
' fornam:   forum name (need not be Trim$()'d)
' msgid:    message ID

    formsgid = Trim$(fornam) & " " & Format$(msgid, MNMFMT)
End Function

Sub FreeCursor ()
' free mouse cursor after call to ClipCursor

    nClipCursor 0&
End Sub

Sub frmgivef (frm As Form)
' set focus to a form and restore if minimized

    frm.SetFocus
    If frm.WindowState = MINIMIZED Then
        junk = sndmsg(frm.hWnd, WM_SYSCOMMAND, SC_RESTORE, 0&)
    End If
End Sub

Function frontstr (ByVal wholestr As String, ByVal maxlen As Integer) As String
'grab up to maxlen characters off the front of a string,
'break at word boundaries and add elipsis if original string
'is longer than maxlen

    Dim i As Integer, j As Integer

    If Len(wholestr) <= maxlen Then
        frontstr = wholestr
        Exit Function
    End If
    i = InStr(wholestr, " ")
    If i < maxlen And i > 0 Then
        Do
            j = i - 1
            i = InStr(i + 1, wholestr, " ")
        Loop While i < maxlen And i > 0
        wholestr = Left$(wholestr, j)
    ElseIf Len(wholestr) > maxlen Then
        wholestr = Left$(wholestr, maxlen)
    End If
    frontstr = wholestr & "..."
End Function

Function getdlgfontstr (dlgfont As dialogfont) As String
' get a dialogfont structure into FX string form

    Dim flags As Integer

    flags = 0
    If dlgfont.bold Then
        flags = flags Or FXBOLD
    End If
    If dlgfont.italic Then
        flags = flags Or FXITAL
    End If
    If dlgfont.uline Then
        flags = flags Or FXULIN
    End If
    If dlgfont.sthru Then
        flags = flags Or FXSTHR
    End If
    getdlgfontstr = Trim$(dlgfont.name) & tb & dlgfont.size & tb & dlgfont.color & tb & flags
End Function

Sub getfdpk (ByVal fornam As String, fordpk As credfor, info As String)
' get forum create/edit dynapak
' fornam:   name of forum to get
' fordpk:   buffer to put forum dynapak into
' info:     string to put forum dynapak info string into

    Dim inidpk() As credfdpk
    Dim detdpk() As viewfdpk

    If appconnect() Then
        If fornam = "" Then
            ReDim inidpk(0)
            junk = sreadpk(FINIDPK, Len(inidpk(0)), inidpk(0))
            LSet fordpk = inidpk(0)
            stpnls inidpk(0).info
            info = Trim$(inidpk(0).info)
            Erase inidpk
        Else
            ReDim detdpk(0)
            junk = sreadpk(FDETDPK & Trim$(fornam), Len(detdpk(0)), detdpk(0))
            fordpk.dfnpv = detdpk(0).dfnpv
            fordpk.dfprv = detdpk(0).dfprv
            fordpk.mxnpv = detdpk(0).mxnpv
            fordpk.msglif = detdpk(0).msglif
            fordpk.chgmsg = detdpk(0).chgmsg
            fordpk.chgrdm = detdpk(0).chgrdm
            fordpk.chgatt = detdpk(0).chgatt
            fordpk.chgadl = detdpk(0).chgadl
            fordpk.chgupk = detdpk(0).chgupk
            fordpk.chgdpk = detdpk(0).chgdpk
            fordpk.ccr = detdpk(0).ccr
            fordpk.pfnlvl = detdpk(0).pfnlvl
            fordpk.seqid = detdpk(0).seqid
            fordpk.necho = detdpk(0).necho
            stpnls detdpk(0).info
            info = Trim$(detdpk(0).info)
            Erase detdpk
        End If
    End If
End Sub

Function strrpl (ByVal s As String, ByVal olds As String, ByVal news As String) As String
' replace every occurrence of olds in s with news
' s:    string to search
' olds: substring to replace
' news: new substring to replace with
' returns updated string

    Dim i As Integer, oldlen As Integer, diflen As Integer

    oldlen = Len(olds)
    diflen = Len(news) - oldlen + 1
    i = InStr(s, olds)
    While i
        s = Left$(s, i - 1) & news & Mid$(s, i + oldlen)
        i = InStr(i + diflen, s, olds)
    Wend
    strrpl = s
End Function

Function subpfx (ByVal prefix As String, ByVal addr As String) As String
' substitute a new carrier prefix onto an address

    Dim i As Integer

    i = InStr(addr, ":")
    If i > 0 And i <= 4 Then
        addr = Mid$(addr, i + 1)
    End If
    subpfx = prefix & addr
End Function

Function suffix (ByVal dpknam As String) As String
' extract the suffix from a dynapak name

    Dim saunam As saunam

    suffix = ""
    If cnvd2s(dpknam, saunam) Then
        suffix = Trim$(saunam.suffix)
    End If
End Function

Function sysappdir (ByVal appid As String) As String
' create \wgman\<sysnum>\<appid> directory
' appid:    App-ID to use
' and return same

    Dim tmpdir As String

    tmpdir = homedir() & "\" & sysrno("") & "\" & appid
    On Error Resume Next
    MkDir tmpdir
    sysappdir = tmpdir
End Function

Function thrid2num (ByVal thrid As String) As Long
' convert thread ID in string form to long

    Dim thridval As Double

    thridval = Val(thrid)
    If thridval > MAXLONG Then
        thrid2num = CLng(Val(thrid) - THRIDCNV)
    Else
        thrid2num = CLng(thridval)
    End If
End Function

Function thrid2stg (ByVal thrid As Long) As String
    If thrid > 0 Then
        thrid2stg = Format$(thrid, THRIDFMT)
    Else
        thrid2stg = Format$(CDbl(thrid) + THRIDCNV, THRIDFMT)
    End If
End Function

Function thrmsgdpknam (ByVal fornam As String, ByVal thrid As Long, ByVal msgid As Long) As String
' create thread message dynapak name
' fornam:   forum name to use
' thrid:    thread ID to use
' msgid:    message ID to use

    thrmsgdpknam = THRMSGDPK & fornam & " " & thrid2stg(thrid) & " " & Format$(msgid, MNMFMT)
End Function

Function thrmsgmm (ByVal fornam As String, ByVal thrid As Long) As String
' create thread message minimum match
' fornam:   forum name to use
' thrid:    thread ID to use

    thrmsgmm = wtspace(THRMSGMIN & fornam & " " & thrid2stg(thrid) & " ")
End Function

Sub txtgivef (txt As Control)
' set focus to a text box and highlight its contents
' txt:  text box to give focus to

    txt.SelStart = 0
    txt.SelLength = Len(txt)
    On Error Resume Next
    txt.SetFocus
End Sub

Function u2int (u As Long) As Integer
'change unsigned integer to bit-equivalent signed integer

    If u > 32767 Then
        u = u - 65536
    End If
    u2int = u
End Function

Function uniquefn (ByVal dirstr As String, ByVal extstr As String)
' generate a unique file name
' dirstr:   directory in which file name should be unique
' extstr:   extension to give file

    Dim tmpnam As String

    If Right$(dirstr, 1) <> "\" Then
        dirstr = dirstr & "\"
    End If
    If Left$(extstr, 1) <> "." Then
        extstr = "." & extstr
    End If
    Do
        tmpnam = dtstr(Now)
        While Len(tmpnam) < 8
            tmpnam = "A" & tmpnam
        Wend
        tmpnam = tmpnam & extstr
    Loop While Dir$(dirstr & tmpnam) = tmpnam
    uniquefn = dirstr & tmpnam
End Function

Function validposval (ByVal posn As Integer) As Integer
' make sure a position value is not negative

    If posn > 0 Then
        validposval = posn
    Else
        validposval = 0
    End If
End Function

Function valslnam (ByVal slname As String) As Integer
' check for valid sysop distribution list name

    Dim i As Integer

    If Len(slname) > 9 Or Left$(slname, 1) <> "@" Then
        valslnam = False
        Exit Function
    End If
    For i = 2 To Len(slname)
        If Not Mid$(slname, i, 1) Like "[0-9A-Za-z]" Then
            valslnam = False
            Exit Function
        End If
    Next
    valslnam = True
End Function

Function wordwrap (ByVal origstr As String, ByVal linelen As Integer) As String
' wordwrap a message string
' origstr: message string to wordwrap
' linelen: length to wordwrap to
' returns: wordwrapped string

    Dim tmpstr As String

    tmpstr = RTrim$(txtlin(origstr, linelen))
    Do While Len(origstr)
        tmpstr = tmpstr & Chr$(13) & RTrim$(txtlin(origstr, linelen))
    Loop
    wordwrap = tmpstr
End Function

Function getGDI () As Long
' debugging function: get GDI heap space available

    getGDI = loword(GetHeapSpaces(GetModuleHandle("GDI")))
End Function

Function gethdrstr (hdr As message, ByVal info As String) As String
' get the header portion of a message into a printable string

    Dim hdrstr As String, tmps As String
    Dim txtlen As Single

    If hdr.forum = EMLID Then
        hdrstr = "Electronic Mail" & nl
    Else
        hdrstr = "Forum: " & Trim$(hdr.fornam) & nl
    End If
    If hdr.msgid = 0& Then
        tmps = " <none>"
    Else
        tmps = Trim$(Str$(hdr.msgid))
    End If
    hdrstr = hdrstr & "Message #" & tmps & nl
    hdrstr = hdrstr & "Date: " & Format$(hdr.crdatim, LDATEFMT) & "   " & Format$(hdr.crdatim, TIMEFMT) & nl
    hdrstr = hdrstr & "From: " & getminf(info, FROMFLD) & nl
    hdrstr = hdrstr & "To: " & getminf(info, TOFLD) & nl
    hdrstr = hdrstr & "Topic: " & getminf(info, TPCFLD) & nl
    tmps = getminf(info, HISTFLD)
    If Len(tmps) Then
        hdrstr = hdrstr & "(" & tmps & ")" & nl
    End If
    If hdr.flags And FILATT Then
        hdrstr = hdrstr & nl
        hdrstr = hdrstr & "File Attached: " & Trim$(hdr.attname) & nl
    End If
    gethdrstr = hdrstr & nl
End Function

Function getlbcaret (lst As Control) As Integer
' get caret index in list box
' lst:  list box to get for

    getlbcaret = sndmsg(lst.hWnd, LB_GETCARETINDEX, 0, 0&)
End Function

Function getlbheight (lb As Control) As Integer
' get scale height of list box

    Dim tmprect As winrect

    GetClientRect lb.hWnd, tmprect
    getlbheight = tmprect.bottom * Screen.TwipsPerPixelX
End Function

Function getlbiheight (lst As Control, ByVal idx As Integer) As Integer
' get height of a list box item
' lst:  list box control
' idx:  index of item to get height of

    getlbiheight = sndmsg(lst.hWnd, LB_GETITEMHEIGHT, idx, 0&) * Screen.TwipsPerPixelY
End Function

Sub getlbirect (lst As Control, ByVal idx As Integer, itemrect As vbrect)
' get rect for given item in given list box

    Dim tmprect As winrect

    junk = sendpmsg(lst.hWnd, LB_GETITEMRECT, idx, tmprect)
    itemrect.Left = tmprect.Left * Screen.TwipsPerPixelX
    itemrect.Top = tmprect.Top * Screen.TwipsPerPixelY
    itemrect.right = tmprect.right * Screen.TwipsPerPixelX
    itemrect.bottom = tmprect.bottom * Screen.TwipsPerPixelY
End Sub

Function getlbnvisi (lst As Control) As Integer
' get number if fully-visible items in a list box
' Note: this code assumes all items are the same height

    getlbnvisi = getlbheight(lst) \ getlbiheight(lst, 0)
End Function

Function getlbwidth (lb As Control) As Long
' get scale width of list box

    Dim tmprect As winrect

    GetClientRect lb.hWnd, tmprect
    getlbwidth = tmprect.right * Screen.TwipsPerPixelX
End Function

Function getmidx (ByVal msgid As Long, msgarr() As msgdpkshrt) As Integer
' find specified message in array of message headers
' msgid:    message ID to find
' msgarr:   array of message headers to search
' returns index of message in msgarr() or -1 if not found

    Dim i As Integer
    Dim comp As Long

    getmidx = -1
    i = nearmidx(comp, msgid, msgarr())
    If i >= 0 And comp = 0 Then
        getmidx = i
    End If
End Function

Function getminf (ByVal infostg As String, ByVal fldnum As Integer) As String
' get specified field from message dynapak info field
    Dim s As String

    s = itemidxd(infostg, fldnum, FLDSEP)
    getminf = RTrim$(s)
End Function

Function getpfx (ByVal addr As String) As String
' get exporter prefix from address string
' returns prefix (without ":") or "" if none

    If InStr(addr, ":") Then
        getpfx = itemidxd(addr, 0, ":")
    Else
        getpfx = ""
    End If
End Function

Function gettidx (ByVal thrid As Long, thrarr() As thrinfarrstruct) As Integer
' find specified thread in array of thread info
' thrid:    thread ID to find
' thrarr:   array of thread info structures to search
' returns index or -1 if not found

    Dim i As Integer
    Dim comp As Integer

    gettidx = -1
    i = neartidx(comp, thrid, thrarr())
    If i >= 0 And comp = 0 Then
        gettidx = i
    End If
End Function

Function gettlstidx (ByVal thrid As Long, thrarr() As thrinfarrstruct) As Integer
' get index of thread in list of threads
' thrid:    thread ID to find
' thrarr:   thread info array

    Dim arridx As Integer, lstidx As Integer

    gettlstidx = -1
    arridx = gettidx(thrid, thrarr())
    If arridx >= 0 Then
        gettlstidx = thrarr(arridx).lstidx
    End If
End Function

Function hiword (ByVal l As Long) As Long
    Dim temp As Long

    temp = l \ &H10000
    If temp < 0 Then
        temp = temp + &H10000
    End If
    hiword = temp
End Function

Function infaxes (forinf As foruminf) As Integer
' get access portion of forinf.axes field

    infaxes = (Asc(forinf.axes) And FAXSMASK)
End Function

Function inrect (ByVal X As Integer, ByVal y As Integer, rect As vbrect) As Integer
' are specified coordinates within rectangle specified by rect

    inrect = X >= rect.Left And X <= rect.right And y >= rect.Top And y <= rect.bottom
End Function

Function isfornamchr (ByVal c As String) As Integer
' is this a valid forum name character

    isfornamchr = (Asc(c) > Asc(" ") And Not c Like "[ /@;]")
End Function

Function iskeynamchr (ByVal c As String) As Integer
' is this a valid key name character

    iskeynamchr = (c Like "[#=?_0-9A-Za-z--]")
End Function

Function isquoted (ByVal aline As String) As Integer
' determine if a line in a message is quoted
' aline: line to check
' returns: TRUE if line is quoted, FALSE otherwise

    Const alphnm = "[A-Za-z0-9]"
    Dim tstchr As String

    tstchr = Left$(aline, 1)
    If tstchr Like alphnm Then
        tstchr = Mid$(aline, 2, 1)
        If tstchr Like alphnm Then
            tstchr = Mid$(aline, 3, 1)
        End If
    End If
    isquoted = tstchr = "[" Or tstchr = "]" Or tstchr Like "[<>{}|:]"
End Function

Function isrtf (ByVal Text As String) As Integer
' is the given string RTF?

    isrtf = sameto(RTFIDSTR, Text)
End Function

Function itempos (ByVal item As String, ByVal Index As Integer) As Integer
' returns the position of the first character of a substring within a passed tab-delimited string
'   returns zero if Index >= itemcntd(Item,delim)
' item: delimited string
' index: 0-based substring number
' delim: string (character) used to delimit string

    itempos = itemposd(item, Index, Chr$(KEY_TAB))
End Function

Function itemposd (ByVal item As String, ByVal Index As Integer, ByVal delim As String) As Integer
' generalized form of itempos -
'   returns the position of the first character of a substring within a passed delimited string
'   returns zero if Index >= itemcntd(Item,delim)
' item: delimited string
' index: 0-based substring number
' delim: string (character) used to delimit string

    Dim i As Integer                ' util. Integer
    Dim ld As Integer               ' length of delim

    i = 1
    ld = Len(delim)
    Do While Index > 0
        i = InStr(i, item, delim)
        If i = 0 Then
            Exit Do
        End If
        i = i + ld
        Index = Index - 1
    Loop
    itemposd = i
End Function

Function loword (ByVal l As Long) As Long
    Dim temp As Long

    temp = l Mod &H10000
    If temp < 0 Then
        temp = temp + &H10000
    End If
    loword = temp
End Function

Function lp2hlstr (ByVal srclpstr As Long) As String
' take an lpstr returned from an API call and return a VB string (hlstr)

    Dim tmplen As Long
    Dim tmpstr As String

    tmplen = lpstrlen(srclpstr)
    tmpstr = Space$(tmplen + 1)
    junk = lstrcpy(tmpstr, srclpstr)
    lp2hlstr = Left$(tmpstr, tmplen)
End Function

Function lpstrlen (ByVal lpstr As Long) As Long
' get the length of an lpstr (excluding the trailing nul)

    Dim tmplen As Long

    tmplen = lstrlen(lpstr)
    If tmplen < 0 Then
        tmplen = tmplen + 65536
    End If
    lpstrlen = tmplen
End Function

Function nearmidx (comp As Long, ByVal msgid As Long, msgarr() As msgdpkshrt) As Integer
' find index of message nearest to specified message ID in array of headers
' comp:     result of last comparison
' msgid:    message ID being searched for
' msgarr:   array of message headers (must be sorted in message ID order)
' returns index in msgarr() array

    Dim lo As Integer, md As Integer, hi As Integer

    md = -1
    lo = 0
    On Error GoTo mnotdimmed
    hi = UBound(msgarr)
    Do While lo <= hi
        md = lo + Int((hi - lo) / 2)
        comp = msgid - msgarr(md).msgid
        If comp < 0 Then
            hi = md - 1
        ElseIf comp > 0 Then
            lo = md + 1
        Else
            Exit Do
        End If
    Loop
mnotdimmed:
    nearmidx = md
    Exit Function
End Function

Function neartidx (comp As Integer, ByVal thrid As Long, thrarr() As thrinfarrstruct) As Integer
' find index of message nearest to specified message ID in array of headers
' comp:     result of last comparison
' msgid:    message ID being searched for
' msgarr:   array of message headers (must be sorted in message ID order)
' returns index in msgarr() array

    Dim lo As Integer, md As Integer, hi As Integer
    Dim seekthrid As Double, curthrid As Double

    seekthrid = thrid
    If thrid < 0 Then
        seekthrid = seekthrid + THRIDCNV
    End If
    md = -1
    lo = 0
    On Error GoTo tnotdimmed
    hi = UBound(thrarr)
    Do While lo <= hi
        md = lo + Int((hi - lo) / 2)
        curthrid = thrarr(md).thrid
        If curthrid < 0 Then
            curthrid = curthrid + THRIDCNV
        End If
        comp = Sgn(seekthrid - curthrid)
        If comp < 0 Then
            hi = md - 1
        ElseIf comp > 0 Then
            lo = md + 1
        Else
            Exit Do
        End If
    Loop
tnotdimmed:
    neartidx = md
    Exit Function
End Function

Function ninmarr (msgarr() As msgdpkshrt) As Integer
' get number of messages in an array of headers

    ninmarr = 0
    On Error GoTo nomsgs
    ninmarr = UBound(msgarr) + 1
nomsgs:
    Exit Function
End Function

Function nintarr (arr() As thrinfarrstruct) As Integer
' get number of items in an thread info array

    nintarr = 0
    On Error GoTo nothrs
    nintarr = UBound(arr) + 1
nothrs:
    Exit Function
End Function

Sub nuketabs (lst As Control)
' clear all tabs from a list box
' Note:  Assumes list has 16 tab positions

    Dim i As Integer

    For i = 0 To 15
        lst.TabPos(i) = 0
    Next
End Sub

Function prefix (ByVal dpknam As String) As String
' extract the prefix (including trailing ":") from dynapak name

    prefix = Left$(dpknam, Len(dpknam) - Len(suffix(dpknam)))
End Function

Sub printstr (ByVal prtstr As String, ByVal margin As Integer)
' print a string with CR/LF line terminators
' prtstr:   string to print
' margin:   left/right margin to use

    Dim pmargin As Integer
    Dim txtlen As Single
    Dim tmps As String

    txtlen = Printer.Width - margin * 2
    pmargin = margin - (Printer.Width - Printer.ScaleWidth) / 2
    Do While Len(prtstr)
        Printer.CurrentX = pmargin
        tmps = prnlin(prtstr, txtlen)
        Printer.Print tmps
    Loop
End Sub

Sub printtxt (ByVal hdrstr As String, ByVal txtstr As String, ByVal ncpy As Integer)
' print plain text message
' hdrstr:   header string
' txtstr:   body string
' ncpy:     number of copies to print

    Dim i As Integer, topmargin As Integer
    Dim margin As Single, txtlen As Single
    Dim tmps As String

    If prnwider(txtstr, Printer.ScaleWidth) Then
        txtlen = Printer.Width - DFTPMRG * 2
        margin = DFTPMRG
    Else
        txtlen = Printer.TextWidth(txtstr)
        margin = (Printer.Width - txtlen) / 2
        If margin > DFTPMRG Then
            margin = DFTPMRG
        End If
    End If
    topmargin = DFTPMRG - (Printer.Height - Printer.ScaleHeight) / 2
    For i = 1 To ncpy
        If i > 1 Then
            Printer.NewPage
        End If
        Printer.CurrentY = topmargin
        printstr hdrstr, margin
        printstr txtstr, margin
    Next
    Printer.EndDoc
End Sub

Function prnlin (s As String, ByVal w As Integer) As String
' get a line of text to print from a CR/LF-separated buffer, up to a maximum width
' s:    source string (modified)
' w:    maximum allowed line width in twips
' returns line to print

    Dim i As Integer, linlen As Integer, eolflg As Integer
    Dim linstr As String, tmps As String
    Dim tm As textmetric

    i = InStr(s, nl)
    If i Then
        linstr = Left$(s, i - 1)
    Else
        linstr = s
    End If
    eolflg = (i <> 0)
    junk = GetTextMetrics(Printer.hDC, tm)
    linlen = w / (tm.tmAveCharWidth * Printer.TwipsPerPixelX)
    If Len(linstr) > linlen + 1 Then
        tmps = Left$(linstr, linlen + 1)
        If Printer.TextWidth(tmps) <= w Then
            Do While Len(tmps) < Len(linstr) And Printer.TextWidth(tmps) <= w
                tmps = Left$(linstr, Len(tmps) + 1)
            Loop
        End If
        eolflg = eolflg And (Len(tmps) = Len(linstr))
        linstr = tmps
    End If
    Do While Len(linstr) > 1
        tmps = Left$(linstr, Len(linstr) - 1)
        If Printer.TextWidth(tmps) > w Then
            eolflg = False
            linstr = tmps
        Else
            Exit Do
        End If
    Loop
    If Printer.TextWidth(linstr) <= w Then
        If eolflg Then
            s = Mid$(s, Len(linstr) + 3)
        Else
            s = ""      ' it's the last line w/ no trailing CR/LF
        End If
        prnlin = RTrim$(linstr)
        Exit Function
    End If
    For i = Len(linstr) To 1 Step -1
        If Mid$(linstr, i, 1) = " " Then
            s = Mid$(s, i + 1)
            prnlin = RTrim$(Left$(linstr, i - 1))
            Exit Function
        End If
    Next
    s = Mid$(s, Len(linstr) + 1)
    prnlin = linstr
End Function

Function prnwider (ByVal s As String, ByVal w As Integer) As Integer
' is the printer width of the given string wider than the given width
' s:    string to check
' w:    width to compare

    Dim i As Integer
    Dim linstr As String, tmps As String
    Dim tm As textmetric

    Do While Len(s)
        i = InStr(s, nl)
        If i Then
            linstr = Left$(s, i - 1)
            s = Mid$(s, i + 2)
        Else
            linstr = s
            s = ""
        End If
        junk = GetTextMetrics(Printer.hDC, tm)
        i = w / (tm.tmAveCharWidth * Printer.TwipsPerPixelX)
        If Len(linstr) > i + 1 Then
            tmps = Left$(linstr, i + 1)
            If Printer.TextWidth(tmps) > w Then
                prnwider = True
                Exit Function
            End If
            Do While Len(tmps) < Len(linstr)
                tmps = Left$(linstr, Len(tmps) + 1)
                If Printer.TextWidth(tmps) > w Then
                    prnwider = True
                    Exit Function
                End If
            Loop
        End If
        If Printer.TextWidth(linstr) > w Then
            prnwider = True
            Exit Function
        End If
    Loop
    prnwider = False
End Function

Sub protdoevt ()
' protected DoEvents:  prevent user input

    Dim i As Integer

    For i = 0 To Forms.Count - 1
        Forms(i).Enabled = False
    Next
    DoEvents
    For i = 0 To Forms.Count - 1
        Forms(i).Enabled = True
    Next
End Sub

Function qtelin (msgtxt As String, ByVal linelen As Integer, ByVal qlinelen As Integer)
' return a line of text from message text
' msgtxt: message text to extract line from -
'         stripped of returned text by qtelin()
' linelen: max length of line if msgtxt not quoted
' qlinelen: max length of line if msgtxt quoted

    If isquoted(msgtxt) Then
        qtelin = txtlin(msgtxt, qlinelen)
    Else
        qtelin = txtlin(msgtxt, linelen)
    End If
End Function

Function quotemsg (ByVal from As String, ByVal Text As String) As String
    Dim inits As String, qtelin As String, qtemsg As String
    Dim i As Integer

    inits = quotestr(from)
    Text = cvt4dsp(Text, False)     'don't bother with quoting, we'll handle it below
    qtemsg = ""
    Do While Text <> ""
        i = InStr(Text, nl)
        If i > 0 Then
            qtelin = Left$(Text, i + 1)
        Else
            qtelin = Text
        End If
        Text = Right$(Text, Len(Text) - Len(qtelin))
        If qtelin = nl Then
            qtemsg = qtemsg & nl
        Else
            i = InStr(qtelin, nl)
            If i > 0 Then
                qtelin = Left$(qtelin, i - 1)
            End If
            qtelin = inits & qtelin
            If Len(qtelin) > QTELMT Then
                qtelin = Left$(qtelin, QTELMT)
            End If
            qtemsg = qtemsg & qtelin & nl
        End If
    Loop
    quotemsg = qtemsg
End Function

Function quotestr (ByVal from As String) As String
' generate string used for quoting

    Dim i As Integer

    i = InStr(from, ":")
    If ((i = 3) Or (i = 4)) And (Len(from) > i) Then
        from = Mid$(from, i + 1)
    End If
    i = itemcntd(from, " ")
    If i = 1 Then
        quotestr = UCase$(Left$(from, 2)) & ">"
    Else
        quotestr = UCase$(Left$(from, 1) & Left$(itemidxd(from, i - 1, " "), 1)) & ">"
    End If
End Function

Function qwordwrap (ByVal origstr As String, ByVal linelen As Integer, ByVal qlinelen As Integer) As String
' quoted-line-sensitive wordwrap of a message string
' origstr: message string to wordwrap
' linelen: length to wrap non-quoted lines to
' qlinelen: length to truncate quoted lines at
' returns: wordwrapped string

    Dim txtfmt As String

    txtfmt = qtelin(origstr, linelen, qlinelen)
    Do While origstr <> ""
        txtfmt = txtfmt & Chr$(13) & qtelin(origstr, linelen, qlinelen)
    Loop
    qwordwrap = txtfmt
End Function

Function readfile (ByVal filename As String, ByVal maxlen As Long) As String
' read a text file and return its contents
' filename: path and file name of file
' maxlen:   limit length of returned string (0 for no limit)

    Dim tmps As String, inl As String
    Dim f As Integer, ok As Integer

    readfile = ""
    If (maxlen = 0 And FileLen(filename) > 65535) Or (maxlen <> 0 And FileLen(filename) > maxlen) Then
        Screen.MousePointer = DEFAULT
        poperror "File too long", ""
        Exit Function
    End If
    ok = False
    On Error GoTo readerr
    f = FreeFile
    Open filename For Input Access Read As f
    Line Input #f, tmps
    While Not EOF(f)
        Line Input #f, inl
        tmps = tmps & nl & inl
    Wend
    ok = True
readerr:
    Close f
    If ok Then
        readfile = tmps
    Else
        Screen.MousePointer = DEFAULT
        poperror "Error reading file: " & Error$, ""
    End If
    Exit Function
End Function

Sub refreshall (frm As Form)
' refresh a form and all controls on it

    Dim i As Integer

    frm.Refresh
    For i = 0 To frm.Controls.Count - 1
        If TypeOf frm.Controls(i) Is Menu Then
            ' do nothing
        Else
            If frm.Controls(i).Visible Then
                On Error Resume Next
                frm.Controls(i).Refresh
            End If
        End If
    Next
End Sub

Sub remlbitem (lst As Control, ByVal idx As Integer)
' remove an item from a list box, without losing highlight
' lst:  list box to remove from
' idx:  index of item to remove

    Dim savidx As Integer

    savidx = lst.ListIndex
    lst.RemoveItem idx
    If savidx >= lst.ListCount Then
        savidx = lst.ListCount - 1
    End If
    lst.ListIndex = savidx
End Sub

Function scr640 () As Integer
' is this a 640x480 screen?

    scr640 = Screen.Width / Screen.TwipsPerPixelX <= 640    ' 640 x 480 screen
End Function

Sub setdlgfont (c As Control, dlgfont As dialogfont)
' set a control's font settings from a dialogfont structure
' (color is not set)
' NOTE: Bold, Italic, etc. set to 1 for compatibility w/TextControl

    On Error Resume Next
    c.FontName = Trim$(dlgfont.name)
    c.FontSize = dlgfont.size
    If dlgfont.bold Then
        c.FontBold = 1
    Else
        c.FontBold = 0
    End If
    If dlgfont.italic Then
        c.FontItalic = 1
    Else
        c.FontItalic = 0
    End If
    If dlgfont.uline Then
        c.FontUnderline = 1
    Else
        c.FontUnderline = 0
    End If
    If dlgfont.sthru Then
        c.FontStrikethru = 1
    Else
        c.FontStrikethru = 0
    End If
End Sub

Sub setdlgfontstr (dlgfont As dialogfont, ByVal s As String)
' fill in a dlgfont structure from a FX string

    Dim flags As Integer

    dlgfont.name = itemidx(s, 0)
    dlgfont.size = Val(itemidx(s, 1))
    dlgfont.color = Val(itemidx(s, 2))
    flags = Val(itemidx(s, 3))
    dlgfont.bold = (flags And FXBOLD) <> 0
    dlgfont.italic = (flags And FXITAL) <> 0
    dlgfont.uline = (flags And FXULIN) <> 0
    dlgfont.sthru = (flags And FXSTHR) <> 0
End Sub

Sub setflg (ByVal flgval As Integer, flgarr As Integer, ByVal flgmask As Integer)
' set/clear a flag in an array of bit flags
' flgval:   True if flag should be set
' flgarr:   array of bit flags to set/clear in
' flgmask:  bit mask of flag to set/clear

    If flgval Then
        flgarr = flgarr Or flgmask
    Else
        flgarr = flgarr And Not flgmask
    End If
End Sub

Sub setfontstr (c As Control, ByVal s As String)
' set a control's font settings from a FX string
' (color is not set)

    Dim flags As Integer

    On Error Resume Next
    c.FontName = Trim$(itemidx(s, 0))
    c.FontSize = Val(itemidx(s, 1))
    flags = Val(itemidx(s, 3))
    If flags And FXBOLD Then
        c.FontBold = 1
    Else
        c.FontBold = 0
    End If
    If flags And FXITAL Then
        c.FontItalic = 1
    Else
        c.FontItalic = 0
    End If
    If flags And FXULIN Then
        c.FontUnderline = 1
    Else
        c.FontUnderline = 0
    End If
    If flags And FXSTHR Then
        c.FontStrikethru = 1
    Else
        c.FontStrikethru = 0
    End If
End Sub

Sub setlbcaret (lst As Control, ByVal idx As Integer)
' set list box caret index
' lst:  list box control to set in
' idx:  value to set to

    junk = sndmsg(lst.hWnd, LB_SETCARETINDEX, idx, 0&)
End Sub

Function setminf (ByVal infostg As String, ByVal newval As String, ByVal fldnum As Integer) As String
' get specified field from message dynapak info field
    Dim s As String

    s = itemsetd(infostg, fldnum, newval, FLDSEP)
    setminf = s
End Function

Function setreadonly (tbox As Control) As Long
' make a text box read-only and mark it thus so others can tell

    tbox.Tag = "readonly"
    setreadonly = sndmsg(tbox.hWnd, EM_SETREADONLY, 1, 0&)
End Function

