'****************************************************************************
'*                                                                          *
'*  MSGDECL.BAS                                                             *
'*                                                                          *
'*  Copyright (c) 1995-1997 Galacticomm, Inc.    All Rights Reserved.       *
'*                                                                          *
'*  Global variables and constants used by C/S mail app.                    *
'*                                                                          *
'*                                                  - J. Alvrus 11/28/95    *
'*                                                                          *
'****************************************************************************

Option Explicit

Global Const EMLAPID = "GALEML"     ' E-mail app ID
Global Const FORAPID = "GALFOR"     ' Forums app ID
Global Const MSGAPID = "GALMSG"     ' Combined app ID

Global Const MAXADR = 255           ' max address field length
Global Const TPCSIZ = 50            ' max topic field length
Global Const HSTSIZ = 56            ' max history field length
Global Const FLNSIZ = 12            ' max attachment name field length
Global Const INFSIZ = 16318         ' max info field length for msgs to user
Global Const SHRTINFSIZ = 619       ' max info field len, msgs to user, w/out msg body
Global Const NINFSIZ = 16350        ' max info field length for new msgs
Global Const EMLID = 0              ' forum id for email messages
Global Const MXLLEN = 72            ' max line len when formatted for wrt
Global Const QTELMT = 79            ' max len for quoted line when fmt 4 wrt
Global Const MAXDIR = 64            ' max directory name length
Global Const FORNSZ = 15            ' forum name size
Global Const MAXBTVP = 56           ' max length of data file path specs for BTrieve
Global Const ALLINF = "** ALL **"   ' "all" in forum
Global Const CDLLAB = "LIST:"       ' client-side distribution list prefix
Global Const FVINFSZ = 16330        ' max len of Type viewfor/viewfdpk info stg
Global Const FCEINFSZ = 16354       ' max len of Type credfor info stg
Global Const PFXSIZ = 3             ' carrier prefix size
Global Const EXPNSZ = 15            ' carrier name size
Global Const MXCINF = 16384 - 20    ' (MAXDPKV - 20) information max size
Global Const MAXKWDS = 80           ' max length of scan kwd string
Global Const MAXSCF = 2399          ' max index of forums in scan
Global Const ROOTGRPID = 0          ' root group ID
Global Const ROOTGRPSTR = "(root group)" ' root group name in list
Global Const maxgrpfor = 1000       ' maximum forums allowed in a group
Global Const GRPINFSZ = 82          ' group info string size (FORNSZ + 1 + KEYSIZ + 1 + TPCSIZ)
Global Const FOLDRSZ = 28           ' max folder name length (SFXSIZ - Len(FCFLDMIN))
Global Const MAXLIST = 500          ' maximum number of messages that can be displayed in list
Global Const RDMINSCW = 4500        ' minimum read form scale width for allonscr
Global Const WTMINSCW = 9615        ' minimum write form scale width for allonscr
Global Const RTFIDSTR = "{\rtf"     ' all RTF begins with this
Global Const MSGPGW = 9360          ' message page width (for RTF editor)
Global Const MSGPGH = 32767         ' message page height (for RTF editor)
Global Const DFTPMRG = 720          ' default printer margin in twips (1/2 inch)
Global Const SBWIDTH = 255          ' text box vertical scroll bar width in twips
Global Const SPERTAB = 8            ' spaces per tab for reading plain-text msgs
Global Const MNMFMT = "0000000000"  ' format for msgid's in dpk names
Global Const THRIDCNV = 4294967296# ' used to convert unsigned thrids to signed
Global Const THRIDFMT = "0000000000" ' format for thrid's in dpk names
Global Const LEXFILE = "galdict.vtd" ' dictionary file name

' dynapak names
Global Const EACCDPK = "(c=p)sa=GALEML;u:emlacc" ' E-mail access info dpk name
Global Const FORACC = "(c=p)sa=GALFOR;u:foracc" ' Forums access info dpk name
Global Const CARDPK = "(c=p)sa=GALEML;u:cdetail " ' carrier detail dpk name
Global Const CARMIN = "cdetail "    ' carrier detail dpk min match
Global Const SYSCARDPK = "(c=p)sa=GALEML;:syscar " ' sysop carrier detail dpk name
Global Const SYSCARMIN = "syscar "  ' sysop carrier detail dpk min match
Global Const PREFDPK = "sa=GALMSG;ul:prefs" ' preferences dynapak name
Global Const CKPRFDPK = "sa=GALMSG;ul:checkpref" ' check for new mail periodically preferences dpk name
Global Const FLSTMODEDPK = "saul:forlistmode" ' forum list mode preferences dpk name
Global Const ELEXDPK = "(o=u)sa=GALEML;f:lex " ' read-speller-files-from-server dpk name (E-mail)
Global Const FLEXDPK = "(o=u)sa=GALFOR;f:lex " ' read-speller-files-from-server dpk name (Forums)
Global Const LMSGDPK = "sa=GALEML;ul:eml " ' local message dynapak name
Global Const LMSGMIN = "eml "       ' local msg dynapak minimum match
Global Const RDEMLDPK = "sa=GALEML;u:rdeml " ' read E-mail dynapak name
Global Const RDEMLMIN = "rdeml "    ' read E-mail dynapak minimum match
Global Const POMSGDPK = "sa=GALEML;u:emlmsg " ' read E-mail message dynapak name
Global Const POMSGMIN = "emlmsg "   ' read E-mail message minimum match
Global Const POHDRDPK = "sa=GALEML;u:emlhdr " ' read E-mail header dynapak name
Global Const POHDRMIN = "emlhdr "   ' read E-mail header minimum match
Global Const SAFWDPK = "sa=GALEML;u:safwdee" ' server auto-forwardee dpk name
Global Const SLSTDPK = "sa=GALEML;u:slfmty" ' server list forum messages to you dpk name
Global Const SCLRDPK = "sa=GALEML;u:sclarpl" ' server clear after reply dpk name
Global Const GRPFILDPK = "sa=GALFOR;uf:grpfil" ' group info file dpk name
Global Const FORFILDPK = "sa=GALFOR;uf:forfil" ' forum info file dpk name
Global Const GRPFILLDPK = "sa=GALFOR;ul:grpfil" ' local group info file name dpk name
Global Const FORFILLDPK = "sa=GALFOR;ul:forfil" ' local forum info file name dpk name
Global Const GRPFILSDPK = "sa=GALFOR;f:grpfilsys" ' sysop group info file dpk name
Global Const FORFILSDPK = "sa=GALFOR;f:forfilsys" ' sysop forum info file dpk name
Global Const FORNOTDPK = "sa=GALFOR;u:forntfy " ' set/clear forum change notification dpk name
Global Const NFNOTDPK = "newfornot " ' new forum notify unsolicited dpk suffix
Global Const MFNOTDPK = "modfornot " ' forum modified ntfy unsolicited dpk suffix
Global Const DFNOTDPK = "delfornot " ' forum deleted notify unsolicited dpk suffix
Global Const CRTGRPDPK = "sa=GALFOR;:crtgrp" ' create group dynapak name
Global Const GRPINFDPK = "sa=GALFOR;:grpinf " ' group info dynapak name
Global Const MODGRPDPK = "sa=GALFOR;:modgrp " ' modify group header dynapak name
Global Const MODGRPFDPK = "sa=GALFOR;:modgrpf " ' modify forums in a group dpk name
Global Const FINFODPK = "(c=p)sa=GALFOR;u:forum " ' forum info dpk name
Global Const FINFOSFX = "forum "    ' forum info dpk min match
Global Const FDETDPK = "sa=GALFOR;:fordet " ' forum details dpk name
Global Const FINIDPK = "sa=GALFOR;u:inifor" ' initialize forum (when creating)
Global Const CRTFORDPK = "sa=GALFOR;:crtfor" ' create forum dynapak name
Global Const MODFORDPK = "sa=GALFOR;:modfor " ' modify/delete forum dynapak name
Global Const CFGACCDPK = "sa=GALFOR;:cfgacc " ' Forum-Op configure access dynapak
Global Const THREADDPK = "sa=GALFOR;:thread " ' thread info dpk name
Global Const THREADMIN = "thread "  ' thread info min match
Global Const FORMSGDPK = "sa=GALFOR;u:formsg " ' forum message dpk name
Global Const FORMSGMIN = "formsg "  ' forum message min match
Global Const FORHDRDPK = "sa=GALFOR;u:forhdr " ' forum message header dpk name
Global Const FORHDRMIN = "forhdr "  ' forum message header min match
Global Const THRMSGDPK = "sa=GALFOR;u:m " ' message in thread dpk name
Global Const THRMSGMIN = "m "       ' message in thread min match
Global Const THRHDRDPK = "sa=GALFOR;u:h " ' message header in thread dpk name
Global Const THRHDRMIN = "h "       ' message header in thread min match
Global Const THREXCDPK = "sa=GALFOR;u:e " ' message excerpt in thread dpk name
Global Const THREXCMIN = "e "       ' message excerpt in thread min match
Global Const PARMSGDPK = "sa=GALFOR;u:parmsg " ' parent message dpk name
Global Const PARHDRDPK = "sa=GALFOR;u:parhdr " ' parent message header dpk name
Global Const FORMODDPK = "sa=GALFOR;:modmsg " ' modify/delete forum message dpk name
Global Const APVMSGDPK = "sa=GALFOR;:msgapv " ' approve/unapprove attachment dpk name
Global Const XMTMSGDPK = "sa=GALFOR;:msgxmt " ' exempt/unexempt message dpk name
Global Const DFTSCNDPK = "sa=GALFOR;ul:scndft" ' user's default scan settings
Global Const INISCNDPK = "sa=GALFOR;u:iniscn" ' initialize scan dpk name
Global Const CLSSCNDPK = "sa=GALFOR;u:clsscn" ' close scan dpk name
Global Const SCNMSGDPK = "sa=GALFOR;u:scnmsg " ' scan message dpk name
Global Const SCNMSGMIN = "scnmsg "  ' scan message min match
Global Const SCNHDRDPK = "sa=GALFOR;u:scnhdr " ' scan message header dpk name
Global Const SCNHDRMIN = "scnhdr "  ' scan message header min match
Global Const UNAMSGDPK = "sa=GALFOR;u:unamsg " ' unapproved message dpk name
Global Const UNAMSGMIN = "unamsg "  ' unapproved message min match
Global Const UNAHDRDPK = "sa=GALFOR;u:unahdr " ' unapproved message header dpk name
Global Const UNAHDRMIN = "unahdr "  ' unapproved message header min match
Global Const EMLATTDPK = "sa=GALEML;uf:emlatt " ' e-mail attachment dpk name
Global Const FORATTDPK = "sa=GALFOR;f:foratt " ' forum attachment dpk name
Global Const IBXNOTDPK = "sa=GALMSG;ul:msgnot " ' inbox message notes
Global Const FCBNOTDPK = "sa=GAL_FCB;ul:msgnot " ' filecabinet message notes
Global Const APPINFDPK = "sa=GALEML;u:appinf " ' get app-defined info dpk name
Global Const ALIASDPK = "(c=p)sa=GALALIAS;u:alias" ' get/set internet alias

' main form toolbar button indices
Global Const MTB_GETNEW = 1         ' check for/get new mail
Global Const MTB_DELETE = 2         ' delete message(s)
Global Const MTB_FILEIT = 3         ' file message(s)
Global Const MTB_WRTEML = 4         ' write E-mail message
Global Const MTB_PSTFOR = 5         ' post in forum
Global Const MTB_INBOX = 6          ' list In Box
Global Const MTB_POSTOFC = 7        ' list Post Office
Global Const MTB_FORUM = 8          ' list online Forum
Global Const MTB_OFLFOR = 9         ' list Offline Forum
Global Const MTB_SCAN = 10          ' list messages in Scan
Global Const MTB_FOLDER = 11        ' list Folder
Global Const MTB_JFIRST = 12        ' jump to first message
Global Const MTB_JSPEC = 13         ' jump to specific message
Global Const MTB_JLAST = 14         ' jump to last message
Global Const MTB_ADRBOOK = 15       ' view Address Book
Global Const MTB_DISLST = 16        ' view Distribution List
Global Const MTB_OUTBOX = 17        ' view Out Box
Global Const MTB_LSTMSG = 18        ' list messages in forum
Global Const MTB_LSTTHR = 19        ' list threads in forum
Global Const MTB_NEWMAIL = 20       ' there is new mail

Global Const MTBGRPS = "1,|,2,3,|,4,5,|,6,7,|,8,9,10,|,11,|,12,13,14,|,15,16,17,|,18,19,|,20"
Global Const MTBDFTS = "1,2,3,4,5,6,7,8,9,10,11,12,14,15,17,18,19,20"
Global Const MTBALL = "1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20"
Global Const MTBMIN = "1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17"

' miscellaneous Windows API constants
Global Const WM_USER = &H400        ' base value for non-system Windows messages
Global Const LB_GETITEMRECT = WM_USER + 25 ' get dimensions of list box item
Global Const LB_SETCARETINDEX = WM_USER + 31 ' set caret (focus rectangle) index
Global Const LB_GETCARETINDEX = WM_USER + 32 ' get caret (focus rectangle) index
Global Const LB_GETITEMHEIGHT = WM_USER + 34 ' get height of list box item
Global Const WM_SYSCOMMAND = &H112  ' issue system menu command
Global Const SC_RESTORE = &HF120    ' system command: restore
Global Const RDW_FRAME = &H400      ' RedrawWindow command to update non-client area
Global Const RDW_INVALIDATE = 1     ' RedrawWindow command to invalidate region

' GetWindow commands
Global Const GW_HWNDFIRST = 0       ' get first sibling
Global Const GW_HWNDLAST = 1        ' get last sibling
Global Const GW_HWNDNEXT = 2        ' get next sibling
Global Const GW_HWNDPREV = 3        ' get previous sibling
Global Const GW_OWNER = 4           ' get parent window
Global Const GW_CHILD = 5           ' get first child window

' GetSystemMetrics commands
Global Const SM_CXVSCROLL = 2       ' width of vertical scroll bar
Global Const SM_CYHSCROLL = 3       ' height of horizontal scroll bar
Global Const SM_CYCAPTION = 4       ' title bar height
Global Const SM_CYBORDER = 6        ' non-sizeable border height
Global Const SM_CYFRAME = 33        ' sizeable border height

' Window menu constants
Global Const WINTILEVERT = 0        ' tile windows vertically
Global Const WINTILEHORZ = 1        ' tile windows horizontally
Global Const OTHRACTIVE = 0         ' active windows is not read or write
Global Const READACTIVE = 1         ' active window is read form
Global Const WRITACTIVE = 2         ' active window is write form

' font array indices
Global Const FPFMTWRT = 0           ' default font for formatted messages
Global Const FPTXTWRT = 1           ' font for writing plain-text messages
Global Const FPTXTRD = 2            ' font for reading plain-text messages
Global Const FPMSGLST = 3           ' message list font
Global Const FPTHRLST = 4           ' thread list font
Global Const NFONTPREF = 4          ' highest index in font preference array

Type preftype                       ' local preferences structure
    flags As Integer                '   preference flags field
    fwdee As String * MAXADR        '   auto-forwardee address
    autofile As String * FOLDRSZ    '   auto-file folder name
    eattdir As String * MAXDIR      '   E-mail attachment download directory
    fattdir As String * MAXDIR      '   Forums attachment download directory
    curfor As String * FORNSZ       '   name of last selected forum
    onfgetsiz As Integer            '   number of online forum messages to get at once
    flag2 As Integer                '   second preference flags field
    sticky As Integer               '   flags that make things "sticky"
    scaleunit As Integer            '   measurement units (inch, cm, mm)
    fmttabsiz As Integer            '   default tab size for RTF msgs (twips)
    txttabsiz As Integer            '   default tab size for plain-text msgs (chars)
    urlcolor As Long                '   color to use when highlighting URLs
    fontpref(NFONTPREF) As dialogfont ' font preference array
End Type

' preferences flags
Global Const PPMTMT = &H1           ' prompt to empty out box on connect
Global Const PALWMT = &H2           ' always empty out box on connect
Global Const PDLONC = &H4           ' always get new mail on connect
Global Const PRDONC = &H8           ' always read new mail on connect
Global Const PDLATT = &H10          ' always download attachments with E-mail
Global Const PALWQUO = &H20         ' always quote when replying
Global Const PALWCMT = &H40         ' always add comments when copy/fwding
Global Const PCLARPL = &H80         ' delete message from in box after reply
Global Const PNEWADR = &H100        ' add new addresses to address book when writing
Global Const PAUTFIL = &H200        ' auto-file messages when writing
Global Const PFWDEML = &H400        ' auto-forward E-mail
Global Const PTBAR = &H800          ' (obsolete) show toolbar
Global Const PASPELL = &H800        ' auto-spell-check before sending
Global Const PREFLOW = &H1000       ' (obsolete) reflow message text
Global Const PCLRPO = &H1000        ' delete message from post office after reply
Global Const PFORUM2 = &H2000       ' list forum messages to you
Global Const PLAINTXT = &H4000      ' write text-only message (no RTF)
Global Const PSHOWCC = &H8000       ' include cc: list in message

' second preference flags
Global Const P2ALWPO = &H1          ' always get tagged Post Office mail on connect
Global Const P2PMTPO = &H2          ' prompt to get tagged Post Office mail on connect
Global Const P2HIURL = &H4          ' highlight URLs in messages

' sticky preferences flags
Global Const SMTBAR = &H1           ' show main form toolbar
Global Const SREFLOW = &H2          ' reflow message text
Global Const SRTBAR = &H4           ' show read form toolbar
Global Const SWTBAR = &H8           ' show write form toolbar
Global Const SFMTBAR = &H10         ' show format bar when writing
Global Const SRULER = &H20          ' show ruler bar when writing
Global Const SFDLATT = &H40         ' download attachments when getting forum msgs
Global Const SDSWNDN = &H80         ' disconnect when done getting forum msgs
Global Const SONLMSG = &H100        ' list online forum messages (vs threads)
Global Const SOFLMSG = &H200        ' list offline forum messages (vs threads)

Type checkpref                      ' periodic check-for-new-mail preference type
    flags As Integer                '   flag array
    period As Integer               '   check period (in minutes)
End Type

' check-for-new-mail preference flags
Global Const CPGET = &H1            ' get mail periodically
Global Const CPCONN = &H2           ' connect if necessary
Global Const CPDISC = &H4           ' disconnect when done

' old E-mail preferences declarations
Global Const EPREFDPK = "sa=GALEML;ul:emlpref" ' preferences dynapak name
Type epreftyp                       ' old E-mail preferences structure
    flags As Integer                '   preference flags field
    fwdee As String * MAXADR        '   auto-forwardee address
    autofile As String * FOLDRSZ    '   auto-file folder name
    attdir As String * MAXDIR       '   attachment download directory
End Type

' old Forums preferences declarations
Global Const FPREFDPK = "sa=GALFOR;ul:forpref"
Type fpreftyp                       ' old Forums preferences structure
    flags As Integer                '   preferences flags field
    curfor As String * FORNSZ       '   current forum
    autodelage As Integer           '   age in days of msgs to auto-delete
    autofile As String * FOLDRSZ    '   auto-file folder name
    attdir As String * MAXDIR       '   attachment download directory
End Type
Global Const PAUTDEL = &H2000       ' (obsolete) auto-delete outdate offline msgs
Global Const PDSWNDN = &H4000       ' (obsolete) disconnect when done

Global Const MAXCUSTLEN = 400       ' maximum space allowed for custom dictionary names
Type SpellerOptions                 ' spelling checker options structure
    flags As Integer                '   option flags
    perf As Integer                 '   performance index
    dlglft As Integer               '   Left location of dialog
    dlgtop As Integer               '   Top location of dialog
    numsug As Integer               '   max number of suggestions
    custom As String * MAXCUSTLEN   '   custom dictionary names
End Type

' font dialog formxchg flags
Global Const FXBOLD = &H1           ' bold
Global Const FXITAL = &H2           ' italic
Global Const FXULIN = &H4           ' underlined
Global Const FXSTHR = &H8           ' strikethrough
Global Const FXFIXED = &H10         ' show fixed-pitch fonts only

' scale unit labels
Global Const SUIN = "in."           ' inches
Global Const SUMM = "mm."           ' millimeters
Global Const SUCM = "cm."           ' centimeters

' paragraph justification constants
Global Const JUSTL = 0              ' left
Global Const JUSTC = 1              ' centered
Global Const JUSTR = 2              ' right
Global Const JUSTF = 3              ' full

' tab type constants
Global Const TABL = 0               ' left
Global Const TABC = 1               ' centered
Global Const TABR = 2               ' right
Global Const TABD = 3               ' decimal

' types of addresses (returned by addrtyp())
Global Const ISFORUM = 0            ' forum address
Global Const ISPLIST = 1            ' personal distribution list
Global Const ISSLIST = 2            ' server distribution list
Global Const ISLCLAD = 3            ' local address
Global Const ISNETAD = 4            ' net address

' forward form input item indices
Global Const FWIFIRST = 0           ' first time invoked (vs. editing)
Global Const FWITOADR = 1           ' to address
Global Const FWICMT = 2             ' comments
Global Const FWIDELV = 3            ' delete flag value
Global Const FWIDELE = 4            ' delete flag enabled
Global Const FWIFNAM = 5            ' original forum name
Global Const FWIMSGID = 6           ' original message ID
Global Const FWIFROM = 7            ' original from
Global Const FWITPC = 8             ' message topic
Global Const FWITXLEN = 9           ' original message text length

' forward form output item indices
Global Const FWOSEND = 0            ' send now flag (vs. put in outbox)
Global Const FWODELO = 1            ' delete original
Global Const FWOTOADR = 2           ' address to forward to
Global Const FWOCMT = 3             ' comments

' Sub-App flags
Global Const EMLAPP = 1             ' E-mail sub-app available
Global Const FORAPP = 2             ' Forums sub-app available

Type emlaccs                        ' E-mail access dynapak structure
    flags As Integer                '   access flags
    ccmax As Integer                '   max # cc:s per message
    txtlen As Long                  '   max length of text field
    dftuid As String * VBUIDSIZ     '   default User-ID for "sysop" mail
End Type

' general access flags
Global Const EAWRITE = &H1          ' write E-mail other than "sysop"
Global Const EAATTACH = &H2         ' attach files to messages
Global Const EARECREQ = &H4         ' request return receipts
Global Const EAPRIMSG = &H8         ' write priority message
Global Const EAFOROP = &H10         ' do Forum-Op operations
Global Const EAINDATT = &H20        ' make indirect attachments to msgs
Global Const EAMSLST = &H40         ' use !MASS list
Global Const EAEDLST = &H80         ' create/edit server-side lists

Type globforaccess                  ' global forum access structure
    flags As Integer                '   access flags
    defcurforum As String * FORNSZ  '   default forum name
    maxscnfor As Integer            '   max # of forums allowed in scan
    txtlen As Long                  '   max body text length for messages
    ccmax As Integer                '   max # cc:s per message
    maxgrpfor As Integer            '   max # of forums allowed per group
    fmgrappid As String * VBAIDSIZ  '   forum manager App-ID
End Type

' global forum access flags
Global Const FOPMODFOR = &H1        ' forum-op can modify whole forum flag
Global Const FORSYSOP = &H2         ' user is a forum sysop
'lobal Const EAINDATT = &H20          make indirect attachments to msgs

Type cdetail                        ' carrier detail dynapak structure
    prefix As String * PFXSIZ       '   carrier prefix
    name As String * EXPNSZ         '   carrier name
    flags As Integer                '   carrier flags
    info As String * MXCINF         '   description/example/long desc
End Type

Type cars                           ' carrier in memory array structure
    prefix As String * PFXSIZ       '   carrier prefix
    name As String * EXPNSZ         '   carrier name
    flags As Integer                '   carrier access flags
End Type

' itemidxd() indices into carrier info string
Global Const CDSCFLD = 0            ' carrier short description
Global Const CEXMFLD = 1            ' carrier example
Global Const CLDFLD = 2             ' carrier long description

Type foruminf                       ' forum basic info structure
    forum As Integer                '   forum ID
    axes As String * 1              '   access level byte
    topic As String * TPCSIZ        '   forum topic
End Type

Global Const FAXSMASK = &HF         ' mask to get acc lvl from foruminf.axes
Global Const FISECHO = &H10         ' foruminf.axes flag for forum is echoed

' forum access codes
Global Const NOAXES = 0             ' no access
Global Const RDAXES = 2             ' read access
Global Const DLAXES = 4             ' download access
Global Const WRAXES = 6             ' write access
Global Const ULAXES = 8             ' upload access
Global Const COAXES = 10            ' Co-Op access
Global Const OPAXES = 12            ' Forum-Op access
Global Const SYAXES = 14            ' Sysop access
Global Const NOTSET = 15            ' not set yet (use default)
Global Const DFDFNPV = RDAXES       ' default default non-priviledged access
Global Const DFDFPRV = ULAXES       ' default default privileged access
Global Const DFMXNPV = COAXES       ' default max non-privileged access

Type viewfor                        ' view-a-forum in-mem structure
    forum As Integer                '   forum id
    nthrs As Long                   '   number of threads in forum
    nmsgs As Long                   '   number of messages in forum
    nfiles As Long                  '   number of files in forum
    nw4app As Long                  '   number of files waiting for apprvl
    dfnpv As Integer                '   default non-privileged access
    dfprv As Integer                '   default privileged access setting
    mxnpv As Integer                '   maximum non-privileged access
    msglif As Integer               '   message lifetime (days)
    chgmsg As Integer               '   charge per message posted
    chgrdm As Integer               '   charge per message read
    chgatt As Integer               '   charge per file attachment uploaded
    chgadl As Integer               '   charge per file attachment download
    chgupk As Integer               '   charge per-kbyte for upload
    chgdpk As Integer               '   charge per-kbyte for download
    ccr As Integer                  '   credit consumption rate
    pfnlvl As Integer               '   profanity suppression level
    crdatim As Double               '   forum creation date/time
    necho As Integer                '   number of echo addresses
    seqid As Long                   '   number of forum in list of forums
End Type

Type viewfdpk                       ' view-a-forum dpk structure
    forum As Integer                '   forum id
    nthrs As Long                   '   number of threads in forum
    nmsgs As Long                   '   number of messages in forum
    nfiles As Long                  '   number of files in forum
    nw4app As Long                  '   number of files waiting for apprvl
    dfnpv As Integer                '   default non-privileged access
    dfprv As Integer                '   default privileged access setting
    mxnpv As Integer                '   maximum non-privileged access
    msglif As Integer               '   message lifetime (days)
    chgmsg As Integer               '   charge per message posted
    chgrdm As Integer               '   charge per message read
    chgatt As Integer               '   charge per file attachment uploaded
    chgadl As Integer               '   charge per file attachment download
    chgupk As Integer               '   charge per-kbyte for upload
    chgdpk As Integer               '   charge per-kbyte for download
    ccr As Integer                  '   credit consumption rate
    pfnlvl As Integer               '   profanity suppression level
    crdatim As Double               '   forum creation date/time
    necho As Integer                '   number of echo addresses
    seqid As Long                   '   number of forum in list of forums
    info As String * FVINFSZ        '   variable-length forum info:
                                    '       forum name
                                    '       forum topic
                                    '       forum op
                                    '       privleged access key
                                    '       echo addresses (if any)
                                    '       description/help message
                                    '       data file (if creating)
                                    '       attachment path (if creating)
End Type

Type credfor                        ' create/edit-a-forum in-mem structure
    dfnpv As Integer                '   default non-priv access setting
    dfprv As Integer                '   default priviledged access setting
    mxnpv As Integer                '   maximum non-priv access setting
    msglif As Integer               '   message lifetime (days)
    chgmsg As Integer               '   charge per message posted
    chgrdm As Integer               '   charge per message read
    chgatt As Integer               '   charge per file attachment uploaded
    chgadl As Integer               '   charge per file attachment download
    chgupk As Integer               '   charge per-kbyte for upload
    chgdpk As Integer               '   charge per-kbyte for download
    ccr As Integer                  '   credit consumption rate
    pfnlvl As Integer               '   profanity suppression level
    seqid As Long                   '   number of forum in list of forums
    necho As Integer                '   number of echo addresses
End Type

Type credfdpk                       ' create/edit-a-forum dpk structure
    dfnpv As Integer                '   default non-priv access setting
    dfprv As Integer                '   default priviledged access setting
    mxnpv As Integer                '   maximum non-priv access setting
    msglif As Integer               '   message lifetime (days)
    chgmsg As Integer               '   charge per message posted
    chgrdm As Integer               '   charge per message read
    chgatt As Integer               '   charge per file attachment uploaded
    chgadl As Integer               '   charge per file attachment download
    chgupk As Integer               '   charge per-kbyte for upload
    chgdpk As Integer               '   charge per-kbyte for download
    ccr As Integer                  '   credit consumption rate
    pfnlvl As Integer               '   profanity suppression level
    seqid As Long                   '   number of forum in list of forums
    necho As Integer                '   number of echo addresses
    info As String * FCEINFSZ       '   variable-length forum info:
                                    '       forum name
                                    '       forum topic
                                    '       forum op
                                    '       privleged access key
                                    '       echo addresses (if any)
                                    '       description/help message
                                    '       data file (if creating)
                                    '       attachment path (if creating)
End Type

Type foraccs                        ' set forum access structure
    dfnpv As Integer                '   default non-privileged access
    dfprv As Integer                '   default privileged access
    mxnpv As Integer                '   maximum non-privileged access
    forlok As String * VBKEYSIZ     '   privileged access key
End Type

Type grphdr                         ' create/modify forum group dpk struct
     parid As Integer               '   group ID of this group's parent
     flags As Integer               '   group flags
     info As String * GRPINFSZ      '   string info, consisting of:
                                    '       group name
                                    '       key required to use group
                                    '       group topic
End Type                            '   separated by FLDSEP

Type grpinf                         ' forum group all info record structure
     grpid As Integer               '   group ID
     parid As Integer               '   group ID of this group's parent
     name As String * FORNSZ        '   group name
     topic As String * TPCSIZ       '   group topic
     key As String * VBKEYSIZ       '   key required to use this group
     flags As Integer               '   group flags
     nforums As Integer             '   number of forums in group
     forlst(maxgrpfor) As Integer   '   list of forum IDs in group
End Type

' itemidxd() constants for forum info strings
Global Const FNAME = 0              ' forum name
Global Const FTOPIC = 1             ' forum topic
Global Const FFOROP = 2             ' forum op
Global Const FPRVKEY = 3            ' privleged access key
Global Const FEADDRS = 4            ' echo addresses
Global Const FDESC = 5              ' description/help message
Global Const FATTPTH = 6            ' attachment path
Global Const FDATFIL = 7            ' data file

' profanity levels
'lobal Const NONE = 0               ' already defined as 0 in CONSTANT.TXT
Global Const MILD = 1
Global Const MODERATE = 2
Global Const SEVERE = 3
Global Const DFTPFN = 4             ' use system-wide default

Type globid                         ' global message identifier structure
    sysid As Long                   '   system identifier
    msgid As Long                   '   message identifier
End Type

Type message                        ' in-memory message structure
    forum As Integer                '   ID of forum message belongs to
    axes As String * 1              '   per-message access info
    fornam As String * FORNSZ       '   name of forum msg in ("" if E-mail)
    msgid As Long                   '   unique message identifier
    gmid As globid                  '   unique global message identifier
    thrid As Long                   '   ID of thread message is part of
    attname As String * FLNSIZ      '   attached file name
    crdatim As Double               '   message creation date and time
    rplto As globid                 '   global ID of msg this is a reply to
    nrpl As Integer                 '   number of times replied to
    flags As Integer                '   message/attachment flag bits
End Type                            ' info field passed as separate string

Type msgdpk                         ' in-dynapak message structure
    forum As Integer                '   ID of forum message belongs to
    axes As String * 1              '   per-message access info
    fornam As String * FORNSZ       '   name of forum msg in ("" if E-mail)
    msgid As Long                   '   unique message identifier
    gmid As globid                  '   unique global message identifier
    thrid As Long                   '   ID of thread message is part of
    attname As String * FLNSIZ      '   attached file name
    crdatim As Double               '   message creation date and time
    rplto As globid                 '   global ID of msg this is a reply to
    nrpl As Integer                 '   number of times replied to
    flags As Integer                '   message/attachment flag bits
    info As String * INFSIZ         '   info field (see below)
End Type

Type msgdpkshrt                     ' message header dynapak structure
    forum As Integer                '   ID of forum message belongs to
    axes As String * 1              '   per-message access info
    fornam As String * FORNSZ       '   name of forum msg in ("" if E-mail)
    msgid As Long                   '   unique message identifier
    gmid As globid                  '   unique global message identifier
    thrid As Long                   '   ID of thread message is part of
    attname As String * FLNSIZ      '   attached file name
    crdatim As Double               '   message creation date and time
    rplto As globid                 '   global ID of msg this is a reply to
    nrpl As Integer                 '   number of times replied to
    flags As Integer                '   message/attachment flag bits
    info As String * SHRTINFSIZ     '   info field (w/out message body)
End Type

Type newmsg                         ' in-memory new message structure
    orgfor As Integer               '   forum original message was in
    forum As Integer                '   forum message being written to
    msgid As Long                   '   original message identifier
    gmid As globid                  '   original global message identifier
    thrid As Long                   '   ID of thread message is part of
    attname As String * FLNSIZ      '   attached file name
    flags As Integer                '   message/attachment flag bits
End Type

Type newdpk                         ' in-dynapak new message structure
    orgfor As Integer               '   forum original message was in
    forum As Integer                '   forum message being written to
    msgid As Long                   '   original message identifier
    gmid As globid                  '   original global message identifier
    thrid As Long                   '   ID of thread message is part of
    attname As String * FLNSIZ      '   attached file name
    flags As Integer                '   message/attachment flag bits
    info As String * NINFSIZ        '   info field (see below)
End Type

' itemidxd() indices into email info string fields
Global Const FROMFLD = 0            ' from field index
Global Const ATTPATH = 0            ' attachment path field index
Global Const TOFLD = 1              ' to field index
Global Const TPCFLD = 2             ' topic field index
Global Const HISTFLD = 3            ' history field index
Global Const TEXTFLD = 4            ' text field index

' message flag bits
Global Const PRIMSG = &H1           ' message is "priority"
Global Const EXEMPT = &H2           ' message is exempt from auto-deletion
Global Const RECREQ = &H10          ' return-receipt requested when received
Global Const FILIND = &H20          ' "indirect" att, direct has path
Global Const FILATT = &H40          ' file is attached to this message
Global Const FILAPV = &H80          ' file attached is ok to download
Global Const NODEL = &H100          ' sender can't delete
Global Const NOMOD = &H200          ' sender can't modify
Global Const OLDMSGREAD = &H8000    ' (obsolete) message has been read (E-mail client In Box only)

Type wrterr                         ' write message error structure
    flags As Integer                '   what message field had error
    code As Integer                 '   type of error
End Type

' message write error flags
'lobal Const PRIMSG = &H1             message is "priority"
Global Const FORUMID = &H2          ' error in forum ID
Global Const ADDRESS = &H4          ' error in address
Global Const CCOPY = &H8            ' error in carbon copies
'lobal Const RECREQ = &H10            error in return-receipt request
'lobal Const FILIND = &H20            error in indirect attachment
'lobal Const FILATT = &H40            error in attachment
Global Const THEMOD = &H2000        ' error in modified msg
Global Const THEFWD = &H4000        ' error in forwarded msg
Global Const THEMSG = &H8000        ' error while writing msg

' general error codes
Global Const GMEERR = -1            ' generic error
Global Const GMEDUP = -2            ' unique name or ID exists
Global Const GME2MFR = -3           ' too many forums error
Global Const GMENFID = -4           ' no available forum IDs error
Global Const GMENFND = -5           ' generic "not found" error
Global Const GMENDEL = -6           ' generic "can't delete" error
Global Const GMENMOD = -7           ' generic "can't modify" error
Global Const GMEFDV = -8            ' variable part of forum def too long
Global Const GMECRD = -9            ' not enough credits for operation
Global Const GMEMEM = -10           ' not enough memory for operation
Global Const GMEIVA = -11           ' invalid attachment to message
Global Const GMENOAT = -12          ' unable to attach file to message
Global Const GMEACC = -13           ' user doesn't have access
Global Const GMENRGM = -14          ' couldn't re-get message
Global Const GMENCFL = -15          ' can't copy/fwd to a dist list
Global Const GMERST = -16           ' E-mail message pointer reset
Global Const GMEUSE = -17           ' message in use, can't modify or del
Global Const GME2MFL = -19          ' too many forum data files
Global Const GMENSRC = -20          ' source not found
Global Const GMENDST = -21          ' destination not found
Global Const TRYAGAIN = 1000        ' retry write operation
Global Const PFNERR = 1001          ' message has unallowable profanity
Global Const BADADR = 1002          ' copy/forward to a bad address
Global Const TOOMNY = 1003          ' too many carbon copies
Global Const CMTERR = 1004          ' error adding comments when forwarding

Type threadinf                      ' thread info dynapak structure
    nmsgs As Integer                '   number of messages in thread
    topic As String * TPCSIZ        '   thread topic
End Type

Type thrinfarrstruct                ' thread info array element structure
    thrid As Long                   '   thread ID
    nmsgs As Integer                '   number of messages in thread
    topic As String * TPCSIZ        '   thread topic
    lstidx As Integer               '   index of thread in list
End Type

Type otscan                         ' one-time scan setup structure
    keywds As String * MAXKWDS      '   keywords
    stmsgid As Long                 '   starting message ID (0 for none)
    flags As String * 1             '   search flags
    nforums As Integer              '   number of forums in list
    forlst(MAXSCF) As Integer       '   list of forums to scan
End Type

' one-time scan flags
Global Const SCNEW = &H1            ' include "new" messages only
Global Const SCATT = &H2            ' include msgs w/attachments only
Global Const SCTOU = &H4            ' include msgs to user only
Global Const SCFRU = &H8            ' include msgs from user only
Global Const SCALL = &H10           ' include all forums not listed

' scan initialization error codes
Global Const SCINVR = 0             ' scans not supported on this server
Global Const SCINOW = 1             ' can't scan now, try again later
Global Const SCINVF = 2             ' no valid forums are in scan request

Type tcpostype                      ' structure for getting TextControl cursor position
    lin As Long                     '   cursor line
    col As Long                     '   cursor column
End Type

Type textmetric                     ' Windows TEXTMETRIC structure
    tmHeight As Integer
    tmAscent As Integer
    tmDescent As Integer
    tmInternalLeading As Integer
    tmExternalLeading As Integer
    tmAveCharWidth As Integer
    tmMaxCharWidth As Integer
    tmWeight As Integer
    tmItalic As String * 1
    tmUnderlined As String * 1
    tmStruckOut As String * 1
    tmFirstChar As String * 1
    tmLastChar As String * 1
    tmDefaultChar As String * 1
    tmBreakChar As String * 1
    tmPitchAndFamily As String * 1
    tmCharSet As String * 1
    tmOverhang As Integer
    tmDigitizedAspectX As Integer
    tmDigitizedAspectY As Integer
End Type

Type winrect                        ' Windows RECT structure
    left As Integer
    Top As Integer
    right As Integer
    bottom As Integer
End Type

Type vbrect                         ' VB-ized RECT structure (has room for twips)
    left As Long
    Top As Long
    right As Long
    bottom As Long
End Type

Type pointstruct                    ' Windows POINT structure
    pointx As Integer
    pointy As Integer
End Type

Global convertflag As Integer       ' conversion of stuff from old format to new format required

Global appflgs As Integer           ' what sub-apps are available (E-mail/Forums)
Global msgactivewin As Integer      ' window which is currently active
Global cursource As Integer         ' source ID of current list
Global maxlstlbl As Integer         ' highest index of lstname and lsttitle arrays
Global maxcaplbl As Integer         ' highest index of caplbl array
Global mtbid As Integer             ' main form toolbar ID
Global appconnected As Integer      ' app initiated connection
Global shutdnipg As Integer         ' session shutdown in progress
Global appclsipg As Integer         ' app unload in progress
Global abtappcls As Integer         ' abort app unload (only if not session shutdown)
Global initipg As Integer           ' initialization in progress
Global initflgs As Integer          ' current initialization progress flags
Global multipleop As Integer        ' is a multiple selection operation being performed?
Global emlaccrid As Integer         ' reqid for initializing E-mail access
Global foraccrid As Integer         ' reqid for initializing Forums access
Global carrid As Integer            ' reqid for initializing carriers
Global scanipg As Integer           ' is a scan currently in progress?
Global curscan As otscan            ' user's current scan settings
Global scnactv As Integer           ' is a user (non-background) scan active?
Global selforarr() As Integer       ' array of selected forums for multiselect forum selector
Global datew As Integer             ' width in twips of a date string
Global frmtopofs As Integer         ' offset additional forms this far from top
Global frmlftofs As Integer         ' offset additional forms this far from left
Global capfail As Integer           ' global actcap() failure flag
Global capargs As String            ' global actcap() arguments string
Global FLDSEP As String             ' itemidxd() separator for messages
Global tb As String                 ' global string to hold TAB character
Global nl As String                 ' global string to hold newline string
Global emlacc As emlaccs            ' global E-mail access structure
Global globforacc As globforaccess  ' global Forums access structure
Global cdet As cdetail              ' global buffer for reading carrier detail
Global carp() As cars               ' array of carrier info
Global numcar As Integer            ' number of carriers in array
Global curlstmode As Integer        ' current forum list mode
Global curgrpstr As String          ' current group string
Global prefs As preftype            ' global preferences structure
Global checkpref As checkpref       ' global check-for-new-mail preference structure
Global msgindpk As msgdpk           ' global buffer for reading message dynapaks
Global curforinf As foruminf        ' global forum info for last selected forum

Declare Function lstrlen Lib "Kernel" (ByVal lpstr As Long) As Integer
Declare Function lstrcpy Lib "Kernel" (ByVal dststr As Any, ByVal srcstr As Any) As Long
Declare Function GlobalLock Lib "Kernel" (ByVal hglb As Integer) As Long
Declare Function GlobalUnlock Lib "Kernel" (ByVal hglb As Integer) As Integer
Declare Function GlobalFree Lib "Kernel" (ByVal hglb As Integer) As Integer
Declare Function sendsmsg Lib "User" Alias "sendmessage" (ByVal hwnd As Integer, ByVal msg As Integer, ByVal wparm As Integer, ByVal sparm As String) As Long
Declare Function sendpmsg Lib "User" Alias "sendmessage" (ByVal hwnd As Integer, ByVal msg As Integer, ByVal wparm As Integer, lpparm As Any) As Long
Declare Function GetSystemMetrics Lib "User" (ByVal nIndex As Integer) As Integer
Declare Function GetTextMetrics Lib "GDI" (ByVal hDC As Integer, tm As Any) As Integer
Declare Function bitblt Lib "GDI" (ByVal dsthdc As Integer, ByVal dstx As Integer, ByVal dsty As Integer, ByVal w As Integer, ByVal h As Integer, ByVal srchdc As Integer, ByVal srcx As Integer, ByVal srcy As Integer, ByVal rop As Long) As Integer
Declare Function GetProfileInt Lib "Kernel" (ByVal lpSection As String, ByVal lpItem As String, ByVal nDefault As Integer) As Integer
Declare Sub GetClientRect Lib "User" (ByVal hwnd As Integer, lpRect As winrect)
Declare Sub InvalidateRect Lib "User" (ByVal hwnd As Integer, lpRect As winrect, ByVal erasebkg As Integer)
Declare Sub GetCaretPos Lib "User" (lpPoint As pointstruct)
Declare Sub SetCaretPos Lib "User" (ByVal X As Integer, ByVal Y As Integer)
Declare Function GetWindow Lib "User" (ByVal hwnd As Integer, ByVal wCmd As Integer) As Integer
Declare Sub ClipCursor Lib "User" (lpRect As winrect)
Declare Sub nClipCursor Lib "User" (ByVal nlpRect As Long)
Declare Function GetModuleHandle Lib "Kernel" (ByVal ModName As String) As Integer
Declare Function GetHeapSpaces Lib "Kernel" (ByVal hModule As Integer) As Long
Declare Function RedrawWindow Lib "User" (ByVal hwnd As Integer, lprcUpdate As winrect, ByVal hrgnUpdate As Integer, ByVal fuRedraw As Integer) As Integer

