'****************************************************************************
'*                                                                          *
'*  MSGAPPU.BAS                                                             *
'*                                                                          *
'*  Copyright (c) 1996-1997 Galacticomm Inc.    All Rights Reserved.        *
'*                                                                          *
'*  Utility functions specific to Message Center.                           *
'*                                                                          *
'*                                                   - J. Alvrus 4/29/96    *
'*                                                                          *
'****************************************************************************

Option Explicit

Dim lexdlipg As Integer             ' dictionary files being downloaded
Dim lexrqid As Integer              ' dictionary files download request ID
Dim acc2get As Integer              ' access flags being read
Dim aliasInfo As String             ' Internet e-mail alias info

Sub caplblvis (ByVal vis As Integer)
' set main form message list caption visibility
' vis:  caption label visibility flag

    Dim i As Integer

    For i = 0 To maxcaplbl
        mainform!caplbl(i).Visible = vis
    Next
End Sub

Function checklex () As Integer
' check for and download if necessary the spelling checker files
' returns True if files available

    Dim cursiz As Long, totsiz As Long
    Dim lexdpk As String
    Dim tmpprg As dpkprg

    If fexist(LEXFILE, False) Then
        checklex = True
        lexdlipg = False
    Else
        On Error Resume Next
        Kill "american.vtd"
        On Error GoTo 0
        checklex = False
        If gmsgbox("You do not have all the files necessary to check spelling. Would you like to download them now?", MB_ICONQUESTION Or MB_YESNO, "") <> IDYES Then
            Exit Function
        End If
        cursiz = 0&
        If Not appconnect() Then
            Exit Function
        End If
        lexdlipg = True
        lexrqid = -1
        progopen PRGT_BAR, "Getting Spelling Checker Files", "", "", ""
        If appflgs And EMLAPP Then
            lexdpk = ELEXDPK & LEXFILE
        Else
            lexdpk = FLEXDPK & LEXFILE
        End If
        totsiz = Abs(stsdpk(lexdpk))
        lexrqid = readpk(lexdpk, mainform!maincbk)
        Do While lexrqid >= 0
            DoEvents
            prgdpk lexrqid, tmpprg
            If tmpprg.totlen >= 0 Then
                If cursiz <> tmpprg.dsofar Then
                    cursiz = tmpprg.dsofar
                    progupdate CStr(100& * cursiz \ totsiz)
                End If
            End If
            DoEvents
            If progcancel() Then
                progclose
                abodpk lexrqid
                lexdlipg = False
                Exit Function
            End If
        Loop
        progclose
        lexdlipg = False
        checklex = True
    End If
End Function

Sub enablemain (ByVal Enable As Integer)
' enable/disable controls on main form

    mainform!mf_file.Enabled = Enable
    mainform!ml_list.Enabled = Enable
    mainform!mv_view.Enabled = Enable
    mainform!mt_thread.Enabled = Enable
    mainform!mr_forop.Enabled = Enable
    mainform!mo_options.Enabled = Enable
    mainform!mw_win.Enabled = Enable
    mainform!mh_help.Enabled = Enable
    mainform!toolbar.Enabled = Enable
    mainform!thrlist.Enabled = Enable
    mainform!sepbar.Enabled = Enable
    mainform!msglist.Enabled = Enable
End Sub

Sub endofthr (ByVal direc As Integer)
' generate end-of-thread message

    Screen.MousePointer = DEFAULT
    Select Case direc
    Case READPREV
        popmsg "You have reached the first message in this thread.", ""
    Case READTHIS
        popmsg "The parent of this message is not available.", ""
    Case READNEXT
        popmsg "You have reached the last message in this thread.", ""
    End Select
End Sub

Sub aliasDialog ()
' display appropriate alias dialog
    Dim tmps As String

    If Len(aliasInfo) Then
        tmps = itemdel(aliasInfo, 0)
        If itemcnt(tmps) = 1 Then
            If Len(tmps) Then
                popmsg "Your Internet alias is """ & tmps & """. This alias has been assigned to you by the system and can not be changed.", ""
            Else
                popmsg "Your User-ID conflicts with an existing Internet e-mail address. In order to receive Internet e-mail on this system, you must choose a different User-ID. Please contact the Sysop if you have any questions.", ""
            End If
        Else
            tmps = formfunc(aliasfrm, tmps)
            If Len(tmps) Then
                If appconnect() Then
                    tmps = swrtdpkv(ALIASDPK, STGLEN, itemidx(tmps, 1))
                    If evtdpk() = "Write ok" Then
                        aliasInfo = tmps
                    ElseIf Len(tmps) Then
                        poperror tmps, ""
                    Else
                        poperror "Unable to set alias.", ""
                    End If
                End If
            End If
        End If
    Else
        poperror "Internet aliasing is not available on this system.", ""
    End If
End Sub

Function aliasInit () As Integer
' initialize alias info
' returns False if aliasing not available

    aliasInfo = sreadpkv(ALIASDPK)
    aliasInit = (Len(aliasInfo) <> 0)
End Function

Sub clearlists ()
' clear out all lists/labels on the main form

    unldlst
    mainform!thrlist.Clear
    mainform!msglist.Clear
    nuketabs mainform!msglist
    unldcap
End Sub

Sub dlatt (ByVal fornam As String, ByVal msgid As Long, ByVal attname As String, ByVal path As String, ByVal later As Integer)
' generic download-attachment handler
' fornam:   forum name or "" if E-mail
' msgid:    message ID of message
' attname:  name of attachment file
' path:     path to download to or "" to let user select
' later:    download file later (not now)

    Dim filename As String

    freeup
    filename = attname
    On Error Resume Next
    junk = Dir$(attname)
    If Err Then
        filename = ""
    End If
    On Error GoTo 0
    appconnected = True
    If Len(fornam) Then
        tagsub attname & " (attached to #" & msgid & " in " & fornam & ")", curapid(), FORATTDPK, "sa=GALFOR;ul:~", fornam & " " & Format$(msgid, MNMFMT), path, filename, later, False
    Else
        tagsub attname & " (attached to message #" & msgid & ")", curapid(), EMLATTDPK, "sa=GALEML;ul:etg ", Format$(msgid, MNMFMT), path, filename, later, False
    End If
    appconnected = False
End Sub

Sub docascade (theform As Form, ftop As Integer, fleft As Integer, ByVal fwidth As Integer, ByVal fheight As Integer, ByVal fminscw As Integer, ByVal ctrlsiz As Integer)
' place a form in its cascaded position
' theform:  form to position
' ftop:     form top position
' fleft:    form left position
' fwidth:   form width
' fheight:  form height
' fminscw:  minimum scale width to allow
' ctrlsiz:  height of form header region

    If isloaded(theform) Then
        If Len(theform.Tag) Then
            theform.SetFocus
            theform.WindowState = NORMAL
            theform.Height = fheight
            theform.Width = fwidth
            theform.Top = ftop
            theform.Left = fleft
            ftop = ftop + frmtopofs
            fleft = fleft + frmlftofs
            allonscr theform, fminscw, 3 * ctrlsiz
        End If
    End If
End Sub

Function emlcanthread (ByVal msgidstr As String, ByVal fornam As String, ByVal msgid As Long, ByVal thrid As Long, rplto As globid, ByVal direc As Integer) As Integer
' E-mail In Box/Post Office:  check for message in a thread function
' msgidstr: identifier of current message
' fornam:   forum name or "" if email
' msgid:    current message ID
' thrid:    current thread ID
' rplto:    reply-to ID of current message
' direc:    direction to read (-1=prev, 0=parent, 1=next)
' returns:  True if message available

    Select Case direc
    Case READTHIS
        If Len(fornam) Then
            emlcanthread = rplto.sysid <> 0 And rplto.msgid <> 0
        Else
            emlcanthread = rplto.msgid <> 0
        End If
    Case READNEXT, READPREV
        emlcanthread = Len(fornam) <> 0
    End Select
End Function

Function emlreadthr (msgidstr As String, ByVal fornam As String, ByVal msgid As Long, ByVal thrid As Long, rplto As globid, ByVal direc As Integer) As Integer
' E-mail In Box/Post Office:  read a message in a thread function
' msgidstr: identifier of current message (updated if successful)
' fornam:   forum name or "" if email
' msgid:    current message ID
' thrid:    current thread ID
' rplto:    reply-to ID of current message
' direc:    direction to read (-1=prev, 0=parent, 1=next)
' returns:  True if message found
' implicit output: message is in msgindpk if returns True

    If Len(fornam) Then             'Forum message
        If appconnect() Then
            If forreadthr(fornam, msgid, thrid, direc) Then
                emlreadthr = True
                msgidstr = Format$(msgindpk.msgid, MNMFMT)
            End If
        End If
    Else                            'E-mail message
        If direc = READTHIS Then    'backtrack
            If appconnect() Then
                If sreadpk("sa=" & EMLAPID & ";u:bktrack " & msgidstr, Len(msgindpk), msgindpk) Then
                    emlreadthr = True
                    msgidstr = Format$(msgindpk.msgid, MNMFMT)
                End If
            End If
        End If
    End If
End Function

Sub emlsetup (ByVal lstcap As String, ByVal tagvis As Integer)
' set up main form for E-mail In Box/Post Office
' lstcap:   list title ("In Box" or "Post Office")
' tagvis:   tag-related menu options visibility flag

    Screen.MousePointer = HOURGLASS
    mainform!msglist.ReFreshOnUpdate = False
    clearlists
    thrlstvis False
    tbvis mtbid, MTB_DELETE & SETSEP & MTB_JFIRST & SETSEP & MTB_JSPEC & SETSEP & MTB_JLAST
    tbinvis mtbid, MTB_LSTMSG & SETSEP & MTB_LSTTHR
    mainform!mfdel.Visible = True
    jmpmnuvis True
    tagmnuvis tagvis
    fopmnuvis False, ""
    lopmnuvis False
    mainform!lsttitle(0) = lstcap
    mainform!lsttitle(0).Visible = True
    mainform!lstname(0).Visible = False
    setmlntab 2
    mainform!caplbl(0).Caption = "Date"
    mainform!caplbl(1).Caption = "From"
    mainform!caplbl(2).Caption = "Topic"
    mainform!caplbl(1).Left = mainform!caplbl(0).Left + mainform!msglist.TabPos(0)
End Sub

Sub fopmnuvis (ByVal Visible As Integer, ByVal fornam As String)
' set Forum-Op menu(s) visibility

    Dim acc As Integer

    If globforacc.flags And FORSYSOP Then
        mainform!mr_forop.Visible = True
        mainform!mrman.Visible = True
        mainform!mredit.Visible = False
        mainform!mrsep1.Visible = True
        mainform!mrsetacc.Visible = Visible
        mainform!mrcpyacc.Visible = True
        mainform!molstuna.Visible = Visible
        Exit Sub
    End If
    If Visible Then
        acc = getaxes(fornam, NOAXES)
        If acc >= OPAXES Then
            mainform!mr_forop.Visible = True
            mainform!mrman.Visible = False
            mainform!mredit.Visible = True
            mainform!mrsep1.Visible = False
            mainform!mrsetacc.Visible = True
            mainform!mrcpyacc.Visible = False
            mainform!molstuna.Visible = True
            Exit Sub
        End If
    End If
    mainform!mr_forop.Visible = False
    mainform!molstuna.Visible = False
End Sub

Function forapvmsg (ByVal fornam As String, ByVal msgid As Long, ByVal setto As Integer) As Integer
' approve attachment to a forum message
' fornam:   name of forum message is located in
' msgid:    message ID of message with attachment
' setto:    True to approve, False to unapprove
' returns True if successful

    Dim retval As Integer

    forapvmsg = False
    If appconnect() Then
        retval = 0
        junk = swrtdpk(APVMSGDPK & fornam & " " & Format$(msgid, MNMFMT), Len(setto), setto, Len(retval), retval)
        Select Case evtdpk()
        Case "Write ok"
            popmsg "Attachment approval status updated successfully.", ""
            forapvmsg = True
        Case "Offline write denied", "Write may be incomplete"
            'do nothing
        Case Else
            Select Case retval
            Case GMEACC
                poperror "You do not have access to approve attachments.", ""
            Case GMENFND
                poperror "This message no longer exists on the server.", ""
            Case Else
                poperror "Unable to approve attachment.  (Error " & retval & ")", ""
            End Select
        End Select
    End If
End Function

Function fordelmsg (ByVal fornam As String, ByVal msgid As Long) As Integer
' delete a forum message
' returns True if message deleted

    Dim rspval As Integer, confirm As Integer, savemp As Integer

    fordelmsg = False
    savemp = Screen.MousePointer
    confirm = IDNO
    If Not multipleop Then
        Screen.MousePointer = DEFAULT
        confirm = gmsgbox("This will delete the message from the server!  Are you sure you wish to do this?", MB_ICONQUESTION Or MB_YESNO Or MB_DEFBUTTON2, "")
        Screen.MousePointer = savemp
    End If
    If multipleop Or (confirm = IDYES) Then
        If appconnect() Then
            rspval = 0
            junk = swrtdpk(FORMODDPK & fornam & " " & Format$(msgid, MNMFMT), 0, "", Len(rspval), rspval)
            Select Case evtdpk()
            Case "Write ok"
                fordelmsg = True
            Case "Offline write denied", "Write may be incomplete"
                'do nothing
            Case Else
                Screen.MousePointer = DEFAULT
                Select Case rspval
                Case GMEUSE
                    poperror "This message is in use by someone else at the moment and cannot be deleted.", ""
                Case GMEACC
                    poperror "You do not have access to delete this message.", ""
                Case GMENFND
                    fordelmsg = True
                Case Else
                    poperror "Unable to delete this message.  (Error " & rspval & ")", ""
                End Select
                Screen.MousePointer = savemp
            End Select
        End If
    End If
End Function

Function forreadthr (ByVal fornam As String, ByVal msgid As Long, ByVal thrid As Long, ByVal direc As Integer) As Integer
' read a forum message in a thread
' msgidstr: identifier of current message (updated if successful)
' fornam:   forum name or "" if email
' msgid:    current message ID
' thrid:    current thread ID
' rplto:    reply-to ID of current message
' direc:    direction to read (-1=prev, 0=parent, 1=next)
' source:   message source in effect (must be SRCFORUM or SRCTHREAD or SRCUNAPV)
' returns:  True if message found
' implicit output: message is in msgindpk if returns True

    Dim rsplen As Integer

    rsplen = 0
    If appconnect() Then
        Select Case direc
        Case READPREV
            rsplen = srltdpk(thrmsgdpknam(fornam, thrid, msgid), thrmsgmm(fornam, thrid), Len(msgindpk), msgindpk)
        Case READTHIS
            rsplen = sreadpk(PARMSGDPK & fornam & " " & Format$(msgid, MNMFMT), Len(msgindpk), msgindpk)
        Case READNEXT
            rsplen = srgtdpk(thrmsgdpknam(fornam, thrid, msgid), thrmsgmm(fornam, thrid), Len(msgindpk), msgindpk)
        End Select
        If rsplen Then
            stpnls msgindpk.info
        End If
    End If
    forreadthr = rsplen <> 0
End Function

Function forxmtmsg (ByVal fornam As String, ByVal msgid As Long, ByVal setto As Integer) As Integer
' exempt a forum message from auto-delete
' fornam:   name of forum message is located in
' msgid:    message ID of message with attachment
' setto:    True to exempt, False to unexempt
' returns True if successful

    Dim retval As Integer

    forxmtmsg = False
    If appconnect() Then
        retval = 0
        junk = swrtdpk(XMTMSGDPK & fornam & " " & Format$(msgid, MNMFMT), Len(setto), setto, Len(retval), retval)
        Select Case evtdpk()
        Case "Write ok"
            popmsg "Message exempt status updated successfully.", ""
            forxmtmsg = True
        Case "Offline write denied", "Write may be incomplete"
            'do nothing
        Case Else
            Select Case retval
            Case GMEACC
                poperror "You do not have access to exempt messages.", ""
            Case GMENFND
                poperror "This message no longer exists on the server.", ""
            Case Else
                poperror "Unable to exempt message.  (Error " & retval & ")", ""
            End Select
        End Select
    End If
End Function

Function getaxes (ByVal fornam As String, ByVal dftaxes As Integer)
' by hook or by crook, get user's correct forum access
' fornam:   name of forum to get access in
' dftaxes:  use this if can't read forum info

    Dim forinf As foruminf

    If getforinf(forinf, fornam) Then
        getaxes = infaxes(forinf)
    Else
        getaxes = dftaxes
    End If
End Function

Sub getfontnames (namelist As Control, txtctl As TextControl)
'get list of supported fonts into given list based on given text control

    Dim hglb As Integer
    Dim lpfontlst As Long, fontnamlen As Long
    Dim fontnam As String

    namelist.Clear
    hglb = u2int(sndmsg(txtctl.hWnd, TX_GETSUPPORTEDFONTS, 0, 0&))
    lpfontlst = GlobalLock(hglb)
    Do
        fontnamlen = lpstrlen(lpfontlst)
        If fontnamlen Then
            namelist.AddItem lp2hlstr(lpfontlst)
            lpfontlst = lpfontlst + fontnamlen + 1
        End If
    Loop While fontnamlen
    If GlobalUnlock(hglb) = 0 Then
        junk = GlobalFree(hglb)
    End If
End Sub

Sub getfontsizes (ByVal fontnam As String, sizelist As Control, txtctl As TextControl)
'get supported sizes for given font in given list based on given textcontrol

    Dim hglb As Integer
    Dim lpsizelst As Long, sizestrlen As Long

    hglb = u2int(sendsmsg(txtctl.hWnd, TX_GETSUPPORTEDSIZES, 0, fontnam))
    lpsizelst = GlobalLock(hglb)
    sizelist.Clear
    Do
        sizestrlen = lpstrlen(lpsizelst)
        If sizestrlen Then
            sizelist.AddItem lp2hlstr(lpsizelst)
            lpsizelst = lpsizelst + sizestrlen + 1
        End If
    Loop While sizestrlen
    If GlobalUnlock(hglb) = 0 Then
        junk = GlobalFree(hglb)
    End If
End Sub

Function getfontstr (ctl As TextControl) As String
' get a control's font settings into FX string form
' (color is not set)

    Dim flags As Integer
    Dim tmps As String

    flags = 0
    If ctl.FontBold Then
        flags = flags Or FXBOLD
    End If
    If ctl.FontItalic Then
        flags = flags Or FXITAL
    End If
    If ctl.FontUnderline Then
        flags = flags Or FXULIN
    End If
    If ctl.FontStrikethru Then
        flags = flags Or FXSTHR
    End If
    tmps = ""
    If ctl.FontSize > 0 Then
        tmps = ctl.FontSize
    End If
    getfontstr = ctl.FontName & tb & tmps & tb & "0" & tb & flags
End Function

Function getjmpmid () As Long
' get message ID to jump to
' returns -1 if user cancels or gives invalid input

    Dim tmpid As Long
    Dim tmps As String

    getjmpmid = -1
    tmps = formfunc(minpbox, "Message Number:" & tb & "Jump to...")
    If IsNumeric(tmps) Then
        tmpid = lval(tmps)
        If tmpid < 0 Then
            tmpid = 0
        End If
        getjmpmid = tmpid
    End If
End Function

Function gettccol (tc As TextControl) As Long
'get cursor column in TextControl (zero-based)

    Dim col As Long, lin As Long

    gettcpos tc, col, lin
    gettccol = col
End Function

Function gettccsrofs (tc As TextControl) As Long
' get character position of cursor (like SelStart)

    Dim row As Long, col As Long

    gettcpos tc, col, row
    gettccsrofs = col + sndmsg(tc.hWnd, TX_LINEINDEX, 0, row - 1)
End Function

Function gettcdev (tc As TextControl) As Integer
' get current device type for TextControl

    gettcdev = sndmsg(tc.hWnd, TX_GETDEVICE, 0, 0&)
End Function

Function gettclen (tc As TextControl) As Long
' get length of text in text control

    gettclen = sndmsg(tc.hWnd, TX_GETTEXTSIZE, 0, 0&)
End Function

Function gettclin (txtctl As TextControl) As Long
'get cursor line in TextControl (one-based)

    Dim col As Long, lin As Long

    gettcpos txtctl, col, lin
    gettclin = lin
End Function

Function gettcnlin (tc As TextControl) As Long
' get number of lines of text in TextControl

    gettcnlin = sndmsg(tc.hWnd, TX_GETLINECOUNT, 0, 0&)
End Function

Sub gettcpos (txtctl As TextControl, col As Long, lin As Long)
' get cursor position in TextControl (col is zero-based, lin is one-based)

    Dim tmps As String
    Dim pos As tcpostype

    tmps = Space$(Len(pos))
    junk = sendsmsg(txtctl.hWnd, TX_GETLINEANDCOL, 0, tmps)
    stg2typ tmps, pos, Len(pos)
    col = pos.col
    lin = pos.lin
End Sub

Function gettcrtf (tc As TextControl) As String
'get contents of textcontrol as RTF
'tc:    Text Control to get from
'returns contents as RTF if SelLength = 0 or selected text as RTF if SelLength <> 0

    Const TX_EXPORTTEXT = (WM_USER + 163)

    Dim hglb As Integer, errsav As Integer
    Dim lprtf As Long, rtflen As Long

    gettcrtf = ""
    hglb = u2int(sendsmsg(tc.hWnd, TX_EXPORTTEXT, -1, "TX_RTF.DLL"))
    If hglb Then
        lprtf = GlobalLock(hglb)
        If lprtf Then
            errsav = 0
            rtflen = lpstrlen(lprtf)
            If rtflen Then
                On Error Resume Next
                gettcrtf = lp2hlstr(lprtf)
                errsav = Err
                On Error GoTo 0
            End If
            If GlobalUnlock(hglb) = 0 Then
                junk = GlobalFree(hglb)
            End If
            If errsav Then
                Err = errsav
            End If
        End If
    End If
End Function

Function gettcseltext (tc As TextControl) As String
'get selected text from textcontrol
'tc:    Text Control to get from
'returns selected text

    Dim tmps As String

    gettcseltext = ""
    If tc.SelLength Then
        tmps = gettctext(tc)
        gettcseltext = Mid$(tmps, tc.SelStart + 1, tc.SelLength)
    End If
End Function

Function gettcselx (tc As TextControl) As Long
' get character x coordinate of TextControl SelStart (zero-based)

    gettcselx = tc.SelStart - sndmsg(tc.hWnd, TX_LINEINDEX, 0, gettcsely(tc))
End Function

Function gettcsely (tc As TextControl) As Long
' get character y coordinate of TextControl SelStart (zero-based)

    If tc.SelStart = gettclen(tc) Then
        gettcsely = gettcnlin(tc) - 1
    Else
        gettcsely = sndmsg(tc.hWnd, TX_LINEFROMCHAR, 0, tc.SelStart) - 1
    End If
End Function

Function gettctext (tc As TextControl) As String
'get plain text contents of textcontrol
'tc:    Text Control to get from
'returns text

    Const TX_GETTEXT = (WM_USER + 179)

    Dim tmplen As Long
    Dim tmps As String

    gettctext = ""
    tmplen = gettclen(tc)
    tmps = Space$(tmplen + 1)
    If sendsmsg(tc.hWnd, TX_GETTEXT, tmplen + 1, tmps) Then
        gettctext = Left$(tmps, tmplen)
    End If
End Function

Sub hdlctrltab (KeyCode As Integer, Shift As Integer, curform As Form)
' handle Ctrl+Tab switching between forms
' KeyCode:  KeyCode argument to Form_KeyDown event
' Shift:    Shift argument to Form_KeyDown event
' curform:  form receiving keystrokes

    Dim i As Integer

    If KeyCode = KEY_TAB And (Shift = CTRL_MASK Or Shift = (CTRL_MASK Or SHIFT_MASK)) Then
        For i = 0 To Forms.Count - 1
            If Forms(i) Is curform Then
                Exit For
            End If
        Next
        Do
            If Shift And SHIFT_MASK Then
                i = i - 1
                If i < 0 Then
                    i = Forms.Count - 1
                End If
            Else
                i = i + 1
                If i >= Forms.Count Then
                    i = 0
                End If
            End If
            If Forms(i) Is curform Then
                Exit Do
            End If
        Loop Until Len(Forms(i).Tag)
        If Not Forms(i) Is curform Then
            On Error Resume Next
            Forms(i).SetFocus
        End If
        KeyCode = 0
    End If
End Sub

Function hdllexcbk (ByVal evtstg As String, ByVal reqid As Integer) As Integer
' handle dictionary download callback
' evtstg:   event string
' reqid:    request ID (may be < 0)
' returns True if callback handled

    hdllexcbk = False
    If lexdlipg And reqid >= 0 And reqid = lexrqid Then
        lexrqid = -1
        hdllexcbk = True
    End If
End Function

Sub jmpmnuvis (ByVal Visible As Integer)
' set View/Jump To menu visibility

    mainform!mvsep1.Visible = Visible
    mainform!mvjump.Visible = Visible
End Sub

Sub loadflstpref ()
' load forum list mode preferences

    Dim tmps As String

    tmps = sreadpkv(FLSTMODEDPK)
    If Len(tmps) Then
        curlstmode = Val(itemidx(tmps, 0))
        curgrpstr = itemidx(tmps, 1)
    Else
        curlstmode = LSTMODEGRP
        curgrpstr = ""
    End If
End Sub

Sub loadprefs ()
' load preferences

    Dim elen As Integer, flen As Integer
    Dim epref As epreftyp
    Dim fpref As fpreftyp

    If sreadpk(PREFDPK, Len(prefs), prefs) < Len(prefs) Then
        convertflag = True
        elen = sreadpk(EPREFDPK, Len(epref), epref)
        flen = sreadpk(FPREFDPK, Len(fpref), fpref)
        prefs.sticky = SFMTBAR Or SRULER Or SRTBAR Or SWTBAR
        If elen Then
            prefs.flags = epref.flags And Not (PTBAR Or PREFLOW)
            If epref.flags And PTBAR Then
                prefs.sticky = prefs.sticky Or SMTBAR
            End If
            If epref.flags And PREFLOW Then
                prefs.sticky = prefs.sticky Or SREFLOW
            End If
            prefs.autofile = epref.autofile
            prefs.fwdee = epref.fwdee
            prefs.eattdir = epref.attdir
            If flen Then
                If fpref.flags And PDLATT Then
                    prefs.sticky = prefs.sticky Or SFDLATT
                End If
                If fpref.flags And PDSWNDN Then
                    prefs.sticky = prefs.sticky Or SDSWNDN
                End If
                prefs.fattdir = fpref.attdir
                prefs.curfor = fpref.curfor
            Else
                prefs.fattdir = ""
                prefs.curfor = ""
            End If
        ElseIf flen Then
            prefs.flags = fpref.flags And Not (PTBAR Or PREFLOW Or PDLATT)
            If fpref.flags And PTBAR Then
                prefs.sticky = prefs.sticky Or SMTBAR
            End If
            If fpref.flags And PREFLOW Then
                prefs.sticky = prefs.sticky Or SREFLOW
            End If
            If fpref.flags And PDLATT Then
                prefs.sticky = prefs.sticky Or SFDLATT
            End If
            If fpref.flags And PDSWNDN Then
                prefs.sticky = prefs.sticky Or SDSWNDN
            End If
            prefs.autofile = fpref.autofile
            prefs.fwdee = ""
            prefs.fattdir = fpref.attdir
            prefs.eattdir = ""
            prefs.curfor = fpref.curfor
        Else
            prefs.flags = PDLONC Or PPMTMT
            prefs.sticky = prefs.sticky Or SMTBAR
            prefs.fwdee = ""
            prefs.autofile = ""
            prefs.eattdir = ""
            prefs.fattdir = ""
            prefs.curfor = ""
        End If
        prefs.flag2 = P2PMTPO Or P2HIURL
        prefs.urlcolor = &HFF0000   ' bright blue
        prefs.onfgetsiz = 32
        prefs.flags = prefs.flags Or PSHOWCC Or PALWQUO
        If GetProfileInt("Intl", "iMeasure", 1) Then
            prefs.scaleunit = SCALE_INCH
        Else
            prefs.scaleunit = SCALE_CM
        End If
        prefs.fmttabsiz = 1440
        prefs.txttabsiz = 8
        prefs.fontpref(FPFMTWRT).name = "MS Sans Serif"
        prefs.fontpref(FPFMTWRT).size = 12
        prefs.fontpref(FPFMTWRT).color = 0&     'Black
        prefs.fontpref(FPFMTWRT).bold = False
        prefs.fontpref(FPFMTWRT).italic = False
        prefs.fontpref(FPFMTWRT).uline = False
        prefs.fontpref(FPFMTWRT).sthru = False
        prefs.fontpref(FPTXTWRT).name = "FixedSys"
        prefs.fontpref(FPTXTWRT).size = 9
        prefs.fontpref(FPTXTWRT).color = 0&
        prefs.fontpref(FPTXTWRT).bold = False
        prefs.fontpref(FPTXTWRT).italic = False
        prefs.fontpref(FPTXTWRT).uline = False
        prefs.fontpref(FPTXTWRT).sthru = False
        prefs.fontpref(FPTXTRD) = prefs.fontpref(FPTXTWRT)
        prefs.fontpref(FPMSGLST).name = "MS Sans Serif"
        prefs.fontpref(FPMSGLST).size = 8
        prefs.fontpref(FPMSGLST).color = 0&
        prefs.fontpref(FPMSGLST).bold = True
        prefs.fontpref(FPMSGLST).italic = False
        prefs.fontpref(FPMSGLST).uline = False
        prefs.fontpref(FPMSGLST).sthru = False
        prefs.fontpref(FPTHRLST) = prefs.fontpref(FPMSGLST)
        saveprefs
        junk = swrtdpkv(EPREFDPK, 0, 0)
        junk = swrtdpkv(FPREFDPK, 0, 0)
    End If
    junk = sreadpk(CKPRFDPK, Len(checkpref), checkpref)
    loadflstpref
End Sub

Sub lopmnuvis (ByVal Visible As Integer)
' set Options/List menu visibility

    mainform!mosep1.Visible = Visible
    mainform!molist.Visible = Visible
End Sub

Sub minmenu ()
' make all optional menu items invisible

    thrlstvis False
    tagmnuvis False
    mainform!mr_forop.Visible = False
    mainform!mosep1.Visible = False
    mainform!molist.Visible = False
    tbinvis mtbid, MTBALL
    tbvis mtbid, MTBMIN
    fixmtb
End Sub

Sub nosource ()
' clear source-related info

    cursource = SRCNONE
    clearlists
    minmenu
End Sub

Sub nothr (ByVal direc As Integer)
' generate no next/previous thread message

    Screen.MousePointer = DEFAULT
    Select Case direc
    Case READPREV
        popmsg "You have reached the first thread in this forum.", ""
    Case READNEXT
        popmsg "You have reached the last thread in this forum.", ""
    End Select
End Sub

Sub printfmt (ByVal hdrstr As String, tc As TextControl, ByVal ncpy As Integer)
' print formatted message
' hdrstr:   header string to add to beginning
' tc:       TextControl containing body
' ncpy:     number of copies to print

    Dim cpy As Integer, pg As Integer, margin As Integer
    Dim savpgw As Long, savpgh As Long
    Dim savmrgt As Long, savmrgb As Long
    Dim savmrgl As Long, savmrgr As Long
    Dim savdev As Integer, savss As Integer

    savpgw = tc.PageWidth
    savpgh = tc.PageHeight
    savmrgt = tc.PageMarginT
    savmrgb = tc.PageMarginB
    savmrgl = tc.PageMarginL
    savmrgr = tc.PageMarginR
    savdev = gettcdev(tc)
    savss = tc.SelStart
    winrefresh tc.hWnd, False
    tc.PageWidth = printer.Width
    tc.PageHeight = printer.Height
    tc.PageMarginT = DFTPMRG
    tc.PageMarginB = DFTPMRG
    pg = (printer.Width - printer.ScaleWidth) / 2
    If savpgw Then      'text is not "reflowed"
        margin = (printer.Width - (savpgw - savmrgl - savmrgr)) / 2
        If margin < pg Then
            margin = pg
        End If
    Else
        margin = pg
    End If
    tc.PageMarginL = margin
    tc.PageMarginR = margin
    If Len(hdrstr) Then
        hdrstr = strrpl(hdrstr, nl, Chr$(10))
        tc.SelStart = 0
        tc.SelLength = 0
        tc.SelText = hdrstr
        tc.SelStart = 0
        tc.SelLength = Len(hdrstr) - 1
        tc.FontName = "Courier"
        tc.FontSize = 12
        tc.FontBold = False
        tc.FontItalic = False
        tc.FontUnderline = False
        tc.FontStrikethru = False
        tc.Alignment = 0    'left justified
        tc.Indents(INDENT_LEFT) = 0
        tc.Indents(INDENT_RIGHT) = 0
        tc.Indents(INDENT_FIRST) = 0
        tc.SelLength = 0
    End If
    printer.Print
    For cpy = 1 To ncpy
        For pg = 1 To tc.CurrentPages
            tc.PrintDevice = printer.hDC
            tc.PrintPage = pg
            printer.NewPage
        Next
    Next
    printer.EndDoc
    If Len(hdrstr) Then
        tc.SelStart = 0
        tc.SelLength = Len(hdrstr)
        tc.SelText = ""
    End If
    tc.PageWidth = savpgw
    tc.PageHeight = savpgh
    tc.PageMarginT = savmrgt
    tc.PageMarginB = savmrgb
    tc.PageMarginL = savmrgl
    tc.PageMarginR = savmrgr
    settcdev tc, savdev
    tc.SelStart = savss
    winrefresh tc.hWnd, True
    tc.Refresh
End Sub

Sub saveflstpref ()
' save current forum list mode preferences

    junk = swrtdpkv(FLSTMODEDPK, STGLEN, CStr(CStr(curlstmode) & tb & curgrpstr))
End Sub

Sub saveprefs ()
' save preferences

    junk = swrtdpkv(PREFDPK, Len(prefs), prefs)
    junk = swrtdpkv(CKPRFDPK, Len(checkpref), checkpref)
End Sub

Sub savetofile (msg As msgdpk, ByVal plaintxt As String)
' save a message to a text file
' msg:      message to be saved
' plaintxt: plain-text version of message body

    Dim f As Integer, ok As Integer
    Dim info As String, hdr As String, oar As String
    Dim tmpmsg As message

    'get message strings
    LSet tmpmsg = msg
    info = RTrim$(msg.info)
    plaintxt = cvt4dsp(plaintxt, False)
    hdr = gethdrstr(tmpmsg, info)

    'get file name
    fdlgxchg.filename = ""
    Do
        oar = "O"
        fdlgxchg.CancelError = False
        fdlgxchg.DefaultExt = ""
        fdlgxchg.DialogTitle = "Save As Text"
        fdlgxchg.filter = "*.*"
        fdlgxchg.flags = OFN_NOREADONLYRETURN Or OFN_HIDEFILETYPE Or OFN_SHOWHELP
        fdlgxchg.helpcontext = API_SAVE_AS
        On Error Resume Next
        filedlg fdlgsave, "savetofile"
        If Err Then
            poperror "Error writing file:  " & Error$, ""
            Exit Sub
        ElseIf usrcancel Then
            Exit Sub
        End If
        protdoevt   'allow file dialog to finish unloading
        If fexist(fdlgxchg.filename, False) Then
            oar = formfunc(oarfrm, fdlgxchg.filename)
            If Len(oar) = 0 Then    'Cancel
                Exit Sub
            ElseIf oar = "R" Then
                protdoevt   'allow oarfrm to finish unloading
            End If
        End If
    Loop While oar = "R"    'Reselect

    'write out file
    ok = False
    On Error GoTo wrterr
    f = FreeFile
    If oar = "O" Then   'Overwrite
        Open fdlgxchg.filename For Output As f
    Else                'Append (oar = "A")
        Open fdlgxchg.filename For Append As f
        Print #f,
        Print #f,
    End If
    Print #f, hdr; plaintxt  'hdr always has blank line at end
    ok = True
wrterr:
    Close f
    If Not ok Then
        poperror "Error writing file:  " & Error$, ""
    End If
    Exit Sub
End Sub

Function scaleabbr (ByVal scaleunits As Integer) As String
' get abbreviation for scale unit

    Select Case scaleunits
    Case SCALE_MM
        scaleabbr = SUMM
    Case SCALE_CM
        scaleabbr = SUCM
    Case SCALE_INCH
        scaleabbr = SUIN
    End Select
End Function

Function scalefactor (ByVal scaleunits As Integer) As Double
' get conversion factor between twips and given scale units
' (scaleunits = scalefactor() * twips)

    Select Case scaleunits
    Case SCALE_MM
        scalefactor = 25.4 / 1440
    Case SCALE_CM
        scalefactor = 2.54 / 1440
    Case SCALE_INCH
        scalefactor = 1 / 1440
    End Select
End Function

Function selfont (ByVal fontstr As String) As String
' bring up select a font form and select a new font
' fontstr:  font parameters to initialize with
' returns font format string

    selfont = ""
    If actcap(mfontdlg, "selfont", fontstr) Then
        selfont = formxchg
    End If
End Function

Sub setadbmp (lstbox As Control, ByVal lidx As Integer, ByVal addr As String)
    Select Case addrtyp(addr)
    Case ISFORUM
        lstbox.Picture(lidx) = mainform!forumbmp
    Case ISPLIST
        lstbox.Picture(lidx) = mainform!plistbmp
    Case ISSLIST
        lstbox.Picture(lidx) = mainform!slistbmp
    Case ISLCLAD
        lstbox.Picture(lidx) = mainform!lcladbmp
    Case ISNETAD
        lstbox.Picture(lidx) = mainform!netadbmp
    End Select
End Sub

Sub setflstbmp (lstbox As Control, ByVal idx As Integer, ByVal axes As Integer)
' set list icon in list of forums
' lstbox:   list box to set icon in
' idx:      index of item to set for
' axes:     axes field of forum info structure

    If (axes And FISECHO) <> 0 Then
        lstbox.Picture(idx) = mainform!echobmp
    Else
        lstbox.Picture(idx) = mainform!forumbmp
    End If
End Sub

Sub setmsgidx (ByVal msgidx As Integer)
' highlight specified message in list of messages

    mainform!msglist.ListIndex = -1
    mainform!msglist.ListIndex = msgidx
End Sub

Sub settcdev (txtctl As TextControl, ByVal devtype As Integer)
' set output device for text control

    junk = sndmsg(txtctl.hWnd, TX_SETDEVICE, devtype, 0&)
End Sub

Sub showdetails (fdetfrm As Form, ByVal forum As String)
' show details on a forum
' fdetfrm: form to use to show details
' forum: name of forum to show details on

    Dim i As Integer
    Dim echostr As String
    Dim fdet() As viewfdpk

    If appconnect() Then
        Screen.MousePointer = HOURGLASS
        ReDim fdet(0)
        If sreadpk(FDETDPK & Trim$(forum), Len(fdet(0)), fdet(0)) <> 0 Then
            Load fdetfrm
            stpnls fdet(0).info
            fdetfrm.Caption = "Details on the " & Trim$(dblamp(getminf(fdet(0).info, FNAME))) & " Forum"
            fdetfrm!forop = dblamp(getminf(fdet(0).info, FFOROP))
            fdetfrm!topic = dblamp(getminf(fdet(0).info, FTOPIC))
            fdetfrm!nmsgs = fdet(0).nmsgs
            fdetfrm!nthrs = fdet(0).nthrs
            fdetfrm!nfils = fdet(0).nfiles
            fdetfrm!msglif = fdet(0).msglif
            fdetfrm!chgmsg = fdet(0).chgmsg
            fdetfrm!chgrdm = fdet(0).chgrdm
            fdetfrm!chgatt = fdet(0).chgatt
            fdetfrm!chgadl = fdet(0).chgadl
            fdetfrm!chgupk = fdet(0).chgupk
            fdetfrm!chgdpk = fdet(0).chgdpk
            If fdet(0).necho = 0 Then
                fdetfrm!echolst.Visible = False
                fdetfrm!echolbl.Visible = False
                fdetfrm!parmframe.Height = 2055
                applyoff fdetfrm!detframe, fdetfrm!parmframe, TOP2BOTTOM, -SAMEDIST
                applyoff fdetfrm!clsbtn, fdetfrm!detframe, TOP2BOTTOM, -DIFFDIST
                applyoff fdetfrm!hlpbtn, fdetfrm!detframe, TOP2BOTTOM, -DIFFDIST
                mdinisiz fdetfrm, fdetfrm.ScaleWidth, fdetfrm!hlpbtn.Top + fdetfrm!hlpbtn.Height + DIFFDIST
            Else
                echostr = getminf(fdet(0).info, FEADDRS)
                For i = 0 To fdet(0).necho - 1
                    fdetfrm!echolst.AddItem itemidxd(echostr, i, ";")
                Next
                fdetfrm!echolst.ListIndex = 0
                fdetfrm!echolbl.ForeColor = WINDOW_TEXT
            End If
            fdetfrm!detinfo = cvt4dsp(getminf(fdet(0).info, FDESC), True)
            Screen.MousePointer = DEFAULT
            fdetfrm.Show 1
        End If
        Erase fdet
        Screen.MousePointer = DEFAULT
    End If
End Sub

Sub stdmlcap (ByVal lstitle As String, ByVal lstname As String)
' set up standard message list captions (used by forums and filing cabinet)
' lstitle:  list title
' lstname:  name of thing listed

    mainform!lsttitle(0) = lstitle
    If Len(lstname) Then
        mainform!lstname(0).Left = mainform!lsttitle(0).Left + mainform!lsttitle(0).Width + SAMEDIST
        mainform!lstname(0) = dblamp(lstname)
    End If
    mainform!lsttitle(0).Visible = True
    mainform!lstname(0).Visible = Len(lstname) <> 0
    setmlntab 3
    mainform!caplbl(0).Caption = "From"
    mainform!caplbl(1).Caption = "To"
    mainform!caplbl(2).Caption = "Topic"
    mainform!caplbl(3).Caption = "Date"
End Sub

Sub stdmlfin ()
' do standard "finished listing messages" things

    mainform!msglist.ReFreshOnUpdate = True
    adjmsgtabs
    fixmtb
    caplblvis True
    Screen.MousePointer = DEFAULT
    On Error Resume Next
    mainform!msglist.SetFocus
End Sub

Sub stdmlsetup ()
' do standard setup to display list of forum messages

    Screen.MousePointer = HOURGLASS
    mainform!molstmsg.Checked = True
    mainform!molstthr.Checked = False
    mainform!msglist.ReFreshOnUpdate = False
    clearlists
    thrlstvis False
End Sub

Sub stdtlcap (ByVal lstitle As String, ByVal fornam As String)
' set up standard thread list titles and captions

    maxlstlbl = 1
    Load mainform!lsttitle(1)
    Load mainform!lstname(1)
    mainform!lsttitle(0) = lstitle
    mainform!lstname(0).Left = mainform!lsttitle(0).Left + mainform!lsttitle(0).Width + SAMEDIST
    mainform!lstname(0) = dblamp(fornam)
    mainform!lsttitle(1).Left = mainform!lstname(0).Left + mainform!lstname(0).Width + 2 * DIFFDIST
    mainform!lsttitle(1) = "Thread Topic:"
    mainform!lstname(1).Left = mainform!lsttitle(1).Left + mainform!lsttitle(1).Width + SAMEDIST
    mainform!lstname(1) = ""
    mainform!lsttitle(0).Visible = True
    mainform!lstname(0).Visible = True
    mainform!lsttitle(1).Visible = True
    mainform!lstname(1).Visible = True
    setmlntab 2
    mainform!caplbl(0).Caption = "Date"
    mainform!caplbl(1).Caption = "From"
    mainform!caplbl(2).Caption = "Excerpt"
End Sub

Sub stdtlfin ()
' do standard "finished thread list" things

    mainform!thrlist.ReFreshOnUpdate = True
    mainform!msglist.ReFreshOnUpdate = True
    adjthrtabs
    adjmsgtabs
    fixmtb
    mainform!caplbl(0).Visible = True
    mainform!caplbl(1).Visible = True
    mainform!caplbl(2).Visible = True
    Screen.MousePointer = DEFAULT
    On Error Resume Next
    If mainform!msglist.ListCount Then
        mainform!msglist.SetFocus
    Else
        mainform!thrlist.SetFocus
    End If
End Sub

Sub stdtlsetup (ByVal taggable As Integer)
' do standard setup to display thread list
' taggable: make thread tagging check boxes visible

    Screen.MousePointer = HOURGLASS
    mainform!molstmsg.Checked = False
    mainform!molstthr.Checked = True
    mainform!thrlist.ReFreshOnUpdate = False
    mainform!msglist.ReFreshOnUpdate = False
    clearlists
    If taggable Then
        mainform!thrlist.Left = -Screen.TwipsPerPixelX
        mainform!thrlbl.Left = mainform!chkon.Width + 3 * Screen.TwipsPerPixelX
    Else
        mainform!thrlist.Left = -(mainform!chkon.Width + 2 * Screen.TwipsPerPixelX)
        mainform!thrlbl.Left = 2 * Screen.TwipsPerPixelX
    End If
    mainform!thrlist.Tag = CStr(taggable)
    thrlstvis True
End Sub

Sub tagmnuvis (ByVal Visible As Integer)
' set visibility for message tag-related menu options

    mainform!mfgettag.Visible = Visible
    mainform!mftag.Visible = Visible
    mainform!mfclrtag.Visible = Visible
    mainform!mfsep3.Visible = Visible
End Sub

Sub thrlstvis (ByVal vis As Integer)
' change thrlist visibility

    mainform!mt_thread.Visible = vis
    mainform!mt_thread.Enabled = vis
    mainform!thrlist.Visible = vis
    mainform!thrcap.Visible = vis
    mainform!sepbar.Visible = vis
    If vis Then
        mainform!caplbl(0).Left = mainform!listpic(0).Width + 4 * Screen.TwipsPerPixelX
        adjsep
    Else
        mainform!caplbl(0).Left = mainform!listpic(0).Width + 3 * Screen.TwipsPerPixelX
        mainform!msglist.Left = -Screen.TwipsPerPixelX
        mainform!msgcap.Left = 0
        mainform!msglist.Width = mainform.ScaleWidth - mainform!msglist.Left + Screen.TwipsPerPixelX
        mainform!msgcap.Width = mainform.ScaleWidth
    End If
End Sub

Sub unldcap ()
' unload caption labels

    Dim i As Integer

    For i = 1 To maxcaplbl
        Unload mainform!caplbl(i)
    Next
    maxcaplbl = 0
    mainform!caplbl(0).Visible = False
End Sub

Sub unldlst ()
' unload list title/name labels

    Dim i As Integer

    For i = 1 To maxlstlbl
        Unload mainform!lstname(i)
        Unload mainform!lsttitle(i)
    Next
    maxlstlbl = 0
    mainform!lstname(0).Visible = False
    mainform!lsttitle(0).Visible = False
End Sub

Sub wincascade ()
' cascade the three primary windows

    Dim newtop As Integer, newleft As Integer
    Dim newwidth As Integer, newheight As Integer
    Dim numwins As Integer

    numwins = 0
    If isloaded(rdmsg) Then
        If Len(rdmsg.Tag) Then
            numwins = numwins + 1
        End If
    End If
    If isloaded(wrtedt) Then
        If Len(wrtedt.Tag) Then
            numwins = numwins + 1
        End If
    End If
    Select Case msgactivewin
    Case READACTIVE
        newtop = validposval(rdmsg.Top - (numwins * frmtopofs))
        newleft = validposval(rdmsg.Left - (numwins * frmlftofs))
        newwidth = rdmsg.Width
        newheight = rdmsg.Height
        docascade mainform, newtop, newleft, newwidth, newheight, RDMINSCW, rdmsg!bodytext.Top
        If isloaded(wrtedt) Then
            docascade wrtedt, newtop, newleft, newwidth, newheight, WTMINSCW, wrtedt!bodytext.Top
        End If
        docascade rdmsg, newtop, newleft, newwidth, newheight, MINLSTW, mainform!msglist.Top
    Case WRITACTIVE
        newtop = validposval(wrtedt.Top - (numwins * frmtopofs))
        newleft = validposval(wrtedt.Left - (numwins * frmlftofs))
        newwidth = wrtedt.Width
        newheight = wrtedt.Height
        docascade mainform, newtop, newleft, newwidth, newheight, MINLSTW, mainform!msglist.Top
        If isloaded(rdmsg) Then
            docascade rdmsg, newtop, newleft, newwidth, newheight, RDMINSCW, rdmsg!bodytext.Top
        End If
        docascade wrtedt, newtop, newleft, newwidth, newheight, WTMINSCW, wrtedt!bodytext.Top
    Case Else
        newtop = validposval(mainform.Top - (numwins * frmtopofs))
        newleft = validposval(mainform.Left - (numwins * frmlftofs))
        newwidth = mainform.Width
        newheight = mainform.Height
        If isloaded(rdmsg) Then
            docascade rdmsg, newtop, newleft, newwidth, newheight, RDMINSCW, rdmsg!bodytext.Top
        End If
        If isloaded(wrtedt) Then
            docascade wrtedt, newtop, newleft, newwidth, newheight, WTMINSCW, wrtedt!bodytext.Top
        End If
        docascade mainform, newtop, newleft, newwidth, newheight, MINLSTW, mainform!msglist.Top
    End Select
End Sub

Sub winmenus ()
' adjust Window menu visibility

    Dim rvis As Integer, wvis As Integer, ovis As Integer

    rvis = False
    wvis = False
    ovis = False
    If isloaded(rdmsg) Then
        rvis = Len(rdmsg.Tag) <> 0
    End If
    If isloaded(wrtedt) Then
        wvis = Len(wrtedt.Tag) <> 0
    End If
    If isloaded(outbox) Then
        ovis = Len(outbox.Tag) <> 0
    End If
    If rvis Or wvis Or ovis Then
        mainform!mw_win.Visible = True
        mainform!mwread.Visible = rvis
        mainform!mwwrite.Visible = wvis
        mainform!mwoutbx.Visible = ovis
        If rvis Then
            rdmsg!mwwrite.Visible = wvis
            rdmsg!mwoutbx.Visible = ovis
        End If
        If wvis Then
            wrtedt!mwread.Visible = rvis
            wrtedt!mwoutbx.Visible = ovis
        End If
    Else
        mainform!mw_win.Visible = False
    End If
End Sub

Sub wintile (ByVal posn As Integer)
' tile the three primary windows
' posn: tile vertical or horizontal

    Dim newpos As Integer, heights As Integer
    Dim amtdiv As Integer, widths As Integer

    newpos = 0
    amtdiv = 1
    If isloaded(rdmsg) Then
        If Len(rdmsg.Tag) Then
            amtdiv = amtdiv + 1
        End If
    End If
    If isloaded(wrtedt) Then
        If Len(wrtedt.Tag) Then
            amtdiv = amtdiv + 1
        End If
    End If
    Select Case posn
    Case WINTILEVERT
        heights = Screen.Height / amtdiv
        widths = Screen.Width
    Case WINTILEHORZ
        heights = Screen.Height
        widths = Screen.Width / amtdiv
    End Select
    mainform.WindowState = NORMAL
    mainform.Height = heights
    mainform.Width = widths
    mainform.Top = 0
    mainform.Left = 0
    If posn = WINTILEVERT Then
        newpos = newpos + mainform.Height
    Else
        newpos = newpos + mainform.Width
    End If
    If isloaded(rdmsg) Then
        If Len(rdmsg.Tag) Then
            rdmsg.WindowState = NORMAL
            rdmsg.Height = heights
            rdmsg.Width = widths
            If posn = WINTILEVERT Then
                rdmsg.Top = newpos
                rdmsg.Left = 0
                newpos = newpos + rdmsg.Height
            Else
                rdmsg.Top = 0
                rdmsg.Left = newpos
                newpos = newpos + rdmsg.Width
            End If
        End If
    End If
    If isloaded(wrtedt) Then
        If Len(wrtedt.Tag) Then
            wrtedt.WindowState = NORMAL
            wrtedt.Height = heights
            wrtedt.Width = widths
            If posn = WINTILEVERT Then
                wrtedt.Top = newpos
                wrtedt.Left = 0
            Else
                wrtedt.Left = newpos
                wrtedt.Top = 0
            End If
        End If
    End If
End Sub

Sub accrdbeg (ByVal accflgs As Integer)
' fire off asynch reads to get access, wait until they're done
' accflgs: which parts to initialize

    If initipg Then
        Exit Sub
    End If
    emlaccrid = -1
    foraccrid = -1
    carrid = -1
    numcar = 0
    initflgs = 0
    initipg = True
    acc2get = accflgs
    junk = readpk(ALIASDPK, 0)  ' update it in primary cache if connected
    emlaccrid = readpk(EACCDPK, mainform!initcbk)
    If accflgs And FORAPP Then
        foraccrid = readpk(FORACC, mainform!initcbk)
    End If
    carrid = rgtdpk(wtspace(CARDPK), wtspace(CARMIN), -1, mainform!initcbk)
End Sub

Function accrdfin () As Integer
' wait for access initialization dpk reads to finish
' returns flags that indicate what got initialized

    While emlaccrid >= 0 Or foraccrid >= 0
        DoEvents
    Wend
    initipg = False
    accrdfin = initflgs
End Function

Function actcap (frm As Form, ByVal act As String, ByVal parm As String) As Integer
'act on a form's capability
'   returns True if successful
'   frm:    form to perform action
'   act:    action to perform
'   parm:   action parameters

    capfail = False
    capargs = parm
    frm!action.Caption = act
    frm!action.Value = True
    capargs = ""
    actcap = Not capfail
End Function

Sub adjsep ()
' adjust width/position of lists and separator due to sepbar move

    applyoff mainform!thrlist, mainform!sepbar, RIGHT2LEFT, -Screen.TwipsPerPixelX
    applyoff mainform!msglist, mainform!sepbar, LEFT2RIGHT, Screen.TwipsPerPixelX
    mainform!msglist.Width = mainform.ScaleWidth - mainform!msglist.Left + Screen.TwipsPerPixelX
    mainform!msgcap.Left = mainform!msglist.Left
    mainform!msgcap.Width = mainform.ScaleWidth - mainform!msgcap.Left
    mainform!thrcap.Width = mainform!thrlist.Width + mainform!thrlist.Left
End Sub

