'****************************************************************************
'*                                                                          *
'*  MSGAPI.BAS                                                              *
'*                                                                          *
'*  Copyright (c) 1994-1997 Galacticomm, Inc.    All Rights Reserved.       *
'*                                                                          *
'*  API-type functions used by C/S mail app.                                *
'*                                                                          *
'*                                                  - J. Alvrus 11/28/95    *
'*                                                                          *
'****************************************************************************

Option Explicit

' readmsg() direction codes
Global Const READPREV = -1          ' read previous message
Global Const READTHIS = 0           ' read specified message
Global Const READNEXT = 1           ' read next message

' readmsg() source codes
Global Const SRCNONE = 0            ' no source
Global Const SRCFILCAB = 1          ' Filing Cabinet folder
Global Const SRCEINBOX = 2          ' E-mail in box
Global Const SRCPOSTOFC = 3         ' E-mail post office
Global Const SRCFORUM = 4           ' Messages in a forum
Global Const SRCTHREAD = 5          ' Messages in a thread
Global Const SRCUNAPV = 6           ' Messages in a forum with unapproved attachments
Global Const SRCONLSCN = 7          ' Online forum scan
Global Const SRCOFLMSG = 8          ' Offline forum messages
Global Const SRCOFLTHR = 9          ' Offline forum threads

' read form formxchg item indices
Global Const RDICAP = 0             ' form caption
Global Const RDIBTN = 1             ' button flags
Global Const RDIABL = 2             ' ability flags
Global Const RDIMID = 3             ' message ID string
Global Const RDISRC = 4             ' source ID

' read form navigation button flags
Global Const RDBNONE = 0            ' no navigation buttons
Global Const RDBNXTPRV = &H1        ' show next/previous buttons
Global Const RDBTHREAD = &H2        ' show thread buttons
Global Const RDBBKTRAK = &H4        ' show backtrack button
Global Const RDBJUMP = &H8          ' show jump buttons
Global Const RDBNPTHR = &H10        ' show go to next/previous thread buttons
Global Const RDBALL = RDBNXTPRV Or RDBTHREAD Or RDBBKTRAK Or RDBJUMP

' read form capability flags
Global Const RDCNONE = 0            ' no additional capabilities
Global Const RDCDEL = &H1           ' can delete message
Global Const RDCSILENT = &H2        ' don't generate "you've reached first/last message" messages
Global Const RDCENUM = &H4          ' show "#X of Y" for message
Global Const RDCFOROP = &H8         ' enable Forum-Op options
Global Const RDCEDTNT = &H10        ' can view/edit comments for message

' jumpto() destination codes
Global Const JUMPFRST = -1          ' jump to first message
Global Const JUMPSPEC = 0           ' jump to specific message
Global Const JUMPLAST = 1           ' jump to last message

' hidden list info item index constants
Global Const MLI_FLAGS = 0          ' message info flags (not the same as msg.flags)
Global Const MLI_THRIDX = 1         ' thread list-to-array cross reference
Global Const MLI_TMSGID = 1         ' offline forum message list message ID index

' hidden info flags constants
Global Const MLF_PRIMSG = &H1       ' message is "priority"
Global Const MLF_READ = &H2         ' message has been read
Global Const MLF_FORUM = &H4        ' message is a forum message (not E-mail)
Global Const MLF_TAGGED = &H8       ' message/thread has been tagged
Global Const MLF_RECREQ = &H10      ' message has return-receipt requested
Global Const MLF_TGABLE = &H20      ' message/thread is taggable
Global Const MLF_FILATT = &H40      ' message has attachment
Global Const MLF_MSGMASK = MLF_PRIMSG Or MLF_RECREQ Or MLF_FILATT
Global Const MLF_MLFMASK = MLF_PRIMSG Or MLF_READ Or MLF_FORUM Or MLF_TAGGED Or MLF_RECREQ Or MLF_TGABLE Or MLF_FILATT

' main form list resizing constants
Const EFRTABPCT! = 40 / 100
Const UTOTABPCT! = 30 / 110
Const TPCTABPCT! = 60 / 110
Const FFRTABPCT! = 30 / 100
Const SFRTABPCT! = 15 / 125
Const STOTABPCT! = 45 / 125
Const STPTABPCT! = 75 / 125
Global Const MINLSTW = 960

Global srcfrm As drawfrm            ' source form for drawing envelopes

Function abtonact () As Integer
' abort ongoing activity (if any)
' returns False if context change should be aborted

    abtonact = True
    Select Case cursource
    Case SRCUNAPV
        abtonact = unaabtact()
    Case SRCONLSCN
        abtonact = scnabtact()
    End Select
End Function

Sub adjmsgtabs ()
' adjust message list tabs due to change in list box size

    Dim lstw As Integer, tmpw As Integer, tmpx As Integer

    lstw = getlbwidth(mainform!msglist) - mainform!listpic(0).Width - SAMEDIST
    If lstw < 3 * MINLSTW Then
        lstw = 3 * MINLSTW
    End If
    tmpw = lstw - datew - SAMEDIST
    Select Case cursource
    Case SRCEINBOX, SRCPOSTOFC
        mainform!msglist.TabPos(0) = datew + DIFFDIST
        mainform!caplbl(1).Left = mainform!caplbl(0).Left + mainform!msglist.TabPos(0)
        mainform!msglist.TabPos(1) = mainform!msglist.TabPos(0) + lstw * EFRTABPCT
        mainform!caplbl(2).Left = mainform!caplbl(0).Left + mainform!msglist.TabPos(1)
    Case SRCTHREAD, SRCOFLTHR
        mainform!msglist.TabPos(0) = datew + DIFFDIST
        mainform!caplbl(1).Left = mainform!caplbl(0).Left + mainform!msglist.TabPos(0)
        mainform!msglist.TabPos(1) = mainform!msglist.TabPos(0) + lstw * FFRTABPCT
        mainform!caplbl(2).Left = mainform!caplbl(0).Left + mainform!msglist.TabPos(1)
    Case SRCONLSCN
        tmpx = tmpw * SFRTABPCT
        mainform!msglist.TabPos(0) = tmpx
        mainform!caplbl(1).Left = mainform!caplbl(0).Left + tmpx
        tmpx = tmpw * STOTABPCT
        mainform!msglist.TabPos(1) = tmpx
        mainform!caplbl(2).Left = mainform!caplbl(0).Left + tmpx
        tmpx = tmpw * STPTABPCT
        mainform!msglist.TabPos(2) = tmpx
        mainform!caplbl(3).Left = mainform!caplbl(0).Left + tmpx
        mainform!msglist.TabPos(3) = tmpw
        mainform!caplbl(4).Left = mainform!caplbl(0).Left + tmpw
    Case SRCFORUM, SRCOFLMSG, SRCUNAPV
        tmpx = tmpw * UTOTABPCT
        mainform!msglist.TabPos(0) = tmpx
        mainform!caplbl(1).Left = mainform!caplbl(0).Left + tmpx
        tmpx = tmpw * TPCTABPCT
        mainform!msglist.TabPos(1) = tmpx
        mainform!caplbl(2).Left = mainform!caplbl(0).Left + tmpx
        mainform!msglist.TabPos(2) = tmpw
        mainform!caplbl(3).Left = mainform!caplbl(0).Left + tmpw
    Case SRCFILCAB
        tmpx = tmpw * UTOTABPCT
        mainform!msglist.TabPos(0) = tmpx
        mainform!caplbl(1).Left = mainform!caplbl(0).Left + tmpx
        tmpx = tmpw * TPCTABPCT
        mainform!msglist.TabPos(1) = tmpx
        mainform!caplbl(2).Left = mainform!caplbl(0).Left + tmpx
        mainform!msglist.TabPos(2) = tmpw
        mainform!caplbl(3).Left = mainform!caplbl(0).Left + tmpw
    End Select
End Sub

Sub adjrdbtn ()
' adjust enabling of buttons on read forms

    Dim i As Integer

    For i = 0 To forms.Count - 1
        If TypeOf forms(i) Is rdmsg Then
            junk = actcap(forms(i), "adjbtn", "")
        End If
    Next
End Sub

Sub adjthrtabs ()
' adjust thread list tabs due to change in list box size

    Dim lstw As Integer, tmpx As Integer

    lstw = getlbwidth(mainform!thrlist) - mainform!chkoff.Width - SAMEDIST
    If lstw < 2 * MINLSTW Then
        lstw = 2 * MINLSTW
    End If
    setffont mainform, mainform!thrlist
    tmpx = lstw - mainform.TextWidth("0000") - screen.TwipsPerPixelX
    mainform!thrlist.TabPos(0) = tmpx
    mainform!nmsglbl.Left = mainform!thrlbl.Left + tmpx
End Sub

Function aprvmsg (ByVal source As Integer, ByVal msgidstr As String, ByVal setto As Integer) As Integer
' approve attachment to a message
' source:   message source in effect
' msgidstr: message ID string
' setto:    True to approve, False to unapprove
' returns True if successful

    aprvmsg = False
    Select Case source
    Case SRCFORUM, SRCTHREAD, SRCUNAPV
        aprvmsg = onapvmsg(source, msgidstr, setto)
    Case SRCONLSCN
        aprvmsg = scnapvmsg(msgidstr, setto)
    End Select
End Function

Function candel (msg As msgdpk, ByVal source As Integer) As Integer
' can user delete this message (from read form)
' msg:      dynapak form of message
' source:   source ID

    Dim smsg As msgdpkshrt

    candel = False
    Select Case source
    Case SRCEINBOX
        candel = ibxcandel(msg)
    Case SRCPOSTOFC
        candel = pocandel(msg)
    Case SRCFORUM, SRCTHREAD, SRCUNAPV, SRCONLSCN
        LSet smsg = msg
        candel = forcandel(smsg)
    Case SRCOFLMSG, SRCOFLTHR
        candel = ofcandel(msg)
    Case SRCFILCAB
        candel = True
    End Select
End Function

Function candell (ByVal source As Integer, ByVal lstidx As Integer) As Integer
' can user delete this message (from list)
' source:   source in effect
' lstidx:   index in message list of messages

    candell = False
    Select Case source
    Case SRCEINBOX, SRCPOSTOFC, SRCOFLMSG, SRCOFLTHR, SRCFILCAB
        candell = True
    Case SRCFORUM, SRCTHREAD, SRCUNAPV
        candell = oncandell(lstidx)
    Case SRCONLSCN
        candell = scncandell(lstidx)
    End Select
End Function

Function canread (ByVal msgidstr As String, ByVal direc As Integer, ByVal source As Integer) As Integer
' can user read message in specified direction?
' msgidstr: identifier of current message (updated if successful)
' direc:    direction to read (-1=prev, 0=exact, 1=next)
' source:   code indicating where to read message from

    canread = False
    Select Case source
    Case SRCEINBOX
        canread = ibxcanread(msgidstr, direc)
    Case SRCPOSTOFC
        canread = pocanread(msgidstr, direc)
    Case SRCFORUM
        canread = oncanread(msgidstr, direc)
    Case SRCUNAPV
        canread = unacanread(msgidstr, direc)
    Case SRCONLSCN
        canread = scncanread(msgidstr, direc)
    Case SRCOFLMSG
        canread = ofcanread(msgidstr, direc)
    Case SRCFILCAB
        canread = fccanread(msgidstr, direc)
    End Select
End Function

Function canthread (ByVal msgidstr As String, ByVal fornam As String, ByVal msgid As Long, ByVal thrid As Long, rplto As globid, ByVal direc As Integer, ByVal source As Integer) As Integer
' check for message in a thread function
' msgidstr: identifier of current message
' fornam:   forum name or "" if email
' msgid:    current message ID
' thrid:    current thread ID
' rplto:    reply-to ID of current message
' direc:    direction to read (-1=prev, 0=parent, 1=next)
' source:   code indicating where to read message from
' returns:  True if message available

    canthread = False
    Select Case source
    Case SRCEINBOX, SRCPOSTOFC
        canthread = emlcanthread(msgidstr, fornam, msgid, thrid, rplto, direc)
    Case SRCFORUM, SRCTHREAD, SRCUNAPV, SRCONLSCN, SRCOFLMSG, SRCOFLTHR
        If direc = READTHIS Then
            canthread = rplto.sysid <> 0 And rplto.msgid <> 0
        Else
            canthread = True
        End If
    End Select
End Function

Function delmsg (ByVal msgidstr As String, ByVal source As Integer) As Integer
' delete a message function and update appropriate list
' msgidstr: message ID string of message to delete
' source:   source ID of message
' returns True if message deleted

    Dim i As Integer, delflg As Integer

    delflg = False
    Select Case source
    Case SRCEINBOX
        delflg = ibxdelmsg(msgidstr)
    Case SRCPOSTOFC
        delflg = podelmsg(msgidstr)
    Case SRCFORUM, SRCTHREAD, SRCUNAPV
        delflg = ondelmsg(msgidstr, source)
    Case SRCOFLMSG, SRCOFLTHR
        delflg = ofdelmsg(msgidstr, source)
    Case SRCONLSCN
        delflg = scndelmsg(msgidstr)
    Case SRCFILCAB
        delflg = fcdelmsg(msgidstr)
    End Select
    If delflg Then
        adjrdbtn
        fixmtb
    End If
    delmsg = delflg
End Function

Sub drawenv (ByVal basex As Integer, ByVal flags As Integer, ByVal grayback As Integer)
' draw an envelop icon with appropriate characteristics
' basex:    X coordinate of left edge of envelop
' flags:    flags indicating attachment, return receipt, etc.
' grayback: background is gray (vs. white)

    If flags And MLF_FORUM Then
        junk = bitblt(drawfrm.hDC, basex, 0, 26, 14, srcfrm.hDC, 35, 0, &HCC0020)
        If flags And MLF_READ Then
            junk = bitblt(drawfrm.hDC, basex + 17, 0, 12, 14, srcfrm.hDC, 61, 0, &HCC0020)
        End If
    Else
        junk = bitblt(drawfrm.hDC, basex, 0, 25, 14, srcfrm.hDC, 0, 0, &HCC0020)
        If flags And MLF_READ Then
            junk = bitblt(drawfrm.hDC, basex + 21, 0, 10, 15, srcfrm.hDC, 25, 0, &HCC0020)
        Else
            If flags And MLF_RECREQ Then
                junk = bitblt(drawfrm.hDC, basex + 15, 0, 8, 14, srcfrm.hDC, 79, 0, &HCC0020)
            End If
            If flags And MLF_PRIMSG Then
                If grayback Then
                    junk = bitblt(drawfrm.hDC, basex + 26, 1, 4, 12, srcfrm.hDC, 113, 0, &HCC0020)
                Else
                    junk = bitblt(drawfrm.hDC, basex + 26, 1, 4, 12, srcfrm.hDC, 87, 0, &HCC0020)
                End If
            End If
        End If
    End If
    If flags And MLF_FILATT Then
        junk = bitblt(drawfrm.hDC, basex + 2, 0, 6, 14, srcfrm.hDC, 73, 0, &HCC0020)
    End If
End Sub

Function enumstr (ByVal msgidstr As String, ByVal source As Integer) As String
' get enumeration string (e.g. "#1 of 2") given message ID string and source ID
' msgidstr: identifier of current message
' source:   code indicating where message was read from

    enumstr = ""
    Select Case source
    Case SRCOFLMSG
        enumstr = ofenumstr(msgidstr)
    End Select
End Function

Function exmtmsg (ByVal source As Integer, ByVal msgidstr As String, ByVal setto As Integer) As Integer
' exempt a message from auto-delete
' source:   message source in effect
' msgidstr: message ID string
' setto:    True to exempt, False to unexempt
' returns True if successful

    exmtmsg = False
    Select Case source
    Case SRCFORUM, SRCTHREAD, SRCUNAPV
        exmtmsg = onxmtmsg(source, msgidstr, setto)
    Case SRCONLSCN
        exmtmsg = scnxmtmsg(msgidstr, setto)
    End Select
End Function

Sub fixmtb ()
' fix enabling of main form toolbar buttons

    Dim state As Integer, totalsel As Integer
    Dim index As Integer

    chkreload
    state = UPDISABLED
    totalsel = mainform!msglist.SelectCount
    If totalsel Then
        tbsetbutstt mtbid, MTB_FILEIT, UP
        state = UP
        For index = 0 To totalsel - 1
            If Not candell(cursource, mainform!msglist.ListIndexMulti(index)) Then
                state = UPDISABLED
                Exit For
            End If
        Next index
    Else
        tbsetbutstt mtbid, MTB_FILEIT, UPDISABLED
    End If
    tbsetbutstt mtbid, MTB_DELETE, state
    state = UPDISABLED
    If mainform!msglist.ListCount Then
        state = UP
    End If
    tbsetbutstt mtbid, MTB_JFIRST, state
    tbsetbutstt mtbid, MTB_JSPEC, state
    tbsetbutstt mtbid, MTB_JLAST, state
End Sub

Function getnotes (ByVal msgidstr As String, ByVal source As Integer) As String
' get inbox or filecabinet notes associated with a message
' msgidstr: message ID string of message to delete
' source:   source ID of message
' returns comments if any exist

    Dim wrkstr As String, tmpdpk As String

    wrkstr = ""
    Select Case source
    Case SRCEINBOX
        tmpdpk = IBXNOTDPK & Format$(Val(msgidstr), MNMFMT)
        wrkstr = sreadpkv(tmpdpk)
    Case SRCFILCAB
        wrkstr = sreadpkv(FCBNOTDPK & msgidstr)
    End Select
    getnotes = wrkstr
End Function

Sub gotmsgtg (ByVal fornam As String, ByVal msgid As Long)
' finished getting a tagged message, clear list tag
' fornam:   name of forum thread is in
' msgid:    message ID that's been gotten

    Select Case cursource
    Case SRCFORUM, SRCTHREAD
        onupdmtg fornam, msgid
    Case SRCONLSCN
        scnupdmtg fornam, msgid
    End Select
End Sub

Sub gotthrtg (ByVal fornam As String, ByVal thrid As Long)
' finished getting a tagged thread, clear list tags
' fornam:   name of forum thread is in
' forum:    forum ID of thread
' thrid:    thread ID that's been gotten

    Select Case cursource
    Case SRCTHREAD
        ontupdtgs fornam, thrid
    Case SRCFORUM
        onupdtgs fornam
    Case SRCONLSCN
        scnupdtgs
    End Select
End Sub

Sub hdlclarpl (ByVal msgid As Long)
' handle clear-after-reply preference

    If prefs.flags And PCLARPL Then
        ibxclarpl msgid
    End If
End Sub

Function infostg (ByVal lbitem As String) As String
' get hidden information from list box item

    infostg = itemidx(lbitem, itemcnt(lbitem) - 1)
End Function

Function infostgitem (ByVal istg As String, ByVal idx As Integer)
' get specified item from an info string

    infostgitem = itemidxd(istg, idx, FLDSEP)
End Function

Sub initcclist (cclist As String, ByVal orgtxt As String, ByVal msgto As String)
' initialize cc: list given original message text
' cclist:   cc: list string to initialize
' orgtxt:   plain-text version of original message body to extract to: and cc:
'           (line terminator must be single Chr$(10)s)
' msgto:    to address of message being sent

    Dim i As Integer, naddr As Integer
    Dim foundcc As Integer
    Dim bol As Long
    Dim addrarr() As String, tmps As String

    cclist = ""
    If Right$(orgtxt, 1) = Chr$(10) Then
        orgtxt = Left$(orgtxt, Len(orgtxt) - 1)
    End If
    naddr = 0
    foundcc = False
    bol = Len(orgtxt)
    Do While bol > 0
        Do While bol > 0
            If Mid$(orgtxt, bol, 1) = Chr$(10) Then
                Exit Do
            End If
            bol = bol - 1
        Loop
        ReDim Preserve addrarr(naddr)
        addrarr(naddr) = Mid$(orgtxt, bol + 1)
        i = naddr
        naddr = naddr + 1
        bol = bol - 1
        If bol > 0 Then
            orgtxt = Left$(orgtxt, bol)
        End If
        tmps = Left$(addrarr(i), 1)
        If tmps = " " Or tmps = Chr$(KEY_TAB) Then
            If foundcc Then
                naddr = naddr - 1
                Exit Do
            End If
            While Left$(addrarr(i), 1) = Chr$(KEY_TAB)
                addrarr(i) = Mid$(addrarr(i), 2)
            Wend
            addrarr(i) = Trim$(addrarr(i))
        ElseIf sameto("cc:", addrarr(i)) Then
            If foundcc Then
                naddr = naddr - 1
                Exit Do
            End If
            foundcc = True
            addrarr(i) = Trim$(Mid$(addrarr(i), Len("cc:") + 1))
            While Left$(addrarr(i), 1) = Chr$(KEY_TAB)
                addrarr(i) = Mid$(addrarr(i), 2)
            Wend
            addrarr(i) = Trim$(addrarr(i))
        ElseIf sameto("to:", addrarr(i)) Then
            addrarr(i) = Trim$(Mid$(addrarr(i), Len("to:") + 1))
            While Left$(addrarr(i), 1) = Chr$(KEY_TAB)
                addrarr(i) = Mid$(addrarr(i), 2)
            Wend
            addrarr(i) = Trim$(addrarr(i))
            Exit Do
        Else
            naddr = naddr - 1
            Exit Do
        End If
    Loop
    If foundcc And naddr > 0 Then
        cclist = addrarr(naddr - 1)
        For i = naddr - 2 To 0 Step -1
            cclist = cclist & "; " & addrarr(i)
        Next
        For i = 0 To itemcntd(cclist, ";") - 1
            tmps = Trim$(itemidxd(cclist, i, ";"))
            If sameas(tmps, msgto) Or sameas(tmps, curuid()) Then
                cclist = Trim$(itemdeld(cclist, i, ";"))
                Exit For
            End If
        Next
    End If
    Erase addrarr
End Sub

Sub initmodify (omsg As obxmem, dmsg As msgdpk)
' initialize outbox message structure for modify
'   omsg    - outbox structure to fill in
'   dmsg    - message structure to use as source

    omsg.flags = ISMODIFY
    setflg isrtf(getminf(dmsg.info, TEXTFLD)), omsg.flags, FMTTEXT
    omsg.axes = dmsg.axes
    omsg.fornam = dmsg.fornam
    omsg.msghdr.orgfor = dmsg.forum
    omsg.msghdr.forum = dmsg.forum
    omsg.msghdr.msgid = dmsg.msgid
    omsg.msghdr.gmid = dmsg.gmid
    omsg.msghdr.thrid = dmsg.thrid
    omsg.msghdr.attname = dmsg.attname
    omsg.msghdr.flags = dmsg.flags
    omsg.info = dmsg.info
End Sub

Sub initnewmsg (omsg As obxmem, ByVal forum As Integer, ByVal fornam As String, ByVal axes As Integer, ByVal toaddr As String)
' initialize new message structure with default stuff

    omsg.flags = 0
    If prefs.flags And PSHOWCC Then
        omsg.flags = omsg.flags Or APNDCC
    End If
    If prefs.flags And PALWQUO Then
        omsg.flags = omsg.flags Or QUOTMSG
    End If
    If (prefs.flags And PLAINTXT) = 0 Then
        omsg.flags = omsg.flags Or FMTTEXT
    End If
    omsg.axes = Chr$(axes)
    omsg.msghdr.orgfor = forum
    omsg.msghdr.forum = forum
    omsg.msghdr.msgid = 0&
    omsg.msghdr.gmid.sysid = 0&
    omsg.msghdr.gmid.msgid = 0&
    omsg.msghdr.thrid = 0&
    omsg.msghdr.attname = ""
    omsg.msghdr.flags = 0
    omsg.fornam = fornam
    omsg.info = ""
    omsg.info = setminf(omsg.info, toaddr, TOFLD)
    omsg.info = setminf(omsg.info, OBXDFT, FILEIN)
End Sub

Sub initreply (omsg As obxmem, cclist As String, dmsg As msgdpk, ByVal orgtxt As String)
' initialize new message structure for reply
'   omsg    - outbox structure to fill in
'   cclist  - cc: list string to initialize
'   dmsg    - message structure to use as source
'   orgtxt  - plain-text version of original message body to extract to: and cc:
'             (line terminator must be single Chr$(10)s)

    omsg.flags = ISREPLY
    If prefs.flags And PSHOWCC Then
        omsg.flags = omsg.flags Or APNDCC
    End If
    If prefs.flags And PALWQUO Then
        omsg.flags = omsg.flags Or QUOTMSG
    End If
    If (prefs.flags And PLAINTXT) = 0 Then
        omsg.flags = omsg.flags Or FMTTEXT
    End If
    If dmsg.forum = EMLID Then
        omsg.axes = Chr$(emlacc.flags)
    Else
        omsg.axes = getaxes(Trim$(dmsg.fornam), Asc(dmsg.axes))
    End If
    omsg.msghdr.orgfor = dmsg.forum
    omsg.msghdr.forum = dmsg.forum
    omsg.msghdr.msgid = dmsg.msgid
    omsg.msghdr.gmid = dmsg.gmid
    omsg.msghdr.thrid = dmsg.thrid
    omsg.msghdr.attname = ""
    omsg.msghdr.flags = 0
    omsg.fornam = dmsg.fornam
    omsg.info = RTrim$(dmsg.info)
    omsg.info = setminf(omsg.info, "", ATTPATH)
    omsg.info = setminf(omsg.info, getminf(dmsg.info, FROMFLD), TOFLD)
    omsg.info = setminf(omsg.info, OBXDFT, FILEIN)
    initcclist cclist, orgtxt, getminf(omsg.info, TOFLD)
End Sub

Sub initresend (omsg As obxmem, cclist As String, dmsg As msgdpk, ByVal orgtxt As String)
' initialize new message structure for resend
'   omsg    - outbox structure to fill in
'   cclist  - cc: list string to initialize
'   dmsg    - message structure to use as source
'   orgtxt  - plain-text version of original message body to extract to: and cc:
'             (line terminator must be single Chr$(10)s)

    Dim tmpfinf As foruminf

    initnewmsg omsg, EMLID, "", Asc(dmsg.axes), ""
    setflg isrtf(getminf(dmsg.info, TEXTFLD)), omsg.flags, FMTTEXT
    omsg.info = RTrim$(dmsg.info)
    omsg.info = setminf(omsg.info, "", ATTPATH)
    omsg.info = setminf(omsg.info, OBXDFT, FILEIN)
    initcclist cclist, orgtxt, getminf(omsg.info, TOFLD)
End Sub

Function iteminfo (ByVal lbitem As String, ByVal idx As Integer)
' get specified list box hidden info item given the list box item string

    iteminfo = infostgitem(infostg(lbitem), idx)
End Function

Sub listjump (ByVal jumpto As Integer, ByVal source As Integer)
' move list selection to specified message
' jumpto:   which message to jump to code
' source:   source being listed

    Select Case source
    Case SRCEINBOX
        ibxlstjmp jumpto
    Case SRCPOSTOFC
        polistjmp jumpto
    Case SRCFORUM
        onlistjmp jumpto
    Case SRCTHREAD
        ontlistjmp jumpto
    Case SRCOFLMSG
        oflistjmp jumpto
    Case SRCOFLTHR
        oftlistjmp jumpto
    Case SRCFILCAB
        fclistjmp jumpto
    End Select
End Sub

Sub markread (ByVal forum As Integer, ByVal msgid As Long, ByVal msgidstr As String, ByVal source As Integer)
' mark a message as having been read
' forum:    forum ID of message
' msgid:    message ID of message
' source:   source ID

    Dim idx As Integer, flags As Integer
    Dim tmps As String

    If msgid <> 0 And Not msgmarked(forum, msgid) Then
        markmsg forum, msgid
        ofupdread forum, msgid
        If source = cursource Then
            Select Case source
            Case SRCEINBOX
                idx = ibxlstidx(msgidstr)
            Case SRCPOSTOFC
                idx = polistidx(msgidstr)
            Case SRCFORUM, SRCUNAPV
                idx = onlistidx(msgidstr)
            Case SRCTHREAD
                idx = ontlistidx(msgidstr)
            Case SRCONLSCN
                idx = scnlistidx(msgidstr)
            Case SRCOFLMSG
                idx = oflistidx(msgidstr)
            Case SRCOFLTHR
                idx = oftlistidx(msgidstr)
            Case SRCFILCAB
                idx = fclistidx(msgidstr)
            End Select
            If idx >= 0 Then
                tmps = mainform!msglist.List(idx)
                flags = Val(iteminfo(tmps, MLI_FLAGS)) Or MLF_READ
                mainform!msglist.ReFreshOnUpdate = False
                mainform!msglist.List(idx) = setitminf(tmps, MLI_FLAGS, CStr(flags))
                setmlpic mainform!msglist, idx, flags
                mainform!msglist.ReFreshOnUpdate = True
            End If
        End If
    End If
End Sub

Function mlflags (msg As msgdpkshrt, ByVal ctrlflgs As Integer) As Integer
' create message list flags given message header and control flags
' msg:      message header to evaluate
' ctrlflgs: control flags (e.g., "taggable")
' returns hidden message list info flags for this message

    Dim flags As Integer

    flags = (msg.flags And MLF_MSGMASK)
    If msg.msgid Then
        If msgmarked(msg.forum, msg.msgid) Then
            flags = flags Or MLF_READ
        End If
    End If
    If msg.forum Then
        flags = flags Or MLF_FORUM
    End If
    mlflags = flags Or ctrlflgs
End Function

Function nearmsg (msgidstr As String, ByVal source As Integer) As Integer
' read nearest message (next preferred)
' msgidstr: current message ID string (updated if successful)
' source:   source to read from
' returns True if successful

    nearmsg = True
    If Not readmsg(msgidstr, READNEXT, source) Then
        If Not readmsg(msgidstr, READPREV, source) Then
            nearmsg = False
        End If
    End If
End Function

Function nearthr (msgidstr As String, ByVal fornam As String, ByVal msgid As Long, ByVal thrid As Long, rplto As globid, ByVal source As Integer) As Integer
' read nearest message in a thread (next preferred)
' msgidstr: identifier of current message (updated if successful)
' fornam:   forum name
' msgid:    current message ID
' thrid:    current thread ID
' rplto:    reply-to ID of current message
' source:   code indicating where to read message from
' returns True if message found

    If source = SRCOFLTHR Or source = SRCOFLMSG Then
        nearthr = ofnearthr(msgidstr, fornam, msgid, thrid, rplto)
    Else
        nearthr = True
        If Not readthr(msgidstr, fornam, msgid, thrid, rplto, READNEXT, source) Then
            If Not readthr(msgidstr, fornam, msgid, thrid, rplto, READPREV, source) Then
                nearthr = False
            End If
        End If
    End If
End Function

Function ok2edit () As Integer
' ok to start editing a new message?

    ok2edit = True
    If isloaded(wrtedt) Then
        If Len(wrtedt.Tag) Then
            poperror "You are still editing a message. You must finish with it before you can edit another.", ""
            frmgivef wrtedt
            ok2edit = False
        End If
    End If
End Function

Sub prepread (ByVal source As Integer, ByVal lstidx As Integer, capstr As String, btnflgs As Integer, capflgs As Integer, msgidstr As String)
' prepare read form arguments
' source:   source to prepare for
' lstidx:   index in message list of message to prepare
' capstr:   read form caption
' btnflgs:  button flags
' capflgs:  capability flags
' msgidstr: message ID string

    Select Case source
    Case SRCEINBOX
        ibxpreprd lstidx, capstr, btnflgs, capflgs, msgidstr
    Case SRCPOSTOFC
        poprepread lstidx, capstr, btnflgs, capflgs, msgidstr
    Case SRCFORUM
        onpreprd lstidx, capstr, btnflgs, capflgs, msgidstr
    Case SRCTHREAD
        ontpreprd lstidx, capstr, btnflgs, capflgs, msgidstr
    Case SRCUNAPV
        unapreprd lstidx, capstr, btnflgs, capflgs, msgidstr
    Case SRCONLSCN
        scnpreprd lstidx, capstr, btnflgs, capflgs, msgidstr
    Case SRCOFLMSG
        ofpreprd lstidx, capstr, btnflgs, capflgs, msgidstr
    Case SRCOFLTHR
        oftpreprd lstidx, capstr, btnflgs, capflgs, msgidstr
    Case SRCFILCAB
        fcpreprd lstidx, capstr, btnflgs, capflgs, msgidstr
    End Select
End Sub

Function putnotes (ByVal msgidstr As String, ByVal source As Integer, ByVal notes As String) As Integer
' store inbox or filecabinet notes associated with a message
' msgidstr: message ID string of message to delete
' source:   source ID of message
' returns comments if any exist

    Dim tmpdpk As String

    Select Case source
    Case SRCEINBOX
        tmpdpk = IBXNOTDPK & Format$(Val(msgidstr), MNMFMT)
        junk = swrtdpkv(tmpdpk, STGLEN, notes)
    Case SRCFILCAB
        junk = swrtdpkv(FCBNOTDPK & msgidstr, STGLEN, notes)
    End Select
    tmpdpk = evtdpk()
    Select Case tmpdpk
    Case "Write ok"
        putnotes = True
    Case Else
        putnotes = False
    End Select
End Function

Function readjump (msgidstr As String, ByVal jumpto As Integer, ByVal source As Integer) As Integer
' jump to (and read) a message
' dest:     where to jump to
' source:   source being read from
' returns True if message found

    readjump = False
    Select Case source
    Case SRCEINBOX
        readjump = ibxrdjmp(msgidstr, jumpto)
    Case SRCPOSTOFC
        readjump = poreadjmp(msgidstr, jumpto)
    Case SRCFORUM
        readjump = onreadjmp(msgidstr, jumpto)
    Case SRCTHREAD
        readjump = ontreadjmp(msgidstr, jumpto)
    Case SRCOFLMSG
        readjump = ofreadjmp(msgidstr, jumpto)
    Case SRCOFLTHR
        readjump = oftreadjmp(msgidstr, jumpto)
    Case SRCFILCAB
        readjump = fcreadjmp(msgidstr, jumpto)
    End Select
End Function

Function readmsg (msgidstr As String, ByVal direc As Integer, ByVal source As Integer) As Integer
' generic read-a-message function
' msgidstr: identifier of current message (updated if successful)
' direc:    direction to read (-1=prev, 0=exact, 1=next)
' source:   code indicating where to read message from
' returns:  True if message found
' implicit output: message is in msgindpk if returns True

    Dim rsplen As Integer

    Select Case source
    Case SRCEINBOX
        readmsg = ibxrdmsg(msgidstr, direc)
    Case SRCPOSTOFC
        readmsg = poreadmsg(msgidstr, direc)
    Case SRCFORUM
        readmsg = onreadmsg(msgidstr, direc)
    Case SRCTHREAD
        readmsg = ontreadmsg(msgidstr, direc)
    Case SRCUNAPV
        readmsg = unareadmsg(msgidstr, direc)
    Case SRCONLSCN
        readmsg = scnreadmsg(msgidstr, direc)
    Case SRCOFLMSG
        readmsg = ofreadmsg(msgidstr, direc)
    Case SRCOFLTHR
        readmsg = oftreadmsg(msgidstr, direc)
    Case SRCFILCAB
        readmsg = fcreadmsg(msgidstr, direc)
    End Select
End Function

Function readthr (msgidstr As String, ByVal fornam As String, ByVal msgid As Long, ByVal thrid As Long, rplto As globid, ByVal direc As Integer, ByVal source As Integer) As Integer
' read a message in a thread function
' msgidstr: identifier of current message (updated if successful)
' fornam:   forum name or "" if email
' msgid:    current message ID
' thrid:    current thread ID
' rplto:    reply-to ID of current message
' direc:    direction to read (-1=prev, 0=parent, 1=next)
' source:   code indicating where to read message from
' returns:  True if message found
' implicit output: message is in msgindpk if returns True

    readthr = False
    Select Case source
    Case SRCEINBOX, SRCPOSTOFC
        readthr = emlreadthr(msgidstr, fornam, msgid, thrid, rplto, direc)
    Case SRCFORUM, SRCTHREAD, SRCUNAPV
        readthr = onreadthr(msgidstr, fornam, msgid, thrid, rplto, direc, source)
    Case SRCONLSCN
        readthr = scnreadthr(msgidstr, fornam, msgid, thrid, rplto, direc)
    Case SRCOFLMSG, SRCOFLTHR
        readthr = ofreadthr(msgidstr, fornam, msgid, thrid, rplto, direc)
    Case SRCFILCAB
        readthr = fcreadthr(msgidstr, fornam, msgid, thrid, rplto, direc)
    End Select
End Function

Sub remread (ByVal msgidstr As String, ByVal source As Integer)
' unload read form(s) associated with a given message and/or source
' msgidstr: ID string of message or "" to remove all forms associated with source
' source:   source ID of message(s) to remove

    Dim i As Integer

    i = 0
    Do While i < forms.Count
        If TypeOf forms(i) Is rdmsg Then
            If (Len(msgidstr) = 0 Or sameas(forms(i)!msgid, msgidstr)) And Val(forms(i)!source) = source Then
                Unload forms(i)
            Else
                i = i + 1
            End If
        Else
            i = i + 1
        End If
    Loop
End Sub

Function setitminf (ByVal lbitem As String, ByVal idx As Integer, ByVal setto As String) As String
' set a hidden info item's value
' lbitem:   list box item string
' idx:      hidden info item index
' setto:    new value for hidden info item
' returns updated list box item string

    Dim invidx As Integer

    invidx = itemcnt(lbitem) - 1
    setitminf = itemset(lbitem, invidx, itemsetd(itemidx(lbitem, invidx), idx, setto, FLDSEP))
End Function

Sub setmlntab (ByVal numtabs As Integer)
' set number of tabs in main form message list (including one extra for hidden info)
'   and loads captions for visible tabs
' numtabs:  number of visible tabs to set up

    Dim i As Integer

    maxcaplbl = numtabs
    For i = 0 To numtabs - 1
        Load mainform!caplbl(i + 1)
        mainform!msglist.TabPos(i) = 100 * (i + 1)
        mainform!msglist.TabType(i) = 1 'Hard
    Next
    mainform!msglist.TabPos(numtabs) = MAXINT
    mainform!msglist.TabType(numtabs) = 1   'Hard
End Sub

Sub setmlpic (lst As Control, ByVal idx As Integer, ByVal flags As Integer)
' set message list picture
' lst:      list to set picture in
' idx:      index at which to set picture
' flags:    message type flags

    flags = flags And MLF_MLFMASK
    If (flags And MLF_TGABLE) = 0 Then
        flags = flags And Not MLF_TAGGED
    End If
    If flags And (MLF_FORUM Or MLF_READ) Then
        flags = flags And Not (MLF_PRIMSG Or MLF_RECREQ)
    End If
    lst.Picture(idx) = mainform!listpic(flags)
End Sub

Sub settlpic (lst As Control, ByVal idx As Integer, ByVal flags As Integer)
' set thread list picture
' lst:      list to set picture in
' idx:      index at which to set picture
' flags:    message type flags

    flags = flags And MLF_MLFMASK
    If flags And MLF_TGABLE Then
        If flags And MLF_TAGGED Then
            lst.Picture(idx) = mainform!chkon
        Else
            lst.Picture(idx) = mainform!chkoff
        End If
    End If
End Sub

Sub showedit (ByVal args As String)
' show the edit-message form
' args: actcap() argument to pass to write form

    junk = actcap(wrtedt, "newmsg", args)
End Sub

Sub showrdfrm (ByVal args As String)
' show the read-message form
' args: actcap() argument to pass to read form
' returns False if not enough resources to load

    junk = actcap(rdmsg, "loadmsg", args)
End Sub

Function switchthr (msgidstr As String, capstr As String, ByVal fornam As String, ByVal thrid As Long, ByVal direc As Integer, ByVal source As Integer) As Integer
' switch threads
' msgidstr: message ID string (updated if successful)
' capstr:   message window caption (updated if successful)
' fornam:   name of forum being read from
' thrid:    current thread ID
' direc:    direction to switch (previous/next)
' source:   code indicating where messages being read from
' returns True if switched

    switchthr = False
    Select Case source
    Case SRCTHREAD
        switchthr = onswthr(msgidstr, capstr, fornam, thrid, direc)
    Case SRCOFLTHR
        switchthr = ofswthr(msgidstr, capstr, fornam, thrid, direc)
    End Select
End Function

Sub synclist (ByVal msgidstr As String, ByVal source As Integer)
' synchronize message lists given message ID string and source ID

    If source = cursource Then
        Select Case source
        Case SRCEINBOX
            ibxsynclst msgidstr
        Case SRCPOSTOFC
            posynclst msgidstr
        Case SRCFORUM
            onsynclst msgidstr
        Case SRCTHREAD
            ontsynclst msgidstr
        Case SRCUNAPV
            unasynclst msgidstr
        Case SRCONLSCN
            scnsynclst msgidstr
        Case SRCOFLMSG
            ofsynclst msgidstr
        Case SRCOFLTHR
            oftsynclst msgidstr
        Case SRCFILCAB
            fcsynclst msgidstr
        End Select
    End If
End Sub

Function togmsgtg (flags As Integer, ByVal idx As Integer, ByVal source As Integer) As Integer
' toggle a message's tagged status from list of messages
' flags:    current message list flags (updated by handler)
' idx:      index in list of message to tag
' source:   message source ID
' returns True if message tag toggled successfully

    togmsgtg = False
    Select Case source
    Case SRCPOSTOFC
        togmsgtg = potogtag(flags, idx)
    Case SRCFORUM, SRCTHREAD, SRCUNAPV
        togmsgtg = ontogtag(flags, idx, source)
    Case SRCONLSCN
        togmsgtg = scntogtag(flags, idx)
    End Select
End Function

Function togthrtg (flags As Integer, ByVal idx As Integer, ByVal source As Integer) As Integer
' toggle a thread's tagged status from list of messages
' flags:    current message list flags (updated by handler)
' idx:      index in list of message to tag
' source:   message source ID
' returns True if message tag toggled successfully

    togthrtg = False
    Select Case source
    Case SRCTHREAD
        togthrtg = ontogthrtg(flags, idx)
    End Select
End Function

Sub updmtag (ByVal lstidx As Integer, ByVal forum As Integer, ByVal thrid As Long, ByVal msgid As Long)
' update a message list item's tagged status
' lstidx:   index of item to update
' forum:    forum ID message is in
' thrid:    thread ID message is in
' msgid:    message ID of message

    Dim oldflg As Integer, newflg As Integer
    Dim tmps As String

    tmps = mainform!msglist.List(lstidx)
    oldflg = Val(iteminfo(tmps, MLI_FLAGS))
    newflg = oldflg
    setflg msgtagged(msgid, thrid, forum), newflg, MLF_TAGGED
    If newflg <> oldflg Then
        mainform!msglist.List(lstidx) = setitminf(tmps, MLI_FLAGS, CStr(newflg))
        setmlpic mainform!msglist, lstidx, newflg
    End If
End Sub

Function canswthr (ByVal msgidstr As String, ByVal fornam As String, ByVal thrid As Long, ByVal direc As Integer, ByVal source As Integer) As Integer
' can user switch threads?
' msgidstr: message ID string
' fornam:   name of forum being read from
' thrid:    current thread ID
' direc:    direction to switch (previous/next)
' source:   code indicating where messages being read from
' returns True if thread available

    canswthr = False
    Select Case source
    Case SRCTHREAD
        canswthr = oncanswthr(msgidstr, fornam, thrid, direc)
    Case SRCOFLTHR
        canswthr = ofcanswthr(msgidstr, fornam, thrid, direc)
    End Select
End Function

Function delmsgl (ByVal msgidstr As String, ByVal source As Integer) As Integer
' delete local copy of a message function and update appropriate list
' msgidstr: message ID string of message to delete
' source:   source ID of message
' returns True if deleted

    Dim i As Integer, delflg As Integer

    delflg = False
    Select Case source
    Case SRCEINBOX
        delflg = ibxdelmsg(msgidstr)
    Case SRCPOSTOFC
        delflg = podelmsgl(msgidstr)
    Case SRCFORUM, SRCTHREAD, SRCUNAPV
        delflg = ondelmsgl(msgidstr, source)
    Case SRCOFLMSG, SRCOFLTHR
        delflg = ofdelmsgl(msgidstr, source)
    Case SRCONLSCN
        delflg = scndelmsgl(msgidstr)
    Case SRCFILCAB
        delflg = fcdelmsg(msgidstr)
    End Select
    If delflg Then
        adjrdbtn
        fixmtb
    End If
    delmsgl = delflg
End Function

