VERSION 2.00
Begin Form mparadlg
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Paragraph Format"
   ClientHeight    =   2415
   ClientLeft      =   2835
   ClientTop       =   3345
   ClientWidth     =   5715
   Height          =   2880
   HelpContextID   =   65
   Left            =   2745
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2415
   ScaleWidth      =   5715
   Top             =   2970
   Width           =   5895
   Begin CommandButton helpbtn
      BackColor       =   &H00C0C0C0&
      Caption         =   "Help"
      Height          =   360
      Left            =   4560
      TabIndex        =   17
      Top             =   1200
      Width           =   960
   End
   Begin CommandButton cancelbtn
      BackColor       =   &H00C0C0C0&
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   360
      Left            =   4560
      TabIndex        =   16
      Top             =   720
      Width           =   960
   End
   Begin CommandButton okbtn
      BackColor       =   &H00C0C0C0&
      Caption         =   "OK"
      Default         =   -1  'True
      Height          =   360
      Left            =   4560
      TabIndex        =   15
      Top             =   300
      Width           =   960
   End
   Begin SSFrame Frame3D2
      Caption         =   "&Alignment"
      ForeColor       =   &H00000000&
      Height          =   1935
      Left            =   2880
      TabIndex        =   10
      Top             =   240
      Width           =   1515
      Begin SSOption fulljust
         Caption         =   "Justified"
         Height          =   255
         Left            =   180
         TabIndex        =   14
         Top             =   1440
         Width           =   1215
      End
      Begin SSOption rightjust
         Caption         =   "Right"
         Height          =   255
         Left            =   180
         TabIndex        =   13
         Top             =   1080
         Width           =   975
      End
      Begin SSOption centerjust
         Caption         =   "Centered"
         Height          =   255
         Left            =   180
         TabIndex        =   12
         Top             =   720
         Width           =   1215
      End
      Begin SSOption leftjust
         Caption         =   "Left"
         Height          =   255
         Left            =   180
         TabIndex        =   11
         Top             =   360
         Width           =   795
      End
   End
   Begin SSFrame Frame3D1
      Caption         =   "Indents"
      ForeColor       =   &H00000000&
      Height          =   1935
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   2475
      Begin SpinButton fispin
         Delay           =   150
         Height          =   300
         Left            =   1680
         TdThickness     =   1
         Top             =   1320
         Width           =   225
      End
      Begin SpinButton rispin
         Delay           =   150
         Height          =   300
         Left            =   1680
         TdThickness     =   1
         Top             =   840
         Width           =   225
      End
      Begin SpinButton lispin
         Delay           =   150
         Height          =   300
         Left            =   1680
         TdThickness     =   1
         Top             =   360
         Width           =   225
      End
      Begin TextBox firstind
         Height          =   300
         Left            =   1080
         TabIndex        =   8
         Top             =   1320
         Width           =   615
      End
      Begin TextBox rightind
         Height          =   300
         Left            =   1080
         TabIndex        =   5
         Top             =   840
         Width           =   615
      End
      Begin TextBox leftind
         Height          =   300
         Left            =   1080
         TabIndex        =   2
         Text            =   "6.88888888"
         Top             =   360
         Width           =   615
      End
      Begin Label fiscale
         BackStyle       =   0  'Transparent
         Caption         =   "mm."
         Height          =   195
         Left            =   1980
         TabIndex        =   9
         Top             =   1380
         Width           =   315
      End
      Begin Label riscale
         BackStyle       =   0  'Transparent
         Caption         =   "mm."
         Height          =   195
         Left            =   1980
         TabIndex        =   6
         Top             =   900
         Width           =   315
      End
      Begin Label liscale
         BackStyle       =   0  'Transparent
         Caption         =   "mm."
         Height          =   195
         Left            =   1980
         TabIndex        =   3
         Top             =   420
         Width           =   315
      End
      Begin Label Label3
         BackStyle       =   0  'Transparent
         Caption         =   "&First line:"
         Height          =   195
         Left            =   180
         TabIndex        =   7
         Top             =   1380
         Width           =   795
      End
      Begin Label Label2
         BackStyle       =   0  'Transparent
         Caption         =   "&Right:"
         Height          =   195
         Left            =   180
         TabIndex        =   4
         Top             =   900
         Width           =   555
      End
      Begin Label Label1
         BackStyle       =   0  'Transparent
         Caption         =   "&Left:"
         Height          =   195
         Left            =   180
         TabIndex        =   1
         Top             =   420
         Width           =   555
      End
   End
End
'****************************************************************************
'*                                                                          *
'*  MPARADLG.FRM                                                            *
'*                                                                          *
'*  Copyright (c) 1995-1997 Galacticomm, Inc.    All Rights Reserved.       *
'*                                                                          *
'*  Paragraph format dialog.                                                *
'*                                                                          *
'*                                                  - J. Alvrus 11/28/95    *
'*                                                                          *
'****************************************************************************

Option Explicit

Const INDFMT = "0.0##"

Dim retstr As String
Dim mouseclick As Integer
Dim just As Integer
Dim scaleunits As Integer
Dim pagew As Integer
Dim scaleval As Double
Dim spininc As Single

Sub cancelbtn_Click ()
    Unload Me
End Sub

Sub centerjust_Click (Value As Integer)
    just = JUSTC
    chkbtn
End Sub

Sub chkbtn ()
    okbtn.Enabled = IsNumeric(leftind) And IsNumeric(rightind) And IsNumeric(firstind) And (just >= 0 And just <= 3)
End Sub

Sub firstind_Change ()
    chkbtn
End Sub

Sub firstind_GotFocus ()
    If Not mouseclick Then
        firstind.SelStart = 0
        firstind.SelLength = Len(firstind)
    End If
End Sub

Sub firstind_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    mouseclick = (Button And KEY_LBUTTON) <> 0
End Sub

Sub firstind_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
    mouseclick = False
End Sub

Sub fispin_SpinDown ()
    If (Len(firstind) = 0 Or IsNumeric(firstind)) And Val(firstind) > -(pagew * scaleval) Then
        firstind = Format$(Val(firstind) - spininc, INDFMT)
    End If
End Sub

Sub fispin_SpinUp ()
    If (Len(firstind) = 0 Or IsNumeric(firstind)) And Val(firstind) < (pagew * scaleval) Then
        firstind = Format$(Val(firstind) + spininc, INDFMT)
    End If
End Sub

Sub Form_Load ()
    Dim tmps As String
    Dim tmpi As Integer

    mouseclick = False
    retstr = ""
    modsysmnu Me, MOVCLS
    repoctr Me, Nothing
    scaleunits = Val(itemidx(formxchg, 0))
    pagew = Val(itemidx(formxchg, 1))
    tmps = scaleabbr(scaleunits)
    scaleval = scalefactor(scaleunits)
    If scaleunits = SCALE_MM Then
        spininc = 1
    Else
        spininc = .1
    End If
    liscale = tmps
    riscale = tmps
    fiscale = tmps
    tmpi = Val(itemidx(formxchg, 2))
    If tmpi = INDENT_NOCOMMON Then
        leftind = ""
    Else
        leftind = Format$(tmpi * scaleval, INDFMT)
    End If
    tmpi = Val(itemidx(formxchg, 3))
    If tmpi = INDENT_NOCOMMON Then
        rightind = ""
    Else
        rightind = Format$(tmpi * scaleval, INDFMT)
    End If
    tmpi = Val(itemidx(formxchg, 4))
    If tmpi = INDENT_NOCOMMON Then
        firstind = ""
    Else
        firstind = Format$(tmpi * scaleval, INDFMT)
    End If
    just = Val(itemidx(formxchg, 5))
    Select Case just
    Case JUSTL
        leftjust.Value = True
    Case JUSTC
        centerjust.Value = True
    Case JUSTR
        rightjust.Value = True
    Case JUSTF
        fulljust.Value = True
    Case Else
        leftjust.Value = False
        centerjust.Value = False
        rightjust.Value = False
        fulljust.Value = False
    End Select
    chkbtn
End Sub

Sub Form_Unload (Cancel As Integer)
    formxchg = retstr
End Sub

Sub fulljust_Click (Value As Integer)
    just = JUSTF
    chkbtn
End Sub

Sub helpbtn_Click ()
    dohelp helpbtn, HELP_CONTEXT
End Sub

Sub leftind_Change ()
    chkbtn
End Sub

Sub leftind_GotFocus ()
    If Not mouseclick Then
        leftind.SelStart = 0
        leftind.SelLength = Len(leftind)
    End If
End Sub

Sub leftind_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    mouseclick = (Button And KEY_LBUTTON) <> 0
End Sub

Sub leftind_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
    mouseclick = False
End Sub

Sub leftjust_Click (Value As Integer)
    just = JUSTL
    chkbtn
End Sub

Sub lispin_SpinDown ()
    If (Len(leftind) = 0 Or IsNumeric(leftind)) And Val(leftind) > 0 Then
        leftind = Format$(Val(leftind) - spininc, INDFMT)
    End If
End Sub

Sub lispin_SpinUp ()
    If (Len(leftind) = 0 Or IsNumeric(leftind)) And Val(leftind) < (pagew * scaleval) Then
        leftind = Format$(Val(leftind) + spininc, INDFMT)
    End If
End Sub

Sub okbtn_Click ()
    Dim li As Integer, ri As Integer, fi As Integer

    li = Val(leftind) / scaleval
    ri = Val(rightind) / scaleval
    fi = Val(firstind) / scaleval
    If li < 0 Then
        poperror "Left indent cannot be negative", ""
        txtgivef leftind
    ElseIf li > pagew Then
        poperror "Left indent is too large", ""
        txtgivef leftind
    ElseIf ri < 0 Then
        poperror "Right indent cannot be negative", ""
        txtgivef rightind
    ElseIf ri > pagew Then
        poperror "Right indent is too large", ""
        txtgivef rightind
    ElseIf pagew - li - ri < 0 Then
        poperror "Right indent overlaps left indent", ""
        txtgivef rightind
    ElseIf pagew - li - fi - ri < 0 Then
        poperror "Right indent overlaps first indent", ""
        txtgivef rightind
    ElseIf li + fi < 0 Then
        poperror "Negative first indent is too large", ""
        txtgivef firstind
    Else
        retstr = li & tb & ri & tb & fi & tb & just
        Unload Me
    End If
End Sub

Sub rightind_Change ()
    chkbtn
End Sub

Sub rightind_GotFocus ()
    If Not mouseclick Then
        rightind.SelStart = 0
        rightind.SelLength = Len(rightind)
    End If
End Sub

Sub rightind_MouseDown (Button As Integer, Shift As Integer, X As Single, Y As Single)
    mouseclick = (Button And KEY_LBUTTON) <> 0
End Sub

Sub rightind_MouseUp (Button As Integer, Shift As Integer, X As Single, Y As Single)
    mouseclick = False
End Sub

Sub rightjust_Click (Value As Integer)
    just = JUSTR
    chkbtn
End Sub

Sub rispin_SpinDown ()
    If (Len(rightind) = 0 Or IsNumeric(rightind)) And Val(rightind) > 0 Then
        rightind = Format$(Val(rightind) - spininc, INDFMT)
    End If
End Sub

Sub rispin_SpinUp ()
    If (Len(rightind) = 0 Or IsNumeric(rightind)) And Val(rightind) < (pagew * scaleval) Then
        rightind = Format$(Val(rightind) + spininc, INDFMT)
    End If
End Sub

