VERSION 2.00
Begin Form mfontdlg
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Font"
   ClientHeight    =   3555
   ClientLeft      =   1395
   ClientTop       =   2580
   ClientWidth     =   6900
   Height          =   4020
   HelpContextID   =   107001
   Left            =   1305
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3555
   ScaleWidth      =   6900
   Top             =   2205
   Visible         =   0   'False
   Width           =   7080
   Begin CommandButton action
      Height          =   195
      Left            =   5880
      TabIndex        =   16
      TabStop         =   0   'False
      Top             =   1020
      Visible         =   0   'False
      Width           =   795
   End
   Begin TextControl sample
      Alignment       =   2  'Centered
      BackStyle       =   1  'Opaque
      BorderStyle     =   1  'Fixed Single
      ButtonBar       =   "None"
      ClipChildren    =   -1  'True
      ClipSiblings    =   -1  'True
      ControlChars    =   0   'False
      DataFormat      =   0  'Text
      FontName        =   "Arial"
      FontSize        =   12
      FormatSelection =   0   'False
      Height          =   660
      HideSelection   =   -1  'True
      ImageAttrDlg    =   -1  'True
      InsertionMode   =   0   'False
      Left            =   6960
      LineSpacing     =   100
      LineSpacingT    =   0
      PageHeight      =   32767
      PageMarginB     =   0
      PageMarginL     =   0
      PageMarginR     =   0
      PageMarginT     =   0
      PageWidth       =   32767
      PrintColors     =   -1  'True
      PrintZoom       =   100
      ReadOnly        =   -1  'True
      Ruler           =   "None"
      ScrollBars      =   0  'None
      SizeMode        =   0  'Fixed
      StatusBar       =   "None"
      TabIndex        =   14
      TabKey          =   0   'False
      TabStop         =   0   'False
      Text            =   ""
      Top             =   960
      ViewMode        =   0
      VTSpellDictionary=   ""
      Width           =   825
      ZoomFactor      =   0  '100%
   End
   Begin SSCombo colorlist
      Prop37          =   MFONTDLG.FRX:0000
      AllowForPicture =   MFONTDLG.FRX:0037
      AutoHScroll     =   -1  'True
      Case            =   0  'Unchanged
      DividerStyle    =   0  'None
      FixedHeight     =   14
      Font3D          =   0  'None
      Height          =   300
      HoldFontH       =   14
      Left            =   150
      ListStyle       =   0  '2D (BackColor used)
      MaxDropDnItems  =   8
      ScrollVertical  =   -1  'True
      ShadowColor     =   0  'Dark Grey
      Sorted          =   0   'False
      Style           =   2  'Dropdown List
      TabIndex        =   12
      Text            =   "colorlist"
      Top             =   2910
      Width           =   2205
      WndStyle        =   1084228179
   End
   Begin CommandButton okbtn
      Caption         =   "OK"
      Default         =   -1  'True
      Height          =   345
      Left            =   5715
      TabIndex        =   6
      Top             =   135
      Width           =   1050
   End
   Begin CommandButton cancelbtn
      Cancel          =   -1  'True
      Caption         =   "Cancel"
      Height          =   345
      Left            =   5715
      TabIndex        =   7
      Top             =   540
      Width           =   1050
   End
   Begin SSCombo sizelist
      Prop37          =   MFONTDLG.FRX:0181
      AutoHScroll     =   -1  'True
      Case            =   0  'Unchanged
      DividerStyle    =   0  'None
      FixedHeight     =   13
      Font3D          =   0  'None
      Height          =   1335
      HoldFontH       =   14
      Left            =   4680
      ListStyle       =   0  '2D (BackColor used)
      MaxDropDnItems  =   8
      ScrollVertical  =   -1  'True
      ShadowColor     =   0  'Dark Grey
      Sorted          =   0   'False
      Style           =   1  'Simple Combo
      TabIndex        =   5
      Top             =   300
      Width           =   840
      WndStyle        =   1084228193
   End
   Begin SSCombo stylelist
      Prop37          =   MFONTDLG.FRX:01B8
      AutoHScroll     =   -1  'True
      Case            =   0  'Unchanged
      DividerStyle    =   0  'None
      FixedHeight     =   13
      Font3D          =   0  'None
      Height          =   1335
      HoldFontH       =   14
      Left            =   2820
      ListStyle       =   0  '2D (BackColor used)
      MaxDropDnItems  =   8
      ScrollVertical  =   -1  'True
      ShadowColor     =   0  'Dark Grey
      Sorted          =   0   'False
      Style           =   1  'Simple Combo
      TabIndex        =   3
      Top             =   300
      Width           =   1680
      WndStyle        =   1084228193
   End
   Begin Frame sampframe
      Caption         =   "Sample"
      Height          =   1215
      Left            =   2565
      TabIndex        =   13
      Top             =   1740
      Width           =   4200
      Begin PictureBox sampic
         BorderStyle     =   0  'None
         Height          =   675
         Left            =   240
         ScaleHeight     =   675
         ScaleWidth      =   3795
         TabIndex        =   15
         TabStop         =   0   'False
         Top             =   360
         Width           =   3795
      End
   End
   Begin Frame Frame1
      Caption         =   "Effects"
      Height          =   825
      Left            =   150
      TabIndex        =   8
      Top             =   1740
      Width           =   2205
      Begin CheckBox ulinechk
         Caption         =   "&Underline"
         Height          =   225
         Left            =   105
         TabIndex        =   10
         TabStop         =   0   'False
         Top             =   540
         Width           =   1335
      End
      Begin CheckBox sthruchk
         Caption         =   "Stri&keout"
         Height          =   225
         Left            =   105
         TabIndex        =   9
         Top             =   240
         Width           =   1275
      End
   End
   Begin SSCombo namelist
      Prop37          =   MFONTDLG.FRX:01EF
      AutoHScroll     =   -1  'True
      Case            =   0  'Unchanged
      DividerStyle    =   0  'None
      FixedHeight     =   13
      Font3D          =   0  'None
      Height          =   1335
      HoldFontH       =   14
      Left            =   150
      ListStyle       =   0  '2D (BackColor used)
      MaxDropDnItems  =   8
      ScrollVertical  =   -1  'True
      ShadowColor     =   0  'Dark Grey
      Sorted          =   0   'False
      Style           =   1  'Simple Combo
      TabIndex        =   1
      Top             =   300
      Width           =   2475
      WndStyle        =   1084228193
   End
   Begin Label Label4
      Caption         =   "&Color:"
      Height          =   255
      Left            =   150
      TabIndex        =   11
      Top             =   2670
      Width           =   555
   End
   Begin Label Label3
      Caption         =   "&Size"
      Height          =   255
      Left            =   4680
      TabIndex        =   4
      Top             =   60
      Width           =   495
   End
   Begin Label Label2
      Caption         =   "Font St&yle:"
      Height          =   255
      Left            =   2820
      TabIndex        =   2
      Top             =   60
      Width           =   975
   End
   Begin Label Label1
      Caption         =   "&Font:"
      Height          =   255
      Left            =   150
      TabIndex        =   0
      Top             =   60
      Width           =   495
   End
End
'****************************************************************************
'*                                                                          *
'*  MFONTDLG.FRM                                                            *
'*                                                                          *
'*  Copyright (c) 1995-1997 Galacticomm Inc.    All Rights Reserved.        *
'*                                                                          *
'*  Message Center-specific font dialog box.                                *
'*                                                                          *
'*                                                  - J. Alvrus 11/28/95    *
'*                                                                          *
'****************************************************************************

Option Explicit

Const SAMPSTR = "AaBbYyZz"
Const MINLEFT = 150
Const MINTOP = 240
Const MAXWIDTH = 3915
Const MAXHEIGHT = 900
Const ITALMASK = 1
Const BOLDMASK = 2

Dim retstr As String
Dim fontstr As String
Dim firstactive As Integer
Dim ok2change As Integer
Dim userchange As Integer
Dim colorxrf(15) As Long

Sub action_Click ()

    Const TMPF_FIXED_PITCH = 1

    Dim flags As Integer, i As Integer
    Dim tm As textmetric

    If action.Caption <> "selfont" Then
        Exit Sub
    End If
    retstr = ""
    fontstr = capargs
    sample.Text = SAMPSTR
    sample.SelStart = 0
    sample.SelLength = Len(SAMPSTR)
    setfontstr sample, fontstr
    sample.TextColor = Val(itemidx(fontstr, 2))
    firstactive = True
    ok2change = False
    getfontnames namelist, sample
    flags = Val(itemidx(fontstr, 3))
    If flags And FXFIXED Then
        i = 0
        While i < namelist.ListCount
            FontName = namelist.List(i)
            junk = GetTextMetrics(hDC, tm)
            'this seems backwards, but it works
            If Asc(tm.tmPitchAndFamily) And TMPF_FIXED_PITCH Then
                namelist.RemoveItem i
            Else
                i = i + 1
            End If
        Wend
    End If
    namelist.ListIndex = findinlist(namelist.Text, namelist)
    namelist.Text = itemidx(fontstr, 0)
    getfontsizes namelist.Text, sizelist, sample
    sizelist.ListIndex = findsize(sizelist.Text, sizelist)
    sizelist.Text = itemidx(fontstr, 1)
    colorlist.ListIndex = findcolor(Val(itemidx(fontstr, 2)))
    i = 0
    If flags And FXITAL Then
        i = i Or ITALMASK
    End If
    If flags And FXBOLD Then
        i = i Or BOLDMASK
    End If
    stylelist.ListIndex = i
    If flags And FXULIN Then
        ulinechk.Value = 1
    Else
        ulinechk.Value = 0
    End If
    If flags And FXSTHR Then
        sthruchk.Value = 1
    Else
        sthruchk.Value = 0
    End If
    synchup
    ok2change = True
    userchange = False
    repoctr Me, Nothing
    Show 1
End Sub

Sub cancelbtn_Click ()
    Unload Me
End Sub

Sub chkbtn ()
    Dim tmpsiz As Integer

    If findinlist(namelist.Text, namelist) < 0 Then
        okbtn.Enabled = False
        Exit Sub
    ElseIf findstyle() < 0 Then
        okbtn.Enabled = False
        Exit Sub
    ElseIf colorlist.ListIndex < 0 Then
        okbtn.Enabled = False
        Exit Sub
    Else
        If Val(sizelist.Text) <= 0 Then
            okbtn.Enabled = False
            Exit Sub
        End If
    End If
    okbtn.Enabled = True
End Sub

Sub colorlist_Click ()
    If ok2change Then
        sample.TextColor = colorxrf(colorlist.ListIndex)
        synchup
    End If
End Sub

Function findcolor (ByVal color As Long) As Integer
    Dim i As Integer

    For i = 0 To UBound(colorxrf)
        If color = colorxrf(i) Then
            findcolor = i
            Exit Function
        End If
    Next
    findcolor = -1
End Function

Function findsize (ByVal sizestr As String, List As Control) As Integer
    Dim size As Integer, lo As Integer, md As Integer, hi As Integer

    md = -1
    size = ival(sizestr)
    If List.ListCount Then
        lo = 0
        hi = List.ListCount - 1
        Do While lo <= hi
            md = lo + Int((hi - lo) / 2)
            If size < Val(List.List(md)) Then
                If md = lo Then
                    md = -1
                    Exit Do
                End If
                hi = md - 1
            ElseIf size > Val(List.List(md)) Then
                If md = hi Then
                    md = -1
                    Exit Do
                End If
                lo = md + 1
            Else
                Exit Do
            End If
        Loop
    End If
    findsize = md
End Function

Function findstyle () As Integer
    Dim i As Integer

    For i = 0 To stylelist.ListCount
        If sameas(stylelist.Text, stylelist.List(i)) Then
            findstyle = i
            Exit Function
        End If
    Next
    findstyle = -1
End Function

Sub Form_Activate ()
    If firstactive Then
        firstactive = False
        protdoevt           'allow form to finish displaying
        userchange = True
        namelist_LostFocus
        namelist.SetFocus
    End If
End Sub

Sub Form_Load ()
    ok2change = False
    modsysmnu Me, MOVCLS
    settcdev sample, TF_SCREEN
    setupcolors
    stylelist.AddItem "Regular"
    stylelist.AddItem "Italic"
    stylelist.AddItem "Bold"
    stylelist.AddItem "Bold Italic"
End Sub

Sub Form_Unload (Cancel As Integer)
    If Not appclsipg Then
        formxchg = retstr
        capfail = (Len(retstr) = 0)
        Cancel = True
        Hide
    End If
End Sub

Sub namelist_Change ()
    userchange = True
End Sub

Sub namelist_Click ()
    Dim savsiz As String

    If ok2change Then
        savsiz = sizelist.Text
        winrefresh sizelist.Hwnd, False
        getfontsizes namelist.Text, sizelist, sample
        ok2change = False
        sizelist.ListIndex = findsize(savsiz, sizelist)
        sizelist.Text = savsiz
        ok2change = True
        winrefresh sizelist.Hwnd, True
        sample.FontName = namelist.Text
        sample.FontSize = Val(sizelist.Text)
        synchup
    End If
End Sub

Sub namelist_LostFocus ()
    Dim i As Integer

    If userchange Then
        i = findinlist(namelist.Text, namelist)
        If i >= 0 Then
            namelist.ListIndex = i
        End If
        synchup
    End If
    userchange = False
End Sub

Sub okbtn_Click ()
    retstr = getfontstr(sample)
    retstr = itemset(retstr, 2, Trim$(Str$(sample.TextColor)))
    Unload Me
End Sub

Sub sampic_Paint ()
    Dim tm As textmetric

    sampic.CurrentX = 0
    sampic.CurrentY = 0
    junk = GetTextMetrics(sampic.hDC, tm)
    If tm.tmAscent * screen.TwipsPerPixelY > sampic.Height Then
        sampic.CurrentY = sampic.Height - tm.tmAscent * screen.TwipsPerPixelY
    End If
    sampic.Print SAMPSTR
End Sub

Sub setupcolors ()
    Dim i As Integer

    colorxrf(0) = RGB(0, 0, 0)
    colorlist.AddItem "Black"
    colorxrf(1) = RGB(128, 0, 0)
    colorlist.AddItem "Maroon"
    colorxrf(2) = RGB(0, 128, 0)
    colorlist.AddItem "Green"
    colorxrf(3) = RGB(128, 128, 0)
    colorlist.AddItem "Olive"
    colorxrf(4) = RGB(0, 0, 128)
    colorlist.AddItem "Navy"
    colorxrf(5) = RGB(128, 0, 128)
    colorlist.AddItem "Purple"
    colorxrf(6) = RGB(0, 128, 128)
    colorlist.AddItem "Teal"
    colorxrf(7) = RGB(128, 128, 128)
    colorlist.AddItem "Gray"
    colorxrf(8) = RGB(192, 192, 192)
    colorlist.AddItem "Silver"
    colorxrf(9) = RGB(255, 0, 0)
    colorlist.AddItem "Red"
    colorxrf(10) = RGB(0, 255, 0)
    colorlist.AddItem "Lime"
    colorxrf(11) = RGB(255, 255, 0)
    colorlist.AddItem "Yellow"
    colorxrf(12) = RGB(0, 0, 255)
    colorlist.AddItem "Blue"
    colorxrf(13) = RGB(255, 0, 255)
    colorlist.AddItem "Fuschia"
    colorxrf(14) = RGB(0, 255, 255)
    colorlist.AddItem "Aqua"
    colorxrf(15) = RGB(255, 255, 255)
    colorlist.AddItem "White"
    Load drawfrm
    drawfrm.Width = 27 * screen.TwipsPerPixelX
    drawfrm.Height = 13 * screen.TwipsPerPixelY
    drawfrm.BackColor = WINDOW_BACKGROUND
    drawfrm.Picture = colorlist.AllowForPicture
    drawfrm.PSet (26, 12), RGB(255, 255, 255)  'remove little black tail
    For i = 0 To 15
        drawfrm.Line (4, 1)-(25, 10), colorxrf(i), BF
        colorlist.Picture(i) = drawfrm.Image
    Next
    Unload drawfrm
    Set drawfrm = Nothing
End Sub

Sub showsamp ()
    Dim tmpx As Single, tmpy As Single
    Dim tmpw As Single, tmph As Single

    sampic.Cls
    If Not okbtn.Enabled Then
        Exit Sub
    End If
    copyfont sampic, sample
    tmpw = sampic.TextWidth(SAMPSTR)
    tmph = sampic.TextHeight(SAMPSTR) + screen.TwipsPerPixelY   'to allow for underline
    tmpx = (sampframe.Width - tmpw) / 2
    tmpy = MINTOP + (MAXHEIGHT - tmph) / 2
    If tmpx < MINLEFT Then
        tmpx = MINLEFT
    End If
    If tmpy < MINTOP Then
        tmpy = MINTOP
    End If
    If tmpw > MAXWIDTH Then
        tmpw = MAXWIDTH
    End If
    If tmph > MAXHEIGHT Then
        tmph = MAXHEIGHT
    End If
    sampic.ForeColor = sample.TextColor
    sampic.Move tmpx, tmpy, tmpw, tmph
    sampic_Paint
End Sub

Sub sizelist_Change ()
    userchange = True
End Sub

Sub sizelist_Click ()
    If ok2change Then
        sample.FontSize = Val(sizelist.Text)
        synchup
    End If
End Sub

Sub sizelist_LostFocus ()
    Dim i As Integer

    If userchange Then
        sample.FontSize = Val(sizelist.Text)
        i = findsize(sizelist.Text, sizelist)
        If i >= 0 Then
            sizelist.ListIndex = i
        End If
        synchup
    End If
    userchange = False
End Sub

Sub sthruchk_Click ()
    If ok2change Then
        sample.FontStrikethru = (sthruchk.Value = 1) And 1
        synchup
    End If
End Sub

Sub stylelist_Change ()
    userchange = True
End Sub

Sub stylelist_Click ()
    If ok2change Then
        sample.FontBold = ((stylelist.ListIndex And BOLDMASK) <> 0) And 1
        sample.FontItalic = ((stylelist.ListIndex And ITALMASK) <> 0) And 1
        synchup
    End If
End Sub

Sub stylelist_LostFocus ()
    Dim i As Integer

    If userchange Then
        i = findstyle()
        If i >= 0 Then
            stylelist.ListIndex = i
        End If
        synchup
    End If
    userchange = False
End Sub

Sub synchup ()
    Dim tmpi As Integer

    chkbtn
    showsamp
End Sub

Sub ulinechk_Click ()
    If ok2change Then
        sample.FontUnderline = (ulinechk.Value = 1) And 1
        synchup
    End If
End Sub

