'****************************************************************************
'*                                                                          *
'*  MARKMSG.BAS                                                             *
'*                                                                          *
'*  Copyright (c) 1995-1997 GALACTICOMM, Inc.    All Rights Reserved.       *
'*                                                                          *
'*  This file contains declarations and functions for keeping track of      *
'*  which messages in which forums have been read.                          *
'*                                                                          *
'****************************************************************************

Option Explicit

Global Const MAXMARKS = 4094    ' max # of messages marked as read
Global Const MARKDPK = "sa=GALFOR;ul:marked " ' dynapak name for message marks
Global Const FORIDFMT = "000000" ' format string for mark dpk forum ID

Type markedmsgs
    forumid As Integer          ' nonzero forum id
    nmarked As Integer          ' number of messages marked
    mark(MAXMARKS) As Long      ' the message markings
End Type

Dim marks As markedmsgs         ' instance of markedmsgs to use
Dim marksread As Integer        ' has a markedmsgs record been read yet?

Function hireadmsg (ByVal forumid As Integer) As Long
' returns highest read msg # for passed id, or 0 for none

    hireadmsg = 0&
    If marks.forumid <> forumid Or Not marksread Then
        marksread = True
        If sreadpk(MARKDPK & Format$(forumid, FORIDFMT), Len(marks), marks) = 0 Then
            marks.forumid = forumid     ' probably want to continue using this forum
            marks.nmarked = 0
            Exit Function
        End If
    End If
    If marks.nmarked Then
        hireadmsg = marks.mark(marks.nmarked - 1)
    End If
End Function

Sub markmsg (ByVal forumid As Integer, ByVal msgid As Long)
' mark a message as read

    Dim i As Integer, inspos As Integer
    Dim comp As Long

    If msgid = 0 Then
        Exit Sub
    End If
    If marks.forumid <> forumid Or Not marksread Then
        marksread = True
        If sreadpk(MARKDPK & Format$(forumid, FORIDFMT), Len(marks), marks) = 0 Then
            marks.forumid = forumid
            marks.nmarked = 0
        End If
    End If
    If marks.nmarked < 0 Or marks.nmarked > MAXMARKS Then
        marks.nmarked = 0
    End If
    comp = 1
    inspos = nearmark(comp, msgid, marks)
    If comp = 0 Then
        Exit Sub
    ElseIf comp > 0 Then
        inspos = inspos + 1
    ElseIf inspos = 0 And comp < 0 And marks.nmarked = MAXMARKS Then
        Exit Sub
    End If
    If marks.nmarked < MAXMARKS Then
        For i = marks.nmarked - 1 To inspos Step -1
            marks.mark(i + 1) = marks.mark(i)
        Next
    Else
        For i = 1 To inspos
            marks.mark(i - 1) = marks.mark(i)
        Next
    End If
    marks.mark(inspos) = msgid
    marks.nmarked = marks.nmarked + 1
    junk = swrtdpkv(MARKDPK & Format$(forumid, FORIDFMT), Len(marks), marks)
End Sub

Function msgmarked (ByVal forumid As Integer, ByVal msgid As Long) As Integer
' return whether a message has been read

    Dim comp As Long

    msgmarked = False
    If marks.forumid <> forumid Or Not marksread Then
        marksread = True
        If sreadpk(MARKDPK & Format$(forumid, FORIDFMT), Len(marks), marks) = 0 Then
            marks.forumid = forumid     ' probably want to continue using this forum
            marks.nmarked = 0
            Exit Function
        End If
    End If
    If marks.nmarked = MAXMARKS Then
        If msgid < marks.mark(0) Then
            msgmarked = True
            Exit Function
        End If
    End If
    comp = 1
    junk = nearmark(comp, msgid, marks)
    msgmarked = (comp = 0)
End Function

Private Function nearmark (comp As Long, ByVal msgid As Long, mark As markedmsgs) As Integer
' find index of mark nearest to specified message ID
' comp:     result of last comparison
' msgid:    message ID being searched for
' returns index in mark.mark() array

    Dim lo As Integer, md As Integer, hi As Integer

    md = -1
    lo = 0
    hi = mark.nmarked - 1
    Do While lo <= hi
        md = lo + Int((hi - lo) / 2)
        comp = msgid - mark.mark(md)
        If comp < 0 Then
            hi = md - 1
        ElseIf comp > 0 Then
            lo = md + 1
        Else
            Exit Do
        End If
    Loop
    nearmark = md
End Function

