'****************************************************************************
'*                                                                          *
'*  FORLIST.BAS                                                             *
'*                                                                          *
'*  Copyright (c) 1995-1997 Galacticomm, Inc.    All Rights Reserved.       *
'*                                                                          *
'*  This file contains declarations and functions for listing forums.       *
'*                                                                          *
'*                                                  - J. Alvrus 1/9/95      *
'*                                                                          *
'****************************************************************************

Option Explicit

Global Const MAXFLST = 1000         ' max forums can hold in a list at once

' forum select mode constants
Global Const SELSINGLE = 0          ' select a single forum
Global Const SELMULT = 1            ' select multiple forums
Global Const SELMULTNA = 2          ' select multiple forums, no all flag

' forum list mode constants
Global Const LSTMODEFOR = 0         ' show all forums in list
Global Const LSTMODEGRP = 1         ' show groups in list

Const USRFORFILDPK = "sa=GALFOR;ul:forfil"
Const USRGRPFILDPK = "sa=GALFOR;ul:grpfil"

Type forinfmem                      ' forum info in memory structure
    forum As Integer                '   forum ID
    axes As String * 1              '   access level byte
    topic As String * TPCSIZ        '   forum topic
    name As String * FORNSZ         '   forum name
End Type

Type grpinfmem                      ' group info in memory (for lists) structure
     grpid As Integer               '   group ID
     parid As Integer               '   group ID of this group's parent
     name As String * FORNSZ        '   group name
     topic As String * TPCSIZ       '   group topic
End Type

Global forloaded As Integer         ' is forum info loaded?
Global grploaded As Integer         ' is group info file name loaded?
Global forupdated As Integer        ' has forum info file been updated this session?
Global grpupdated As Integer        ' has group info file been updated this session?
Global forfilename As String        ' forum info file name
Global grpfilename As String        ' group info file name
Global forinfarr() As forinfmem     ' array of forum info
Global grpinfarr() As grpinfmem     ' array of group info

Dim forconnected As Integer         ' forum info code initiated connection
Dim sysopflg As Integer             ' Sysop info is being used
Dim forinfrqid As Integer           ' forum info download request ID
Dim grpinfrqid As Integer           ' group info download request ID
Dim forreload As Integer            ' forum info needs to be reloaded
Dim grpreload As Integer            ' group info needs to be reloaded
Dim forlstbaseidx As Integer        ' index of first list box item in array
Dim firstgrpidx As Integer          ' index of first group item in list
Dim curgrpstr As String             ' string describing current group

Sub addforum (ByVal fornam As String)
' add a new forum to in-memory info

    Dim i As Integer, newidx As Integer, comp As Integer
    Dim forinf As foruminf

    If forconnect() Then
        fornam = rdforinf(fornam, forinf)
        If Len(fornam) Then
            comp = 1
            newidx = nearfidx(comp, fornam, forinfarr())
            If comp > 0 Then
                newidx = newidx + 1
            End If
            ReDim Preserve forinfarr(ninfarr(forinfarr()))
            For i = UBound(forinfarr) To newidx + 1 Step -1
                forinfarr(i) = forinfarr(i - 1)
            Next
            LSet forinfarr(newidx) = forinf
            forinfarr(newidx).name = fornam
        End If
    End If
End Sub

Function addgrpfilgrp (ByVal grpidx As Integer) As Integer
' add a new group to group information file
' grpidx:   index in group info array of new group
' returns True if successful

    Dim fin As Integer, fout As Integer
    Dim searching As Integer, found As Integer
    Dim parid As Integer, grpid As Integer, tmpid As Integer
    Dim tmps As String, tmpfnam As String, grpstr As String
    Dim tmppar As String, tmpnam As String, tmptpc As String

    addgrpfilgrp = False
    parid = grpinfarr(grpidx).parid
    grpid = grpinfarr(grpidx).grpid
    grpstr = gengrpstr(grpidx) & " " & CStr(grpid) & " " & Trim$(grpinfarr(grpidx).topic)
    tmpfnam = newgrpfilnam()
    On Error GoTo addgrpfilgrperr
    fin = FreeFile
    Open grpfilename For Input Access Read As fin
    fout = FreeFile
    Open tmpfnam For Output Access Write As fout
    searching = (parid <> ROOTGRPID)
    found = Not searching
    While Not EOF(fin)
        Line Input #fin, tmps
        If searching Then
            If isgroup(tmps) Then
                parsegrp tmps, tmppar, tmpnam, tmpid, tmptpc
                If tmpid = parid Then
                    searching = False
                    found = True
                End If
            End If
        ElseIf found Then
            If isgroup(tmps) Then
                Print #fout, grpstr
                found = False
            End If
        End If
        Print #fout, tmps
    Wend
    If found Then
        Print #fout, grpstr
    End If
    Close fin
    Close fout
    If searching Then
        Kill tmpfnam
    Else
        Kill grpfilename
        Name tmpfnam As grpfilename
        addgrpfilgrp = True
    End If
    Exit Function
addgrpfilgrperr:
    poperror "Error #" & CStr(Err) & " updating group information file (" & Error$(Err) & ")", ""
    If fexist(tmpfnam, False) Then
        Kill tmpfnam
    End If
    Exit Function
End Function

Function anygroups () As Integer
' are there any groups currently defined/in use on this system

    anygroups = False
    If fexist(grpfilename, False) Then
        On Error Resume Next
        anygroups = (FileLen(grpfilename) <> 0)
    End If
End Function

Sub canforinfdl ()
' cancel forum info download

    Dim tmpid As Integer

    If forinfrqid >= 0 Then
        tmpid = forinfrqid
        forinfrqid = -1
        abodpk tmpid
    End If
    If grpinfrqid >= 0 Then
        tmpid = grpinfrqid
        grpinfrqid = -1
        abodpk tmpid
    End If
End Sub

Function chkforlst () As Integer
' check if forum list is ready to be used

    Dim toosoon As Integer, lastprog As Integer, curprog As Integer
    Dim totlen As Long, curlen As Long
    Dim dpkprg As dpkprg

    chkforlst = False
    chkreload
    If forloaded And grploaded Then
        chkforlst = True
    ElseIf fordlipg() Then
        lastprog = 0
        progopen PRGT_BAR, "Getting Forum Information", "Forum information is being retrieved, please wait.", "", ""
        Do
            toosoon = False
            totlen = 0
            curlen = 0
            If forinfrqid < 0 Then
                If forupdated Then
                    totlen = FileLen(forfilename)
                    curlen = totlen
                End If
            Else
                prgdpk forinfrqid, dpkprg
                If dpkprg.totlen = -1 Then
                    toosoon = True
                Else
                    totlen = dpkprg.totlen
                    curlen = dpkprg.dsofar
                End If
            End If
            If grpinfrqid < 0 Then
                If grpupdated Then
                    totlen = totlen + FileLen(grpfilename)
                    curlen = curlen + FileLen(grpfilename)
                End If
            Else
                prgdpk grpinfrqid, dpkprg
                If dpkprg.totlen = -1 Then
                    toosoon = True
                Else
                    totlen = totlen + dpkprg.totlen
                    curlen = curlen + dpkprg.dsofar
                End If
            End If
            If totlen <> 0 And Not toosoon Then
                curprog = 100 * curlen \ totlen
                If curprog <> lastprog Then
                    progupdate CStr(curprog)
                    lastprog = curprog
                End If
            End If
            DoEvents
            If progcancel() Then
                progclose
                canforinfdl
                Exit Function
            End If
        Loop While fordlipg()
        progupdate "100"
        chkreload
        progclose
        chkforlst = forloaded And grploaded
    End If
End Function

Sub chkreload ()
' check for group/forum info needing reload

    If forreload Then
        forloaded = False
        loadforinf forfilename, forinfarr()
        forreload = False
    End If
    If grpreload Then
        If sysopflg Then
            grploaded = False
            loadgrpinf grpfilename, grpinfarr()
        Else
            grploaded = fexist(grpfilename, False)
        End If
        grpreload = False
    End If
End Sub

Private Sub delforidx (ByVal arridx As Integer, forarr() As forinfmem)
' delete a forum from forum info array given index

    Dim i As Integer, n As Integer

    n = ninfarr(forarr())
    For i = arridx To n - 2
        forarr(i) = forarr(i + 1)
    Next
    If n <= 1 Then
        Erase forarr
    Else
        ReDim Preserve forarr(n - 2)
    End If
End Sub

Sub delforum (ByVal fornam As String)
' delete a forum from memory
' fornam:   name of forum to delete

    Dim i As Integer

    i = getfidx(fornam, forinfarr())
    If i >= 0 Then
        delforidx i, forinfarr()
    End If
End Sub

Function delgrpfilgrp (ByVal grpidx As Integer) As Integer
' update group information file with new group information
' grpidx:   index in group info array of group that changed
' returns True if successful

    Dim i As Integer, fin As Integer, fout As Integer
    Dim searching As Integer, foundnext As Integer, targetid As Integer, grpid As Integer
    Dim tmps As String, tmpfnam As String, grpstr As String
    Dim tmppar As String, tmpnam As String, tmptpc As String

    delgrpfilgrp = False
    targetid = grpinfarr(grpidx).grpid
    grpstr = gengrpstr(grpidx)
    If Len(grpstr) Then
        grpstr = grpstr & "/"
    End If
    For i = grpidx To ningarr(grpinfarr()) - 2
        grpinfarr(i) = grpinfarr(i + 1)
    Next
    ReDim Preserve grpinfarr(ningarr(grpinfarr()) - 2)
    tmpfnam = newgrpfilnam()
    On Error GoTo delgrpfilgrperr
    fin = FreeFile
    Open grpfilename For Input Access Read As fin
    fout = FreeFile
    Open tmpfnam For Output Access Write As fout
    searching = True
    Do Until EOF(fin)
        Line Input #fin, tmps
        If searching Then
            If isgroup(tmps) Then
                parsegrp tmps, tmppar, tmpnam, grpid, tmptpc
                If grpid = targetid Then
                    searching = False
                    foundnext = False
                    Do Until EOF(fin)
                        Line Input #fin, tmps
                        If Not sameto(grpstr, tmps) Then
                            foundnext = True
                            Exit Do
                        End If
                    Loop
                    If Not foundnext Then
                        Exit Do
                    End If
                End If
            End If
        End If
        Print #fout, tmps
    Loop
    Close fin
    Close fout
    Kill grpfilename
    Name tmpfnam As grpfilename
    delgrpfilgrp = True
    Exit Function
delgrpfilgrperr:
    poperror "Error #" & CStr(Err) & " updating group information file (" & Error$(Err) & ")", ""
    If fexist(tmpfnam, False) Then
        Kill tmpfnam
    End If
    Exit Function
End Function

Private Function fididx (ByVal forum As Integer, ByVal nforums As Integer, forarr() As Integer) As Integer
' find forum in array of forum IDs
' forum:    forum ID being searched for
' nforums:  number of forums in array
' forarr:   array of forum info
' returns index in forarr() array or -1 if not found

    Dim i As Integer

    For i = 0 To nforums - 1
        If forarr(i) = forum Then
            fididx = i
            Exit Function
        End If
    Next
    fididx = -1
End Function

Private Function forconnect () As Integer
' forum info connection handler

    forconnected = True
    forconnect = appconnect()
    forconnected = False
End Function

Function fordlipg () As Integer
' is forum info download still in progress?

    fordlipg = forinfrqid >= 0 Or grpinfrqid >= 0
End Function

Sub forinfcbk (ByVal evtstg As String, ByVal reqid As Integer)
' forum info download handler

    Dim tmps As String

    If reqid = forinfrqid Then
        forinfrqid = -1
        Select Case evtstg
        Case "Dynapak received"
            tmps = cbkrspv()
            If Len(tmps) Then
                If Not sysopflg Then
                    On Error Resume Next
                    Kill forfilename
                    On Error GoTo 0
                    setforfilnam tmps
                End If
                forfilename = tmps
                forupdated = True
                forreload = True
                Exit Sub
            End If
        Case "Offline read denied"
            'do nothing
        Case Else
            If Not appclsipg Then
                freeup
                poperror "Unable to download forum information", ""
            End If
        End Select
    ElseIf reqid = grpinfrqid Then
        grpinfrqid = -1
        Select Case evtstg
        Case "Dynapak received"
            tmps = cbkrspv()
            If Len(tmps) Then
                If Not sysopflg Then
                    On Error Resume Next
                    Kill grpfilename
                    On Error GoTo 0
                    setgrpfilnam tmps
                End If
                grpfilename = tmps
                grpupdated = True
                grpreload = True
                Exit Sub
            End If
        Case "Offline read denied"
            'do nothing
        Case Else
            If Not appclsipg Then
                freeup
                poperror "Unable to download group information", ""
            End If
        End Select
    End If
End Sub

Sub forinfconn (cbk As CallBack)
' group/forum info connection handler
' cbk:  callback handler to use to get group/forum info

    reqforchgnot
    If Not forconnected And Not sysopflg And Not (forupdated And grpupdated) Then
        junk = getforusrinf(False, cbk)
    End If
End Sub

Function forinfusdpk (cbk As CallBack) As Integer
' group/forum info unsolicited dynapak handler
' cbk:  callback handler to use to get new info
' returns True if handled dynapak

    Dim i As Integer
    Dim tmps As String, fornam As String
    Dim forinf As foruminf

    forinfusdpk = False
    tmps = suffix(namdpk())
    If sameto(NFNOTDPK, tmps) Or sameto(MFNOTDPK, tmps) Or sameto(DFNOTDPK, tmps) Then
        forinfusdpk = True
        hdlforinfchg cbk
    End If
End Function

Function forlstarridx (ByVal lstidx As Integer) As Integer
' get forum info array index given forum list index
' returns -1 if lstidx is out of bounds

    Dim maxlstidx As Integer

    forlstarridx = -1
    If lstidx > 0 Or forlstbaseidx = 0 Then
        maxlstidx = ninfarr(forinfarr())
        If maxlstidx > MAXFLST Then
            maxlstidx = MAXFLST
        End If
        If forlstbaseidx Then
            lstidx = lstidx - 1
        End If
        If lstidx < maxlstidx Then
            forlstarridx = forlstbaseidx + lstidx
        End If
    End If
End Function

Sub forlstclick (fornam As TextBox, ByVal lstidx As Integer)
' handle forum list click and associated text box
' fornam:   text box associated with forum list
' lstidx:   ListIndex of selected item

    Dim tmps As String

    tmps = forlstfornam(lstidx)
    If Len(tmps) Then
        fornam = tmps
        fornam.SelStart = 0
        fornam.SelLength = Len(tmps)
    Else
        fornam = ""
    End If
End Sub

Function forlstfornam (ByVal lstidx As Integer) As String
' get forum name from forum list
' lstidx:   list index to get name for

    forlstfornam = ""
    lstidx = forlstarridx(lstidx)
    If lstidx >= 0 Then
        forlstfornam = Trim$(forinfarr(lstidx).name)
    End If
End Function

Function forlstidx (ByVal arridx As Integer) As Integer
' get forum list index give forum array index

    Dim maxlstidx As Integer

    forlstidx = -1
    maxlstidx = ninfarr(forinfarr())
    If maxlstidx > MAXFLST Then
        maxlstidx = MAXFLST
    End If
    If arridx >= forlstbaseidx And arridx - forlstbaseidx < maxlstidx Then
        If forlstbaseidx Then
            arridx = arridx + 1
        End If
        forlstidx = arridx - forlstbaseidx
    End If
End Function

Sub forusrinit (cbk As CallBack)
' initialize group/forum info for normal users
' cbk:  CallBack handler to use to read group/forum information

    Dim tmpnam As String

    initforinf
    tmpnam = getforfilnam()
    If Len(tmpnam) Then
        loadforinf tmpnam, forinfarr()
        If forloaded Then
            forfilename = tmpnam
        End If
    End If
    tmpnam = getgrpfilnam()
    If Len(tmpnam) Then
        If fexist(tmpnam, False) Then
            grploaded = True
            grpfilename = tmpnam
        End If
    End If
    If Not (forloaded And grploaded) Then
        junk = forconnect()
    End If
    If connected() Then
        reqforchgnot
        junk = getforusrinf(False, cbk)
    End If
End Sub

Function fstforlstforidx () As Integer
' get list index of first forum in forum list

    fstforlstforidx = 0
    If forlstbaseidx Then
        fstforlstforidx = 1
    End If
End Function

Function fstgrplstforidx () As Integer
' get list index of first forum in group/forum list

    fstgrplstforidx = 0
    If Len(curgrpstr) Then
        fstgrplstforidx = 1
    End If
End Function

Function gengrpstr (ByVal grpidx As Integer) As String
' generate string describing group
' grpidx:   index of group in group info array

    Dim curpar As Integer
    Dim tmps As String

    curpar = grpinfarr(grpidx).parid
    tmps = Trim$(grpinfarr(grpidx).name)
    Do While curpar
        grpidx = grpidx - 1
        If grpinfarr(grpidx).grpid = curpar Then
            tmps = Trim$(grpinfarr(grpidx).name) & "/" & tmps
            curpar = grpinfarr(grpidx).parid
        End If
    Loop
    gengrpstr = tmps
End Function

Function getfidx (ByVal fornam As String, forarr() As forinfmem) As Integer
' get index of forum in array of in-memory forum info
' fornam:   name to search for
' forarr:   forum info array to search
' returns index in forarr() or -1 if not found

    Dim i As Integer, comp As Integer

    getfidx = -1
    i = nearfidx(comp, fornam, forarr())
    If i >= 0 And comp = 0 Then
        getfidx = i
    End If
End Function

Private Function getforfilnam () As String
' get current forum info file name

    Dim tmps As String

    getforfilnam = ""
    tmps = sreadpkv(FORFILLDPK)
    If Len(tmps) Then
        getforfilnam = infdirnam() & "\" & fnpart(tmps)
    End If
End Function

Function getforinf (forinf As foruminf, fornam As String) As Integer
' get forum info for a given forum
' forinf:   buffer to place forum info into
' fornam:   name of forum to get info on, updated with correct capitalization
' returns False if couldn't get forum info

    Dim i As Integer
    Dim tmpnam As String
    Dim tmpforinf As foruminf

    getforinf = False
    If sameas(fornam, Trim$(prefs.curfor)) And curforinf.forum <> EMLID Then
        fornam = Trim$(prefs.curfor)
        forinf = curforinf
        getforinf = True
    Else
        If forloaded Then
            i = getfidx(fornam, forinfarr())
            If i >= 0 Then
                LSet forinf = forinfarr(i)
                fornam = Trim$(forinfarr(i).name)
                getforinf = True
                Exit Function
            End If
        End If
        tmpnam = rdforinf(fornam, forinf)
        If Len(tmpnam) Then
            fornam = tmpnam
            getforinf = True
        End If
    End If
End Function

Function getforsysinf (ByVal showprog As Integer, cbk As CallBack) As Integer
' get sysop-level forum information
' showprog: show progress while downloading
' cbk:      callback handler to use
' returns False if showprog = True and user cancels

    getforsysinf = False
    If forconnect() Then
        forreload = False
        grpreload = False
        sysopflg = True
        forinfrqid = readpk("(f=""" & infdirnam() & "\sysfor.inf"")" & FORFILSDPK, cbk)
        grpinfrqid = readpk("(f=""" & infdirnam() & "\sysgrp.inf"")" & GRPFILSDPK, cbk)
        getforsysinf = True
        If showprog Then
            getforsysinf = chkforlst()
        End If
    End If
End Function

Function getForumName (ByVal forum As Integer, ByVal dftName As String) As String
' get forum name given forum ID

    Dim i As Integer

    getForumName = Trim$(dftName)
    For i = 0 To ninfarr(forinfarr()) - 1
        If forinfarr(i).forum = forum Then
            If i >= 0 Then
                getForumName = Trim$(forinfarr(i).name)
            End If
            Exit Function
        End If
    Next
End Function

Function getforusrinf (ByVal showprog As Integer, cbk As CallBack) As Integer
' get user-specific forum information
' showprog: show progress while downloading
' cbk:      callback handler to use
' returns False if showprog = True and user cancels

    getforusrinf = False
    If forconnect() Then
        forreload = False
        grpreload = False
        forinfrqid = readpk("(f=""" & newforfilnam() & """)(o=u)" & FORFILDPK, cbk)
        grpinfrqid = readpk("(f=""" & newgrpfilnam() & """)(o=u)" & GRPFILDPK, cbk)
        getforusrinf = True
        sysopflg = False
        If showprog Then
            getforusrinf = chkforlst()
        End If
    End If
End Function

Function getgidx (ByVal grpid As Integer, grparr() As grpinfmem) As Integer
' find index of group in array of group info given group ID
' grpid:    group ID being sought
' grparr:   array of group info structures to search
' returns index in grparr() or -1 if not found

    Dim i As Integer

    For i = 0 To ningarr(grparr()) - 1
        If grparr(i).grpid = grpid Then
            getgidx = i
            Exit Function
        End If
    Next
    getgidx = -1
End Function

Private Function getgrpfilnam () As String
' get current group info file name

    Dim tmps As String

    getgrpfilnam = ""
    tmps = sreadpkv(GRPFILLDPK)
    If Len(tmps) Then
        getgrpfilnam = infdirnam() & "\" & fnpart(tmps)
    End If
End Function

Function grplinitem (ByVal grpnam As String, ByVal grptpc As String) As String
' generate group outline item string
' grpnam:   group name
' grptpc:   group topic

    Dim tmps As String

    tmps = grpnam
    If Len(grptpc) Then
        tmps = tmps & " - " & grptpc
    End If
    grplinitem = tmps
End Function

Sub grplstclick (fornam As TextBox, lst As Control)
' handle group/forum list click and associated text box
' fornam:   text box associated with list
' lst:      list box holding group/forum list

    Dim lstidx As Integer

    lstidx = getlbcaret(lst)
    If lstidx = 0 And Len(curgrpstr) <> 0 Then
        fornam = ""
    Else
        fornam = itemidx(lst.List(lstidx), 0)
        fornam.SelStart = 0
        fornam.SelLength = Len(fornam)
    End If
End Sub

Function grplstforid (lst As Control, ByVal lstidx As Integer) As Integer
' get forum ID from group/forum list
' lst:      list box containing list
' lstidx:   index of item
' returns EMLID if not a forum

    Dim i As Integer

    grplstforid = EMLID
    i = getfidx(grplstfornam(lst, lstidx), forinfarr())
    If i >= 0 Then
        grplstforid = forinfarr(i).forum
    End If
End Function

Function grplstfornam (lst As Control, ByVal lstidx As Integer) As String
' get forum name from group/forum list
' lst:      list box displaying list
' lstidx:   index of item in list

    grplstfornam = ""
    If (lstidx > 0 Or Len(curgrpstr) = 0) And lstidx < firstgrpidx Then
        grplstfornam = itemidx(lst.List(lstidx), 0)
    End If
End Function

Sub hdlforinfchg (cbk As CallBack)
' handle forum info change
' cbk:  callback handler to use to get new group/forum info

    If Not fordlipg() Then
        forupdated = False
        grpupdated = False
        If Not sysopflg Then
            junk = getforusrinf(False, cbk)
        End If
    End If
End Sub

Private Function infdirnam () As String
' generate forum/group info file directory name

    Dim tmpnam As String

    tmpnam = sysappdir(MSGAPID) & "\forinf"
    On Error Resume Next
    MkDir tmpnam
    infdirnam = tmpnam
End Function

Sub initforinf ()
' initialize group/forum info handler

    forloaded = False
    grploaded = False
    forupdated = False
    grpupdated = False
    forreload = False
    grpreload = False
    forinfrqid = -1
    grpinfrqid = -1
End Sub

Function isgroup (ByVal s As String) As Integer
' is group info file line a group
' s:    string to check

    isgroup = (InStr(Trim$(s), " ") <> 0)
End Function

Function isgrplstforum (ByVal lstidx As Integer) As Integer
' is the given list index a forum (not a group)

    If Len(curgrpstr) Then
        isgrplstforum = lstidx > 0 And lstidx < firstgrpidx
    Else
        isgrplstforum = lstidx < firstgrpidx
    End If
End Function

Function lastforlstforidx () As Integer
' get list index of last forum in forum list

    Dim i As Integer, n As Integer

    n = ninfarr(forinfarr())
    If n > MAXFLST Then
        n = MAXFLST
    End If
    i = n - 1
    If forlstbaseidx Then
        i = i + 1
    End If
    lastforlstforidx = i
End Function

Function lastgrplstforidx () As Integer
' get list index of last forum in group/forum list

    lastgrplstforidx = firstgrpidx - 1
End Function

Sub loadforinf (ByVal filename As String, forarr() As forinfmem)
' load forum info file into memory
' filename: name of forum info file to load
' forarr:   array of forum information to load into

    Dim f As Integer, n As Integer, i As Integer, ok As Integer
    Dim tmps As String
    Dim tmpinf As forinfmem

    ok = False
    f = FreeFile
    On Error GoTo loadforinferropn
    Open filename For Input Access Read As f
    On Error GoTo loadforinferrrd
    n = 0
    While Not EOF(f)
        Line Input #f, tmps
        i = InStr(tmps, " ")
        tmpinf.name = Trim$(Left$(tmps, i - 1))
        tmps = Mid$(tmps, i + 1)
        i = InStr(tmps, " ")
        tmpinf.forum = Val(Left$(tmps, i - 1))
        tmps = Mid$(tmps, i + 1)
        i = InStr(tmps, " ")
        tmpinf.axes = Chr$(Val(Left$(tmps, i - 1)))
        tmpinf.topic = Trim$(Mid$(tmps, i + 1))
        ReDim Preserve forarr(n)
        forarr(n) = tmpinf
        n = n + 1
    Wend
    ok = True
loadforinferrrd:
    Close f
    forloaded = ok
    If Not ok Then
        Kill filename
        Erase forarr
    End If
loadforinferropn:
    Exit Sub
End Sub

Sub loadgrpinf (ByVal filename As String, grparr() As grpinfmem)
' load a group information file into an array
' filename: name of group information file
' grparr:   array of group info structures

    Dim f As Integer, n As Integer, grpid As Integer, ok As Integer
    Dim stack() As Integer              ' stack of parent group IDs
    Dim tmps As String, parstr As String, grppar As String, grpnam As String, grptpc As String

    ok = False
    ReDim grparr(0)
    grparr(0).grpid = ROOTGRPID
    n = 1
    parstr = ""
    ReDim stack(0)
    stack(0) = ROOTGRPID
    f = FreeFile
    On Error GoTo loadgrpinferropn
    Open filename For Input Access Read As f
    On Error GoTo loadgrpinferrrd
    While Not EOF(f)
        Line Input #f, tmps
        If isgroup(tmps) Then
            parsegrp tmps, grppar, grpnam, grpid, grptpc
            If Not sameas(grppar, parstr) Then
                If Len(grppar) > Len(parstr) Then
                    ReDim Preserve stack(UBound(stack) + 1)
                    stack(UBound(stack)) = grparr(n - 1).grpid
                    parstr = grppar
                Else
                    Do
                        ReDim Preserve stack(UBound(stack) - 1)
                        parstr = itemdeld(parstr, itemcntd(parstr, "/") - 1, "/")
                    Loop Until sameas(grppar, parstr)
                End If
            End If
            ReDim Preserve grparr(n)
            grparr(n).parid = stack(UBound(stack))
            grparr(n).grpid = grpid
            grparr(n).name = grpnam
            grparr(n).topic = grptpc
            n = n + 1
        End If
    Wend
    ok = True
loadgrpinferrrd:
    Close f
    grploaded = ok
    If Not ok Then
        Kill filename
        ReDim Preserve grparr(0)
    End If
loadgrpinferropn:
    Exit Sub
End Sub

Private Function nearfidx (comp As Integer, ByVal fornam As String, forarr() As forinfmem) As Integer
' find index of forum closest to a given name
' comp:     result of last comparison
' fornam:   forum name being searched for
' forarr:   array of forum info (must be sorted in forum name order)
' returns index in forarr() array

    Dim lo As Integer, md As Integer, hi As Integer

    md = -1
    lo = 0
    On Error GoTo fnotdimmed
    hi = UBound(forarr)
    On Error GoTo 0
    Do While lo <= hi
        md = lo + Int((hi - lo) / 2)
        comp = stricmp(fornam, Trim$(forarr(md).name))
        If comp < 0 Then
            hi = md - 1
        ElseIf comp > 0 Then
            lo = md + 1
        Else
            Exit Do
        End If
    Loop
fnotdimmed:
    nearfidx = md
    Exit Function
End Function

Private Function newforfilnam () As String
' create a new forum info file path and name

    newforfilnam = uniquefn(infdirnam(), ".for")
End Function

Private Function newgrpfilnam () As String
' create a new group info file path and name

    newgrpfilnam = uniquefn(infdirnam(), ".grp")
End Function

Function ninfarr (infarr() As forinfmem) As Integer
' get number of forums in an array of info

    ninfarr = 0
    On Error GoTo noforums
    ninfarr = UBound(infarr) + 1
noforums:
    Exit Function
End Function

Function ningarr (grparr() As grpinfmem) As Integer
' get number of items in a group info array

    ningarr = 0
    On Error GoTo ningarrerr
    ningarr = UBound(grparr) + 1
ningarrerr:
    Exit Function
End Function

Sub parsegrp (ByVal grpstr As String, grppar As String, grpnam As String, grpid As Integer, grptpc As String)
' parse a group info file line into it's component parts
' grpstr:   info file line string
' grppar:   parent group string (e.g., "group1/group12/group121")
' grpnam:   group name
' grpid:    group ID
' grptpc:   group topic

    Dim i As Integer, lasti As Integer
    Dim tmps As String

    tmps = Left$(grpstr, InStr(grpstr, " ") - 1)
    lasti = 0
    i = InStr(tmps, "/")
    While i
        lasti = i
        i = InStr(lasti + 1, tmps, "/")
    Wend
    If lasti Then
        grppar = Left$(grpstr, lasti - 1)
    Else
        grppar = ""
    End If
    i = InStr(grpstr, " ")
    grpnam = Mid$(grpstr, lasti + 1, i - lasti - 1)
    lasti = i
    i = InStr(lasti + 1, grpstr, " ")
    grpid = Val(Mid$(grpstr, lasti + 1, i - lasti - 1))
    grptpc = Trim$(Mid$(grpstr, i + 1))
End Sub

Function rdforinf (ByVal fornam As String, forinf As foruminf) As String
' read forum info
' fornam:   name of forum to read
' forinf:   forum info structure to fill in
' returns correctly-capitalized forum name if successful

    Dim tmpnam As String
    Dim tmpforinf As foruminf

    If srgtdpk(wtspace(FINFODPK & olthan(fornam, FORNSZ)), wtspace(FINFOSFX), Len(tmpforinf), tmpforinf) Then
        tmpnam = itemidxd(suffix(namdpk()), 1, " ")
        If sameas(tmpnam, fornam) Then
            rdforinf = tmpnam
            forinf = tmpforinf
        End If
    End If
End Function

Function rengrpfilfor (ByVal oldnam As String, ByVal newnam As String) As Integer
' rename a forum in group info file
' oldnam:   old forum name
' newnam:   new forum name

    Dim i As Integer, lasti As Integer, namidx As Integer, fin As Integer, fout As Integer
    Dim tmps As String, tmpfnam As String, tmppar As String, tmpfor As String

    rengrpfilfor = False
    tmpfnam = newgrpfilnam()
    On Error GoTo rengrpfilforerr
    fin = FreeFile
    Open grpfilename For Input Access Read As fin
    fout = FreeFile
    Open tmpfnam For Output Access Write As fout
    While Not EOF(fin)
        Line Input #fin, tmps
        If Not isgroup(tmps) Then
            lasti = 0
            i = InStr(tmps, "/")
            While i
                lasti = i
                i = InStr(lasti + 1, tmps, "/")
            Wend
            If lasti Then
                tmpfor = Mid$(tmps, lasti + 1)
                tmppar = Left$(tmps, lasti)
            Else
                tmpfor = tmps
                tmppar = ""
            End If
            If sameas(oldnam, tmpfor) Then
                tmps = tmppar & newnam
            End If
        End If
        Print #fout, tmps
    Wend
    Close fin
    Close fout
    Kill grpfilename
    Name tmpfnam As grpfilename
    rengrpfilfor = True
    Exit Function
rengrpfilforerr:
    poperror "Error #" & CStr(Err) & " updating group information file (" & Error$(Err) & ")", ""
    If fexist(tmpfnam, False) Then
        Kill tmpfnam
    End If
    Exit Function
End Function

Sub reqforchgnot ()
' request notification of changes in forum info

    Dim dummy As Integer

    junk = swrtdpkv(FORNOTDPK & curapid(), Len(dummy), dummy)
End Sub

Function selforum (ByVal fornam As String, forinf As foruminf, ByVal movlst As Integer, lst As Control) As String
' select a forum from a forum list
' fornam:   name of forum to select
' forinf:   buffer to hold forum info (if any read)
' movlst:   move list highlight even if exact match found
' lst:      list box containing forum list
' returns forum name (with correct capitalization) or "" if exact match not found
' If an exact match for the forum name is not found, the closest match in the list will be highlighted
' or the list will be refreshed to include forums with names close to the suggested forum.
' This function also handles the "more..." entries if there are any.

    Dim i As Integer, comp As Integer
    Dim tmpnam As String
    Dim tmpinf As foruminf

    selforum = ""
    If Len(fornam) Then
        If ninfarr(forinfarr()) Then
            comp = 1
            i = nearfidx(comp, fornam, forinfarr())
            If comp Then
                If comp > 0 Then
                    i = i + 1
                End If
                If i < forlstbaseidx Or i >= forlstbaseidx + MAXFLST Then
                    showforlst fornam, lst
                Else
                    If forlstbaseidx Then
                        i = i - forlstbaseidx + 1
                    End If
                    If i >= lst.ListCount Then
                        i = lst.ListCount - 1
                    End If
                    setlbidx lst, i
                End If
            Else
                LSet forinf = forinfarr(i)
                selforum = Trim$(forinfarr(i).name)
                If movlst Then
                    If i < forlstbaseidx Or i >= forlstbaseidx + MAXFLST Then
                        showforlst fornam, lst
                    Else
                        If forlstbaseidx Then
                            i = i - forlstbaseidx + 1
                        End If
                        setlbidx lst, i
                    End If
                End If
            End If
        End If
    Else
        If getlbcaret(lst) = 0 And forlstbaseidx <> 0 Then
            showforlst Trim$(forinfarr(forlstbaseidx - 1).name), lst
        ElseIf getlbcaret(lst) = lst.ListCount - 1 And (ninfarr(forinfarr()) > forlstbaseidx + MAXFLST) Then
            showforlst Trim$(forinfarr(forlstbaseidx + MAXFLST).name), lst
        End If
    End If
End Function

Function selgrpfor (ByVal fornam As String, grpstr As String, forinf As foruminf, ByVal movlst As Integer, lst As Control) As String
' select a group or forum from a group/forum list
' fornam:   partial forum name to find
' grpstr:   string describing current group - updated if switch groups
' forinf:   forum info buffer (filled in if exact forum selected)
' movlst:   move list highlight even if exact match found
' lst:      list box containing list
' returns forum name (with correct capitalization) or "" if exact match not found
' If an exact match for the forum name is not found, the closest match in the list will be highlighted.
' If an exact match to a group is found, the list will be reloaded to display that group.
' This function also handles the "back up a group" entry if any.

    Dim curlstidx As Integer, lstidx As Integer, arridx As Integer, stidx As Integer, hiidx As Integer, comp As Integer

    selgrpfor = ""
    curlstidx = getlbcaret(lst)
    If fornam = ".." Or (Len(grpstr) <> 0 And Len(fornam) = 0 And curlstidx = 0) Then
        grpstr = itemdeld(grpstr, itemcntd(grpstr, "/") - 1, "/")
        showgrplst "", grpstr, lst
        Exit Function
    End If
    If sameas(fornam, itemidx(lst.List(curlstidx), 0)) Then
        If curlstidx < firstgrpidx Then
            arridx = getfidx(fornam, forinfarr())
            If arridx >= 0 Then
                selgrpfor = Trim$(forinfarr(arridx).name)
                LSet forinf = forinfarr(arridx)
            End If
        Else
            If Len(grpstr) Then
                grpstr = grpstr & "/"
            End If
            grpstr = grpstr & itemidx(lst.List(curlstidx), 0)
            showgrplst "", grpstr, lst
        End If
        Exit Function
    End If
    stidx = 0
    If Len(grpstr) Then
        stidx = 1
    End If
    hiidx = stidx - 1
    For lstidx = stidx To firstgrpidx - 1
        comp = stricmp(fornam, itemidx(lst.List(lstidx), 0))
        If comp = 0 Then
            arridx = getfidx(fornam, forinfarr())
            If arridx >= 0 Then
                selgrpfor = Trim$(forinfarr(arridx).name)
                LSet forinf = forinfarr(arridx)
                If movlst Then
                    setlbidx lst, lstidx
                End If
            End If
            Exit Function
        ElseIf comp > 0 Then
            hiidx = lstidx
        End If
    Next
    For lstidx = firstgrpidx To lst.ListCount - 1
        If sameas(fornam, itemidx(lst.List(lstidx), 0)) Then
            If Len(grpstr) Then
                grpstr = grpstr & "/"
            End If
            grpstr = grpstr & itemidx(lst.List(lstidx), 0)
            showgrplst "", grpstr, lst
            Exit Function
        End If
    Next
    If lst.ListCount Then
        hiidx = hiidx + 1
        If hiidx >= lst.ListCount Then
            hiidx = lst.ListCount - 1
        End If
        setlbidx lst, hiidx
    End If
End Function

Private Sub setforfilnam (ByVal newname As String)
' get current forum info file name
' newname:  new forum info file name

    newname = fnpart(newname)
    junk = swrtdpkv(FORFILLDPK, STGLEN, newname)
End Sub

Private Sub setgrpfilnam (ByVal newname As String)
' get current group info file name
' newname:  new group info file name

    newname = fnpart(newname)
    junk = swrtdpkv(GRPFILLDPK, STGLEN, newname)
End Sub

Sub setlbidx (lst As Control, ByVal idx As Integer)
' set list box index depending on selection type
' lst:  list box control
' idx:  index to set

    If lst.SelectionType = 1 Then   ' multi-select
        setlbcaret lst, idx
    Else                            ' normal or extended multi
        lst.ListIndex = idx
    End If
End Sub

Sub showforlst (ByVal fornam As String, lst As Control)
' start showing list of forums
' fornam:   name of forum to highlight (and center list on)
' lst:      list control to fill

    Dim i As Integer, n As Integer, lstmax As Integer, tmpidx As Integer, comp As Integer, hiidx As Integer

    If Not chkforlst() Then
        Exit Sub
    End If
    winrefresh lst.hWnd, False
    lst.Clear
    forlstbaseidx = 0
    comp = 1
    hiidx = nearfidx(comp, fornam, forinfarr())
    If comp > 0 Then
        hiidx = hiidx + 1
    End If
    n = ninfarr(forinfarr())
    lstmax = n - 1
    If n > MAXFLST Then
        lstmax = MAXFLST - 1
        If hiidx >= MAXFLST / 2 Then
            forlstbaseidx = hiidx - MAXFLST / 2 + 1
            If forlstbaseidx + MAXFLST > n Then
                forlstbaseidx = n - MAXFLST
            End If
            If forlstbaseidx < 0 Then
                forlstbaseidx = 0
            End If
        End If
    End If
    If forlstbaseidx Then
        lst.AddItem "more..."
        lst.Picture(0) = mainform!morebak
    End If
    For i = 0 To lstmax
        tmpidx = forlstbaseidx + i
        lst.AddItem Trim$(forinfarr(tmpidx).name) & tb & Trim$(forinfarr(tmpidx).topic)
        setflstbmp lst, lst.LastAdded, Asc(forinfarr(tmpidx).axes)
    Next
    If n > forlstbaseidx + MAXFLST Then
        lst.AddItem "more..."
        lst.Picture(lst.LastAdded) = mainform!morefwd
    End If
    If lst.ListCount Then
        If hiidx < 0 Then
            hiidx = 0
        ElseIf forlstbaseidx Then
            hiidx = hiidx - forlstbaseidx + 1
        End If
        If hiidx >= lst.ListCount Then
            hiidx = lst.ListCount - 1
        End If
        setlbidx lst, hiidx
    End If
    winrefresh lst.hWnd, True
    lst.Refresh
End Sub

Sub showgrplst (ByVal fornam As String, ByVal grpstr As String, lst As Control)
' show lst of forums/groups in a group
' fornam:   name of forum to highlight
' grpstr:   string describing group to lst
' lst:      lst box to load

    Dim i As Integer, f As Integer, hiidx As Integer
    Dim tmps As String, cmpstr As String, grppar As String, grpnam As String, grptpc As String

    If Not chkforlst() Then
        Exit Sub
    End If
    f = FreeFile
    On Error Resume Next
    Open grpfilename For Input Access Read As f
    If Err Then
        On Error GoTo 0
        poperror "Unable to open group information file!", ""
        Exit Sub
    End If
    On Error GoTo 0
    winrefresh lst.hWnd, False
    lst.Clear
    hiidx = 0
    curgrpstr = grpstr
    firstgrpidx = -1
    If Len(grpstr) Then
        lst.AddItem "(previous group)"
        lst.Picture(0) = mainform!backbmp
        cmpstr = grpstr & "/"
    Else
        cmpstr = ""
    End If
    While Not EOF(f)
        Line Input #f, tmps
        If sameto(cmpstr, tmps) Then
            If isgroup(tmps) Then
                parsegrp tmps, grppar, grpnam, i, grptpc
                If sameas(grpstr, grppar) Then
                    If firstgrpidx < 0 Then
                        firstgrpidx = lst.ListCount
                    End If
                    lst.AddItem grpnam & tb & grptpc
                    lst.Picture(lst.LastAdded) = mainform!groupbmp
                End If
            ElseIf InStr(Mid$(tmps, Len(cmpstr) + 1), "/") = 0 Then
                i = getfidx(Mid$(tmps, Len(cmpstr) + 1), forinfarr())
                If i >= 0 Then
                    lst.AddItem Trim$(forinfarr(i).name) & tb & Trim$(forinfarr(i).topic)
                    setflstbmp lst, lst.LastAdded, Asc(forinfarr(i).axes)
                    If stricmp(fornam, Trim$(forinfarr(i).name)) >= 0 Then
                        hiidx = lst.LastAdded
                    End If
                End If
            End If
        End If
    Wend
    If firstgrpidx < 0 Then
        firstgrpidx = lst.ListCount
    End If
    Close f
    If lst.ListCount Then
        setlbidx lst, hiidx
    End If
    winrefresh lst.hWnd, True
End Sub

Function updgrpfilfor (ByVal grpidx As Integer, ByVal nforums As Integer, forarr() As Integer) As Integer
' update forums associated with a group in a group info file
' grpidx:   index in group info array of group that changed
' nforums:  number of forums in array
' forarr:   array of forum IDs in group
' returns True if successful

    Dim i As Integer, j As Integer, namidx As Integer, fin As Integer, fout As Integer
    Dim searching As Integer, foundnext As Integer, targetid As Integer, grpid As Integer
    Dim tmps As String, tmpfnam As String, tmppar As String, tmpnam As String, tmptpc As String
    Dim namarr() As String * FORNSZ

    If nforums Then
        For i = 0 To nforums - 2
            For j = i + 1 To nforums - 1
                If forarr(j) < forarr(i) Then
                    namidx = forarr(i)
                    forarr(i) = forarr(j)
                    forarr(j) = namidx
                End If
            Next
        Next
        i = 0
        While i < nforums - 1
            If forarr(i) = forarr(i + 1) Then
                nforums = nforums - 1
                For j = i + 1 To nforums - 1
                    forarr(j) = forarr(j + 1)
                Next
            Else
                i = i + 1
            End If
        Wend
        ReDim namarr(nforums - 1)
        namidx = 0
        For i = 0 To ninfarr(forinfarr()) - 1
            j = fididx(forinfarr(i).forum, nforums, forarr())
            If j >= 0 Then
                namarr(namidx) = forinfarr(i).name
                namidx = namidx + 1
            End If
        Next
    End If
    updgrpfilfor = False
    targetid = grpinfarr(grpidx).grpid
    tmpfnam = newgrpfilnam()
    On Error GoTo updgrpfilforerr
    fin = FreeFile
    Open grpfilename For Input Access Read As fin
    fout = FreeFile
    Open tmpfnam For Output Access Write As fout
    If targetid = ROOTGRPID Then
        searching = False
        For i = 0 To nforums - 1
            Print #fout, Trim$(namarr(i))
        Next
        Do Until EOF(fin)
            Line Input #fin, tmps
            If isgroup(tmps) Then
                Print #fout, tmps
                Exit Do
            End If
        Loop
        Do Until EOF(fin)
            Line Input #fin, tmps
            Print #fout, tmps
        Loop
    Else
        searching = True
        Do Until EOF(fin)
            Line Input #fin, tmps
            If searching Then
                If isgroup(tmps) Then
                    parsegrp tmps, tmppar, tmpnam, grpid, tmptpc
                    If grpid = targetid Then
                        searching = False
                        If Len(tmppar) Then
                            tmppar = tmppar & "/"
                        End If
                        tmppar = tmppar & tmpnam & "/"
                        Print #fout, tmps
                        For i = 0 To nforums - 1
                            Print #fout, tmppar & Trim$(namarr(i))
                        Next
                        foundnext = False
                        Do Until EOF(fin)
                            Line Input #fin, tmps
                            If isgroup(tmps) Then
                                foundnext = True
                                Exit Do
                            End If
                        Loop
                        If Not foundnext Then
                            Exit Do
                        End If
                    End If
                End If
            End If
            Print #fout, tmps
        Loop
    End If
    Close fin
    Close fout
    If searching Then
        Kill tmpfnam
    Else
        Kill grpfilename
        Name tmpfnam As grpfilename
        updgrpfilfor = True
    End If
    Exit Function
updgrpfilforerr:
    poperror "Error #" & CStr(Err) & " updating group information file (" & Error$(Err) & ")", ""
    If fexist(tmpfnam, False) Then
        Kill tmpfnam
    End If
    Exit Function
End Function

Function updgrpfilgrp (ByVal grpidx As Integer) As Integer
' update group information file with new group information
' grpidx:   index in group info array of group that changed
' returns True if successful

    Dim fin As Integer, fout As Integer, searching As Integer, replacing As Integer
    Dim targetid As Integer, grpid As Integer, keepidx As Integer
    Dim tmps As String, tmpfnam As String, grpstr As String, grplin As String
    Dim oldpar As String, tmpnam As String, tmptpc As String

    updgrpfilgrp = False
    targetid = grpinfarr(grpidx).grpid
    grpstr = gengrpstr(grpidx)
    grplin = grpstr & " " & CStr(targetid) & " " & Trim$(grpinfarr(grpidx).topic)
    If Len(grpstr) Then
        grpstr = grpstr & "/"
    End If
    tmpfnam = newgrpfilnam()
    On Error GoTo updgrpfilgrperr
    fin = FreeFile
    Open grpfilename For Input Access Read As fin
    fout = FreeFile
    Open tmpfnam For Output Access Write As fout
    searching = True
    replacing = False
    While Not EOF(fin)
        Line Input #fin, tmps
        If searching Then
            If isgroup(tmps) Then
                parsegrp tmps, oldpar, tmpnam, grpid, tmptpc
                If grpid = targetid Then
                    tmps = grplin
                    searching = False
                    replacing = True
                    If Len(oldpar) Then
                        oldpar = oldpar & "/"
                    End If
                    oldpar = oldpar & tmpnam & "/"
                    keepidx = Len(oldpar) + 1
                End If
            End If
        ElseIf replacing Then
            If sameto(oldpar, tmps) Then
                tmps = grpstr & Mid$(tmps, keepidx)
            Else
                replacing = False
            End If
        End If
        Print #fout, tmps
    Wend
    Close fin
    Close fout
    Kill grpfilename
    Name tmpfnam As grpfilename
    updgrpfilgrp = True
    Exit Function
updgrpfilgrperr:
    poperror "Error #" & CStr(Err) & " updating group information file (" & Error$(Err) & ")", ""
    If fexist(tmpfnam, False) Then
        Kill tmpfnam
    End If
    Exit Function
End Function

