'******************************************************************************
'*                                                                            *
'*   FILECAB.BAS                                                              *
'*                                                                            *
'*   Copyright (c) 1994-1997 Galacticomm, Inc.      All rights reserved.      *
'*                                                                            *
'*   This is the File Cabinet .BAS file.                                      *
'*                                                                            *
'*                                                  - Tim Stark 10/26/94      *
'*                                                                            *
'******************************************************************************

Option Explicit

'************************** global declarations *******************************

' define dynapak names
Global Const FCFLDDPK = "sa=GAL_FCAB;ul:FLIST " ' client-side folder list dynapak name
Global Const FCFLDMIN = "FLIST "    ' min name match for folder list dynapak
Global Const FCMSGDPK = "sa=GAL_FCAB;ul:" ' client-side folder entry dynapak name
Global Const GENFLDR = "(General)"  ' catch-all folder
Global Const GENFLDID = 0           ' (General) folder number
Global Const FLDRNAMSZ = 33         ' maximum folder name size (VBSFXSIZ - Len(FCFLDMIN))
Global Const FNUMFMT = "00000"      ' folder number format for Format$()
Global Const FCDTFMT = "000000.000000000" ' date/time format for Format$()

Const FCMSGIDSZ = 17                ' filing cabinet message ID string length
Const CFLCHR = "{"                  ' dynapak name conflict resolution character

Type foldrec                        ' folder list record
    name As String * FLDRNAMSZ      '   folder name
    id As Integer                   '   folder ID
End Type

Global lastUsedFolder As String     ' name of last folder filed in

Dim curfoldnam As String            ' current folder name
Dim curfoldid As Integer            ' current folder reference number
Dim hifnum As Integer               ' high folder number
Dim folderlist() As foldrec         ' list of folders

Type fctrack                        ' filing cabinet message tracking structure
    idstr As String * FCMSGIDSZ     '   message ID string
    hdr As msgdpkshrt               '   message header
End Type

Dim msgarr() As fctrack             ' array of message IDs for currently loaded folder
Dim loadmsg As msgdpk               ' message dynapak buffer for background use

Private Function add2arr (msg As msgdpk, ByVal dpknam As String, arr() As fctrack) As Integer
' add message to in-memory array
' msg:      message dynapak
' dpknam:   dynapak name
' arr:      array to add to
' returns index at which message was added

    Dim i As Integer, j As Integer, comp As Integer, fldrcnt As Integer
    Dim idstr As String

    idstr = itemidxd(suffix(dpknam), 1, " ")
    comp = 1
    i = nearfcid(comp, idstr, arr())
    If comp > 0 Then
        i = i + 1
    End If
    fldrcnt = fcnmsgs(arr())
    ReDim Preserve arr(fldrcnt)
    For j = fldrcnt - 1 To i Step -1
        arr(j + 1) = arr(j)
    Next
    arr(i).idstr = idstr
    LSet arr(i).hdr = msg
    add2arr = i
End Function

Private Sub add2lst (ByVal idx As Integer)
' add entry to list of messages
' idx:  index of item to add

    Dim tmps As String

    tmps = fcitem(msgarr(idx).hdr)
    mainform!msglist.AddItem tmps, idx
    setmlpic mainform!msglist, idx, Val(iteminfo(tmps, MLI_FLAGS))
End Sub

Function delfolder (ByVal foldnam As String) As Integer
' delete named folder
' returns True if completed, False if aborted

    Dim folderid As Integer, folderidx As Integer, i As Integer
    Dim dpknam As String, minmat As String

    delfolder = False
    If sameas(foldnam, GENFLDR) Then
        poperror "You can not delete the """ & GENFLDR & """ folder.", "Filing Cabinet"
        Exit Function
    End If
    If gmsgbox("Delete folder """ & foldnam & """ and all of its associated messages?", MB_YESNO + MB_ICONQUESTION + MB_DEFBUTTON2, "Delete Folder Confirmation") = IDYES Then
        folderidx = findfolder(foldnam)
        If folderidx > 0 Then
            folderid = folderlist(folderidx).id
            screen.MousePointer = HOURGLASS
            minmat = wtspace(Format$(folderid, FNUMFMT))
            dpknam = FCMSGDPK & minmat
            Do While srgtdpk(dpknam, minmat, Len(i), i)
                dpknam = namdpk()
                junk = swrtdpkv(dpknam, 0, 0)
            Loop
            junk = swrtdpkv(FCFLDDPK & foldnam, 0, 0)
            For i = folderidx To UBound(folderlist) - 1
                folderlist(i) = folderlist(i + 1)
            Next
            ReDim Preserve folderlist(UBound(folderlist) - 1)
            fcremread folderid
            If sameas(curfoldnam, foldnam) Then
                curfoldnam = ""
                Erase msgarr
                If cursource = SRCFILCAB Then
                    nosource
                End If
            End If
            screen.MousePointer = DEFAULT
            delfolder = True
        End If
    End If
End Function

Function fccanread (ByVal msgidstr As String, ByVal direc As Integer) As Integer
' can user read message in filing cabinet in specified direction?
' msgidstr: identifier of current message (updated if successful)
' direc:    direction to read (-1=prev, 0=exact, 1=next)

    Dim dummy As Integer
    Dim dpknam As String, minmat As String

    dpknam = FCMSGDPK & msgidstr
    minmat = wtspace(itemidxd(msgidstr, 0, " ") & " ")
    Select Case direc
    Case READPREV
        fccanread = srltdpk(dpknam, minmat, Len(dummy), dummy) <> 0
    Case READTHIS
        fccanread = True
    Case READNEXT
        fccanread = srgtdpk(dpknam, minmat, Len(dummy), dummy) <> 0
    End Select
End Function

Function fccanthread (ByVal msgidstr As String, ByVal fornam As String, ByVal msgid As Long, ByVal thrid As Long, rplto As globid, ByVal direc As Integer) As Integer
' check for message in a thread in filing cabinet
' msgidstr: identifier of current message
' fornam:   forum name or "" if email
' msgid:    current message ID
' thrid:    current thread ID
' rplto:    reply-to ID of current message
' direc:    direction to test (-1=prev, 0=parent, 1=next)

    fccanthread = False
End Function

Function fcdelmsg (ByVal msgidstr As String) As Integer
' delete a message from file cabinet
' returns True if message deleted

    Dim i As Integer, delidx As Integer, tmpfoldid As Integer

    fcdelmsg = False
    junk = swrtdpkv(FCMSGDPK & msgidstr, 0, "")
    junk = swrtdpkv(FCBNOTDPK & msgidstr, 0, "")
    tmpfoldid = Val(itemidxd(msgidstr, 0, " "))
    If Len(curfoldnam) <> 0 And tmpfoldid = curfoldid Then
        delidx = fcididx(itemidxd(msgidstr, 1, " "))
        For i = delidx To fcnmsgs(msgarr()) - 2
            msgarr(i) = msgarr(i + 1)
        Next
        If fcnmsgs(msgarr()) = 1 Then
            Erase msgarr
        Else
            ReDim Preserve msgarr(UBound(msgarr) - 1)
        End If
        If cursource = SRCFILCAB Then
            remlbitem mainform!msglist, delidx
        End If
    End If
    fcdelmsg = True
End Function

Private Function fcididx (ByVal idstr As String) As Integer
' get index in msgarr() of message given ID string
' idstr:    date stamp ID of message to find
' returns index or -1 if not found

    Dim i As Integer, comp As Integer

    fcididx = -1
    i = nearfcid(comp, idstr, msgarr())
    If i >= 0 And comp = 0 Then
        fcididx = i
    End If
End Function

Private Function fcitem (msg As msgdpkshrt) As String
' generate a folder message list item string

    Dim flags As Integer

    flags = mlflags(msg, 0)
    fcitem = getminf(msg.info, FROMFLD) & tb & getminf(msg.info, TOFLD) & tb & getminf(msg.info, TPCFLD) & tb & Format$(msg.crdatim, DATEFMT) & tb & flags
End Function

Function fclistidx (ByVal msgidstr As String) As Integer
' Filing Cabinet: get index of specified message in list of messages
' msgidstr: source-specific message ID string
' returns -1 if not found or not current folder

    fclistidx = -1
    If Len(curfoldnam) <> 0 And Val(itemidxd(msgidstr, 0, " ")) = curfoldid Then
        fclistidx = fcididx(itemidxd(msgidstr, 1, " "))
    End If
End Function

Sub fclistjmp (ByVal jumpto As Integer)
' Filing Cabinet:  move list selection to specified message
' jumpto:   which message to jump to code

    Dim i As Integer, comp As Integer
    Dim tmps As String

    i = jumpidx(jumpto)
    If i >= 0 Then
        setmsgidx i
    End If
End Sub

Private Function fcnmsgs (arr() As fctrack) As Integer
' get number of messages in array of filing cabinet messages
' array of messages
' returns 0 if no messages or no folder listed

    fcnmsgs = 0
    On Error GoTo nofcmsgs
    fcnmsgs = UBound(arr) + 1
nofcmsgs:
    Exit Function
End Function

Sub fcpreprd (ByVal lstidx As Integer, capstr As String, btnflgs As Integer, capflgs As Integer, msgidstr As String)
' Offline Forums:  prepare arguments to launch read form with
' lstidx:   index in message list of message to prepare
' capstr:   read form caption
' btnflgs:  button flags
' capflgs:  capability flags
' msgidstr: message ID string

    capstr = "Message in """ & curfoldnam & """"
    btnflgs = RDBNXTPRV Or RDBJUMP
    capflgs = RDCDEL Or RDCEDTNT
    msgidstr = Format$(curfoldid, FNUMFMT) & " " & Trim$(msgarr(lstidx).idstr)
End Sub

Function fcreadjmp (msgidstr As String, ByVal jumpto As Integer) As Integer
' Offline Forums:  jump to (and read) a message
' msgidstr: message ID string of current message (updated if new message found)
' jumpto:   what message to jump to code
' returns True if message found

    Dim i As Integer, folderid As Integer, direc As Integer
    Dim tmps As String

    fcreadjmp = False
    folderid = Val(itemidxd(msgidstr, 0, " "))
    If folderid = curfoldid Then
        i = jumpidx(jumpto)
        If i < 0 Then
            Exit Function
        End If
        direc = READTHIS
        tmps = Trim$(msgarr(i).idstr)
    Else
        Select Case jumpto
        Case JUMPFRST
            direc = READNEXT
            tmps = Chr$(0)
        Case JUMPSPEC
            tmps = formfunc(minpbox, "Date:" & tb & "Jump to...")
            If Not IsDate(tmps) Then
                Exit Function
            End If
            direc = READNEXT
            tmps = Format$(CDbl(CVDate(tmps)), FCDTFMT)
        Case JUMPLAST
            direc = READPREV
            tmps = Chr$(255)
        End Select
    End If
    tmps = itemsetd(msgidstr, 1, tmps, " ")
    If fcreadmsg(tmps, direc) Then
        fcreadjmp = True
        msgidstr = tmps
    End If
End Function

Function fcreadmsg (msgidstr As String, ByVal direc As Integer) As Integer
' Filing Cabinet readmsg() function

    Dim rsplen As Integer
    Dim dpknam As String, minmat As String

    dpknam = FCMSGDPK & msgidstr
    minmat = wtspace(itemidxd(msgidstr, 0, " ") & " ")
    Select Case direc
    Case READPREV
        rsplen = srltdpk(dpknam, minmat, Len(msgindpk), msgindpk)
    Case READTHIS
        rsplen = sreadpk(dpknam, Len(msgindpk), msgindpk)
    Case READNEXT
        rsplen = srgtdpk(dpknam, minmat, Len(msgindpk), msgindpk)
    End Select
    If rsplen Then
        msgidstr = suffix(namdpk())
        stpnls msgindpk.info
    End If
    fcreadmsg = rsplen <> 0
End Function

Function fcreadthr (msgidstr As String, ByVal fornam As String, ByVal msgid As Long, ByVal thrid As Long, rplto As globid, ByVal direc As Integer)
' read a message in a thread function
' msgidstr: identifier of current message (updated if successful)
' fornam:   forum name or "" if email
' msgid:    current message ID
' thrid:    current thread ID
' rplto:    reply-to ID of current message
' direc:    direction to read (-1=prev, 0=parent, 1=next)
' returns:  True if message found
' implicit output: message is in msgindpk if returns True

    fcreadthr = False
End Function

Sub fcremread (ByVal folderid As Integer)
' unload read form(s) associated with a given folder

    Dim i As Integer

    i = 0
    Do While i < forms.Count
        If TypeOf forms(i) Is rdmsg Then
            If Val(forms(i)!source) = SRCFILCAB And Val(itemidxd(forms(i)!msgid, 0, " ")) = folderid Then
                Unload forms(i)
            Else
                i = i + 1
            End If
        Else
            i = i + 1
        End If
    Loop
End Sub

Sub fcsynclst (ByVal msgidstr As String)
' Filing Cabinet: synchronize list with given message
' msgidstr:     ID string of message to synchronize with

    Dim i As Integer, folderid As Integer

    folderid = Val(itemidxd(msgidstr, 0, " "))
    If Len(curfoldnam) <> 0 And folderid = curfoldid Then
        i = fcididx(itemidxd(msgidstr, 1, " "))
        If i >= 0 Then
            setmsgidx i
        End If
    End If
End Sub

Sub fileit (msg As msgdpk, notes As String)
' file message in user-selected folder
' msg: message to file

    Dim foldnam As String

    foldnam = formfunc(filcab, "File Message" & tb & lastUsedFolder)
    If Len(foldnam) Then
        screen.MousePointer = HOURGLASS
        lastUsedFolder = foldnam
        protdoevt       'let filcab form finish unloading
        filemsg foldnam, msg, notes
        screen.MousePointer = DEFAULT
    End If
End Sub

Sub filemsg (ByVal foldnam As String, msg As msgdpk, notes As String)
' write file cabinet folder message
' foldnam:  folder name to add to
' msg:      message dynapak structure

    Dim i As Integer
    Dim dpknam As String, ntdpknam As String

    If Len(foldnam) = 0 Then
        Exit Sub
    End If
    If numfolders() = 0 Then
        initfolders
    End If
    dpknam = newfcdpk(getfolderid(foldnam), msg.crdatim)
    junk = swrtdpkv(dpknam, Len(msg) - INFSIZ + Len(RTrim$(msg.info)), msg)
    ntdpknam = FCBNOTDPK & suffix(dpknam)
    junk = swrtdpkv(ntdpknam, STGLEN, notes)
    If sameas(foldnam, curfoldnam) Then
        i = add2arr(msg, dpknam, msgarr())
        If cursource = SRCFILCAB Then
            add2lst i
        End If
    End If
End Sub

Private Function findfolder (ByVal foldnam As String)
' find named folder in list of folders
' returns index in list

    Dim lo As Integer, md As Integer, hi As Integer, comp As Integer

    lo = 0
    hi = numfolders() - 1
    Do While lo <= hi
        md = lo + Int((hi - lo) / 2)
        comp = stricmp(foldnam, Trim$(folderlist(md).name))
        If comp > 0 Then
            If md = hi Then
                Exit Do
            End If
            lo = md + 1
        ElseIf comp < 0 Then
            If md = lo Then
                Exit Do
            End If
            hi = md - 1
        Else
            findfolder = md
            Exit Function
        End If
    Loop
    findfolder = -1
End Function

Function foldlist (delim As String) As String
' compose a list of folders
' returns: a delimited list of available folders
' delim: delimiter to use for return list

    Dim i As Integer
    Dim tmps As String

    If numfolders() = 0 Then
        initfolders
    End If
    tmps = Trim$(folderlist(0).name)
    For i = 1 To numfolders() - 1
        tmps = tmps & delim & Trim$(folderlist(i).name)
    Next
    foldlist = tmps
End Function

Function getfolderid (ByVal foldnam As String)
' get folder number given folder name
' returns -1 if no such folder

    Dim i As Integer

    getfolderid = -1
    i = findfolder(foldnam)
    If i >= 0 Then
        getfolderid = folderlist(i).id
    End If
End Function

Private Sub initfolders ()
' load list of folders into memory

    Dim i As Integer, mpsave As Integer, fnum As Integer
    Dim tmps As String, dpknam As String

    mpsave = screen.MousePointer
    screen.MousePointer = HOURGLASS
    ReDim folderlist(0)
    folderlist(0).name = GENFLDR
    folderlist(0).id = GENFLDID
    i = 0
    hifnum = 1
    dpknam = wtspace(FCFLDDPK)
    While srgtdpk(dpknam, wtspace(FCFLDMIN), Len(fnum), fnum)
        i = i + 1
        ReDim Preserve folderlist(i)
        dpknam = namdpk()
        tmps = suffix(dpknam)
        folderlist(i).name = Mid$(tmps, InStr(tmps, " ") + 1)
        folderlist(i).id = fnum
        If fnum >= hifnum Then
            hifnum = fnum + 1
        End If
    Wend
    screen.MousePointer = mpsave
End Sub

Private Function jumpidx (ByVal jumpto As Integer) As Integer
' get index of specified message to jump to
' jumpto:   which message to jump to code
' folderid: folder ID of folder to jump in
' returns index of message in msgarr() or -1 if cancelled
' Note: this function only works with the current folder

    Dim i As Integer, comp As Integer
    Dim tmps As String

    jumpidx = -1
    If fcnmsgs(msgarr()) = 0 Then
        Exit Function
    End If
    Select Case jumpto
    Case JUMPFRST
        jumpidx = 0
    Case JUMPSPEC
        tmps = formfunc(minpbox, "Date:" & tb & "Jump to...")
        If IsDate(tmps) Then
            tmps = Format$(CDbl(CVDate(tmps)), FCDTFMT)
            i = nearfcid(comp, tmps, msgarr())
            If comp > 0 Then
                i = i + 1
            End If
            jumpidx = i
        End If
    Case JUMPLAST
        jumpidx = fcnmsgs(msgarr()) - 1
    End Select
End Function

Sub listfolder ()
' list messages in a named folder

    Dim i As Integer
    Dim savsrc As Integer
    Dim foldnam As String

    If Not abtonact() Then
        Exit Sub
    End If
    foldnam = formfunc(filcab, "Open Folder" & tb & curfoldnam)
    If Len(foldnam) = 0 Then
        Exit Sub
    End If
    savsrc = cursource
    cursource = SRCFILCAB
    If Not sameas(foldnam, curfoldnam) Then
        If Not loadfolder(foldnam) Then
            cursource = savsrc
            Exit Sub
        End If
    End If
    screen.MousePointer = HOURGLASS
    mainform!msglist.ReFreshOnUpdate = False
    clearlists
    thrlstvis False
    tbvis mtbid, MTB_DELETE & SETSEP & MTB_JFIRST & SETSEP & MTB_JSPEC & SETSEP & MTB_JLAST
    tbinvis mtbid, MTB_LSTMSG & SETSEP & MTB_LSTTHR
    mainform!mfdel.Visible = True
    jmpmnuvis True
    tagmnuvis False
    fopmnuvis False, ""
    lopmnuvis False
    stdmlcap "Folder:", foldnam
    If fcnmsgs(msgarr()) Then
        For i = 0 To fcnmsgs(msgarr()) - 1
            add2lst i
        Next
        setmsgidx 0
    End If
    stdmlfin
End Sub

Private Function loadfolder (ByVal foldnam As String) As Integer
' load a folder into memory
' foldnam:  name of folder to load
' returns False if aborted

    Dim tmpfoldid As Integer, i As Integer, n As Integer
    Dim dpknam As String, minmat As String
    Dim tmparr() As fctrack

    loadfolder = False
    Erase tmparr
    tmpfoldid = getfolderid(foldnam)
    progopen PRGT_INF, "Loading Folder", "Loading """ & foldnam & """", "Message #", MNMFMT
    minmat = wtspace(Format$(tmpfoldid, FNUMFMT) & " ")
    dpknam = FCMSGDPK & minmat
    While srgtdpk("(h=n)" & dpknam, minmat, Len(loadmsg), loadmsg)
        dpknam = namdpk()
        junk = add2arr(loadmsg, dpknam, tmparr())
        DoEvents
        If progcancel() Then
            progclose
            Erase tmparr
            Exit Function
        End If
        If loadmsg.msgid Then
            progupdate CStr(loadmsg.msgid)
        Else
            progupdate "<none>"
        End If
    Wend
    n = fcnmsgs(tmparr())
    If n Then
        ReDim msgarr(n - 1)
        For i = 0 To n - 1
            msgarr(i) = tmparr(i)
        Next
    Else
        Erase msgarr
    End If
    Erase tmparr
    progclose
    loadfolder = True
    curfoldnam = foldnam
    curfoldid = tmpfoldid
End Function

Private Function nearfcid (comp As Integer, ByVal idstr As String, arr() As fctrack) As Integer
' find message nearest to a given filing cabinet message ID in array of messages
' comp:     result of last comparison
' idstr:    filing cabinet message ID string
' arr:      array to search
' returns index of nearest message or -1 if no messages

    Dim lo As Integer, md As Integer, hi As Integer

    md = -1
    lo = 0
    hi = fcnmsgs(arr()) - 1
    Do While lo <= hi
        md = lo + Int((hi - lo) / 2)
        comp = StrComp(idstr, Trim$(arr(md).idstr), 0)
        If comp > 0 Then
            lo = md + 1
        ElseIf comp < 0 Then
            hi = md - 1
        Else
            Exit Do
        End If
    Loop
    nearfcid = md
End Function

Function newfcdpk (ByVal folderid As Integer, ByVal datim As Double) As String
' generate new filing cabinet dynapak name based on folder ID and date/time stamp
' (does conflict checking)

    Dim cnt As Integer, dummy As Integer
    Dim minmat As String

    minmat = Format$(folderid, FNUMFMT) & " " & Format$(datim, FCDTFMT)
    cnt = Asc(CFLCHR)
    While sreadpk("(h=n)" & FCMSGDPK & minmat & Chr$(cnt), Len(dummy), dummy)
        cnt = cnt + 1
    Wend
    newfcdpk = FCMSGDPK & minmat & Chr$(cnt)
End Function

Function newfolder (ByVal foldnam As String) As Integer
' create a new folder
' returns True if successful
' NOTE: This code assumes hifnum has been initialized by getting a list of folders

    Dim i As Integer

    newfolder = False
    If Len(sreadpkv(FCFLDDPK & foldnam)) = 0 And Not sameas(foldnam, GENFLDR) Then
        junk = swrtdpkv(FCFLDDPK & foldnam, Len(hifnum), hifnum)
        i = UBound(folderlist) + 1
        ReDim Preserve folderlist(i)
        folderlist(i).name = foldnam
        folderlist(i).id = hifnum
        sortfolders
        hifnum = hifnum + 1
        newfolder = True
    End If
End Function

Private Function numfolders () As Integer
' get number of folders in array

    numfolders = 0
    On Error GoTo nofolders
    numfolders = UBound(folderlist) + 1
nofolders:
    Exit Function
End Function

Function renfolder (ByVal oldnam As String, ByVal newnam As String) As Integer
' rename a folder
' returns True if successful

    Dim folderid As Integer

    renfolder = False
    folderid = getfolderid(oldnam)
    If folderid <> GENFLDID Then
        junk = swrtdpkv(FCFLDDPK & oldnam, 0, 0)
        junk = swrtdpkv(FCFLDDPK & newnam, Len(folderid), folderid)
        folderlist(findfolder(oldnam)).name = newnam
        sortfolders
        'unload associated forms so don't have to deal with changing name
        fcremread folderid
        If cursource = SRCFILCAB And sameas(oldnam, curfoldnam) Then
            curfoldnam = newnam
            mainform!lstname(0) = newnam
        End If
        renfolder = True
    End If
End Function

Private Sub sortfolders ()
' sort list of folders on folder name

    Dim lo As Integer, hi As Integer
    Dim exchange As foldrec

    For lo = 0 To UBound(folderlist) - 1
        For hi = lo + 1 To UBound(folderlist)
            If stricmp(folderlist(lo).name, folderlist(hi).name) > 0 Then
                exchange = folderlist(lo)
                folderlist(lo) = folderlist(hi)
                folderlist(hi) = exchange
            End If
        Next
    Next
End Sub

