'***************************************************************************
'*                                                                         *
'*  EMLPO.BAS                                                              *
'*                                                                         *
'*  Copyright (c) 1994-1997 Galacticomm, Inc.    All Rights Reserved.      *
'*                                                                         *
'*  Functions, variables, and constants for managing the E-mail post       *
'*  office.                                                                *
'*                                                                         *
'*                                                  - J. Alvrus 12/6/95    *
'*                                                                         *
'***************************************************************************

Option Explicit

Const POTAGDPK = "sa=GALEML;u:emailtags" ' tagged messages dynapak name

Global poconnected As Integer       ' Post Office initiated connection

Dim loadrqid As Integer             ' load Post Office request ID
Dim getipg As Integer               ' get tagged messages in progress?
Dim getrqid As Integer              ' get tagged messages request ID
Dim numgot As Integer               ' number of tagged messages gotten
Dim incallback As Integer           ' pogotmsg() was called by PO get callback
Dim numtags As Integer              ' number of tagged Post Office messages
Dim tagarr(4095) As Long            ' array of Post Office tags
Dim msgarr() As msgdpkshrt          ' array of message headers
Dim getmsg As msgdpk                ' message dynapak buffer for background use

Private Sub add2arr (msg As msgdpkshrt)
' add a message to array of headers

    Dim i As Integer

    i = ninmarr(msgarr())
    ReDim Preserve msgarr(i)
    msgarr(i) = msg
End Sub

Private Function add2lst (msg As msgdpkshrt) As Integer
' add a message to the post office message list

    Dim flags As Integer

    add2lst = False
    flags = MLF_TGABLE
    If tagidx(msg.msgid) >= 0 Then
        flags = flags Or MLF_TAGGED
    End If
    flags = mlflags(msg, flags)
    On Error GoTo add2lsterr
    mainform!msglist.AddItem Format$(msg.crdatim, DATEFMT) & tb & getminf(msg.info, FROMFLD) & tb & getminf(msg.info, TPCFLD) & tb & flags
    setmlpic mainform!msglist, mainform!msglist.LastAdded, flags
    add2lst = True
add2lsterr:
    Exit Function
End Function

Private Sub addatag (ByVal msgid As Long)
' add a message to array of tagged messages
' msgid:    message ID to add
' assumes message is not already tagged

    tagarr(numtags) = msgid
    numtags = numtags + 1
End Sub

Private Sub bgnget (cbk As CallBack)
' begin getting Post Office messages

    getipg = True
    numgot = 0
    getrqid = readpk(rddpknam(tagarr(numtags - 1)), cbk)
End Sub

Private Sub delatag (ByVal tagidx As Integer)
' remove a tag from array
' tagidx:   index of tag in array

    Dim i As Integer

    numtags = numtags - 1
    For i = tagidx + 1 To numtags
        tagarr(i - 1) = tagarr(i)
    Next
End Sub

Private Function jumpidx (ByVal jumpto As Integer) As Integer
' get index of message to jump to
' jumpto:   which message to jump to code
' returns index or -1 if cancelled

    Dim idx As Integer
    Dim tmpid As Long, comp As Long

    jumpidx = -1
    Select Case jumpto
    Case JUMPFRST
        jumpidx = 0
    Case JUMPSPEC
        tmpid = getjmpmid()
        If tmpid >= 0 Then
            If tmpid <= msgarr(0).msgid Then
                jumpidx = 0
            ElseIf tmpid >= msgarr(UBound(msgarr)).msgid Then
                jumpidx = UBound(msgarr)
            Else
                idx = nearmidx(comp, tmpid, msgarr())
                If comp < 0 And idx > 0 Then
                    idx = idx - 1
                End If
                jumpidx = idx
            End If
        End If
    Case JUMPLAST
        jumpidx = UBound(msgarr)
    End Select
End Function

Sub listpo ()
' load main form list with post office

    Dim i As Integer
    Dim savsrc As Integer

    If Not abtonact() Then
        Exit Sub
    End If
    savsrc = cursource
    cursource = SRCPOSTOFC
    If Not loadpo() Then
        cursource = savsrc
        Exit Sub
    End If
    emlsetup "Post Office", True
    If ninmarr(msgarr()) Then
        For i = 0 To ninmarr(msgarr()) - 1
            If Not add2lst(msgarr(i)) Then
                Screen.MousePointer = NORMAL
                poperror "There are more messages in your Post Office than can be displayed in this list! Only the first " & CStr(mainform!msglist.ListCount) & " of " & CStr(ninmarr(msgarr())) & " are displayed.", "Post Office"
                ReDim Preserve msgarr(mainform!msglist.ListCount - 1)
                Exit For
            End If
        Next
        setmsgidx 0
    End If
    stdmlfin
End Sub

Private Function loadpo () As Integer
' read post office message headers from server and load into memory
' returns false if aborted

    Dim dpknam As String

    loadpo = False
    If appconnect() Then
        junk = readtags()
        If evtdpk() <> "Dynapak received" Then
            Exit Function
        End If
        Erase msgarr
        progopen PRGT_INF, "Loading Post Office", "", "Message #", MNMFMT
        loadrqid = rgtdpk(POHDRDPK & "0", wtspace(POHDRMIN), -1, mainform!loadcbk)
        Do
            DoEvents
            If progcancel() Then
                abodpk loadrqid
                progclose
                Erase msgarr
                Exit Function
            End If
            DoEvents
        Loop Until loadrqid < 0
        progclose
        loadpo = True
    End If
End Function

Function poanytag () As Integer
' Post Office: any messages tagged?

    poanytag = numtags <> 0
End Function

Function pocandel (msg As msgdpk) As Integer
' Post Office:  can user delete this message
' msg:  dynapak form of message

    Dim tmpflg As Integer
    Dim smsg As msgdpkshrt

    tmpflg = getmidx(msg.msgid, msgarr()) >= 0
    If Not tmpflg And msg.forum <> EMLID Then
        LSet smsg = msg
        tmpflg = forcandel(smsg)
    End If
    pocandel = tmpflg
End Function

Function pocanread (ByVal msgidstr As String, ByVal direc As Integer) As Integer
' Post Office: can user read message in specified direction?
' msgidstr: identifier of current message (updated if successful)
' direc:    direction to read (-1=prev, 0=exact, 1=next)

    Dim i As Integer

    i = getmidx(Val(msgidstr), msgarr())
    Select Case direc
    Case READPREV
        pocanread = i > 0
    Case READTHIS
        pocanread = i < 0
    Case READNEXT
        pocanread = i < ninmarr(msgarr()) - 1
    End Select
End Function

Sub pocbkhlr (ByVal evtstg As String, ByVal reqid As Integer, cbk As CallBack)
' Post Office get tagged messages callback handler
' evtstg:   event string
' reqid:    request ID
' cbk:      callback to use for subsequent reads

    Dim dpklen As Integer, gotone As Integer

    If reqid = getrqid Then
        getrqid = -1
        gotone = evtstg = "Dynapak received"
        If gotone Then
            dpklen = cbkrsp(Len(getmsg), getmsg)
            gotone = dpklen <> 0
            If gotone Then
                stpnls getmsg.info
                numgot = numgot + 1
                incallback = True
                gotibxmsg getmsg, dpklen
                incallback = False
            End If
        End If
        numtags = numtags - 1
        untaglist tagarr(numtags)
        If numtags <> 0 And connected() Then
            getrqid = readpk(rddpknam(tagarr(numtags - 1)), cbk)
        Else
            getipg = False
        End If
        If Not appclsipg Then
            freeup
            If Not gotone Then
                popmsg "Unable to get message #" & tagarr(numtags), "Post Office"
            End If
            If Not getipg Then
                adjrdbtn
                If numtags Then
                    popmsg "Tagged message get aborted. " & numgot & " message(s) gotten.", "Post Office"
                End If
            End If
        End If
    End If
End Sub

Function poclrtags () As Integer
' Post Office:  clear all tags
' returns True if successful

    Dim ntgsav As Integer

    ntgsav = numtags
    numtags = 0
    If savetags() Then
        poclrtags = True
    Else
        numtags = ntgsav
        poclrtags = False
    End If
End Function

Sub poconn (cbk As CallBack)
' Post Office handle connection
' check with server for tagged E-mail and act on preferences

    Dim dummy As Integer
    Static oneatatime As Integer    ' assumes this is initialized to False

    If oneatatime Then
        Exit Sub
    End If
    oneatatime = True
    If Not (poconnected Or ibxconnected) And connected() Then
        If prefs.flag2 And (P2PMTPO Or P2ALWPO) Then
            If readtags() Then
                If prefs.flag2 And P2ALWPO Then
                    If cursource <> SRCPOSTOFC And cursource <> SRCEINBOX Then
                        popmsg "You have tagged mail at the Post Office which is being gotten now.", "Post Office"
                    End If
                    bgnget cbk
                ElseIf (prefs.flag2 And P2PMTPO) <> 0 And Not appconnected Then
                    If gmsgbox("You have tagged mail at the Post Office. Would you like to get it now?", MB_ICONQUESTION Or MB_YESNO, "Post Office") = IDYES Then
                        bgnget cbk
                    End If
                End If
            End If
        End If
    End If
    oneatatime = False
End Sub

Function podelmsg (ByVal msgidstr As String) As Integer
' delete a message from the post office
' msgidstr: ID string of message to delete
' returns True if deleted

    Dim i As Integer, rspval As Integer, delflg As Integer
    Dim confirm As Integer, savemp As Integer

    delflg = False
    savemp = Screen.MousePointer
    confirm = IDNO
    If Not multipleop Then
        Screen.MousePointer = DEFAULT
        confirm = gmsgbox("Are you sure you want to delete this message from the server?", MB_ICONQUESTION Or MB_YESNO Or MB_DEFBUTTON2, "")
        Screen.MousePointer = savemp
    End If
    If multipleop Or (confirm = IDYES) Then
        If appconnect() Then
            junk = swrtdpk(POMSGDPK & msgidstr, 0, 0, Len(rspval), rspval)
            Select Case evtdpk()
            Case "Write ok"
                delflg = True
            Case "Offline write denied", "Write may be incomplete"
                'do nothing
            Case Else
                Screen.MousePointer = DEFAULT
                Select Case rspval
                Case GMEUSE
                    poperror "This message is in use by someone else at the moment and cannot be deleted.", ""
                Case GMENFND
                    'we are deleting it after all
                    delflg = True
                Case Else
                    poperror "Unable to delete this message.  (Error " & rspval & ")", ""
                End Select
                Screen.MousePointer = savemp
            End Select
            If delflg Then
                junk = podelmsgl(msgidstr)
            End If
        End If
    End If
    podelmsg = delflg
End Function

Function podelmsgl (ByVal msgidstr As String) As Integer
' delete local copy of a message from the post office
' msgidstr: ID string of message to delete
' returns True if deleted

    Dim i As Integer

    If cursource = SRCPOSTOFC Then
        i = delmarr(Val(msgidstr), msgarr())
        If i >= 0 Then
            remlbitem mainform!msglist, i
        End If
    End If
    podelmsgl = True
End Function

Sub pogettag (cbk As CallBack)
' start getting tagged post office messages
' cbk:  CallBack control to use

    If numtags = 0 Then
        popmsg "There are no tagged messages at the Post Office", ""
        Exit Sub
    End If
    If getipg Then
        popmsg "The Post Office is still getting messages", ""
        Exit Sub
    End If
    poconnected = True
    If appconnect() Then
        bgnget cbk
    End If
    poconnected = False
End Sub

Sub pogotmsg (ByVal msgid As Long)
' Post Office:  notification of message gotten
' msgid:    message ID gotten (can be untagged)
' Note:  this assumes Post Office is the current list

    Dim i As Integer

    If Not incallback Then
        i = tagidx(msgid)
        If i >= 0 Then
            delatag i
        End If
        untaglist msgid
    End If
End Sub

Function polistidx (ByVal msgidstr As String) As Integer
' Post Office: get index of specified message in list of messages
' msgidstr: source-specific message ID string
' returns index or -1 if not found

    polistidx = getmidx(Val(msgidstr), msgarr())
End Function

Sub polistjmp (ByVal jumpto As Integer)
' Post Office:  move list selection to specified message
' jumpto:   which message to jump to

    Dim i As Integer

    i = jumpidx(jumpto)
    If i >= 0 Then
        setmsgidx i
    End If
End Sub

Sub poloadcbk (ByVal evtstg As String, ByVal reqid As Integer)
' Post Office:  load messages callback handler

    Dim n As Integer
    Dim msg As msgdpkshrt

    If reqid = loadrqid Then
        Select Case evtstg
        Case "Dynapak received"
            junk = cbkrsp(Len(msg), msg)
            stpnls msg.info
            add2arr msg
            progupdate CStr(msg.msgid)
        Case Else
            loadrqid = -1
        End Select
    End If
End Sub

Sub poprepread (ByVal lstidx As Integer, capstr As String, btnflgs As Integer, capflgs As Integer, msgidstr As String)
' Post Office:  prepare arguments to launch read form with
' lstidx:   index in message list of message to prepare
' capstr:   read form caption
' btnflgs:  button flags
' capflgs:  capability flags
' msgidstr: message ID string

    capstr = "Post Office Message"
    btnflgs = RDBALL
    capflgs = RDCDEL
    msgidstr = Format$(msgarr(lstidx).msgid, MNMFMT)
End Sub

Function poqryunl () As Integer
' OK with Post Office if we unload main form

    If getipg Then
        poqryunl = gmsgbox("Post Office is getting messages. Are you sure you wish to quit?", MB_ICONQUESTION Or MB_YESNO Or MB_DEFBUTTON2, "") = IDNO
    End If
End Function

Function poreadjmp (msgidstr As String, ByVal jumpto As Integer) As Integer
' Post Office: jump to (and read) a message
' msgidstr: message ID string of current message (updated if new message found)
' jumpto:   what message to jump to
' returns True if message found

    Dim i As Integer
    Dim tmps As String

    poreadjmp = False
    i = jumpidx(jumpto)
    If i >= 0 Then
        tmps = Format$(msgarr(i).msgid, MNMFMT)
        If poreadmsg(tmps, READTHIS) Then
            msgidstr = tmps
            poreadjmp = True
        End If
    End If
End Function

Function poreadmsg (msgidstr As String, ByVal direc As Integer) As Integer
' E-mail In Box:  read-a-message function
' msgidstr: identifier of current message (updated if successful)
' direc:    direction to read (-1=prev, 0=exact, 1=next)
' returns:  True if message found
' implicit output: message is in msgindpk if returns True

    Dim rsplen As Integer

    rsplen = 0
    If appconnect() Then
        Select Case direc
        Case READPREV
            rsplen = srltdpk(POMSGDPK & msgidstr, wtspace(POMSGMIN), Len(msgindpk), msgindpk)
        Case READTHIS
            rsplen = sreadpk(POMSGDPK & msgidstr, Len(msgindpk), msgindpk)
        Case READNEXT
            rsplen = srgtdpk(POMSGDPK & msgidstr, wtspace(POMSGMIN), Len(msgindpk), msgindpk)
        End Select
        If rsplen Then
            msgidstr = Format$(msgindpk.msgid, MNMFMT)
            stpnls msgindpk.info
        End If
    End If
    poreadmsg = rsplen <> 0
End Function

Sub posynclst (ByVal msgidstr As String)
' Post Office: synchronize list with given message
' msgidstr: ID string of message to synchronize with

    Dim i As Integer

    If cursource = SRCPOSTOFC Then
        i = getmidx(Val(msgidstr), msgarr())
        If i >= 0 Then
            setmsgidx i
        End If
    End If
End Sub

Function potogtag (flags As Integer, ByVal idx As Integer) As Integer
' Post Office: toggle a message's tagged status from list of messages
' flags:    current message list flags (updated by handler)
' idx:      index in list of message to tag
' returns True if message tag toggled successfully

    Dim i As Integer

    potogtag = False
    i = tagidx(msgarr(idx).msgid)
    If i < 0 Then
        If settag(idx) Then
            potogtag = True
            flags = flags Or MLF_TAGGED
        End If
    Else
        If remtag(idx, i) Then
            potogtag = True
            flags = flags And Not MLF_TAGGED
        End If
    End If
End Function

Private Function readtags () As Integer
' read Post Office tags from the server

    numtags = sreadpk(POTAGDPK, Len(tagarr(0)) * (UBound(tagarr) + 1), tagarr(0)) / Len(tagarr(0))
    readtags = numtags <> 0
End Function

Private Function remtag (ByVal lstidx As Integer, ByVal tagidx As Integer) As Integer
' remove a post office message tag
' lstidx:   index of message in list of messages
' tagidx:   index of tag in tag array
' returns True if successful

    Dim savtag As Long

    remtag = False
    savtag = tagarr(tagidx)
    delatag tagidx
    If savetags() Then
        remtag = True
    Else
        addatag savtag
    End If
End Function

Private Function savetags () As Integer
' send tag array to server
' returns True if able to save

    savetags = False
    If appconnect() Then
        junk = swrtdpkv(POTAGDPK, Len(tagarr(0)) * numtags, tagarr(0))
        If evtdpk() = "Write ok" Then
            savetags = True
        End If
    End If
End Function

Private Function settag (ByVal lstidx As Integer) As Integer
' set a post office message tag
' lstidx:   index of message in list of messages
' assumes message is NOT already tagged
' returns True if successful

    settag = False
    addatag msgarr(lstidx).msgid
    If savetags() Then
        settag = True
    Else
        numtags = numtags - 1
    End If
End Function

Private Function tagidx (ByVal msgid As Long) As Integer
' find index of specified message ID in check array
' returns -1 if not found

    Dim i As Integer

    For i = 0 To numtags - 1
        If msgid = tagarr(i) Then
            tagidx = i
            Exit Function
        End If
    Next
    tagidx = -1
End Function

Private Sub untaglist (ByVal msgid As Long)
' untag a message in post office list
' msgid:    message ID to untag

    Dim i As Integer, flags As Integer
    Dim tmps As String

    i = getmidx(msgid, msgarr())
    If i >= 0 Then
        tmps = mainform!msglist.List(i)
        flags = Val(iteminfo(tmps, MLI_FLAGS))
        If flags And MLF_TAGGED Then
            flags = flags And Not MLF_TAGGED
            mainform!msglist.ReFreshOnUpdate = False
            mainform!msglist.List(i) = setitminf(tmps, MLI_FLAGS, CStr(flags))
            setmlpic mainform!msglist, i, flags
            mainform!msglist.ReFreshOnUpdate = True
        End If
    End If
End Sub

