'****************************************************************************
'*                                                                          *
'*  EMLIBX.BAS                                                              *
'*                                                                          *
'*  Copyright (c) 1994-1997 Galacticomm, Inc.    All Rights Reserved.       *
'*                                                                          *
'*  Functions, variables, and constants for managing the E-mail in box      *
'*                                                                          *
'*                                                  - J. Alvrus 11/28/95    *
'*                                                                          *
'****************************************************************************

Option Explicit

Global ibxconnected As Integer      ' in box initiated connection to get new mail
Global getnewipg As Integer         ' "getting new mail" process in progress

Dim inboxinit As Integer            ' has in box been initialized yet?
Dim getnewrq As Integer             ' "getting new mail" request ID
Dim firstnew As Long                ' first new message ID from chk4new
Dim numnew As Integer               ' number of new messages gotten
Dim checkcnt As Integer             ' periodic check for new mail counter
Dim ibxdlipg As Integer             ' in box is downloading attachments
Dim ibxdidc As Integer              ' in box connected to check for new mail
Dim periodic As Integer             ' is this a periodic get of new mail?
Dim bkqflg As Integer               ' result of background query for new mail
Dim qrqid As Integer                ' request ID of background new mail query
Dim listoverflow As Integer         ' have we run out of room in message list?
Dim msgarr() As msgdpkshrt          ' message headers in memory
Dim getmsg As msgdpk                ' background-only-use message dpk buffer

' loadinbox return codes
Const LOADOK = 1                    ' in box was loaded successfully
Const LOADABT = 2                   ' user aborted load
Const LOADRCS = 3                   ' recursive call to loadinbox

Private Function addarr (msg As msgdpk) As Integer
' add a message to array of headers
' return index added at or -1 if not added

    Dim i As Integer, insidx As Integer
    Dim comp As Long

    addarr = -1
    If ninmarr(msgarr()) Then
        comp = 1
        insidx = nearmidx(comp, msg.msgid, msgarr())
        If comp = 0 Then
            Exit Function
        ElseIf comp > 0 Then
            insidx = insidx + 1
        End If
        ReDim Preserve msgarr(UBound(msgarr) + 1)
        For i = UBound(msgarr) - 1 To insidx Step -1
            msgarr(i + 1) = msgarr(i)
        Next i
    Else
        ReDim msgarr(0)
        insidx = 0
    End If
    LSet msgarr(insidx) = msg
    addarr = insidx
End Function

Private Function addlst (ByVal idx As Integer, msg As msgdpkshrt) As Integer
' add an in box item to list
' returns False if out of room in list (also generates error message)

    Dim flags As Integer

    addlst = False
    flags = mlflags(msg, 0)
    On Error GoTo ibxaddlsterr
    mainform!msglist.AddItem Format$(msg.crdatim, DATEFMT) & tb & getminf(msg.info, FROMFLD) & tb & getminf(msg.info, TPCFLD) & tb & flags, idx
    setmlpic mainform!msglist, mainform!msglist.LastAdded, flags
    addlst = True
ibxaddlsterr:
    Exit Function
End Function

Function bkquery () As Integer
' background query for new mail

    bkqflg = False
    qrqid = readpk("sa=GALEML;u:qrynew", mainform!getnewcbk)
    While qrqid >= 0
        DoEvents
    Wend
    bkquery = bkqflg
End Function

Sub chk4new ()
' check server for new mail and get if present

    If getnewipg Then
        popmsg "New messages are still being gotten.", ""
        Exit Sub
    End If
    If ibxconnect() Then
        If qrynew() Then
            ibxdidc = False
            periodic = False
            getnewmail True
        Else
            popmsg "There is currently no new mail for you at the Post Office.", ""
        End If
    End If
End Sub

Sub getnewmail (ByVal showibx As Integer)
' fire up asynchronous get new E-mail process
' showibx:  should we show the in box now or just get it in the background?

    If getnewipg Or (firstnew = 0) Then
        Exit Sub
    End If
    If Not inboxinit Then
        If proginuse() Then
            popmsg "New mail has just arrived in your Post Office, but can not be gotten because another operation is in progress. Let that operation finish, then click Get New Mail.", ""
            Exit Sub
        ElseIf loadinbox() = LOADABT Then
            poperror "In Box load aborted, new mail not gotten.", ""
            Exit Sub
        End If
    End If
    If Not ibxconnect() Then
        Exit Sub
    End If
    If showibx Then
        listinbox
    End If
    ibxdlipg = False
    getnewipg = True
    numnew = 0
    getnewrq = rgtdpk(rddpknam(firstnew - 1), wtspace(RDEMLMIN), -1, mainform!getnewcbk)
    tbinvis mtbid, CStr(MTB_NEWMAIL)
End Sub

Sub gotibxmsg (msg As msgdpk, ByVal msglen As Integer)
' got a message, put it in in box

    Dim i As Integer, j As Integer
    Dim attspec As String

    If cursource = SRCPOSTOFC Then
        pogotmsg msg.msgid
    End If
    junk = swrtdpkv(msgdpknam(msg.msgid), msglen, msg)
    If Not listoverflow Then
        i = addarr(msg)
        If cursource = SRCEINBOX And i >= 0 Then
            If addlst(i, msgarr(i)) Then
                If firstnew Then
                    If msg.msgid >= firstnew Then
                        mainform!msglist.TopIndex = i
                        setmsgidx i
                        firstnew = 0
                    End If
                End If
            Else
                listoverflow = True
                For j = i To ninmarr(msgarr()) - 2
                    msgarr(j) = msgarr(j + 1)
                Next
                ReDim Preserve msgarr(mainform!msglist.ListCount - 1)
            End If
        End If
    End If
    If ((msg.flags And FILATT) <> 0) And ((prefs.flags And PDLATT) <> 0) Then
        ibxdlipg = True
        attspec = autdlnam(Trim$(prefs.eattdir), Trim$(msg.attname))
        dlatt "", msg.msgid, fnpart(attspec), pppart(attspec), False
    End If
End Sub

Sub hdlcheckpref ()
' handle periodically-check-for-new-mail preference

    If checkpref.flags And CPGET Then
        checkcnt = 0
        On Error Resume Next
        mainform!checktimer.Enabled = True
        If Err Then
            poperror "Unable to start new mail check timer. Too many timers are already in use.", ""
        End If
    Else
        mainform!checktimer.Enabled = False
    End If
End Sub

Sub hdlchecktick ()
' handle check-for-new-mail timer tick

    checkcnt = checkcnt + 1
    If checkcnt >= checkpref.period Then
        checkcnt = 0
        ibxdidc = False
        periodic = False
        If checkpref.flags And CPCONN Then
            If Not connected() Then
                If ibxconnect() Then
                    ibxdidc = True
                End If
            End If
        End If
        If connected() Then
            If bkquery() Then
                periodic = True
                getnewmail False
            ElseIf ibxdidc And (checkpref.flags And CPDISC) <> 0 Then
                disconnect
            End If
        End If
    End If
End Sub

Function ibxcandel (msg As msgdpk) As Integer
' E-mail In Box:  can user delete this message
' msg:  dynapak form of message

    Dim tmpflg As Integer
    Dim smsg As msgdpkshrt

    tmpflg = getmidx(msg.msgid, msgarr()) >= 0
    If Not tmpflg And msg.forum <> EMLID Then
        LSet smsg = msg
        tmpflg = forcandel(smsg)
    End If
    ibxcandel = tmpflg
End Function

Function ibxcanread (ByVal msgidstr As String, ByVal direc As Integer) As Integer
' E-mail In Box:  can user read message in specified direction?
' msgidstr: identifier of current message (updated if successful)
' direc:    direction to read (-1=prev, 0=exact, 1=next)

    Dim dummy As Integer

    Select Case direc
    Case READPREV
        ibxcanread = srltdpk(msgdpknam(Val(msgidstr)), wtspace(LMSGMIN), Len(dummy), dummy) <> 0
    Case READTHIS
        ibxcanread = True
    Case READNEXT
        ibxcanread = srgtdpk(msgdpknam(Val(msgidstr)), wtspace(LMSGMIN), Len(dummy), dummy) <> 0
    End Select
End Function

Sub ibxcbkhlr (ByVal evtstg As String, ByVal reqid As Integer)
' E-mail In Box get new mail callback handler

    Dim msglen As Integer

    If getnewipg And (reqid = getnewrq) Then
        Select Case evtstg
        Case "Dynapak received"
            msglen = cbkrsp(Len(getmsg), getmsg)
            stpnls getmsg.info
            gotibxmsg getmsg, msglen
            numnew = numnew + 1
        Case Else
            getnewipg = False
            firstnew = 0
            adjrdbtn
            If Not appclsipg Then
                freeup
                If ibxdidc And Not ibxdlipg And (checkpref.flags And CPDISC) <> 0 Then
                    ibxdidc = False
                    disconnect
                End If
                If evtstg = "No more dynapaks" Then
                    If listoverflow Then
                        popmsg "You have just received " & numnew & " new e-mail message(s). However, there are too many messages in your In Box to display in this list, so only the first " & ninmarr(msgarr()) & " will be displayed.", "In Box"
                    ElseIf cursource <> SRCEINBOX Or periodic Then
                        popmsg "You have just received " & numnew & " new e-mail message(s).", "In Box"
                    End If
                Else
                    popmsg "New mail get aborted." & nl & numnew & " new message(s) gotten.", "In Box"
                End If
            End If
            periodic = False
        End Select
    ElseIf reqid = qrqid Then
        qrqid = -1
        If evtstg = "Dynapak received" Then
            bkqflg = (cbkrsp(Len(firstnew), firstnew) <> 0)
        End If
    End If
End Sub

Sub ibxclarpl (ByVal msgid As Long)
' E-mail In Box:  handle clear-after-reply

    junk = ibxdelmsg(CStr(msgid))
    If Len(rdmsg.Tag) <> 0 And Val(rdmsg!source) = SRCEINBOX And Val(rdmsg!msgid) = msgid Then
        junk = actcap(rdmsg, "hdldel", "")
    End If
End Sub

Sub ibxconn ()
' E-mail In Box handle connection
' check with server for new E-mail and act on preferences

    If Not ibxconnected And connected() Then
        If getnewipg Then
            Exit Sub
        End If
        If qrynew() Then
            If prefs.flags And PDLONC Then
                ibxdidc = False
                periodic = False
                If (prefs.flags And PRDONC) <> 0 And Not appconnected Then
                    getnewmail True
                Else
                    getnewmail False
                End If
            Else
                tbvis mtbid, CStr(MTB_NEWMAIL)
            End If
        Else
            firstnew = 0
        End If
    End If
End Sub

Private Function ibxconnect () As Integer
' E-mail In Box: connect to server if not already
' prevents conficts with other in box operations

    ibxconnected = True
    ibxconnect = appconnect()
    ibxconnected = False
End Function

Function ibxdelmsg (ByVal msgidstr As String) As Integer
' E-mail In Box:  delete a message function and update appropriate list
' msgidstr: message ID string of message to delete
' returns True if message deleted

    Dim i As Integer

    junk = swrtdpkv(msgdpknam(Val(msgidstr)), 0, 0)
    junk = swrtdpkv(notdpknam(Val(msgidstr)), 0, "")
    i = delmarr(Val(msgidstr), msgarr())
    If cursource = SRCEINBOX And i >= 0 Then
        inboxdel i
    End If
    ibxdelmsg = True
End Function

Sub ibxdlfin ()
' in box downloads complete notification handler

    If ibxdidc And ibxdlipg And (checkpref.flags And CPDISC) <> 0 Then
        disconnect
    End If
    ibxdidc = False
    ibxdlipg = False
End Sub

Function ibxidstr (ByVal lstidx As Integer) As String
' E-mail In Box:  generate message ID string for specified message in list

    ibxidstr = Format$(msgarr(lstidx).msgid, MNMFMT)
End Function

Sub ibxinit ()
' initialize in box at startup

    qrqid = -1
    ibxdidc = False
    ibxdlipg = False
    periodic = False
    hdlcheckpref
End Sub

Function ibxlstidx (ByVal msgidstr As String) As Integer
' E-mail In Box: get index of specified message in list of messages
' msgidstr: source-specific message ID string
' returns index or -1 if not found

    ibxlstidx = getmidx(Val(msgidstr), msgarr())
End Function

Sub ibxlstjmp (ByVal jumpto As Integer)
' E-mail In Box:  move list selection to specified message
' jumpto:   which message to jump to

    Dim i As Integer

    i = jumpidx(jumpto)
    If i >= 0 Then
        setmsgidx i
    End If
End Sub

Sub ibxpreprd (ByVal lstidx As Integer, capstr As String, btnflgs As Integer, capflgs As Integer, msgidstr As String)
' E-mail In Box:  prepare arguments to launch read form with
' lstidx:   index in message list of message to prepare
' capstr:   read form caption
' btnflgs:  button flags
' capflgs:  capability flags
' msgidstr: message ID string

    capstr = "In Box Message"
    btnflgs = RDBALL
    capflgs = RDCDEL Or RDCEDTNT
    msgidstr = ibxidstr(lstidx)
End Sub

Function ibxqryunl () As Integer
' OK with In Box if we unload main form

    If getnewipg Then
        ibxqryunl = gmsgbox("New mail is still being gotten. Are you sure you wish to quit?", MB_ICONQUESTION Or MB_YESNO Or MB_DEFBUTTON2, "") = IDNO
    End If
End Function

Function ibxrdjmp (msgidstr As String, ByVal jumpto As Integer) As Integer
' E-mail In Box: jump to (and read) a message
' msgidstr: message ID string of current message (updated if new message found)
' jumpto:   what message to jump to
' returns True if message found

    Dim i As Integer
    Dim tmps As String

    ibxrdjmp = False
    i = jumpidx(jumpto)
    If i >= 0 Then
        tmps = ibxidstr(i)
        If ibxrdmsg(tmps, READTHIS) Then
            msgidstr = tmps
            ibxrdjmp = True
        End If
    End If
End Function

Function ibxrdmsg (msgidstr As String, ByVal direc As Integer) As Integer
' E-mail In Box:  read-a-message function
' msgidstr: identifier of current message (updated if successful)
' direc:    direction to read (-1=prev, 0=exact, 1=next)
' returns:  True if message found
' implicit output: message is in msgindpk if returns True

    Dim rsplen As Integer

    Select Case direc
    Case READPREV
        rsplen = srltdpk(msgdpknam(Val(msgidstr)), wtspace(LMSGMIN), Len(msgindpk), msgindpk)
    Case READTHIS
        rsplen = sreadpk(msgdpknam(Val(msgidstr)), Len(msgindpk), msgindpk)
    Case READNEXT
        rsplen = srgtdpk(msgdpknam(Val(msgidstr)), wtspace(LMSGMIN), Len(msgindpk), msgindpk)
    End Select
    If rsplen Then
        msgidstr = itemidxd(namdpk(), 1, " ")
        stpnls msgindpk.info
    End If
    ibxrdmsg = rsplen <> 0
End Function

Sub ibxsynclst (ByVal msgidstr As String)
' E-mail In Box: synchronize list with given message
' msgidstr:     ID string of message to synchronize with

    inboxjmp Val(msgidstr)
End Sub

Private Sub inboxdel (ByVal index As Integer)
' remove item from list
' index:    index in list of item to remove

    If cursource = SRCEINBOX Then
        remlbitem mainform!msglist, index
    End If
End Sub

Private Sub inboxjmp (ByVal msgnum As Long)
' highlight a specified message in in box if it is available
' msgnum:   message number to highlight

    Dim i As Integer

    If cursource = SRCEINBOX Then
        i = getmidx(msgnum, msgarr())
        If i >= 0 Then
            setmsgidx i
        End If
    End If
End Sub

Private Function jumpidx (ByVal jumpto As Integer) As Integer
' get index of message to jump to
' jumpto:   which message to jump to code
' returns index or -1 if cancelled

    Dim idx As Integer
    Dim tmpid As Long, comp As Long

    jumpidx = -1
    Select Case jumpto
    Case JUMPFRST
        jumpidx = 0
    Case JUMPSPEC
        tmpid = getjmpmid()
        If tmpid >= 0 Then
            If tmpid <= msgarr(0).msgid Then
                jumpidx = 0
            ElseIf tmpid >= msgarr(UBound(msgarr)).msgid Then
                jumpidx = UBound(msgarr)
            Else
                idx = nearmidx(comp, tmpid, msgarr())
                If comp < 0 And idx > 0 Then
                    idx = idx - 1
                End If
                jumpidx = idx
            End If
        End If
    Case JUMPLAST
        jumpidx = UBound(msgarr)
    End Select
End Function

Sub listinbox ()
' load main form list with in box

    If cursource = SRCEINBOX Then
        Exit Sub
    End If
    If Not abtonact() Then
        Exit Sub
    End If
    If Not inboxinit Then
        If loadinbox() <> LOADOK Then
            Exit Sub
        End If
    End If
    cursource = SRCEINBOX
    emlsetup "In Box", False
    showlist
    stdmlfin
End Sub

Private Function loadinbox () As Integer
' load in box messages into memory
' returns result code

    Dim dpknam As String
    Static norecurs As Integer  ' assume this gets initialized to False


    If norecurs Then
        loadinbox = LOADRCS
        Exit Function
    End If
    norecurs = True
    loadinbox = LOADABT
    Erase msgarr
    inboxinit = False
    listoverflow = False
    progopen PRGT_INF, "Loading In Box", "", "Message #", MNMFMT
    dpknam = msgdpknam(0)
    Do While srgtdpk(dpknam, wtspace(LMSGMIN), Len(getmsg), getmsg)
        dpknam = namdpk()
        DoEvents
        junk = addarr(getmsg)
        If convertflag Then     ' convert in box contents to new marking read scheme
            If getmsg.flags And OLDMSGREAD Then
                markmsg getmsg.forum, getmsg.msgid
            End If
        End If
        DoEvents
        If progcancel() Then
            progclose
            Erase msgarr
            norecurs = False
            Exit Function
        End If
        DoEvents
        progupdate CStr(getmsg.msgid)
        DoEvents
    Loop
    progclose
    inboxinit = True
    loadinbox = LOADOK
    norecurs = False
End Function

Private Function msgdpknam (ByVal msgid As Long) As String
' generate dynapak name for reading locally-cached message

    msgdpknam = LMSGDPK & Format$(msgid, MNMFMT)
End Function

Private Function notdpknam (ByVal msgid As Long) As String
' generate dynapak name for reading locally-cached message

    notdpknam = IBXNOTDPK & Format$(msgid, MNMFMT)
End Function

Function qrynew () As Integer
' does user have new mail on the server?

    qrynew = sreadpk("sa=GALEML;u:qrynew", Len(firstnew), firstnew) <> 0
End Function

Function rddpknam (ByVal msgid As Long) As String
' generate dynapak name for reading message from server

    rddpknam = RDEMLDPK & Format$(msgid, MNMFMT)
End Function

Private Sub showlist ()
' show list of messages in in box

    Dim i As Integer, hilite As Integer, found As Integer

    found = False
    hilite = 0
    For i = 0 To ninmarr(msgarr()) - 1
        If Not addlst(i, msgarr(i)) Then
            Screen.MousePointer = NORMAL
            poperror "There are more messages in your In Box than can be displayed in this list! Only the first " & CStr(mainform!msglist.ListCount) & " of " & CStr(ninmarr(msgarr())) & " are displayed.", "In Box"
            ReDim Preserve msgarr(mainform!msglist.ListCount - 1)
            Exit For
        End If
        If (Val(iteminfo(mainform!msglist.List(i), MLI_FLAGS)) And MLF_READ) = 0 And Not found Then
            found = True
            hilite = i
        End If
    Next
    If ninmarr(msgarr()) Then
        If hilite Then
            mainform!msglist.TopIndex = hilite - 1
        End If
        setmsgidx hilite
    End If
End Sub

