VERSION 2.00
Begin Form comment
   BackColor       =   &H00C0C0C0&
   Caption         =   "Comment on Message"
   ClientHeight    =   3960
   ClientLeft      =   1755
   ClientTop       =   2565
   ClientWidth     =   9075
   Height          =   4425
   HelpContextID   =   21
   Icon            =   0
   KeyPreview      =   -1  'True
   Left            =   1665
   MinButton       =   0   'False
   ScaleHeight     =   3960
   ScaleWidth      =   9075
   Top             =   2190
   Width           =   9255
   Begin SSPanel butpic
      Alignment       =   1  'Left Justify - MIDDLE
      BevelOuter      =   0  'None
      ForeColor       =   &H00000000&
      Height          =   360
      Left            =   3060
      TabIndex        =   10
      Top             =   3480
      Width           =   3060
      Begin CommandButton cancelbut
         BackColor       =   &H00C0C0C0&
         Cancel          =   -1  'True
         Caption         =   "Cancel"
         Height          =   360
         Left            =   1020
         TabIndex        =   13
         Top             =   0
         Width           =   960
      End
      Begin CommandButton okbut
         BackColor       =   &H00C0C0C0&
         Caption         =   "&OK"
         Height          =   360
         Left            =   0
         TabIndex        =   12
         Top             =   0
         Width           =   960
      End
      Begin CommandButton helpbut
         BackColor       =   &H00C0C0C0&
         Caption         =   "Help"
         Height          =   360
         Left            =   2100
         TabIndex        =   11
         Top             =   0
         Width           =   960
      End
   End
   Begin Timer movetimer
      Enabled         =   0   'False
      Interval        =   1
      Left            =   120
      Top             =   3480
   End
   Begin HScrollBar hscroll
      Height          =   255
      Left            =   60
      TabIndex        =   9
      TabStop         =   0   'False
      Top             =   3120
      Width           =   8715
   End
   Begin VScrollBar vscroll
      Height          =   2295
      Left            =   8760
      TabIndex        =   8
      TabStop         =   0   'False
      Top             =   840
      Width           =   255
   End
   Begin PictureBox cmtpic
      Height          =   2295
      Left            =   60
      ScaleHeight     =   2265
      ScaleWidth      =   8685
      TabIndex        =   7
      TabStop         =   0   'False
      Top             =   840
      Width           =   8715
      Begin TextBox cmttxt
         BorderStyle     =   0  'None
         Height          =   32767
         Left            =   0
         MultiLine       =   -1  'True
         TabIndex        =   0
         Top             =   0
         Width           =   7875
      End
   End
   Begin Label Label1
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "From:"
      Height          =   195
      Left            =   60
      TabIndex        =   1
      Top             =   360
      Width           =   615
   End
   Begin Label Label2
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "Topic:"
      Height          =   195
      Left            =   60
      TabIndex        =   2
      Top             =   600
      Width           =   615
   End
   Begin Label from
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Left            =   780
      TabIndex        =   3
      Top             =   360
      Width           =   45
   End
   Begin Label topic
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Left            =   780
      TabIndex        =   4
      Top             =   600
      Width           =   45
   End
   Begin Label Label5
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Caption         =   "To:"
      Height          =   195
      Left            =   60
      TabIndex        =   5
      Top             =   120
      Width           =   615
   End
   Begin Label towho
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      FontBold        =   0   'False
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   8.25
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      Height          =   195
      Left            =   780
      TabIndex        =   6
      Top             =   120
      Width           =   45
   End
End
'********************************************************************************
'*                                                                              *
'*  COMMENT.FRM                                                                 *
'*                                                                              *
'*  Copyright (c) 1994-1997 Galacticomm, Inc.      All rights reserved.         *
'*                                                                              *
'*  Comment about message code.                                                 *
'*                                                                              *
'*                                                  - J. Alvrus 10/26/95        *
'*                                                                              *
'********************************************************************************

Option Explicit

Const CMTFRMID = "commentform"
Const EM_LINEINDEX = &H40B
Const EM_LINELENGTH = &H411
Const EM_LINEFROMCHAR = &H419

Dim minw As Single, minh As Single
Dim ok2change As Integer
Dim lineh As Integer
Dim charw As Integer
Dim respstr As String

Sub cancelbut_Click ()
    Unload Me
End Sub

Sub cmtpic_GotFocus ()
    On Error Resume Next
    cmttxt.SetFocus
End Sub

Sub cmttxt_Change ()
    If ok2change Then
        vscroll.Max = gettxtnlin(cmttxt) - 1
        showcaret
    End If
End Sub

Sub cmttxt_KeyDown (KeyCode As Integer, Shift As Integer)
    eatctrltab KeyCode, Shift
    If KeyCode Then
        movetimer.Enabled = True
    End If
End Sub

Sub cmttxt_LostFocus ()
    snagtab cmttxt, Space$(prefs.txttabsiz - (gettxtx(cmttxt) Mod prefs.txttabsiz))
End Sub

Sub cmttxt_MouseMove (Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button And KEY_LBUTTON Then
        showcaret
    End If
End Sub

Sub Form_Activate ()
    cmttxt_Change   'sets up scroll bar and caret
End Sub

Sub Form_KeyDown (KeyCode As Integer, Shift As Integer)
    Dim pt As pointstruct
    Dim tmpx As Integer, tmpy As Integer
    Dim curline As Integer, lvis As Integer, ltot As Integer

    Select Case KeyCode
    Case KEY_PRIOR      'Page Up
        If Shift = 0 Then
            GetCaretPos pt
            tmpx = (pt.pointx * Screen.TwipsPerPixelX) / charw
            tmpy = (pt.pointy * Screen.TwipsPerPixelY) / lineh
            lvis = Int(cmtpic.ScaleHeight / lineh)
            If tmpy > lvis Then
                tmpy = tmpy - lvis + 1
            Else
                tmpy = 0
            End If
            settxtpos cmttxt, tmpx, tmpy
            If vscroll.Value > vscroll.LargeChange Then
                vscroll.Value = vscroll.Value - vscroll.LargeChange
            Else
                vscroll.Value = 0
            End If
            showcaret
        End If
        KeyCode = 0
    Case KEY_NEXT       'Page Down
        If Shift = 0 Then
            GetCaretPos pt
            tmpx = (pt.pointx * Screen.TwipsPerPixelX) / charw
            tmpy = (pt.pointy * Screen.TwipsPerPixelY) / lineh
            lvis = Int(cmtpic.ScaleHeight / lineh)
            ltot = gettxtnlin(cmttxt)
            If tmpy + lvis < ltot Then
                tmpy = tmpy + lvis - 1
            Else
                tmpy = ltot - 1
            End If
            settxtpos cmttxt, tmpx, tmpy
            If vscroll.Value < vscroll.Max - vscroll.LargeChange Then
                vscroll.Value = vscroll.Value + vscroll.LargeChange
            Else
                vscroll.Value = vscroll.Max
            End If
            showcaret
        End If
        KeyCode = 0
    End Select
End Sub

Sub Form_Load ()
    Dim s As String

    respstr = ""
    towho = getminf(formxchg, 0)
    from = getminf(formxchg, 1)
    topic = getminf(formxchg, 2)
    setdlgfont cmttxt, prefs.fontpref(FPTXTWRT)
    cmttxt.ForeColor = prefs.fontpref(FPTXTWRT).color
    setffont Me, cmttxt
    lineh = TextHeight(" ")
    charw = TextWidth(" ")
    cmttxt.MaxLength = Val(getminf(formxchg, 3))
    cmttxt.Height = 32767 * Screen.TwipsPerPixelY
    cmttxt.Width = charw * MXLLEN
    minh = butpic.Height + cmtpic.Top + 2 * lineh + hscroll.Height + 2 * SAMEDIST
    minw = butpic.Width + (2 * cmtpic.Left)
    vscroll.Width = GetSystemMetrics(SM_CXVSCROLL) * Screen.TwipsPerPixelX
    hscroll.Height = GetSystemMetrics(SM_CYHSCROLL) * Screen.TwipsPerPixelY
    vscroll.SmallChange = 1
    hscroll.SmallChange = charw
    hscroll.LargeChange = TextWidth(Space$(10))
    ok2change = False
    Caption = getminf(formxchg, 4)
    HelpContextID = Val(getminf(formxchg, 5))
    cmttxt = getminf(formxchg, 6)
    ok2change = True
    posiload Me, CMTFRMID
End Sub

Sub Form_Resize ()
    Dim tmpsw As Single, tmpw As Single
    Dim tmpsh As Single, tmph As Single

    If Me.WindowState = MINIMIZED Then
        Exit Sub
    End If
    tmpsw = ScaleWidth
    If tmpsw < minw Then
        tmpsw = minw
    End If
    tmpw = tmpsw - 2 * cmtpic.Left
    tmpsh = ScaleHeight
    If tmpsh < minh Then
        tmpsh = minh
    End If
    tmph = tmpsh - cmtpic.Top - butpic.Height - 2 * SAMEDIST
    cmtpic.Width = tmpw - vscroll.Width + Screen.TwipsPerPixelX
    vscroll.Left = cmtpic.Left + tmpw - vscroll.Width
    If cmtpic.ScaleWidth < cmttxt.Width Then
        hscroll.Visible = True
        hscroll.Top = cmtpic.Top + tmph - hscroll.Height
        hscroll.Width = cmtpic.Width
        hscroll.Max = cmttxt.Width - cmtpic.ScaleWidth
        cmtpic.Height = tmph - hscroll.Height + Screen.TwipsPerPixelY
        vscroll.Height = cmtpic.Height
    Else
        hscroll.Visible = False
        cmtpic.Height = tmph
        vscroll.Height = tmph
    End If
    butpic.Move (tmpsw - butpic.Width) / 2, cmtpic.Top + tmph + SAMEDIST
    vscroll.LargeChange = cmtpic.Height \ lineh - 1
    vscroll.Max = gettxtnlin(cmttxt) - 1
End Sub

Sub Form_Unload (Cancel As Integer)
    posisave Me, CMTFRMID, True
    formxchg = respstr
End Sub

Function gettxtnlin (c As TextBox) As Long
' get number of lines in a TextBox

    gettxtnlin = sndmsg(c.hWnd, EM_GETLINECOUNT, 0, 0&)
End Function

Function gettxtx (c As TextBox) As Long
' get character x coordinate of TextBox SelStart (zero-based)

    gettxtx = c.SelStart - sndmsg(c.hWnd, EM_LINEINDEX, gettxty(c), 0&)
End Function

Function gettxty (c As TextBox) As Long
' get character y coordinate of TextBox SelStart (zero-based)

    If c.SelStart = Len(c.Text) Then
        gettxty = gettxtnlin(c) - 1
    Else
        gettxty = sndmsg(c.hWnd, EM_LINEFROMCHAR, c.SelStart, 0&)
    End If
End Function

Sub helpbut_Click ()
    On Error Resume Next
    cmttxt.SetFocus
    dohelp helpbut, HELP_CONTEXT
End Sub

Sub hscroll_Change ()
    cmttxt.Left = -hscroll.Value
End Sub

Sub hscroll_Scroll ()
    hscroll_Change
End Sub

Sub movetimer_Timer ()
    movetimer.Enabled = False
    showcaret
End Sub

Sub okbut_Click ()
    respstr = "OK" & FLDSEP & cmttxt
    Unload Me
End Sub

Sub settxtpos (c As TextBox, ByVal xpos As Integer, ByVal ypos As Integer)
' put caret at specific coordinates

    Dim lstart As Long, maxx As Long

    lstart = sndmsg(c.hWnd, EM_LINEINDEX, ypos, 0)
    maxx = sndmsg(c.hWnd, EM_LINELENGTH, lstart, 0)
    If xpos > maxx Then
        xpos = maxx
    End If
    c.SelStart = lstart + xpos
End Sub

Sub showcaret ()
' make sure caret is displayed in text box

    Dim pt As pointstruct
    Dim tmpx As Long, tmpy As Long
    Dim tmpval As Single

    GetCaretPos pt
    tmpx = pt.pointx * Screen.TwipsPerPixelX
    tmpy = pt.pointy * Screen.TwipsPerPixelY
    If tmpx < -cmttxt.Left Then
        hscroll.Value = hscroll.LargeChange * Int(tmpx / hscroll.LargeChange)
    ElseIf tmpx >= -cmttxt.Left + cmtpic.ScaleWidth Then
        tmpval = hscroll.LargeChange * (Int((tmpx - cmtpic.ScaleWidth) / hscroll.LargeChange) + 1)
        If tmpval > hscroll.Max Then
            tmpval = hscroll.Max
        End If
        hscroll.Value = tmpval
    End If
    If tmpy < -cmttxt.Top Then
        vscroll.Value = Int(tmpy / lineh)
    ElseIf tmpy > -cmttxt.Top + cmtpic.ScaleHeight - lineh Then
        vscroll.Value = Int((tmpy - cmtpic.ScaleHeight) / lineh) + 2
    End If
End Sub

Sub vscroll_Change ()
    cmttxt.Top = -(lineh * vscroll.Value)
End Sub

Sub vscroll_Scroll ()
    vscroll_Change
End Sub

