'******************************************************************************
'*                                                                            *
'*   ADDRBOOK.BAS                                                             *
'*                                                                            *
'*   Copyright (c) 1994-1997 Galacticomm, Inc.      All rights reserved.      *
'*                                                                            *
'*   This is the Address Book and Distribution Lists .BAS file.               *
'*                                                                            *
'*                                                  - Tim Stark 10/18/94      *
'*                                                                            *
'******************************************************************************

Option Explicit

'************************** global declarations *******************************

' general global constants
Global Const EMLNAMSIZ = 60         ' max name size
Global Const EMLADRSIZ = 255        ' max address size
Global Const EMLCMTSIZ = 1000       ' max comment size
Global Const NORMADRSIZ = 38        ' normal address size for dpk suffix
Global Const MAXADRSIZ = 39         ' long address size for dpk suffix
Global Const ASCIIOFFSET = 123      ' ascii offset value for duplicate character (39) in suffix
Global Const ABKDLID = 0            ' address book dynamic list box ID
Global Const MINLCH = 0             ' minimum sysop-defined distribution list charge
Global Const MAXLCH = 32000         ' maximum sysop-defined distribution list charge

' define different types of distribution lists
Global Const CLIST = 0              ' client-side list
Global Const SLIST = 1              ' server-side list

' define listlist flags used with getadr()
Global Const ADDRBK = 1             ' address book is valid
Global Const DISLST = 2             ' distribution lists are valid
Global Const FORLST = 4             ' forum lists are valid

' define listlist CONSTANTS used with getadr()
Global Const ABKISLST = 0           ' address book is current listlist sel
Global Const DLISLST = 1            ' distribution list is current listlist sel
Global Const FORISLST = 2           ' forums list is current listlist sel

' text to display in listlist in abkgafrm.frm
Global Const ABDIS = "Address Book"
Global Const DLDIS = "Distribution Lists"
Global Const FLDIS = "Forums"

' define different modes for emode
Global Const ADDMD = 1              ' add mode
Global Const EDITMD = 2             ' edit mode

Global Const CDLNAM = "sa=GALEML;ul:CLIST " ' client-side dist list
Global Const CDLMIN = "CLIST "      ' client-side min suffix
Global Const ABKNAM = "sa=GAL_ABK;ul:" ' address book dynapak name
Global Const ABKMIN = ""            ' address book min suffix
Global Const SDLNAM = "(c=p)sa=GALEML;:SLIST " ' server-side dis list info dynapak name
Global Const SDLMIN = "SLIST "      ' server-side dis list min suffix
Global Const EDLNAM = "(c=p)sa=GALEML;:ELIST " ' edit server-side dis list dynapak name
Global Const EDLMIN = "ELIST "      ' edit server-side dis list min suffix
Global Const SLINAM = "sa=GALEML;f:SLIST " ' server-side dis list data request dynapak name
Global Const CRTNAM = "sa=GALEML;:crtlst " ' create server-side dis list request
Global Const ADLNAM = "sa=GALEML;:addlst " ' add entry to server-side dis list request

Type emlmgmt                        ' email management structure
    name As String * EMLNAMSIZ      '   name of user
    address As String * EMLADRSIZ   '   address of user
    comments As String * EMLCMTSIZ  '   comments
End Type

Type dismgmt                        ' distribution list management structure
    key As String * VBKEYSIZ        '   list key
    surchg As Integer               '   list surcharge
End Type

Global frommab As Integer           ' is abkeadded being called from mab?
Global emode As Integer             ' current mode of operation
Global adr() As String              ' array of address book entries
Global dis() As Integer             ' array of dist list types synched w/dislist

Global eml As emlmgmt               ' declare memory for emlmgmt
Global tmpeml As emlmgmt            ' declare temporary for emlmgmt

Function addifnew (ByVal address As String)
' add address to list if it doesn't already exist
' returns: added - true/false
' address: address to check/add

    Dim dpknam As String

    If sameas(address, ALLINF) Then
        addifnew = False
        Exit Function
    End If
    dpknam = isrealdup(Trim$(address))
    If Len(dpknam) = 0 Then
        eml.name = Trim$(address)
        eml.address = Trim$(address)
        eml.comments = ""
        junk = swrtabkv(dpknam, eml)
        addifnew = True
    Else
        addifnew = False
    End If
End Function

Sub addtodl (lst As Control, ByVal lname As String, ByVal ltype As Integer, setidx As Integer)
' add entry to a list
' lst: list to add entry to
' setidx: true/false integer whether to set listindex

    Dim i As Integer, idx As Integer, added As Integer

    idx = -1
    For i = 0 To lst.ListCount - 1
        If sameas(lst.List(i), Trim$(lname)) Then
            idx = i
            Exit For
        End If
    Next i
    If idx = -1 Then
        added = True
        lst.AddItem Trim$(lname)
        idx = lst.LastAdded
    Else
        added = False
    End If
    If Left$(lname, 1) <> "@" Then
        setadrico CDLLAB & Trim$(lname), lst, idx
    Else
        setadrico Trim$(lname), lst, idx
    End If
    If added Then
        ReDim Preserve dis(lst.ListCount - 1)
        For i = lst.ListCount - 1 To lst.LastAdded + 1 Step -1
            dis(i) = dis(i - 1)
        Next
        dis(lst.LastAdded) = ltype
    End If
    If setidx Then
        lst.ListIndex = lst.LastAdded
    End If
End Sub

Sub addtolist (lst As Control, setidx As Integer)
' add entry to a list
' lst: list to add entry to
' setidx: true/false integer whether to set listindex

    Dim i As Integer, idx As Integer, comp As Integer

    comp = 1
    idx = nearname(comp, Trim$(eml.name), lst)
    If comp > 0 Then
        idx = idx + 1
    End If
    lst.AddItem Trim$(eml.name), idx
    If setidx Then
        lst.ListIndex = idx
    End If
    setadrico Trim$(eml.address), lst, idx
    ReDim Preserve adr(lst.ListCount - 1)
    For i = lst.ListCount - 1 To idx + 1 Step -1
        adr(i) = adr(i - 1)
    Next
    adr(lst.LastAdded) = Trim$(eml.address)
End Sub

Sub clipadr (ByVal address As String)
' clip an address to address book, called from Email or Forum messages
' adrlist: Address(s) to clip to address book
    Dim retval As Integer, i As Integer
    Dim dpknam As String, tmpadr As String

    tmpadr = ""
    For i = 0 To itemcntd(address, ";") - 1
        If Not sameas(Trim$(itemidxd(address, i, ";")), ALLINF) Then
            If tmpadr <> "" Then
                tmpadr = tmpadr & ";"
            End If
            tmpadr = tmpadr & Trim$(itemidxd(address, i, ";"))
        End If
    Next i
    If itemcntd(tmpadr, ";") > 1 Then
        tmpadr = formfunc(abkgamlt, Trim$(tmpadr))
        If Len(tmpadr) = 0 Then
            Exit Sub
        End If
    End If
    eml.name = Trim$(itemidxd(tmpadr, 0, ";"))
    eml.address = eml.name
    eml.comments = ""
    emode = ADDMD
    retval = Val(formfunc(abkeadded, ""))
    If retval Then
        dpknam = isrealdup(Trim$(eml.address))
        junk = swrtabkv(dpknam, eml)
    End If
End Sub

Function getadr (ByVal flags As Integer, ByVal caption As String, ByVal adrlist As String) As String
' get address for sending email/forum messages
' flags:    list or lists flag for which lists to display
' caption:  caption to put on address book form
' adrlist:  list of addresses (to addr, FLDSEP, cc: addr; cc: addr; ...)

    getadr = formfunc(abkgafrm, Str$(flags) & FLDSEP & caption & FLDSEP & adrlist)
End Function

Function getpdupidx (adr As String) As Integer
' get next available index on partial duplicate suffix names for address longer than NORMADRSIZ
' always call isrealdup() first to make sure address doesn't already exist
' returns: unique index value to use (164 possible slots)
' adr: address string to check

    Dim idx As Integer, cnt As Integer, colonpos As Integer
    Dim readstg As String, tmpsuf As String

    screen.MousePointer = HOURGLASS
    readstg = srgtdpkv(ABKNAM & Mid$(Trim$(adr), 1, NORMADRSIZ), ABKMIN)
    If Len(readstg) > 0 Then
        colonpos = InStr(1, namdpk(), ":")
        If colonpos > 0 Then
            Do
                colonpos = InStr(1, namdpk(), ":")
                If colonpos = 0 Then
                    Exit Do
                End If
                tmpsuf = Mid$(Trim$(namdpk()), colonpos + 1)
                If Not sameas(Mid$(tmpsuf, 1, NORMADRSIZ), Mid$(Trim$(adr), 1, NORMADRSIZ)) Then
                    Exit Do
                End If
                idx = Asc(Mid$(tmpsuf, NORMADRSIZ + 1, MAXADRSIZ + 1)) - ASCIIOFFSET
                If Len(readstg) = 0 Or idx <> cnt Or Len(tmpsuf) < MAXADRSIZ Then
                    Exit Do
                End If
                cnt = cnt + 1
                readstg = srgtdpkv(namdpk(), ABKMIN)
            Loop
        End If
    End If
    screen.MousePointer = DEFAULT
    getpdupidx = cnt
End Function

Function getplist (ByVal lstnam As String) As String
' get the contents of a client-side (personal) list
    Dim tmplst As String

    If sameto(CDLLAB, lstnam) Then
        lstnam = Mid$(lstnam, Len(CDLLAB) + 1)
    End If
    getplist = itemdeld(sreadpkv(CDLNAM & Trim$(lstnam)), 0, ";")
End Function

Function isrealdup (adr As String) As String
' check for exact duplicate of address in database
' returns: namdpk() of duplicate if found, else an empty string

    Dim idx As Integer, cnt As Integer, colonpos As Integer
    Dim readint As Integer
    Dim dupret As String

    screen.MousePointer = HOURGLASS
    dupret = ""
    If Len(adr) > NORMADRSIZ Then
        readint = srgtdpk(ABKNAM & Mid$(Trim$(adr), 1, NORMADRSIZ), ABKMIN, Len(tmpeml), tmpeml)
        If readint > 0 Then
            Do
                If readint = 0 Or Not sameas(Mid$(Trim$(adr), 1, NORMADRSIZ), Mid$(Trim$(tmpeml.address), 1, NORMADRSIZ)) Then
                    Exit Do
                End If
                If sameas(Trim$(adr), Trim$(tmpeml.address)) Then
                    dupret = namdpk()
                    Exit Do
                End If
                readint = srgtdpk(namdpk(), ABKMIN, Len(tmpeml), tmpeml)
            Loop
        End If
    ElseIf sreadpk(ABKNAM & Trim$(adr), Len(tmpeml), tmpeml) > 0 Then
        dupret = namdpk()
    End If
    screen.MousePointer = DEFAULT
    isrealdup = dupret
End Function

Private Function nearname (comp As Integer, ByVal nam As String, lst As Control) As Integer
' find a string in a lst box
' lst box must be sorted, and only the first column is searched

    Dim lo As Integer, md As Integer, hi As Integer

    md = -1
    If lst.ListCount Then
        lo = 0
        hi = lst.ListCount - 1
        Do While lo <= hi
            md = lo + Int((hi - lo) / 2)
            comp = stricmp(nam, lst.List(md))
            If comp < 0 Then
                hi = md - 1
            ElseIf comp > 0 Then
                lo = md + 1
            Else
                Exit Do
            End If
        Loop
    End If
    nearname = md
End Function

Sub remfromdl (lst As Control, ByVal idx As Integer)
' remove item from a list of distribution lists
' lst: list to remove item from
' idx: index in list of item to be removed

    Dim i As Integer

    remlbitem lst, idx
    For i = idx + 1 To lst.ListCount
        dis(i - 1) = dis(i)
    Next
    If lst.ListCount > 0 Then
        ReDim Preserve dis(lst.ListCount - 1)
    End If
End Sub

Sub remfromlist (lst As Control, idx As Integer)
' remove item from a list
' lst: list to remove item from
' idx: index in list of item to be removed

    Dim i As Integer

    screen.MousePointer = HOURGLASS
    remlbitem lst, idx
    For i = idx + 1 To lst.ListCount
        adr(i - 1) = adr(i)
    Next
    If lst.ListCount > 0 Then
        ReDim Preserve adr(lst.ListCount - 1)
    End If
    screen.MousePointer = DEFAULT
End Sub

Sub setadrico (adr As String, lst As Control, ByVal idx As Integer)
' set icon in list to proper type per address
' adr: address of current listing
' lst: list control to use
' idx: index of list

    setadbmp lst, idx, adr
End Sub

Sub shwadrbk (lst As Control)
' show address book, load into list
' lst: list to load addresses into

    Dim readint As Integer

    screen.MousePointer = HOURGLASS
    winrefresh lst.hWnd, False
    lst.Clear
    readint = srgtdpk(wtspace(ABKNAM), wtspace(ABKMIN), Len(eml), eml)
    If readint > 0 Then
        addtolist lst, False
        Do
            readint = srgtdpk(namdpk(), wtspace(ABKMIN), Len(eml), eml)
            If readint = 0 Then
                Exit Do
            End If
            addtolist lst, False
        Loop
        lst.ListIndex = 0
    End If
    winrefresh lst.hWnd, True
    lst.Refresh
    screen.MousePointer = DEFAULT
End Sub

Function stripsemi (stg As String) As String
' strip a string of all semi-colons
' stg: string possibly containing semi-colons to be stripped

    Dim pos As Integer
    Dim tmpstg As String

    tmpstg = ""
    Do
        pos = InStr(stg, ";")
        If pos > 0 Then
            tmpstg = Left$(stg, pos - 1)
            tmpstg = tmpstg & Mid$(stg, pos + 1)
        Else
            Exit Do
        End If
    Loop
    stripsemi = tmpstg
End Function

Function swrtabkv (dpknam As String, adrptr As emlmgmt) As String
' synchronisly write an entry into address book handling larger than NORMADRSIZ
' addresses if necessary.  If dpknam is supplied then write without any checks.
' returns: string as returned by swrtdpkv()
' adrptr: structure to use for swrtdpkv()

    Dim match As Integer

    If Len(dpknam) > 0 Then
        swrtabkv = swrtdpkv(dpknam, Len(adrptr), adrptr)
    ElseIf (Len(Trim$(adrptr.address))) > NORMADRSIZ Then
        match = getpdupidx(Trim$(adrptr.address))
        swrtabkv = swrtdpkv(ABKNAM & Mid$(Trim$(adrptr.address), 1, NORMADRSIZ) & Chr$(match + ASCIIOFFSET), Len(adrptr), adrptr)
    Else
        swrtabkv = swrtdpkv(ABKNAM & Trim$(adrptr.address), Len(adrptr), adrptr)
    End If
End Function

Sub updlist (lst As Control, idx As Integer)
' update list entry and dynapak information
' lst: list to update
' idx: current index of item in list

    Dim dpknam As String

    dpknam = isrealdup(Trim$(adr(idx)))
    If Not sameas(Trim$(eml.address), Trim$(tmpeml.address)) Then
        junk = swrtdpkv(dpknam, 0, "")
        dpknam = ""
    End If
    If Not sameas(Trim$(eml.name), Trim$(tmpeml.name)) Then
        remfromlist lst, idx
        addtolist lst, True
    Else
        adr(idx) = Trim$(eml.address)
        setadrico adr(idx), lst, idx
    End If
    junk = swrtabkv(dpknam, eml)
End Sub

Sub valadr ()
' validate address for saving

    If Len(abkeadded!uname) > 0 And Len(abkeadded!address) > 0 And Not abkeadded!okbut.Enabled Then
        abkeadded!okbut.Enabled = True
    ElseIf abkeadded!okbut.Enabled Then
        If Len(abkeadded!uname) = 0 Or Len(abkeadded!address) = 0 Then
            abkeadded!okbut.Enabled = False
        End If
    End If
End Sub

