VERSION 2.00
Begin Form abkeditdl 
   BackColor       =   &H00C0C0C0&
   Caption         =   "Edit Distribution List"
   ClientHeight    =   4395
   ClientLeft      =   1695
   ClientTop       =   2655
   ClientWidth     =   5820
   Height          =   4860
   HelpContextID   =   61
   Icon            =   0
   Left            =   1605
   MinButton       =   0   'False
   ScaleHeight     =   4395
   ScaleWidth      =   5820
   Top             =   2280
   Width           =   6000
   Begin SSPanel butpic 
      BevelOuter      =   0  'None
      ForeColor       =   &H00000000&
      Height          =   3975
      Left            =   4740
      TabIndex        =   1
      Top             =   60
      Width           =   960
      Begin CommandButton okbtn 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&OK"
         Height          =   360
         Left            =   0
         TabIndex        =   10
         Top             =   0
         Width           =   960
      End
      Begin CommandButton helpbtn 
         BackColor       =   &H00C0C0C0&
         Caption         =   "Help"
         Height          =   360
         Left            =   0
         TabIndex        =   9
         Top             =   3600
         Width           =   960
      End
      Begin CommandButton delbtn 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Delete"
         Height          =   360
         Left            =   0
         TabIndex        =   8
         Top             =   1740
         Width           =   960
      End
      Begin CommandButton editbtn 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Edit..."
         Height          =   360
         Left            =   0
         TabIndex        =   7
         Top             =   1320
         Width           =   960
      End
      Begin CommandButton addbtn 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Add..."
         Default         =   -1  'True
         Height          =   360
         Left            =   0
         TabIndex        =   6
         Top             =   900
         Width           =   960
      End
      Begin CommandButton impbtn 
         BackColor       =   &H00C0C0C0&
         Caption         =   "&Import..."
         Height          =   360
         Left            =   0
         TabIndex        =   5
         Top             =   2700
         Width           =   960
      End
      Begin CommandButton cancelbtn 
         BackColor       =   &H00C0C0C0&
         Cancel          =   -1  'True
         Caption         =   "Cancel"
         Height          =   360
         Left            =   0
         TabIndex        =   4
         Top             =   420
         Width           =   960
      End
      Begin CommandButton expbtn 
         BackColor       =   &H00C0C0C0&
         Caption         =   "E&xport..."
         Height          =   360
         Left            =   0
         TabIndex        =   3
         Top             =   3120
         Width           =   960
      End
      Begin CommandButton accbtn 
         BackColor       =   &H00C0C0C0&
         Caption         =   "A&ccess..."
         Height          =   360
         Left            =   0
         TabIndex        =   2
         Top             =   2220
         Width           =   960
      End
   End
   Begin SSList adrlist 
      Prop47          =   ABKEDITD.FRX:0000
      AllowForPicture =   ABKEDITD.FRX:0037
      BorderStyle     =   1  'Fixed Single
      Case            =   0  'Unchanged
      DividerStyle    =   0  'None
      FixedHeight     =   17
      Font3D          =   0  'None
      Height          =   4275
      IntegralSize    =   0   'False
      Left            =   60
      ListStyle       =   0  '2D (BackColor used)
      MultiColumn     =   0   'False
      ReFreshOnUpdate =   -1  'True
      ScrollHorizontal=   0   'False
      ScrollVertical  =   -1  'True
      SelectionType   =   0  'Single
      ShadowColor     =   0  'Dark Grey
      Sorted          =   0   'False
      TabIndex        =   0
      Top             =   60
      Width           =   4575
      WndStyle        =   1151336785
   End
End
Option Explicit

Const DLKEYSTR = "key required="
Const DLCHGSTR = "charge="
Const DLPOSID = "editdistlist"

Dim alor As Single, alob As Single, bpor As Single
Dim mindlsh As Single, mindlsw As Single
Dim listmode As String, listtype As String
Dim listname As String, listfile As String, listkey As String
Dim listchg As Integer

Sub accbtn_Click ()
    Dim tmps As String

    On Error Resume Next
    adrlist.SetFocus
    tmps = formfunc(abkdlacc, listname & tb & listkey & tb & listchg)
    If Len(tmps) Then
        listkey = itemidx(tmps, 0)
        listchg = Val(itemidx(tmps, 1))
    End If
End Sub

Sub addbtn_Click ()
    Dim tmpstg As String

    On Error Resume Next
    adrlist.SetFocus
    tmpstg = formfunc(abkaeadr, "")
    If Len(tmpstg) Then
        addlist tmpstg
    End If
End Sub

Sub addlist (ByVal adr As String)
' add an address to the list

    adrlist.AddItem Trim$(adr)
    setadrico Trim$(adr), adrlist, adrlist.LastAdded
    adrlist.ListIndex = adrlist.LastAdded
    fixbtns
End Sub

Sub adrlist_Click ()
    fixbtns
End Sub

Sub adrlist_DblClick ()
    If listmode = "edit" Then
        editbtn_click
    End If
End Sub

Sub cancelbtn_Click ()
    Unload Me
End Sub

Sub delbtn_Click ()
    Dim idx As Integer

    On Error Resume Next
    adrlist.SetFocus
    idx = adrlist.ListIndex
    If idx < 0 Then
        Exit Sub
    End If
    remlbitem adrlist, idx
    fixbtns
End Sub

Sub editbtn_click ()
    Dim idx As Integer
    Dim tmpstg As String

    On Error Resume Next
    adrlist.SetFocus
    idx = adrlist.ListIndex
    If idx = -1 Then
        Exit Sub
    End If
    tmpstg = formfunc(abkaeadr, Trim$(adrlist.List(idx)))
    If Len(tmpstg) > 0 Then
        adrlist.List(idx) = Trim$(tmpstg)
        setadrico Trim$(tmpstg), adrlist, idx
    End If
End Sub

Sub expbtn_Click ()
    Dim i As Integer, f As Integer, ok As Integer
    Dim oar As String
    
    On Error Resume Next
    adrlist.SetFocus

    'get file name
    fdlgxchg.filename = ""
    Do
        oar = "O"
        fdlgxchg.CancelError = False
        fdlgxchg.DefaultExt = ""
        fdlgxchg.DialogTitle = "Export to Text File"
        fdlgxchg.filter = "*.*"
        fdlgxchg.flags = OFN_NOREADONLYRETURN Or OFN_HIDEFILETYPE Or OFN_SHOWHELP
        fdlgxchg.helpcontext = API_SAVE_AS
        On Error Resume Next
        filedlg fdlgsave, "impexpdlfile"
        If Err Then
            poperror "Error writing file:  " & Error$, ""
            Exit Sub
        ElseIf usrcancel Then
            Exit Sub
        End If
        protdoevt   'allow file dialog to finish unloading
        If fexist(fdlgxchg.filename, False) Then
            oar = formfunc(oarfrm, fdlgxchg.filename)
            If Len(oar) = 0 Then    'Cancel
                Exit Sub
            ElseIf oar = "R" Then
                protdoevt   'allow oarfrm to finish unloading
            End If
        End If
    Loop While oar = "R"    'Reselect

    'write out file
    screen.MousePointer = HOURGLASS
    ok = False
    On Error GoTo wrterr
    f = FreeFile
    If oar = "O" Then   'Overwrite
        Open fdlgxchg.filename For Output As f
    Else                'Append (oar = "A")
        Open fdlgxchg.filename For Append As f
        Print #f,
    End If
    For i = 0 To adrlist.ListCount - 1
        Print #f, adrlist.List(i)
    Next
    ok = True
wrterr:
    Close f
    screen.MousePointer = DEFAULT
    If Not ok Then
        poperror "Error writing file:  " & Error$, ""
    End If
    Exit Sub
End Sub

Sub fixbtns ()
    editbtn.Enabled = adrlist.ListIndex >= 0
    delbtn.Enabled = adrlist.ListIndex >= 0
End Sub

Sub Form_Load ()
    screen.MousePointer = HOURGLASS
    listmode = itemidx(formxchg, 0)
    listtype = itemidx(formxchg, 1)
    listname = itemidx(formxchg, 2)
    If listmode = "edit" Then
        Caption = "Edit List: " & listname
        If listtype = "client" Then
            accbtn.Visible = False
            impbtn.Top = accbtn.Top
            expbtn.Top = impbtn.Top + impbtn.Height + SAMEDIST
            helpbtn.Top = expbtn.Top + expbtn.Height + DIFFDIST
            butpic.Height = helpbtn.Top + helpbtn.Height
        End If
    Else
        Caption = "List: " & listname
        okbtn.Caption = "Close"
        okbtn.Cancel = True
        cancelbtn.Visible = False
        addbtn.Visible = False
        editbtn.Visible = False
        delbtn.Visible = False
        accbtn.Visible = False
        impbtn.Visible = False
        expbtn.Visible = False
        helpbtn.Top = okbtn.Top + okbtn.Height + SAMEDIST
        butpic.Height = helpbtn.Top + helpbtn.Height
    End If
    mindlsh = butpic.Height
    mindlsw = 2 * butpic.Width
    alor = calcoff(adrlist, Nothing, RIGHT2RIGHT)
    alob = calcoff(adrlist, Nothing, BOTTOM2BOTTOM)
    bpor = calcoff(butpic, Nothing, LEFT2RIGHT)
    posiload Me, DLPOSID
    If listtype = "client" Then
        loadclist
    Else
        If Not loadslist() Then
            screen.MousePointer = DEFAULT
            Unload Me
            Exit Sub
        End If
    End If
    fixbtns
    screen.MousePointer = DEFAULT
End Sub

Sub Form_Resize ()
    applymin adrlist, Nothing, RIGHT2RIGHT, alor, mindlsh, mindlsw
    applymin adrlist, Nothing, BOTTOM2BOTTOM, alob, mindlsh, mindlsw
    applymin butpic, Nothing, LEFT2RIGHT, bpor, mindlsh, mindlsw
End Sub

Sub Form_Unload (Cancel As Integer)
    posisave Me, DLPOSID, True
End Sub

Sub helpbtn_Click ()
    On Error Resume Next
    adrlist.SetFocus
    dohelp helpbtn, HELP_CONTEXT
End Sub

Sub impbtn_Click ()
    Dim f As Integer, ok As Integer
    Dim tmps As String

    On Error Resume Next
    adrlist.SetFocus
    fdlgxchg.CancelError = False
    fdlgxchg.DefaultExt = ""
    fdlgxchg.DialogTitle = "Import Text File"
    fdlgxchg.filename = ""
    tmps = "Text Files (*.txt)|*.txt"
    fdlgxchg.filter = tmps & "|All Files (*.*)|*.*"
    fdlgxchg.filterindex = 0
    fdlgxchg.flags = OFN_FILEMUSTEXIST Or OFN_SHOWHELP
    fdlgxchg.helpcontext = API_OPEN
    On Error Resume Next
    filedlg fdlgopen, "impexpdlfil"
    If Err Then
        poperror "Error reading file:  " & Error$, ""
        Exit Sub
    ElseIf usrcancel Then
        Exit Sub
    End If
    screen.MousePointer = HOURGLASS
    protdoevt   'allow file dialog to finish unloading
    adrlist.ReFreshOnUpdate = False
    ok = False
    On Error GoTo readerr
    f = FreeFile
    Open fdlgxchg.filename For Input Access Read As f
    Do
        Line Input #f, tmps
        If Len(tmps) Then
            addlist tmps
        End If
    Loop While Not EOF(f)
    ok = True
readerr:
    Close f
    screen.MousePointer = DEFAULT
    If Not ok Then
        poperror "Error importing file: " & Error$, ""
    End If
    adrlist.ReFreshOnUpdate = True
    frcupd adrlist
    Exit Sub
End Sub

Sub loadclist ()
' load up a client-side list

    Dim cnt As Integer, i As Integer
    Dim curadr As String, listdata As String

    adrlist.Clear
    listdata = sreadpkv(CDLNAM & Trim$(listname))
    cnt = itemcntd(listdata, ";") - 1
    If cnt > 0 Then
        For i = 1 To cnt
            curadr = Trim$(itemidxd(listdata, i, ";"))
            adrlist.AddItem curadr
            setadrico curadr, adrlist, adrlist.LastAdded
        Next
        If adrlist.ListCount > 0 Then
            adrlist.ListIndex = 0
        End If
    End If
End Sub

Function loadslist () As Integer
' load up a sysop-defined list

    Dim f As Integer
    Dim linedata As String

    loadslist = False
    If Not appconnect() Then
        Exit Function
    End If
    adrlist.Clear
    listfile = sreadpkv("(o=e)(d=s)" & SLINAM & Trim$(listname))
    If Len(listfile) Then
        f = FreeFile
        Open listfile For Input As f
        On Error Resume Next
        Input #f, linedata
        If Not sameto(DLKEYSTR, linedata) Then
            screen.MousePointer = DEFAULT
            poperror "Invalid list file.", ""
            Exit Function
        End If
        listkey = Trim$(Mid$(linedata, Len(DLKEYSTR) + 1))
        Input #f, linedata
        If Not sameto(DLCHGSTR, linedata) Then
            screen.MousePointer = DEFAULT
            poperror "Invalid list file.", ""
            Exit Function
        End If
        listchg = Val(Trim$(Mid$(linedata, Len(DLCHGSTR) + 1)))
        While Not EOF(f)
            Input #f, linedata
            linedata = Trim$(linedata)
            If Len(linedata) Then
                adrlist.AddItem linedata
                setadrico linedata, adrlist, adrlist.LastAdded
            End If
        Wend
        Close f
        If adrlist.ListCount > 0 Then
            adrlist.ListIndex = 0
        End If
        loadslist = True
    End If
End Function

Sub okbtn_Click ()
    screen.MousePointer = HOURGLASS
    If listtype = "client" Then
        saveclist
    Else
        If Not saveslist() Then
            screen.MousePointer = DEFAULT
            Exit Sub
        End If
    End If
    screen.MousePointer = DEFAULT
    Unload Me
End Sub

Sub saveclist ()
' save client-side list

    Dim i As Integer
    Dim savdata As String

    savdata = listname
    For i = 0 To adrlist.ListCount - 1
        savdata = savdata & ";" & Trim$(adrlist.List(i))
    Next
    junk = swrtdpkv(CDLNAM & Trim$(listname), STGLEN, Trim$(savdata))
End Sub

Function saveslist () As Integer
' save a server-side list

    Dim f As Integer, i As Integer
    Dim linedata As String

    saveslist = False
    f = FreeFile
    Open listfile For Output As f
    On Error Resume Next
    Print #f, DLKEYSTR & listkey
    Print #f, DLCHGSTR & listchg
    For i = 0 To adrlist.ListCount - 1
        Print #f, adrlist.List(i)
    Next
    Close f
    i = 0
    If Not appconnect() Then
        Exit Function
    End If
    junk = swrtdpk(SLINAM & listname, STGLEN, listfile, Len(i), i)
    Select Case evtdpk()
    Case "Write ok"
        saveslist = True
    Case "Offline write denied", "Write may be incomplete"
        'do nothing
    Case Else
        screen.MousePointer = DEFAULT
        Select Case i
        Case GMEACC
            poperror "You no longer have access to create or edit public lists.", ""
        Case GMENFND
            poperror "The " & listname & " list has been deleted.", ""
        Case GMEUSE
            poperror "Someone is currently using the " & listname & " list, so it cannot be updated right now.", ""
        Case Else
            poperror "An unknown error has occurred while sending the list to the server (error = " & i & ").", ""
        End Select
    End Select
End Function

