VERSION 2.00
Begin Form maindoor
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   1  'Fixed Single
   ClientHeight    =   3060
   ClientLeft      =   1365
   ClientTop       =   2400
   ClientWidth     =   7050
   Height          =   3465
   Icon            =   MJDMAIN.FRX:0000
   Left            =   1305
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   3060
   ScaleWidth      =   7050
   Top             =   2055
   Width           =   7170
   Begin CallBack lstcbk
      Left            =   5460
      Top             =   2520
   End
   Begin CallBack appcbk
      Left            =   5040
      Top             =   2520
   End
   Begin CommandButton Command6
      Caption         =   "&Delete"
      Height          =   360
      Left            =   5940
      TabIndex        =   7
      Top             =   2100
      Visible         =   0   'False
      Width           =   960
   End
   Begin CommandButton Command5
      Caption         =   "Help"
      Height          =   360
      HelpContextID   =   1
      Left            =   5940
      TabIndex        =   8
      Top             =   2580
      Width           =   960
   End
   Begin CommandButton Command4
      Caption         =   "&Modify..."
      Height          =   360
      Left            =   5940
      TabIndex        =   6
      Top             =   1680
      Visible         =   0   'False
      Width           =   960
   End
   Begin CommandButton Command3
      Caption         =   "&Add..."
      Height          =   360
      Left            =   5940
      TabIndex        =   5
      Top             =   1260
      Visible         =   0   'False
      Width           =   960
   End
   Begin CommandButton Command2
      Cancel          =   -1  'True
      Caption         =   "Close"
      Height          =   360
      Left            =   5940
      TabIndex        =   4
      Top             =   780
      Width           =   960
   End
   Begin CommandButton Command1
      Caption         =   "Enter"
      Default         =   -1  'True
      Height          =   360
      Left            =   5940
      TabIndex        =   3
      Top             =   360
      Width           =   960
   End
   Begin SSList SSList1
      Prop47          =   MJDMAIN.FRX:0302
      BorderStyle     =   1  'Fixed Single
      Case            =   0  'Unchanged
      DividerStyle    =   0  'None
      FixedHeight     =   13
      Font3D          =   0  'None
      Height          =   2595
      IntegralSize    =   0   'False
      Left            =   120
      ListStyle       =   0  '2D (BackColor used)
      MultiColumn     =   0   'False
      ReFreshOnUpdate =   -1  'True
      ScrollHorizontal=   0   'False
      ScrollVertical  =   -1  'True
      SelectionType   =   0  'Single
      ShadowColor     =   0  'Dark Grey
      Sorted          =   -1  'True
      TabIndex        =   2
      Top             =   360
      Width           =   5565
      WndStyle        =   1151336787
   End
   Begin Label Label2
      BackStyle       =   0  'Transparent
      Caption         =   "Description"
      Height          =   240
      Left            =   1260
      TabIndex        =   1
      Top             =   120
      Width           =   1215
   End
   Begin Label Label1
      BackStyle       =   0  'Transparent
      Caption         =   "Name"
      Height          =   240
      Left            =   180
      TabIndex        =   0
      Top             =   120
      Width           =   990
   End
End
'******************************************************************************
'*                                                                            *
'*   MJDMAIN.FRM                                                              *
'*                                                                            *
'*   Copyright (c) 1995-1997 Galacticomm, Inc.      All rights reserved.      *
'*                                                                            *
'*   This is the main .FRM for the Doors C/S Client App.                      *
'*                                                                            *
'*                                                  - Don Pitchford 11/14/95  *
'*                                                                            *
'******************************************************************************

Option Explicit

Sub appcbk_CallBack (evtstg As String, reqid As Integer)

    Dim drs As String

    Debug.Print evtstg
    Select Case evtstg
    Case "VTM session open"
        ' event received when door opens, reqid is ival(cbkrspv())
    Case "New command line"
        ' event received when second copy of Doors is executed
        drs = cbkrspv()
        freeup
        docline drs, False
    Case "Session shutdown", "Connection down"
        Unload Me
    End Select
End Sub

Sub chkenab ()
' check buttons to enable/disable

    If SSList1.ListIndex <> -1 Then
        If InStr(SSList1.List(SSList1.ListIndex), itemidx(mjdprefs, PREFOFF)) = 0 Then
            Command1.Enabled = True
        Else
            Command1.Enabled = False
        End If
        Command4.Enabled = True
        Command6.Enabled = True
    Else
        Command1.Enabled = False
        Command4.Enabled = False
        Command6.Enabled = False
    End If
End Sub

Sub Command1_Click ()
' execute door

    Dim l As String
    Dim flags As Integer, closable As Integer


    If SSList1.ListIndex <> -1 Then
        l = SSList1.List(SSList1.ListIndex)
        flags = ival(itemidx(l, 4))
        closable = (flags And MJDCAB) <> 0
        execdoor itemidx(l, 0), doorcap(itemidx(l, 1), ival(itemidx(l, 3))), closable
    End If
End Sub

Sub Command2_Click ()
' exit module

    Unload Me
End Sub

Sub Command3_Click ()

    Dim sav As Integer

    sav = SSList1.ListIndex
    SSList1.ListIndex = -1
    writeinfo
    If SSList1.ListIndex = -1 Then
        SSList1.ListIndex = sav
    End If
End Sub

Sub Command4_Click ()

    Dim doorname As String
    Dim sav As Integer
    Dim info As vbmjdapps
    Dim leave As Integer

    If SSList1.ListIndex <> -1 Then
        addormod!Label1 = "Name:"
        addormod.Caption = "Modify Door"
        sav = SSList1.ListIndex
        doorname = UCase$(itemidx(SSList1.List(sav), 0))
        addormod!Label8.Visible = True
        addormod!Text1.Visible = False
        junk = sreadpk("sa=GALMJD;u:doorinfo " & doorname, Len(info), info)
        If evtdpk() = "Dynapak received" Then
            addormod!Text1 = UCase$(itemidx(info.ndkh, MJDNAME))
            addormod!Label8 = dblamp(addormod!Text1)
            addormod!Text7 = UCase$(itemidx(info.ndkh, MJDKEYR))
            addormod!Text2 = itemidx(info.ndkh, MJDDESC)
            addormod!Text4 = Trim$(Str$(info.surchg))
            addormod!Text3 = Trim$(Str$(info.timalw))
            addormod!Text5(0) = Format$(Hex$(info.begchn), "00")
            addormod!Text5(1) = Format$(Hex$(info.endchn), "00")
            addormod!Check3D1 = ((info.flags And MJDDIS) = 0)
            addormod!Check3D2 = ((info.flags And MJDNOH) = 0)
            addormod!Check3D3 = ((info.flags And MJDCAB) <> 0)
            addormod!Check3D4 = ((info.flags And MJDXCL) <> 0)
            addormod!Command4.Enabled = False
            addormod!Command4.Tag = UCase$(itemidx(info.ndkh, MJDHSKS))
            If Not addormod!Check3D2 Then
                addormod!SSCombo1.Enabled = False
                addormod!SSCombo1.ListIndex = 0
                addormod!Command4.Enabled = False
            Else
                addormod!SSCombo1.Enabled = True
                On Error Resume Next
                addormod!SSCombo1.ListIndex = info.hskmhd - 1
                On Error GoTo 0
                If info.hskmhd = 3 Then
                    addormod!Command4.Enabled = True
                Else
                    addormod!Command4.Enabled = False
                End If
            End If
            writeinfo
        End If
        Unload addormod
    End If
End Sub

Sub Command5_Click ()
' help button

    dohelp Command5, HELP_CONTEXT
End Sub

Sub Command6_Click ()

    Dim doorname As String
    Dim sav As Integer
    Dim result As String

    If SSList1.ListIndex <> -1 Then
        doorname = itemidx(SSList1.List(SSList1.ListIndex), 0)
        If gmsgbox("OK to delete the " & doorname & " door?", MB_ICONQUESTION + MB_YESNO, "Delete a Door") = IDYES Then
            result = swrtdpkv("sa=GALMJD;u:doorinfo " & doorname, 0, "")
            If evtdpk() = "Write ok" Then
                sav = SSList1.ListIndex
                SSList1.RemoveItem SSList1.ListIndex
                If SSList1.ListCount <= sav Then
                    sav = SSList1.ListCount - 1
                End If
                SSList1.ListIndex = sav
            Else
                junk = gmsgbox(result, MB_ICONEXCLAMATION, "Delete")
            End If
        End If
    End If
End Sub

Sub docline (ByVal cl As String, ByVal endex As Integer)
' process command line options to execute doors specified on the command line
' endex: end execution if door processed

    Dim door As String
    Dim numdoors As Integer
    Dim di As vbmjdapps

    numdoors = 0
    Do
        Do
            If Len(cl) = 0 Then
                If (numdoors <> 0) And endex Then
                    unrapp
                    End
                End If
                Exit Sub
            End If
            door = itemidxd(cl, 0, " ")
            cl = Mid$(cl, Len(door) + 2)
        Loop Until Len(door) > 0
        numdoors = numdoors + 1
        If Len(door) <= VBAPPNSZ Then
            If sreadpk("sa=GALMJD;u:doorinfo " & door, Len(di), di) Then
                execdoor itemidx(di.ndkh, 0), doorcap(itemidx(di.ndkh, 1), di.surchg), (di.flags And MJDCAB) <> 0
            Else
                junk = gmsgbox("The """ & door & """ door does not exist, or you do not have access to it.", MB_ICONEXCLAMATION, "Door Not Executed")
            End If
        End If
    Loop
End Sub

Function doorcap (ByVal desc As String, ByVal surcharge As Integer) As String
' build caption

    Dim cap As String

    cap = "Doors"
    If Len(desc) <> 0 Then
        cap = cap & " - " & desc
    End If
    desc = surchstg(surcharge)
    If Len(desc) <> 0 Then
        cap = cap & "  " & desc
    End If
    doorcap = cap
End Function

Sub execdoor (ByVal door As String, ByVal cap As String, ByVal closable As Integer)
' execute door

    vtmwin "GALMJD", cap, "sa=GALMJD;u:door " & door & " ", itemidx(mjdprefs, PREFTXT), closable
End Sub

Sub Form_Load ()
' load event

    If Not regapp("GALMJD", appcbk) Then
        passcmd
        End
    End If
    If Not connect("default") Then
        unrapp
        End
    End If
    mjdprefs = sreadpkv("sa=GALMJD;u:prefs")
    If Len(mjdprefs) = 0 Then
        unrapp
        End
    End If
    bgncnc
    docline cncall(), True
    inithelp
    Caption = itemidx(mjdprefs, PREFCAP)
    If sameas(itemidx(mjdprefs, PREFSYS), "1") Then
        Command3.Visible = True
        Command4.Visible = True
        Command6.Visible = True
    End If
    posiload Me, "mjdmain"
    loadoors
End Sub

Sub Form_Unload (Cancel As Integer)
' unload event

    posisave Me, "mjdmain", False
    closehelp Me
    unrapp
    End
End Sub

Sub loadoors ()
    Dim i As Integer
    Dim j As Integer

    SSList1.Clear
    Label2.Left = Label1.Left + SSList1.TabPos(0)
    junk = rgtdpk(wtspace("sa=GALMJD;u:doorinfo "), wtspace("doorinfo "), -1, lstcbk)
    chkenab
End Sub

Sub lstcbk_CallBack (evtstg As String, reqid As Integer)

    Dim doorinfo As vbmjdapps

    If evtstg = "Dynapak received" Then
        If cbkrsp(Len(doorinfo), doorinfo) > 0 Then
            SSList1.AddItem makeline(doorinfo)
            If SSList1.ListCount = 1 Then
                SSList1.ListIndex = 0
            End If
            chkenab
        End If
    End If
End Sub

Function makeline (info As vbmjdapps) As String
' makes a listbox line ready for inclusion

    Dim l As String

    l = itemidx(info.ndkh, MJDNAME) & Chr$(9) & itemidx(info.ndkh, MJDDESC) & Chr$(9)
    If info.surchg <> 0 Then
        l = l & " " & surchstg(info.surchg)
    End If
    If (info.flags And MJDDIS) <> 0 Then ' must be last
        l = l & " " & itemidx(mjdprefs, PREFOFF)
    End If
    makeline = l & Chr$(9) & Str$(info.surchg) & Chr$(9) & Trim$(Str$(info.flags))
End Function

Sub passcmd ()
' pass off command line

    Dim lst As String, cl As String
    Dim appsrun As Integer, i As Integer

    bgncnc
    cl = cncall()
    If Len(cl) = 0 Then
        Exit Sub
    End If
    lst = applst()
    appsrun = False
    For i = 0 To MAXTASK - 1
        If sameas("GALMJD", Trim$(Mid$(lst, VBAIDSIZ * i + 1, VBAIDSIZ))) Then
            appsrun = True
            Exit For
        End If
    Next i
    If appsrun Then
        If Not regappa("GALTMPID", appcbk) Then
            Exit Sub
        End If
        junk = sndevt("GALMJD", "New command line", STGLEN, cl)
        unrapp
    End If
End Sub

Sub SSList1_Click ()

    chkenab
End Sub

Sub SSList1_DblClick ()
' enter a door

    If Command1.Enabled Then
        Command1_Click
    End If
End Sub

Function surchstg (ByVal surcharge As Integer) As String

    Dim rv As String, cs As String
    Dim i As Integer

    rv = itemidx(mjdprefs, PREFSRC)
    If surcharge > 0 Then
        cs = "+" & Trim$(Str$(surcharge))
    ElseIf surcharge < 0 Then
        cs = "-" & Trim$(Str$(-surcharge))
    Else
        surchstg = ""
        Exit Function
    End If
    i = InStr(rv, "_")
    If i = 0 Then
        surchstg = "[" & cs & " c/min]"
    Else
        surchstg = Left$(rv, i - 1) & cs & Mid$(rv, i + 1)
    End If
End Function

Sub writeinfo ()
' write contents of addormod to add/modify a door

    Dim info As vbmjdapps
    Dim result As String
    Dim leave As Integer

    leave = False
    Do
        addormod.Show 1
        If addormod.Tag <> "" Then
            On Error Resume Next
            info.ndkh = addormod!Text1 & Chr$(9) & addormod!Text2 & Chr$(9) & addormod!Text7 & Chr$(9) & addormod!Command4.Tag & Chr$(9)
            info.timalw = ival(addormod!Text3)
            info.hskmhd = addormod!SSCombo1.ListIndex + 1
            info.surchg = ival(addormod!Text4)
            info.begchn = Val("&H" + addormod!Text5(0))
            info.endchn = Val("&H" + addormod!Text5(1))
            info.flags = 0
            If Not addormod!Check3D1 Then
                info.flags = info.flags Or MJDDIS
            End If
            If Not addormod!Check3D2 Then
                info.flags = info.flags Or MJDNOH
            End If
            If addormod!Check3D3 Then
                info.flags = info.flags Or MJDCAB
            End If
            If addormod!Check3D4 Then
                info.flags = info.flags Or MJDXCL
            End If
            result = swrtdpkv("sa=GALMJD;u:doorinfo " & addormod!Text1, Len(info), info)
            If evtdpk() = "Write ok" Then
                If SSList1.ListIndex = -1 Then
                    SSList1.AddItem makeline(info)
                    SSList1.ListIndex = SSList1.LastAdded
                Else
                    SSList1.List(SSList1.ListIndex) = makeline(info)
                End If
                leave = True
            Else
                junk = gmsgbox(result, MB_ICONEXCLAMATION, addormod.Caption)
                leave = False
            End If
        Else
            leave = True
        End If
    Loop Until leave

End Sub

