VERSION 2.00
Begin Form ircmain 
   AutoRedraw      =   -1  'True
   BackColor       =   &H00C0C0C0&
   Caption         =   "Internet Relay Chat"
   ClientHeight    =   6000
   ClientLeft      =   1125
   ClientTop       =   1950
   ClientWidth     =   8820
   Height          =   6690
   HelpContextID   =   10
   Icon            =   GALIRC.FRX:0000
   Left            =   1065
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   6000
   ScaleWidth      =   8820
   Top             =   1320
   Width           =   8940
   Begin CommandButton sendbut 
      Caption         =   "Send"
      Default         =   -1  'True
      Enabled         =   0   'False
      Height          =   360
      HelpContextID   =   10
      Left            =   7800
      TabIndex        =   9
      TabStop         =   0   'False
      Top             =   5580
      Width           =   960
   End
   Begin PictureBox lclpict 
      AutoRedraw      =   -1  'True
      Height          =   612
      Left            =   40
      ScaleHeight     =   39
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   578
      TabIndex        =   8
      TabStop         =   0   'False
      Top             =   4944
      Width           =   8700
   End
   Begin CallBack maincbk 
      Left            =   3840
      Top             =   2520
   End
   Begin TextBox inpbox 
      Height          =   360
      Left            =   40
      MaxLength       =   127
      TabIndex        =   0
      Top             =   5544
      Width           =   7730
   End
   Begin SSPanel ircpanel 
      BevelInner      =   1  'Inset
      BorderWidth     =   0
      ForeColor       =   &H00000000&
      Height          =   400
      Left            =   40
      TabIndex        =   1
      Top             =   20
      Width           =   8700
      Begin TextBox chnbox 
         BackColor       =   &H00C0C0C0&
         Height          =   288
         Left            =   5040
         TabIndex        =   6
         TabStop         =   0   'False
         Top             =   54
         Width           =   1212
      End
      Begin TextBox srvbox 
         BackColor       =   &H00C0C0C0&
         Height          =   288
         Left            =   1200
         TabIndex        =   5
         TabStop         =   0   'False
         Top             =   54
         Width           =   2412
      End
      Begin Label Label2 
         BackColor       =   &H00C0C0C0&
         Caption         =   "IRC Channel:"
         ForeColor       =   &H00000000&
         Height          =   252
         Left            =   3840
         TabIndex        =   3
         Top             =   96
         Width           =   1212
      End
      Begin Label Label1 
         BackColor       =   &H00C0C0C0&
         Caption         =   "IRC Server:"
         Height          =   252
         Left            =   84
         TabIndex        =   2
         Top             =   96
         Width           =   1128
      End
   End
   Begin SSPanel msgpanel 
      AutoSize        =   3  'AutoSize Child To Panel
      BevelInner      =   1  'Inset
      BorderWidth     =   0
      ForeColor       =   &H00000000&
      Height          =   4476
      Left            =   40
      TabIndex        =   4
      Top             =   460
      Width           =   8700
      Begin PictureBox msgpict 
         AutoRedraw      =   -1  'True
         BackColor       =   &H00C0C0C0&
         BorderStyle     =   0  'None
         Height          =   4410
         Left            =   24
         ScaleHeight     =   294
         ScaleMode       =   3  'Pixel
         ScaleWidth      =   576
         TabIndex        =   7
         TabStop         =   0   'False
         Top             =   24
         Width           =   8640
      End
   End
   Begin Menu file 
      Caption         =   "&File"
      Begin Menu quitirc 
         Caption         =   "&Quit IRC Server"
      End
      Begin Menu dash 
         Caption         =   "-"
      End
      Begin Menu exit 
         Caption         =   "E&xit"
      End
   End
   Begin Menu winmenu 
      Caption         =   "&Window"
      Begin Menu wmchnlst 
         Caption         =   "&Channel List"
      End
      Begin Menu wmwholst 
         Caption         =   "&Who List"
      End
   End
   Begin Menu help 
      Caption         =   "&Help"
      Begin Menu contents 
         Caption         =   "&Contents"
      End
      Begin Menu searchelp 
         Caption         =   "&Search For Help On..."
      End
      Begin Menu about 
         Caption         =   "&About Internet Relay Chat"
      End
   End
End
'*******************************************************************************
'*                                                                             *
'*   GALIRC.FRM                                                                *
'*                                                                             *
'*   Copyright (C) 1995 Galacticomm, Inc.        All rights reserved.          *
'*                                                                             *
'*   Main form for the Internet Relay Chat client app.                         *
'*                                                                             *
'*                                                  - Scott Brinker 7/26/95    *
'*                                                                             *
'*                                                                             *
'*******************************************************************************

Option Explicit

Dim iproff As Single        ' irc panel right offset to form
Dim iptoff As Single        ' irc panel top offset to form
                            ' iptoff should be implied
Dim mproff As Single        ' msg panel right offset to form
Dim mpboff As Single        ' msg panel bottom offset to form
                            ' msgpict picture box should automatically resize
Dim lpboff As Single        ' local pict bottom offset to msg panel
Dim lproff As Single        ' local pict right offset to msg panel
Dim ibboff As Single        ' input box bottom offset to local pict
Dim ibroff As Single        ' input box right offset to local pict
Dim sbboff As Single        ' send button buttom offset to local pict
Dim sbloff As Single        ' send button left offset to local pict

Dim msgpictroff As Single   ' msgpict right offset to msg panel
Dim msgpictboff As Single   ' msgpict bottom offset to msg panel

Const mpminh = 2000         ' min height of msg panel
Const mpminw = 5000         ' min width of msg panel

Sub about_Click ()
    ircabout.Show 1
End Sub

Sub adjpanel ()
' adjust top panel in message area after resizing

    Const MINHGT = 13 ' smallest possible height (pixels) for tlccarea!toppanel

    Dim dy As Integer, savx As Integer, savy As Integer, sclbot As Integer
    Dim scrollrect As rect
    Dim pbox As PictureBox

    If (msgpanel.Height / screen.TwipsPerPixelY) > MINHGT + BBORDER * 4 Then
        applyoff msgpict, msgpanel, RIGHT2RIGHT Or ISPARENT, msgpictroff
        applyoff msgpict, msgpanel, BOTTOM2BOTTOM Or ISPARENT, msgpictboff
        Set pbox = msgpict
        If pbox.CurrentX > 0 Then
            sclbot = pbox.CurrentY + pbox.TextHeight("")
        Else
            sclbot = pbox.CurrentY
        End If
        If sclbot > pbox.ScaleHeight - BBORDER Then
            scrollrect.Top = BBORDER
            scrollrect.Left = LBORDER
            scrollrect.bottom = sclbot
            scrollrect.right = msgpict.ScaleWidth - LBORDER
            dy = sclbot - (pbox.ScaleHeight - BBORDER)
            junk = ScrollDC(pbox.hDC, 0, -dy, scrollrect, scrollrect, 0, 0)
            pbox.CurrentY = pbox.CurrentY - dy
            savx = pbox.CurrentX
            savy = pbox.CurrentY
            msgpict.Line (0, pbox.ScaleHeight - BBORDER)-(msgpict.ScaleWidth, sclbot), pbox.BackColor, BF
            pbox.CurrentX = savx
            pbox.CurrentY = savy
        End If
    End If
End Sub

Sub contents_Click ()
    dohelp contents, HELP_CONTENTS
End Sub

Sub exit_Click ()
    Unload Me
End Sub

Sub Form_Load ()
    If Not regapp("GALIRC", maincbk) Then
        End
    End If
    inithelp
    modsysmnu Me, MOVMINCLS
    iproff = calcoff(ircpanel, Nothing, RIGHT2RIGHT)
    iptoff = calcoff(ircpanel, Nothing, TOP2TOP)
    mproff = calcoff(msgpanel, Nothing, RIGHT2RIGHT)
    mpboff = calcoff(msgpanel, Nothing, BOTTOM2BOTTOM)
    lpboff = calcoff(lclpict, Nothing, TOP2BOTTOM)
    lproff = calcoff(lclpict, Nothing, RIGHT2RIGHT)
    msgpictroff = calcoff(msgpict, msgpanel, RIGHT2RIGHT Or ISPARENT)
    msgpictboff = calcoff(msgpict, msgpanel, BOTTOM2BOTTOM Or ISPARENT)
    ibboff = calcoff(inpbox, Nothing, TOP2BOTTOM)
    ibroff = calcoff(inpbox, Nothing, RIGHT2RIGHT)
    sbboff = calcoff(sendbut, Nothing, TOP2BOTTOM)
    sbloff = calcoff(sendbut, Nothing, LEFT2RIGHT)
    posiload Me, "ircmain"
    If Not connect("default") Then
        unrapp
        End
    End If
    supdcb = False
    whodun = True
    initcolors
    Show
    Load irccfgf
End Sub

Sub Form_Resize ()
    applyoff ircpanel, Nothing, RIGHT2RIGHT, iproff
    applyoff ircpanel, Nothing, TOP2TOP, iptoff
    applymin msgpanel, Nothing, RIGHT2RIGHT, mproff, mpminh, mpminw
    applymin msgpanel, Nothing, BOTTOM2BOTTOM, mpboff, mpminh, mpminw
    applyoff lclpict, Nothing, TOP2BOTTOM, lpboff
    applyoff lclpict, Nothing, RIGHT2RIGHT, lproff
    applyoff inpbox, Nothing, TOP2BOTTOM, ibboff
    applyoff inpbox, Nothing, RIGHT2RIGHT, ibroff
    applyoff sendbut, Nothing, TOP2BOTTOM, sbboff
    applyoff sendbut, Nothing, LEFT2RIGHT, sbloff
    adjpanel
End Sub

Sub Form_Unload (Cancel As Integer)
    junk = swrtdpkv("sau:exit", STGLEN, "bye")
    posisave Me, "ircmain", True
    unrapp
    closehelp Me
    End
End Sub

Sub initcolors ()
    ircolor(PUBNIC) = &H0&          ' black
    ircolor(PUBTXT) = &H0&
    ircolor(PRVNIC) = &HC00000      ' blue
    ircolor(PRVTXT) = &HC00000
    ircolor(ACTNIC) = &H800080      ' purple
    ircolor(ACTTXT) = &H800080
    ircolor(EOLNIC) = &H80&         ' red
    ircolor(EOLTXT) = &H80&
    ircolor(GENTXT) = &H0&          ' black
End Sub

Sub inpbox_Change ()
    sendbut.Enabled = inpbox <> ""
End Sub

Sub maincbk_CallBack (evtstg As String, reqid As Integer)
    Dim valstg As String, dpknam As String, lstnic As String, lsthst As String
    Dim lstopc As String, lststg As String, r2wstg As String

    Select Case evtstg
    Case "Unsolicited dynapak received"
        dpknam = namdpk()
        Select Case dpknam
        Case "sau:pubmsg", "sau:privmsg", "sau:onpubact", "sau:onprvact", "sau:onnotic", "sau:join", "sau:onquit", "sau:part", "sau:onname", "sau:defnum", "sau:ukick", "sau:onkick", "sau:ontopic", "sau:oninvit", "sau:onnick", "sau:cmode", "sau:on341"
            valstg = cbkrspv()
            hdlirc dpknam, valstg, ircmain.msgpict
        Case "sau:umode"
            valstg = cbkrspv()
            freeup
            junk = gmsgbox(itemidx(valstg, 0) & " has changed your user mode to: " & itemidx(valstg, 1), MB_ICONINFORMATION, "Change of Mode")
        Case "sau:anickuse"
            freeup
            junk = gmsgbox("Sorry, that nickname is already in use.", MB_ICONEXCLAMATION, "Nick in Use")
        Case "sau:bglist"
            irchnlst.Show
            irchnlst!chnlst.Clear
            irchnlst!Command2.Enabled = False
            wmchnlst.Checked = True
            irchnlst!chnlst.AddItem "(Waiting...)"
        Case "sau:onlist"
            If irchnlst.Visible Then
                If irchnlst!chnlst.List(0) = "(Waiting...)" Then
                    irchnlst!chnlst.RemoveItem 0
                End If
                valstg = cbkrspv()
                lstchn = itemidx(valstg, 0)
                lstuct = itemidx(valstg, 1)
                lstopc = itemidx(valstg, 2)
                If lstchn <> "" And lstuct <> "" Then
                    lststg = lstchn & Chr$(9) & lstuct & Chr$(9) & lstopc
                    irchnlst!chnlst.AddItem lststg
                    irchnlst!Command2.Enabled = True
                    If irchnlst!chnlst.ListIndex = -1 Then
                        irchnlst!chnlst.ListIndex = 0
                    End If
                End If
            End If
        Case "sau:whoreply"
            If whodun = True Then
                ircwhlst.Show
                ircwhlst!wholst.Clear
                whodun = False
                wmwholst.Checked = True
            End If
            If ircwhlst.Visible Then
                valstg = cbkrspv()
                lstchn = itemidx(valstg, 0)
                lstnic = itemidx(valstg, 1)
                lsthst = itemidx(valstg, 2)
                lstopc = itemidx(valstg, 3)
                If lstchn <> "" And lstnic <> "" Then
                    lststg = lstchn & Chr$(9) & lstnic & Chr$(9) & lsthst
                    lststg = lststg & Chr$(9) & lstopc
                    ircwhlst!wholst.AddItem lststg
                    If ircwhlst!wholst.ListIndex = -1 Then
                        ircwhlst!wholst.ListIndex = 0
                    End If
                End If
            End If
        Case "sau:endwho"
            whodun = True
        Case "sau:whoisusr"
            valstg = cbkrspv()
            ircwhois!whinick = itemidx(valstg, 0)
            ircwhois!whihost = itemidx(valstg, 1) & "@" & itemidx(valstg, 2)
            ircwhois!whidesc = itemidx(valstg, 3)
            ircwhois.Show
        Case "sau:whoischn"
            valstg = cbkrspv()
            ircwhois!whichan = itemidx(valstg, 0)
            ircwhois.Refresh
        Case "sau:whoiserv"
            valstg = cbkrspv()
            ircwhois!whiprov = itemidx(valstg, 1)
            ircwhois!whiploc = itemidx(valstg, 2)
            ircwhois.Refresh
        Case "sau:fingrply"
            valstg = cbkrspv()
            ircfingf.Caption = "Reply from Finger: " & itemidx(valstg, 0)
            ircfingf!fingbox = itemidx(valstg, 1)
            ircfingf.Show
        Case "sau:immerr"
            valstg = cbkrspv()
            supdcb = True
            freeup
            junk = gmsgbox("Can't connect to " & itemidx(valstg, 0) & ": " & itemidx(valstg, 1), MB_ICONEXCLAMATION, "Connection Failed")
            irccfgf.Show 1
            ' IRCEXIT will automatically handle from here
            supdcb = False
        Case "sau:condrop"
            valstg = cbkrspv()
            supdcb = True
            freeup
            junk = gmsgbox("Disconnected. Error #" & itemidx(valstg, 0) & ": " & itemidx(valstg, 1), MB_ICONEXCLAMATION, "Connection Dropped")
            irccfgf.Show 1
            ' IRCEXIT will automatically handle from here
            supdcb = False
        Case "sau:nocreds"
            valstg = cbkrspv()
            supdcb = True
            freeup
            junk = gmsgbox(itemidx(valstg, 0), MB_ICONEXCLAMATION, "Not Enough Credits")
            irccfgf.Show 1
            supdcb = False
        Case "sau:rocreds"
            valstg = cbkrspv()
            supdcb = True
            freeup
            junk = gmsgbox(itemidx(valstg, 0), MB_ICONEXCLAMATION, "Connection Dropped")
            irccfgf.Show 1
            supdcb = False
        Case "sau:condead"
            valstg = cbkrspv()
            supdcb = True
            freeup
            junk = gmsgbox("Error with IRC server. Disconnecting..." & Chr$(13) & itemidx(valstg, 0), MB_ICONEXCLAMATION, "Connection Dropped")
            irccfgf.Show 1
            ' IRCEXIT will automatically handle from here
            supdcb = False
        Case "sau:nnickuse"
            supdcb = True
            freeup
            junk = gmsgbox("Sorry, your nickname is already in use." & Chr$(13) & "Please choose a different one.", MB_ICONEXCLAMATION, "Connection Dropped")
            irccfgf.Show 1
            ' IRCEXIT will automatically handle from here
            supdcb = False
        End Select
        If ircmain!srvbox = "" Then  ' this should be do'able from irccfgf
            ircmain!srvbox = Trim$(serv)
        End If
    Case "Write ok"
        dpknam = namdpk()
        Select Case dpknam
        Case "sau:irc"
            ' parse response, handle it
        Case "sau:irccfg", "sau:irccfgw"
            freeup
            ircwhlst.Hide
            irchnlst.Hide
            ircfingf.Hide
            ircwhois.Hide
            If supdcb = False Then
                junk = gmsgbox("Disconnected from IRC server.", MB_ICONINFORMATION, "Disconnect")
            End If
            whodun = True
            ircmain!srvbox = ""
            ircmain!chnbox = ""
            ircmain!wmwholst.Enabled = False
            If supdcb = False Then
                irccfgf.Show 1
            End If
        End Select
    Case "Write denied"
        dpknam = namdpk()
        If dpknam = "sau:irc" Then
            valstg = cbkrspv()
            r2wstg = itemidx(valstg, 0)
            freeup
            Select Case r2wstg
            Case "nocmd"
                junk = gmsgbox("Sorry, that is not a valid IRC command.", MB_ICONINFORMATION, "Invalid Command")
            ' no such command (itemidx)
            Case "nochan"
                junk = gmsgbox("Sorry, you must /join an IRC channel to do that.", MB_ICONINFORMATION, "Not on a Channel")
            ' you're not on a channel yet
            End Select
        End If
    Case "Connection down"
        freeup
        junk = gmsgbox("You have disconnected from the server. Closing IRC...", MB_ICONEXCLAMATION, "IRC Shutdown")
        Unload Me
    Case "Session shutdown"
        freeup
        Unload Me
    End Select
End Sub

Sub prtlcl (ByVal stg As String)
' print text on local message picture box
' stg: line to print

    Dim scalehgt As Integer, scalewid As Integer
    Dim texthgt As Integer
    Dim scrollrect As rect
    Dim slash As String

    scalehgt = lclpict.ScaleHeight
    scalewid = lclpict.ScaleWidth
    texthgt = lclpict.TextHeight("Wj")
    scrollrect.Top = 2
    scrollrect.Left = 0
    scrollrect.bottom = scalehgt - 2
    scrollrect.right = scalewid
    junk = ScrollDC(lclpict.hDC, 0, -texthgt, scrollrect, scrollrect, 0, 0)
    lclpict.Line (0, scalehgt - texthgt)-(scalewid, scalehgt), lclpict.BackColor, BF
    lclpict.CurrentX = 2
    lclpict.CurrentY = scalehgt - texthgt - 2
    lclpict.Print stg
    slash = Left$(Trim$(stg), 1)
    If slash <> "/" And chnbox <> "" Then
        hdlirc "local", stg, ircmain!msgpict
    ElseIf Len(Trim$(stg)) > 4 And UCase$(Mid$(stg, 2, 3)) = "ME " Then
        hdlirc "locact", Trim$(Mid$(stg, 4, Len(Trim$(stg)) - 3)), ircmain!msgpict
    End If
End Sub

Sub quitirc_Click ()
    ircwhlst.Hide
    irchnlst.Hide
    ircfingf.Hide
    ircwhois.Hide
    junk = wrtdpk("sau:irc", STGLEN, "/quit", ircmain!maincbk)
End Sub

Sub searchelp_Click ()
    dohelp searchelp, HELP_PARTIALKEY
End Sub

Sub sendbut_Click ()
    Dim chkstg As String

    chkstg = LCase$(Trim$(inpbox))
    If qroom("normal") Then
        If UCase$(Left$(Trim$(inpbox), 5)) = "/JOIN" Then
            If banchan(Mid$(inpbox, 5, Len(inpbox) - 4)) Then
                junk = gmsgbox("Sorry, that channel is banned on this system.", MB_ICONSTOP, "Cannot Join Channel")
                inpbox = ""
                Exit Sub
            End If
        ElseIf UCase$(Left$(Trim$(inpbox), 4)) = "/WHO" Then
            whocmd = inpbox
        ElseIf UCase$(Left$(Trim$(inpbox), 5)) = "/LIST" Then
            lstcmd = inpbox
        ElseIf UCase$(Left$(Trim$(inpbox), 5)) = "/HELP" Then
            dohelp sendbut, HELP_CONTEXT
        End If
        junk = wrtdpk("sau:irc", STGLEN, CStr(inpbox), ircmain!maincbk)
        prtlcl inpbox
        inpbox = ""
    End If
End Sub

Sub wmchnlst_Click ()
    If irchnlst.Visible = False Then
        lstcmd = "/list"
        junk = wrtdpk("sau:irc", STGLEN, "/list", ircmain!maincbk)
    Else
        irchnlst.Show
    End If
End Sub

Sub wmwholst_Click ()
    If ircwhlst.Visible = False Then
        whocmd = "/who"
        junk = wrtdpk("sau:irc", STGLEN, "/who", ircmain!maincbk)
    Else
        ircwhlst.Show
    End If
End Sub

